################################################################################
# cspyce/cspyce0_info.py
#
# A dictionary of docstrings and call signatures, keyed by the name of the
# CSPICE function name.
#
# This file is automatically generated by program make_cspyce_info.py. Do not
# modify. To regenerate:
#     python make_cspyce0_info.py
################################################################################

CSPYCE_ARGNAMES    = {}
CSPYCE_RETNAMES    = {}
CSPYCE_ABSTRACT    = {}
CSPYCE_DEFINITIONS = {}
CSPYCE_URL         = {}
CSPYCE_PS          = {}
CSPYCE_DEFAULTS    = {}

#########################################
CSPYCE_ARGNAMES["axisar"] = ["axis", "angle"]
CSPYCE_RETNAMES["axisar"] = ["rotmat"]
CSPYCE_ABSTRACT["axisar"] = """
Construct a rotation matrix that rotates vectors by a specified angle
about a specified axis.
"""
CSPYCE_DEFINITIONS["axisar"] = {
'axis'  : ("float[3]", "Rotation axis."),
'angle' : ("float", "Rotation angle, in radians."),
'rotmat': ("float[3,3]", "Rotation matrix corresponding to axis and angle."),
}
CSPYCE_URL["axisar"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/axisar_c.html"
#########################################
CSPYCE_ARGNAMES["b1900"] = []
CSPYCE_RETNAMES["b1900"] = ["jd"]
CSPYCE_ABSTRACT["b1900"] = """
Return the Julian Date corresponding to Besselian Date 1900.0.
"""
CSPYCE_DEFINITIONS["b1900"] = {
'jd'    : ("float", "JD of Besselian Date 1900.0"),
}
CSPYCE_URL["b1900"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/b1900_c.html"
#########################################
CSPYCE_ARGNAMES["b1950"] = []
CSPYCE_RETNAMES["b1950"] = ["jd"]
CSPYCE_ABSTRACT["b1950"] = """
Return the Julian Date corresponding to Besselian Date 1950.0.
"""
CSPYCE_DEFINITIONS["b1950"] = {
'jd'    : ("float", "JD of Besselian Date 1950.0."),
}
CSPYCE_URL["b1950"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/b1950_c.html"
#########################################
CSPYCE_ARGNAMES["bltfrm"] = ["frmcls"]
CSPYCE_RETNAMES["bltfrm"] = ["ids"]
CSPYCE_ABSTRACT["bltfrm"] = """
Return an array containing the frame IDs of all built-in frames of a
specified class.
"""
CSPYCE_DEFINITIONS["bltfrm"] = {
'frmcls': ("int", "Frame class (-1 = all; 1 = built-in inertial; 2 = PCK-based; 3 = CK-based; 4 = fixed rotational; 5 = dynamic)."),
'ids'   : ("frame_code[*]", "Array of ID codes of frames of the specified class."),
}
CSPYCE_URL["bltfrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bltfrm_c.html"
#########################################
CSPYCE_ARGNAMES["bodc2n"] = ["code"]
CSPYCE_RETNAMES["bodc2n"] = ["name", "found"]
CSPYCE_ABSTRACT["bodc2n"] = """
Translate the SPICE integer code of a body into a common name for that
body.
"""
CSPYCE_DEFINITIONS["bodc2n"] = {
'code'  : ("body_code", "Integer ID code to be translated into a name."),
'name'  : ("body_name", "A common name for the body identified by code."),
'found' : ("bool", "True if translated, otherwise False."),
}
CSPYCE_URL["bodc2n"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodc2n_c.html"
#########################################
CSPYCE_ARGNAMES["bodc2s"] = ["code"]
CSPYCE_RETNAMES["bodc2s"] = ["name"]
CSPYCE_ABSTRACT["bodc2s"] = """
Translate a body ID code to either the corresponding name or if no name
to ID code mapping exists, the string representation of the body ID
value.
"""
CSPYCE_DEFINITIONS["bodc2s"] = {
'code'  : ("body_code", "Integer ID code to translate to a string."),
'name'  : ("body_name", "String corresponding to 'code'."),
}
CSPYCE_URL["bodc2s"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodc2s_c.html"
#########################################
CSPYCE_ARGNAMES["boddef"] = ["name", "code"]
CSPYCE_RETNAMES["boddef"] = []
CSPYCE_ABSTRACT["boddef"] = """
Define a body name/ID code pair for later translation via bodn2c or
bodc2n.
"""
CSPYCE_DEFINITIONS["boddef"] = {
'name'  : ("body_name", "Common name of some body."),
'code'  : ("body_code", "Integer code for that body."),
}
CSPYCE_URL["boddef"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/boddef_c.html"
#########################################
CSPYCE_ARGNAMES["bodfnd"] = ["body", "item"]
CSPYCE_RETNAMES["bodfnd"] = ["found"]
CSPYCE_ABSTRACT["bodfnd"] = """
Determine whether values exist for some item for any body in the kernel
pool.
"""
CSPYCE_DEFINITIONS["bodfnd"] = {
'body'  : ("body_code", "ID code of body."),
'item'  : ("string", "Item to find (\"RADII\", \"NUT_AMP_RA\", etc.)."),
'found' : ("bool", "True if the item is in the kernel pool; False if it is not."),
}
CSPYCE_URL["bodfnd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodfnd_c.html"
#########################################
CSPYCE_ARGNAMES["bodn2c"] = ["name"]
CSPYCE_RETNAMES["bodn2c"] = ["code", "found"]
CSPYCE_ABSTRACT["bodn2c"] = """
Translate the name of a body or object to the corresponding SPICE
integer ID code.
"""
CSPYCE_DEFINITIONS["bodn2c"] = {
'name'  : ("body_name", "Body name to be translated into a SPICE ID code."),
'code'  : ("body_code", "SPICE integer ID code for the named body."),
'found' : ("bool", "True if translated, otherwise False."),
}
CSPYCE_URL["bodn2c"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodn2c_c.html"
#########################################
CSPYCE_ARGNAMES["bods2c"] = ["name"]
CSPYCE_RETNAMES["bods2c"] = ["code", "found"]
CSPYCE_ABSTRACT["bods2c"] = """
Translate a string containing a body name or ID code to an integer code.
"""
CSPYCE_DEFINITIONS["bods2c"] = {
'name'  : ("body_name", "String to be translated to an ID code."),
'code'  : ("body_code", "Integer ID code corresponding to `name'."),
'found' : ("bool", "Flag indicating whether translation succeeded."),
}
CSPYCE_URL["bods2c"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bods2c_c.html"
#########################################
CSPYCE_ARGNAMES["bodvar"] = ["body", "item"]
CSPYCE_RETNAMES["bodvar"] = ["values"]
CSPYCE_ABSTRACT["bodvar"] = """
Deprecated: This routine has been superseded by bodvcd and bodvrd. This
routine is supported for purposes of backward compatibility only.

Return the values of some item for any body in the kernel pool.
"""
CSPYCE_DEFINITIONS["bodvar"] = {
'body'  : ("body_code", "ID code of body."),
'item'  : ("string", "Item for which values are desired. (\"RADII\", \"NUT_PREC_ANGLES\", etc.)."),
'values': ("float[*]", "Array of values."),
}
CSPYCE_URL["bodvar"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodvar_c.html"
#########################################
CSPYCE_ARGNAMES["bodvcd"] = ["bodyid", "item"]
CSPYCE_RETNAMES["bodvcd"] = ["values"]
CSPYCE_ABSTRACT["bodvcd"] = """
Fetch from the kernel pool the floating-point values of an item
associated with a body, where the body is specified by an integer ID
code.
"""
CSPYCE_DEFINITIONS["bodvcd"] = {
'bodyid': ("body_code", "Body ID code."),
'item'  : ("string", "Item for which values are desired. (\"RADII\", \"NUT_PREC_ANGLES\", etc.)."),
'values': ("float[*]", "Array of values."),
}
CSPYCE_URL["bodvcd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodvcd_c.html"
#########################################
CSPYCE_ARGNAMES["bodvrd"] = ["bodynm", "item"]
CSPYCE_RETNAMES["bodvrd"] = ["values"]
CSPYCE_ABSTRACT["bodvrd"] = """
Fetch from the kernel pool the floating-point values of an item
associated with a body.
"""
CSPYCE_DEFINITIONS["bodvrd"] = {
'bodynm': ("body_name", "Body name."),
'item'  : ("string", "Item for which values are desired. (\"RADII\", \"NUT_PREC_ANGLES\", etc.)."),
'values': ("float[*]", "Array of values."),
}
CSPYCE_URL["bodvrd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bodvrd_c.html"
#########################################
CSPYCE_ARGNAMES["ccifrm"] = ["frclss", "clssid"]
CSPYCE_RETNAMES["ccifrm"] = ["frcode", "frname", "center", "found"]
CSPYCE_ABSTRACT["ccifrm"] = """
Return the frame name, frame ID, and center associated with a given
frame class and class ID.
"""
CSPYCE_DEFINITIONS["ccifrm"] = {
'frclss': ("int", "Class of frame."),
'clssid': ("int", "Class ID of frame."),
'frcode': ("frame_code", "ID code of the frame."),
'frname': ("frame_name", "Name of the frame."),
'center': ("body_code", "ID code of the center of the frame."),
'found' : ("bool", "True if the requested information is available."),
}
CSPYCE_URL["ccifrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ccifrm_c.html"
#########################################
CSPYCE_ARGNAMES["cgv2el"] = ["center", "vec1", "vec2"]
CSPYCE_RETNAMES["cgv2el"] = ["ellipse"]
CSPYCE_ABSTRACT["cgv2el"] = """
Form a CSPICE ellipse from a center vector and two generating vectors.
"""
CSPYCE_DEFINITIONS["cgv2el"] = {
'center': ("float[3]", "Center of an ellipse."),
'vec1'  : ("float[3]", "First of two generating vectors for an ellipse."),
'vec2'  : ("float[3]", "Second of two generating vectors for an ellipse."),
'ellipse': ("float[9]", "The CSPICE ellipse defined by the input vectors."),
}
CSPYCE_URL["cgv2el"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cgv2el_c.html"
#########################################
CSPYCE_ARGNAMES["chkin"] = ["module"]
CSPYCE_RETNAMES["chkin"] = []
CSPYCE_ABSTRACT["chkin"] = """
Inform the CSPICE error handling mechanism of entry into a routine.
"""
CSPYCE_DEFINITIONS["chkin"] = {
'module': ("string", "The name of the calling routine."),
}
CSPYCE_URL["chkin"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/chkin_c.html"
#########################################
CSPYCE_ARGNAMES["chkout"] = ["module"]
CSPYCE_RETNAMES["chkout"] = []
CSPYCE_ABSTRACT["chkout"] = """
Inform the CSPICE error handling mechanism of exit from a routine.
"""
CSPYCE_DEFINITIONS["chkout"] = {
'module': ("string", "The name of the calling routine."),
}
CSPYCE_URL["chkout"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/chkout_c.html"
#########################################
CSPYCE_ARGNAMES["cidfrm"] = ["cent"]
CSPYCE_RETNAMES["cidfrm"] = ["frcode", "frname", "found"]
CSPYCE_ABSTRACT["cidfrm"] = """
Retrieve frame ID code and name to associate with a frame center.
"""
CSPYCE_DEFINITIONS["cidfrm"] = {
'cent'  : ("body_code", "An object ID to associate a frame with."),
'frcode': ("frame_code", "The ID code of the frame associated with cent."),
'frname': ("frame_name", "The name of the frame with ID frcode."),
'found' : ("bool", "True if the requested information is available."),
}
CSPYCE_PS["cidfrm"] = 'Raise SPICE(CKINSUFFDATA) condition if the requested information is unavailable.'
CSPYCE_URL["cidfrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cidfrm_c.html"
#########################################
CSPYCE_ARGNAMES["ckcov"] = ["ck", "idcode", "needav", "level", "tol", "timsys"]
CSPYCE_RETNAMES["ckcov"] = ["cover"]
CSPYCE_ABSTRACT["ckcov"] = """
Find the coverage window for a specified object in a specified CK file.
"""
CSPYCE_DEFINITIONS["ckcov"] = {
'ck'    : ("string", "Name of CK file."),
'idcode': ("body_code", "ID code of object."),
'needav': ("bool", "Flag indicating whether angular velocity is needed."),
'level' : ("string", "Coverage level: \"SEGMENT\" OR \"INTERVAL\"."),
'tol'   : ("float", "Tolerance in ticks."),
'timsys': ("string", "Time system used to represent coverage."),
'cover' : ("time[*,2]", "Array giving start/stop time pairs for the intervals covered."),
}
CSPYCE_URL["ckcov"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckcov_c.html"
#########################################
CSPYCE_ARGNAMES["ckgp"] = ["inst", "sclkdp", "tol", "ref"]
CSPYCE_RETNAMES["ckgp"] = ["cmat", "clkout", "found"]
CSPYCE_ABSTRACT["ckgp"] = """
Get pointing (attitude) for a specified spacecraft clock time.
"""
CSPYCE_DEFINITIONS["ckgp"] = {
'inst'  : ("int", "NAIF ID of instrument, spacecraft, or structure."),
'sclkdp': ("float", "Encoded spacecraft clock time."),
'tol'   : ("float", "Time tolerance."),
'ref'   : ("frame_name", "Reference frame."),
'cmat'  : ("float[3,3]", "C-matrix pointing data."),
'clkout': ("float", "Output encoded spacecraft clock time."),
'found' : ("bool", "True when requested pointing is available."),
}
CSPYCE_URL["ckgp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckgp_c.html"
#########################################
CSPYCE_ARGNAMES["ckgpav"] = ["inst", "sclkdp", "tol", "ref"]
CSPYCE_RETNAMES["ckgpav"] = ["cmat", "av", "clkout", "found"]
CSPYCE_ABSTRACT["ckgpav"] = """
Get pointing (attitude) and angular velocity for a specified spacecraft
clock time.
"""
CSPYCE_DEFINITIONS["ckgpav"] = {
'inst'  : ("int", "NAIF ID of instrument, spacecraft, or structure."),
'sclkdp': ("float", "Encoded spacecraft clock time."),
'tol'   : ("float", "Time tolerance."),
'ref'   : ("frame_name", "Reference frame."),
'cmat'  : ("float[3,3]", "C-matrix pointing data."),
'av'    : ("float[3]", "Angular velocity vector."),
'clkout': ("float", "Output encoded spacecraft clock time."),
'found' : ("bool", "True when requested pointing is available."),
}
CSPYCE_URL["ckgpav"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckgpav_c.html"
#########################################
CSPYCE_ARGNAMES["ckobj"] = ["ck"]
CSPYCE_RETNAMES["ckobj"] = ["bodids"]
CSPYCE_ABSTRACT["ckobj"] = """
Find the set of ID codes of all objects in a specified CK file.
"""
CSPYCE_DEFINITIONS["ckobj"] = {
'ck'    : ("string", "Name of CK file."),
'bodids': ("body_code[*]", "Array of ID codes of objects in CK file."),
}
CSPYCE_URL["ckobj"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckobj_c.html"
#########################################
CSPYCE_ARGNAMES["clight"] = []
CSPYCE_RETNAMES["clight"] = ["c"]
CSPYCE_ABSTRACT["clight"] = """
Return the speed of light in a vacuum (IAU official value, in km/sec).
"""
CSPYCE_DEFINITIONS["clight"] = {
'c'     : ("float", "The speed of light in vacuo (km/sec)."),
}
CSPYCE_URL["clight"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/clight_c.html"
#########################################
CSPYCE_ARGNAMES["clpool"] = []
CSPYCE_RETNAMES["clpool"] = []
CSPYCE_ABSTRACT["clpool"] = """
Remove all variables from the kernel pool.
"""
CSPYCE_DEFINITIONS["clpool"] = {
}
CSPYCE_URL["clpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/clpool_c.html"
#########################################
CSPYCE_ARGNAMES["cnmfrm"] = ["cname"]
CSPYCE_RETNAMES["cnmfrm"] = ["frcode", "frname", "found"]
CSPYCE_ABSTRACT["cnmfrm"] = """
Retrieve frame ID code and name to associate with an object.
"""
CSPYCE_DEFINITIONS["cnmfrm"] = {
'cname' : ("body_name", "Name of the object to find a frame for."),
'frcode': ("frame_code", "The ID code of the frame associated with cname."),
'frname': ("frame_name", "The name of the frame with ID frcode."),
'found' : ("bool", "True if the requested information is available."),
}
CSPYCE_URL["cnmfrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cnmfrm_c.html"
#########################################
CSPYCE_ARGNAMES["conics"] = ["elts", "et"]
CSPYCE_RETNAMES["conics"] = ["state"]
CSPYCE_ABSTRACT["conics"] = """
Determine the state (position, velocity) of an orbiting body from a set
of elliptic, hyperbolic, or parabolic orbital elements.
"""
CSPYCE_DEFINITIONS["conics"] = {
'elts'  : ("float[8]", "Conic elements."),
'et'    : ("time", "Input time."),
'state' : ("float[6]", "State of orbiting body at et."),
}
CSPYCE_URL["conics"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/conics_c.html"
#########################################
CSPYCE_ARGNAMES["convrt"] = ["x", "in", "out"]
CSPYCE_RETNAMES["convrt"] = ["y"]
CSPYCE_ABSTRACT["convrt"] = """
Take a measurement X, the units associated with X, and units to which X
should be converted; return Y, the value of the measurement in the
output units.
"""
CSPYCE_DEFINITIONS["convrt"] = {
'x'     : ("float", "Number representing a measurement in some units."),
'in'    : ("string", "The units in which x is measured."),
'out'   : ("string", "Desired units for the measurement."),
'y'     : ("float", "The measurment in the desired units."),
}
CSPYCE_URL["convrt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/convrt_c.html"
#########################################
CSPYCE_ARGNAMES["cyllat"] = ["r", "lonc", "z"]
CSPYCE_RETNAMES["cyllat"] = ["radius", "lon", "lat"]
CSPYCE_ABSTRACT["cyllat"] = """
Convert from cylindrical to latitudinal coordinates.
"""
CSPYCE_DEFINITIONS["cyllat"] = {
'r'     : ("float", "Distance of point from z axis."),
'lonc'  : ("float", "Cylindrical angle of point from XZ plane (radians)."),
'z'     : ("float", "Height of point above XY plane."),
'radius': ("float", "Distance of point from origin."),
'lon'   : ("float", "Longitude of point (radians)."),
'lat'   : ("float", "Latitude of point (radians)."),
}
CSPYCE_URL["cyllat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cyllat_c.html"
#########################################
CSPYCE_ARGNAMES["cylrec"] = ["r", "lon", "z"]
CSPYCE_RETNAMES["cylrec"] = ["rectan"]
CSPYCE_ABSTRACT["cylrec"] = """
Convert from cylindrical to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["cylrec"] = {
'r'     : ("float", "Distance of a point from z axis."),
'lon'   : ("float", "Angle (radians) of a point from XZ plane."),
'z'     : ("float", "Height of a point above XY plane."),
'rectan': ("float[3]", "Rectangular coordinates of the point."),
}
CSPYCE_URL["cylrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cylrec_c.html"
#########################################
CSPYCE_ARGNAMES["cylsph"] = ["r", "lonc", "z"]
CSPYCE_RETNAMES["cylsph"] = ["radius", "colat", "lon"]
CSPYCE_ABSTRACT["cylsph"] = """
Convert from cylindrical to spherical coordinates.
"""
CSPYCE_DEFINITIONS["cylsph"] = {
'r'     : ("float", "Distance of point from z axis."),
'lonc'  : ("float", "Angle (radians) of point from XZ plane."),
'z'     : ("float", "Height of point above XY plane."),
'radius': ("float", "Distance of point from origin."),
'colat' : ("float", "Polar angle (co-latitude in radians) of point."),
'lon'   : ("float", "Azimuthal angle (longitude) of point (radians)."),
}
CSPYCE_URL["cylsph"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cylsph_c.html"
#########################################
CSPYCE_ARGNAMES["dafbfs"] = ["handle"]
CSPYCE_RETNAMES["dafbfs"] = []
CSPYCE_ABSTRACT["dafbfs"] = """
Begin a forward search for arrays in a DAF.
"""
CSPYCE_DEFINITIONS["dafbfs"] = {
'handle': ("int", "Handle of file to be searched."),
}
CSPYCE_URL["dafbfs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafbfs_c.html"
#########################################
CSPYCE_ARGNAMES["dafcls"] = ["handle"]
CSPYCE_RETNAMES["dafcls"] = []
CSPYCE_ABSTRACT["dafcls"] = """
Close the DAF associated with a given handle.
"""
CSPYCE_DEFINITIONS["dafcls"] = {
'handle': ("int", "Handle of DAF to be closed."),
}
CSPYCE_URL["dafcls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafcls_c.html"
#########################################
CSPYCE_ARGNAMES["dafgda"] = ["handle", "begin", "end"]
CSPYCE_RETNAMES["dafgda"] = ["data"]
CSPYCE_ABSTRACT["dafgda"] = """
Read the floating-point data bounded by two addresses within a DAF.
"""
CSPYCE_DEFINITIONS["dafgda"] = {
'handle': ("int", "Handle of a DAF."),
'begin' : ("int", "Initial address within file."),
'end'   : ("int", "Final address within file."),
'data'  : ("float[*]", "Data contained between `begin' and `end'."),
}
CSPYCE_URL["dafgda"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafgda_c.html"
#########################################
CSPYCE_ARGNAMES["dafgn"] = []
CSPYCE_RETNAMES["dafgn"] = ["name"]
CSPYCE_ABSTRACT["dafgn"] = """
Return (get) the name for the current array in the current DAF.
"""
CSPYCE_DEFINITIONS["dafgn"] = {
'name'  : ("string", "Name of current array."),
}
CSPYCE_URL["dafgn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafgn_c.html"
#########################################
CSPYCE_ARGNAMES["dafgs"] = []
CSPYCE_RETNAMES["dafgs"] = ["sum"]
CSPYCE_ABSTRACT["dafgs"] = """
Return (get) the summary for the current array in the current DAF.
"""
CSPYCE_DEFINITIONS["dafgs"] = {
'sum'   : ("float[*]", "Summary for current array."),
}
CSPYCE_URL["dafgs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafgs_c.html"
#########################################
CSPYCE_ARGNAMES["daffna"] = []
CSPYCE_RETNAMES["daffna"] = ["found"]
CSPYCE_ABSTRACT["daffna"] = """
Find the next (forward) array in the current DAF.
"""
CSPYCE_DEFINITIONS["daffna"] = {
'found' : ("bool", "True if an array was found."),
}
CSPYCE_URL["daffna"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/daffna_c.html"
#########################################
CSPYCE_ARGNAMES["dafopr"] = ["fname"]
CSPYCE_RETNAMES["dafopr"] = ["handle"]
CSPYCE_ABSTRACT["dafopr"] = """
Open a DAF for subsequent read requests.
"""
CSPYCE_DEFINITIONS["dafopr"] = {
'fname' : ("string", "Name of DAF to be opened."),
'handle': ("int", "Handle assigned to DAF."),
}
CSPYCE_URL["dafopr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafopr_c.html"
#########################################
CSPYCE_ARGNAMES["dafus"] = ["sum", "nd", "ni"]
CSPYCE_RETNAMES["dafus"] = ["dc", "ic"]
CSPYCE_ABSTRACT["dafus"] = """
Unpack an array summary into its floating-point and integer components.
"""
CSPYCE_DEFINITIONS["dafus"] = {
'sum'   : ("float[*]", "Array summary."),
'nd'    : ("int", "Number of floating-point components."),
'ni'    : ("int", "Number of integer components."),
'dc'    : ("float[*]", "Floating-point components."),
'ic'    : ("int[*]", "Integer components."),
}
CSPYCE_URL["dafus"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafus_c.html"
#########################################
CSPYCE_ARGNAMES["dcyldr"] = ["x", "y", "z"]
CSPYCE_RETNAMES["dcyldr"] = ["jacobi"]
CSPYCE_ABSTRACT["dcyldr"] = """
This routine computes the Jacobian of the transformation from
rectangular to cylindrical coordinates.
"""
CSPYCE_DEFINITIONS["dcyldr"] = {
'x'     : ("float", "X-coordinate of point."),
'y'     : ("float", "Y-coordinate of point."),
'z'     : ("float", "Z-coordinate of point."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["dcyldr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dcyldr_c.html"
#########################################
CSPYCE_ARGNAMES["deltet"] = ["epoch", "eptype"]
CSPYCE_RETNAMES["deltet"] = ["delta"]
CSPYCE_ABSTRACT["deltet"] = """
Return the value of Delta ET (ET-UTC) for an input epoch.
"""
CSPYCE_DEFINITIONS["deltet"] = {
'epoch' : ("time", "Input epoch (seconds past J2000)."),
'eptype': ("string", "Type of input epoch (\"UTC\" or \"ET\")."),
'delta' : ("float", "Delta ET (ET-UTC) at input epoch."),
}
CSPYCE_URL["deltet"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/deltet_c.html"
#########################################
CSPYCE_ARGNAMES["det"] = ["m1"]
CSPYCE_RETNAMES["det"] = ["value"]
CSPYCE_ABSTRACT["det"] = """
Compute the determinant of a 3x3 matrix.
"""
CSPYCE_DEFINITIONS["det"] = {
'm1'    : ("float[3,3]", "Matrix whose determinant is to be found."),
'value' : ("float", "Value of the determinant."),
}
CSPYCE_URL["det"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/det_c.html"
#########################################
CSPYCE_ARGNAMES["dgeodr"] = ["x", "y", "z", "re", "f"]
CSPYCE_RETNAMES["dgeodr"] = ["jacobi"]
CSPYCE_ABSTRACT["dgeodr"] = """
This routine computes the Jacobian of the transformation from
rectangular to geodetic coordinates.
"""
CSPYCE_DEFINITIONS["dgeodr"] = {
'x'     : ("float", "X-coordinate of point."),
'y'     : ("float", "Y-coordinate of point."),
'z'     : ("float", "Z-coordinate of point."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["dgeodr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dgeodr_c.html"
#########################################
CSPYCE_ARGNAMES["diags2"] = ["symmat"]
CSPYCE_RETNAMES["diags2"] = ["diag", "rotate"]
CSPYCE_ABSTRACT["diags2"] = """
Diagonalize a symmetric 2x2 matrix.
"""
CSPYCE_DEFINITIONS["diags2"] = {
'symmat': ("float[2,2]", "A symmetric 2x2 matrix."),
'diag'  : ("float[2,2]", "A diagonal matrix similar to symmat."),
'rotate': ("float[2,2]", "A rotation used as the similarity transformation."),
}
CSPYCE_URL["diags2"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/diags2_c.html"
#########################################
CSPYCE_ARGNAMES["dlatdr"] = ["x", "y", "z"]
CSPYCE_RETNAMES["dlatdr"] = ["jacobi"]
CSPYCE_ABSTRACT["dlatdr"] = """
This routine computes the Jacobian of the transformation from
rectangular to latitudinal coordinates.
"""
CSPYCE_DEFINITIONS["dlatdr"] = {
'x'     : ("float", "X-coordinate of point."),
'y'     : ("float", "Y-coordinate of point."),
'z'     : ("float", "Z-coordinate of point."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["dlatdr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlatdr_c.html"
#########################################
CSPYCE_ARGNAMES["dpgrdr"] = ["body", "x", "y", "z", "re", "f"]
CSPYCE_RETNAMES["dpgrdr"] = ["jacobi"]
CSPYCE_ABSTRACT["dpgrdr"] = """
This routine computes the Jacobian matrix of the transformation from
rectangular to planetographic coordinates.
"""
CSPYCE_DEFINITIONS["dpgrdr"] = {
'body'  : ("body_name", "Body with which coordinate system is associated."),
'x'     : ("float", "X-coordinate of point."),
'y'     : ("float", "Y-coordinate of point."),
'z'     : ("float", "Z-coordinate of point."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["dpgrdr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dpgrdr_c.html"
#########################################
CSPYCE_ARGNAMES["dpmax"] = []
CSPYCE_RETNAMES["dpmax"] = ["value"]
CSPYCE_ABSTRACT["dpmax"] = """
Return the value of the largest (positive) number representable in a
floating-point variable.
"""
CSPYCE_DEFINITIONS["dpmax"] = {
'value' : ("float", "The maximum respresentable floating-point number."),
}
CSPYCE_URL["dpmax"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dpmax_c.html"
#########################################
CSPYCE_ARGNAMES["dpmin"] = []
CSPYCE_RETNAMES["dpmin"] = ["value"]
CSPYCE_ABSTRACT["dpmin"] = """
Return the value of the smallest (negative) number representable in a
floating-point variable.
"""
CSPYCE_DEFINITIONS["dpmin"] = {
'value' : ("float", "The minimum respresentable floating-point number."),
}
CSPYCE_URL["dpmin"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dpmin_c.html"
#########################################
CSPYCE_ARGNAMES["dpr"] = []
CSPYCE_RETNAMES["dpr"] = ["value"]
CSPYCE_ABSTRACT["dpr"] = """
Return the number of degrees per radian.
"""
CSPYCE_DEFINITIONS["dpr"] = {
'value' : ("float", "The number of degrees per radian."),
}
CSPYCE_URL["dpr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dpr_c.html"
#########################################
CSPYCE_ARGNAMES["drdcyl"] = ["r", "lon", "z"]
CSPYCE_RETNAMES["drdcyl"] = ["jacobi"]
CSPYCE_ABSTRACT["drdcyl"] = """
This routine computes the Jacobian of the transformation from
cylindrical to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["drdcyl"] = {
'r'     : ("float", "Distance of a point from the origin."),
'lon'   : ("float", "Angle of the point from the xz plane in radians."),
'z'     : ("float", "Height of the point above the xy plane."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["drdcyl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/drdcyl_c.html"
#########################################
CSPYCE_ARGNAMES["drdgeo"] = ["lon", "lat", "alt", "re", "f"]
CSPYCE_RETNAMES["drdgeo"] = ["jacobi"]
CSPYCE_ABSTRACT["drdgeo"] = """
This routine computes the Jacobian of the transformation from geodetic
to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["drdgeo"] = {
'lon'   : ("float", "Geodetic longitude of point (radians)."),
'lat'   : ("float", "Geodetic latitude of point (radians)."),
'alt'   : ("float", "Altitude of point above the reference spheroid."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["drdgeo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/drdgeo_c.html"
#########################################
CSPYCE_ARGNAMES["drdlat"] = ["r", "lon", "lat"]
CSPYCE_RETNAMES["drdlat"] = ["jacobi"]
CSPYCE_ABSTRACT["drdlat"] = """
Compute the Jacobian of the transformation from latitudinal to
rectangular coordinates.
"""
CSPYCE_DEFINITIONS["drdlat"] = {
'r'     : ("float", "Distance of a point from the origin."),
'lon'   : ("float", "Angle of the point from the XZ plane in radians."),
'lat'   : ("float", "Angle of the point from the XY plane in radians."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["drdlat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/drdlat_c.html"
#########################################
CSPYCE_ARGNAMES["drdpgr"] = ["body", "lon", "lat", "alt", "re", "f"]
CSPYCE_RETNAMES["drdpgr"] = ["jacobi"]
CSPYCE_ABSTRACT["drdpgr"] = """
This routine computes the Jacobian matrix of the transformation from
planetographic to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["drdpgr"] = {
'body'  : ("body_name", "Name of body with which coordinates are associated."),
'lon'   : ("float", "Planetographic longitude of a point (radians)."),
'lat'   : ("float", "Planetographic latitude of a point (radians)."),
'alt'   : ("float", "Altitude of a point above reference spheroid."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["drdpgr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/drdpgr_c.html"
#########################################
CSPYCE_ARGNAMES["drdsph"] = ["r", "colat", "lon"]
CSPYCE_RETNAMES["drdsph"] = ["jacobi"]
CSPYCE_ABSTRACT["drdsph"] = """
This routine computes the Jacobian of the transformation from spherical
to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["drdsph"] = {
'r'     : ("float", "Distance of a point from the origin."),
'colat' : ("float", "Angle of the point from the positive z-axis."),
'lon'   : ("float", "Angle of the point from the xy plane."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["drdsph"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/drdsph_c.html"
#########################################
CSPYCE_ARGNAMES["dsphdr"] = ["x", "y", "z"]
CSPYCE_RETNAMES["dsphdr"] = ["jacobi"]
CSPYCE_ABSTRACT["dsphdr"] = """
This routine computes the Jacobian of the transformation from
rectangular to spherical coordinates.
"""
CSPYCE_DEFINITIONS["dsphdr"] = {
'x'     : ("float", "x-coordinate of point."),
'y'     : ("float", "y-coordinate of point."),
'z'     : ("float", "z-coordinate of point."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["dsphdr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dsphdr_c.html"
#########################################
CSPYCE_ARGNAMES["dtpool"] = ["name"]
CSPYCE_RETNAMES["dtpool"] = ["found", "n", "type"]
CSPYCE_ABSTRACT["dtpool"] = """
Return the data about a kernel pool variable.
"""
CSPYCE_DEFINITIONS["dtpool"] = {
'name'  : ("string", "Name of the variable whose value is to be returned."),
'found' : ("bool", "True if variable is in pool."),
'n'     : ("int", "Number of values returned for name."),
'type'  : ("string", "Type of the variable: 'C', 'N', or 'X'."),
}
CSPYCE_URL["dtpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dtpool_c.html"
#########################################
CSPYCE_ARGNAMES["ducrss"] = ["s1", "s2"]
CSPYCE_RETNAMES["ducrss"] = ["sout"]
CSPYCE_ABSTRACT["ducrss"] = """
Compute the unit vector parallel to the cross product of two
3-dimensional vectors and the derivative of this unit vector.
"""
CSPYCE_DEFINITIONS["ducrss"] = {
's1'    : ("float[6]", "Left hand state for cross product and derivative."),
's2'    : ("float[6]", "Right hand state for cross product and derivative."),
'sout'  : ("float[6]", "Unit vector and derivative of the cross product."),
}
CSPYCE_URL["ducrss"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ducrss_c.html"
#########################################
CSPYCE_ARGNAMES["dvcrss"] = ["s1", "s2"]
CSPYCE_RETNAMES["dvcrss"] = ["sout"]
CSPYCE_ABSTRACT["dvcrss"] = """
Compute the cross product of two 3-dimensional vectors and the
derivative of this cross product.
"""
CSPYCE_DEFINITIONS["dvcrss"] = {
's1'    : ("float[6]", "Left hand state for cross product and derivative."),
's2'    : ("float[6]", "Right hand state for cross product and derivative."),
'sout'  : ("float[6]", "State associated with cross product of positions."),
}
CSPYCE_URL["dvcrss"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dvcrss_c.html"
#########################################
CSPYCE_ARGNAMES["dvdot"] = ["s1", "s2"]
CSPYCE_RETNAMES["dvdot"] = ["value"]
CSPYCE_ABSTRACT["dvdot"] = """
Compute the derivative of the dot product of two position vectors.
"""
CSPYCE_DEFINITIONS["dvdot"] = {
's1'    : ("float[6]", "First state vector in the dot product."),
's2'    : ("float[6]", "Second state vector in the dot product."),
'value' : ("float", "The derivative of the dot product <s1,s2>"),
}
CSPYCE_URL["dvdot"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dvdot_c.html"
#########################################
CSPYCE_ARGNAMES["dvhat"] = ["s1"]
CSPYCE_RETNAMES["dvhat"] = ["state"]
CSPYCE_ABSTRACT["dvhat"] = """
Find the unit vector corresponding to a state vector and the derivative
of the unit vector.
"""
CSPYCE_DEFINITIONS["dvhat"] = {
's1'    : ("float[6]", "State to be normalized."),
'state' : ("float[6]", "Unit vector s1 / |s1|, and its time derivative."),
}
CSPYCE_URL["dvhat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dvhat_c.html"
#########################################
CSPYCE_ARGNAMES["dvnorm"] = ["state"]
CSPYCE_RETNAMES["dvnorm"] = ["value"]
CSPYCE_ABSTRACT["dvnorm"] = """
The derivative of the norm of a 3-vector.
"""
CSPYCE_DEFINITIONS["dvnorm"] = {
'state' : ("float[6]", "A 6-vector composed of three coordinates and their derivatives."),
'value' : ("float", "Derivative of the norm."),
}
CSPYCE_URL["dvnorm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dvnorm_c.html"
#########################################
CSPYCE_ARGNAMES["dvpool"] = ["name"]
CSPYCE_RETNAMES["dvpool"] = []
CSPYCE_ABSTRACT["dvpool"] = """
Delete a variable from the kernel pool.
"""
CSPYCE_DEFINITIONS["dvpool"] = {
'name'  : ("string", "Name of the kernel variable to be deleted."),
}
CSPYCE_URL["dvpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dvpool_c.html"
#########################################
CSPYCE_ARGNAMES["dvsep"] = ["s1", "s2"]
CSPYCE_RETNAMES["dvsep"] = ["value"]
CSPYCE_ABSTRACT["dvsep"] = """
Calculate the time derivative of the separation angle between two input
states, S1 and S2.
"""
CSPYCE_DEFINITIONS["dvsep"] = {
's1'    : ("float[6]", "State vector of the first body."),
's2'    : ("float[6]", "State vector of the second body."),
'value' : ("float", "Derivative of the separation angle between state vectors."),
}
CSPYCE_URL["dvsep"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dvsep_c.html"
#########################################
CSPYCE_ARGNAMES["edlimb"] = ["a", "b", "c", "viewpt"]
CSPYCE_RETNAMES["edlimb"] = ["limb"]
CSPYCE_ABSTRACT["edlimb"] = """
Find the limb of a triaxial ellipsoid, viewed from a specified point.
"""
CSPYCE_DEFINITIONS["edlimb"] = {
'a'     : ("float", "Length of ellipsoid semi-axis lying on the x-axis."),
'b'     : ("float", "Length of ellipsoid semi-axis lying on the y-axis."),
'c'     : ("float", "Length of ellipsoid semi-axis lying on the z-axis."),
'viewpt': ("float[3]", "Location of viewing point."),
'limb'  : ("float[9]", "Limb of ellipsoid as seen from viewing point."),
}
CSPYCE_URL["edlimb"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/edlimb_c.html"
#########################################
CSPYCE_ARGNAMES["edterm"] = ["trmtyp", "source", "target", "et", "fixref", "abcorr", "obsrvr", "npts"]
CSPYCE_RETNAMES["edterm"] = ["trgepc", "obspos", "trmpts"]
CSPYCE_ABSTRACT["edterm"] = """
Compute a set of points on the umbral or penumbral terminator of a
specified target body, where the target shape is modeled as an
ellipsoid.
"""
CSPYCE_DEFINITIONS["edterm"] = {
'trmtyp': ("string", "Terminator type, \"UMBRAL\" or \"PENUMBRAL\"."),
'source': ("body_name", "Light source."),
'target': ("body_name", "Target body."),
'et'    : ("time", "Observation epoch."),
'fixref': ("frame_name", "Body-fixed frame associated with target."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'obsrvr': ("body_name", "Observer."),
'npts'  : ("int", "Number of points in terminator set."),
'trgepc': ("time", "Epoch associated with target center."),
'obspos': ("float[3]", "Position of observer in body-fixed frame."),
'trmpts': ("float[*,3]", "Array of terminator points."),
}
CSPYCE_URL["edterm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/edterm_c.html"
#########################################
CSPYCE_ARGNAMES["el2cgv"] = ["ellipse"]
CSPYCE_RETNAMES["el2cgv"] = ["center", "smajor", "sminor"]
CSPYCE_ABSTRACT["el2cgv"] = """
Convert a CSPICE ellipse to a center vector and two generating vectors.
The selected generating vectors are semi-axes of the ellipse.
"""
CSPYCE_DEFINITIONS["el2cgv"] = {
'ellipse': ("float[9]", "A CSPICE ellipse."),
'center': ("float[3]", "Center of ellipse."),
'smajor': ("float[3]", "Semimajor axis of ellipse."),
'sminor': ("float[3]", "Semiminor axis of ellipse."),
}
CSPYCE_URL["el2cgv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/el2cgv_c.html"
#########################################
CSPYCE_ARGNAMES["eqncpv"] = ["et", "epoch", "eqel", "rapol", "decpol"]
CSPYCE_RETNAMES["eqncpv"] = ["state"]
CSPYCE_ABSTRACT["eqncpv"] = """
Compute the state (position and velocity of an object whose trajectory
is described via equinoctial elements relative to some fixed plane
(usually the equatorial plane of some planet).
"""
CSPYCE_DEFINITIONS["eqncpv"] = {
'et'    : ("time", "Epoch in seconds past J2000 to find state."),
'epoch' : ("time", "Epoch of elements in seconds past J2000."),
'eqel'  : ("float[9]", "Array of equinoctial elements."),
'rapol' : ("float", "Right Ascension of the pole of the reference plane."),
'decpol': ("float", "Declination of the pole of the reference plane."),
'state' : ("float[6]", "State of the object described by eqel."),
}
CSPYCE_URL["eqncpv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/eqncpv_c.html"
#########################################
CSPYCE_ARGNAMES["erract"] = ["op", "action"]
CSPYCE_RETNAMES["erract"] = ["action"]
CSPYCE_ABSTRACT["erract"] = """
Retrieve or set the default error action.
"""
CSPYCE_DEFINITIONS["erract"] = {
'op'    : ("string", "Operation: \"GET\" or \"SET\"; default is \"GET\"."),
'action': ("string", "Error response action, \"EXCEPTION\", \"RUNTIME\", \"RETURN\", \"ABORT\", or \"DEFAULT\" (which is similar to \"ABORT\"). Note that options \"ABORT\" and \"DEFAULT\" are not supported in interactive Python. CSPICE options \"REPORT\" and \"IGNORE\" are not safe and are not supported under any circumstances."),
}
CSPYCE_PS["erract"] = 'As a special case, if a single argument is provided and it is one of the allowed actions, then "SET" is assumed.'
CSPYCE_URL["erract"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/erract_c.html"
CSPYCE_DEFAULTS["erract"] = ["GET", ""]
#########################################
CSPYCE_ARGNAMES["errch"] = ["marker", "string"]
CSPYCE_RETNAMES["errch"] = []
CSPYCE_ABSTRACT["errch"] = """
Substitute a character string for the first occurrence of a marker in
the current long error message.
"""
CSPYCE_DEFINITIONS["errch"] = {
'marker': ("string", "A substring of the error message to be replaced."),
'string': ("string", "The character string to substitute for marker."),
}
CSPYCE_URL["errch"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/errch_c.html"
#########################################
CSPYCE_ARGNAMES["errdev"] = ["op", "device"]
CSPYCE_RETNAMES["errdev"] = ["device"]
CSPYCE_ABSTRACT["errdev"] = """
Retrieve or set the name of the current output device for error
messages.
"""
CSPYCE_DEFINITIONS["errdev"] = {
'op'    : ("string", "The operation: \"GET\" or \"SET\"; default is \"GET\"."),
'device': ("string", "The device name; ignored on \"GET\". Options are a file name, \"SCREEN\" and \"NULL\"."),
}
CSPYCE_PS["errdev"] = 'As a special case, if a single argument is provided, "SET" is assumed and the argument is interpreted as the device name.'
CSPYCE_URL["errdev"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/errdev_c.html"
CSPYCE_DEFAULTS["errdev"] = ["GET", ""]
#########################################
CSPYCE_ARGNAMES["errdp"] = ["marker", "number"]
CSPYCE_RETNAMES["errdp"] = []
CSPYCE_ABSTRACT["errdp"] = """
Substitute a floating-point number for the first occurrence of a marker
found in the current long error message.
"""
CSPYCE_DEFINITIONS["errdp"] = {
'marker': ("string", "A substring of the error message to be replaced."),
'number': ("float", "The d.p. number to substitute for marker."),
}
CSPYCE_URL["errdp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/errdp_c.html"
#########################################
CSPYCE_ARGNAMES["errint"] = ["marker", "number"]
CSPYCE_RETNAMES["errint"] = []
CSPYCE_ABSTRACT["errint"] = """
Substitute an integer for the first occurrence of a marker found in the
current long error message.
"""
CSPYCE_DEFINITIONS["errint"] = {
'marker': ("string", "A substring of the error message to be replaced."),
'number': ("int", "The integer to substitute for marker."),
}
CSPYCE_URL["errint"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/errint_c.html"
#########################################
CSPYCE_ARGNAMES["errprt"] = ["op", "list"]
CSPYCE_RETNAMES["errprt"] = ["list"]
CSPYCE_ABSTRACT["errprt"] = """
Retrieve or set the list of error message items to be output when an
error is detected.
"""
CSPYCE_DEFINITIONS["errprt"] = {
'op'    : ("string", "The operation: \"GET\" or \"SET\"; default is \"GET\"."),
'list'  : ("string", "Specification of error messages to be output, as a single string containing comma-separated values. Options are \"SHORT\", \"LONG\", \"EXPLAIN\", \"TRACEBACK\", \"ALL\", \"NONE\", and \"DEFAULT\"."),
}
CSPYCE_PS["errprt"] = 'As a special case, if a single argument is provided and is not "GET", then "SET" is assumed and this argument is interpreted as the list.'
CSPYCE_URL["errprt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/errprt_c.html"
CSPYCE_DEFAULTS["errprt"] = ["GET", ""]
#########################################
CSPYCE_ARGNAMES["et2lst"] = ["et", "body", "lon", "type"]
CSPYCE_RETNAMES["et2lst"] = ["hr", "mn", "sc", "time", "ampm"]
CSPYCE_ABSTRACT["et2lst"] = """
Given an ephemeris epoch, compute the local solar time for an object on
the surface of a body at a specified longitude.
"""
CSPYCE_DEFINITIONS["et2lst"] = {
'et'    : ("time", "Epoch in seconds past J2000 epoch."),
'body'  : ("body_code", "ID-code of the body of interest."),
'lon'   : ("float", "Longitude of surface point (radians)."),
'type'  : ("string", "Type of longitude, \"PLANETOCENTRIC\", etc."),
'hr'    : ("int", "Local hour on a \"24 hour\" clock."),
'mn'    : ("int", "Minutes past the hour."),
'sc'    : ("body_code", "Seconds past the minute."),
'time'  : ("string", "String giving local time on 24 hour clock."),
'ampm'  : ("string", "String giving time on AM/PM scale."),
}
CSPYCE_URL["et2lst"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/et2lst_c.html"
#########################################
CSPYCE_ARGNAMES["et2utc"] = ["et", "format", "prec"]
CSPYCE_RETNAMES["et2utc"] = ["utcstr"]
CSPYCE_ABSTRACT["et2utc"] = """
Convert an input time from ephemeris seconds past J2000 to Calendar,
Day-of-Year, or Julian Date format, UTC.
"""
CSPYCE_DEFINITIONS["et2utc"] = {
'et'    : ("time", "Input epoch, given in ephemeris seconds past J2000."),
'format': ("string", "Format of output epoch: \"C\" for calendar format; \"D\" for day-of-year format; \"J\" for Julian date; \"ISOC\" for ISO calendar format; \"ISOD\" for ISO day-of-year format."),
'prec'  : ("int", "Digits of precision in fractional seconds or days."),
'utcstr': ("string", "Output time string, UTC."),
}
CSPYCE_URL["et2utc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/et2utc_c.html"
#########################################
CSPYCE_ARGNAMES["etcal"] = ["et"]
CSPYCE_RETNAMES["etcal"] = ["string"]
CSPYCE_ABSTRACT["etcal"] = """
Convert from an ephemeris epoch measured in seconds past the epoch of
J2000 to a calendar string format using a formal calendar free of
leapseconds.
"""
CSPYCE_DEFINITIONS["etcal"] = {
'et'    : ("time", "Ephemeris time measured in seconds past J2000."),
'string': ("string", "A standard calendar representation of et."),
}
CSPYCE_URL["etcal"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/etcal_c.html"
#########################################
CSPYCE_ARGNAMES["eul2m"] = ["angle3", "angle2", "angle1", "axis3", "axis2", "axis1"]
CSPYCE_RETNAMES["eul2m"] = ["rotmat"]
CSPYCE_ABSTRACT["eul2m"] = """
Construct a rotation matrix from a set of Euler angles.
"""
CSPYCE_DEFINITIONS["eul2m"] = {
'angle3': ("float", "Rotation angle about the third rotation axis (radians)."),
'angle2': ("float", "Rotation angle about the second rotation axis (radians)."),
'angle1': ("float", "Rotation angle about the first rotation axis (radians)."),
'axis3' : ("int", "Axis number (1, 2, or 3) of the third rotation axis."),
'axis2' : ("int", "Axis number (1, 2, or 3) of the second rotation axis."),
'axis1' : ("int", "Axis number (1, 2, or 3) of the first rotation axis."),
'rotmat': ("float[3,3]", "Product of the 3 rotations."),
}
CSPYCE_URL["eul2m"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/eul2m_c.html"
#########################################
CSPYCE_ARGNAMES["eul2xf"] = ["eulang", "axisa", "axisb", "axisc"]
CSPYCE_RETNAMES["eul2xf"] = ["xform"]
CSPYCE_ABSTRACT["eul2xf"] = """
This routine computes a state transformation from an Euler angle
factorization of a rotation and the derivatives of those Euler angles.
"""
CSPYCE_DEFINITIONS["eul2xf"] = {
'eulang': ("float[6]", "An array of Euler angles and their derivatives."),
'axisa' : ("int", "Axis A of the Euler angle factorization."),
'axisb' : ("int", "Axis B of the Euler angle factorization."),
'axisc' : ("int", "Axis C of the Euler angle factorization."),
'xform' : ("float[6,6]", "A state transformation matrix."),
}
CSPYCE_URL["eul2xf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/eul2xf_c.html"
#########################################
CSPYCE_ARGNAMES["expool"] = ["name"]
CSPYCE_RETNAMES["expool"] = ["found"]
CSPYCE_ABSTRACT["expool"] = """
Confirm the existence of a kernel variable in the kernel pool.
"""
CSPYCE_DEFINITIONS["expool"] = {
'name'  : ("string", "Name of the variable whose value is to be returned."),
'found' : ("bool", "True when the variable is in the pool; False otherwise."),
}
CSPYCE_URL["expool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/expool_c.html"
#########################################
CSPYCE_ARGNAMES["failed"] = []
CSPYCE_RETNAMES["failed"] = ["value"]
CSPYCE_ABSTRACT["failed"] = """
True if an error condition has been signalled via sigerr. failed is the
CSPICE status indicator.
"""
CSPYCE_DEFINITIONS["failed"] = {
'value' : ("bool", "True if an error condition was detected inside CSPICE, False otherwise."),
}
CSPYCE_URL["failed"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/failed_c.html"
#########################################
CSPYCE_ARGNAMES["fovray"] = ["inst", "raydir", "rframe", "abcorr", "obsrvr", "et"]
CSPYCE_RETNAMES["fovray"] = ["visibl"]
CSPYCE_ABSTRACT["fovray"] = """
Determine if a specified ray is within the field-of-view (FOV) of a
specified instrument at a given time.
"""
CSPYCE_DEFINITIONS["fovray"] = {
'inst'  : ("string", "Name or ID code string of the instrument."),
'raydir': ("float[3]", "Ray's direction vector."),
'rframe': ("frame_name", "Body-fixed, body-centered frame for target body."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"S\", or \"XS\"."),
'obsrvr': ("body_name", "Name or ID code string of the observer."),
'et'    : ("time", "Time of the observation (seconds past J2000)."),
'visibl': ("bool", "Visibility flag (True/False)."),
}
CSPYCE_URL["fovray"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/fovray_c.html"
#########################################
CSPYCE_ARGNAMES["fovtrg"] = ["inst", "target", "tshape", "tframe", "abcorr", "obsrvr", "et"]
CSPYCE_RETNAMES["fovtrg"] = ["visibl"]
CSPYCE_ABSTRACT["fovtrg"] = """
Determine if a specified ephemeris object is within the field-of-view
(FOV) of a specified instrument at a given time.
"""
CSPYCE_DEFINITIONS["fovtrg"] = {
'inst'  : ("string", "Name or ID code string of the instrument."),
'target': ("body_name", "Name or ID code string of the target."),
'tshape': ("string", "Type of shape model used for the target, \"ELLIPSOID\" or \"POINT\"."),
'tframe': ("frame_name", "Body-fixed, body-centered frame for target body."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obsrvr': ("body_name", "Name or ID code string of the observer."),
'et'    : ("time", "Time of the observation (seconds past J2000)."),
'visibl': ("bool", "Visibility flag (True or False)."),
}
CSPYCE_URL["fovtrg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/fovtrg_c.html"
#########################################
CSPYCE_ARGNAMES["frame"] = ["x1"]
CSPYCE_RETNAMES["frame"] = ["x", "y", "z"]
CSPYCE_ABSTRACT["frame"] = """
Given a vector x, this routine builds a right handed orthonormal frame
x,y,z where the output x is parallel to the input x.
"""
CSPYCE_DEFINITIONS["frame"] = {
'x1'    : ("float[3]", "Input vector."),
'x'     : ("float[3]", "A unit vector parallel to x1."),
'y'     : ("float[3]", "Unit vector in the plane orthogonal to x."),
'z'     : ("float[3]", "Unit vector given by x X y."),
}
CSPYCE_URL["frame"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/frame_c.html"
#########################################
CSPYCE_ARGNAMES["frinfo"] = ["frcode"]
CSPYCE_RETNAMES["frinfo"] = ["cent", "frclss", "clssid", "found"]
CSPYCE_ABSTRACT["frinfo"] = """
Retrieve the minimal attributes associated with a frame needed for
converting transformations to and from it.
"""
CSPYCE_DEFINITIONS["frinfo"] = {
'frcode': ("frame_code", "The idcode for some frame."),
'cent'  : ("body_code", "The center of the frame."),
'frclss': ("int", "The class (type) of the frame."),
'clssid': ("int", "The idcode for the frame within its class."),
'found' : ("bool", "True if the requested information is available."),
}
CSPYCE_URL["frinfo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/frinfo_c.html"
#########################################
CSPYCE_ARGNAMES["frmchg"] = ["frame1", "frame2", "et"]
CSPYCE_RETNAMES["frmchg"] = ["xform"]
CSPYCE_ABSTRACT["frmchg"] = """
Return the state transformation matrix from one frame to another.
"""
CSPYCE_DEFINITIONS["frmchg"] = {
'frame1': ("frame_code", "The frame id-code for some reference frame."),
'frame2': ("frame_code", "The frame id-code for some reference frame."),
'et'    : ("time", "An epoch in TDB seconds past J2000."),
'xform' : ("float[6,6]", "A state transformation matrix."),
}
CSPYCE_URL["frmchg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/FORTRAN/spicelib/frmchg.html"
#########################################
CSPYCE_ARGNAMES["frmnam"] = ["frcode"]
CSPYCE_RETNAMES["frmnam"] = ["frname"]
CSPYCE_ABSTRACT["frmnam"] = """
Retrieve the name of a reference frame associated with a SPICE ID code.
"""
CSPYCE_DEFINITIONS["frmnam"] = {
'frcode': ("frame_code", "An integer code for a reference frame."),
'frname': ("frame_name", "The name associated with the reference frame; blank on error."),
}
CSPYCE_URL["frmnam"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/frmnam_c.html"
#########################################
CSPYCE_ARGNAMES["furnsh"] = ["file"]
CSPYCE_RETNAMES["furnsh"] = []
CSPYCE_ABSTRACT["furnsh"] = """
Load one or more SPICE kernels into a program.
"""
CSPYCE_DEFINITIONS["furnsh"] = {
'file'  : ("string", "Name of SPICE kernel file (text or binary)."),
}
CSPYCE_URL["furnsh"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/furnsh_c.html"
#########################################
CSPYCE_ARGNAMES["gcpool"] = ["name", "start"]
CSPYCE_RETNAMES["gcpool"] = ["cvals", "found"]
CSPYCE_ABSTRACT["gcpool"] = """
Return the character value(s) of a kernel variable from the kernel pool.
"""
CSPYCE_DEFINITIONS["gcpool"] = {
'name'  : ("string", "Name of the variable whose value is to be returned."),
'start' : ("int", "Which component to start retrieving for name."),
'cvals' : ("string[*]", "Values associated with name."),
'found' : ("bool", "True if variable is in pool."),
}
CSPYCE_URL["gcpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gcpool_c.html"
CSPYCE_DEFAULTS["gcpool"] = ["", 0]
#########################################
CSPYCE_ARGNAMES["gdpool"] = ["name", "start"]
CSPYCE_RETNAMES["gdpool"] = ["values", "found"]
CSPYCE_ABSTRACT["gdpool"] = """
Return the floating-point value(s) of a kernel variable from the kernel
pool.
"""
CSPYCE_DEFINITIONS["gdpool"] = {
'name'  : ("string", "Name of the variable whose value is to be returned."),
'start' : ("int", "Which component to start retrieving for name."),
'values': ("float[*]", "Values associated with name."),
'found' : ("bool", "True if variable is in pool."),
}
CSPYCE_URL["gdpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gdpool_c.html"
CSPYCE_DEFAULTS["gdpool"] = ["", 0]
#########################################
CSPYCE_ARGNAMES["georec"] = ["lon", "lat", "alt", "re", "f"]
CSPYCE_RETNAMES["georec"] = ["rectan"]
CSPYCE_ABSTRACT["georec"] = """
Convert geodetic coordinates to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["georec"] = {
'lon'   : ("float", "Geodetic longitude of point (radians)."),
'lat'   : ("float", "Geodetic latitude of point (radians)."),
'alt'   : ("float", "Altitude of point above the reference spheroid."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'rectan': ("float[3]", "Rectangular coordinates of point."),
}
CSPYCE_URL["georec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/georec_c.html"
#########################################
CSPYCE_ARGNAMES["getfov"] = ["instid"]
CSPYCE_RETNAMES["getfov"] = ["shape", "frame", "bsight", "bounds"]
CSPYCE_ABSTRACT["getfov"] = """
This subroutine returns the field-of-view (FOV) configuration for a
specified instrument.
"""
CSPYCE_DEFINITIONS["getfov"] = {
'instid': ("int", "NAIF ID of an instrument."),
'shape' : ("string", "Instrument FOV shape."),
'frame' : ("string", "Name of the frame in which FOV vectors are defined."),
'bsight': ("float[3]", "Boresight vector."),
'bounds': ("float[*,3]", "FOV boundary vectors."),
}
CSPYCE_URL["getfov"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/getfov_c.html"
#########################################
CSPYCE_ARGNAMES["getmsg"] = ["option"]
CSPYCE_RETNAMES["getmsg"] = ["msg"]
CSPYCE_ABSTRACT["getmsg"] = """
Retrieve the current short error message, the explanation of the short
error message, or the long error message.
"""
CSPYCE_DEFINITIONS["getmsg"] = {
'option': ("string", "Indicates type of error message, \"SHORT\", \"LONG\", or \"EXPLAIN\"."),
'msg'   : ("string", "The error message to be retrieved."),
}
CSPYCE_URL["getmsg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/getmsg_c.html"
#########################################
CSPYCE_ARGNAMES["gipool"] = ["name", "start"]
CSPYCE_RETNAMES["gipool"] = ["ivals", "found"]
CSPYCE_ABSTRACT["gipool"] = """
Return the integer value of a kernel variable from the kernel pool.
"""
CSPYCE_DEFINITIONS["gipool"] = {
'name'  : ("string", "Name of the variable whose value is to be returned."),
'start' : ("int", "Which component to start retrieving for name."),
'ivals' : ("int[*]", "Values associated with name."),
'found' : ("bool", "True if variable is in pool."),
}
CSPYCE_URL["gipool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gipool_c.html"
CSPYCE_DEFAULTS["gipool"] = ["", 0]
#########################################
CSPYCE_ARGNAMES["gnpool"] = ["name", "start"]
CSPYCE_RETNAMES["gnpool"] = ["kvars", "found"]
CSPYCE_ABSTRACT["gnpool"] = """
Return names of kernel variables matching a specified template.
"""
CSPYCE_DEFINITIONS["gnpool"] = {
'name'  : ("string", "Template that names should match."),
'start' : ("int", "Index of first matching name to retrieve."),
'kvars' : ("string[*]", "Kernel pool variables whose names match name."),
'found' : ("bool", "True if there is at least one match."),
}
CSPYCE_PS["gnpool"] = 'Raise a SPICE error condition if the variable is not in the pool, if it has the wrong type, or if the start index is out of range.'
CSPYCE_URL["gnpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gnpool_c.html"
CSPYCE_DEFAULTS["gnpool"] = ["", 0]
#########################################
CSPYCE_ARGNAMES["halfpi"] = []
CSPYCE_RETNAMES["halfpi"] = ["value"]
CSPYCE_ABSTRACT["halfpi"] = """
Return half the value of pi (the ratio of the circumference of a circle
to its diameter).
"""
CSPYCE_DEFINITIONS["halfpi"] = {
'value' : ("float", "Half the value of pi."),
}
CSPYCE_URL["halfpi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/halfpi_c.html"
#########################################
CSPYCE_ARGNAMES["ident"] = []
CSPYCE_RETNAMES["ident"] = ["matrix"]
CSPYCE_ABSTRACT["ident"] = """
Return the 3x3 identity matrix.
"""
CSPYCE_DEFINITIONS["ident"] = {
'matrix': ("float[3,3]", "is the 3x3 identity matrix."),
}
CSPYCE_URL["ident"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ident_c.html"
#########################################
CSPYCE_ARGNAMES["illum"] = ["target", "et", "abcorr", "obsrvr", "spoint"]
CSPYCE_RETNAMES["illum"] = ["phase", "solar", "emissn"]
CSPYCE_ABSTRACT["illum"] = """
Find the illumination angles at a specified surface point of a target
body.
"""
CSPYCE_DEFINITIONS["illum"] = {
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Body-fixed coordinates of a target surface point."),
'phase' : ("float", "Phase angle at the surface point."),
'solar' : ("float", "Solar incidence angle at the surface point."),
'emissn': ("float", "Emission angle at the surface point."),
}
CSPYCE_URL["illum"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/illum_c.html"
#########################################
CSPYCE_ARGNAMES["illumf"] = ["method", "target", "ilusrc", "et", "fixref", "abcorr", "obsrvr", "spoint"]
CSPYCE_RETNAMES["illumf"] = ["trgepc", "srfvec", "phase", "incdnc", "emissn", "visibl", "lit"]
CSPYCE_ABSTRACT["illumf"] = """
Compute the illumination angles---phase, incidence, and emission---at a
specified point on a target body. Return logical flags indicating
whether the surface point is visible from the observer's position and
whether the surface point is illuminated.

The target body's surface is represented using topographic data provided
by DSK files, or by a reference ellipsoid.

The illumination source is a specified ephemeris object.
"""
CSPYCE_DEFINITIONS["illumf"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'ilusrc': ("body_name", "Name of illumination source."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Body-fixed coordinates of a target surface point."),
'trgepc': ("time", "Target surface point epoch."),
'srfvec': ("float[3]", "Vector from observer to target surface point."),
'phase' : ("float", "Phase angle at the surface point."),
'incdnc': ("float", "Source incidence angle at the surface point."),
'emissn': ("float", "Emission angle at the surface point."),
'visibl': ("bool", "Visibility flag, True if visible."),
'lit'   : ("bool", "Illumination flag, True if illuminated."),
}
CSPYCE_URL["illumf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/illumf_c.html"
#########################################
CSPYCE_ARGNAMES["illumg"] = ["method", "target", "ilusrc", "et", "fixref", "abcorr", "obsrvr", "spoint"]
CSPYCE_RETNAMES["illumg"] = ["trgepc", "srfvec", "phase", "incdnc", "emissn"]
CSPYCE_ABSTRACT["illumg"] = """
Find the illumination angles (phase, incidence, and emission) at a
specified surface point of a target body.

The surface of the target body may be represented by a triaxial
ellipsoid or by topographic data provided by DSK files.

The illumination source is a specified ephemeris object.
"""
CSPYCE_DEFINITIONS["illumg"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'ilusrc': ("body_name", "Name of illumination source."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Body-fixed coordinates of a target surface point."),
'trgepc': ("time", "Target surface point epoch."),
'srfvec': ("float[3]", "Vector from observer to target surface point."),
'phase' : ("float", "Phase angle at the surface point."),
'incdnc': ("float", "Source incidence angle at the surface point."),
'emissn': ("float", "Emission angle at the surface point."),
}
CSPYCE_URL["illumg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/illumg_c.html"
#########################################
CSPYCE_ARGNAMES["ilumin"] = ["method", "target", "et", "fixref", "abcorr", "obsrvr", "spoint"]
CSPYCE_RETNAMES["ilumin"] = ["trgepc", "srfvec", "phase", "incdnc", "emissn"]
CSPYCE_ABSTRACT["ilumin"] = """
Find the illumination angles (phase, solar incidence, and emission) at a
specified surface point of a target body.

This routine supersedes illum.
"""
CSPYCE_DEFINITIONS["ilumin"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Body-fixed coordinates of a target surface point."),
'trgepc': ("time", "Target surface point epoch."),
'srfvec': ("float[3]", "Vector from observer to target surface point."),
'phase' : ("float", "Phase angle at the surface point."),
'incdnc': ("float", "Solar incidence angle at the surface point."),
'emissn': ("float", "Emission angle at the surface point."),
}
CSPYCE_URL["ilumin"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ilumin_c.html"
#########################################
CSPYCE_ARGNAMES["inedpl"] = ["a", "b", "c", "plane"]
CSPYCE_RETNAMES["inedpl"] = ["ellipse", "found"]
CSPYCE_ABSTRACT["inedpl"] = """
Find the intersection of a triaxial ellipsoid and a plane.
"""
CSPYCE_DEFINITIONS["inedpl"] = {
'a'     : ("float", "Length of ellipsoid semi-axis lying on the x-axis."),
'b'     : ("float", "Length of ellipsoid semi-axis lying on the y-axis."),
'c'     : ("float", "Length of ellipsoid semi-axis lying on the z-axis."),
'plane' : ("float[4]", "Plane that intersects ellipsoid."),
'ellipse': ("float[9]", "Intersection ellipse, when found is True."),
'found' : ("bool", "Flag indicating whether ellipse was found."),
}
CSPYCE_URL["inedpl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/inedpl_c.html"
#########################################
CSPYCE_ARGNAMES["inelpl"] = ["ellips", "plane"]
CSPYCE_RETNAMES["inelpl"] = ["nxpts", "xpt1", "xpt2"]
CSPYCE_ABSTRACT["inelpl"] = """
Find the intersection of an ellipse and a plane.
"""
CSPYCE_DEFINITIONS["inelpl"] = {
'ellips': ("float[9]", "A CSPICE ellipse."),
'plane' : ("float[4]", "A CSPICE plane."),
'nxpts' : ("int", "Number of intersection points of plane and ellipse."),
'xpt1'  : ("float[3]", "First intersection point."),
'xpt2'  : ("float[3]", "Second intersection point."),
}
CSPYCE_URL["inelpl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/inelpl_c.html"
#########################################
CSPYCE_ARGNAMES["inrypl"] = ["vertex", "dir", "plane"]
CSPYCE_RETNAMES["inrypl"] = ["nxpts", "xpt"]
CSPYCE_ABSTRACT["inrypl"] = """
Find the intersection of a ray and a plane.
"""
CSPYCE_DEFINITIONS["inrypl"] = {
'vertex': ("float[3]", "Vertex vector of ray."),
'dir'   : ("float[3]", "Direction vector of ray."),
'plane' : ("float[4]", "A CSPICE plane."),
'nxpts' : ("int", "Number of intersection points of ray and plane."),
'xpt'   : ("float[3]", "Intersection point, if nxpts = 1."),
}
CSPYCE_URL["inrypl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/inrypl_c.html"
#########################################
CSPYCE_ARGNAMES["intmax"] = []
CSPYCE_RETNAMES["intmax"] = ["value"]
CSPYCE_ABSTRACT["intmax"] = """
Return the value of the largest (positive) number representable in an
integer variable.
"""
CSPYCE_DEFINITIONS["intmax"] = {
'value' : ("int", "The largest positive number that can be represented in an integer variable."),
}
CSPYCE_URL["intmax"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/intmax_c.html"
#########################################
CSPYCE_ARGNAMES["intmin"] = []
CSPYCE_RETNAMES["intmin"] = ["value"]
CSPYCE_ABSTRACT["intmin"] = """
Return the value of the smallest (negative) number representable in an
integer variable.
"""
CSPYCE_DEFINITIONS["intmin"] = {
'value' : ("int", "The smallest (negative) number that can be represented in an integer variable."),
}
CSPYCE_URL["intmin"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/intmin_c.html"
#########################################
CSPYCE_ARGNAMES["invert"] = ["m1"]
CSPYCE_RETNAMES["invert"] = ["matrix"]
CSPYCE_ABSTRACT["invert"] = """
Generate the inverse of a 3x3 matrix.
"""
CSPYCE_DEFINITIONS["invert"] = {
'm1'    : ("float[3,3]", "Matrix to be inverted."),
'matrix': ("float[3,3]", "Inverted matrix (m1)**-1. If m1 is singular, then matrix will be size zero."),
}
CSPYCE_URL["invert"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/invert_c.html"
#########################################
CSPYCE_ARGNAMES["invort"] = ["m"]
CSPYCE_RETNAMES["invort"] = ["mit"]
CSPYCE_ABSTRACT["invort"] = """
Given a matrix, construct the matrix whose rows are the columns of the
first divided by the length squared of the the corresponding columns of
the input matrix.
"""
CSPYCE_DEFINITIONS["invort"] = {
'm'     : ("float[3,3]", "A 3x3 matrix."),
'mit'   : ("float[3,3]", "Matrix after transposition and scaling of rows."),
}
CSPYCE_URL["invort"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/invort_c.html"
#########################################
CSPYCE_ARGNAMES["isrot"] = ["m", "ntol", "dtol"]
CSPYCE_RETNAMES["isrot"] = ["value"]
CSPYCE_ABSTRACT["isrot"] = """
Indicate whether a 3x3 matrix is a rotation matrix.
"""
CSPYCE_DEFINITIONS["isrot"] = {
'm'     : ("float[3,3]", "A matrix to be tested."),
'ntol'  : ("float", "Tolerance for the norms of the columns of m."),
'dtol'  : ("float", "Tolerance for the determinant of a matrix whose columns are the unitized columns of m."),
'value' : ("bool", "True if and only if m is a rotation matrix."),
}
CSPYCE_URL["isrot"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/isrot_c.html"
#########################################
CSPYCE_ARGNAMES["j1900"] = []
CSPYCE_RETNAMES["j1900"] = ["jd"]
CSPYCE_ABSTRACT["j1900"] = """
Return the Julian Date of 1899 DEC 31 12:00:00 (1900 JAN 0.5).
"""
CSPYCE_DEFINITIONS["j1900"] = {
'jd'    : ("float", "Julian Date of 1899 DEC 31 12:00:00 (1900 JAN 0.5)."),
}
CSPYCE_URL["j1900"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/j1900_c.html"
#########################################
CSPYCE_ARGNAMES["j1950"] = []
CSPYCE_RETNAMES["j1950"] = ["jd"]
CSPYCE_ABSTRACT["j1950"] = """
Return the Julian Date of 1950 JAN 01 00:00:00 (1950 JAN 1.0).
"""
CSPYCE_DEFINITIONS["j1950"] = {
'jd'    : ("float", "Julian Date of 1950 JAN 01 00:00:00 (1950 JAN 1.0)."),
}
CSPYCE_URL["j1950"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/j1950_c.html"
#########################################
CSPYCE_ARGNAMES["j2000"] = []
CSPYCE_RETNAMES["j2000"] = ["jd"]
CSPYCE_ABSTRACT["j2000"] = """
Return the Julian Date of 2000 JAN 01 12:00:00 (2000 JAN 1.5).
"""
CSPYCE_DEFINITIONS["j2000"] = {
'jd'    : ("float", "Julian Date of 2000 JAN 01 12:00:00 (2000 JAN 1.5)."),
}
CSPYCE_URL["j2000"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/j2000_c.html"
#########################################
CSPYCE_ARGNAMES["j2100"] = []
CSPYCE_RETNAMES["j2100"] = ["jd"]
CSPYCE_ABSTRACT["j2100"] = """
Return the Julian Date of 2100 JAN 01 12:00:00 (2100 JAN 1.5).
"""
CSPYCE_DEFINITIONS["j2100"] = {
'jd'    : ("float", "Julian Date of 2100 JAN 01 12:00:00 (2100 JAN 1.5)."),
}
CSPYCE_URL["j2100"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/j2100_c.html"
#########################################
CSPYCE_ARGNAMES["jyear"] = []
CSPYCE_RETNAMES["jyear"] = ["value"]
CSPYCE_ABSTRACT["jyear"] = """
Return the number of seconds in a julian year.
"""
CSPYCE_DEFINITIONS["jyear"] = {
'value' : ("float", "The number of seconds in a julian year."),
}
CSPYCE_URL["jyear"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/jyear_c.html"
#########################################
CSPYCE_ARGNAMES["kplfrm"] = ["frmcls"]
CSPYCE_RETNAMES["kplfrm"] = ["ids"]
CSPYCE_ABSTRACT["kplfrm"] = """
Return an array containing the frame IDs of all reference frames of a
given class having specifications in the kernel pool.
"""
CSPYCE_DEFINITIONS["kplfrm"] = {
'frmcls': ("int", "Frame class (-1 = all; 1 = built-in inertial; 2 = PCK-based; 3 = CK-based; 4 = fixed rotational; 5 = dynamic)."),
'ids'   : ("frame_code[*]", "Array of ID codes of frames of the specified class."),
}
CSPYCE_URL["kplfrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/kplfrm_c.html"
#########################################
CSPYCE_ARGNAMES["latcyl"] = ["radius", "lon", "lat"]
CSPYCE_RETNAMES["latcyl"] = ["r", "lonc", "z"]
CSPYCE_ABSTRACT["latcyl"] = """
Convert from latitudinal coordinates to cylindrical coordinates.
"""
CSPYCE_DEFINITIONS["latcyl"] = {
'radius': ("float", "Distance of a point from the origin."),
'lon'   : ("float", "Angle of the point from the XZ plane in radians."),
'lat'   : ("float", "Angle of the point from the XY plane in radians."),
'r'     : ("float", "Distance of the point from the z axis."),
'lonc'  : ("float", "Angle of the point from the XZ plane in radians."),
'z'     : ("float", "Height of the point above the XY plane."),
}
CSPYCE_URL["latcyl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/latcyl_c.html"
#########################################
CSPYCE_ARGNAMES["latrec"] = ["radius", "lon", "lat"]
CSPYCE_RETNAMES["latrec"] = ["rectan"]
CSPYCE_ABSTRACT["latrec"] = """
Convert from latitudinal coordinates to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["latrec"] = {
'radius': ("float", "Distance of a point from the origin."),
'lon'   : ("float", "Longitude of point in radians."),
'lat'   : ("float", "Latitude of point in radians."),
'rectan': ("float[3]", "Rectangular coordinates of the point."),
}
CSPYCE_URL["latrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/latrec_c.html"
#########################################
CSPYCE_ARGNAMES["latsrf"] = ["method", "target", "et", "fixref", "lonlat"]
CSPYCE_RETNAMES["latsrf"] = ["srfpts"]
CSPYCE_ABSTRACT["latsrf"] = """
Map array of planetocentric longitude/latitude coordinate pairs to
surface points on a specified target body.

The surface of the target body may be represented by a triaxial
ellipsoid or by topographic data provided by DSK files.
"""
CSPYCE_DEFINITIONS["latsrf"] = {
'method': ("string", "Computation method: \"ELLIPSOID\" or \"DSK/UNPRIORITIZED[/SURFACES = <surface list>]\"."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'lonlat': ("float[*,2]", "Array of longitude/latitude coordinate pairs."),
'srfpts': ("float[*,3]", "Array of surface points."),
}
CSPYCE_URL["latsrf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/latsrf_c.html"
#########################################
CSPYCE_ARGNAMES["latsph"] = ["radius", "lon", "lat"]
CSPYCE_RETNAMES["latsph"] = ["rho", "colat", "lon2"]
CSPYCE_ABSTRACT["latsph"] = """
Convert from latitudinal coordinates to spherical coordinates.
"""
CSPYCE_DEFINITIONS["latsph"] = {
'radius': ("float", "Distance of a point from the origin."),
'lon'   : ("float", "Angle of the point from the XZ plane in radians."),
'lat'   : ("float", "Angle of the point from the XY plane in radians."),
'rho'   : ("float", "Distance of the point from the origin."),
'colat' : ("float", "Angle of the point from positive z axis (radians)."),
'lon2'  : ("float", "Angle of the point from the XZ plane (radians)."),
}
CSPYCE_URL["latsph"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/latsph_c.html"
#########################################
CSPYCE_ARGNAMES["ldpool"] = ["filename"]
CSPYCE_RETNAMES["ldpool"] = []
CSPYCE_ABSTRACT["ldpool"] = """
Load the variables contained in a NAIF ASCII kernel file into the kernel
pool.
"""
CSPYCE_DEFINITIONS["ldpool"] = {
'filename': ("string", "Name of the kernel file."),
}
CSPYCE_URL["ldpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ldpool_c.html"
#########################################
CSPYCE_ARGNAMES["limbpt"] = ["method", "target", "et", "fixref", "abcorr", "corloc", "obsrvr", "refvec", "rolstp", "ncuts", "schstp", "soltol", "maxn"]
CSPYCE_RETNAMES["limbpt"] = ["npts", "points", "epochs", "tangts"]
CSPYCE_ABSTRACT["limbpt"] = """
Find limb points on a target body. The limb is the set of points of
tangency on the target of rays emanating from the observer. The caller
specifies half-planes bounded by the observer-target center vector in
which to search for limb points.

The surface of the target body may be represented either by a triaxial
ellipsoid or by topographic data.
"""
CSPYCE_DEFINITIONS["limbpt"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'corloc': ("string", "Aberration correction locus."),
'obsrvr': ("body_name", "Name of observing body."),
'refvec': ("float[3]", "Reference vector for cutting half-planes."),
'rolstp': ("float", "Roll angular step for cutting half-planes."),
'ncuts' : ("int", "Number of cutting half-planes."),
'schstp': ("float", "Angular step size for searching."),
'soltol': ("float", "Solution convergence tolerance."),
'maxn'  : ("int", "Maximum number of entries in output arrays."),
'npts'  : ("int[*]", "Counts of limb points corresponding to cuts."),
'points': ("float[*,3]", "Limb points."),
'epochs': ("time[*]", "Times associated with limb points."),
'tangts': ("float[*,3]", "Tangent vectors emanating from the observer."),
}
CSPYCE_URL["limbpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/limbpt_c.html"
#########################################
CSPYCE_ARGNAMES["lspcn"] = ["body", "et", "abcorr"]
CSPYCE_RETNAMES["lspcn"] = ["value"]
CSPYCE_ABSTRACT["lspcn"] = """
Compute L_s, the planetocentric longitude of the sun, as seen from a
specified body.
"""
CSPYCE_DEFINITIONS["lspcn"] = {
'body'  : ("body_name", "Name of central body."),
'et'    : ("time", "Epoch in seconds past J2000 TDB."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", or \"LT+S\"."),
'value' : ("float", "The value of L_s for the specified body at the specified time."),
}
CSPYCE_URL["lspcn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lspcn_c.html"
#########################################
CSPYCE_ARGNAMES["ltime"] = ["etobs", "obs", "dir", "targ"]
CSPYCE_RETNAMES["ltime"] = ["ettarg", "elapsd"]
CSPYCE_ABSTRACT["ltime"] = """
Compute the transmission (or reception) time of a signal at a specified
target, given the reception (or transmission) time at a specified
observer. Also return the elapsed time between transmission and
reception.
"""
CSPYCE_DEFINITIONS["ltime"] = {
'etobs' : ("time", "Epoch of a signal at some observer."),
'obs'   : ("body_code", "NAIF ID of some observer."),
'dir'   : ("string", "Direction the signal travels (\"->\" or \"<-\")."),
'targ'  : ("body_code", "NAIF ID of the target object."),
'ettarg': ("float", "Epoch of the signal at the target."),
'elapsd': ("float", "Time between transmit and receipt of the signal."),
}
CSPYCE_URL["ltime"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ltime_c.html"
#########################################
CSPYCE_ARGNAMES["m2eul"] = ["r", "axis3", "axis2", "axis1"]
CSPYCE_RETNAMES["m2eul"] = ["angle3", "angle2", "angle1"]
CSPYCE_ABSTRACT["m2eul"] = """
Factor a rotation matrix as a product of three rotations about specified
coordinate axes.
"""
CSPYCE_DEFINITIONS["m2eul"] = {
'r'     : ("float[3,3]", "A rotation matrix to be factored."),
'axis3' : ("int", "Number of the third rotation axis."),
'axis2' : ("int", "Number of the second rotation axis."),
'axis1' : ("int", "Number of the first rotation axis."),
'angle3': ("float", "Third Euler angle, in radians."),
'angle2': ("float", "Second Euler angle, in radians."),
'angle1': ("float", "First Euler angle, in radians."),
}
CSPYCE_URL["m2eul"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/m2eul_c.html"
#########################################
CSPYCE_ARGNAMES["m2q"] = ["r"]
CSPYCE_RETNAMES["m2q"] = ["q"]
CSPYCE_ABSTRACT["m2q"] = """
Find a unit quaternion corresponding to a specified rotation matrix.
"""
CSPYCE_DEFINITIONS["m2q"] = {
'r'     : ("float[3,3]", "A rotation matrix."),
'q'     : ("float[4]", "A unit quaternion representing r."),
}
CSPYCE_URL["m2q"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/m2q_c.html"
#########################################
CSPYCE_ARGNAMES["mequ"] = ["m1"]
CSPYCE_RETNAMES["mequ"] = ["matrix"]
CSPYCE_ABSTRACT["mequ"] = """
Set one 3x3 matrix equal to another.
"""
CSPYCE_DEFINITIONS["mequ"] = {
'm1'    : ("float[3,3]", "Input matrix."),
'matrix': ("float[3,3]", "Output matrix equal to m1."),
}
CSPYCE_URL["mequ"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mequ_c.html"
#########################################
CSPYCE_ARGNAMES["mequg"] = ["m1"]
CSPYCE_RETNAMES["mequg"] = ["matrix"]
CSPYCE_ABSTRACT["mequg"] = """
Set one matrix of arbitrary size equal to another.
"""
CSPYCE_DEFINITIONS["mequg"] = {
'm1'    : ("float[*,*]", "Input matrix."),
'matrix': ("float[*,*]", "Output matrix equal to m1."),
}
CSPYCE_URL["mequg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mequg_c.html"
#########################################
CSPYCE_ARGNAMES["mtxm"] = ["m1", "m2"]
CSPYCE_RETNAMES["mtxm"] = ["m3"]
CSPYCE_ABSTRACT["mtxm"] = """
Multiply the transpose of a 3x3 matrix and a 3x3 matrix.
"""
CSPYCE_DEFINITIONS["mtxm"] = {
'm1'    : ("float[3,3]", "3x3 matrix."),
'm2'    : ("float[3,3]", "3x3 matrix."),
'm3'    : ("float[3,3]", "The product m1 transpose times m2."),
}
CSPYCE_URL["mtxm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mtxm_c.html"
#########################################
CSPYCE_ARGNAMES["mtxmg"] = ["m1", "m2"]
CSPYCE_RETNAMES["mtxmg"] = ["m3"]
CSPYCE_ABSTRACT["mtxmg"] = """
Multiply the transpose of a matrix with another matrix, both of
arbitrary size. (The dimensions of the matrices must be compatible with
this multiplication.)
"""
CSPYCE_DEFINITIONS["mtxmg"] = {
'm1'    : ("float[*,*]", "First input matrix."),
'm2'    : ("float[*,*]", "Second input matrix."),
'm3'    : ("float[*,*]", "Transpose of m1 times m2."),
}
CSPYCE_URL["mtxmg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mtxmg_c.html"
#########################################
CSPYCE_ARGNAMES["mtxv"] = ["m1", "v1"]
CSPYCE_RETNAMES["mtxv"] = ["vector"]
CSPYCE_ABSTRACT["mtxv"] = """
Multiply the transpose of a 3x3 matrix on the left with a vector on the
right.
"""
CSPYCE_DEFINITIONS["mtxv"] = {
'm1'    : ("float[3,3]", "3x3 matrix."),
'v1'    : ("float[3]", "3-dimensional vector."),
'vector': ("float[3]", "The product m1**t * v."),
}
CSPYCE_URL["mtxv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mtxv_c.html"
#########################################
CSPYCE_ARGNAMES["mtxvg"] = ["m1", "v2"]
CSPYCE_RETNAMES["mtxvg"] = ["v3"]
CSPYCE_ABSTRACT["mtxvg"] = """
Multiply the transpose of a matrix and a vector of arbitrary size.
"""
CSPYCE_DEFINITIONS["mtxvg"] = {
'm1'    : ("float[*,*]", "Left-hand matrix to be multiplied."),
'v2'    : ("float[*]", "Right-hand vector to be multiplied."),
'v3'    : ("float", "Product vector m1 transpose * v2."),
}
CSPYCE_URL["mtxvg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mtxvg_c.html"
#########################################
CSPYCE_ARGNAMES["mxm"] = ["m1", "m2"]
CSPYCE_RETNAMES["mxm"] = ["matrix"]
CSPYCE_ABSTRACT["mxm"] = """
Multiply two 3x3 matrices.
"""
CSPYCE_DEFINITIONS["mxm"] = {
'm1'    : ("float[3,3]", "3x3 matrix."),
'm2'    : ("float[3,3]", "3x3 matrix."),
'matrix': ("float[3,3]", "3x3 product m1*m2."),
}
CSPYCE_URL["mxm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mxm_c.html"
#########################################
CSPYCE_ARGNAMES["mxmg"] = ["m1", "m2"]
CSPYCE_RETNAMES["mxmg"] = ["m3"]
CSPYCE_ABSTRACT["mxmg"] = """
Multiply two matrices of arbitrary size.
"""
CSPYCE_DEFINITIONS["mxmg"] = {
'm1'    : ("float[*,*]", "First matrix."),
'm2'    : ("float[*,*]", "Second matrix."),
'm3'    : ("float[*,*]", "The product m1 times m2."),
}
CSPYCE_URL["mxmg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mxmg_c.html"
#########################################
CSPYCE_ARGNAMES["mxmt"] = ["m1", "m2"]
CSPYCE_RETNAMES["mxmt"] = ["m3"]
CSPYCE_ABSTRACT["mxmt"] = """
Multiply a 3x3 matrix and the transpose of another 3x3 matrix.
"""
CSPYCE_DEFINITIONS["mxmt"] = {
'm1'    : ("float[3,3]", "3x3 matrix."),
'm2'    : ("float[3,3]", "3x3 matrix."),
'm3'    : ("float[3,3]", "The product m1 times m2 transpose."),
}
CSPYCE_URL["mxmt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mxmt_c.html"
#########################################
CSPYCE_ARGNAMES["mxmtg"] = ["m1", "m2"]
CSPYCE_RETNAMES["mxmtg"] = ["m3"]
CSPYCE_ABSTRACT["mxmtg"] = """
Multiply a matrix and the transpose of a matrix, both of arbitrary size.
"""
CSPYCE_DEFINITIONS["mxmtg"] = {
'm1'    : ("float[*,*]", "Left-hand matrix to be multiplied."),
'm2'    : ("float[*,*]", "Right-hand matrix whose transpose is to be multiplied"),
'm3'    : ("float[*,*]", "Product matrix."),
}
CSPYCE_URL["mxmtg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mxmtg_c.html"
#########################################
CSPYCE_ARGNAMES["mxv"] = ["m1", "v1"]
CSPYCE_RETNAMES["mxv"] = ["vector"]
CSPYCE_ABSTRACT["mxv"] = """
Multiply a 3x3 matrix with a 3-dimensional vector.
"""
CSPYCE_DEFINITIONS["mxv"] = {
'm1'    : ("float[3,3]", "3x3 matrix."),
'v1'    : ("float[3]", "3-dimensional vector."),
'vector': ("float[3]", "The product m1*vin."),
}
CSPYCE_URL["mxv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mxv_c.html"
#########################################
CSPYCE_ARGNAMES["mxvg"] = ["m1", "v2"]
CSPYCE_RETNAMES["mxvg"] = ["v3"]
CSPYCE_ABSTRACT["mxvg"] = """
Multiply a matrix and a vector of arbitrary size.
"""
CSPYCE_DEFINITIONS["mxvg"] = {
'm1'    : ("float[*,*]", "Left-hand matrix to be multiplied."),
'v2'    : ("float[*]", "Right-hand vector to be multiplied."),
'v3'    : ("float", "Product vector m1*v2."),
}
CSPYCE_URL["mxvg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/mxvg_c.html"
#########################################
CSPYCE_ARGNAMES["namfrm"] = ["frname"]
CSPYCE_RETNAMES["namfrm"] = ["frcode"]
CSPYCE_ABSTRACT["namfrm"] = """
Look up the frame ID code associated with a string.
"""
CSPYCE_DEFINITIONS["namfrm"] = {
'frname': ("frame_name", "The name of some reference frame."),
'frcode': ("frame_code", "The SPICE ID code of the frame."),
}
CSPYCE_URL["namfrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/namfrm_c.html"
#########################################
CSPYCE_ARGNAMES["nearpt"] = ["positn", "a", "b", "c"]
CSPYCE_RETNAMES["nearpt"] = ["npoint", "alt"]
CSPYCE_ABSTRACT["nearpt"] = """
This routine locates the point on the surface of an ellipsoid that is
nearest to a specified position. It also returns the altitude of the
position above the ellipsoid.
"""
CSPYCE_DEFINITIONS["nearpt"] = {
'positn': ("float[3]", "Position of a point in bodyfixed frame."),
'a'     : ("float", "Length of semi-axis parallel to x-axis."),
'b'     : ("float", "Length of semi-axis parallel to y-axis."),
'c'     : ("float", "Length on semi-axis parallel to z-axis."),
'npoint': ("float[3]", "Point on the ellipsoid closest to positn."),
'alt'   : ("float", "Altitude of positn above the ellipsoid."),
}
CSPYCE_URL["nearpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/nearpt_c.html"
#########################################
CSPYCE_ARGNAMES["npedln"] = ["a", "b", "c", "linept", "linedr"]
CSPYCE_RETNAMES["npedln"] = ["pnear", "dist"]
CSPYCE_ABSTRACT["npedln"] = """
Find nearest point on a triaxial ellipsoid to a specified line, and the
distance from the ellipsoid to the line.
"""
CSPYCE_DEFINITIONS["npedln"] = {
'a'     : ("float", "Length of ellipsoid's semi-axis in the x direction."),
'b'     : ("float", "Length of ellipsoid's semi-axis in the y direction."),
'c'     : ("float", "Length of ellipsoid's semi-axis in the z direction."),
'linept': ("float[3]", "Point on line."),
'linedr': ("float[3]", "Direction vector of line."),
'pnear' : ("float[3]", "Nearest point on ellipsoid to line."),
'dist'  : ("float", "Distance of ellipsoid from line."),
}
CSPYCE_URL["npedln"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/npedln_c.html"
#########################################
CSPYCE_ARGNAMES["npelpt"] = ["point", "ellips"]
CSPYCE_RETNAMES["npelpt"] = ["pnear", "dist"]
CSPYCE_ABSTRACT["npelpt"] = """
Find the nearest point on an ellipse to a specified point, both in
three-dimensional space, and find the distance between the ellipse and
the point.
"""
CSPYCE_DEFINITIONS["npelpt"] = {
'point' : ("float[3]", "Point whose distance to an ellipse is to be found."),
'ellips': ("float[9]", "A CSPICE ellipse."),
'pnear' : ("float[3]", "Nearest point on ellipse to input point."),
'dist'  : ("float", "Distance of input point to ellipse."),
}
CSPYCE_URL["npelpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/npelpt_c.html"
#########################################
CSPYCE_ARGNAMES["nplnpt"] = ["linpt", "lindir", "point"]
CSPYCE_RETNAMES["nplnpt"] = ["pnear", "dist"]
CSPYCE_ABSTRACT["nplnpt"] = """
Find the nearest point on a line to a specified point, and find the
distance between the two points.
"""
CSPYCE_DEFINITIONS["nplnpt"] = {
'linpt' : ("float[3]", "Point on a line."),
'lindir': ("float[3]", "The line's direction vector."),
'point' : ("float[3]", "A second point."),
'pnear' : ("float[3]", "Nearest point on the line to point."),
'dist'  : ("float", "Distance between point and pnear."),
}
CSPYCE_URL["nplnpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/nplnpt_c.html"
#########################################
CSPYCE_ARGNAMES["nvc2pl"] = ["normal", "constant"]
CSPYCE_RETNAMES["nvc2pl"] = ["plane"]
CSPYCE_ABSTRACT["nvc2pl"] = """
Make a CSPICE plane from a normal vector and a constant.
"""
CSPYCE_DEFINITIONS["nvc2pl"] = {
'normal': ("float[3]", "A normal vector defining a plane."),
'constant': ("float", "A constant defining a plane."),
'plane' : ("float[4]", "A CSPICE plane structure representing the plane."),
}
CSPYCE_URL["nvc2pl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/nvc2pl_c.html"
#########################################
CSPYCE_ARGNAMES["nvp2pl"] = ["normal", "point"]
CSPYCE_RETNAMES["nvp2pl"] = ["plane"]
CSPYCE_ABSTRACT["nvp2pl"] = """
Make a CSPICE plane from a normal vector and a point.
"""
CSPYCE_DEFINITIONS["nvp2pl"] = {
'normal': ("float[3]", "A normal vector defining a plane."),
'point' : ("float[3]", "A point on the plane."),
'plane' : ("float[4]", "A CSPICE plane structure representing the plane."),
}
CSPYCE_URL["nvp2pl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/nvp2pl_c.html"
#########################################
CSPYCE_ARGNAMES["occult"] = ["targ1", "shape1", "frame1", "targ2", "shape2", "frame2", "abcorr", "obsrvr", "et"]
CSPYCE_RETNAMES["occult"] = ["ocltid"]
CSPYCE_ABSTRACT["occult"] = """
Determines the occultation condition (not occulted, partially, etc.) of
one target relative to another target as seen by an observer at a given
time.

The surfaces of the target bodies may be represented by triaxial
ellipsoids or by topographic data provided by DSK files.
"""
CSPYCE_DEFINITIONS["occult"] = {
'targ1' : ("body_name", "Name or ID of first target."),
'shape1': ("string", "Type of shape model used for first target."),
'frame1': ("frame_name", "Body-fixed, body-centered frame for first body."),
'targ2' : ("body_name", "Name or ID of second target."),
'shape2': ("string", "Type of shape model used for second target."),
'frame2': ("frame_name", "Body-fixed, body-centered frame for second body."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"CN\", \"XLT\", or \"XCN\"."),
'obsrvr': ("body_name", "Name or ID of the observer."),
'et'    : ("time", "Time of the observation (seconds past J2000)."),
'ocltid': ("int", "Occultation identification code."),
}
CSPYCE_URL["occult"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/occult_c.html"
#########################################
CSPYCE_ARGNAMES["oscelt"] = ["state", "et", "mu"]
CSPYCE_RETNAMES["oscelt"] = ["elts"]
CSPYCE_ABSTRACT["oscelt"] = """
Determine the set of osculating conic orbital elements that corresponds
to the state (position, velocity) of a body at some epoch.
"""
CSPYCE_DEFINITIONS["oscelt"] = {
'state' : ("float[6]", "State of body at epoch of elements."),
'et'    : ("time", "Epoch of elements."),
'mu'    : ("float", "Gravitational parameter (GM) of primary body."),
'elts'  : ("float[8]", "Equivalent conic elements."),
}
CSPYCE_URL["oscelt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/oscelt_c.html"
#########################################
CSPYCE_ARGNAMES["oscltx"] = ["state", "et", "mu"]
CSPYCE_RETNAMES["oscltx"] = ["elts"]
CSPYCE_ABSTRACT["oscltx"] = """
Determine the set of osculating conic orbital elements that corresponds
to the state (position, velocity) of a body at some epoch. In addition
to the classical elements, return the true anomaly, semi-major axis, and
period, if applicable.
"""
CSPYCE_DEFINITIONS["oscltx"] = {
'state' : ("float[6]", "State of body at epoch of elements."),
'et'    : ("time", "Epoch of elements."),
'mu'    : ("float", "Gravitational parameter (GM) of primary body."),
'elts'  : ("float[*]", "Extended set of classical conic elements."),
}
CSPYCE_URL["oscltx"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/oscltx_c.html"
#########################################
CSPYCE_ARGNAMES["pckcov"] = ["pck", "idcode"]
CSPYCE_RETNAMES["pckcov"] = ["cover"]
CSPYCE_ABSTRACT["pckcov"] = """
Find the coverage window for a specified reference frame in a specified
binary PCK file.
"""
CSPYCE_DEFINITIONS["pckcov"] = {
'pck'   : ("string", "Name of PCK file."),
'idcode': ("frame_code", "Class ID code of PCK reference frame."),
'cover' : ("time[*,2]", "Array giving start/stop time pairs for the intervals covered."),
}
CSPYCE_URL["pckcov"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pckcov_c.html"
#########################################
CSPYCE_ARGNAMES["pckfrm"] = ["pck"]
CSPYCE_RETNAMES["pckfrm"] = ["ids"]
CSPYCE_ABSTRACT["pckfrm"] = """
Find the set of reference frame class ID codes of all frames in a
specified binary PCK file.
"""
CSPYCE_DEFINITIONS["pckfrm"] = {
'pck'   : ("string", "Name of PCK file."),
'ids'   : ("int[*]", "Array of frame class ID codes for frames in PCK file."),
}
CSPYCE_URL["pckfrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pckfrm_c.html"
#########################################
CSPYCE_ARGNAMES["pcpool"] = ["name", "cvals"]
CSPYCE_RETNAMES["pcpool"] = []
CSPYCE_ABSTRACT["pcpool"] = """
This entry point provides toolkit programmers a method for
programmatically inserting character data into the kernel pool.
"""
CSPYCE_DEFINITIONS["pcpool"] = {
'name'  : ("string", "The kernel pool name to associate with cvals."),
'cvals' : ("string[*]", "An array of strings to insert into the kernel pool."),
}
CSPYCE_URL["pcpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pcpool_c.html"
#########################################
CSPYCE_ARGNAMES["pdpool"] = ["name", "dvals"]
CSPYCE_RETNAMES["pdpool"] = []
CSPYCE_ABSTRACT["pdpool"] = """
This entry point provides toolkit programmers a method for
programmatically inserting floating-point data into the kernel pool.
"""
CSPYCE_DEFINITIONS["pdpool"] = {
'name'  : ("string", "The kernel pool name to associate with dvals."),
'dvals' : ("float[*]", "An array of values to insert into the kernel pool."),
}
CSPYCE_URL["pdpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pdpool_c.html"
#########################################
CSPYCE_ARGNAMES["pgrrec"] = ["body", "lon", "lat", "alt", "re", "f"]
CSPYCE_RETNAMES["pgrrec"] = ["rectan"]
CSPYCE_ABSTRACT["pgrrec"] = """
Convert planetographic coordinates to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["pgrrec"] = {
'body'  : ("body_name", "Body with which coordinate system is associated."),
'lon'   : ("float", "Planetographic longitude of a point (radians)."),
'lat'   : ("float", "Planetographic latitude of a point (radians)."),
'alt'   : ("float", "Altitude of a point above reference spheroid."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'rectan': ("float[3]", "Rectangular coordinates of the point."),
}
CSPYCE_URL["pgrrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pgrrec_c.html"
#########################################
CSPYCE_ARGNAMES["phaseq"] = ["et", "target", "illmn", "obsrvr", "abcorr"]
CSPYCE_RETNAMES["phaseq"] = ["value"]
CSPYCE_ABSTRACT["phaseq"] = """
Compute the apparent phase angle for a target, observer, illuminator set
of ephemeris objects.
"""
CSPYCE_DEFINITIONS["phaseq"] = {
'et'    : ("time", "Ephemeris seconds past J2000 TDB."),
'target': ("body_name", "Target body name."),
'illmn' : ("body_name", "Illuminating body name."),
'obsrvr': ("body_name", "Observer body."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'value' : ("float", "Value of the phase angle."),
}
CSPYCE_URL["phaseq"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/phaseq_c.html"
#########################################
CSPYCE_ARGNAMES["pi"] = []
CSPYCE_RETNAMES["pi"] = ["value"]
CSPYCE_ABSTRACT["pi"] = """
Return the value of pi (the ratio of the circumference of a circle to
its diameter).
"""
CSPYCE_DEFINITIONS["pi"] = {
'value' : ("float", "The value of pi."),
}
CSPYCE_URL["pi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pi_c.html"
#########################################
CSPYCE_ARGNAMES["pipool"] = ["name", "ivals"]
CSPYCE_RETNAMES["pipool"] = []
CSPYCE_ABSTRACT["pipool"] = """
This entry point provides toolkit programmers a method for
programmatically inserting integer data into the kernel pool.
"""
CSPYCE_DEFINITIONS["pipool"] = {
'name'  : ("string", "The kernel pool name to associate with values."),
'ivals' : ("int[*]", "An array of integers to insert into the pool."),
}
CSPYCE_URL["pipool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pipool_c.html"
#########################################
CSPYCE_ARGNAMES["pjelpl"] = ["elin", "plane"]
CSPYCE_RETNAMES["pjelpl"] = ["elout"]
CSPYCE_ABSTRACT["pjelpl"] = """
Project an ellipse onto a plane, orthogonally.
"""
CSPYCE_DEFINITIONS["pjelpl"] = {
'elin'  : ("float[9]", "A CSPICE ellipse to be projected."),
'plane' : ("float[4]", "A plane onto which elin is to be projected."),
'elout' : ("float[9]", "A CSPICE ellipse resulting from the projection."),
}
CSPYCE_URL["pjelpl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pjelpl_c.html"
#########################################
CSPYCE_ARGNAMES["pltar"] = ["vrtces", "plates"]
CSPYCE_RETNAMES["pltar"] = ["area"]
CSPYCE_ABSTRACT["pltar"] = """
Compute the total area of a collection of triangular plates.
"""
CSPYCE_DEFINITIONS["pltar"] = {
'vrtces': ("float[*,3]", "Array of vertices."),
'plates': ("int[*,3]", "Array of plates defined by the indices of three vertices. Indices start at 1."),
'area'  : ("float", "Total area of plates."),
}
CSPYCE_URL["pltar"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pltar_c.html"
#########################################
CSPYCE_ARGNAMES["pltexp"] = ["iverts", "delta"]
CSPYCE_RETNAMES["pltexp"] = ["overts"]
CSPYCE_ABSTRACT["pltexp"] = """
Expand a triangular plate by a specified amount. The expanded plate is
co-planar with, and has the same orientation as, the original. The
centroids of the two plates coincide.
"""
CSPYCE_DEFINITIONS["pltexp"] = {
'iverts': ("float[3,3]", "Vertices of the plate to be expanded."),
'delta' : ("float", "Fraction by which the plate is to be expanded."),
'overts': ("float[3,3]", "Vertices of the expanded plate."),
}
CSPYCE_URL["pltexp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pltexp_c.html"
#########################################
CSPYCE_ARGNAMES["pltnp"] = ["point", "v1", "v2", "v3"]
CSPYCE_RETNAMES["pltnp"] = ["pnear", "dist"]
CSPYCE_ABSTRACT["pltnp"] = """
Find the nearest point on a triangular plate to a given point.
"""
CSPYCE_DEFINITIONS["pltnp"] = {
'point' : ("float[3]", "A point in 3-dimensional space."),
'v1'    : ("float[3]", "First vertex of a triangular plate."),
'v2'    : ("float[3]", "Second vertex of a triangular plate."),
'v3'    : ("float[3]", "Third vertex of a triangular plate."),
'pnear' : ("float[3]", "Nearest point on the plate to `point'."),
'dist'  : ("float", "Distance between `pnear' and `point'."),
}
CSPYCE_URL["pltnp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pltnp_c.html"
#########################################
CSPYCE_ARGNAMES["pltvol"] = ["vrtces", "plates"]
CSPYCE_RETNAMES["pltvol"] = ["volume"]
CSPYCE_ABSTRACT["pltvol"] = """
Compute the volume of a three-dimensional region bounded by a collection
of triangular plates.
"""
CSPYCE_DEFINITIONS["pltvol"] = {
'vrtces': ("float[*,3]", "Array of vertices."),
'plates': ("int[*,3]", "Array of plates defined by the indices of three vertices. Indices start at 1."),
'volume': ("float", "The volume of the spatial region bounded by the plates."),
}
CSPYCE_URL["pltvol"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pltvol_c.html"
#########################################
CSPYCE_ARGNAMES["pl2nvc"] = ["plane"]
CSPYCE_RETNAMES["pl2nvc"] = ["normal", "constant"]
CSPYCE_ABSTRACT["pl2nvc"] = """
Return a unit normal vector and constant that define a specified plane.
"""
CSPYCE_DEFINITIONS["pl2nvc"] = {
'plane' : ("float[4]", "A CSPICE plane."),
'normal': ("float[3]", "A unit normal vector defining the geometric plane."),
'constant': ("float", "The constant defining the geometric plane."),
}
CSPYCE_URL["pl2nvc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pl2nvc_c.html"
#########################################
CSPYCE_ARGNAMES["pl2nvp"] = ["plane"]
CSPYCE_RETNAMES["pl2nvp"] = ["normal", "point"]
CSPYCE_ABSTRACT["pl2nvp"] = """
Return a unit normal vector and point that define a specified plane.
"""
CSPYCE_DEFINITIONS["pl2nvp"] = {
'plane' : ("float[4]", "A CSPICE plane."),
'normal': ("float[3]", "A unit normal vector defining the geometric plane."),
'point' : ("float[3]", "A point on the geometric plane."),
}
CSPYCE_URL["pl2nvp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pl2nvp_c.html"
#########################################
CSPYCE_ARGNAMES["pl2psv"] = ["plane"]
CSPYCE_RETNAMES["pl2psv"] = ["point", "span1", "span2"]
CSPYCE_ABSTRACT["pl2psv"] = """
Return a point and two orthogonal spanning vectors that generate a
specified plane.
"""
CSPYCE_DEFINITIONS["pl2psv"] = {
'plane' : ("float[4]", "A CSPICE plane."),
'point' : ("float[3]", "A point in the input plane."),
'span1' : ("float[3]", "The first of two vectors spanning the input plane."),
'span2' : ("float[3]", "The second of two vectors spanning the input plane."),
}
CSPYCE_URL["pl2psv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pl2psv_c.html"
#########################################
CSPYCE_ARGNAMES["prop2b"] = ["gm", "pvinit", "dt"]
CSPYCE_RETNAMES["prop2b"] = ["pvprop"]
CSPYCE_ABSTRACT["prop2b"] = """
Given a central mass and the state of massless body at time t_0, this
routine determines the state as predicted by a two-body force model at
time t_0 + dt.
"""
CSPYCE_DEFINITIONS["prop2b"] = {
'gm'    : ("float", "Gravity of the central mass."),
'pvinit': ("float[6]", "Initial state from which to propagate a state."),
'dt'    : ("float", "Time offset from initial state to propagate to."),
'pvprop': ("float[6]", "The propagated state."),
}
CSPYCE_URL["prop2b"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/prop2b_c.html"
#########################################
CSPYCE_ARGNAMES["psv2pl"] = ["point", "span1", "span2"]
CSPYCE_RETNAMES["psv2pl"] = ["plane"]
CSPYCE_ABSTRACT["psv2pl"] = """
Make a CSPICE plane from a point and two spanning vectors.
"""
CSPYCE_DEFINITIONS["psv2pl"] = {
'point' : ("float[3]", "A point in the plane."),
'span1' : ("float[3]", "The first of two vectors spanning the plane."),
'span2' : ("float[3]", "The second of two vectors spanning the plane."),
'plane' : ("float[4]", "A CSPICE plane representing the plane."),
}
CSPYCE_URL["psv2pl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/psv2pl_c.html"
#########################################
CSPYCE_ARGNAMES["pxform"] = ["from", "to", "et"]
CSPYCE_RETNAMES["pxform"] = ["rotate"]
CSPYCE_ABSTRACT["pxform"] = """
Return the matrix that transforms position vectors from one specified
frame to another at a specified epoch.
"""
CSPYCE_DEFINITIONS["pxform"] = {
'from'  : ("frame_name", "Name of the frame to transform from."),
'to'    : ("frame_name", "Name of the frame to transform to."),
'et'    : ("time", "Epoch of the rotation matrix."),
'rotate': ("float[3,3]", "A rotation matrix."),
}
CSPYCE_URL["pxform"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pxform_c.html"
#########################################
CSPYCE_ARGNAMES["pxfrm2"] = ["from", "to", "etfrom", "etto"]
CSPYCE_RETNAMES["pxfrm2"] = ["rotate"]
CSPYCE_ABSTRACT["pxfrm2"] = """
Return the 3x3 matrix that transforms position vectors from one
specified frame at a specified epoch to another specified frame at
another specified epoch.
"""
CSPYCE_DEFINITIONS["pxfrm2"] = {
'from'  : ("frame_name", "Name of the frame to transform from."),
'to'    : ("frame_name", "Name of the frame to transform to."),
'etfrom': ("time", "Evaluation time of `from' frame."),
'etto'  : ("time", "Evaluation time of `to' frame."),
'rotate': ("float[3,3]", "A position transformation matrix from frame `from' to frame `to'."),
}
CSPYCE_URL["pxfrm2"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pxfrm2_c.html"
#########################################
CSPYCE_ARGNAMES["q2m"] = ["q"]
CSPYCE_RETNAMES["q2m"] = ["matrix"]
CSPYCE_ABSTRACT["q2m"] = """
Find the rotation matrix corresponding to a specified unit quaternion.
"""
CSPYCE_DEFINITIONS["q2m"] = {
'q'     : ("float[4]", "A unit quaternion."),
'matrix': ("float[3,3]", "A rotation matrix corresponding to q."),
}
CSPYCE_URL["q2m"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/q2m_c.html"
#########################################
CSPYCE_ARGNAMES["qcktrc"] = []
CSPYCE_RETNAMES["qcktrc"] = ["trace"]
CSPYCE_ABSTRACT["qcktrc"] = """
Return a string containing a traceback.
"""
CSPYCE_DEFINITIONS["qcktrc"] = {
'trace' : ("string", "A traceback string."),
}
CSPYCE_URL["qcktrc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/qcktrc_c.html"
#########################################
CSPYCE_ARGNAMES["qdq2av"] = ["q", "dq"]
CSPYCE_RETNAMES["qdq2av"] = ["av"]
CSPYCE_ABSTRACT["qdq2av"] = """
Derive angular velocity from a unit quaternion and its derivative with
respect to time.
"""
CSPYCE_DEFINITIONS["qdq2av"] = {
'q'     : ("float[4]", "Unit SPICE quaternion."),
'dq'    : ("float[4]", "Derivative of `q' with respect to time."),
'av'    : ("float[3]", "Angular velocity defined by `q' and `dq'."),
}
CSPYCE_URL["qdq2av"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/qdq2av_c.html"
#########################################
CSPYCE_ARGNAMES["qxq"] = ["q1", "q2"]
CSPYCE_RETNAMES["qxq"] = ["qout"]
CSPYCE_ABSTRACT["qxq"] = """
Multiply two quaternions.
"""
CSPYCE_DEFINITIONS["qxq"] = {
'q1'    : ("float[4]", "First SPICE quaternion factor."),
'q2'    : ("float[4]", "Second SPICE quaternion factor."),
'qout'  : ("float[4]", "Product of `q1' and `q2'."),
}
CSPYCE_URL["qxq"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/qxq_c.html"
#########################################
CSPYCE_ARGNAMES["radrec"] = ["range", "ra", "dec"]
CSPYCE_RETNAMES["radrec"] = ["rectan"]
CSPYCE_ABSTRACT["radrec"] = """
Convert from range, right ascension, and declination to rectangular
coordinates.
"""
CSPYCE_DEFINITIONS["radrec"] = {
'range' : ("float", "Distance of a point from the origin."),
'ra'    : ("float", "Right ascension of point in radians."),
'dec'   : ("float", "Declination of point in radians."),
'rectan': ("float[3]", "Rectangular coordinates of the point."),
}
CSPYCE_URL["radrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/radrec_c.html"
#########################################
CSPYCE_ARGNAMES["rav2xf"] = ["rot", "av"]
CSPYCE_RETNAMES["rav2xf"] = ["xform"]
CSPYCE_ABSTRACT["rav2xf"] = """
This routine determines from a state transformation matrix the
associated rotation matrix and angular velocity of the rotation.
"""
CSPYCE_DEFINITIONS["rav2xf"] = {
'rot'   : ("float[3,3]", "Rotation matrix."),
'av'    : ("float[3]", "Angular velocity vector."),
'xform' : ("float[6,6]", "State transformation associated with rot and av."),
}
CSPYCE_URL["rav2xf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/rav2xf_c.html"
#########################################
CSPYCE_ARGNAMES["raxisa"] = ["matrix"]
CSPYCE_RETNAMES["raxisa"] = ["axis", "angle"]
CSPYCE_ABSTRACT["raxisa"] = """
Compute the axis of the rotation given by an input matrix and the angle
of the rotation about that axis.
"""
CSPYCE_DEFINITIONS["raxisa"] = {
'matrix': ("float[3,3]", "3x3 rotation matrix."),
'axis'  : ("float[3]", "Axis of the rotation."),
'angle' : ("float", "Angle through which the rotation is performed."),
}
CSPYCE_URL["raxisa"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/raxisa_c.html"
#########################################
CSPYCE_ARGNAMES["reccyl"] = ["rectan"]
CSPYCE_RETNAMES["reccyl"] = ["r", "lon", "z"]
CSPYCE_ABSTRACT["reccyl"] = """
Convert from rectangular to cylindrical coordinates.
"""
CSPYCE_DEFINITIONS["reccyl"] = {
'rectan': ("float[3]", "Rectangular coordinates of a point."),
'r'     : ("float", "Distance of the point from z axis."),
'lon'   : ("float", "Angle (radians) of the point from XZ plane."),
'z'     : ("float", "Height of the point above XY plane."),
}
CSPYCE_URL["reccyl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reccyl_c.html"
#########################################
CSPYCE_ARGNAMES["recgeo"] = ["rectan", "re", "f"]
CSPYCE_RETNAMES["recgeo"] = ["lon", "lat", "alt"]
CSPYCE_ABSTRACT["recgeo"] = """
Convert from rectangular coordinates to geodetic coordinates.
"""
CSPYCE_DEFINITIONS["recgeo"] = {
'rectan': ("float[3]", "Rectangular coordinates of a point."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'lon'   : ("float", "Geodetic longitude of the point (radians)."),
'lat'   : ("float", "Geodetic latitude of the point (radians)."),
'alt'   : ("float", "Altitude of the point above reference spheroid."),
}
CSPYCE_URL["recgeo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/recgeo_c.html"
#########################################
CSPYCE_ARGNAMES["reclat"] = ["rectan"]
CSPYCE_RETNAMES["reclat"] = ["radius", "lon", "lat"]
CSPYCE_ABSTRACT["reclat"] = """
Convert from rectangular coordinates to latitudinal coordinates.
"""
CSPYCE_DEFINITIONS["reclat"] = {
'rectan': ("float[3]", "Rectangular coordinates of a point."),
'radius': ("float", "Distance of the point from the origin."),
'lon'   : ("float", "Longitude of the point in radians."),
'lat'   : ("float", "Latitude of the point in radians."),
}
CSPYCE_URL["reclat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reclat_c.html"
#########################################
CSPYCE_ARGNAMES["recpgr"] = ["body", "rectan", "re", "f"]
CSPYCE_RETNAMES["recpgr"] = ["lon", "lat", "alt"]
CSPYCE_ABSTRACT["recpgr"] = """
Convert rectangular coordinates to planetographic coordinates.
"""
CSPYCE_DEFINITIONS["recpgr"] = {
'body'  : ("body_name", "Body with which coordinate system is associated."),
'rectan': ("float[3]", "Rectangular coordinates of a point."),
're'    : ("float", "Equatorial radius of the reference spheroid."),
'f'     : ("float", "Flattening coefficient."),
'lon'   : ("float", "Planetographic longitude of the point (radians)."),
'lat'   : ("float", "Planetographic latitude of the point (radians)."),
'alt'   : ("float", "Altitude of the point above reference spheroid."),
}
CSPYCE_URL["recpgr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/recpgr_c.html"
#########################################
CSPYCE_ARGNAMES["recrad"] = ["rectan"]
CSPYCE_RETNAMES["recrad"] = ["range", "ra", "dec"]
CSPYCE_ABSTRACT["recrad"] = """
Convert rectangular coordinates to range, right ascension, and
declination.
"""
CSPYCE_DEFINITIONS["recrad"] = {
'rectan': ("float[3]", "Rectangular coordinates of a point."),
'range' : ("float", "Distance of the point from the origin."),
'ra'    : ("float", "Right ascension in radians."),
'dec'   : ("float", "Declination in radians."),
}
CSPYCE_URL["recrad"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/recrad_c.html"
#########################################
CSPYCE_ARGNAMES["recsph"] = ["rectan"]
CSPYCE_RETNAMES["recsph"] = ["r", "colat", "lon"]
CSPYCE_ABSTRACT["recsph"] = """
Convert from rectangular coordinates to spherical coordinates.
"""
CSPYCE_DEFINITIONS["recsph"] = {
'rectan': ("float[3]", "Rectangular coordinates of a point."),
'r'     : ("float", "Distance of the point from the origin."),
'colat' : ("float", "Angle of the point from the positive Z-axis."),
'lon'   : ("float", "Longitude of the point in radians."),
}
CSPYCE_URL["recsph"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/recsph_c.html"
#########################################
CSPYCE_ARGNAMES["refchg"] = ["frame1", "frame2", "et"]
CSPYCE_RETNAMES["refchg"] = ["rotate"]
CSPYCE_ABSTRACT["refchg"] = """
Return the transformation matrix from one frame to another.
"""
CSPYCE_DEFINITIONS["refchg"] = {
'frame1': ("frame_code", "The frame id-code for some reference frame."),
'frame2': ("frame_code", "The frame id-code for some reference frame."),
'et'    : ("time", "An epoch in TDB seconds past J2000."),
'rotate': ("float[3,3]", "A rotation matrix."),
}
CSPYCE_URL["refchg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/FORTRAN/spicelib/refchg.html"
#########################################
CSPYCE_ARGNAMES["repmc"] = ["in", "marker", "value"]
CSPYCE_RETNAMES["repmc"] = ["out"]
CSPYCE_ABSTRACT["repmc"] = """
Replace a marker with a character string.
"""
CSPYCE_DEFINITIONS["repmc"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("string", "Replacement value."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repmc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repmc_c.html"
#########################################
CSPYCE_ARGNAMES["repmct"] = ["in", "marker", "value", "repcase"]
CSPYCE_RETNAMES["repmct"] = ["out"]
CSPYCE_ABSTRACT["repmct"] = """
Replace a marker with the text representation of a cardinal number.
"""
CSPYCE_DEFINITIONS["repmct"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("int", "Replacement value."),
'repcase': ("string", "Case of replacement text: \"U\" for UPPPERCASE; \"L\" for lowercase; \"C\" for Capitalized."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repmct"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repmct_c.html"
#########################################
CSPYCE_ARGNAMES["repmd"] = ["in", "marker", "value", "sigdig"]
CSPYCE_RETNAMES["repmd"] = ["out"]
CSPYCE_ABSTRACT["repmd"] = """
Replace a marker with a floating-point number.
"""
CSPYCE_DEFINITIONS["repmd"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("float", "Replacement value."),
'sigdig': ("int", "Significant digits in replacement text."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repmd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repmd_c.html"
#########################################
CSPYCE_ARGNAMES["repmf"] = ["in", "marker", "value", "sigdig", "format"]
CSPYCE_RETNAMES["repmf"] = ["out"]
CSPYCE_ABSTRACT["repmf"] = """
Replace a marker in a string with a formatted floating-point value.
"""
CSPYCE_DEFINITIONS["repmf"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("float", "Replacement value."),
'sigdig': ("int", "Significant digits in replacement text."),
'format': ("string", "Format: 'E' or 'F'."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repmf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repmf_c.html"
#########################################
CSPYCE_ARGNAMES["repmi"] = ["in", "marker", "value"]
CSPYCE_RETNAMES["repmi"] = ["out"]
CSPYCE_ABSTRACT["repmi"] = """
Replace a marker with an integer.
"""
CSPYCE_DEFINITIONS["repmi"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("int", "Replacement value."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repmi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repmi_c.html"
#########################################
CSPYCE_ARGNAMES["repmot"] = ["in", "marker", "value", "repcase"]
CSPYCE_RETNAMES["repmot"] = ["out"]
CSPYCE_ABSTRACT["repmot"] = """
Replace a marker with the text representation of an ordinal number.
"""
CSPYCE_DEFINITIONS["repmot"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("int", "Replacement value."),
'repcase': ("string", "Case of replacement text: \"U\" for UPPERCASE; \"L\" for lowercase; \"C\" for Capitalized."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repmot"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repmot_c.html"
#########################################
CSPYCE_ARGNAMES["reset"] = []
CSPYCE_RETNAMES["reset"] = []
CSPYCE_ABSTRACT["reset"] = """
Reset the CSPICE error status to a value of "no error." as a result, the
status routine, failed, will return a value of False.
"""
CSPYCE_DEFINITIONS["reset"] = {
}
CSPYCE_URL["reset"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reset_c.html"
#########################################
CSPYCE_ARGNAMES["rotate"] = ["angle", "iaxis"]
CSPYCE_RETNAMES["rotate"] = ["matrix"]
CSPYCE_ABSTRACT["rotate"] = """
Calculate the 3x3 rotation matrix generated by a rotation of a specified
angle about a specified axis. This rotation is thought of as rotating
the coordinate system.
"""
CSPYCE_DEFINITIONS["rotate"] = {
'angle' : ("float", "Angle of rotation (radians)."),
'iaxis' : ("int", "Axis of rotation (X=1, Y=2, Z=3)."),
'matrix': ("float[3,3]", "Resulting rotation matrix [angle] iaxis."),
}
CSPYCE_URL["rotate"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/rotate_c.html"
#########################################
CSPYCE_ARGNAMES["rotmat"] = ["m1", "angle", "iaxis"]
CSPYCE_RETNAMES["rotmat"] = ["matrix"]
CSPYCE_ABSTRACT["rotmat"] = """
This function applies a rotation of angle radians about axis iaxis to a
matrix. This rotation is thought of as rotating the coordinate system.
"""
CSPYCE_DEFINITIONS["rotmat"] = {
'm1'    : ("float[3,3]", "Matrix to be rotated."),
'angle' : ("float", "Angle of rotation (radians)."),
'iaxis' : ("int", "Axis of rotation (X=1, Y=2, Z=3)."),
'matrix': ("float[3,3]", "Resulting rotated matrix."),
}
CSPYCE_URL["rotmat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/rotmat_c.html"
#########################################
CSPYCE_ARGNAMES["rotvec"] = ["v1", "angle", "iaxis"]
CSPYCE_RETNAMES["rotvec"] = ["vector"]
CSPYCE_ABSTRACT["rotvec"] = """
Transform a vector to a new coordinate system rotated by angle radians
about axis iaxis. This transformation rotates v1 by -angle radians about
the specified axis.
"""
CSPYCE_DEFINITIONS["rotvec"] = {
'v1'    : ("float[3]", "Vector whose coordinate system is to be rotated."),
'angle' : ("float", "Angle of rotation in radians."),
'iaxis' : ("int", "Axis of rotation (X=1, Y=2, Z=3)."),
'vector': ("float[3]", "Resulting vector [angle]."),
}
CSPYCE_URL["rotvec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/rotvec_c.html"
#########################################
CSPYCE_ARGNAMES["rpd"] = []
CSPYCE_RETNAMES["rpd"] = ["value"]
CSPYCE_ABSTRACT["rpd"] = """
Return the number of radians per degree.
"""
CSPYCE_DEFINITIONS["rpd"] = {
'value' : ("float", "The number of radians per degree."),
}
CSPYCE_URL["rpd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/rpd_c.html"
#########################################
CSPYCE_ARGNAMES["rquad"] = ["a", "b", "c"]
CSPYCE_RETNAMES["rquad"] = ["root1", "root2"]
CSPYCE_ABSTRACT["rquad"] = """
Find the roots of a quadratic equation.
"""
CSPYCE_DEFINITIONS["rquad"] = {
'a'     : ("float", "Coefficient of quadratic term."),
'b'     : ("float", "Coefficient of linear term."),
'c'     : ("float", "Constant."),
'root1' : ("float[2]", "Root built from positive discriminant term."),
'root2' : ("float[2]", "Root built from negative discriminant term."),
}
CSPYCE_URL["rquad"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/rquad_c.html"
#########################################
CSPYCE_ARGNAMES["saelgv"] = ["vec1", "vec2"]
CSPYCE_RETNAMES["saelgv"] = ["smajor", "sminor"]
CSPYCE_ABSTRACT["saelgv"] = """
Find semi-axis vectors of an ellipse generated by two arbitrary
three-dimensional vectors.
"""
CSPYCE_DEFINITIONS["saelgv"] = {
'vec1'  : ("float[3]", "First of two vectors used to generate an ellipse."),
'vec2'  : ("float[3]", "Second of two vectors used to generate an ellipse."),
'smajor': ("float[3]", "Semi-major axis of ellipse."),
'sminor': ("float[3]", "Semi-minor axis of ellipse."),
}
CSPYCE_URL["saelgv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/saelgv_c.html"
#########################################
CSPYCE_ARGNAMES["scdecd"] = ["sc", "sclkdp"]
CSPYCE_RETNAMES["scdecd"] = ["sclkch"]
CSPYCE_ABSTRACT["scdecd"] = """
Convert floating-point encoding of spacecraft clock time into a
character representation.
"""
CSPYCE_DEFINITIONS["scdecd"] = {
'sc'    : ("body_code", "NAIF spacecraft identification code."),
'sclkdp': ("float", "Encoded representation of a spacecraft clock count."),
'sclkch': ("string", "Character representation of a clock count."),
}
CSPYCE_URL["scdecd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/scdecd_c.html"
#########################################
CSPYCE_ARGNAMES["sce2c"] = ["sc", "et"]
CSPYCE_RETNAMES["sce2c"] = ["sclkdp"]
CSPYCE_ABSTRACT["sce2c"] = """
Convert ephemeris seconds past j2000 (ET) to continuous encoded
spacecraft clock (`ticks'). Non-integral tick values may be returned.
"""
CSPYCE_DEFINITIONS["sce2c"] = {
'sc'    : ("body_code", "NAIF spacecraft ID code."),
'et'    : ("time", "Ephemeris time, seconds past j2000."),
'sclkdp': ("float", "SCLK, encoded as ticks since spacecraft clock start. sclkdp need not be integral."),
}
CSPYCE_URL["sce2c"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sce2c_c.html"
#########################################
CSPYCE_ARGNAMES["sce2s"] = ["sc", "et"]
CSPYCE_RETNAMES["sce2s"] = ["sclkch"]
CSPYCE_ABSTRACT["sce2s"] = """
Convert an epoch specified as ephemeris seconds past J2000 (ET) to a
character string representation of a spacecraft clock value (SCLK).
"""
CSPYCE_DEFINITIONS["sce2s"] = {
'sc'    : ("body_code", "NAIF spacecraft clock ID code."),
'et'    : ("time", "Ephemeris time, specified as seconds past J2000."),
'sclkch': ("string", "An SCLK string."),
}
CSPYCE_URL["sce2s"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sce2s_c.html"
#########################################
CSPYCE_ARGNAMES["sce2t"] = ["sc", "et"]
CSPYCE_RETNAMES["sce2t"] = ["sclkdp"]
CSPYCE_ABSTRACT["sce2t"] = """
Convert ephemeris seconds past J2000 (ET) to integral encoded spacecraft
clock (`ticks'). For conversion to fractional ticks, (required for
C-kernel production), see the routine sce2c.
"""
CSPYCE_DEFINITIONS["sce2t"] = {
'sc'    : ("body_code", "NAIF spacecraft ID code."),
'et'    : ("time", "Ephemeris time, seconds past J2000."),
'sclkdp': ("float", "SCLK, encoded as ticks since spacecraft clock start."),
}
CSPYCE_URL["sce2t"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sce2t_c.html"
#########################################
CSPYCE_ARGNAMES["scencd"] = ["sc", "sclkch"]
CSPYCE_RETNAMES["scencd"] = ["sclkdp"]
CSPYCE_ABSTRACT["scencd"] = """
Encode character representation of spacecraft clock time into a
floating-point number.
"""
CSPYCE_DEFINITIONS["scencd"] = {
'sc'    : ("body_code", "NAIF spacecraft identification code."),
'sclkch': ("string", "Character representation of a spacecraft clock."),
'sclkdp': ("float", "Encoded representation of the clock count."),
}
CSPYCE_URL["scencd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/scencd_c.html"
#########################################
CSPYCE_ARGNAMES["scfmt"] = ["sc", "ticks"]
CSPYCE_RETNAMES["scfmt"] = ["clkstr"]
CSPYCE_ABSTRACT["scfmt"] = """
Convert encoded spacecraft clock ticks to character clock format.
"""
CSPYCE_DEFINITIONS["scfmt"] = {
'sc'    : ("body_code", "NAIF spacecraft identification code."),
'ticks' : ("float", "Encoded representation of a spacecraft clock count."),
'clkstr': ("string", "Character representation of a clock count."),
}
CSPYCE_URL["scfmt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/scfmt_c.html"
#########################################
CSPYCE_ARGNAMES["scpart"] = ["sc"]
CSPYCE_RETNAMES["scpart"] = ["pstart", "pstop"]
CSPYCE_ABSTRACT["scpart"] = """
Get spacecraft clock partition information from a spacecraft clock
kernel file.
"""
CSPYCE_DEFINITIONS["scpart"] = {
'sc'    : ("body_code", "NAIF spacecraft identification code."),
'pstart': ("float[*]", "Array of partition start times."),
'pstop' : ("float[*]", "Array of partition stop times."),
}
CSPYCE_URL["scpart"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/scpart_c.html"
#########################################
CSPYCE_ARGNAMES["scs2e"] = ["sc", "sclkch"]
CSPYCE_RETNAMES["scs2e"] = ["et"]
CSPYCE_ABSTRACT["scs2e"] = """
Convert a spacecraft clock string to ephemeris seconds past J2000 (ET).
"""
CSPYCE_DEFINITIONS["scs2e"] = {
'sc'    : ("body_code", "NAIF integer code for a spacecraft."),
'sclkch': ("string", "An SCLK string."),
'et'    : ("time", "Ephemeris time, seconds past J2000."),
}
CSPYCE_URL["scs2e"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/scs2e_c.html"
#########################################
CSPYCE_ARGNAMES["sct2e"] = ["sc", "sclkdp"]
CSPYCE_RETNAMES["sct2e"] = ["et"]
CSPYCE_ABSTRACT["sct2e"] = """
Convert encoded spacecraft clock (`ticks') to ephemeris seconds past
J2000 (ET).
"""
CSPYCE_DEFINITIONS["sct2e"] = {
'sc'    : ("body_code", "NAIF spacecraft ID code."),
'sclkdp': ("float", "SCLK, encoded as ticks since spacecraft clock start."),
'et'    : ("time", "Ephemeris time, seconds past J2000."),
}
CSPYCE_URL["sct2e"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sct2e_c.html"
#########################################
CSPYCE_ARGNAMES["sctiks"] = ["sc", "clkstr"]
CSPYCE_RETNAMES["sctiks"] = ["ticks"]
CSPYCE_ABSTRACT["sctiks"] = """
Convert a spacecraft clock format string to number of "ticks".
"""
CSPYCE_DEFINITIONS["sctiks"] = {
'sc'    : ("body_code", "NAIF spacecraft identification code."),
'clkstr': ("string", "Character representation of a spacecraft clock."),
'ticks' : ("float", "Number of ticks represented by the clock string."),
}
CSPYCE_URL["sctiks"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sctiks_c.html"
#########################################
CSPYCE_ARGNAMES["setmsg"] = ["message"]
CSPYCE_RETNAMES["setmsg"] = []
CSPYCE_ABSTRACT["setmsg"] = """
Set the value of the current long error message.
"""
CSPYCE_DEFINITIONS["setmsg"] = {
'message': ("string", "A long error message."),
}
CSPYCE_URL["setmsg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/setmsg_c.html"
#########################################
CSPYCE_ARGNAMES["sigerr"] = ["msg"]
CSPYCE_RETNAMES["sigerr"] = []
CSPYCE_ABSTRACT["sigerr"] = """
Inform the CSPICE error processing mechanism that an error has occurred,
and specify the type of error.
"""
CSPYCE_DEFINITIONS["sigerr"] = {
'msg'   : ("string", "A short error message."),
}
CSPYCE_URL["sigerr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sigerr_c.html"
#########################################
CSPYCE_ARGNAMES["sincpt"] = ["method", "target", "et", "fixref", "abcorr", "obsrvr", "dref", "dvec"]
CSPYCE_RETNAMES["sincpt"] = ["spoint", "trgepc", "srfvec", "found"]
CSPYCE_ABSTRACT["sincpt"] = """
Given an observer and a direction vector defining a ray, compute the
surface intercept of the ray on a target body at a specified epoch,
optionally corrected for light time and stellar aberration.

The surface of the target body may be represented by a triaxial
ellipsoid or by topographic data provided by DSK files.

This routine supersedes srfxpt.
"""
CSPYCE_DEFINITIONS["sincpt"] = {
'method': ("string", "Computation method: \"ELLIPSOID\" or \"DSK/UNPRIORITIZED[/SURFACES = <surface list>]\"."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'dref'  : ("frame_name", "Reference frame of ray's direction vector."),
'dvec'  : ("float[3]", "Ray's direction vector."),
'spoint': ("float[3]", "Surface intercept point on the target body."),
'trgepc': ("time", "Intercept epoch."),
'srfvec': ("float[3]", "Vector from observer to intercept point."),
'found' : ("bool", "Flag indicating whether intercept was found."),
}
CSPYCE_URL["sincpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sincpt_c.html"
#########################################
CSPYCE_ARGNAMES["spd"] = []
CSPYCE_RETNAMES["spd"] = ["value"]
CSPYCE_ABSTRACT["spd"] = """
Return the number of seconds in a day.
"""
CSPYCE_DEFINITIONS["spd"] = {
'value' : ("float", "The number of seconds in a day."),
}
CSPYCE_URL["spd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spd_c.html"
#########################################
CSPYCE_ARGNAMES["sphcyl"] = ["radius", "colat", "lon"]
CSPYCE_RETNAMES["sphcyl"] = ["r", "lon2", "z"]
CSPYCE_ABSTRACT["sphcyl"] = """
This routine converts from spherical coordinates to cylindrical
coordinates.
"""
CSPYCE_DEFINITIONS["sphcyl"] = {
'radius': ("float", "Distance of point from origin."),
'colat' : ("float", "Polar angle (co-latitude in radians) of point."),
'lon'   : ("float", "Azimuthal angle (longitude) of point (radians)."),
'r'     : ("float", "Distance of point from z axis."),
'lon2'  : ("float", "angle (radians) of point from XZ plane."),
'z'     : ("float", "Height of point above XY plane."),
}
CSPYCE_URL["sphcyl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sphcyl_c.html"
#########################################
CSPYCE_ARGNAMES["sphlat"] = ["r", "colat", "lon"]
CSPYCE_RETNAMES["sphlat"] = ["radius", "lon2", "lat"]
CSPYCE_ABSTRACT["sphlat"] = """
Convert from spherical coordinates to latitudinal coordinates.
"""
CSPYCE_DEFINITIONS["sphlat"] = {
'r'     : ("float", "Distance of the point from the origin."),
'colat' : ("float", "Angle of the point from positive z axis (radians)."),
'lon'   : ("float", "Angle of the point from the XZ plane (radians)."),
'radius': ("float", "Distance of a point from the origin."),
'lon2'  : ("float", "Angle of the point from the XZ plane in radians."),
'lat'   : ("float", "Angle of the point from the XY plane in radians."),
}
CSPYCE_URL["sphlat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sphlat_c.html"
#########################################
CSPYCE_ARGNAMES["sphrec"] = ["r", "colat", "lon"]
CSPYCE_RETNAMES["sphrec"] = ["rectan"]
CSPYCE_ABSTRACT["sphrec"] = """
Convert from spherical coordinates to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["sphrec"] = {
'r'     : ("float", "Distance of a point from the origin."),
'colat' : ("float", "Angle of the point from the positive Z-axis."),
'lon'   : ("float", "Angle of the point from the XZ plane in radians."),
'rectan': ("float[3]", "Rectangular coordinates of the point."),
}
CSPYCE_URL["sphrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sphrec_c.html"
#########################################
CSPYCE_ARGNAMES["spkacs"] = ["targ", "et", "ref", "abcorr", "obs"]
CSPYCE_RETNAMES["spkacs"] = ["starg", "lt", "dlt"]
CSPYCE_ABSTRACT["spkacs"] = """
Return the state (position and velocity) of a target body relative to an
observer, optionally corrected for light time and stellar aberration,
expressed relative to an inertial reference frame.
"""
CSPYCE_DEFINITIONS["spkacs"] = {
'targ'  : ("body_code", "Target body."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Inertial reference frame of output state."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obs'   : ("body_code", "Observer."),
'starg' : ("float[6]", "State of target."),
'lt'    : ("float", "One way light time between observer and target."),
'dlt'   : ("float", "Derivative of light time with respect to time."),
}
CSPYCE_URL["spkacs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkacs_c.html"
#########################################
CSPYCE_ARGNAMES["spkapo"] = ["targ", "et", "ref", "sobs", "abcorr"]
CSPYCE_RETNAMES["spkapo"] = ["ptarg", "lt"]
CSPYCE_ABSTRACT["spkapo"] = """
Return the position of a target body relative to an observer, optionally
corrected for light time and stellar aberration.
"""
CSPYCE_DEFINITIONS["spkapo"] = {
'targ'  : ("body_code", "Target body."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Inertial reference frame of observer's state."),
'sobs'  : ("float[6]", "State of observer wrt. solar system barycenter."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'ptarg' : ("float[3]", "Position of target."),
'lt'    : ("float", "One way light time between observer and target."),
}
CSPYCE_URL["spkapo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkapo_c.html"
#########################################
CSPYCE_ARGNAMES["spkapp"] = ["targ", "et", "ref", "sobs", "abcorr"]
CSPYCE_RETNAMES["spkapp"] = ["starg", "lt"]
CSPYCE_ABSTRACT["spkapp"] = """
Return the state (position and velocity) of a target body relative to an
observer, optionally corrected for light time and stellar aberration.

WARNING: For aberration-corrected states, the velocity is not precisely
equal to the time derivative of the position. Use spkaps instead.
"""
CSPYCE_DEFINITIONS["spkapp"] = {
'targ'  : ("body_code", "Target body."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Inertial reference frame of observer's state."),
'sobs'  : ("float[6]", "State of observer wrt. solar system barycenter."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'starg' : ("float[6]", "State of target."),
'lt'    : ("float", "One way light time between observer and target."),
}
CSPYCE_URL["spkapp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkapp_c.html"
#########################################
CSPYCE_ARGNAMES["spkaps"] = ["targ", "et", "ref", "abcorr", "stobs", "accobs"]
CSPYCE_RETNAMES["spkaps"] = ["starg", "lt", "dlt"]
CSPYCE_ABSTRACT["spkaps"] = """
Given the state and acceleration of an observer relative to the solar
system barycenter, return the state (position and velocity) of a target
body relative to the observer, optionally corrected for light time and
stellar aberration. All input and output vectors are expressed relative
to an inertial reference frame.

This routine supersedes spkapp.

SPICE users normally should call the high-level API routines spkezr or
spkez rather than this routine.
"""
CSPYCE_DEFINITIONS["spkaps"] = {
'targ'  : ("body_code", "Target body."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Inertial reference frame of output state."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'stobs' : ("float[6]", "State of the observer relative to the SSB."),
'accobs': ("float[3]", "Acceleration of the observer relative to the SSB."),
'starg' : ("float[6]", "State of target."),
'lt'    : ("float", "One way light time between observer and target."),
'dlt'   : ("float", "Derivative of light time with respect to time."),
}
CSPYCE_URL["spkaps"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkaps_c.html"
#########################################
CSPYCE_ARGNAMES["spkcov"] = ["spk", "idcode"]
CSPYCE_RETNAMES["spkcov"] = ["cover"]
CSPYCE_ABSTRACT["spkcov"] = """
Find the coverage window for a specified ephemeris object in a specified
SPK file.
"""
CSPYCE_DEFINITIONS["spkcov"] = {
'spk'   : ("string", "Name of SPK file."),
'idcode': ("body_code", "ID code of ephemeris object."),
'cover' : ("time[*,2]", "Array giving start/stop time pairs for the intervals covered."),
}
CSPYCE_URL["spkcov"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkcov_c.html"
#########################################
CSPYCE_ARGNAMES["spkez"] = ["targ", "et", "ref", "abcorr", "obs"]
CSPYCE_RETNAMES["spkez"] = ["starg", "lt"]
CSPYCE_ABSTRACT["spkez"] = """
Return the state (position and velocity) of a target body relative to an
observing body, optionally corrected for light time (planetary
aberration) and stellar aberration.
"""
CSPYCE_DEFINITIONS["spkez"] = {
'targ'  : ("body_code", "Target body."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Reference frame of output state vector."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obs'   : ("body_code", "Observing body."),
'starg' : ("float[6]", "State of target."),
'lt'    : ("float", "One way light time between observer and target."),
}
CSPYCE_URL["spkez"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkez_c.html"
#########################################
CSPYCE_ARGNAMES["spkezp"] = ["targ", "et", "ref", "abcorr", "obs"]
CSPYCE_RETNAMES["spkezp"] = ["ptarg", "lt"]
CSPYCE_ABSTRACT["spkezp"] = """
Return the position of a target body relative to an observing body,
optionally corrected for light time (planetary aberration) and stellar
aberration.
"""
CSPYCE_DEFINITIONS["spkezp"] = {
'targ'  : ("body_code", "Target body NAIF ID code."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Reference frame of output position vector."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obs'   : ("body_code", "Observing body NAIF ID code."),
'ptarg' : ("float[3]", "Position of target."),
'lt'    : ("float", "One way light time between observer and target."),
}
CSPYCE_URL["spkezp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkezp_c.html"
#########################################
CSPYCE_ARGNAMES["spkezr"] = ["targ", "et", "ref", "abcorr", "obs"]
CSPYCE_RETNAMES["spkezr"] = ["starg", "lt"]
CSPYCE_ABSTRACT["spkezr"] = """
Return the state (position and velocity) of a target body relative to an
observing body, optionally corrected for light time (planetary
aberration) and stellar aberration.
"""
CSPYCE_DEFINITIONS["spkezr"] = {
'targ'  : ("body_name", "Target body name."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Reference frame of output state vector."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obs'   : ("body_name", "Observing body name."),
'starg' : ("float[6]", "State of target."),
'lt'    : ("float", "One way light time between observer and target."),
}
CSPYCE_URL["spkezr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkezr_c.html"
#########################################
CSPYCE_ARGNAMES["spkgeo"] = ["targ", "et", "ref", "obs"]
CSPYCE_RETNAMES["spkgeo"] = ["state", "lt"]
CSPYCE_ABSTRACT["spkgeo"] = """
Compute the geometric state (position and velocity) of a target body
relative to an observing body.
"""
CSPYCE_DEFINITIONS["spkgeo"] = {
'targ'  : ("body_code", "Target body code."),
'et'    : ("time", "Target epoch."),
'ref'   : ("frame_name", "Target reference frame name."),
'obs'   : ("body_code", "Observing body code."),
'state' : ("float[6]", "State of target."),
'lt'    : ("float", "Light time."),
}
CSPYCE_URL["spkgeo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkgeo_c.html"
#########################################
CSPYCE_ARGNAMES["spkgps"] = ["targ", "et", "ref", "obs"]
CSPYCE_RETNAMES["spkgps"] = ["pos", "lt"]
CSPYCE_ABSTRACT["spkgps"] = """
Compute the geometric position of a target body relative to an observing
body.
"""
CSPYCE_DEFINITIONS["spkgps"] = {
'targ'  : ("body_code", "Target body code."),
'et'    : ("time", "Target epoch."),
'ref'   : ("frame_name", "Target reference frame name."),
'obs'   : ("body_code", "Observing body code."),
'pos'   : ("float[3]", "Position of target."),
'lt'    : ("float", "Light time."),
}
CSPYCE_URL["spkgps"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkgps_c.html"
#########################################
CSPYCE_ARGNAMES["spkltc"] = ["targ", "et", "ref", "abcorr", "stobs"]
CSPYCE_RETNAMES["spkltc"] = ["starg", "lt", "dlt"]
CSPYCE_ABSTRACT["spkltc"] = """
Return the state (position and velocity) of a target body relative to an
observer, optionally corrected for light time, expressed relative to an
inertial reference frame.
"""
CSPYCE_DEFINITIONS["spkltc"] = {
'targ'  : ("body_code", "Target body code."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Inertial reference frame name of output state."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'stobs' : ("float[6]", "State of the observer relative to the SSB."),
'starg' : ("float[6]", "State of target."),
'lt'    : ("float", "One way light time between observer and target."),
'dlt'   : ("float", "Derivative of light time with respect to time."),
}
CSPYCE_URL["spkltc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkltc_c.html"
#########################################
CSPYCE_ARGNAMES["spkobj"] = ["spk"]
CSPYCE_RETNAMES["spkobj"] = ["ids"]
CSPYCE_ABSTRACT["spkobj"] = """
Find the set of ID codes of all objects in a specified SPK file.
"""
CSPYCE_DEFINITIONS["spkobj"] = {
'spk'   : ("string", "Name of SPK file."),
'ids'   : ("body_code[*]", "Array of ID codes of objects in SPK file."),
}
CSPYCE_URL["spkobj"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkobj_c.html"
#########################################
CSPYCE_ARGNAMES["spkpos"] = ["targ", "et", "ref", "abcorr", "obs"]
CSPYCE_RETNAMES["spkpos"] = ["ptarg", "lt"]
CSPYCE_ABSTRACT["spkpos"] = """
Return the position of a target body relative to an observing body,
optionally corrected for light time (planetary aberration) and stellar
aberration.
"""
CSPYCE_DEFINITIONS["spkpos"] = {
'targ'  : ("body_name", "Target body name."),
'et'    : ("time", "Observer epoch."),
'ref'   : ("frame_name", "Reference frame of output position vector."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obs'   : ("body_name", "Observing body name."),
'ptarg' : ("float[3]", "Position of target."),
'lt'    : ("float", "One way light time between observer and target."),
}
CSPYCE_URL["spkpos"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkpos_c.html"
#########################################
CSPYCE_ARGNAMES["spkssb"] = ["targ", "et", "ref"]
CSPYCE_RETNAMES["spkssb"] = ["starg"]
CSPYCE_ABSTRACT["spkssb"] = """
Return the state (position and velocity) of a target body relative to
the solar system barycenter.
"""
CSPYCE_DEFINITIONS["spkssb"] = {
'targ'  : ("body_code", "Target body code."),
'et'    : ("time", "Target epoch."),
'ref'   : ("frame_name", "Target reference frame name."),
'starg' : ("float[6]", "State of target."),
}
CSPYCE_URL["spkssb"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkssb_c.html"
#########################################
CSPYCE_ARGNAMES["srfc2s"] = ["code", "bodyid"]
CSPYCE_RETNAMES["srfc2s"] = ["srfstr", "isname"]
CSPYCE_ABSTRACT["srfc2s"] = """
Translate a surface ID code, together with a body ID code, to the
corresponding surface name. If no such name exists, return a string
representation of the surface ID code.
"""
CSPYCE_DEFINITIONS["srfc2s"] = {
'code'  : ("surface_code", "Integer surface ID code to translate to a string."),
'bodyid': ("body_code", "ID code of body associated with surface."),
'srfstr': ("surface_name", "String corresponding to surface ID code."),
'isname': ("bool", "Logical flag indicating output is a surface name."),
}
CSPYCE_URL["srfc2s"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfc2s_c.html"
#########################################
CSPYCE_ARGNAMES["srfcss"] = ["code", "bodstr"]
CSPYCE_RETNAMES["srfcss"] = ["srfstr", "isname"]
CSPYCE_ABSTRACT["srfcss"] = """
Translate a surface ID code, together with a body string, to the
corresponding surface name. If no such surface name exists, return a
string representation of the surface ID code.
"""
CSPYCE_DEFINITIONS["srfcss"] = {
'code'  : ("surface_code", "Integer surface ID code to translate to a string."),
'bodstr': ("body_name", "Name or ID of body associated with surface."),
'srfstr': ("surface_name", "String corresponding to surface ID code."),
'isname': ("bool", "Flag indicating whether output is a surface name."),
}
CSPYCE_URL["srfcss"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfcss_c.html"
#########################################
CSPYCE_ARGNAMES["srfnrm"] = ["method", "target", "et", "fixref", "srfpts"]
CSPYCE_RETNAMES["srfnrm"] = ["normls"]
CSPYCE_ABSTRACT["srfnrm"] = """
Map array of surface points on a specified target body to the
corresponding unit length outward surface normal vectors.

The surface of the target body may be represented by a triaxial
ellipsoid or by topographic data provided by DSK files.
"""
CSPYCE_DEFINITIONS["srfnrm"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'srfpts': ("float[*,3]", "Array of surface points."),
'normls': ("float[*,3]", "Array of outward, unit length normal vectors."),
}
CSPYCE_URL["srfnrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfnrm_c.html"
#########################################
CSPYCE_ARGNAMES["srfrec"] = ["body", "lon", "lat"]
CSPYCE_RETNAMES["srfrec"] = ["rectan"]
CSPYCE_ABSTRACT["srfrec"] = """
Convert planetocentric latitude and longitude of a surface point on a
specified body to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["srfrec"] = {
'body'  : ("body_code", "NAIF integer code of an extended body."),
'lon'   : ("float", "Longitude of point in radians."),
'lat'   : ("float", "Latitude of point in radians."),
'rectan': ("float[3]", "Rectangular coordinates of the point."),
}
CSPYCE_URL["srfrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfrec_c.html"
#########################################
CSPYCE_ARGNAMES["srfs2c"] = ["srfstr", "bodstr"]
CSPYCE_RETNAMES["srfs2c"] = ["code", "found"]
CSPYCE_ABSTRACT["srfs2c"] = """
Translate a surface string, together with a body string, to the
corresponding surface ID code. The input strings may contain names or
integer ID codes.
"""
CSPYCE_DEFINITIONS["srfs2c"] = {
'srfstr': ("surface_name", "Surface name or ID string."),
'bodstr': ("body_name", "Body name or ID string."),
'code'  : ("surface_code", "Integer surface ID code."),
'found' : ("bool", "Flag indicating whether surface ID was found."),
}
CSPYCE_URL["srfs2c"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfs2c_c.html"
#########################################
CSPYCE_ARGNAMES["srfscc"] = ["srfstr", "bodyid"]
CSPYCE_RETNAMES["srfscc"] = ["code", "found"]
CSPYCE_ABSTRACT["srfscc"] = """
Translate a surface string, together with a body ID code, to the
corresponding surface ID code. The input surface string may contain a
name or an integer ID code.
"""
CSPYCE_DEFINITIONS["srfscc"] = {
'srfstr': ("surface_name", "Surface name or ID string."),
'bodyid': ("body_code", "Body ID code."),
'code'  : ("surface_code", "Integer surface ID code."),
'found' : ("bool", "Flag indicating whether surface ID was found."),
}
CSPYCE_URL["srfscc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfscc_c.html"
#########################################
CSPYCE_ARGNAMES["srfxpt"] = ["method", "target", "et", "abcorr", "obsrvr", "dref", "dvec"]
CSPYCE_RETNAMES["srfxpt"] = ["spoint", "dist", "trgepc", "obspos", "found"]
CSPYCE_ABSTRACT["srfxpt"] = """
Given an observer and a direction vector defining a ray, compute the
surface intercept point of the ray on a target body at a specified
epoch, optionally corrected for light time and stellar aberration.
"""
CSPYCE_DEFINITIONS["srfxpt"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'dref'  : ("frame_name", "Reference frame of input direction vector."),
'dvec'  : ("float[3]", "Ray's direction vector."),
'spoint': ("float[3]", "Surface intercept point on the target body."),
'dist'  : ("float", "Distance from the observer to the intercept point."),
'trgepc': ("time", "Intercept epoch."),
'obspos': ("float[3]", "Observer position relative to target center."),
'found' : ("bool", "Flag indicating whether intercept was found."),
}
CSPYCE_URL["srfxpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/srfxpt_c.html"
#########################################
CSPYCE_ARGNAMES["stcf01"] = ["catnam", "westra", "eastra", "sthdec", "nthdec"]
CSPYCE_RETNAMES["stcf01"] = ["nstars"]
CSPYCE_ABSTRACT["stcf01"] = """
Search through a type 1 star catalog and return the number of stars
within a specified RA - DEC rectangle.
"""
CSPYCE_DEFINITIONS["stcf01"] = {
'catnam': ("string", "Catalog table name."),
'westra': ("float", "Western most right ascension in radians."),
'eastra': ("float", "Eastern most right ascension in radians."),
'sthdec': ("float", "Southern most declination in radians."),
'nthdec': ("float", "Northern most declination in radians."),
'nstars': ("int", "Number of stars found."),
}
CSPYCE_URL["stcf01"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/FORTRAN/spicelib/stcf01.html"
#########################################
CSPYCE_ARGNAMES["stcg01"] = ["index"]
CSPYCE_RETNAMES["stcg01"] = ["ra", "dec", "rasig", "decsig", "catnum", "sptype", "vmag"]
CSPYCE_ABSTRACT["stcg01"] = """
Get data for a single star from a SPICE type 1 star catalog.
"""
CSPYCE_DEFINITIONS["stcg01"] = {
'index' : ("int", "Star index."),
'ra'    : ("float", "Right ascension in radians."),
'dec'   : ("float", "Declination in radians."),
'rasig' : ("float", "Right ascension uncertainty in radians."),
'decsig': ("float", "Declination uncertainty in radians."),
'catnum': ("int", "Catalog number."),
'sptype': ("string", "Spectral type."),
'vmag'  : ("float", "Visual magnitude."),
}
CSPYCE_URL["stcg01"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/FORTRAN/spicelib/stcg01.html"
#########################################
CSPYCE_ARGNAMES["stcl01"] = ["catfnm"]
CSPYCE_RETNAMES["stcl01"] = ["tabnam", "handle"]
CSPYCE_ABSTRACT["stcl01"] = """
Load SPICE type 1 star catalog and return the catalog's table name.
"""
CSPYCE_DEFINITIONS["stcl01"] = {
'catfnm': ("string", "Catalog file name."),
'tabnam': ("string", "Catalog table name."),
'handle': ("int", "Catalog file handle."),
}
CSPYCE_URL["stcl01"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/FORTRAN/spicelib/stcl01.html"
#########################################
CSPYCE_ARGNAMES["stelab"] = ["pobj", "vobs"]
CSPYCE_RETNAMES["stelab"] = ["appobj"]
CSPYCE_ABSTRACT["stelab"] = """
Correct the apparent position of an object for stellar aberration.
"""
CSPYCE_DEFINITIONS["stelab"] = {
'pobj'  : ("float[3]", "Position of an object with respect to the observer."),
'vobs'  : ("float[3]", "Velocity of the observer with respect to the Solar System barycenter."),
'appobj': ("float[3]", "Apparent position of the object with respect to the observer, corrected for stellar aberration."),
}
CSPYCE_URL["stelab"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/stelab_c.html"
#########################################
CSPYCE_ARGNAMES["stlabx"] = ["pobj", "vobs"]
CSPYCE_RETNAMES["stlabx"] = ["corpos"]
CSPYCE_ABSTRACT["stlabx"] = """
Correct the position of a target for the stellar aberration effect on
radiation transmitted from a specified observer to the target.
"""
CSPYCE_DEFINITIONS["stlabx"] = {
'pobj'  : ("float[3]", "Position of an object with respect to the observer."),
'vobs'  : ("float[3]", "Velocity of the observer with respect to the Solar System barycenter."),
'corpos': ("float[3]", "Corrected position of the object."),
}
CSPYCE_URL["stlabx"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/stlabx_c.html"
#########################################
CSPYCE_ARGNAMES["stpool"] = ["item", "nth", "contin"]
CSPYCE_RETNAMES["stpool"] = ["string", "found"]
CSPYCE_ABSTRACT["stpool"] = """
Retrieve the nth string from the kernel pool variable, where the string
may be continued across several components of the kernel pool variable.
"""
CSPYCE_DEFINITIONS["stpool"] = {
'item'  : ("string", "Name of the kernel pool variable."),
'nth'   : ("int", "Index of the full string to retrieve."),
'contin': ("string", "Character sequence used to indicate continuation."),
'string': ("string", "A full string concatenated across continuations."),
'found' : ("bool", "Flag indicating success or failure of request."),
}
CSPYCE_URL["stpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/stpool_c.html"
#########################################
CSPYCE_ARGNAMES["str2et"] = ["str"]
CSPYCE_RETNAMES["str2et"] = ["et"]
CSPYCE_ABSTRACT["str2et"] = """
Convert a string representing an epoch to a floating-point value
representing the number of TDB seconds past the J2000 epoch
corresponding to the input epoch.
"""
CSPYCE_DEFINITIONS["str2et"] = {
'str'   : ("string", "A string representing an epoch."),
'et'    : ("time", "The equivalent value in seconds past J2000, TDB."),
}
CSPYCE_URL["str2et"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/str2et_c.html"
#########################################
CSPYCE_ARGNAMES["subpnt"] = ["method", "target", "et", "fixref", "abcorr", "obsrvr"]
CSPYCE_RETNAMES["subpnt"] = ["spoint", "trgepc", "srfvec"]
CSPYCE_ABSTRACT["subpnt"] = """
Compute the rectangular coordinates of the sub-observer point on a
target body at a specified epoch, optionally corrected for light time
and stellar aberration.

The surface of the target body may be represented by a triaxial
ellipsoid or by topographic data provided by DSK files.

This routine supersedes subpt.
"""
CSPYCE_DEFINITIONS["subpnt"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in TDB seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Sub-observer point on the target body."),
'trgepc': ("time", "Sub-observer point epoch."),
'srfvec': ("float[3]", "Vector from observer to sub-observer point."),
}
CSPYCE_URL["subpnt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/subpnt_c.html"
#########################################
CSPYCE_ARGNAMES["subpt"] = ["method", "target", "et", "abcorr", "obsrvr"]
CSPYCE_RETNAMES["subpt"] = ["spoint", "alt"]
CSPYCE_ABSTRACT["subpt"] = """
Compute the rectangular coordinates of the sub-observer point on a
target body at a particular epoch, optionally corrected for planetary
(light time) and stellar aberration. Return these coordinates expressed
in the body-fixed frame associated with the target body. Also, return
the observer's altitude above the target body.
"""
CSPYCE_DEFINITIONS["subpt"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Sub-observer point on the target body."),
'alt'   : ("float", "Altitude of the observer above the target body."),
}
CSPYCE_URL["subpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/subpt_c.html"
#########################################
CSPYCE_ARGNAMES["subslr"] = ["method", "target", "et", "fixref", "abcorr", "obsrvr"]
CSPYCE_RETNAMES["subslr"] = ["spoint", "trgepc", "srfvec"]
CSPYCE_ABSTRACT["subslr"] = """
Compute the rectangular coordinates of the sub-solar point on a target
body at a specified epoch, optionally corrected for light time and
stellar aberration.

The surface of the target body may be represented by a triaxial
ellipsoid or by topographic data provided by DSK files.

This routine supersedes subsol.
"""
CSPYCE_DEFINITIONS["subslr"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Sub-solar point on the target body."),
'trgepc': ("time", "Sub-solar point epoch."),
'srfvec': ("float[3]", "Vector from observer to sub-solar point."),
}
CSPYCE_URL["subslr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/subslr_c.html"
#########################################
CSPYCE_ARGNAMES["subsol"] = ["method", "target", "et", "abcorr", "obsrvr"]
CSPYCE_RETNAMES["subsol"] = ["spoint"]
CSPYCE_ABSTRACT["subsol"] = """
Determine the coordinates of the sub-solar point on a target body as
seen by a specified observer at a specified epoch, optionally corrected
for planetary (light time) and stellar aberration.
"""
CSPYCE_DEFINITIONS["subsol"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'obsrvr': ("body_name", "Name of observing body."),
'spoint': ("float[3]", "Sub-solar point on the target body."),
}
CSPYCE_URL["subsol"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/subsol_c.html"
#########################################
CSPYCE_ARGNAMES["surfnm"] = ["a", "b", "c", "point"]
CSPYCE_RETNAMES["surfnm"] = ["normal"]
CSPYCE_ABSTRACT["surfnm"] = """
This routine computes the outward-pointing, unit normal vector from a
point on the surface of an ellipsoid.
"""
CSPYCE_DEFINITIONS["surfnm"] = {
'a'     : ("float", "Length of the ellisoid semi-axis along the x-axis."),
'b'     : ("float", "Length of the ellisoid semi-axis along the y-axis."),
'c'     : ("float", "Length of the ellisoid semi-axis along the z-axis."),
'point' : ("float[3]", "Body-fixed coordinates of a point on the ellipsoid."),
'normal': ("float[3]", "Outward pointing unit normal to ellipsoid at point."),
}
CSPYCE_URL["surfnm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/surfnm_c.html"
#########################################
CSPYCE_ARGNAMES["surfpt"] = ["positn", "u", "a", "b", "c"]
CSPYCE_RETNAMES["surfpt"] = ["point", "found"]
CSPYCE_ABSTRACT["surfpt"] = """
Determine the intersection of a line-of-sight vector with the surface of
an ellipsoid.
"""
CSPYCE_DEFINITIONS["surfpt"] = {
'positn': ("float[3]", "Position of the observer in body-fixed frame."),
'u'     : ("float[3]", "Vector from the observer in some direction."),
'a'     : ("float", "Length of the ellipsoid semi-axis along the x-axis."),
'b'     : ("float", "Length of the ellipsoid semi-axis along the y-axis."),
'c'     : ("float", "Length of the ellipsoid semi-axis along the z-axis."),
'point' : ("float[3]", "Point on the ellipsoid pointed to by u."),
'found' : ("bool", "Flag indicating if u points at the ellipsoid."),
}
CSPYCE_URL["surfpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/surfpt_c.html"
#########################################
CSPYCE_ARGNAMES["surfpv"] = ["stvrtx", "stdir", "a", "b", "c"]
CSPYCE_RETNAMES["surfpv"] = ["stx", "found"]
CSPYCE_ABSTRACT["surfpv"] = """
Find the state (position and velocity) of the surface intercept defined
by a specified ray, ray velocity, and ellipsoid.
"""
CSPYCE_DEFINITIONS["surfpv"] = {
'stvrtx': ("float[6]", "State of ray's vertex."),
'stdir' : ("float[6]", "State of ray's direction vector."),
'a'     : ("float", "Length of ellipsoid semi-axis along the x-axis."),
'b'     : ("float", "Length of ellipsoid semi-axis along the y-axis."),
'c'     : ("float", "Length of ellipsoid semi-axis along the z-axis."),
'stx'   : ("float[6]", "State of surface intercept."),
'found' : ("bool", "Flag indicating whether intercept state was found."),
}
CSPYCE_URL["surfpv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/surfpv_c.html"
#########################################
CSPYCE_ARGNAMES["sxform"] = ["from", "to", "et"]
CSPYCE_RETNAMES["sxform"] = ["xform"]
CSPYCE_ABSTRACT["sxform"] = """
Return the state transformation matrix from one frame to another at a
specified epoch.
"""
CSPYCE_DEFINITIONS["sxform"] = {
'from'  : ("string", "Name of the frame to transform from."),
'to'    : ("string", "Name of the frame to transform to."),
'et'    : ("time", "Epoch of the state transformation matrix."),
'xform' : ("float[6,6]", "A state transformation matrix."),
}
CSPYCE_URL["sxform"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sxform_c.html"
#########################################
CSPYCE_ARGNAMES["termpt"] = ["method", "ilusrc", "target", "et", "fixref", "abcorr", "corloc", "obsrvr", "refvec", "rolstp", "ncuts", "schstp", "soltol", "maxn"]
CSPYCE_RETNAMES["termpt"] = ["npts", "points", "epochs", "trmvcs"]
CSPYCE_ABSTRACT["termpt"] = """
Find terminator points on a target body. The caller specifies
half-planes, bounded by the illumination source center-target center
vector, in which to search for terminator points.

The terminator can be either umbral or penumbral. The umbral terminator
is the boundary of the region on the target surface where no light from
the source is visible. The penumbral terminator is the boundary of the
region on the target surface where none of the light from the source is
blocked by the target itself.

The surface of the target body may be represented either by a triaxial
ellipsoid or by topographic data.
"""
CSPYCE_DEFINITIONS["termpt"] = {
'method': ("string", "Computation method."),
'ilusrc': ("body_name", "Illumination source."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", or \"CN+S\"."),
'corloc': ("string", "Aberration correction locus."),
'obsrvr': ("body_name", "Name of observing body."),
'refvec': ("float[3]", "Reference vector for cutting half-planes."),
'rolstp': ("float", "Roll angular step for cutting half-planes."),
'ncuts' : ("int", "Number of cutting planes."),
'schstp': ("float", "Angular step size for searching."),
'soltol': ("float", "Solution convergence tolerance."),
'maxn'  : ("int", "Maximum number of entries in output arrays."),
'npts'  : ("int[*]", "Counts of terminator points corresponding to cuts."),
'points': ("float[*,3]", "Terminator points."),
'epochs': ("time[*]", "Times associated with terminator points."),
'trmvcs': ("float[*,3]", "Terminator vectors emanating from the observer."),
}
CSPYCE_URL["termpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/termpt_c.html"
#########################################
CSPYCE_ARGNAMES["timdef"] = ["action", "item", "value"]
CSPYCE_RETNAMES["timdef"] = ["value"]
CSPYCE_ABSTRACT["timdef"] = """
Set and retrieve the defaults associated with calendar input strings.
"""
CSPYCE_DEFINITIONS["timdef"] = {
'action': ("string", "Action to take, \"SET\" or \"GET\"."),
'item'  : ("string", "Default item of interest, \"CALENDAR\", \"SYSTEM\", or \"ZONE\"."),
'value' : ("string", "Value associated with the default item. CALENDAR can be \"GREGORIAN\", \"JULIAN\", or \"MIXED\"; SYSTEM can be \"TDB\", \"TDT\", \"TT\", or \"UTC\"; ZONE can be \"EST\", \"EDT\", \"CST\", \"CDT\", \"MST\", \"MDT\", \"PST\", \"PDT\", \"UTC+h\", \"UTC-h\", \"UTC+h:m\", or \"UTC-h:m\", where h is hours (0-12) and m is minutes (0-59)."),
}
CSPYCE_URL["timdef"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/timdef_c.html"
CSPYCE_DEFAULTS["timdef"] = ["GET", "", ""]
#########################################
CSPYCE_ARGNAMES["timout"] = ["et", "pictur"]
CSPYCE_RETNAMES["timout"] = ["output"]
CSPYCE_ABSTRACT["timout"] = """
This routine converts an input epoch represented in TDB seconds past the
TDB epoch of J2000 to a character string formatted to the specifications
of a user's format picture.
"""
CSPYCE_DEFINITIONS["timout"] = {
'et'    : ("time", "An epoch in seconds past the ephemeris epoch J2000."),
'pictur': ("string", "A format specification for the output string."),
'output': ("string", "A string representation of the input epoch."),
}
CSPYCE_URL["timout"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/timout_c.html"
#########################################
CSPYCE_ARGNAMES["tipbod"] = ["ref", "body", "et"]
CSPYCE_RETNAMES["tipbod"] = ["tipm"]
CSPYCE_ABSTRACT["tipbod"] = """
Return a 3x3 matrix that transforms positions in inertial coordinates to
positions in body-equator-and-prime-meridian coordinates.
"""
CSPYCE_DEFINITIONS["tipbod"] = {
'ref'   : ("frame_name", "Name of the inertial reference frame to transform from."),
'body'  : ("body_code", "ID code of the body."),
'et'    : ("time", "Epoch of transformation."),
'tipm'  : ("float[3,3]", "Transformation (position), inertial to prime meridian."),
}
CSPYCE_URL["tipbod"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tipbod_c.html"
#########################################
CSPYCE_ARGNAMES["tisbod"] = ["ref", "body", "et"]
CSPYCE_RETNAMES["tisbod"] = ["tsipm"]
CSPYCE_ABSTRACT["tisbod"] = """
Return a 6x6 matrix that transforms states in inertial coordinates to
states in body-equator-and-prime-meridian coordinates.
"""
CSPYCE_DEFINITIONS["tisbod"] = {
'ref'   : ("frame_name", "Name of the inertial reference frame to transform from."),
'body'  : ("body_code", "ID code of the body."),
'et'    : ("time", "Epoch of transformation."),
'tsipm' : ("float[6,6]", "Transformation (state), inertial to prime meridian."),
}
CSPYCE_URL["tisbod"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tisbod_c.html"
#########################################
CSPYCE_ARGNAMES["tkvrsn"] = ["item"]
CSPYCE_RETNAMES["tkvrsn"] = ["value"]
CSPYCE_ABSTRACT["tkvrsn"] = """
Given an item such as the Toolkit or an entry point name, return the
latest version string.
"""
CSPYCE_DEFINITIONS["tkvrsn"] = {
'item'  : ("string", "Item for which a version string is desired; default is \"TOOLKIT\"."),
'value' : ("string", "Version string."),
}
CSPYCE_URL["tkvrsn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tkvrsn_c.html"
CSPYCE_DEFAULTS["tkvrsn"] = ["TOOLKIT"]
#########################################
CSPYCE_ARGNAMES["tparse"] = ["string"]
CSPYCE_RETNAMES["tparse"] = ["sp2000", "errmsg"]
CSPYCE_ABSTRACT["tparse"] = """
Parse a time string and return seconds past the J2000 epoch on a formal
calendar.
"""
CSPYCE_DEFINITIONS["tparse"] = {
'string': ("string", "Input time string, UTC."),
'sp2000': ("float", "Equivalent UTC seconds past J2000."),
'errmsg': ("string", "Descriptive error message."),
}
CSPYCE_URL["tparse"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tparse_c.html"
#########################################
CSPYCE_ARGNAMES["tpictr"] = ["sample"]
CSPYCE_RETNAMES["tpictr"] = ["pictur", "ok", "errmsg"]
CSPYCE_ABSTRACT["tpictr"] = """
Given a sample time string, create a time format picture suitable for
use by the routine timout.
"""
CSPYCE_DEFINITIONS["tpictr"] = {
'sample': ("string", "A sample time string."),
'pictur': ("string", "A format picture that describes sample."),
'ok'    : ("bool", "Flag indicating whether sample parsed successfully."),
'errmsg': ("string", "Diagnostic returned if sample cannot be parsed."),
}
CSPYCE_URL["tpictr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tpictr_c.html"
#########################################
CSPYCE_ARGNAMES["trace"] = ["matrix"]
CSPYCE_RETNAMES["trace"] = ["trace"]
CSPYCE_ABSTRACT["trace"] = """
Return the trace of a 3x3 matrix.
"""
CSPYCE_DEFINITIONS["trace"] = {
'matrix': ("float[3,3]", "3x3 matrix."),
'trace' : ("float", "The trace of the matrix."),
}
CSPYCE_URL["trace"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/trace_c.html"
#########################################
CSPYCE_ARGNAMES["trcoff"] = []
CSPYCE_RETNAMES["trcoff"] = []
CSPYCE_ABSTRACT["trcoff"] = """
Disable tracing.
"""
CSPYCE_DEFINITIONS["trcoff"] = {
}
CSPYCE_URL["trcoff"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/trcoff_c.html"
#########################################
CSPYCE_ARGNAMES["trcdep"] = []
CSPYCE_RETNAMES["trcdep"] = ["depth"]
CSPYCE_ABSTRACT["trcdep"] = """
Return the number of modules in the traceback representation.
"""
CSPYCE_DEFINITIONS["trcdep"] = {
'depth' : ("int", "The number of modules in the traceback."),
}
CSPYCE_URL["trcdep"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/trcdep_c.html"
#########################################
CSPYCE_ARGNAMES["trcnam"] = ["index"]
CSPYCE_RETNAMES["trcnam"] = ["name"]
CSPYCE_ABSTRACT["trcnam"] = """
Return the name of the module having the specified position in the trace
representation. The first module to check in is at index 0.
"""
CSPYCE_DEFINITIONS["trcnam"] = {
'index' : ("int", "The position of the requested module name."),
'name'  : ("string", "The name at position `index' in the traceback."),
}
CSPYCE_URL["trcnam"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/trcnam_c.html"
#########################################
CSPYCE_ARGNAMES["tsetyr"] = ["year"]
CSPYCE_RETNAMES["tsetyr"] = []
CSPYCE_ABSTRACT["tsetyr"] = """
Set the lower bound on the 100 year range.
"""
CSPYCE_DEFINITIONS["tsetyr"] = {
'year'  : ("int", "Lower bound on the 100 year interval of expansion. Default is 1950."),
}
CSPYCE_URL["tsetyr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tsetyr_c.html"
#########################################
CSPYCE_ARGNAMES["twopi"] = []
CSPYCE_RETNAMES["twopi"] = ["value"]
CSPYCE_ABSTRACT["twopi"] = """
Return twice the value of pi (the ratio of the circumference of a circle
to its diameter).
"""
CSPYCE_DEFINITIONS["twopi"] = {
'value' : ("float", "Twice the value of pi."),
}
CSPYCE_URL["twopi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/twopi_c.html"
#########################################
CSPYCE_ARGNAMES["twovec"] = ["axdef", "indexa", "plndef", "indexp"]
CSPYCE_RETNAMES["twovec"] = ["matrix"]
CSPYCE_ABSTRACT["twovec"] = """
Find the transformation to the right-handed frame having a given vector
as a specified axis and having a second given vector lying in a
specified coordinate plane.
"""
CSPYCE_DEFINITIONS["twovec"] = {
'axdef' : ("float[3]", "Vector defining a principal axis."),
'indexa': ("int", "Principal axis number of axdef (X=1, Y=2, Z=3)."),
'plndef': ("float[3]", "Vector defining (with axdef) a principal plane."),
'indexp': ("int", "Second axis number (with indexa) of principal plane."),
'matrix': ("float[3,3]", "Output rotation matrix."),
}
CSPYCE_URL["twovec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/twovec_c.html"
#########################################
CSPYCE_ARGNAMES["tyear"] = []
CSPYCE_RETNAMES["tyear"] = ["value"]
CSPYCE_ABSTRACT["tyear"] = """
Return the number of seconds in a tropical year.
"""
CSPYCE_DEFINITIONS["tyear"] = {
'value' : ("float", "The number of seconds in a tropical year."),
}
CSPYCE_URL["tyear"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tyear_c.html"
#########################################
CSPYCE_ARGNAMES["ucrss"] = ["v1", "v2"]
CSPYCE_RETNAMES["ucrss"] = ["vector"]
CSPYCE_ABSTRACT["ucrss"] = """
Compute the normalized cross product of two 3-vectors.
"""
CSPYCE_DEFINITIONS["ucrss"] = {
'v1'    : ("float[3]", "Left vector for cross product."),
'v2'    : ("float[3]", "Right vector for cross product."),
'vector': ("float[3]", "Normalized cross product (v1xv2) / |v1xv2|."),
}
CSPYCE_URL["ucrss"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ucrss_c.html"
#########################################
CSPYCE_ARGNAMES["unitim"] = ["epoch", "insys", "outsys"]
CSPYCE_RETNAMES["unitim"] = ["value"]
CSPYCE_ABSTRACT["unitim"] = """
Transform time from one uniform scale to another. The uniform time
scales are TAI, TDT, TDB, ET, JED, JDTDB, JDTDT.
"""
CSPYCE_DEFINITIONS["unitim"] = {
'epoch' : ("time", "An epoch to be converted."),
'insys' : ("string", "The time scale associated with the input epoch."),
'outsys': ("string", "The time scale associated with the function value."),
'value' : ("float", "The value in outsys that is equivalent to the epoch on the insys time scale."),
}
CSPYCE_URL["unitim"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/unitim_c.html"
#########################################
CSPYCE_ARGNAMES["unload"] = ["file"]
CSPYCE_RETNAMES["unload"] = []
CSPYCE_ABSTRACT["unload"] = """
Unload a SPICE kernel.
"""
CSPYCE_DEFINITIONS["unload"] = {
'file'  : ("string", "The name of a kernel to unload."),
}
CSPYCE_URL["unload"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/unload_c.html"
#########################################
CSPYCE_ARGNAMES["unorm"] = ["v1"]
CSPYCE_RETNAMES["unorm"] = ["vector", "vmag"]
CSPYCE_ABSTRACT["unorm"] = """
Normalize a 3-vector and return its magnitude.
"""
CSPYCE_DEFINITIONS["unorm"] = {
'v1'    : ("float[3]", "Vector to be normalized."),
'vector': ("float[3]", "Unit vector v1 / |v1|. If v1 is the zero vector, then it will also be zero."),
'vmag'  : ("float", "Magnitude of v1, i.e. |v1|."),
}
CSPYCE_URL["unorm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/unorm_c.html"
#########################################
CSPYCE_ARGNAMES["unormg"] = ["v1"]
CSPYCE_RETNAMES["unormg"] = ["vector", "vmag"]
CSPYCE_ABSTRACT["unormg"] = """
Normalize a vector of arbitrary dimension and return its magnitude.
"""
CSPYCE_DEFINITIONS["unormg"] = {
'v1'    : ("float[*]", "Vector to be normalized."),
'vector': ("float[*]", "Unit vector v1 / |v1|. If v1 is the zero vector, the returned vector will also be zero."),
'vmag'  : ("float", "Magnitude of v1, that is, |v1|."),
}
CSPYCE_URL["unormg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/unormg_c.html"
#########################################
CSPYCE_ARGNAMES["utc2et"] = ["utcstr"]
CSPYCE_RETNAMES["utc2et"] = ["et"]
CSPYCE_ABSTRACT["utc2et"] = """
Convert an input time from Calendar or Julian Date format, UTC, to
ephemeris seconds past J2000.
"""
CSPYCE_DEFINITIONS["utc2et"] = {
'utcstr': ("string", "Input time string, UTC."),
'et'    : ("time", "Output epoch, ephemeris seconds past J2000."),
}
CSPYCE_URL["utc2et"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/utc2et_c.html"
#########################################
CSPYCE_ARGNAMES["vadd"] = ["v1", "v2"]
CSPYCE_RETNAMES["vadd"] = ["v3"]
CSPYCE_ABSTRACT["vadd"] = """
Add two 3 dimensional vectors.
"""
CSPYCE_DEFINITIONS["vadd"] = {
'v1'    : ("float[3]", "First vector to be added."),
'v2'    : ("float[3]", "Second vector to be added."),
'v3'    : ("float[3]", "Sum vector, v1 + v2."),
}
CSPYCE_URL["vadd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vadd_c.html"
#########################################
CSPYCE_ARGNAMES["vaddg"] = ["v1", "v2"]
CSPYCE_RETNAMES["vaddg"] = ["v3"]
CSPYCE_ABSTRACT["vaddg"] = """
Add two vectors of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vaddg"] = {
'v1'    : ("float[*]", "First vector to be added."),
'v2'    : ("float[*]", "Second vector to be added."),
'v3'    : ("float[*]", "Sum vector, v1 + v2."),
}
CSPYCE_URL["vaddg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vaddg_c.html"
#########################################
CSPYCE_ARGNAMES["vcrss"] = ["v1", "v2"]
CSPYCE_RETNAMES["vcrss"] = ["v3"]
CSPYCE_ABSTRACT["vcrss"] = """
Compute the cross product of two 3-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vcrss"] = {
'v1'    : ("float[3]", "Left hand vector for cross product."),
'v2'    : ("float[3]", "Right hand vector for cross product."),
'v3'    : ("float[3]", "Cross product v1xv2."),
}
CSPYCE_URL["vcrss"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vcrss_c.html"
#########################################
CSPYCE_ARGNAMES["vdist"] = ["v1", "v2"]
CSPYCE_RETNAMES["vdist"] = ["dist"]
CSPYCE_ABSTRACT["vdist"] = """
Return the distance between two three-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vdist"] = {
'v1'    : ("float[3]", "The first of two 3-vectors."),
'v2'    : ("float[3]", "The second of two 3-vectors."),
'dist'  : ("float", "The distance between v1 and v2."),
}
CSPYCE_URL["vdist"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vdist_c.html"
#########################################
CSPYCE_ARGNAMES["vdistg"] = ["v1", "v2"]
CSPYCE_RETNAMES["vdistg"] = ["dist"]
CSPYCE_ABSTRACT["vdistg"] = """
Return the distance between two vectors of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vdistg"] = {
'v1'    : ("float[*]", "The first of two vectors of arbitrary dimension."),
'v2'    : ("float[*]", "The second of two vectors of arbitrary dimension."),
'dist'  : ("float", "The distance between v1 and v2."),
}
CSPYCE_URL["vdistg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vdistg_c.html"
#########################################
CSPYCE_ARGNAMES["vdot"] = ["v1", "v2"]
CSPYCE_RETNAMES["vdot"] = ["value"]
CSPYCE_ABSTRACT["vdot"] = """
Compute the dot product of two 3-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vdot"] = {
'v1'    : ("float[3]", "First vector in the dot product."),
'v2'    : ("float[3]", "Second vector in the dot product."),
'value' : ("float", "The dot product of v1 and v2."),
}
CSPYCE_URL["vdot"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vdot_c.html"
#########################################
CSPYCE_ARGNAMES["vdotg"] = ["v1", "v2"]
CSPYCE_RETNAMES["vdotg"] = ["value"]
CSPYCE_ABSTRACT["vdotg"] = """
Compute the dot product of two vectors of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vdotg"] = {
'v1'    : ("float[*]", "First vector in the dot product."),
'v2'    : ("float[*]", "Second vector in the dot product."),
'value' : ("float", "The dot product of v1 and v2."),
}
CSPYCE_URL["vdotg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vdotg_c.html"
#########################################
CSPYCE_ARGNAMES["vequ"] = ["v1"]
CSPYCE_RETNAMES["vequ"] = ["v2"]
CSPYCE_ABSTRACT["vequ"] = """
Make one 3-dimensional vector equal to another.
"""
CSPYCE_DEFINITIONS["vequ"] = {
'v1'    : ("float[3]", "3-dimensional vector."),
'v2'    : ("float[3]", "3-dimensional vector set equal to vin."),
}
CSPYCE_URL["vequ"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vequ_c.html"
#########################################
CSPYCE_ARGNAMES["vequg"] = ["v1"]
CSPYCE_RETNAMES["vequg"] = ["v2"]
CSPYCE_ABSTRACT["vequg"] = """
Make one vector of arbitrary dimension equal to another.
"""
CSPYCE_DEFINITIONS["vequg"] = {
'v1'    : ("float[*]", "Input vector."),
'v2'    : ("float[*]", "Vector set equal to vin."),
}
CSPYCE_URL["vequg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vequg_c.html"
#########################################
CSPYCE_ARGNAMES["vhat"] = ["v1"]
CSPYCE_RETNAMES["vhat"] = ["v2"]
CSPYCE_ABSTRACT["vhat"] = """
Find the unit vector along a 3-dimensional vector.
"""
CSPYCE_DEFINITIONS["vhat"] = {
'v1'    : ("float[3]", "Vector to be unitized."),
'v2'    : ("float[3]", "Unit vector v1 / |v1|."),
}
CSPYCE_URL["vhat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vhat_c.html"
#########################################
CSPYCE_ARGNAMES["vhatg"] = ["v1"]
CSPYCE_RETNAMES["vhatg"] = ["v2"]
CSPYCE_ABSTRACT["vhatg"] = """
Find the unit vector along a vector of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vhatg"] = {
'v1'    : ("float[*]", "Vector to be normalized."),
'v2'    : ("float[*]", "Unit vector v1 / |v1|. If v1 is the zero vector, v2 will also be zero."),
}
CSPYCE_URL["vhatg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vhatg_c.html"
#########################################
CSPYCE_ARGNAMES["vlcom3"] = ["a", "v1", "b", "v2", "c", "v3"]
CSPYCE_RETNAMES["vlcom3"] = ["sum"]
CSPYCE_ABSTRACT["vlcom3"] = """
This subroutine computes the vector linear combination a*v1 + b*v2 +
c*v3 of 3-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vlcom3"] = {
'a'     : ("float", "Coefficient of v1."),
'v1'    : ("float[3]", "Vector in 3-space."),
'b'     : ("float", "Coefficient of v2."),
'v2'    : ("float[3]", "Vector in 3-space."),
'c'     : ("float", "Coefficient of v3."),
'v3'    : ("float[3]", "Vector in 3-space."),
'sum'   : ("float[3]", "Linear vector combination a*v1 + b*v2 + c*v3."),
}
CSPYCE_URL["vlcom3"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vlcom3_c.html"
#########################################
CSPYCE_ARGNAMES["vlcom"] = ["a", "v1", "b", "v2"]
CSPYCE_RETNAMES["vlcom"] = ["sum"]
CSPYCE_ABSTRACT["vlcom"] = """
Compute a vector linear combination of two 3-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vlcom"] = {
'a'     : ("float", "Coefficient of v1."),
'v1'    : ("float[3]", "Vector in 3-space."),
'b'     : ("float", "Coefficient of v2."),
'v2'    : ("float[3]", "Vector in 3-space."),
'sum'   : ("float[3]", "Linear vector combination a*v1 + b*v2."),
}
CSPYCE_URL["vlcom"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vlcom_c.html"
#########################################
CSPYCE_ARGNAMES["vlcomg"] = ["a", "v1", "b", "v2"]
CSPYCE_RETNAMES["vlcomg"] = ["v3"]
CSPYCE_ABSTRACT["vlcomg"] = """
Compute a vector linear combination of two vectors of arbitrary
dimension.
"""
CSPYCE_DEFINITIONS["vlcomg"] = {
'a'     : ("float", "Coefficient of v1."),
'v1'    : ("float[*]", "Vector in n-space."),
'b'     : ("float", "Coefficient of v2."),
'v2'    : ("float[*]", "Vector in n-space."),
'v3'    : ("float[*]", "Linear vector combination a*v1 + b*v2."),
}
CSPYCE_URL["vlcomg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vlcomg_c.html"
#########################################
CSPYCE_ARGNAMES["vminug"] = ["v1"]
CSPYCE_RETNAMES["vminug"] = ["v2"]
CSPYCE_ABSTRACT["vminug"] = """
Negate a vector of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vminug"] = {
'v1'    : ("float[*]", "Vector to be negated."),
'v2'    : ("float[*]", "Vector equal to -vin."),
}
CSPYCE_URL["vminug"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vminug_c.html"
#########################################
CSPYCE_ARGNAMES["vminus"] = ["v1"]
CSPYCE_RETNAMES["vminus"] = ["v2"]
CSPYCE_ABSTRACT["vminus"] = """
Negate a 3-dimensional vector.
"""
CSPYCE_DEFINITIONS["vminus"] = {
'v1'    : ("float[3]", "Vector to be negated."),
'v2'    : ("float[3]", "Negated vector -v1."),
}
CSPYCE_URL["vminus"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vminus_c.html"
#########################################
CSPYCE_ARGNAMES["vnorm"] = ["v1"]
CSPYCE_RETNAMES["vnorm"] = ["value"]
CSPYCE_ABSTRACT["vnorm"] = """
Compute the magnitude of a 3-dimensional vector.
"""
CSPYCE_DEFINITIONS["vnorm"] = {
'v1'    : ("float[3]", "Vector whose magnitude is to be found."),
'value' : ("float", "The norm of v1."),
}
CSPYCE_URL["vnorm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vnorm_c.html"
#########################################
CSPYCE_ARGNAMES["vnormg"] = ["v1"]
CSPYCE_RETNAMES["vnormg"] = ["value"]
CSPYCE_ABSTRACT["vnormg"] = """
Compute the magnitude of a vector of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vnormg"] = {
'v1'    : ("float[*]", "Vector whose magnitude is to be found."),
'value' : ("float", "The norm of v1."),
}
CSPYCE_URL["vnormg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vnormg_c.html"
#########################################
CSPYCE_ARGNAMES["vpack"] = ["x", "y", "z"]
CSPYCE_RETNAMES["vpack"] = ["v"]
CSPYCE_ABSTRACT["vpack"] = """
Pack three scalar components into a vector.
"""
CSPYCE_DEFINITIONS["vpack"] = {
'x'     : ("float", "First scalar component of a 3-vector."),
'y'     : ("float", "Second scalar component of a 3-vector."),
'z'     : ("float", "Third scalar component of a 3-vector."),
'v'     : ("float[3]", "Equivalent 3-vector."),
}
CSPYCE_URL["vpack"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vpack_c.html"
#########################################
CSPYCE_ARGNAMES["vperp"] = ["a", "b"]
CSPYCE_RETNAMES["vperp"] = ["p"]
CSPYCE_ABSTRACT["vperp"] = """
Find the component of a vector that is perpendicular to a second vector.
All vectors are 3-dimensional.
"""
CSPYCE_DEFINITIONS["vperp"] = {
'a'     : ("float[3]", "The vector whose orthogonal component is sought."),
'b'     : ("float[3]", "The vector used as the orthogonal reference."),
'p'     : ("float[3]", "The component of a orthogonal to b."),
}
CSPYCE_URL["vperp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vperp_c.html"
#########################################
CSPYCE_ARGNAMES["vprjp"] = ["v1", "plane"]
CSPYCE_RETNAMES["vprjp"] = ["v2"]
CSPYCE_ABSTRACT["vprjp"] = """
Project a vector onto a specified plane, orthogonally.
"""
CSPYCE_DEFINITIONS["vprjp"] = {
'v1'    : ("float[3]", "Vector to be projected."),
'plane' : ("float[4]", "A CSPICE plane onto which vin is projected."),
'v2'    : ("float[3]", "Vector resulting from projection."),
}
CSPYCE_URL["vprjp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vprjp_c.html"
#########################################
CSPYCE_ARGNAMES["vprjpi"] = ["v1", "projpl", "invpl"]
CSPYCE_RETNAMES["vprjpi"] = ["v2", "found"]
CSPYCE_ABSTRACT["vprjpi"] = """
Find the vector in a specified plane that maps to a specified vector in
another plane under orthogonal projection.
"""
CSPYCE_DEFINITIONS["vprjpi"] = {
'v1'    : ("float[3]", "The projected vector."),
'projpl': ("float[4]", "Plane containing v1."),
'invpl' : ("float[4]", "Plane containing inverse image of v1."),
'v2'    : ("float[3]", "Inverse projection of v1."),
'found' : ("bool", "Flag indicating whether v2 could be calculated."),
}
CSPYCE_URL["vprjpi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vprjpi_c.html"
#########################################
CSPYCE_ARGNAMES["vproj"] = ["a", "b"]
CSPYCE_RETNAMES["vproj"] = ["p"]
CSPYCE_ABSTRACT["vproj"] = """
Find the projection of one vector onto another vector. All vectors are
3-dimensional.
"""
CSPYCE_DEFINITIONS["vproj"] = {
'a'     : ("float[3]", "The vector to be projected."),
'b'     : ("float[3]", "The vector onto which a is to be projected."),
'p'     : ("float[3]", "The projection of a onto b."),
}
CSPYCE_URL["vproj"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vproj_c.html"
#########################################
CSPYCE_ARGNAMES["vrel"] = ["v1", "v2"]
CSPYCE_RETNAMES["vrel"] = ["value"]
CSPYCE_ABSTRACT["vrel"] = """
Return the relative difference between two 3-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vrel"] = {
'v1'    : ("float[3]", "First input vector."),
'v2'    : ("float[3]", "Second input vector."),
'value' : ("float", "The relative difference of v1 and v2."),
}
CSPYCE_URL["vrel"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vrel_c.html"
#########################################
CSPYCE_ARGNAMES["vrelg"] = ["v1", "v2"]
CSPYCE_RETNAMES["vrelg"] = ["value"]
CSPYCE_ABSTRACT["vrelg"] = """
Return the relative difference between two vectors of general dimension.
"""
CSPYCE_DEFINITIONS["vrelg"] = {
'v1'    : ("float[*]", "First input vector."),
'v2'    : ("float[*]", "Second input vector."),
'value' : ("float", "The relative difference of v1 and v2."),
}
CSPYCE_URL["vrelg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vrelg_c.html"
#########################################
CSPYCE_ARGNAMES["vrotv"] = ["v", "axis", "theta"]
CSPYCE_RETNAMES["vrotv"] = ["r"]
CSPYCE_ABSTRACT["vrotv"] = """
Rotate a vector about a specified axis vector by a specified angle and
return the rotated vector.
"""
CSPYCE_DEFINITIONS["vrotv"] = {
'v'     : ("float[3]", "Vector to be rotated."),
'axis'  : ("float[3]", "Axis of the rotation."),
'theta' : ("float", "Angle of rotation (radians)."),
'r'     : ("float[3]", "Result of rotating v about axis by theta."),
}
CSPYCE_URL["vrotv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vrotv_c.html"
#########################################
CSPYCE_ARGNAMES["vscl"] = ["s", "v1"]
CSPYCE_RETNAMES["vscl"] = ["v2"]
CSPYCE_ABSTRACT["vscl"] = """
Multiply a scalar and a 3-dimensional vector.
"""
CSPYCE_DEFINITIONS["vscl"] = {
's'     : ("float", "Scalar to multiply a vector."),
'v1'    : ("float[3]", "Vector to be multiplied."),
'v2'    : ("float[3]", "Product vector, s*v1."),
}
CSPYCE_URL["vscl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vscl_c.html"
#########################################
CSPYCE_ARGNAMES["vsclg"] = ["s", "v1"]
CSPYCE_RETNAMES["vsclg"] = ["v2"]
CSPYCE_ABSTRACT["vsclg"] = """
Multiply a scalar and a vector of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vsclg"] = {
's'     : ("float", "Scalar to multiply a vector."),
'v1'    : ("float[*]", "Vector to be multiplied."),
'v2'    : ("float[*]", "Product vector, s*v1."),
}
CSPYCE_URL["vsclg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vsclg_c.html"
#########################################
CSPYCE_ARGNAMES["vsep"] = ["v1", "v2"]
CSPYCE_RETNAMES["vsep"] = ["value"]
CSPYCE_ABSTRACT["vsep"] = """
Find the separation angle in radians between two 3-dimensional vectors.
This angle is defined as zero if either vector is zero.
"""
CSPYCE_DEFINITIONS["vsep"] = {
'v1'    : ("float[3]", "First vector."),
'v2'    : ("float[3]", "Second vector."),
'value' : ("float", "The separation angle in radians."),
}
CSPYCE_URL["vsep"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vsep_c.html"
#########################################
CSPYCE_ARGNAMES["vsepg"] = ["v1", "v2"]
CSPYCE_RETNAMES["vsepg"] = ["value"]
CSPYCE_ABSTRACT["vsepg"] = """
Find the separation angle in radians between two vectors of arbitrary
dimension. This angle is defined as zero if either vector is zero.
"""
CSPYCE_DEFINITIONS["vsepg"] = {
'v1'    : ("float[*]", "First vector."),
'v2'    : ("float[*]", "Second vector."),
'value' : ("float", "The separation angle in radians."),
}
CSPYCE_URL["vsepg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vsepg_c.html"
#########################################
CSPYCE_ARGNAMES["vsub"] = ["v1", "v2"]
CSPYCE_RETNAMES["vsub"] = ["v3"]
CSPYCE_ABSTRACT["vsub"] = """
Compute the difference between two 3-dimensional vectors.
"""
CSPYCE_DEFINITIONS["vsub"] = {
'v1'    : ("float[3]", "First vector (minuend)."),
'v2'    : ("float[3]", "Second vector (subtrahend)."),
'v3'    : ("float[3]", "Difference vector, v1 - v2."),
}
CSPYCE_URL["vsub"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vsub_c.html"
#########################################
CSPYCE_ARGNAMES["vsubg"] = ["v1", "v2"]
CSPYCE_RETNAMES["vsubg"] = ["v3"]
CSPYCE_ABSTRACT["vsubg"] = """
Compute the difference between two vectors of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vsubg"] = {
'v1'    : ("float[*]", "First vector (minuend)."),
'v2'    : ("float[*]", "Second vector (subtrahend)."),
'v3'    : ("float[*]", "Difference vector, v1 - v2."),
}
CSPYCE_URL["vsubg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vsubg_c.html"
#########################################
CSPYCE_ARGNAMES["vtmv"] = ["v1", "matrix", "v2"]
CSPYCE_RETNAMES["vtmv"] = ["value"]
CSPYCE_ABSTRACT["vtmv"] = """
Multiply the transpose of a 3-dimensional column vector, a 3x3 matrix,
and a 3-dimensional column vector.
"""
CSPYCE_DEFINITIONS["vtmv"] = {
'v1'    : ("float[3]", "3 dimensional column vector."),
'matrix': ("float[3,3]", "3x3 matrix."),
'v2'    : ("float[3]", "3 dimensional column vector."),
'value' : ("float", "The result of (v1**t * matrix * v2)."),
}
CSPYCE_URL["vtmv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vtmv_c.html"
#########################################
CSPYCE_ARGNAMES["vtmvg"] = ["v1", "matrix", "v2"]
CSPYCE_RETNAMES["vtmvg"] = ["value"]
CSPYCE_ABSTRACT["vtmvg"] = """
Multiply the transpose of a n-dimensional column vector, a nxm matrix,
and a m-dimensional column vector.
"""
CSPYCE_DEFINITIONS["vtmvg"] = {
'v1'    : ("float[*]", "n-dimensional column vector."),
'matrix': ("float[*]", "nxm matrix."),
'v2'    : ("float[*]", "m-dimensional column vector."),
'value' : ("float", "The result of (v1**t * matrix * v2)."),
}
CSPYCE_URL["vtmvg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vtmvg_c.html"
#########################################
CSPYCE_ARGNAMES["vupack"] = ["v"]
CSPYCE_RETNAMES["vupack"] = ["x", "y", "z"]
CSPYCE_ABSTRACT["vupack"] = """
Unpack three scalar components from a vector.
"""
CSPYCE_DEFINITIONS["vupack"] = {
'v'     : ("float[3]", "3-vector."),
'x'     : ("float", "First scalar component of the 3-vector."),
'y'     : ("float", "Second scalar component of the 3-vector."),
'z'     : ("float", "Third scalar component of the 3-vector."),
}
CSPYCE_URL["vupack"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vupack_c.html"
#########################################
CSPYCE_ARGNAMES["vzero"] = ["v"]
CSPYCE_RETNAMES["vzero"] = ["value"]
CSPYCE_ABSTRACT["vzero"] = """
Indicate whether a 3-vector is the zero vector.
"""
CSPYCE_DEFINITIONS["vzero"] = {
'v'     : ("float[3]", "Vector to be tested."),
'value' : ("bool", "True if and only if v is the zero vector."),
}
CSPYCE_URL["vzero"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vzero_c.html"
#########################################
CSPYCE_ARGNAMES["vzerog"] = ["v"]
CSPYCE_RETNAMES["vzerog"] = ["value"]
CSPYCE_ABSTRACT["vzerog"] = """
Indicate whether a general-dimensional vector is the zero vector.
"""
CSPYCE_DEFINITIONS["vzerog"] = {
'v'     : ("float[*]", "Vector to be tested."),
'value' : ("bool", "True if and only if v is the zero vector."),
}
CSPYCE_URL["vzerog"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vzerog_c.html"
#########################################
CSPYCE_ARGNAMES["xf2eul"] = ["xform", "axisa", "axisb", "axisc"]
CSPYCE_RETNAMES["xf2eul"] = ["eulang", "unique"]
CSPYCE_ABSTRACT["xf2eul"] = """
Convert a state transformation matrix to Euler angles and their
derivatives with respect to a specified set of axes. The companion
routine eul2xf converts Euler angles and their derivatives with respect
to a specified set of axes to a state transformation matrix.
"""
CSPYCE_DEFINITIONS["xf2eul"] = {
'xform' : ("float[6,6]", "A state transformation matrix."),
'axisa' : ("int", "Axis A of the Euler angle factorization."),
'axisb' : ("int", "Axis B of the Euler angle factorization."),
'axisc' : ("int", "Axis C of the Euler angle factorization."),
'eulang': ("float[6]", "An array of Euler angles and their derivatives."),
'unique': ("bool", "Indicates if eulang is a unique representation."),
}
CSPYCE_URL["xf2eul"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/xf2eul_c.html"
#########################################
CSPYCE_ARGNAMES["xf2rav"] = ["xform"]
CSPYCE_RETNAMES["xf2rav"] = ["rot", "av"]
CSPYCE_ABSTRACT["xf2rav"] = """
This routine determines from a state transformation matrix the
associated rotation matrix and angular velocity of the rotation.
"""
CSPYCE_DEFINITIONS["xf2rav"] = {
'xform' : ("float[6,6]", "State transformation matrix."),
'rot'   : ("float[3,3]", "Rotation associated with xform."),
'av'    : ("float[3]", "Angular velocity associated with xform."),
}
CSPYCE_URL["xf2rav"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/xf2rav_c.html"
#########################################
CSPYCE_ARGNAMES["xfmsta"] = ["state1", "insys", "outsys", "body"]
CSPYCE_RETNAMES["xfmsta"] = ["state2"]
CSPYCE_ABSTRACT["xfmsta"] = """
Transform a state between coordinate systems.
"""
CSPYCE_DEFINITIONS["xfmsta"] = {
'state1': ("float[6]", "Input state."),
'insys' : ("string", "Current (input) coordinate system."),
'outsys': ("string", "Desired (output) coordinate system."),
'body'  : ("body_name", "Name or NAIF ID of body with which coordinates are associated (if applicable)."),
'state2': ("float[6]", "Converted output state."),
}
CSPYCE_URL["xfmsta"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/xfmsta_c.html"
#########################################
CSPYCE_ARGNAMES["xpose6"] = ["m1"]
CSPYCE_RETNAMES["xpose6"] = ["matrix"]
CSPYCE_ABSTRACT["xpose6"] = """
Transpose a 6x6 matrix.
"""
CSPYCE_DEFINITIONS["xpose6"] = {
'm1'    : ("float[6,6]", "6x6 matrix to be transposed."),
'matrix': ("float[6,6]", "Transpose of m1."),
}
CSPYCE_URL["xpose6"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/xpose6_c.html"
#########################################
CSPYCE_ARGNAMES["xpose"] = ["m1"]
CSPYCE_RETNAMES["xpose"] = ["matrix"]
CSPYCE_ABSTRACT["xpose"] = """
Transpose a 3x3 matrix.
"""
CSPYCE_DEFINITIONS["xpose"] = {
'm1'    : ("float[3,3]", "3x3 matrix to be transposed."),
'matrix': ("float[3,3]", "Transpose of m1."),
}
CSPYCE_URL["xpose"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/xpose_c.html"
#########################################
CSPYCE_ARGNAMES["xposeg"] = ["matrix"]
CSPYCE_RETNAMES["xposeg"] = ["xposem"]
CSPYCE_ABSTRACT["xposeg"] = """
Transpose a matrix of arbitrary size.
"""
CSPYCE_DEFINITIONS["xposeg"] = {
'matrix': ("float[*,*]", "Matrix to be transposed."),
'xposem': ("float[*,*]", "Transposed matrix."),
}
CSPYCE_URL["xposeg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/xposeg_c.html"
#########################################
#########################################
CSPYCE_ARGNAMES["azlcpo"] = ["method", "target", "et", "abcorr", "azccw", "elplsz", "obspos", "obsctr", "obsref"]
CSPYCE_RETNAMES["azlcpo"] = ["azlsta", "lt"]
CSPYCE_ABSTRACT["azlcpo"] = """
Return the azimuth/elevation coordinates of a specified target relative
to an "observer," where the observer has constant position in a
specified reference frame. The observer's position is provided by the
calling program rather than by loaded SPK files.
"""
CSPYCE_DEFINITIONS["azlcpo"] = {
'method': ("string", "Method to obtain the surface normal vector; \"ELLIPSOID\" is the one and only option."),
'target': ("body_name", "Name of target ephemeris object."),
'et'    : ("time", "Observation epoch."),
'abcorr': ("string", "Aberration correction, \"NONE\", \"LT\", \"LT+S\", \"CN\", \"CN+S\", \"XLT\", \"XLT+S\", \"XCN\", or \"XCN+S\"."),
'azccw' : ("bool", "Flag indicating how azimuth is measured, True for counterclockwise, False for clockwise."),
'elplsz': ("bool", "Flag indicating how elevation is measured, True for increasing toward +Z, False for -Z."),
'obspos': ("float[3]", "Observer position relative to center of motion."),
'obsctr': ("body_name", "Center of motion of observer."),
'obsref': ("frame_name", "Body-fixed, body-centered frame of observer's center."),
'azlsta': ("float[6]", "State of target with respect to observer, in azimuth/elevation coordinates."),
'lt'    : ("float", "One way light time between target and observer."),
}
CSPYCE_URL["azlcpo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/azlcpo_c.html"
#########################################
CSPYCE_ARGNAMES["azlrec"] = ["range", "az", "el", "azccw", "elplsz"]
CSPYCE_RETNAMES["azlrec"] = ["rectan"]
CSPYCE_ABSTRACT["azlrec"] = """
Convert from range, azimuth and elevation of a point to rectangular
coordinates.
"""
CSPYCE_DEFINITIONS["azlrec"] = {
'range' : ("float", "Distance of the point from the origin."),
'az'    : ("float", "Azimuth in radians."),
'el'    : ("float", "Elevation in radians."),
'azccw' : ("bool", "Flag indicating how azimuth is measured, True for counterclockwise, False for clockwise."),
'elplsz': ("bool", "Flag indicating how elevation is measured, True for increasing toward +Z, False for -Z."),
'rectan': ("float[3]", "Rectangular coordinates of a point."),
}
CSPYCE_URL["azlrec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/azlrec_c.html"
#########################################
CSPYCE_ARGNAMES["badkpv"] = ["caller", "name", "comp", "size", "divby", "type"]
CSPYCE_RETNAMES["badkpv"] = []
CSPYCE_ABSTRACT["badkpv"] = """
Determine if a kernel pool variable is present and if so that it has the
correct size and type.
"""
CSPYCE_DEFINITIONS["badkpv"] = {
'caller': ("string", "Name of the routine calling this routine."),
'name'  : ("string", "Name of a kernel pool variable."),
'comp'  : ("string", "Comparison operator, one of \"=\", \"<\", \">\", \"=>\", \"<=\"."),
'size'  : ("int", "Expected size of the kernel pool variable."),
'divby' : ("int", "A divisor of the size of the kernel pool variable."),
'type'  : ("string", "Expected type of the kernel pool variable, \"C\" for string, \"N\" for numeric."),
}
CSPYCE_URL["badkpv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/badkpv_c.html"
#########################################
CSPYCE_ARGNAMES["brcktd"] = ["number", "end1", "end2"]
CSPYCE_RETNAMES["brcktd"] = []
CSPYCE_ABSTRACT["brcktd"] = """
Bracket a floating-point number. That is, given a number and an
acceptable interval, make sure that the number is contained in the
interval. (If the number is already in the interval, leave it alone. If
not, set it to the nearest endpoint of the interval.)
"""
CSPYCE_DEFINITIONS["brcktd"] = {
'number': ("float", "Number to be bracketed."),
'end1'  : ("float", "One of the bracketing endpoints for `number'."),
'end2'  : ("float", "The other bracketing endpoint for `number'."),
}
CSPYCE_URL["brcktd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/brcktd_c.html"
#########################################
CSPYCE_ARGNAMES["brckti"] = ["number", "end1", "end2"]
CSPYCE_RETNAMES["brckti"] = ["result"]
CSPYCE_ABSTRACT["brckti"] = """
Bracket an integer number. That is, given a number and an acceptable
interval, make sure that the number is contained in the interval. (If
the number is already in the interval, leave it alone. If not, set it to
the nearest endpoint of the interval.)
"""
CSPYCE_DEFINITIONS["brckti"] = {
'number': ("int", "Number to be bracketed."),
'end1'  : ("int", "One of the bracketing endpoints for `number'."),
'end2'  : ("int", "The other bracketing endpoint for `number'."),
'result': ("int", "Bracketed value."),
}
CSPYCE_URL["brckti"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/brckti_c.html"
#########################################
CSPYCE_ARGNAMES["bschoc"] = ["value", "array", "order"]
CSPYCE_RETNAMES["bschoc"] = ["index"]
CSPYCE_ABSTRACT["bschoc"] = """
Do a binary search for a given value within an array of character
strings, accompanied by an order vector. Return the index of the
matching array entry, or -1 if the key value is not found.
"""
CSPYCE_DEFINITIONS["bschoc"] = {
'value' : ("string", "Key value to be found in `array'."),
'array' : ("string[*]", "Character string array to search."),
'order' : ("int[*]", "Order vector."),
'index' : ("int", "Index of value in array."),
}
CSPYCE_URL["bschoc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bschoc_c.html"
#########################################
CSPYCE_ARGNAMES["bschoi"] = ["value", "array", "order"]
CSPYCE_RETNAMES["bschoi"] = ["index"]
CSPYCE_ABSTRACT["bschoi"] = """
Do a binary search for a given value within an integer array,
accompanied by an order vector. Return the index of the matching array
entry, or -1 if the key value is not found.
"""
CSPYCE_DEFINITIONS["bschoi"] = {
'value' : ("int", "Value to find in `array'."),
'array' : ("int[*]", "Array to be searched."),
'order' : ("int[*]", "Order vector."),
'index' : ("int", "Index of value in array."),
}
CSPYCE_URL["bschoi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bschoi_c.html"
#########################################
CSPYCE_ARGNAMES["bsrchc"] = ["value", "array"]
CSPYCE_RETNAMES["bsrchc"] = ["index"]
CSPYCE_ABSTRACT["bsrchc"] = """
Do a binary search for a given value within a character string array,
assumed to be in nondecreasing order. Return the index of the matching
array entry, or -1 if the key value is not found.
"""
CSPYCE_DEFINITIONS["bsrchc"] = {
'value' : ("string", "Key value to be found in `array'."),
'array' : ("string[*]", "Character string array to search."),
'index' : ("int", "Index of value in array."),
}
CSPYCE_URL["bsrchc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bsrchc_c.html"
#########################################
CSPYCE_ARGNAMES["bsrchd"] = ["value", "array"]
CSPYCE_RETNAMES["bsrchd"] = ["index"]
CSPYCE_ABSTRACT["bsrchd"] = """
Do a binary search for a given value within a floating-point array,
assumed to be in nondecreasing order. Return the index of the matching
array entry, or -1 if the key value is not found.
"""
CSPYCE_DEFINITIONS["bsrchd"] = {
'value' : ("float", "Value to find in `array'."),
'array' : ("float[*]", "Array to be searched."),
'index' : ("int", "Index of value in array."),
}
CSPYCE_URL["bsrchd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bsrchd_c.html"
#########################################
CSPYCE_ARGNAMES["bsrchi"] = ["value", "array"]
CSPYCE_RETNAMES["bsrchi"] = ["index"]
CSPYCE_ABSTRACT["bsrchi"] = """
Do a binary search for a given value within an integer array, assumed to
be in nondecreasing order. Return the index of the matching array entry,
or -1 if the key value is not found.
"""
CSPYCE_DEFINITIONS["bsrchi"] = {
'value' : ("int", "Value to find in `array'."),
'array' : ("int[*]", "Array to be searched."),
'index' : ("int", "Index of value in array."),
}
CSPYCE_URL["bsrchi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/bsrchi_c.html"
#########################################
CSPYCE_ARGNAMES["chbder"] = ["cp", "x2s", "x", "nderiv"]
CSPYCE_RETNAMES["chbder"] = ["dpdxs"]
CSPYCE_ABSTRACT["chbder"] = """
Return the value of a polynomial and its first `nderiv' derivatives,
evaluated at the input `x', using the coefficients of the Chebyshev
expansion of the polynomial.
"""
CSPYCE_DEFINITIONS["chbder"] = {
'cp'    : ("float[*]", "degp+1 Chebyshev polynomial coefficients."),
'x2s'   : ("float[2]", "Transformation parameters of polynomial."),
'x'     : ("float", "Value for which the polynomial is to be evaluated."),
'nderiv': ("int", "The number of derivatives to compute."),
'dpdxs' : ("float", "Array of the derivatives of the polynomial."),
}
CSPYCE_URL["chbder"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/chbder_c.html"
#########################################
CSPYCE_ARGNAMES["chbigr"] = ["cp", "x2s", "x"]
CSPYCE_RETNAMES["chbigr"] = ["p", "itgrlp"]
CSPYCE_ABSTRACT["chbigr"] = """
Evaluate an indefinite integral of a Chebyshev expansion at a specified
point `x' and return the value of the input expansion at `x' as well.
The constant of integration is selected to make the integral zero when
`x' equals the abscissa value x2s[0].
"""
CSPYCE_DEFINITIONS["chbigr"] = {
'cp'    : ("float[*]", "Chebyshev coefficients of input expansion."),
'x2s'   : ("float[2]", "Transformation parameters."),
'x'     : ("float", "Abscissa value of evaluation."),
'p'     : ("float", "Input expansion evaluated at `x'."),
'itgrlp': ("float", "Integral evaluated at `x'."),
}
CSPYCE_URL["chbigr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/chbigr_c.html"
#########################################
CSPYCE_ARGNAMES["chbint"] = ["cp", "x2s", "x"]
CSPYCE_RETNAMES["chbint"] = ["p", "dpdx"]
CSPYCE_ABSTRACT["chbint"] = """
Return the value of a polynomial and its derivative, evaluated at the
input `x', using the coefficients of the Chebyshev expansion of the
polynomial.
"""
CSPYCE_DEFINITIONS["chbint"] = {
'cp'    : ("float[*]", "degp+1 Chebyshev polynomial coefficients."),
'x2s'   : ("float[2]", "Transformation parameters of polynomial."),
'x'     : ("float", "Value for which the polynomial is to be evaluated"),
'p'     : ("float", "Value of the polynomial at `x'"),
'dpdx'  : ("float", "Value of the derivative of the polynomial at X"),
}
CSPYCE_URL["chbint"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/chbint_c.html"
#########################################
CSPYCE_ARGNAMES["chbval"] = ["cp", "x2s", "x"]
CSPYCE_RETNAMES["chbval"] = ["p"]
CSPYCE_ABSTRACT["chbval"] = """
Return the value of a polynomial evaluated at the input `x' using the
coefficients for the Chebyshev expansion of the polynomial.
"""
CSPYCE_DEFINITIONS["chbval"] = {
'cp'    : ("float[*]", "degp+1 Chebyshev polynomial coefficients."),
'x2s'   : ("float[2]", "Transformation parameters of polynomial."),
'x'     : ("float", "Value for which the polynomial is to be evaluated."),
'p'     : ("float", "Value of the polynomial at `x'."),
}
CSPYCE_URL["chbval"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/chbval_c.html"
#########################################
CSPYCE_ARGNAMES["ckcls"] = ["handle"]
CSPYCE_RETNAMES["ckcls"] = []
CSPYCE_ABSTRACT["ckcls"] = """
Close an open CK file.
"""
CSPYCE_DEFINITIONS["ckcls"] = {
'handle': ("int", "Handle of the CK file to be closed."),
}
CSPYCE_URL["ckcls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckcls_c.html"
#########################################
CSPYCE_ARGNAMES["ckfrot"] = ["inst", "et"]
CSPYCE_RETNAMES["ckfrot"] = ["rotate", "ref", "found"]
CSPYCE_ABSTRACT["ckfrot"] = """
Find the position rotation matrix from a C-kernel (CK) frame with the
specified frame class ID (CK ID) to the base frame of the highest
priority CK segment containing orientation data for this CK frame at the
time requested.
"""
CSPYCE_DEFINITIONS["ckfrot"] = {
'inst'  : ("int", "Frame class ID (CK ID) of a CK frame."),
'et'    : ("time", "Epoch measured in seconds past J2000 TDB."),
'rotate': ("float[3,3]", "Rotation matrix from CK frame to frame `ref'."),
'ref'   : ("frame_code", "Frame ID of the base reference."),
'found' : ("bool", "True if the requested pointing is available."),
}
CSPYCE_URL["ckfrot"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckfrot_c.html"
#########################################
CSPYCE_ARGNAMES["ckfxfm"] = ["inst", "et"]
CSPYCE_RETNAMES["ckfxfm"] = ["xform", "ref", "found"]
CSPYCE_ABSTRACT["ckfxfm"] = """
Find the state transformation matrix from a C-kernel (CK) frame with the
specified frame class ID (CK ID) to the base frame of the highest
priority CK segment containing orientation and angular velocity data for
this CK frame at the time requested.
"""
CSPYCE_DEFINITIONS["ckfxfm"] = {
'inst'  : ("int", "Frame class ID (CK ID) of a CK frame."),
'et'    : ("time", "Epoch measured in seconds past J2000 TDB."),
'xform' : ("float[6,6]", "Transformation from CK frame to frame `ref'."),
'ref'   : ("frame_code", "Frame ID of the base reference."),
'found' : ("bool", "True if the requested pointing is available."),
}
CSPYCE_URL["ckfxfm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckfxfm_c.html"
#########################################
CSPYCE_ARGNAMES["ckgr02"] = ["handle", "descr", "recno"]
CSPYCE_RETNAMES["ckgr02"] = ["record"]
CSPYCE_ABSTRACT["ckgr02"] = """
Return a specified pointing instance from a CK type 02 segment. The
segment is identified by a CK file handle and segment descriptor.
"""
CSPYCE_DEFINITIONS["ckgr02"] = {
'handle': ("int", "The handle of the CK file containing the segment."),
'descr' : ("float[5]", "The segment descriptor."),
'recno' : ("int", "The number of the pointing record to be returned."),
'record': ("float[*]", "The pointing record."),
}
CSPYCE_URL["ckgr02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckgr02_c.html"
#########################################
CSPYCE_ARGNAMES["ckgr03"] = ["handle", "descr", "recno"]
CSPYCE_RETNAMES["ckgr03"] = ["record"]
CSPYCE_ABSTRACT["ckgr03"] = """
Return a specified pointing instance from a CK type 03 segment. The
segment is identified by a CK file handle and segment descriptor.
"""
CSPYCE_DEFINITIONS["ckgr03"] = {
'handle': ("int", "The handle of the CK file containing the segment."),
'descr' : ("float[5]", "The segment descriptor."),
'recno' : ("int", "The number of the pointing instance to be returned."),
'record': ("float[*]", "The pointing record."),
}
CSPYCE_URL["ckgr03"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckgr03_c.html"
#########################################
CSPYCE_ARGNAMES["cklpf"] = ["fname"]
CSPYCE_RETNAMES["cklpf"] = ["handle"]
CSPYCE_ABSTRACT["cklpf"] = """
Load a CK pointing file for use by the CK readers. Return that file's
handle, to be used by other CK routines to refer to the file.
"""
CSPYCE_DEFINITIONS["cklpf"] = {
'fname' : ("string", "Name of the CK file to be loaded."),
'handle': ("int", "Loaded file's handle."),
}
CSPYCE_URL["cklpf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cklpf_c.html"
#########################################
CSPYCE_ARGNAMES["ckmeta"] = ["ckid", "meta"]
CSPYCE_RETNAMES["ckmeta"] = ["idcode"]
CSPYCE_ABSTRACT["ckmeta"] = """
Return (depending upon the user's request) the ID code of either the
spacecraft or spacecraft clock associated with a C-Kernel ID code.
"""
CSPYCE_DEFINITIONS["ckmeta"] = {
'ckid'  : ("int", "The ID code for some C kernel object."),
'meta'  : ("string", "The kind of meta data requested \"SPK\" or \"SCLK\""),
'idcode': ("int", "The requested SCLK or spacecraft ID code."),
}
CSPYCE_URL["ckmeta"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckmeta_c.html"
#########################################
CSPYCE_ARGNAMES["cknr02"] = ["handle", "descr"]
CSPYCE_RETNAMES["cknr02"] = ["nrec"]
CSPYCE_ABSTRACT["cknr02"] = """
Return the number of pointing records in a CK type 02 segment. The
segment is identified by a CK file handle and segment descriptor.
"""
CSPYCE_DEFINITIONS["cknr02"] = {
'handle': ("int", "The handle of the CK file containing the segment."),
'descr' : ("float[5]", "The descriptor of the type 2 segment."),
'nrec'  : ("int", "The number of records in the segment."),
}
CSPYCE_URL["cknr02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cknr02_c.html"
#########################################
CSPYCE_ARGNAMES["cknr03"] = ["handle", "descr"]
CSPYCE_RETNAMES["cknr03"] = ["nrec"]
CSPYCE_ABSTRACT["cknr03"] = """
Return the number of pointing instances in a CK type 03 segment. The
segment is identified by a CK file handle and segment descriptor.
"""
CSPYCE_DEFINITIONS["cknr03"] = {
'handle': ("int", "The handle of the CK file containing the segment."),
'descr' : ("float[5]", "The descriptor of the type 3 segment."),
'nrec'  : ("int", "The number of pointing instances in the segment."),
}
CSPYCE_URL["cknr03"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cknr03_c.html"
#########################################
CSPYCE_ARGNAMES["ckopn"] = ["fname", "ifname", "ncomch"]
CSPYCE_RETNAMES["ckopn"] = ["handle"]
CSPYCE_ABSTRACT["ckopn"] = """
Open a new CK file, returning the handle of the opened file.
"""
CSPYCE_DEFINITIONS["ckopn"] = {
'fname' : ("string", "The name of the CK file to be opened."),
'ifname': ("string", "The internal filename for the CK."),
'ncomch': ("int", "The number of characters to reserve for comments."),
'handle': ("int", "The handle of the opened CK file."),
}
CSPYCE_URL["ckopn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckopn_c.html"
#########################################
CSPYCE_ARGNAMES["ckupf"] = ["handle"]
CSPYCE_RETNAMES["ckupf"] = []
CSPYCE_ABSTRACT["ckupf"] = """
Unload a CK pointing file so that it will no longer be searched by the
readers.
"""
CSPYCE_DEFINITIONS["ckupf"] = {
'handle': ("int", "Handle of CK file to be unloaded"),
}
CSPYCE_URL["ckupf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckupf_c.html"
#########################################
CSPYCE_ARGNAMES["ckw01"] = ["handle", "begtim", "endtim", "inst", "ref", "avflag", "segid", "sclkdp", "quats", "avvs"]
CSPYCE_RETNAMES["ckw01"] = []
CSPYCE_ABSTRACT["ckw01"] = """
Add a type 1 segment to a C-kernel.
"""
CSPYCE_DEFINITIONS["ckw01"] = {
'handle': ("int", "Handle of an open CK file."),
'begtim': ("float", "The beginning encoded SCLK of the segment."),
'endtim': ("float", "The ending encoded SCLK of the segment."),
'inst'  : ("int", "The NAIF instrument ID code."),
'ref'   : ("frame_name", "The reference frame of the segment."),
'avflag': ("bool", "True if the segment will contain angular velocity."),
'segid' : ("string", "Segment identifier."),
'sclkdp': ("float[*]", "Encoded SCLK times."),
'quats' : ("float[*,4]", "Quaternions representing instrument pointing."),
'avvs'  : ("float[*,3]", "Angular velocity vectors."),
}
CSPYCE_URL["ckw01"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckw01_c.html"
#########################################
CSPYCE_ARGNAMES["ckw02"] = ["handle", "begtim", "endtim", "inst", "ref", "segid", "start", "stop", "quats", "avvs", "rates"]
CSPYCE_RETNAMES["ckw02"] = []
CSPYCE_ABSTRACT["ckw02"] = """
Write a type 2 segment to a C-kernel.
"""
CSPYCE_DEFINITIONS["ckw02"] = {
'handle': ("int", "Handle of an open CK file."),
'begtim': ("float", "The beginning encoded SCLK of the segment."),
'endtim': ("float", "The ending encoded SCLK of the segment."),
'inst'  : ("int", "The NAIF instrument ID code."),
'ref'   : ("frame_name", "The reference frame of the segment."),
'segid' : ("string", "Segment identifier."),
'start' : ("float[*]", "Encoded SCLK interval start times."),
'stop'  : ("float[*]", "Encoded SCLK interval stop times."),
'quats' : ("float[*,4]", "Quaternions representing instrument pointing."),
'avvs'  : ("float[*,3]", "Angular velocity vectors."),
'rates' : ("float[*]", "Number of seconds per tick for each interval."),
}
CSPYCE_URL["ckw02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckw02_c.html"
#########################################
CSPYCE_ARGNAMES["ckw03"] = ["handle", "begtim", "endtim", "inst", "ref", "avflag", "segid", "sclkdp", "quats", "avvs", "nints", "starts"]
CSPYCE_RETNAMES["ckw03"] = []
CSPYCE_ABSTRACT["ckw03"] = """
Add a type 3 segment to a C-kernel.
"""
CSPYCE_DEFINITIONS["ckw03"] = {
'handle': ("int", "Handle of an open CK file."),
'begtim': ("float", "The beginning encoded SCLK of the segment."),
'endtim': ("float", "The ending encoded SCLK of the segment."),
'inst'  : ("int", "The NAIF instrument ID code."),
'ref'   : ("frame_name", "The reference frame of the segment."),
'avflag': ("bool", "True if the segment will contain angular velocity."),
'segid' : ("string", "Segment identifier."),
'sclkdp': ("float[*]", "Encoded SCLK times."),
'quats' : ("float[*,4]", "Quaternions representing instrument pointing."),
'avvs'  : ("float[*,3]", "Angular velocity vectors."),
'nints' : ("int", "Number of intervals."),
'starts': ("float[*]", "Encoded SCLK interval start times."),
}
CSPYCE_URL["ckw03"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckw03_c.html"
#########################################
CSPYCE_ARGNAMES["ckw05"] = ["handle", "subtyp", "degree", "begtim", "endtim", "inst", "ref", "avflag", "segid", "sclkdp", "packts", "rate", "nints", "starts"]
CSPYCE_RETNAMES["ckw05"] = []
CSPYCE_ABSTRACT["ckw05"] = """
Write a type 5 segment to a CK file.
"""
CSPYCE_DEFINITIONS["ckw05"] = {
'handle': ("int", "Handle of an open CK file."),
'subtyp': ("string", "CK type 5 subtype code."),
'degree': ("int", "Degree of interpolating polynomials."),
'begtim': ("float", "The beginning encoded SCLK of the segment."),
'endtim': ("float", "The ending encoded SCLK of the segment."),
'inst'  : ("int", "The NAIF instrument ID code."),
'ref'   : ("frame_name", "The reference frame of the segment."),
'avflag': ("bool", "True if the segment will contain angular velocity."),
'segid' : ("string", "Segment identifier."),
'sclkdp': ("float[*]", "Encoded SCLK times."),
'packts': ("float[*]", "Array of packets."),
'rate'  : ("float", "Nominal SCLK rate in seconds per tick."),
'nints' : ("int", "Number of intervals."),
'starts': ("float[*]", "Encoded SCLK interval start times."),
}
CSPYCE_URL["ckw05"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ckw05_c.html"
#########################################
CSPYCE_ARGNAMES["cmprss"] = ["delim", "n", "input"]
CSPYCE_RETNAMES["cmprss"] = ["output"]
CSPYCE_ABSTRACT["cmprss"] = """
Compress a character string by removing occurrences of more than N
consecutive occurrences of a specified character.
"""
CSPYCE_DEFINITIONS["cmprss"] = {
'delim' : ("string", "Delimiter to be compressed."),
'n'     : ("int", "Maximum consecutive occurrences of delim."),
'input' : ("string", "Input string."),
'output': ("string", "Compressed string."),
}
CSPYCE_URL["cmprss"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cmprss_c.html"
#########################################
CSPYCE_ARGNAMES["cpos"] = ["str", "chars", "start"]
CSPYCE_RETNAMES["cpos"] = ["pos"]
CSPYCE_ABSTRACT["cpos"] = """
Find the first occurrence in a string of a character belonging to a
collection of characters, starting at a specified location, searching
forward.
"""
CSPYCE_DEFINITIONS["cpos"] = {
'str'   : ("string", "Any character string."),
'chars' : ("string", "A collection of characters."),
'start' : ("int", "Position to begin looking for one of chars."),
'pos'   : ("int", "Position of character."),
}
CSPYCE_URL["cpos"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cpos_c.html"
#########################################
CSPYCE_ARGNAMES["cposr"] = ["str", "chars", "start"]
CSPYCE_RETNAMES["cposr"] = ["pos"]
CSPYCE_ABSTRACT["cposr"] = """
Find the first occurrence in a string of a character belonging to a
collection of characters, starting at a specified location, searching in
reverse.
"""
CSPYCE_DEFINITIONS["cposr"] = {
'str'   : ("string", "Any character string."),
'chars' : ("string", "A collection of characters."),
'start' : ("int", "Position to begin looking for one of chars."),
'pos'   : ("int", "Position of character."),
}
CSPYCE_URL["cposr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cposr_c.html"
#########################################
CSPYCE_ARGNAMES["cvpool"] = ["agent"]
CSPYCE_RETNAMES["cvpool"] = ["update"]
CSPYCE_ABSTRACT["cvpool"] = """
Indicate whether or not any watched kernel variables that have a
specified agent on their notification list have been updated.
"""
CSPYCE_DEFINITIONS["cvpool"] = {
'agent' : ("string", "Name of the agent to check for notices."),
'update': ("bool", "True if variables for `agent' have been updated."),
}
CSPYCE_URL["cvpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/cvpool_c.html"
#########################################
CSPYCE_ARGNAMES["dafac"] = ["handle", "buffer"]
CSPYCE_RETNAMES["dafac"] = []
CSPYCE_ABSTRACT["dafac"] = """
Add comments from a buffer of character strings to the comment area of a
binary DAF file, appending them to any comments which are already
present in the file's comment area.
"""
CSPYCE_DEFINITIONS["dafac"] = {
'handle': ("int", "handle of a DAF opened with write access."),
'buffer': ("string[*]", "Buffer of comments to put into the comment area."),
}
CSPYCE_URL["dafac"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafac_c.html"
#########################################
CSPYCE_ARGNAMES["dafbbs"] = ["handle"]
CSPYCE_RETNAMES["dafbbs"] = []
CSPYCE_ABSTRACT["dafbbs"] = """
Begin a backward search for arrays in a DAF.
"""
CSPYCE_DEFINITIONS["dafbbs"] = {
'handle': ("int", "Handle of DAF to be searched."),
}
CSPYCE_URL["dafbbs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafbbs_c.html"
#########################################
CSPYCE_ARGNAMES["dafcs"] = ["handle"]
CSPYCE_RETNAMES["dafcs"] = []
CSPYCE_ABSTRACT["dafcs"] = """
Select a DAF that already has a search in progress as the one to
continue searching.
"""
CSPYCE_DEFINITIONS["dafcs"] = {
'handle': ("int", "Handle of DAF to continue searching."),
}
CSPYCE_URL["dafcs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafcs_c.html"
#########################################
CSPYCE_ARGNAMES["dafdc"] = ["handle"]
CSPYCE_RETNAMES["dafdc"] = []
CSPYCE_ABSTRACT["dafdc"] = """
Delete the entire comment area of a specified DAF file.
"""
CSPYCE_DEFINITIONS["dafdc"] = {
'handle': ("int", "The handle of a binary DAF opened for writing."),
}
CSPYCE_URL["dafdc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafdc_c.html"
#########################################
CSPYCE_ARGNAMES["dafec"] = ["handle"]
CSPYCE_RETNAMES["dafec"] = ["buffer", "done"]
CSPYCE_ABSTRACT["dafec"] = """
Extract comments from the comment area of a binary DAF.
"""
CSPYCE_DEFINITIONS["dafec"] = {
'handle': ("int", "Handle of binary DAF opened with read access."),
'buffer': ("string[*]", "Buffer where extracted comment lines are placed."),
'done'  : ("bool", "Indicates whether all comments have been extracted."),
}
CSPYCE_URL["dafec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafec_c.html"
#########################################
CSPYCE_ARGNAMES["daffpa"] = []
CSPYCE_RETNAMES["daffpa"] = ["found"]
CSPYCE_ABSTRACT["daffpa"] = """
Find the previous (backward) array in the current DAF.
"""
CSPYCE_DEFINITIONS["daffpa"] = {
'found' : ("bool", "True if an array was found."),
}
CSPYCE_URL["daffpa"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/daffpa_c.html"
#########################################
CSPYCE_ARGNAMES["dafgh"] = []
CSPYCE_RETNAMES["dafgh"] = ["handle"]
CSPYCE_ABSTRACT["dafgh"] = """
Return (get) the handle of the DAF currently being searched.
"""
CSPYCE_DEFINITIONS["dafgh"] = {
'handle': ("int", "Handle for current DAF."),
}
CSPYCE_URL["dafgh"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafgh_c.html"
#########################################
CSPYCE_ARGNAMES["dafgsr"] = ["handle", "recno", "begin", "end"]
CSPYCE_RETNAMES["dafgsr"] = ["data", "found"]
CSPYCE_ABSTRACT["dafgsr"] = """
Read a portion of the contents of a summary record in a DAF file.
"""
CSPYCE_DEFINITIONS["dafgsr"] = {
'handle': ("int", "Handle of DAF."),
'recno' : ("int", "Record number."),
'begin' : ("int", "First word to read from record."),
'end'   : ("int", "Last word to read from record."),
'data'  : ("float[*]", "Contents of record."),
'found' : ("bool", "True if record is found."),
}
CSPYCE_URL["dafgsr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafgsr_c.html"
#########################################
CSPYCE_ARGNAMES["dafhsf"] = ["handle"]
CSPYCE_RETNAMES["dafhsf"] = ["nd", "ni"]
CSPYCE_ABSTRACT["dafhsf"] = """
Return the summary format associated with a handle.
"""
CSPYCE_DEFINITIONS["dafhsf"] = {
'handle': ("int", "Handle of a DAF file."),
'nd'    : ("int", "Number of floating-point components in summaries."),
'ni'    : ("int", "Number of integer components in summaries."),
}
CSPYCE_URL["dafhsf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafhsf_c.html"
#########################################
CSPYCE_ARGNAMES["dafopw"] = ["fname"]
CSPYCE_RETNAMES["dafopw"] = ["handle"]
CSPYCE_ABSTRACT["dafopw"] = """
Open a DAF for subsequent write requests.
"""
CSPYCE_DEFINITIONS["dafopw"] = {
'fname' : ("string", "Name of DAF to be opened."),
'handle': ("int", "Handle assigned to DAF."),
}
CSPYCE_URL["dafopw"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafopw_c.html"
#########################################
CSPYCE_ARGNAMES["dafps"] = ["dc", "ic"]
CSPYCE_RETNAMES["dafps"] = ["sum"]
CSPYCE_ABSTRACT["dafps"] = """
Pack (assemble) an array summary from its floating-point and integer
components.
"""
CSPYCE_DEFINITIONS["dafps"] = {
'dc'    : ("float[*]", "Double precision components."),
'ic'    : ("int[*]", "Integer components."),
'sum'   : ("float[*]", "Array summary."),
}
CSPYCE_URL["dafps"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafps_c.html"
#########################################
CSPYCE_ARGNAMES["dafrfr"] = ["handle"]
CSPYCE_RETNAMES["dafrfr"] = ["nd", "ni", "ifname", "fward", "bward", "free"]
CSPYCE_ABSTRACT["dafrfr"] = """
Read the contents of the file record of a DAF.
"""
CSPYCE_DEFINITIONS["dafrfr"] = {
'handle': ("int", "Handle of an open DAF file."),
'nd'    : ("int", "Number of floating-point components in summaries."),
'ni'    : ("int", "Number of integer components in summaries."),
'ifname': ("string", "Internal file name."),
'fward' : ("int", "Forward list pointer."),
'bward' : ("int", "Backward list pointer."),
'free'  : ("int", "Free address pointer."),
}
CSPYCE_URL["dafrfr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafrfr_c.html"
#########################################
CSPYCE_ARGNAMES["dafrs"] = ["sum"]
CSPYCE_RETNAMES["dafrs"] = []
CSPYCE_ABSTRACT["dafrs"] = """
Change the summary for the current array in the current DAF.
"""
CSPYCE_DEFINITIONS["dafrs"] = {
'sum'   : ("float[*]", "New summary for current array."),
}
CSPYCE_URL["dafrs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dafrs_c.html"
#########################################
CSPYCE_ARGNAMES["dasac"] = ["handle", "buffer"]
CSPYCE_RETNAMES["dasac"] = []
CSPYCE_ABSTRACT["dasac"] = """
Add comments from a buffer of character strings to the comment area of a
binary DAS file, appending them to any comments which are already
present in the file's comment area.
"""
CSPYCE_DEFINITIONS["dasac"] = {
'handle': ("int", "DAS handle of a file opened with write access."),
'buffer': ("string[*]", "Buffer of lines to be put into the comment area."),
}
CSPYCE_URL["dasac"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasac_c.html"
#########################################
CSPYCE_ARGNAMES["dasadc"] = ["handle", "n", "bpos", "epos", "data"]
CSPYCE_RETNAMES["dasadc"] = []
CSPYCE_ABSTRACT["dasadc"] = """
Add character data to a DAS file.
"""
CSPYCE_DEFINITIONS["dasadc"] = {
'handle': ("int", "DAS file handle."),
'n'     : ("int", "Number of characters to add to file."),
'bpos'  : ("int", "Begin position of substrings in byte array."),
'epos'  : ("int", "End position of substrings in byte array."),
'data'  : ("byte_array[*,*]", "Byte array providing the set of substrings to be added to the character data in the DAS file."),
}
CSPYCE_URL["dasadc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasadc_c.html"
#########################################
CSPYCE_ARGNAMES["dasadd"] = ["handle", "data"]
CSPYCE_RETNAMES["dasadd"] = []
CSPYCE_ABSTRACT["dasadd"] = """
Add an array of floating-point numbers to a DAS file.
"""
CSPYCE_DEFINITIONS["dasadd"] = {
'handle': ("int", "DAS file handle."),
'data'  : ("float[*]", "Array of d.p. numbers to add."),
}
CSPYCE_URL["dasadd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasadd_c.html"
#########################################
CSPYCE_ARGNAMES["dasadi"] = ["handle", "data"]
CSPYCE_RETNAMES["dasadi"] = []
CSPYCE_ABSTRACT["dasadi"] = """
Add an array of integers to a DAS file.
"""
CSPYCE_DEFINITIONS["dasadi"] = {
'handle': ("int", "DAS file handle."),
'data'  : ("int[*]", "Array of integers to add."),
}
CSPYCE_URL["dasadi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasadi_c.html"
#########################################
CSPYCE_ARGNAMES["dascls"] = ["handle"]
CSPYCE_RETNAMES["dascls"] = []
CSPYCE_ABSTRACT["dascls"] = """
Close a DAS file.
"""
CSPYCE_DEFINITIONS["dascls"] = {
'handle': ("int", "Handle of an open DAS file."),
}
CSPYCE_URL["dascls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dascls_c.html"
#########################################
CSPYCE_ARGNAMES["dasdc"] = ["handle"]
CSPYCE_RETNAMES["dasdc"] = []
CSPYCE_ABSTRACT["dasdc"] = """
Delete the entire comment area of a previously opened binary DAS file.
"""
CSPYCE_DEFINITIONS["dasdc"] = {
'handle': ("int", "The handle of a binary DAS file opened for writing."),
}
CSPYCE_URL["dasdc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasdc_c.html"
#########################################
CSPYCE_ARGNAMES["dasec"] = ["handle"]
CSPYCE_RETNAMES["dasec"] = ["buffer", "done"]
CSPYCE_ABSTRACT["dasec"] = """
Extract comments from the comment area of a binary DAS file.
"""
CSPYCE_DEFINITIONS["dasec"] = {
'handle': ("int", "Handle of binary DAS file open with read access."),
'buffer': ("string[*]", "Buffer in which extracted comments are placed."),
'done'  : ("bool", "Indicates whether all comments have been extracted."),
}
CSPYCE_URL["dasec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasec_c.html"
#########################################
CSPYCE_ARGNAMES["dashfn"] = ["handle"]
CSPYCE_RETNAMES["dashfn"] = ["fname"]
CSPYCE_ABSTRACT["dashfn"] = """
Return the name of the DAS file associated with a handle.
"""
CSPYCE_DEFINITIONS["dashfn"] = {
'handle': ("int", "Handle of a DAS file."),
'fname' : ("string", "Corresponding file name."),
}
CSPYCE_URL["dashfn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dashfn_c.html"
#########################################
CSPYCE_ARGNAMES["dashfs"] = ["handle"]
CSPYCE_RETNAMES["dashfs"] = ["nresvr", "nresvc", "ncomr", "ncomc", "free", "lastla", "lastrc", "lastwd"]
CSPYCE_ABSTRACT["dashfs"] = """
Return a file summary for a specified DAS file.
"""
CSPYCE_DEFINITIONS["dashfs"] = {
'handle': ("int", "Handle of a DAS file."),
'nresvr': ("int", "Number of reserved records in file."),
'nresvc': ("int", "Number of characters in use in reserved rec. area."),
'ncomr' : ("int", "Number of comment records in file."),
'ncomc' : ("int", "Number of characters in use in comment area."),
'free'  : ("int", "Number of first free record."),
'lastla': ("int[3]", "Array of last logical addresses for each data type."),
'lastrc': ("int[3]", "Record number of last descriptor of each data type."),
'lastwd': ("int[3]", "Word number of last descriptor of each data type."),
}
CSPYCE_URL["dashfs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dashfs_c.html"
#########################################
CSPYCE_ARGNAMES["daslla"] = ["handle"]
CSPYCE_RETNAMES["daslla"] = ["lastc", "lastd", "lasti"]
CSPYCE_ABSTRACT["daslla"] = """
Return last DAS logical addresses of character, floating-point and
integer type that are currently in use in a specified DAS file.
"""
CSPYCE_DEFINITIONS["daslla"] = {
'handle': ("int", "DAS file handle."),
'lastc' : ("int", "Last character address in use."),
'lastd' : ("int", "Last floating-point address in use."),
'lasti' : ("int", "Last integer address in use."),
}
CSPYCE_URL["daslla"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/daslla_c.html"
#########################################
CSPYCE_ARGNAMES["dasllc"] = ["handle"]
CSPYCE_RETNAMES["dasllc"] = []
CSPYCE_ABSTRACT["dasllc"] = """
Close the DAS file associated with a given handle, without flushing
buffered data or segregating the file.
"""
CSPYCE_DEFINITIONS["dasllc"] = {
'handle': ("int", "Handle of a DAS file to be closed."),
}
CSPYCE_URL["dasllc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasllc_c.html"
#########################################
CSPYCE_ARGNAMES["dasonw"] = ["fname", "ftype", "ifname", "ncomr"]
CSPYCE_RETNAMES["dasonw"] = ["handle"]
CSPYCE_ABSTRACT["dasonw"] = """
Open a new DAS file and set the file type.
"""
CSPYCE_DEFINITIONS["dasonw"] = {
'fname' : ("string", "Name of a DAS file to be opened."),
'ftype' : ("string", "Mnemonic code for type of data in the DAS file."),
'ifname': ("string", "Internal file name."),
'ncomr' : ("int", "Number of comment records to allocate."),
'handle': ("int", "Handle assigned to the opened DAS file."),
}
CSPYCE_URL["dasonw"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasonw_c.html"
#########################################
CSPYCE_ARGNAMES["dasopr"] = ["fname"]
CSPYCE_RETNAMES["dasopr"] = ["handle"]
CSPYCE_ABSTRACT["dasopr"] = """
Open a DAS file for reading.
"""
CSPYCE_DEFINITIONS["dasopr"] = {
'fname' : ("string", "Name of a DAS file to be opened."),
'handle': ("int", "Handle assigned to the opened DAS file."),
}
CSPYCE_URL["dasopr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasopr_c.html"
#########################################
CSPYCE_ARGNAMES["dasops"] = []
CSPYCE_RETNAMES["dasops"] = ["handle"]
CSPYCE_ABSTRACT["dasops"] = """
Open a scratch DAS file for writing.
"""
CSPYCE_DEFINITIONS["dasops"] = {
'handle': ("int", "Handle assigned to a scratch DAS file."),
}
CSPYCE_URL["dasops"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasops_c.html"
#########################################
CSPYCE_ARGNAMES["dasopw"] = ["fname"]
CSPYCE_RETNAMES["dasopw"] = ["handle"]
CSPYCE_ABSTRACT["dasopw"] = """
Open a DAS file for writing.
"""
CSPYCE_DEFINITIONS["dasopw"] = {
'fname' : ("string", "Name of a DAS file to be opened."),
'handle': ("int", "Handle assigned to the opened DAS file."),
}
CSPYCE_URL["dasopw"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasopw_c.html"
#########################################
CSPYCE_ARGNAMES["dasrdc"] = ["handle", "first", "last", "bpos", "epos", "data"]
CSPYCE_RETNAMES["dasrdc"] = ["data"]
CSPYCE_ABSTRACT["dasrdc"] = """
Read character data from a range of DAS logical addresses.
"""
CSPYCE_DEFINITIONS["dasrdc"] = {
'handle': ("int", "DAS file handle."),
'first' : ("int", "Beginning of range of DAS character logical addresses."),
'last'  : ("int", "End of range of DAS character logical addresses."),
'bpos'  : ("int", "Beginning position of substrings."),
'epos'  : ("int", "End position of substrings."),
'data'  : ("byte_array[*,*]", "Byte array having updated values in rows `first' through `last' at positions `bpos' to `epos'."),
}
CSPYCE_URL["dasrdc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasrdc_c.html"
#########################################
CSPYCE_ARGNAMES["dasrdd"] = ["handle", "first", "last"]
CSPYCE_RETNAMES["dasrdd"] = ["data"]
CSPYCE_ABSTRACT["dasrdd"] = """
Read floating-point data from a range of DAS logical addresses.
"""
CSPYCE_DEFINITIONS["dasrdd"] = {
'handle': ("int", "DAS file handle."),
'first' : ("int", "Beginning of range of DAS floating-point logical addresses."),
'last'  : ("int", "End of range of DAS character floating-point addresses."),
'data'  : ("float[*]", "Data having addresses `first' through `last'."),
}
CSPYCE_URL["dasrdd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasrdd_c.html"
#########################################
CSPYCE_ARGNAMES["dasrdi"] = ["handle", "first", "last"]
CSPYCE_RETNAMES["dasrdi"] = ["data"]
CSPYCE_ABSTRACT["dasrdi"] = """
Read integer data from a range of DAS logical addresses.
"""
CSPYCE_DEFINITIONS["dasrdi"] = {
'handle': ("int", "DAS file handle."),
'first' : ("int", "Beginning of range of DAS integer logical addresses."),
'last'  : ("int", "End of range of DAS character integer addresses."),
'data'  : ("int[*]", "Data having addresses `first' through `last'."),
}
CSPYCE_URL["dasrdi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasrdi_c.html"
#########################################
CSPYCE_ARGNAMES["dasrfr"] = ["handle"]
CSPYCE_RETNAMES["dasrfr"] = ["idword", "ifname", "nresvr", "nresvc", "ncomr", "ncomc"]
CSPYCE_ABSTRACT["dasrfr"] = """
Return the contents of the file record of a specified DAS file.
"""
CSPYCE_DEFINITIONS["dasrfr"] = {
'handle': ("int", "DAS file handle."),
'idword': ("string", "ID word."),
'ifname': ("string", "DAS internal file name."),
'nresvr': ("int", "Number of reserved records in file."),
'nresvc': ("int", "Number of characters in use in reserved rec. area."),
'ncomr' : ("int", "Number of comment records in file."),
'ncomc' : ("int", "Number of characters in use in comment area."),
}
CSPYCE_URL["dasrfr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasrfr_c.html"
#########################################
CSPYCE_ARGNAMES["dasudc"] = ["handle", "first", "last", "bpos", "epos", "data"]
CSPYCE_RETNAMES["dasudc"] = []
CSPYCE_ABSTRACT["dasudc"] = """
Update character data in a specified range of DAS logical addresses with
substrings of a character array.
"""
CSPYCE_DEFINITIONS["dasudc"] = {
'handle': ("int", "DAS file handle."),
'first' : ("int", "Beginning of range of DAS character logical addresses."),
'last'  : ("int", "End of range of DAS character logical addresses."),
'bpos'  : ("int", "Begin position of substrings in byte array."),
'epos'  : ("int", "End position of substrings in byte array."),
'data'  : ("byte_array[*,*]", "Byte array having addresses `first' through `last'."),
}
CSPYCE_URL["dasudc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasudc_c.html"
#########################################
CSPYCE_ARGNAMES["dasudd"] = ["handle", "first", "last", "data"]
CSPYCE_RETNAMES["dasudd"] = []
CSPYCE_ABSTRACT["dasudd"] = """
Update data in a specified range of floating-point addresses in a DAS
file.
"""
CSPYCE_DEFINITIONS["dasudd"] = {
'handle': ("int", "DAS file handle."),
'first' : ("int", "Beginning of range of floating-point addresses to write to."),
'last'  : ("int", "End of range of floating-point addresses to write to."),
'data'  : ("float[*]", "An array of d.p. numbers."),
}
CSPYCE_URL["dasudd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasudd_c.html"
#########################################
CSPYCE_ARGNAMES["dasudi"] = ["handle", "first", "last", "data"]
CSPYCE_RETNAMES["dasudi"] = []
CSPYCE_ABSTRACT["dasudi"] = """
Update data in a specified range of integer addresses in a DAS file.
"""
CSPYCE_DEFINITIONS["dasudi"] = {
'handle': ("int", "DAS file handle."),
'first' : ("int", "Beginning of range of integer addresses to write to."),
'last'  : ("int", "End of range of integer addresses to write to."),
'data'  : ("int[*]", "An array of integers."),
}
CSPYCE_URL["dasudi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dasudi_c.html"
#########################################
CSPYCE_ARGNAMES["daswbr"] = ["handle"]
CSPYCE_RETNAMES["daswbr"] = []
CSPYCE_ABSTRACT["daswbr"] = """
Write out all buffered records of a specified DAS file.
"""
CSPYCE_DEFINITIONS["daswbr"] = {
'handle': ("int", "Handle of DAS file."),
}
CSPYCE_URL["daswbr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/daswbr_c.html"
#########################################
CSPYCE_ARGNAMES["dazldr"] = ["x", "y", "z", "azccw", "elplsz"]
CSPYCE_RETNAMES["dazldr"] = ["jacobi"]
CSPYCE_ABSTRACT["dazldr"] = """
Compute the Jacobian matrix of the transformation from rectangular to
azimuth/elevation coordinates.
"""
CSPYCE_DEFINITIONS["dazldr"] = {
'x'     : ("float", "x-coordinate of point."),
'y'     : ("float", "y-coordinate of point."),
'z'     : ("float", "z-coordinate of point."),
'azccw' : ("bool", "Flag indicating how azimuth is measured, True for counterclockwise, False for clockwise."),
'elplsz': ("bool", "Flag indicating how elevation is measured, True for increasing toward +Z, False for -Z."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["dazldr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dazldr_c.html"
#########################################
CSPYCE_ARGNAMES["dlabbs"] = ["handle"]
CSPYCE_RETNAMES["dlabbs"] = ["dladsc", "found"]
CSPYCE_ABSTRACT["dlabbs"] = """
Begin a backward segment search in a DLA file.
"""
CSPYCE_DEFINITIONS["dlabbs"] = {
'handle': ("int", "Handle of open DLA file."),
'dladsc': ("int[*]", "Descriptor of last segment in DLA file."),
'found' : ("bool", "Flag indicating whether a segment was found."),
}
CSPYCE_URL["dlabbs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlabbs_c.html"
#########################################
CSPYCE_ARGNAMES["dlabfs"] = ["handle"]
CSPYCE_RETNAMES["dlabfs"] = ["dladsc", "found"]
CSPYCE_ABSTRACT["dlabfs"] = """
Begin a forward segment search in a DLA file.
"""
CSPYCE_DEFINITIONS["dlabfs"] = {
'handle': ("int", "Handle of open DLA file."),
'dladsc': ("int[*]", "Descriptor of first segment in DLA file."),
'found' : ("bool", "Flag indicating whether a segment was found."),
}
CSPYCE_URL["dlabfs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlabfs_c.html"
#########################################
CSPYCE_ARGNAMES["dlabns"] = ["handle"]
CSPYCE_RETNAMES["dlabns"] = []
CSPYCE_ABSTRACT["dlabns"] = """
Begin a new segment in a DLA file.
"""
CSPYCE_DEFINITIONS["dlabns"] = {
'handle': ("int", "Handle of open DLA file."),
}
CSPYCE_URL["dlabns"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlabns_c.html"
#########################################
CSPYCE_ARGNAMES["dlaens"] = ["handle"]
CSPYCE_RETNAMES["dlaens"] = []
CSPYCE_ABSTRACT["dlaens"] = """
End a new segment in a DLA file.
"""
CSPYCE_DEFINITIONS["dlaens"] = {
'handle': ("int", "Handle of open DLA file."),
}
CSPYCE_URL["dlaens"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlaens_c.html"
#########################################
CSPYCE_ARGNAMES["dlafns"] = ["handle", "dladsc"]
CSPYCE_RETNAMES["dlafns"] = ["nxtdsc", "found"]
CSPYCE_ABSTRACT["dlafns"] = """
Find the segment following a specified segment in a DLA file.
"""
CSPYCE_DEFINITIONS["dlafns"] = {
'handle': ("int", "Handle of open DLA file."),
'dladsc': ("int[*]", "Descriptor of a DLA segment."),
'nxtdsc': ("int[*]", "Descriptor of next segment in DLA file."),
'found' : ("bool", "Flag indicating whether a segment was found."),
}
CSPYCE_URL["dlafns"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlafns_c.html"
#########################################
CSPYCE_ARGNAMES["dlafps"] = ["handle", "dladsc"]
CSPYCE_RETNAMES["dlafps"] = ["prvdsc", "found"]
CSPYCE_ABSTRACT["dlafps"] = """
Find the segment preceding a specified segment in a DLA file.
"""
CSPYCE_DEFINITIONS["dlafps"] = {
'handle': ("int", "Handle of open DLA file."),
'dladsc': ("int[*]", "Descriptor of a segment in DLA file."),
'prvdsc': ("int[*]", "Descriptor of previous segment in DLA file."),
'found' : ("bool", "Flag indicating whether a segment was found."),
}
CSPYCE_URL["dlafps"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlafps_c.html"
#########################################
CSPYCE_ARGNAMES["dlaopn"] = ["fname", "ftype", "ifname", "ncomch"]
CSPYCE_RETNAMES["dlaopn"] = ["handle"]
CSPYCE_ABSTRACT["dlaopn"] = """
Open a new DLA file and set the file type.
"""
CSPYCE_DEFINITIONS["dlaopn"] = {
'fname' : ("string", "Name of a DLA file to be opened."),
'ftype' : ("string", "Mnemonic code for type of data in the DLA file."),
'ifname': ("string", "Internal file name."),
'ncomch': ("int", "Number of comment characters to allocate."),
'handle': ("int", "Handle assigned to the opened DLA file."),
}
CSPYCE_URL["dlaopn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dlaopn_c.html"
#########################################
CSPYCE_ARGNAMES["dnearp"] = ["state", "a", "b", "c"]
CSPYCE_RETNAMES["dnearp"] = ["dnear", "dalt", "found"]
CSPYCE_ABSTRACT["dnearp"] = """
Compute the state (position and velocity) of an ellipsoid surface point
nearest to the position component of a specified state.
"""
CSPYCE_DEFINITIONS["dnearp"] = {
'state' : ("float[6]", "State of an object in body-fixed coordinates."),
'a'     : ("float", "Length of semi-axis parallel to X-axis."),
'b'     : ("float", "Length of semi-axis parallel to Y-axis."),
'c'     : ("float", "Length on semi-axis parallel to Z-axis."),
'dnear' : ("float[6]", "State of the nearest point on the ellipsoid."),
'dalt'  : ("float[2]", "Altitude and derivative of altitude."),
'found' : ("bool", "Flag that indicates whether `dnear' is degenerate."),
}
CSPYCE_URL["dnearp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dnearp_c.html"
#########################################
CSPYCE_ARGNAMES["dp2hx"] = ["number"]
CSPYCE_RETNAMES["dp2hx"] = ["hxstr"]
CSPYCE_ABSTRACT["dp2hx"] = """
Convert a floating-point number to an equivalent character string using
a base 16 "scientific notation."
"""
CSPYCE_DEFINITIONS["dp2hx"] = {
'number': ("float", "D.p. number to be converted."),
'hxstr' : ("string", "Equivalent character string, left justified."),
}
CSPYCE_URL["dp2hx"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dp2hx_c.html"
#########################################
CSPYCE_ARGNAMES["drdazl"] = ["range", "az", "el", "azccw", "elplsz"]
CSPYCE_RETNAMES["drdazl"] = ["jacobi"]
CSPYCE_ABSTRACT["drdazl"] = """
Compute the Jacobian matrix of the transformation from azimuth/elevation
to rectangular coordinates.
"""
CSPYCE_DEFINITIONS["drdazl"] = {
'range' : ("float", "Distance of a point from the origin."),
'az'    : ("float", "Azimuth of input point in radians."),
'el'    : ("float", "Elevation of input point in radians."),
'azccw' : ("bool", "Flag indicating how azimuth is measured, True for counterclockwise, False for clockwise."),
'elplsz': ("bool", "Flag indicating how elevation is measured, True for increasing toward +Z, False for -Z."),
'jacobi': ("float[3,3]", "Matrix of partial derivatives."),
}
CSPYCE_URL["drdazl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/drdazl_c.html"
#########################################
CSPYCE_ARGNAMES["dskb02"] = ["handle", "dladsc"]
CSPYCE_RETNAMES["dskb02"] = ["nv", "np", "nvxtot", "vtxbds", "voxsiz", "voxori", "vgrext", "cgscal", "vtxnpl", "voxnpt", "voxnpl"]
CSPYCE_ABSTRACT["dskb02"] = """
Return bookkeeping data from a DSK type 2 segment.
"""
CSPYCE_DEFINITIONS["dskb02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'nv'    : ("int", "Number of vertices in model."),
'np'    : ("int", "Number of plates in model."),
'nvxtot': ("int", "Number of voxels in fine grid."),
'vtxbds': ("float[3,2]", "Vertex bounds."),
'voxsiz': ("float", "Fine voxel edge length."),
'voxori': ("float[3]", "Fine voxel grid origin."),
'vgrext': ("int[3]", "Fine voxel grid extent."),
'cgscal': ("int", "Coarse voxel grid scale."),
'vtxnpl': ("int", "Size of vertex-plate correspondence list."),
'voxnpt': ("int", "Size of voxel-plate pointer list."),
'voxnpl': ("int", "Size of voxel-plate correspondence list."),
}
CSPYCE_URL["dskb02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskb02_c.html"
#########################################
CSPYCE_ARGNAMES["dskcls"] = ["handle", "optmiz"]
CSPYCE_RETNAMES["dskcls"] = []
CSPYCE_ABSTRACT["dskcls"] = """
Close a DSK file.
"""
CSPYCE_DEFINITIONS["dskcls"] = {
'handle': ("int", "Handle assigned to the opened DSK file."),
'optmiz': ("bool", "Flag indicating whether to segregate the DSK."),
}
CSPYCE_URL["dskcls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskcls_c.html"
#########################################
CSPYCE_ARGNAMES["dskd02"] = ["handle", "dladsc", "item", "start"]
CSPYCE_RETNAMES["dskd02"] = ["values"]
CSPYCE_ABSTRACT["dskd02"] = """
Fetch floating-point data from a type 2 DSK segment.
"""
CSPYCE_DEFINITIONS["dskd02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'item'  : ("int", "Keyword identifying item to fetch."),
'start' : ("int", "Start index."),
'values': ("float[*]", "Array containing requested item."),
}
CSPYCE_URL["dskd02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskd02_c.html"
#########################################
CSPYCE_ARGNAMES["dskgd"] = ["handle", "dladsc"]
CSPYCE_RETNAMES["dskgd"] = ["dskdsc"]
CSPYCE_ABSTRACT["dskgd"] = """
Return the DSK descriptor from a DSK segment identified by a DAS handle
and DLA descriptor.
"""
CSPYCE_DEFINITIONS["dskgd"] = {
'handle': ("int", "Handle of a DSK file."),
'dladsc': ("int[*]", "DLA segment descriptor."),
'dskdsc': ("float[*]", "DSK segment descriptor."),
}
CSPYCE_URL["dskgd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskgd_c.html"
#########################################
CSPYCE_ARGNAMES["dskgtl"] = ["keywrd"]
CSPYCE_RETNAMES["dskgtl"] = ["dpval"]
CSPYCE_ABSTRACT["dskgtl"] = """
Retrieve the value of a specified DSK tolerance or margin parameter.
"""
CSPYCE_DEFINITIONS["dskgtl"] = {
'keywrd': ("int", "Code specifying parameter to retrieve."),
'dpval' : ("float", "Value of parameter."),
}
CSPYCE_URL["dskgtl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskgtl_c.html"
#########################################
CSPYCE_ARGNAMES["dski02"] = ["handle", "dladsc", "item", "start", "room"]
CSPYCE_RETNAMES["dski02"] = ["n", "values"]
CSPYCE_ABSTRACT["dski02"] = """
Fetch integer data from a type 2 DSK segment.
"""
CSPYCE_DEFINITIONS["dski02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'item'  : ("int", "Keyword identifying item to fetch."),
'start' : ("int", "Start index."),
'room'  : ("int", "Amount of room in output array."),
'n'     : ("int", "Number of values returned."),
'values': ("int", "Array containing requested item."),
}
CSPYCE_URL["dski02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dski02_c.html"
#########################################
CSPYCE_ARGNAMES["dskmi2"] = ["vrtces", "plates", "finscl", "corscl", "makvtl"]
CSPYCE_RETNAMES["dskmi2"] = ["spaixd", "spaixi"]
CSPYCE_ABSTRACT["dskmi2"] = """
Make spatial index for a DSK type 2 segment. The index is returned as a
pair of arrays, one of type int and one of type float. These arrays are
suitable for use with the DSK type 2 writer dskw02.
"""
CSPYCE_DEFINITIONS["dskmi2"] = {
'vrtces': ("float[*,3]", "Vertices."),
'plates': ("int[*,3]", "Plates."),
'finscl': ("float", "Fine voxel scale."),
'corscl': ("int", "Coarse voxel scale."),
'makvtl': ("bool", "Vertex-plate list flag."),
'spaixd': ("float[*]", "Double precision component of spatial index."),
'spaixi': ("int[*]", "Integer component of spatial index."),
}
CSPYCE_URL["dskmi2"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskmi2_c.html"
#########################################
CSPYCE_ARGNAMES["dskn02"] = ["handle", "dladsc", "plid"]
CSPYCE_RETNAMES["dskn02"] = ["normal"]
CSPYCE_ABSTRACT["dskn02"] = """
Compute the unit normal vector for a specified plate from a type 2 DSK
segment.
"""
CSPYCE_DEFINITIONS["dskn02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'plid'  : ("int", "Plate ID."),
'normal': ("float[3]", "Plate's unit normal vector."),
}
CSPYCE_URL["dskn02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskn02_c.html"
#########################################
CSPYCE_ARGNAMES["dskobj"] = ["dskfnm"]
CSPYCE_RETNAMES["dskobj"] = ["bodids"]
CSPYCE_ABSTRACT["dskobj"] = """
Find the set of body ID codes of all objects for which topographic data
are provided in a specified DSK file.
"""
CSPYCE_DEFINITIONS["dskobj"] = {
'dskfnm': ("string", "Name of DSK file."),
'bodids': ("body_code[*]", "Set of ID codes of objects in DSK file."),
}
CSPYCE_URL["dskobj"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskobj_c.html"
#########################################
CSPYCE_ARGNAMES["dskopn"] = ["fname", "ifname", "ncomch"]
CSPYCE_RETNAMES["dskopn"] = ["handle"]
CSPYCE_ABSTRACT["dskopn"] = """
Open a new DSK file for subsequent write operations.
"""
CSPYCE_DEFINITIONS["dskopn"] = {
'fname' : ("string", "Name of a DSK file to be opened."),
'ifname': ("string", "Internal file name."),
'ncomch': ("int", "Number of comment characters to allocate."),
'handle': ("int", "Handle assigned to the opened DSK file."),
}
CSPYCE_URL["dskopn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskopn_c.html"
#########################################
CSPYCE_ARGNAMES["dskp02"] = ["handle", "dladsc", "start"]
CSPYCE_RETNAMES["dskp02"] = ["plates"]
CSPYCE_ABSTRACT["dskp02"] = """
Fetch triangular plates from a type 2 DSK segment.
"""
CSPYCE_DEFINITIONS["dskp02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'start' : ("int", "Start index."),
'plates': ("int[*,3]", "Array containing plates."),
}
CSPYCE_URL["dskp02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskp02_c.html"
#########################################
CSPYCE_ARGNAMES["dskrb2"] = ["vrtces", "plates", "corsys", "corpar"]
CSPYCE_RETNAMES["dskrb2"] = ["mncor3", "mxcor3"]
CSPYCE_ABSTRACT["dskrb2"] = """
Determine range bounds for a set of triangular plates to be stored in a
type 2 DSK segment.
"""
CSPYCE_DEFINITIONS["dskrb2"] = {
'vrtces': ("float[*,3]", "Vertices."),
'plates': ("int[*,3]", "Plates."),
'corsys': ("int", "DSK coordinate system code."),
'corpar': ("float[*]", "DSK coordinate system parameters."),
'mncor3': ("float", "Lower bound on range of third coordinate."),
'mxcor3': ("float", "Upper bound on range of third coordinate."),
}
CSPYCE_URL["dskrb2"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskrb2_c.html"
#########################################
CSPYCE_ARGNAMES["dsksrf"] = ["dskfnm", "bodyid"]
CSPYCE_RETNAMES["dsksrf"] = ["srfids"]
CSPYCE_ABSTRACT["dsksrf"] = """
Find the set of surface ID codes for all surfaces associated with a
given body in a specified DSK file.
"""
CSPYCE_DEFINITIONS["dsksrf"] = {
'dskfnm': ("string", "Name of DSK file."),
'bodyid': ("body_code", "Integer body ID code."),
'srfids': ("int[*]", "Set of ID codes of surfaces in DSK file."),
}
CSPYCE_URL["dsksrf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dsksrf_c.html"
#########################################
CSPYCE_ARGNAMES["dskstl"] = ["keywrd", "dpval"]
CSPYCE_RETNAMES["dskstl"] = []
CSPYCE_ABSTRACT["dskstl"] = """
Set the value of a specified DSK tolerance or margin parameter.
"""
CSPYCE_DEFINITIONS["dskstl"] = {
'keywrd': ("int", "Code specifying parameter to set."),
'dpval' : ("float", "Value of parameter."),
}
CSPYCE_URL["dskstl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskstl_c.html"
#########################################
CSPYCE_ARGNAMES["dskv02"] = ["handle", "dladsc", "start"]
CSPYCE_RETNAMES["dskv02"] = ["vrtces"]
CSPYCE_ABSTRACT["dskv02"] = """
Fetch vertices from a type 2 DSK segment.
"""
CSPYCE_DEFINITIONS["dskv02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'start' : ("int", "Start index."),
'vrtces': ("float[*,3]", "Array containing vertices."),
}
CSPYCE_URL["dskv02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskv02_c.html"
#########################################
CSPYCE_ARGNAMES["dskw02"] = ["handle", "center", "surfid", "dclass", "frame", "corsys", "corpar", "mncor1", "mxcor1", "mncor2", "mxcor2", "mncor3", "mxcor3", "first", "last", "vrtces", "plates", "spaixd", "spaixi"]
CSPYCE_RETNAMES["dskw02"] = []
CSPYCE_ABSTRACT["dskw02"] = """
Write a type 2 segment to a DSK file.
"""
CSPYCE_DEFINITIONS["dskw02"] = {
'handle': ("int", "Handle assigned to the opened DSK file."),
'center': ("body_code", "Central body ID code."),
'surfid': ("int", "Surface ID code."),
'dclass': ("int", "Data class."),
'frame' : ("string", "Reference frame."),
'corsys': ("int", "Coordinate system code."),
'corpar': ("float[*]", "Coordinate system parameters."),
'mncor1': ("float", "Minimum value of first coordinate."),
'mxcor1': ("float", "Maximum value of first coordinate."),
'mncor2': ("float", "Minimum value of second coordinate."),
'mxcor2': ("float", "Maximum value of second coordinate."),
'mncor3': ("float", "Minimum value of third coordinate."),
'mxcor3': ("float", "Maximum value of third coordinate."),
'first' : ("float", "Coverage start time."),
'last'  : ("float", "Coverage stop time."),
'vrtces': ("float[*,3]", "Vertices."),
'plates': ("int[*,3]", "Plates."),
'spaixd': ("float[*]", "Double precision component of spatial index."),
'spaixi': ("int[*]", "Integer component of spatial index."),
}
CSPYCE_URL["dskw02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskw02_c.html"
#########################################
CSPYCE_ARGNAMES["dskx02"] = ["handle", "dladsc", "vertex", "raydir"]
CSPYCE_RETNAMES["dskx02"] = ["plid", "xpt", "found"]
CSPYCE_ABSTRACT["dskx02"] = """
Determine the plate ID and body-fixed coordinates of the intersection of
a specified ray with the surface defined by a type 2 DSK plate model.
"""
CSPYCE_DEFINITIONS["dskx02"] = {
'handle': ("int", "Handle of DSK kernel containing plate model."),
'dladsc': ("int[*]", "DLA descriptor of plate model segment."),
'vertex': ("float[3]", "Ray's vertex in the body fixed frame."),
'raydir': ("float[3]", "Ray direction in the body fixed frame."),
'plid'  : ("int", "ID code of the plate intersected by the ray."),
'xpt'   : ("float[3]", "Intercept."),
'found' : ("bool", "Flag indicating whether intercept exists."),
}
CSPYCE_URL["dskx02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskx02_c.html"
#########################################
CSPYCE_ARGNAMES["dskxsi"] = ["pri", "target", "srflst", "et", "fixref", "vertex", "raydir"]
CSPYCE_RETNAMES["dskxsi"] = ["xpt", "handle", "dladsc", "dskdsc", "dc", "ic", "found"]
CSPYCE_ABSTRACT["dskxsi"] = """
Compute a ray-surface intercept using data provided by multiple loaded
DSK segments. Return information about the source of the data defining
the surface on which the intercept was found: DSK handle, DLA and DSK
descriptors, and DSK data type-dependent parameters.
"""
CSPYCE_DEFINITIONS["dskxsi"] = {
'pri'   : ("bool", "Data prioritization flag."),
'target': ("body_name", "Target body name."),
'srflst': ("int[*]", "Surface ID list."),
'et'    : ("time", "Epoch, expressed as seconds past J2000 TDB."),
'fixref': ("frame_name", "Name of target body-fixed reference frame."),
'vertex': ("float[3]", "Vertex of ray."),
'raydir': ("float[3]", "Direction vector of ray."),
'xpt'   : ("float[3]", "Intercept point."),
'handle': ("int", "Handle of segment contributing surface data."),
'dladsc': ("int[*]", "DLA descriptor of segment."),
'dskdsc': ("float[*]", "DSK descriptor of segment."),
'dc'    : ("float[*]", "Double precision component of source info."),
'ic'    : ("int[*]", "Integer component of source info."),
'found' : ("bool", "Found flag."),
}
CSPYCE_URL["dskxsi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskxsi_c.html"
#########################################
CSPYCE_ARGNAMES["dskxv"] = ["pri", "target", "srflst", "et", "fixref", "vtxarr", "dirarr"]
CSPYCE_RETNAMES["dskxv"] = ["xptarr", "fndarr"]
CSPYCE_ABSTRACT["dskxv"] = """
Compute ray-surface intercepts for a set of rays, using data provided by
multiple loaded DSK segments.
"""
CSPYCE_DEFINITIONS["dskxv"] = {
'pri'   : ("bool", "Data prioritization flag."),
'target': ("body_name", "Target body name."),
'srflst': ("int[*]", "Surface ID list."),
'et'    : ("time", "Epoch, expressed as seconds past J2000 TDB."),
'fixref': ("frame_name", "Name of target body-fixed reference frame."),
'vtxarr': ("float[*,3]", "Array of vertices of rays."),
'dirarr': ("float[*,3]", "Array of direction vectors of rays."),
'xptarr': ("float[*,3]", "Intercept point array."),
'fndarr': ("bool[*]", "Found flag array."),
}
CSPYCE_URL["dskxv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskxv_c.html"
#########################################
CSPYCE_ARGNAMES["dskz02"] = ["handle", "dladsc"]
CSPYCE_RETNAMES["dskz02"] = ["nv", "np"]
CSPYCE_ABSTRACT["dskz02"] = """
Return plate model size parameters---plate count and vertex count---for
a type 2 DSK segment.
"""
CSPYCE_DEFINITIONS["dskz02"] = {
'handle': ("int", "DSK file handle."),
'dladsc': ("int[*]", "DLA descriptor."),
'nv'    : ("int", "Number of vertices."),
'np'    : ("int", "Number of plates."),
}
CSPYCE_URL["dskz02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/dskz02_c.html"
#########################################
CSPYCE_ARGNAMES["ednmpt"] = ["a", "b", "c", "normal"]
CSPYCE_RETNAMES["ednmpt"] = ["point"]
CSPYCE_ABSTRACT["ednmpt"] = """
Return the unique point on an ellipsoid's surface where the outward
normal direction is a given vector.
"""
CSPYCE_DEFINITIONS["ednmpt"] = {
'a'     : ("float", "Length of the ellipsoid semi-axis along the X-axis."),
'b'     : ("float", "Length of the ellipsoid semi-axis along the Y-axis."),
'c'     : ("float", "Length of the ellipsoid semi-axis along the Z-axis."),
'normal': ("float[3]", "Outward normal direction."),
'point' : ("float[3]", "Point where outward normal is parallel to `normal'."),
}
CSPYCE_URL["ednmpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ednmpt_c.html"
#########################################
CSPYCE_ARGNAMES["edpnt"] = ["p", "a", "b", "c"]
CSPYCE_RETNAMES["edpnt"] = ["ep"]
CSPYCE_ABSTRACT["edpnt"] = """
Scale a point so that it lies on the surface of a specified triaxial
ellipsoid that is centered at the origin and aligned with the Cartesian
coordinate axes.
"""
CSPYCE_DEFINITIONS["edpnt"] = {
'p'     : ("float[3]", "A point in three-dimensional space."),
'a'     : ("float", "Semi-axis length in the X direction."),
'b'     : ("float", "Semi-axis length in the Y direction."),
'c'     : ("float", "Semi-axis length in the Z direction."),
'ep'    : ("float[3]", "Point on ellipsoid."),
}
CSPYCE_URL["edpnt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/edpnt_c.html"
#########################################
CSPYCE_ARGNAMES["ekacec"] = ["handle", "segno", "recno", "column", "cvals", "isnull"]
CSPYCE_RETNAMES["ekacec"] = []
CSPYCE_ABSTRACT["ekacec"] = """
Add data to a character column in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekacec"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record to which data is to be added."),
'column': ("string", "Column name."),
'cvals' : ("string[*]", "Character values to add to column."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekacec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekacec_c.html"
#########################################
CSPYCE_ARGNAMES["ekaced"] = ["handle", "segno", "recno", "column", "dvals", "isnull"]
CSPYCE_RETNAMES["ekaced"] = []
CSPYCE_ABSTRACT["ekaced"] = """
Add data to an floating-point column in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekaced"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record to which data is to be added."),
'column': ("string", "Column name."),
'dvals' : ("float[*]", "Double precision values to add to column."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekaced"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekaced_c.html"
#########################################
CSPYCE_ARGNAMES["ekacei"] = ["handle", "segno", "recno", "column", "ivals", "isnull"]
CSPYCE_RETNAMES["ekacei"] = []
CSPYCE_ABSTRACT["ekacei"] = """
Add data to an integer column in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekacei"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record to which data is to be added."),
'column': ("string", "Column name."),
'ivals' : ("int[*]", "Integer values to add to column."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekacei"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekacei_c.html"
#########################################
CSPYCE_ARGNAMES["ekaclc"] = ["handle", "segno", "column", "cvals", "entszs", "nlflgs", "rcptrs"]
CSPYCE_RETNAMES["ekaclc"] = []
CSPYCE_ABSTRACT["ekaclc"] = """
Add an entire character column to an EK segment.
"""
CSPYCE_DEFINITIONS["ekaclc"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Number of segment to add column to."),
'column': ("string", "Column name."),
'cvals' : ("string[*]", "Character values to add to column."),
'entszs': ("int[*]", "Array of sizes of column entries."),
'nlflgs': ("bool[*]", "Array of null flags for column entries."),
'rcptrs': ("int[*]", "Record pointers for segment."),
}
CSPYCE_URL["ekaclc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekaclc_c.html"
#########################################
CSPYCE_ARGNAMES["ekacld"] = ["handle", "segno", "column", "dvals", "entszs", "nlflgs", "rcptrs"]
CSPYCE_RETNAMES["ekacld"] = []
CSPYCE_ABSTRACT["ekacld"] = """
Add an entire floating-point column to an EK segment.
"""
CSPYCE_DEFINITIONS["ekacld"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Number of segment to add column to."),
'column': ("string", "Column name."),
'dvals' : ("float[*]", "Double precision values to add to column."),
'entszs': ("int[*]", "Array of sizes of column entries."),
'nlflgs': ("bool[*]", "Array of null flags for column entries."),
'rcptrs': ("int[*]", "Record pointers for segment."),
}
CSPYCE_URL["ekacld"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekacld_c.html"
#########################################
CSPYCE_ARGNAMES["ekacli"] = ["handle", "segno", "column", "ivals", "entszs", "nlflgs", "rcptrs"]
CSPYCE_RETNAMES["ekacli"] = []
CSPYCE_ABSTRACT["ekacli"] = """
Add an entire integer column to an EK segment.
"""
CSPYCE_DEFINITIONS["ekacli"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Number of segment to add column to."),
'column': ("string", "Column name."),
'ivals' : ("int[*]", "Integer values to add to column."),
'entszs': ("int[*]", "Array of sizes of column entries."),
'nlflgs': ("bool[*]", "Array of null flags for column entries."),
'rcptrs': ("int[*]", "Record pointers for segment."),
}
CSPYCE_URL["ekacli"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekacli_c.html"
#########################################
CSPYCE_ARGNAMES["ekappr"] = ["handle", "segno"]
CSPYCE_RETNAMES["ekappr"] = ["recno"]
CSPYCE_ABSTRACT["ekappr"] = """
Append a new, empty record at the end of a specified E-kernel segment.
"""
CSPYCE_DEFINITIONS["ekappr"] = {
'handle': ("int", "File handle."),
'segno' : ("int", "Segment number."),
'recno' : ("int", "Number of appended record."),
}
CSPYCE_URL["ekappr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekappr_c.html"
#########################################
CSPYCE_ARGNAMES["ekbseg"] = ["handle", "tabnam", "cnames", "decls"]
CSPYCE_RETNAMES["ekbseg"] = ["segno"]
CSPYCE_ABSTRACT["ekbseg"] = """
Start a new segment in an E-kernel.
"""
CSPYCE_DEFINITIONS["ekbseg"] = {
'handle': ("int", "File handle."),
'tabnam': ("string", "Table name."),
'cnames': ("string[*]", "Names of columns."),
'decls' : ("string[*]", "Declarations of columns."),
'segno' : ("int", "Segment number."),
}
CSPYCE_URL["ekbseg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekbseg_c.html"
#########################################
CSPYCE_ARGNAMES["ekccnt"] = ["table"]
CSPYCE_RETNAMES["ekccnt"] = ["ccount"]
CSPYCE_ABSTRACT["ekccnt"] = """
Return the number of distinct columns in a specified, currently loaded
table.
"""
CSPYCE_DEFINITIONS["ekccnt"] = {
'table' : ("string", "Name of table."),
'ccount': ("int", "Count of distinct, currently loaded columns."),
}
CSPYCE_URL["ekccnt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekccnt_c.html"
#########################################
CSPYCE_ARGNAMES["ekcii"] = ["table", "cindex"]
CSPYCE_RETNAMES["ekcii"] = ["column", "cclass", "dtype", "strlen", "size", "indexd", "nullok"]
CSPYCE_ABSTRACT["ekcii"] = """
Return attribute information about a column belonging to a loaded EK
table, specifying the column by table and index.
"""
CSPYCE_DEFINITIONS["ekcii"] = {
'table' : ("string", "Name of table containing column."),
'cindex': ("int", "Index of column whose attributes are to be found."),
'column': ("string", "Name of column."),
'cclass': ("int", "Column class code."),
'dtype' : ("int", "Data type code: 0 for character; 1 for floating-point; 2 for integer; 3 for time."),
'strlen': ("int", "String length."),
'size'  : ("int", "Column entry size; this is the number of array elements in a column entry."),
'indexd': ("bool", "True if the column is indexed; False otherwise."),
'nullok': ("bool", "True if the column may contain null values; False otherwise."),
}
CSPYCE_URL["ekcii"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekcii_c.html"
#########################################
CSPYCE_ARGNAMES["ekcls"] = ["handle"]
CSPYCE_RETNAMES["ekcls"] = []
CSPYCE_ABSTRACT["ekcls"] = """
Close an E-kernel.
"""
CSPYCE_DEFINITIONS["ekcls"] = {
'handle': ("int", "EK file handle."),
}
CSPYCE_URL["ekcls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekcls_c.html"
#########################################
CSPYCE_ARGNAMES["ekdelr"] = ["handle", "segno", "recno"]
CSPYCE_RETNAMES["ekdelr"] = []
CSPYCE_ABSTRACT["ekdelr"] = """
Delete a specified record from a specified E-kernel segment.
"""
CSPYCE_DEFINITIONS["ekdelr"] = {
'handle': ("int", "File handle."),
'segno' : ("int", "Segment number."),
'recno' : ("int", "Record number."),
}
CSPYCE_URL["ekdelr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekdelr_c.html"
#########################################
CSPYCE_ARGNAMES["ekffld"] = ["handle", "segno", "rcptrs"]
CSPYCE_RETNAMES["ekffld"] = []
CSPYCE_ABSTRACT["ekffld"] = """
Complete a fast write operation on a new E-kernel segment.
"""
CSPYCE_DEFINITIONS["ekffld"] = {
'handle': ("int", "File handle."),
'segno' : ("int", "Segment number."),
'rcptrs': ("int[*]", "Record pointers."),
}
CSPYCE_URL["ekffld"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekffld_c.html"
#########################################
CSPYCE_ARGNAMES["ekfind"] = ["query"]
CSPYCE_RETNAMES["ekfind"] = ["nmrows", "error", "errmsg"]
CSPYCE_ABSTRACT["ekfind"] = """
Find E-kernel data that satisfy a set of constraints.
"""
CSPYCE_DEFINITIONS["ekfind"] = {
'query' : ("string", "Query specifying data to be found."),
'nmrows': ("int", "Number of matching rows."),
'error' : ("bool", "Flag indicating whether query parsed correctly."),
'errmsg': ("string", "Parse error description."),
}
CSPYCE_URL["ekfind"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekfind_c.html"
#########################################
CSPYCE_ARGNAMES["ekgc"] = ["selidx", "row", "elment"]
CSPYCE_RETNAMES["ekgc"] = ["cdata", "null", "found"]
CSPYCE_ABSTRACT["ekgc"] = """
Return an element of an entry in a column of character type in a
specified row.
"""
CSPYCE_DEFINITIONS["ekgc"] = {
'selidx': ("int", "Index of parent column in SELECT clause."),
'row'   : ("int", "Row to fetch from."),
'elment': ("int", "Index of element, within column entry, to fetch."),
'cdata' : ("string", "Character string element of column entry."),
'null'  : ("bool", "Flag indicating whether column entry was null."),
'found' : ("bool", "Flag indicating whether column was present in row."),
}
CSPYCE_URL["ekgc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekgc_c.html"
#########################################
CSPYCE_ARGNAMES["ekgd"] = ["selidx", "row", "elment"]
CSPYCE_RETNAMES["ekgd"] = ["ddata", "null", "found"]
CSPYCE_ABSTRACT["ekgd"] = """
Return an element of an entry in a column of floating-point type in a
specified row.
"""
CSPYCE_DEFINITIONS["ekgd"] = {
'selidx': ("int", "Index of parent column in SELECT clause."),
'row'   : ("int", "Row to fetch from."),
'elment': ("int", "Index of element, within column entry, to fetch."),
'ddata' : ("float", "Double precision element of column entry."),
'null'  : ("bool", "Flag indicating whether column entry was null."),
'found' : ("bool", "Flag indicating whether column was present in row."),
}
CSPYCE_URL["ekgd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekgd_c.html"
#########################################
CSPYCE_ARGNAMES["ekgi"] = ["selidx", "row", "elment"]
CSPYCE_RETNAMES["ekgi"] = ["idata", "null", "found"]
CSPYCE_ABSTRACT["ekgi"] = """
Return an element of an entry in a column of integer type in a specified
row.
"""
CSPYCE_DEFINITIONS["ekgi"] = {
'selidx': ("int", "Index of parent column in SELECT clause."),
'row'   : ("int", "Row to fetch from."),
'elment': ("int", "Index of element, within column entry, to fetch."),
'idata' : ("int", "Integer element of column entry."),
'null'  : ("bool", "Flag indicating whether column entry was null."),
'found' : ("bool", "Flag indicating whether column was present in row."),
}
CSPYCE_URL["ekgi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekgi_c.html"
#########################################
CSPYCE_ARGNAMES["ekifld"] = ["handle", "tabnam", "nrows", "cnames", "decls"]
CSPYCE_RETNAMES["ekifld"] = ["segno", "rcptrs"]
CSPYCE_ABSTRACT["ekifld"] = """
Initialize a new E-kernel segment to allow fast writing.
"""
CSPYCE_DEFINITIONS["ekifld"] = {
'handle': ("int", "File handle."),
'tabnam': ("string", "Table name."),
'nrows' : ("int", "Number of rows in the segment."),
'cnames': ("string[*]", "Names of columns."),
'decls' : ("string[*]", "Declarations of columns."),
'segno' : ("int", "Segment number."),
'rcptrs': ("int[*]", "Array of record pointers."),
}
CSPYCE_URL["ekifld"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekifld_c.html"
#########################################
CSPYCE_ARGNAMES["ekinsr"] = ["handle", "segno", "recno"]
CSPYCE_RETNAMES["ekinsr"] = []
CSPYCE_ABSTRACT["ekinsr"] = """
Add a new, empty record to a specified E-kernel segment at a specified
index.
"""
CSPYCE_DEFINITIONS["ekinsr"] = {
'handle': ("int", "File handle."),
'segno' : ("int", "Segment number."),
'recno' : ("int", "Record number."),
}
CSPYCE_URL["ekinsr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekinsr_c.html"
#########################################
CSPYCE_ARGNAMES["eklef"] = ["fname"]
CSPYCE_RETNAMES["eklef"] = ["handle"]
CSPYCE_ABSTRACT["eklef"] = """
Load an EK file, making it accessible to the EK readers.
"""
CSPYCE_DEFINITIONS["eklef"] = {
'fname' : ("string", "Name of EK file to load."),
'handle': ("int", "File handle of loaded EK file."),
}
CSPYCE_URL["eklef"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/eklef_c.html"
#########################################
CSPYCE_ARGNAMES["eknelt"] = ["selidx", "row"]
CSPYCE_RETNAMES["eknelt"] = ["count"]
CSPYCE_ABSTRACT["eknelt"] = """
Return the number of elements in a specified column entry in the current
row.
"""
CSPYCE_DEFINITIONS["eknelt"] = {
'selidx': ("int", "Index of parent column in SELECT clause."),
'row'   : ("int", "Row containing element."),
'count' : ("int", "Number of elements in column."),
}
CSPYCE_URL["eknelt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/eknelt_c.html"
#########################################
CSPYCE_ARGNAMES["eknseg"] = ["handle"]
CSPYCE_RETNAMES["eknseg"] = ["count"]
CSPYCE_ABSTRACT["eknseg"] = """
Return the number of segments in a specified EK.
"""
CSPYCE_DEFINITIONS["eknseg"] = {
'handle': ("int", "EK file handle."),
'count' : ("int", "Numer of segments."),
}
CSPYCE_URL["eknseg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/eknseg_c.html"
#########################################
CSPYCE_ARGNAMES["ekntab"] = []
CSPYCE_RETNAMES["ekntab"] = ["n"]
CSPYCE_ABSTRACT["ekntab"] = """
Return the number of loaded EK tables.
"""
CSPYCE_DEFINITIONS["ekntab"] = {
'n'     : ("int", "Number of loaded tables."),
}
CSPYCE_URL["ekntab"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekntab_c.html"
#########################################
CSPYCE_ARGNAMES["ekopn"] = ["fname", "ifname"]
CSPYCE_RETNAMES["ekopn"] = ["handle"]
CSPYCE_ABSTRACT["ekopn"] = """
Open a new E-kernel file and prepare the file for writing.
"""
CSPYCE_DEFINITIONS["ekopn"] = {
'fname' : ("string", "Name of EK file."),
'ifname': ("string", "Internal file name."),
'handle': ("int[*]", "Handle attached to new EK file."),
}
CSPYCE_URL["ekopn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekopn_c.html"
#########################################
CSPYCE_ARGNAMES["ekopr"] = ["fname"]
CSPYCE_RETNAMES["ekopr"] = ["handle"]
CSPYCE_ABSTRACT["ekopr"] = """
Open an existing E-kernel file for reading.
"""
CSPYCE_DEFINITIONS["ekopr"] = {
'fname' : ("string", "Name of EK file."),
'handle': ("int", "Handle attached to EK file."),
}
CSPYCE_URL["ekopr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekopr_c.html"
#########################################
CSPYCE_ARGNAMES["ekops"] = []
CSPYCE_RETNAMES["ekops"] = ["handle"]
CSPYCE_ABSTRACT["ekops"] = """
Open a scratch (temporary) E-kernel file and prepare the file for
writing.
"""
CSPYCE_DEFINITIONS["ekops"] = {
'handle': ("int", "File handle attached to new EK file."),
}
CSPYCE_URL["ekops"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekops_c.html"
#########################################
CSPYCE_ARGNAMES["ekopw"] = ["fname"]
CSPYCE_RETNAMES["ekopw"] = ["handle"]
CSPYCE_ABSTRACT["ekopw"] = """
Open an existing E-kernel file for writing.
"""
CSPYCE_DEFINITIONS["ekopw"] = {
'fname' : ("string", "Name of EK file."),
'handle': ("int", "Handle attached to EK file."),
}
CSPYCE_URL["ekopw"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekopw_c.html"
#########################################
CSPYCE_ARGNAMES["ekpsel"] = ["query"]
CSPYCE_RETNAMES["ekpsel"] = ["xbegs", "xends", "xtypes", "xclass", "tabs", "cols", "error", "errmsg"]
CSPYCE_ABSTRACT["ekpsel"] = """
Parse the SELECT clause of an EK query, returning full particulars
concerning each selected item.
"""
CSPYCE_DEFINITIONS["ekpsel"] = {
'query' : ("string", "EK query."),
'xbegs' : ("int[*]", "Begin positions of expressions in SELECT clause."),
'xends' : ("int[*]", "End positions of expressions in SELECT clause."),
'xtypes': ("int[*]", "Data types of expressions."),
'xclass': ("int[*]", "Classes of expressions."),
'tabs'  : ("string[*]", "Names of tables qualifying SELECT columns."),
'cols'  : ("string[*]", "Names of columns in SELECT clause of `query'."),
'error' : ("bool", "Error flag."),
'errmsg': ("string", "Parse error message."),
}
CSPYCE_URL["ekpsel"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekpsel_c.html"
#########################################
CSPYCE_ARGNAMES["ekrcec"] = ["handle", "segno", "recno", "column"]
CSPYCE_RETNAMES["ekrcec"] = ["cvals", "isnull"]
CSPYCE_ABSTRACT["ekrcec"] = """
Read data from a character column in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekrcec"] = {
'handle': ("int", "Handle attached to EK file."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record from which data is to be read."),
'column': ("string", "Column name."),
'cvals' : ("string[*]", "Character values in column entry."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekrcec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekrcec_c.html"
#########################################
CSPYCE_ARGNAMES["ekrced"] = ["handle", "segno", "recno", "column"]
CSPYCE_RETNAMES["ekrced"] = ["dvals", "isnull"]
CSPYCE_ABSTRACT["ekrced"] = """
Read data from a floating-point column in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekrced"] = {
'handle': ("int", "Handle attached to EK file."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record from which data is to be read."),
'column': ("string", "Column name."),
'dvals' : ("float[*]", "D.p. values in column entry."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekrced"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekrced_c.html"
#########################################
CSPYCE_ARGNAMES["ekrcei"] = ["handle", "segno", "recno", "column"]
CSPYCE_RETNAMES["ekrcei"] = ["ivals", "isnull"]
CSPYCE_ABSTRACT["ekrcei"] = """
Read data from an integer column in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekrcei"] = {
'handle': ("int", "Handle attached to EK file."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record from which data is to be read."),
'column': ("string", "Column name."),
'ivals' : ("int[*]", "Integer values in column entry."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekrcei"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekrcei_c.html"
#########################################
CSPYCE_ARGNAMES["ekssum"] = ["handle", "segno"]
CSPYCE_RETNAMES["ekssum"] = ["tabnam", "ncols", "cnames", "cclass", "dtype", "strln", "size", "indexd", "nullok"]
CSPYCE_ABSTRACT["ekssum"] = """
Return summary information for a specified segment in a specified EK.
"""
CSPYCE_DEFINITIONS["ekssum"] = {
'handle': ("int", "Handle of EK."),
'segno' : ("int", "Number of segment to be summarized."),
'tabnam': ("string", "The name of the table to which the segment belongs."),
'ncols' : ("int", "The number of columns in the segment."),
'cnames': ("string[*]", "Column names."),
'cclass': ("int[*]", "Column class codes."),
'dtype' : ("int[*]", "Data type codes: 0 for character; 1 for floating-point; 2 for integer; 3 for time."),
'strln' : ("int[*]", "String lengths."),
'size'  : ("int[*]", "Column entry sizes; this is the number of array elements in a column entry."),
'indexd': ("bool[*]", "True if the column is indexed; False otherwise."),
'nullok': ("bool[*]", "True if the column may contain null values; False otherwise."),
}
CSPYCE_URL["ekssum"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekssum_c.html"
#########################################
CSPYCE_ARGNAMES["ektnam"] = ["n"]
CSPYCE_RETNAMES["ektnam"] = ["table"]
CSPYCE_ABSTRACT["ektnam"] = """
Return the name of a specified, loaded table.
"""
CSPYCE_DEFINITIONS["ektnam"] = {
'n'     : ("int", "Index of table."),
'table' : ("string", "Name of table."),
}
CSPYCE_URL["ektnam"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ektnam_c.html"
#########################################
CSPYCE_ARGNAMES["ekucec"] = ["handle", "segno", "recno", "column", "cvals", "isnull"]
CSPYCE_RETNAMES["ekucec"] = []
CSPYCE_ABSTRACT["ekucec"] = """
Update a character column entry in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekucec"] = {
'handle': ("int", "EK file handle."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record to which data is to be updated."),
'column': ("string", "Column name."),
'cvals' : ("string[*]", "Character values comprising new column entry."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekucec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekucec_c.html"
#########################################
CSPYCE_ARGNAMES["ekuced"] = ["handle", "segno", "recno", "column", "dvals", "isnull"]
CSPYCE_RETNAMES["ekuced"] = []
CSPYCE_ABSTRACT["ekuced"] = """
Update a floating-point column entry in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekuced"] = {
'handle': ("int", "Handle attached to EK file."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record in which entry is to be updated."),
'column': ("string", "Column name."),
'dvals' : ("float[*]", "Double precision values comprising new column entry."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekuced"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekuced_c.html"
#########################################
CSPYCE_ARGNAMES["ekucei"] = ["handle", "segno", "recno", "column", "ivals", "isnull"]
CSPYCE_RETNAMES["ekucei"] = []
CSPYCE_ABSTRACT["ekucei"] = """
Update an integer column entry in a specified EK record.
"""
CSPYCE_DEFINITIONS["ekucei"] = {
'handle': ("int", "Handle attached to EK file."),
'segno' : ("int", "Index of segment containing record."),
'recno' : ("int", "Record in which entry is to be updated."),
'column': ("string", "Column name."),
'ivals' : ("int[*]", "Integer values comprising new column entry."),
'isnull': ("bool", "Flag indicating whether column entry is null."),
}
CSPYCE_URL["ekucei"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekucei_c.html"
#########################################
CSPYCE_ARGNAMES["ekuef"] = ["handle"]
CSPYCE_RETNAMES["ekuef"] = []
CSPYCE_ABSTRACT["ekuef"] = """
Unload an EK file, making its contents inaccessible to the EK reader
routines, and clearing space in order to allow other EK files to be
loaded.
"""
CSPYCE_DEFINITIONS["ekuef"] = {
'handle': ("int", "Handle of EK file."),
}
CSPYCE_URL["ekuef"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ekuef_c.html"
#########################################
CSPYCE_ARGNAMES["evsgp4"] = ["et", "geophs", "elems"]
CSPYCE_RETNAMES["evsgp4"] = ["state"]
CSPYCE_ABSTRACT["evsgp4"] = """
Evaluate NORAD two-line element data for earth orbiting spacecraft. This
evaluator uses algorithms as described in Vallado 2006 [4].
"""
CSPYCE_DEFINITIONS["evsgp4"] = {
'et'    : ("time", "Epoch in seconds past ephemeris epoch J2000."),
'geophs': ("float[8]", "Geophysical constants"),
'elems' : ("float[*]", "Two-line element data"),
'state' : ("float[6]", "Evaluated state"),
}
CSPYCE_URL["evsgp4"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/evsgp4_c.html"
#########################################
CSPYCE_ARGNAMES["esrchc"] = ["value", "array"]
CSPYCE_RETNAMES["esrchc"] = ["index"]
CSPYCE_ABSTRACT["esrchc"] = """
Search for a given value within a character string array. Return the
index of the first equivalent array entry, or -1 if no equivalent
element is found.
"""
CSPYCE_DEFINITIONS["esrchc"] = {
'value' : ("string", "Key value to be found in array."),
'array' : ("string[*]", "Character string array to search."),
'index' : ("int", "Index of entry in array."),
}
CSPYCE_URL["esrchc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/esrchc_c.html"
#########################################
CSPYCE_ARGNAMES["getelm"] = ["frstyr", "lines"]
CSPYCE_RETNAMES["getelm"] = ["epoch", "elems"]
CSPYCE_ABSTRACT["getelm"] = """
Parse the "lines" of a two-line element set, returning the elements in
units suitable for use in SPICE software.
"""
CSPYCE_DEFINITIONS["getelm"] = {
'frstyr': ("int", "Year of earliest representable two-line elements."),
'lines' : ("string[2]", "A pair of \"lines\" containing two-line elements."),
'epoch' : ("time", "The epoch of the elements in seconds past J2000."),
'elems' : ("float[*]", "The elements converted to SPICE units."),
}
CSPYCE_URL["getelm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/getelm_c.html"
#########################################
CSPYCE_ARGNAMES["getfat"] = ["file"]
CSPYCE_RETNAMES["getfat"] = ["arch", "kertyp"]
CSPYCE_ABSTRACT["getfat"] = """
Determine the file architecture and file type of most SPICE kernel
files.
"""
CSPYCE_DEFINITIONS["getfat"] = {
'file'  : ("string", "The name of a file to be examined."),
'arch'  : ("string", "The architecture of the kernel file."),
'kertyp': ("string", "The type of the kernel file."),
}
CSPYCE_URL["getfat"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/getfat_c.html"
#########################################
CSPYCE_ARGNAMES["getfvn"] = ["inst"]
CSPYCE_RETNAMES["getfvn"] = ["shape", "frame", "bsight", "bounds"]
CSPYCE_ABSTRACT["getfvn"] = """
Return the field-of-view (FOV) parameters for a specified instrument.
The instrument is specified by name.
"""
CSPYCE_DEFINITIONS["getfvn"] = {
'inst'  : ("string", "Name of an instrument."),
'shape' : ("string", "Instrument FOV shape."),
'frame' : ("string", "Name of the frame in which FOV vectors are defined."),
'bsight': ("float[3]", "Boresight vector."),
'bounds': ("float[*,3]", "FOV boundary vectors."),
}
CSPYCE_URL["getfvn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/getfvn_c.html"
#########################################
CSPYCE_ARGNAMES["gfdist"] = ["target", "abcorr", "obsrvr", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfdist"] = ["windows"]
CSPYCE_ABSTRACT["gfdist"] = """
Return the time window over which a specified constraint on
observer-target distance is met.
"""
CSPYCE_DEFINITIONS["gfdist"] = {
'target': ("body_name", "Name of the target body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Step size used for locating extrema and roots."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfdist"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfdist_c.html"
#########################################
CSPYCE_ARGNAMES["gfevnt"] = ["step", "gquant", "qpnams", "qcpars", "qdpars", "qipars", "qlpars", "op", "refval", "tol", "adjust", "rpt", "et0", "et1"]
CSPYCE_RETNAMES["gfevnt"] = ["windows"]
CSPYCE_ABSTRACT["gfevnt"] = """
Determine time intervals when a specified geometric quantity satisfies a
specified mathematical condition.
"""
CSPYCE_DEFINITIONS["gfevnt"] = {
'step'  : ("float", "Time step for searching."),
'gquant': ("string", "Type of geometric quantity."),
'qpnams': ("string[*]", "Names of quantity definition parameters."),
'qcpars': ("string[*]", "Array of character quantity definition parameters."),
'qdpars': ("float[*]", "Array of floating-point quantity definition parameters."),
'qipars': ("int[*]", "Array of integer quantity definition parameters."),
'qlpars': ("bool[*]", "Array of logical quantity definition parameters."),
'op'    : ("string", "Operator that either looks for an extreme value (max, min, local, absolute) or compares the geometric quantity value and a number."),
'refval': ("float", "Reference value."),
'tol'   : ("float", "Convergence tolerance in seconds"),
'adjust': ("float", "Absolute extremum adjustment value."),
'rpt'   : ("bool", "Progress reporter on (True) or off (False)."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfevnt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfevnt_c.html"
#########################################
CSPYCE_ARGNAMES["gffove"] = ["inst", "tshape", "raydir", "target", "tframe", "abcorr", "obsrvr", "tol", "step", "rpt", "et0", "et1"]
CSPYCE_RETNAMES["gffove"] = ["windows"]
CSPYCE_ABSTRACT["gffove"] = """
Determine time intervals when a specified target body or ray intersects
the space bounded by the field-of-view (FOV) of a specified instrument.
Report progress and handle interrupts if so commanded.
"""
CSPYCE_DEFINITIONS["gffove"] = {
'inst'  : ("string", "Name of the instrument."),
'tshape': ("string", "Type of shape model used for target body."),
'raydir': ("float[3]", "Ray's direction vector."),
'target': ("body_name", "Name of the target body."),
'tframe': ("frame_name", "Body-fixed, body-centered frame for target body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'tol'   : ("float", "Convergence tolerance in seconds."),
'step'  : ("float", "Time step for searching."),
'rpt'   : ("bool", "Progress report flag."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gffove"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gffove_c.html"
#########################################
CSPYCE_ARGNAMES["gfilum"] = ["method", "angtyp", "target", "illmn", "fixref", "abcorr", "obsrvr", "spoint", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfilum"] = ["windows"]
CSPYCE_ABSTRACT["gfilum"] = """
Return the time window over which a specified constraint on the observed
phase, solar incidence, or emission angle at a specified target body
surface point is met.
"""
CSPYCE_DEFINITIONS["gfilum"] = {
'method': ("string", "Computation method."),
'angtyp': ("string", "Type of illumination angle."),
'target': ("body_name", "Name of the target body."),
'illmn' : ("body_name", "Name of the illumination source."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'spoint': ("float[3]", "Body-fixed coordinates of a target surface point."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfilum"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfilum_c.html"
#########################################
CSPYCE_ARGNAMES["gfocce"] = ["occtyp", "front", "fshape", "fframe", "back", "bshape", "bframe", "abcorr", "obsrvr", "tol", "step", "rpt", "et0", "et1"]
CSPYCE_RETNAMES["gfocce"] = ["windows"]
CSPYCE_ABSTRACT["gfocce"] = """
Determine time intervals when an observer sees one target occulted by
another. Report progress and handle interrupts if so commanded. The
surfaces of the target bodies may be represented by triaxial ellipsoids
or by topographic data provided by DSK files.
"""
CSPYCE_DEFINITIONS["gfocce"] = {
'occtyp': ("string", "Type of occultation."),
'front' : ("body_name", "Name of body occulting the other."),
'fshape': ("string", "Type of shape model used for front body."),
'fframe': ("frame_name", "Body-fixed, body-centered frame for front body."),
'back'  : ("body_name", "Name of body occulted by the other."),
'bshape': ("string", "Type of shape model used for back body."),
'bframe': ("frame_name", "Body-fixed, body-centered frame for back body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'tol'   : ("float", "Convergence tolerance in seconds."),
'step'  : ("float", "Time step for searching."),
'rpt'   : ("bool", "Progress report flag."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfocce"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfocce_c.html"
#########################################
CSPYCE_ARGNAMES["gfoclt"] = ["occtyp", "front", "fshape", "fframe", "back", "bshape", "bframe", "abcorr", "obsrvr", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfoclt"] = ["windows"]
CSPYCE_ABSTRACT["gfoclt"] = """
Determine time intervals when an observer sees one target occulted by,
or in transit across, another. The surfaces of the target bodies may be
represented by triaxial ellipsoids or by topographic data provided by
DSK files.
"""
CSPYCE_DEFINITIONS["gfoclt"] = {
'occtyp': ("string", "Type of occultation."),
'front' : ("body_name", "Name of body occulting the other."),
'fshape': ("string", "Type of shape model used for front body."),
'fframe': ("frame_name", "Body-fixed, body-centered frame for front body."),
'back'  : ("body_name", "Name of body occulted by the other."),
'bshape': ("string", "Type of shape model used for back body."),
'bframe': ("frame_name", "Body-fixed, body-centered frame for back body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfoclt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfoclt_c.html"
#########################################
CSPYCE_ARGNAMES["gfpa"] = ["target", "illmn", "abcorr", "obsrvr", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfpa"] = ["windows"]
CSPYCE_ABSTRACT["gfpa"] = """
Determine time intervals for which a specified constraint on the phase
angle between an illumination source, a target, and observer body
centers is met.
"""
CSPYCE_DEFINITIONS["gfpa"] = {
'target': ("body_name", "Name of the target body."),
'illmn' : ("body_name", "Name of the illuminating body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfpa"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfpa_c.html"
#########################################
CSPYCE_ARGNAMES["gfposc"] = ["target", "frame", "abcorr", "obsrvr", "crdsys", "coord", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfposc"] = ["windows"]
CSPYCE_ABSTRACT["gfposc"] = """
Determine time intervals for which a coordinate of an observer-target
position vector satisfies a numerical constraint.
"""
CSPYCE_DEFINITIONS["gfposc"] = {
'target': ("body_name", "Name of the target body."),
'frame' : ("string", "Name of the reference frame for coordinate calculations."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'crdsys': ("string", "Name of the coordinate system containing `coord'."),
'coord' : ("string", "Name of the coordinate of interest."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfposc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfposc_c.html"
#########################################
CSPYCE_ARGNAMES["gfrfov"] = ["inst", "raydir", "rframe", "abcorr", "obsrvr", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfrfov"] = ["windows"]
CSPYCE_ABSTRACT["gfrfov"] = """
Determine time intervals when a specified ray intersects the space
bounded by the field-of-view (FOV) of a specified instrument.
"""
CSPYCE_DEFINITIONS["gfrfov"] = {
'inst'  : ("string", "Name of the instrument."),
'raydir': ("float[3]", "Ray's direction vector."),
'rframe': ("frame_name", "Reference frame of ray's direction vector."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfrfov"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfrfov_c.html"
#########################################
CSPYCE_ARGNAMES["gfrr"] = ["target", "abcorr", "obsrvr", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfrr"] = ["windows"]
CSPYCE_ABSTRACT["gfrr"] = """
Determine time intervals for which a specified constraint on the
observer-target range rate is met.
"""
CSPYCE_DEFINITIONS["gfrr"] = {
'target': ("body_name", "Name of the target body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfrr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfrr_c.html"
#########################################
CSPYCE_ARGNAMES["gfsep"] = ["targ1", "shape1", "frame1", "targ2", "shape2", "frame2", "abcorr", "obsrvr", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfsep"] = ["windows"]
CSPYCE_ABSTRACT["gfsep"] = """
Determine time intervals when the angular separation between the
position vectors of two target bodies relative to an observer satisfies
a numerical relationship.
"""
CSPYCE_DEFINITIONS["gfsep"] = {
'targ1' : ("body_name", "Name of first body."),
'shape1': ("string", "Name of shape model describing the first body."),
'frame1': ("frame_name", "The body-fixed reference frame of the first body."),
'targ2' : ("body_name", "Name of second body."),
'shape2': ("string", "Name of the shape model describing the second body."),
'frame2': ("frame_name", "The body-fixed reference frame of the second body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'relate': ("string", "Operator that either looks for an extreme value (max, min, local, absolute) or compares the angular separation value and `refval'."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Absolute extremum adjustment value."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfsep"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfsep_c.html"
#########################################
CSPYCE_ARGNAMES["gfsntc"] = ["target", "fixref", "method", "abcorr", "obsrvr", "dref", "dvec", "crdsys", "coord", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfsntc"] = ["windows"]
CSPYCE_ABSTRACT["gfsntc"] = """
Determine time intervals for which a coordinate of an surface intercept
position vector satisfies a numerical constraint.
"""
CSPYCE_DEFINITIONS["gfsntc"] = {
'target': ("body_name", "Name of the target body."),
'fixref': ("frame_name", "Body fixed frame associated with `target'."),
'method': ("string", "Name of method type for surface intercept calculation."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'dref'  : ("frame_name", "Reference frame of direction vector `dvec'."),
'dvec'  : ("float[3]", "Pointing direction vector from `obsrvr'."),
'crdsys': ("string", "Name of the coordinate system containing `coord'."),
'coord' : ("string", "Name of the coordinate of interest."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfsntc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfsntc_c.html"
#########################################
CSPYCE_ARGNAMES["gfstol"] = ["value"]
CSPYCE_RETNAMES["gfstol"] = []
CSPYCE_ABSTRACT["gfstol"] = """
Override the default GF convergence value used in the high level GF
routines.
"""
CSPYCE_DEFINITIONS["gfstol"] = {
'value' : ("float", "Double precision value returned or to store."),
}
CSPYCE_URL["gfstol"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfstol_c.html"
#########################################
CSPYCE_ARGNAMES["gfsubc"] = ["target", "fixref", "method", "abcorr", "obsrvr", "crdsys", "coord", "relate", "refval", "adjust", "step", "et0", "et1"]
CSPYCE_RETNAMES["gfsubc"] = ["windows"]
CSPYCE_ABSTRACT["gfsubc"] = """
Determine time intervals for which a coordinate of an subpoint position
vector satisfies a numerical constraint.
"""
CSPYCE_DEFINITIONS["gfsubc"] = {
'target': ("body_name", "Name of the target body."),
'fixref': ("frame_name", "Body fixed frame associated with `target'."),
'method': ("string", "Name of method type for subpoint calculation."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'crdsys': ("string", "Name of the coordinate system containing `coord'."),
'coord' : ("string", "Name of the coordinate of interest."),
'relate': ("string", "Relational operator."),
'refval': ("float", "Reference value."),
'adjust': ("float", "Adjustment value for absolute extrema searches."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gfsubc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gfsubc_c.html"
#########################################
CSPYCE_ARGNAMES["gftfov"] = ["inst", "target", "tshape", "tframe", "abcorr", "obsrvr", "step", "et0", "et1"]
CSPYCE_RETNAMES["gftfov"] = ["windows"]
CSPYCE_ABSTRACT["gftfov"] = """
Determine time intervals when a specified ephemeris object intersects
the space bounded by the field-of-view (FOV) of a specified instrument.
"""
CSPYCE_DEFINITIONS["gftfov"] = {
'inst'  : ("string", "Name of the instrument."),
'target': ("body_name", "Name of the target body."),
'tshape': ("string", "Type of shape model used for target body."),
'tframe': ("frame_name", "Body-fixed, body-centered frame for target body."),
'abcorr': ("string", "Aberration correction flag."),
'obsrvr': ("body_name", "Name of the observing body."),
'step'  : ("float", "Time step for searching."),
'et0'   : ("time", "Beginning time of search window."),
'et1'   : ("time", "End time of search window."),
'windows': ("time[*,2]", "Array giving start/stop time pairs for the intervals found."),
}
CSPYCE_URL["gftfov"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/gftfov_c.html"
#########################################
CSPYCE_ARGNAMES["hrmesp"] = ["first", "step", "yvals", "x"]
CSPYCE_RETNAMES["hrmesp"] = ["f", "df"]
CSPYCE_ABSTRACT["hrmesp"] = """
Evaluate, at a specified point, a Hermite interpolating polynomial for a
specified set of equally spaced abscissa values and corresponding pairs
of function and function derivative values.
"""
CSPYCE_DEFINITIONS["hrmesp"] = {
'first' : ("float", "First abscissa value."),
'step'  : ("float", "Step size."),
'yvals' : ("float[*]", "Ordinate and derivative values."),
'x'     : ("float", "Point at which to interpolate the polynomial."),
'f'     : ("float", "Interpolated function value at `x'."),
'df'    : ("float", "Interpolated function's derivative at `x'."),
}
CSPYCE_URL["hrmesp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/hrmesp_c.html"
#########################################
CSPYCE_ARGNAMES["hrmint"] = ["xvals", "yvals", "x"]
CSPYCE_RETNAMES["hrmint"] = ["f", "df"]
CSPYCE_ABSTRACT["hrmint"] = """
Evaluate a Hermite interpolating polynomial at a specified abscissa
value.
"""
CSPYCE_DEFINITIONS["hrmint"] = {
'xvals' : ("float[*]", "Abscissa values."),
'yvals' : ("float[*,2]", "Ordinate and derivative values."),
'x'     : ("float", "Point at which to interpolate the polynomial."),
'f'     : ("float", "Interpolated function value at `x'."),
'df'    : ("float", "Interpolated function's derivative at `x'."),
}
CSPYCE_URL["hrmint"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/hrmint_c.html"
#########################################
CSPYCE_ARGNAMES["hx2dp"] = ["string"]
CSPYCE_RETNAMES["hx2dp"] = ["number", "error", "errmsg"]
CSPYCE_ABSTRACT["hx2dp"] = """
Convert a string representing a floating-point number in a base 16
"scientific notation" into its equivalent double precision number.
"""
CSPYCE_DEFINITIONS["hx2dp"] = {
'string': ("string", "Hex form string to convert to floating-point."),
'number': ("float", "Double precision value to be returned."),
'error' : ("bool", "A logical flag which is True on error."),
'errmsg': ("string", "A descriptive error message."),
}
CSPYCE_URL["hx2dp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/hx2dp_c.html"
#########################################
CSPYCE_ARGNAMES["invstm"] = ["mat"]
CSPYCE_RETNAMES["invstm"] = ["invmat"]
CSPYCE_ABSTRACT["invstm"] = """
Return the inverse of a state transformation matrix.
"""
CSPYCE_DEFINITIONS["invstm"] = {
'mat'   : ("float[6,6]", "A state transformation matrix."),
'invmat': ("float[6,6]", "The inverse of `mat'."),
}
CSPYCE_URL["invstm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/invstm_c.html"
#########################################
CSPYCE_ARGNAMES["isrchc"] = ["value", "array"]
CSPYCE_RETNAMES["isrchc"] = ["index"]
CSPYCE_ABSTRACT["isrchc"] = """
Search for a given value within a character string array. Return the
index of the first matching array entry, or -1 if the key value was not
found.
"""
CSPYCE_DEFINITIONS["isrchc"] = {
'value' : ("string", "Key value to be found in array."),
'array' : ("string[*]", "Character string array to search."),
'index' : ("int", "Index of matching array entry."),
}
CSPYCE_URL["isrchc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/isrchc_c.html"
#########################################
CSPYCE_ARGNAMES["isrchd"] = ["value", "array"]
CSPYCE_RETNAMES["isrchd"] = ["index"]
CSPYCE_ABSTRACT["isrchd"] = """
Search for a given value within a floating-point array. Return the index
of the first matching array entry, or -1 if the key value was not found.
"""
CSPYCE_DEFINITIONS["isrchd"] = {
'value' : ("float", "Key value to be found in array."),
'array' : ("float[*]", "Double Precision array to search."),
'index' : ("int", "Index of matching array entry."),
}
CSPYCE_URL["isrchd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/isrchd_c.html"
#########################################
CSPYCE_ARGNAMES["isrchi"] = ["value", "array"]
CSPYCE_RETNAMES["isrchi"] = ["index"]
CSPYCE_ABSTRACT["isrchi"] = """
Search for a given value within an integer array. Return the index of
the first matching array entry, or -1 if the key value was not found.
"""
CSPYCE_DEFINITIONS["isrchi"] = {
'value' : ("int", "Key value to be found in array."),
'array' : ("int[*]", "Integer array to search."),
'index' : ("int", "Index of matching array entry."),
}
CSPYCE_URL["isrchi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/isrchi_c.html"
#########################################
CSPYCE_ARGNAMES["isordv"] = ["array"]
CSPYCE_RETNAMES["isordv"] = ["flag"]
CSPYCE_ABSTRACT["isordv"] = """
Determine whether an array of n items contains the integers 0 through
n-1.
"""
CSPYCE_DEFINITIONS["isordv"] = {
'array' : ("int[*]", "Array of integers."),
'flag'  : ("bool", "True if the condition is satisfied; False otherwise."),
}
CSPYCE_URL["isordv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/isordv_c.html"
#########################################
CSPYCE_ARGNAMES["iswhsp"] = ["string"]
CSPYCE_RETNAMES["iswhsp"] = ["flag"]
CSPYCE_ABSTRACT["iswhsp"] = """
Return a boolean value indicating whether a string contains only white
space characters.
"""
CSPYCE_DEFINITIONS["iswhsp"] = {
'string': ("string", "String to be tested."),
'flag'  : ("bool", "True if the condition is satisfied; False otherwise."),
}
CSPYCE_URL["iswhsp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/iswhsp_c.html"
#########################################
CSPYCE_ARGNAMES["kclear"] = []
CSPYCE_RETNAMES["kclear"] = []
CSPYCE_ABSTRACT["kclear"] = """
Clear the KEEPER subsystem: unload all kernels, clear the kernel pool,
and re-initialize the subsystem. Existing watches on kernel variables
are retained.
"""
CSPYCE_DEFINITIONS["kclear"] = {
}
CSPYCE_URL["kclear"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/kclear_c.html"
#########################################
CSPYCE_ARGNAMES["kdata"] = ["which", "kind"]
CSPYCE_RETNAMES["kdata"] = ["file", "filtyp", "srcfil", "handle", "found"]
CSPYCE_ABSTRACT["kdata"] = """
Return data for the nth kernel that is among a list of specified kernel
types.
"""
CSPYCE_DEFINITIONS["kdata"] = {
'which' : ("int", "Index of kernel to fetch from the list of kernels."),
'kind'  : ("string", "The kind of kernel to which fetches are limited."),
'file'  : ("string", "The name of the kernel file."),
'filtyp': ("string", "The type of the kernel, one of \"SPK\", \"SK\", \"DSK\", \"PCK\", \"EK\", \"TEXT\", \"META\", or \"ALL\". Default is \"ALL\". To get multiple kinds, join them inside a string, separated by spaces."),
'srcfil': ("string", "Name of the source file used to load `file'."),
'handle': ("int", "The handle attached to `file'."),
'found' : ("bool", "True if the specified file could be located."),
}
CSPYCE_URL["kdata"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/kdata_c.html"
CSPYCE_DEFAULTS["kdata"] = [0, "ALL"]
#########################################
CSPYCE_ARGNAMES["kinfo"] = ["file"]
CSPYCE_RETNAMES["kinfo"] = ["filtyp", "srcfil", "handle", "found"]
CSPYCE_ABSTRACT["kinfo"] = """
Return information about a loaded kernel specified by name.
"""
CSPYCE_DEFINITIONS["kinfo"] = {
'file'  : ("string", "Name of a kernel to fetch information for"),
'filtyp': ("string", "The type of the kernel, one of \"SPK\", \"SK\", \"DSK\", \"PCK\", \"EK\", \"TEXT\", \"META\", or \"ALL\"."),
'srcfil': ("string", "Name of the source file used to load `file'."),
'handle': ("int", "The handle attached to `file'."),
'found' : ("bool", "True if the specified file could be located."),
}
CSPYCE_URL["kinfo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/kinfo_c.html"
#########################################
CSPYCE_ARGNAMES["ktotal"] = ["kind"]
CSPYCE_RETNAMES["ktotal"] = ["count"]
CSPYCE_ABSTRACT["ktotal"] = """
Return the number of kernels of a specified type that are currently
loaded via the furnsh_c interface.
"""
CSPYCE_DEFINITIONS["ktotal"] = {
'kind'  : ("string", "The kind of kernels to count, one of \"SPK\", \"SK\", \"DSK\", \"PCK\", \"EK\", \"TEXT\", \"META\", or \"ALL\". To count multiple kinds, join them inside a string, separated by spaces. Default is \"ALL\"."),
'count' : ("int", "The number of kernels of type `kind'."),
}
CSPYCE_URL["ktotal"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ktotal_c.html"
CSPYCE_DEFAULTS["ktotal"] = ["ALL"]
#########################################
CSPYCE_ARGNAMES["kxtrct"] = ["keywd", "terms", "wordsq"]
CSPYCE_RETNAMES["kxtrct"] = ["wordsq", "found", "substr"]
CSPYCE_ABSTRACT["kxtrct"] = """
Locate a keyword in a string and extract the substring from the
beginning of the first word following the keyword to the beginning of
the first subsequent recognized terminator of a list.
"""
CSPYCE_DEFINITIONS["kxtrct"] = {
'keywd' : ("string", "Word that marks the beginning of text of interest."),
'terms' : ("string[*]", "Set of words, any of which marks the end of text."),
'wordsq': ("string", "String containing a sequence of words."),
'found' : ("bool", "True if the keyword is found in the string."),
'substr': ("string", "String from end of `keywd' to beginning of first `terms' item found."),
}
CSPYCE_URL["kxtrct"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/kxtrct_c.html"
#########################################
CSPYCE_ARGNAMES["lgresp"] = ["first", "step", "yvals", "x"]
CSPYCE_RETNAMES["lgresp"] = ["value"]
CSPYCE_ABSTRACT["lgresp"] = """
Evaluate a Lagrange interpolating polynomial for a specified set of
coordinate pairs whose first components are equally spaced, at a
specified abscissa value.
"""
CSPYCE_DEFINITIONS["lgresp"] = {
'first' : ("float", "First abscissa value."),
'step'  : ("float", "Step size."),
'yvals' : ("float[*]", "Ordinate values."),
'x'     : ("float", "Point at which to interpolate the polynomial."),
'value' : ("float", "Value of Lagrange polynomial."),
}
CSPYCE_URL["lgresp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lgresp_c.html"
#########################################
CSPYCE_ARGNAMES["lgrind"] = ["xvals", "yvals", "x"]
CSPYCE_RETNAMES["lgrind"] = ["p", "dp"]
CSPYCE_ABSTRACT["lgrind"] = """
Evaluate a Lagrange interpolating polynomial, for a specified set of
coordinate pairs, at a specified abscissa value. Return both the value
of the polynomial and its derivative.
"""
CSPYCE_DEFINITIONS["lgrind"] = {
'xvals' : ("float[*]", "Abscissa values."),
'yvals' : ("float[*]", "Ordinate values."),
'x'     : ("float", "Point at which to interpolate the polynomial."),
'p'     : ("float", "Polynomial value at `x'."),
'dp'    : ("float", "Polynomial derivative at `x'."),
}
CSPYCE_URL["lgrind"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lgrind_c.html"
#########################################
CSPYCE_ARGNAMES["lgrint"] = ["xvals", "yvals", "x"]
CSPYCE_RETNAMES["lgrint"] = ["value"]
CSPYCE_ABSTRACT["lgrint"] = """
Evaluate a Lagrange interpolating polynomial for a specified set of
coordinate pairs, at a specified abscissa value.
"""
CSPYCE_DEFINITIONS["lgrint"] = {
'xvals' : ("float[*]", "Abscissa values."),
'yvals' : ("float[*]", "Ordinate values."),
'x'     : ("float", "Point at which to interpolate the polynomial."),
'value' : ("float", "Value of Lagrange polynomial."),
}
CSPYCE_URL["lgrint"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lgrint_c.html"
#########################################
CSPYCE_ARGNAMES["lmpool"] = ["cvals"]
CSPYCE_RETNAMES["lmpool"] = []
CSPYCE_ABSTRACT["lmpool"] = """
Load the variables contained in an internal buffer into the kernel pool.
"""
CSPYCE_DEFINITIONS["lmpool"] = {
'cvals' : ("string[*]", "An array that contains a SPICE text kernel."),
}
CSPYCE_URL["lmpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lmpool_c.html"
#########################################
CSPYCE_ARGNAMES["lparse"] = ["list", "delim"]
CSPYCE_RETNAMES["lparse"] = ["items"]
CSPYCE_ABSTRACT["lparse"] = """
Parse a list of items delimited by a single character.
"""
CSPYCE_DEFINITIONS["lparse"] = {
'list'  : ("string", "List of items delimited by delim."),
'delim' : ("string", "Single character used to delimit items."),
'items' : ("string[*]", "Items in the list, left justified."),
}
CSPYCE_URL["lparse"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lparse_c.html"
#########################################
CSPYCE_ARGNAMES["lparsm"] = ["list", "delims"]
CSPYCE_RETNAMES["lparsm"] = ["items"]
CSPYCE_ABSTRACT["lparsm"] = """
Parse a list of items separated by multiple delimiters.
"""
CSPYCE_DEFINITIONS["lparsm"] = {
'list'  : ("string", "List of items delimited by delims."),
'delims': ("string", "Single characters which delimit items."),
'items' : ("string[*]", "Items in the list, left justified."),
}
CSPYCE_URL["lparsm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lparsm_c.html"
#########################################
CSPYCE_ARGNAMES["lstlec"] = ["string", "array"]
CSPYCE_RETNAMES["lstlec"] = ["index"]
CSPYCE_ABSTRACT["lstlec"] = """
Find the index of the largest array element less than or equal to a
given character string in an ordered array of character strings.
"""
CSPYCE_DEFINITIONS["lstlec"] = {
'string': ("string", "Upper bound value to search against."),
'array' : ("string[*]", "Array of possible lower bounds."),
'index' : ("int", "Index of element in array."),
}
CSPYCE_URL["lstlec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lstlec_c.html"
#########################################
CSPYCE_ARGNAMES["lstled"] = ["x", "array"]
CSPYCE_RETNAMES["lstled"] = ["index"]
CSPYCE_ABSTRACT["lstled"] = """
Find the index of the largest array element less than or equal to a
given number `x' in an array of non-decreasing numbers.
"""
CSPYCE_DEFINITIONS["lstled"] = {
'x'     : ("float", "Upper bound value to search against."),
'array' : ("float[*]", "Array of possible lower bounds."),
'index' : ("int", "Index of element in array."),
}
CSPYCE_URL["lstled"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lstled_c.html"
#########################################
CSPYCE_ARGNAMES["lstlei"] = ["x", "array"]
CSPYCE_RETNAMES["lstlei"] = ["index"]
CSPYCE_ABSTRACT["lstlei"] = """
Find the index of the largest array element less than or equal to a
given integer `x' in an array of non-decreasing integers.
"""
CSPYCE_DEFINITIONS["lstlei"] = {
'x'     : ("int", "Upper bound value to search against."),
'array' : ("int[*]", "Array of possible lower bounds."),
'index' : ("int", "Index of element in array."),
}
CSPYCE_URL["lstlei"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lstlei_c.html"
#########################################
CSPYCE_ARGNAMES["lstltc"] = ["string", "array"]
CSPYCE_RETNAMES["lstltc"] = ["index"]
CSPYCE_ABSTRACT["lstltc"] = """
Find the index of the largest array element less than a given character
string in an ordered array of character strings.
"""
CSPYCE_DEFINITIONS["lstltc"] = {
'string': ("string", "Upper bound value to search against."),
'array' : ("string[*]", "Array of possible lower bounds."),
'index' : ("int", "Index of element in array."),
}
CSPYCE_URL["lstltc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lstltc_c.html"
#########################################
CSPYCE_ARGNAMES["lstltd"] = ["x", "array"]
CSPYCE_RETNAMES["lstltd"] = ["index"]
CSPYCE_ABSTRACT["lstltd"] = """
Find the index of the largest array element less than a given number `x'
in an array of non-decreasing numbers.
"""
CSPYCE_DEFINITIONS["lstltd"] = {
'x'     : ("float", "Upper bound value to search against."),
'array' : ("float[*]", "Array of possible lower bounds."),
'index' : ("int", "Index of element in array."),
}
CSPYCE_URL["lstltd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lstltd_c.html"
#########################################
CSPYCE_ARGNAMES["lstlti"] = ["x", "array"]
CSPYCE_RETNAMES["lstlti"] = ["index"]
CSPYCE_ABSTRACT["lstlti"] = """
Find the index of the largest array element less than a given integer
`x' in an array of non-decreasing integers.
"""
CSPYCE_DEFINITIONS["lstlti"] = {
'x'     : ("int", "Upper bound value to search against."),
'array' : ("int[*]", "Array of possible lower bounds."),
'index' : ("int", "Index of element in array."),
}
CSPYCE_URL["lstlti"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lstlti_c.html"
#########################################
CSPYCE_ARGNAMES["lx4dec"] = ["string", "first"]
CSPYCE_RETNAMES["lx4dec"] = ["last", "nchar"]
CSPYCE_ABSTRACT["lx4dec"] = """
Scan a string from a specified starting position for the end of a
decimal number.
"""
CSPYCE_DEFINITIONS["lx4dec"] = {
'string': ("string", "Any character string."),
'first' : ("int", "First character to scan from in string."),
'last'  : ("int", "Last character that is part of a decimal number."),
'nchar' : ("int", "Number of characters in the decimal number."),
}
CSPYCE_URL["lx4dec"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lx4dec_c.html"
#########################################
CSPYCE_ARGNAMES["lx4num"] = ["string", "first"]
CSPYCE_RETNAMES["lx4num"] = ["last", "nchar"]
CSPYCE_ABSTRACT["lx4num"] = """
Scan a string from a specified starting position for the end of a
number.
"""
CSPYCE_DEFINITIONS["lx4num"] = {
'string': ("string", "Any character string."),
'first' : ("int", "First character to scan from in string."),
'last'  : ("int", "Last character that is part of a number."),
'nchar' : ("int", "Number of characters in the number."),
}
CSPYCE_URL["lx4num"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lx4num_c.html"
#########################################
CSPYCE_ARGNAMES["lx4sgn"] = ["string", "first"]
CSPYCE_RETNAMES["lx4sgn"] = ["last", "nchar"]
CSPYCE_ABSTRACT["lx4sgn"] = """
Scan a string from a specified starting position for the end of a signed
integer.
"""
CSPYCE_DEFINITIONS["lx4sgn"] = {
'string': ("string", "Any character string."),
'first' : ("int", "First character to scan from in string."),
'last'  : ("int", "Last character that is part of a signed integer."),
'nchar' : ("int", "Number of characters in the signed integer."),
}
CSPYCE_URL["lx4sgn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lx4sgn_c.html"
#########################################
CSPYCE_ARGNAMES["lx4uns"] = ["string", "first"]
CSPYCE_RETNAMES["lx4uns"] = ["last", "nchar"]
CSPYCE_ABSTRACT["lx4uns"] = """
Scan a string from a specified starting position for the end of an
unsigned integer.
"""
CSPYCE_DEFINITIONS["lx4uns"] = {
'string': ("string", "Any character string."),
'first' : ("int", "First character to scan from in string."),
'last'  : ("int", "Last character that is part of an unsigned integer."),
'nchar' : ("int", "Number of characters in the unsigned integer."),
}
CSPYCE_URL["lx4uns"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lx4uns_c.html"
#########################################
CSPYCE_ARGNAMES["lxqstr"] = ["string", "qchar", "first"]
CSPYCE_RETNAMES["lxqstr"] = ["last", "nchar"]
CSPYCE_ABSTRACT["lxqstr"] = """
Scan (lex) a quoted string.
"""
CSPYCE_DEFINITIONS["lxqstr"] = {
'string': ("string", "String to be scanned."),
'qchar' : ("string", "Quote delimiter character."),
'first' : ("int", "Character position at which to start scanning."),
'last'  : ("int", "Character position of end of token."),
'nchar' : ("int", "Number of characters in token."),
}
CSPYCE_URL["lxqstr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/lxqstr_c.html"
#########################################
CSPYCE_ARGNAMES["matchi"] = ["string", "templ", "wstr", "wchr"]
CSPYCE_RETNAMES["matchi"] = ["flag"]
CSPYCE_ABSTRACT["matchi"] = """
Determine whether a string is matched by a template containing wild
cards. The pattern comparison is case-insensitive.
"""
CSPYCE_DEFINITIONS["matchi"] = {
'string': ("string", "String to be tested."),
'templ' : ("string", "Template (with wild cards) to test against string."),
'wstr'  : ("string", "Wild string token."),
'wchr'  : ("string", "Wild character token."),
'flag'  : ("bool", "True if the string matches; False otherwise."),
}
CSPYCE_URL["matchi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/matchi_c.html"
#########################################
CSPYCE_ARGNAMES["matchw"] = ["string", "templ", "wstr", "wchr"]
CSPYCE_RETNAMES["matchw"] = ["flag"]
CSPYCE_ABSTRACT["matchw"] = """
Determine whether a string is matched by a template containing wild
cards. The comparison is case-sensitive.
"""
CSPYCE_DEFINITIONS["matchw"] = {
'string': ("string", "String to be tested."),
'templ' : ("string", "Template (with wild cards) to test against string."),
'wstr'  : ("string", "Wild string token."),
'wchr'  : ("string", "Wild character token."),
'flag'  : ("bool", "True if the string matches; False otherwise."),
}
CSPYCE_URL["matchw"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/matchw_c.html"
#########################################
CSPYCE_ARGNAMES["ncpos"] = ["str", "chars", "start"]
CSPYCE_RETNAMES["ncpos"] = ["index"]
CSPYCE_ABSTRACT["ncpos"] = """
Find the first occurrence in a string of a character NOT belonging to a
collection of characters, starting at a specified location, searching
forward.
"""
CSPYCE_DEFINITIONS["ncpos"] = {
'str'   : ("string", "Any character string."),
'chars' : ("string", "A collection of characters."),
'start' : ("int", "Position to begin looking for one not in chars."),
'index' : ("int", "Index of character in string."),
}
CSPYCE_URL["ncpos"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ncpos_c.html"
#########################################
CSPYCE_ARGNAMES["ncposr"] = ["str", "chars", "start"]
CSPYCE_RETNAMES["ncposr"] = ["index"]
CSPYCE_ABSTRACT["ncposr"] = """
Find the first occurrence in a string of a character NOT belonging to a
collection of characters, starting at a specified location, searching in
reverse.
"""
CSPYCE_DEFINITIONS["ncposr"] = {
'str'   : ("string", "Any character string."),
'chars' : ("string", "A collection of characters."),
'start' : ("int", "Position to begin looking for one of chars."),
'index' : ("int", "Index of character in string."),
}
CSPYCE_URL["ncposr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/ncposr_c.html"
#########################################
CSPYCE_ARGNAMES["nextwd"] = ["string"]
CSPYCE_RETNAMES["nextwd"] = ["next", "rest"]
CSPYCE_ABSTRACT["nextwd"] = """
Return the next word in a given character string, and left justify the
rest of the string.
"""
CSPYCE_DEFINITIONS["nextwd"] = {
'string': ("string", "Input character string."),
'next'  : ("string", "The next word in the string."),
'rest'  : ("string", "The remaining part of `string', left-justified."),
}
CSPYCE_URL["nextwd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/nextwd_c.html"
#########################################
CSPYCE_ARGNAMES["nthwd"] = ["string", "nth"]
CSPYCE_RETNAMES["nthwd"] = ["word", "loc"]
CSPYCE_ABSTRACT["nthwd"] = """
Return the nth word in a character string, and its location in the
string.
"""
CSPYCE_DEFINITIONS["nthwd"] = {
'string': ("string", "Input character string."),
'nth'   : ("int", "Index of the word to be returned."),
'word'  : ("string", "The `nth' word in `string'."),
'loc'   : ("int", "Location of `word' in `string'."),
}
CSPYCE_URL["nthwd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/nthwd_c.html"
#########################################
CSPYCE_ARGNAMES["orderc"] = ["array"]
CSPYCE_RETNAMES["orderc"] = ["iorder"]
CSPYCE_ABSTRACT["orderc"] = """
Determine the order of elements in an array of character strings.
"""
CSPYCE_DEFINITIONS["orderc"] = {
'array' : ("string[*]", "Input array."),
'iorder': ("int", "Order vector for array."),
}
CSPYCE_URL["orderc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/orderc_c.html"
#########################################
CSPYCE_ARGNAMES["orderd"] = ["array"]
CSPYCE_RETNAMES["orderd"] = ["iorder"]
CSPYCE_ABSTRACT["orderd"] = """
Determine the order of elements in a floating-point array.
"""
CSPYCE_DEFINITIONS["orderd"] = {
'array' : ("float[*]", "Input array."),
'iorder': ("int", "Order vector for array."),
}
CSPYCE_URL["orderd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/orderd_c.html"
#########################################
CSPYCE_ARGNAMES["orderi"] = ["array"]
CSPYCE_RETNAMES["orderi"] = ["iorder"]
CSPYCE_ABSTRACT["orderi"] = """
Determine the order of elements in an integer array.
"""
CSPYCE_DEFINITIONS["orderi"] = {
'array' : ("int[*]", "Input array."),
'iorder': ("int", "Order vector for array."),
}
CSPYCE_URL["orderi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/orderi_c.html"
#########################################
CSPYCE_ARGNAMES["pckcls"] = ["handle"]
CSPYCE_RETNAMES["pckcls"] = []
CSPYCE_ABSTRACT["pckcls"] = """
Close an open PCK file.
"""
CSPYCE_DEFINITIONS["pckcls"] = {
'handle': ("int", "Handle of the PCK file to be closed."),
}
CSPYCE_URL["pckcls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pckcls_c.html"
#########################################
CSPYCE_ARGNAMES["pcklof"] = ["fname"]
CSPYCE_RETNAMES["pcklof"] = ["handle"]
CSPYCE_ABSTRACT["pcklof"] = """
Load a binary PCK file for use by the readers. Return the handle of the
loaded file which is used by other PCK routines to refer to the file.
"""
CSPYCE_DEFINITIONS["pcklof"] = {
'fname' : ("string", "Name of the file to be loaded."),
'handle': ("int", "Loaded file's handle."),
}
CSPYCE_URL["pcklof"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pcklof_c.html"
#########################################
CSPYCE_ARGNAMES["pckopn"] = ["name", "ifname", "ncomch"]
CSPYCE_RETNAMES["pckopn"] = ["handle"]
CSPYCE_ABSTRACT["pckopn"] = """
Create a new PCK file, returning the handle of the opened file.
"""
CSPYCE_DEFINITIONS["pckopn"] = {
'name'  : ("string", "The name of the PCK file to be opened."),
'ifname': ("string", "The internal filename for the PCK."),
'ncomch': ("int", "The number of characters to reserve for comments."),
'handle': ("int", "The handle of the opened PCK file."),
}
CSPYCE_URL["pckopn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pckopn_c.html"
#########################################
CSPYCE_ARGNAMES["pckuof"] = ["handle"]
CSPYCE_RETNAMES["pckuof"] = []
CSPYCE_ABSTRACT["pckuof"] = """
Unload a binary PCK file so that it will no longer be searched by the
readers.
"""
CSPYCE_DEFINITIONS["pckuof"] = {
'handle': ("int", "Handle of file to be unloaded"),
}
CSPYCE_URL["pckuof"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pckuof_c.html"
#########################################
CSPYCE_ARGNAMES["pckw02"] = ["handle", "clssid", "frame", "first", "last", "segid", "intlen", "n", "polydg", "cdata", "btime"]
CSPYCE_RETNAMES["pckw02"] = []
CSPYCE_ABSTRACT["pckw02"] = """
Write a type 2 segment to a PCK binary file given the file handle, frame
class ID, base frame, time range covered by the segment, and the
Chebyshev polynomial coefficients.
"""
CSPYCE_DEFINITIONS["pckw02"] = {
'handle': ("int", "Handle of binary PCK file open for writing."),
'clssid': ("int", "Frame class ID of body-fixed frame."),
'frame' : ("string", "Name of base reference frame."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'intlen': ("float", "Length of time covered by logical record."),
'n'     : ("int", "Number of logical records in segment."),
'polydg': ("int", "Chebyshev polynomial degree."),
'cdata' : ("float[*]", "Array of Chebyshev coefficients."),
'btime' : ("float", "Begin time of first logical record."),
}
CSPYCE_URL["pckw02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pckw02_c.html"
#########################################
CSPYCE_ARGNAMES["pltnrm"] = ["v1", "v2", "v3"]
CSPYCE_RETNAMES["pltnrm"] = ["normal"]
CSPYCE_ABSTRACT["pltnrm"] = """
Compute an outward normal vector of a triangular plate. The vector does
not necessarily have unit length.
"""
CSPYCE_DEFINITIONS["pltnrm"] = {
'v1'    : ("float[3]", "First vertex of a plate."),
'v2'    : ("float[3]", "Second vertex of a plate."),
'v3'    : ("float[3]", "Third vertex of a plate."),
'normal': ("float[3]", "Plate's outward normal vector."),
}
CSPYCE_URL["pltnrm"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pltnrm_c.html"
#########################################
CSPYCE_ARGNAMES["polyds"] = ["coeffs", "nderiv", "t"]
CSPYCE_RETNAMES["polyds"] = ["p"]
CSPYCE_ABSTRACT["polyds"] = """
Compute the value of a polynomial and its first `nderiv' derivatives at
the value `t'.
"""
CSPYCE_DEFINITIONS["polyds"] = {
'coeffs': ("float[*]", "Coefficients of the polynomial to be evaluated."),
'nderiv': ("int", "Number of derivatives to compute."),
't'     : ("float", "Point to evaluate the polynomial and derivatives"),
'p'     : ("float[*]", "Value of polynomial and derivatives."),
}
CSPYCE_URL["polyds"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/polyds_c.html"
#########################################
CSPYCE_ARGNAMES["pos"] = ["str", "substr", "start"]
CSPYCE_RETNAMES["pos"] = ["index"]
CSPYCE_ABSTRACT["pos"] = """
Find the first occurrence in a string of a substring, starting at a
specified location, searching forward.
"""
CSPYCE_DEFINITIONS["pos"] = {
'str'   : ("string", "Any character string."),
'substr': ("string", "Substring to locate in the character string."),
'start' : ("int", "Position to begin looking for substr in str."),
'index' : ("int", "Index of substring in string."),
}
CSPYCE_URL["pos"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/pos_c.html"
#########################################
CSPYCE_ARGNAMES["posr"] = ["str", "substr", "start"]
CSPYCE_RETNAMES["posr"] = ["index"]
CSPYCE_ABSTRACT["posr"] = """
Find the first occurrence in a string of a substring, starting at a
specified location, searching backward.
"""
CSPYCE_DEFINITIONS["posr"] = {
'str'   : ("string", "Any character string."),
'substr': ("string", "Substring to locate in the character string."),
'start' : ("int", "Position to begin looking for substr in str."),
'index' : ("int", "Index of substring in string."),
}
CSPYCE_URL["posr"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/posr_c.html"
#########################################
CSPYCE_ARGNAMES["prompt"] = ["dspmsg"]
CSPYCE_RETNAMES["prompt"] = ["buffer"]
CSPYCE_ABSTRACT["prompt"] = """
Prompt a user for keyboard input.
"""
CSPYCE_DEFINITIONS["prompt"] = {
'dspmsg': ("string", "The prompt string to display when asking for input."),
'buffer': ("string", "The string containing the response typed by a user."),
}
CSPYCE_URL["prompt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/prompt_c.html"
#########################################
CSPYCE_ARGNAMES["prsdp"] = ["string"]
CSPYCE_RETNAMES["prsdp"] = ["dpval"]
CSPYCE_ABSTRACT["prsdp"] = """
Parse a string as a floating-point number, encapsulating error handling.
"""
CSPYCE_DEFINITIONS["prsdp"] = {
'string': ("string", "String representing a numeric value."),
'dpval' : ("float", "D.p. value obtained by parsing `string'."),
}
CSPYCE_URL["prsdp"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/prsdp_c.html"
#########################################
CSPYCE_ARGNAMES["prsint"] = ["string"]
CSPYCE_RETNAMES["prsint"] = ["intval"]
CSPYCE_ABSTRACT["prsint"] = """
Parse a string as an integer, encapsulating error handling.
"""
CSPYCE_DEFINITIONS["prsint"] = {
'string': ("string", "String representing a numeric value."),
'intval': ("int", "Integer value obtained by parsing `string'."),
}
CSPYCE_URL["prsint"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/prsint_c.html"
#########################################
CSPYCE_ARGNAMES["qderiv"] = ["f0", "f2", "delta"]
CSPYCE_RETNAMES["qderiv"] = ["dfdt"]
CSPYCE_ABSTRACT["qderiv"] = """
Estimate the derivative of a function by finding the derivative of a
quadratic approximating function. This derivative estimate is equivalent
to that found by computing the average of forward and backward
differences.
"""
CSPYCE_DEFINITIONS["qderiv"] = {
'f0'    : ("float[*]", "Function values at left endpoint."),
'f2'    : ("float[*]", "Function values at right endpoint."),
'delta' : ("float", "Separation of abscissa points."),
'dfdt'  : ("float[*]", "Derivative vector."),
}
CSPYCE_URL["qderiv"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/qderiv_c.html"
#########################################
CSPYCE_ARGNAMES["recazl"] = ["rectan", "azccw", "elplsz"]
CSPYCE_RETNAMES["recazl"] = ["range", "az", "el"]
CSPYCE_ABSTRACT["recazl"] = """
Convert rectangular coordinates of a point to range, azimuth and
elevation.
"""
CSPYCE_DEFINITIONS["recazl"] = {
'rectan': ("float[3]", "Rectangular coordinates of a point."),
'azccw' : ("bool", "Flag indicating how azimuth is measured, True for counterclockwise, False for clockwise."),
'elplsz': ("bool", "Flag indicating how elevation is measured, True for increasing toward +Z, False for -Z."),
'range' : ("float", "Distance of the point from the origin."),
'az'    : ("float", "Azimuth in radians."),
'el'    : ("float", "Elevation in radians."),
}
CSPYCE_URL["recazl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/recazl_c.html"
#########################################
CSPYCE_ARGNAMES["reordc"] = ["iorder", "array"]
CSPYCE_RETNAMES["reordc"] = ["array"]
CSPYCE_ABSTRACT["reordc"] = """
Reorder the elements of an array of character strings according to a
given order vector.
"""
CSPYCE_DEFINITIONS["reordc"] = {
'iorder': ("int[*]", "Order vector to be used to re-order array."),
'array' : ("string[*]", "Array to be re-ordered."),
}
CSPYCE_URL["reordc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reordc_c.html"
#########################################
CSPYCE_ARGNAMES["reordd"] = ["iorder", "array"]
CSPYCE_RETNAMES["reordd"] = ["array"]
CSPYCE_ABSTRACT["reordd"] = """
Reorder the elements of a floating-point array according to a given
order vector.
"""
CSPYCE_DEFINITIONS["reordd"] = {
'iorder': ("int[*]", "Order vector to be used to re-order array."),
'array' : ("float", "Array to be re-ordered."),
}
CSPYCE_URL["reordd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reordd_c.html"
#########################################
CSPYCE_ARGNAMES["reordi"] = ["iorder", "array"]
CSPYCE_RETNAMES["reordi"] = ["array"]
CSPYCE_ABSTRACT["reordi"] = """
Reorder the elements of an integer array according to a given order
vector.
"""
CSPYCE_DEFINITIONS["reordi"] = {
'iorder': ("int[*]", "Order vector to be used to re-order array."),
'array' : ("int", "Array to be re-ordered."),
}
CSPYCE_URL["reordi"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reordi_c.html"
#########################################
CSPYCE_ARGNAMES["reordl"] = ["iorder", "array"]
CSPYCE_RETNAMES["reordl"] = ["array"]
CSPYCE_ABSTRACT["reordl"] = """
Reorder the elements of a logical array according to a given order
vector.
"""
CSPYCE_DEFINITIONS["reordl"] = {
'iorder': ("int[*]", "Order vector to be used to re-order array."),
'array' : ("bool", "Array to be re-ordered."),
}
CSPYCE_URL["reordl"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/reordl_c.html"
#########################################
CSPYCE_ARGNAMES["repml"] = ["in", "marker", "value", "rtcase"]
CSPYCE_RETNAMES["repml"] = ["out"]
CSPYCE_ABSTRACT["repml"] = """
Replace a marker with the text representation of a logical value.
"""
CSPYCE_DEFINITIONS["repml"] = {
'in'    : ("string", "Input string."),
'marker': ("string", "Marker to be replaced."),
'value' : ("bool", "Replacement logical value."),
'rtcase': ("string", "Case of replacement text."),
'out'   : ("string", "Output string."),
}
CSPYCE_URL["repml"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/repml_c.html"
#########################################
CSPYCE_ARGNAMES["return_"] = []
CSPYCE_RETNAMES["return_"] = ["status"]
CSPYCE_ABSTRACT["return_"] = """
Return True if CSPICE routines should return immediately upon entry.
"""
CSPYCE_DEFINITIONS["return_"] = {
'status': ("bool", "True if the routine should return immediately."),
}
CSPYCE_URL["return_"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/return_c.html"
#########################################
CSPYCE_ARGNAMES["shellc"] = ["array"]
CSPYCE_RETNAMES["shellc"] = ["array"]
CSPYCE_ABSTRACT["shellc"] = """
Sort an array of character strings according to the ASCII collating
sequence using the Shell Sort algorithm.
"""
CSPYCE_DEFINITIONS["shellc"] = {
'array' : ("string[*]", "The array."),
}
CSPYCE_URL["shellc"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/shellc_c.html"
#########################################
CSPYCE_ARGNAMES["shelld"] = ["array"]
CSPYCE_RETNAMES["shelld"] = ["array"]
CSPYCE_ABSTRACT["shelld"] = """
Sort a floating-point array using the Shell Sort algorithm.
"""
CSPYCE_DEFINITIONS["shelld"] = {
'array' : ("float", "The array to be sorted."),
}
CSPYCE_URL["shelld"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/shelld_c.html"
#########################################
CSPYCE_ARGNAMES["shelli"] = ["array"]
CSPYCE_RETNAMES["shelli"] = ["array"]
CSPYCE_ABSTRACT["shelli"] = """
Sort an integer array using the Shell Sort algorithm.
"""
CSPYCE_DEFINITIONS["shelli"] = {
'array' : ("int", "The array."),
}
CSPYCE_URL["shelli"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/shelli_c.html"
#########################################
CSPYCE_ARGNAMES["spk14a"] = ["handle", "ncsets", "coeffs", "epochs"]
CSPYCE_RETNAMES["spk14a"] = []
CSPYCE_ABSTRACT["spk14a"] = """
Add data to a type 14 SPK segment associated with `handle'.
"""
CSPYCE_DEFINITIONS["spk14a"] = {
'handle': ("int", "The handle of an SPK file open for writing."),
'ncsets': ("int", "The number of coefficient sets and epochs."),
'coeffs': ("float[*]", "The collection of coefficient sets."),
'epochs': ("time[*]", "The epochs associated with the coefficient sets."),
}
CSPYCE_URL["spk14a"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spk14a_c.html"
#########################################
CSPYCE_ARGNAMES["spk14b"] = ["handle", "segid", "body", "center", "frame", "first", "last", "chbdeg"]
CSPYCE_RETNAMES["spk14b"] = []
CSPYCE_ABSTRACT["spk14b"] = """
Begin a type 14 SPK segment in the SPK file associated with `handle'.
"""
CSPYCE_DEFINITIONS["spk14b"] = {
'handle': ("int", "The handle of an SPK file open for writing."),
'segid' : ("string", "The string to use for segment identifier."),
'body'  : ("body_code", "The NAIF ID code for the body of the segment."),
'center': ("body_code", "The center of motion for body."),
'frame' : ("string", "The reference frame for this segment."),
'first' : ("float", "The first epoch for which the segment is valid."),
'last'  : ("float", "The last epoch for which the segment is valid."),
'chbdeg': ("int", "The degree of the Chebyshev Polynomial used."),
}
CSPYCE_URL["spk14b"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spk14b_c.html"
#########################################
CSPYCE_ARGNAMES["spk14e"] = ["handle"]
CSPYCE_RETNAMES["spk14e"] = []
CSPYCE_ABSTRACT["spk14e"] = """
End the type 14 SPK segment currently being written to the SPK file
associated with `handle'.
"""
CSPYCE_DEFINITIONS["spk14e"] = {
'handle': ("int", "The handle of an SPK file open for writing."),
}
CSPYCE_URL["spk14e"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spk14e_c.html"
#########################################
CSPYCE_ARGNAMES["spkcls"] = ["handle"]
CSPYCE_RETNAMES["spkcls"] = []
CSPYCE_ABSTRACT["spkcls"] = """
Close an open SPK file.
"""
CSPYCE_DEFINITIONS["spkcls"] = {
'handle': ("int", "Handle of the SPK file to be closed."),
}
CSPYCE_URL["spkcls"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkcls_c.html"
#########################################
CSPYCE_ARGNAMES["spkcpo"] = ["target", "et", "outref", "refloc", "abcorr", "obspos", "obsctr", "obsref"]
CSPYCE_RETNAMES["spkcpo"] = ["state", "lt"]
CSPYCE_ABSTRACT["spkcpo"] = """
Return the state of a specified target relative to an "observer," where
the observer has constant position in a specified reference frame. The
observer's position is provided by the calling program rather than by
loaded SPK files.
"""
CSPYCE_DEFINITIONS["spkcpo"] = {
'target': ("body_name", "Name of target ephemeris object."),
'et'    : ("time", "Observation epoch."),
'outref': ("frame_name", "Reference frame of output state."),
'refloc': ("string", "Output reference frame evaluation locus."),
'abcorr': ("string", "Aberration correction."),
'obspos': ("float[3]", "Observer position relative to center of motion."),
'obsctr': ("string", "Center of motion of observer."),
'obsref': ("frame_name", "Frame of observer position."),
'state' : ("float[6]", "State of target with respect to observer."),
'lt'    : ("float", "One way light time between target and observer."),
}
CSPYCE_URL["spkcpo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkcpo_c.html"
#########################################
CSPYCE_ARGNAMES["spkcpt"] = ["trgpos", "trgctr", "trgref", "et", "outref", "refloc", "abcorr", "obsrvr"]
CSPYCE_RETNAMES["spkcpt"] = ["state", "lt"]
CSPYCE_ABSTRACT["spkcpt"] = """
Return the state, relative to a specified observer, of a target having
constant position in a specified reference frame. The target's position
is provided by the calling program rather than by loaded SPK files.
"""
CSPYCE_DEFINITIONS["spkcpt"] = {
'trgpos': ("float[3]", "Target position relative to center of motion."),
'trgctr': ("string", "Center of motion of target."),
'trgref': ("string", "Frame of target position."),
'et'    : ("time", "Observation epoch."),
'outref': ("frame_name", "Reference frame of output state."),
'refloc': ("string", "Output reference frame evaluation locus."),
'abcorr': ("string", "Aberration correction."),
'obsrvr': ("body_name", "Name of observing ephemeris object."),
'state' : ("float[6]", "State of target with respect to observer."),
'lt'    : ("float", "One way light time between target and observer."),
}
CSPYCE_URL["spkcpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkcpt_c.html"
#########################################
CSPYCE_ARGNAMES["spkcvo"] = ["target", "et", "outref", "refloc", "abcorr", "obssta", "obsepc", "obsctr", "obsref"]
CSPYCE_RETNAMES["spkcvo"] = ["state", "lt"]
CSPYCE_ABSTRACT["spkcvo"] = """
Return the state of a specified target relative to an "observer," where
the observer has constant velocity in a specified reference frame. The
observer's state is provided by the calling program rather than by
loaded SPK files.
"""
CSPYCE_DEFINITIONS["spkcvo"] = {
'target': ("body_name", "Name of target ephemeris object."),
'et'    : ("time", "Observation epoch."),
'outref': ("frame_name", "Reference frame of output state."),
'refloc': ("string", "Output reference frame evaluation locus."),
'abcorr': ("string", "Aberration correction."),
'obssta': ("float[6]", "Observer state relative to center of motion."),
'obsepc': ("float", "Epoch of observer state."),
'obsctr': ("string", "Center of motion of observer."),
'obsref': ("frame_name", "Frame of observer state."),
'state' : ("float[6]", "State of target with respect to observer."),
'lt'    : ("float", "One way light time between target and observer."),
}
CSPYCE_URL["spkcvo"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkcvo_c.html"
#########################################
CSPYCE_ARGNAMES["spkcvt"] = ["trgsta", "trgepc", "trgctr", "trgref", "et", "outref", "refloc", "abcorr", "obsrvr"]
CSPYCE_RETNAMES["spkcvt"] = ["state", "lt"]
CSPYCE_ABSTRACT["spkcvt"] = """
Return the state, relative to a specified observer, of a target having
constant velocity in a specified reference frame. The target's state is
provided by the calling program rather than by loaded SPK files.
"""
CSPYCE_DEFINITIONS["spkcvt"] = {
'trgsta': ("float[6]", "Target state relative to center of motion."),
'trgepc': ("time", "Epoch of target state."),
'trgctr': ("string", "Center of motion of target."),
'trgref': ("string", "Frame of target state."),
'et'    : ("time", "Observation epoch."),
'outref': ("frame_name", "Reference frame of output state."),
'refloc': ("string", "Output reference frame evaluation locus."),
'abcorr': ("string", "Aberration correction."),
'obsrvr': ("body_name", "Name of observing ephemeris object."),
'state' : ("float[6]", "State of target with respect to observer."),
'lt'    : ("float", "One way light time between target and observer."),
}
CSPYCE_URL["spkcvt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkcvt_c.html"
#########################################
CSPYCE_ARGNAMES["spklef"] = ["fname"]
CSPYCE_RETNAMES["spklef"] = ["handle"]
CSPYCE_ABSTRACT["spklef"] = """
Load an ephemeris file for use by the readers. Return that file's
handle, to be used by other SPK routines to refer to the file.
"""
CSPYCE_DEFINITIONS["spklef"] = {
'fname' : ("string", "Name of the file to be loaded."),
'handle': ("int", "Loaded file's handle."),
}
CSPYCE_URL["spklef"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spklef_c.html"
#########################################
CSPYCE_ARGNAMES["spkopa"] = ["file"]
CSPYCE_RETNAMES["spkopa"] = ["handle"]
CSPYCE_ABSTRACT["spkopa"] = """
Open an existing SPK file for subsequent write.
"""
CSPYCE_DEFINITIONS["spkopa"] = {
'file'  : ("string", "The name of an existing SPK file."),
'handle': ("int", "Handle attached to the SPK file opened to append."),
}
CSPYCE_URL["spkopa"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkopa_c.html"
#########################################
CSPYCE_ARGNAMES["spkopn"] = ["fname", "ifname", "ncomch"]
CSPYCE_RETNAMES["spkopn"] = ["handle"]
CSPYCE_ABSTRACT["spkopn"] = """
Create a new SPK file, returning the handle of the opened file.
"""
CSPYCE_DEFINITIONS["spkopn"] = {
'fname' : ("string", "The name of the new SPK file to be created."),
'ifname': ("string", "The internal filename for the SPK file."),
'ncomch': ("int", "The number of characters to reserve for comments."),
'handle': ("int", "The handle of the opened SPK file."),
}
CSPYCE_URL["spkopn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkopn_c.html"
#########################################
CSPYCE_ARGNAMES["spkpds"] = ["body", "center", "frame", "type", "first", "last"]
CSPYCE_RETNAMES["spkpds"] = ["descr"]
CSPYCE_ABSTRACT["spkpds"] = """
Perform routine error checks and if all check pass, pack the descriptor
for an SPK segment
"""
CSPYCE_DEFINITIONS["spkpds"] = {
'body'  : ("body_code", "The NAIF ID code for the body of the segment."),
'center': ("body_code", "The center of motion for body."),
'frame' : ("string", "The frame for this segment."),
'type'  : ("int", "The type of SPK segment to create."),
'first' : ("float", "The first epoch for which the segment is valid."),
'last'  : ("float", "The last epoch for which the segment is valid."),
'descr' : ("float[5]", "An SPK segment descriptor."),
}
CSPYCE_URL["spkpds"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkpds_c.html"
#########################################
CSPYCE_ARGNAMES["spkpvn"] = ["handle", "descr", "et"]
CSPYCE_RETNAMES["spkpvn"] = ["ref", "state", "center"]
CSPYCE_ABSTRACT["spkpvn"] = """
Return, for a specified SPK segment and time, the state (position and
velocity) of the segment's target body relative to its center of motion.
"""
CSPYCE_DEFINITIONS["spkpvn"] = {
'handle': ("int", "File handle."),
'descr' : ("float[5]", "Segment descriptor."),
'et'    : ("time", "Evaluation epoch."),
'ref'   : ("frame_code", "Segment reference frame ID code."),
'state' : ("float[6]", "Output state vector."),
'center': ("body_code", "Center of state."),
}
CSPYCE_URL["spkpvn"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkpvn_c.html"
#########################################
CSPYCE_ARGNAMES["spksfs"] = ["body", "et"]
CSPYCE_RETNAMES["spksfs"] = ["handle", "descr", "ident", "found"]
CSPYCE_ABSTRACT["spksfs"] = """
Search through loaded SPK files to find the highest-priority segment
applicable to the body and time specified and buffer searched segments
in the process, to attempt to avoid re-reading files.
"""
CSPYCE_DEFINITIONS["spksfs"] = {
'body'  : ("body_code", "Body ID."),
'et'    : ("time", "Ephemeris time."),
'handle': ("int", "Handle of file containing the applicable segment."),
'descr' : ("float[5]", "Descriptor of the applicable segment."),
'ident' : ("string", "Identifier of the applicable segment."),
'found' : ("bool", "Indicates whether or not a segment was found."),
}
CSPYCE_URL["spksfs"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spksfs_c.html"
#########################################
CSPYCE_ARGNAMES["spksub"] = ["handle", "descr", "ident", "begin", "end", "newh"]
CSPYCE_RETNAMES["spksub"] = []
CSPYCE_ABSTRACT["spksub"] = """
Extract a subset of the data in an SPK segment into a separate segment.
"""
CSPYCE_DEFINITIONS["spksub"] = {
'handle': ("int", "Handle of source segment."),
'descr' : ("float[5]", "Descriptor of source segment."),
'ident' : ("string", "Identifier of source segment."),
'begin' : ("float", "Beginning (initial epoch) of subset."),
'end'   : ("float", "End (final epoch) of subset."),
'newh'  : ("int", "Handle of new segment."),
}
CSPYCE_URL["spksub"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spksub_c.html"
#########################################
CSPYCE_ARGNAMES["spkuds"] = ["descr"]
CSPYCE_RETNAMES["spkuds"] = ["body", "center", "frame", "type", "first", "last", "baddrs", "eaddrs"]
CSPYCE_ABSTRACT["spkuds"] = """
Unpack the contents of an SPK segment descriptor.
"""
CSPYCE_DEFINITIONS["spkuds"] = {
'descr' : ("float[5]", "An SPK segment descriptor."),
'body'  : ("body_code", "The NAIF ID code for the body of the segment."),
'center': ("body_code", "The center of motion for `body'."),
'frame' : ("int", "The code for the frame of this segment."),
'type'  : ("int", "The type of SPK segment."),
'first' : ("float", "The first epoch for which the segment is valid."),
'last'  : ("float", "The last epoch for which the segment is valid."),
'baddrs': ("int", "Beginning DAF address of the segment."),
'eaddrs': ("int", "Ending DAF address of the segment."),
}
CSPYCE_URL["spkuds"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkuds_c.html"
#########################################
CSPYCE_ARGNAMES["spkuef"] = ["handle"]
CSPYCE_RETNAMES["spkuef"] = []
CSPYCE_ABSTRACT["spkuef"] = """
Unload an ephemeris file so that it will no longer be searched by the
readers.
"""
CSPYCE_DEFINITIONS["spkuef"] = {
'handle': ("int", "Handle of file to be unloaded"),
}
CSPYCE_URL["spkuef"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkuef_c.html"
#########################################
CSPYCE_ARGNAMES["spkw02"] = ["handle", "body", "center", "frame", "first", "last", "segid", "intlen", "n", "polydg", "cdata", "btime"]
CSPYCE_RETNAMES["spkw02"] = []
CSPYCE_ABSTRACT["spkw02"] = """
Write a type 2 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw02"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "Body code for ephemeris object."),
'center': ("body_code", "Body code for the center of motion of the body."),
'frame' : ("string", "The reference frame of the states."),
'first' : ("float", "First valid time for which states can be computed."),
'last'  : ("float", "Last valid time for which states can be computed."),
'segid' : ("string", "Segment identifier."),
'intlen': ("float", "Length of time covered by logical record."),
'n'     : ("int", "Number of coefficient sets."),
'polydg': ("int", "Chebyshev polynomial degree."),
'cdata' : ("float[*]", "Array of Chebyshev coefficients."),
'btime' : ("float", "Begin time of first logical record."),
}
CSPYCE_URL["spkw02"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw02_c.html"
#########################################
CSPYCE_ARGNAMES["spkw03"] = ["handle", "body", "center", "frame", "first", "last", "segid", "intlen", "n", "polydg", "cdata", "btime"]
CSPYCE_RETNAMES["spkw03"] = []
CSPYCE_ABSTRACT["spkw03"] = """
Write a type 3 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw03"] = {
'handle': ("int", "Handle of SPK file open for writing."),
'body'  : ("body_code", "NAIF code for ephemeris object."),
'center': ("body_code", "NAIF code for the center of motion of the body."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'intlen': ("float", "Length of time covered by record."),
'n'     : ("int", "Number of records in segment."),
'polydg': ("int", "Chebyshev polynomial degree."),
'cdata' : ("float[*]", "Array of Chebyshev coefficients."),
'btime' : ("float", "Begin time of first record."),
}
CSPYCE_URL["spkw03"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw03_c.html"
#########################################
CSPYCE_ARGNAMES["spkw05"] = ["handle", "body", "center", "frame", "first", "last", "segid", "gm", "n", "states", "epochs"]
CSPYCE_RETNAMES["spkw05"] = []
CSPYCE_ABSTRACT["spkw05"] = """
Write an SPK segment of type 5 given a time-ordered set of discrete
states and epochs, and the gravitational parameter of a central body.
"""
CSPYCE_DEFINITIONS["spkw05"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "Body code for ephemeris object."),
'center': ("body_code", "Body code for the center of motion of the body."),
'frame' : ("string", "The reference frame of the states."),
'first' : ("float", "First valid time for which states can be computed."),
'last'  : ("float", "Last valid time for which states can be computed."),
'segid' : ("string", "Segment identifier."),
'gm'    : ("float", "Gravitational parameter of central body."),
'n'     : ("int", "Number of states and epochs."),
'states': ("float[*,6]", "States."),
'epochs': ("time[*]", "Epochs."),
}
CSPYCE_URL["spkw05"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw05_c.html"
#########################################
CSPYCE_ARGNAMES["spkw08"] = ["handle", "body", "center", "frame", "first", "last", "segid", "degree", "n", "states", "begtim", "step"]
CSPYCE_RETNAMES["spkw08"] = []
CSPYCE_ABSTRACT["spkw08"] = """
Write a type 8 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw08"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "NAIF code for an ephemeris object."),
'center': ("body_code", "NAIF code for center of motion of BODY."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'degree': ("int", "Degree of interpolating polynomials."),
'n'     : ("int", "Number of states."),
'states': ("float[*,6]", "Array of states."),
'begtim': ("float", "Epoch of first state in states array."),
'step'  : ("float", "Time step separating epochs of states."),
}
CSPYCE_URL["spkw08"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw08_c.html"
#########################################
CSPYCE_ARGNAMES["spkw09"] = ["handle", "body", "center", "frame", "first", "last", "segid", "degree", "n", "states", "epochs"]
CSPYCE_RETNAMES["spkw09"] = []
CSPYCE_ABSTRACT["spkw09"] = """
Write a type 9 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw09"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "NAIF code for an ephemeris object."),
'center': ("body_code", "NAIF code for center of motion of body."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'degree': ("int", "Degree of interpolating polynomials."),
'n'     : ("int", "Number of states."),
'states': ("float[*,6]", "Array of states."),
'epochs': ("time[*]", "Array of epochs corresponding to states."),
}
CSPYCE_URL["spkw09"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw09_c.html"
#########################################
CSPYCE_ARGNAMES["spkw10"] = ["handle", "body", "center", "frame", "first", "last", "segid", "consts", "n", "elems", "epochs"]
CSPYCE_RETNAMES["spkw10"] = []
CSPYCE_ABSTRACT["spkw10"] = """
Write an SPK type 10 segment to the file specified by the input
`handle'.
"""
CSPYCE_DEFINITIONS["spkw10"] = {
'handle': ("int", "The handle of a DAF file open for writing."),
'body'  : ("body_code", "The NAIF ID code for the body of the segment."),
'center': ("body_code", "The center of motion for `body'."),
'frame' : ("string", "The reference frame for this segment."),
'first' : ("float", "The first epoch for which the segment is valid."),
'last'  : ("float", "The last epoch for which the segment is valid."),
'segid' : ("string", "The string to use for segment identifier."),
'consts': ("float[8]", "Array of geophysical constants for the segment."),
'n'     : ("int", "The number of element/epoch pairs to be stored"),
'elems' : ("float[*]", "The collection of \"two-line\" element sets."),
'epochs': ("time[*]", "The epochs associated with the element sets."),
}
CSPYCE_URL["spkw10"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw10_c.html"
#########################################
CSPYCE_ARGNAMES["spkw12"] = ["handle", "body", "center", "frame", "first", "last", "segid", "degree", "n", "states", "begtim", "step"]
CSPYCE_RETNAMES["spkw12"] = []
CSPYCE_ABSTRACT["spkw12"] = """
Write a type 12 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw12"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "NAIF code for an ephemeris object."),
'center': ("body_code", "NAIF code for center of motion of body."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'degree': ("int", "Degree of interpolating polynomials."),
'n'     : ("int", "Number of states."),
'states': ("float[*,6]", "Array of states."),
'begtim': ("float", "Epoch of first state in states array."),
'step'  : ("float", "Time step separating epochs of states."),
}
CSPYCE_URL["spkw12"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw12_c.html"
#########################################
CSPYCE_ARGNAMES["spkw13"] = ["handle", "body", "center", "frame", "first", "last", "segid", "degree", "n", "states", "epochs"]
CSPYCE_RETNAMES["spkw13"] = []
CSPYCE_ABSTRACT["spkw13"] = """
Write a type 13 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw13"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "NAIF code for an ephemeris object."),
'center': ("body_code", "NAIF code for center of motion of body."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'degree': ("int", "Degree of interpolating polynomials."),
'n'     : ("int", "Number of states."),
'states': ("float[*,6]", "Array of states."),
'epochs': ("time[*]", "Array of epochs corresponding to states."),
}
CSPYCE_URL["spkw13"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw13_c.html"
#########################################
CSPYCE_ARGNAMES["spkw15"] = ["handle", "body", "center", "frame", "first", "last", "segid", "epoch", "tp", "pa", "p", "ecc", "j2flg", "pv", "gm", "j2", "radius"]
CSPYCE_RETNAMES["spkw15"] = []
CSPYCE_ABSTRACT["spkw15"] = """
Write an SPK segment of type 15 given a type 15 data record.
"""
CSPYCE_DEFINITIONS["spkw15"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "Body code for ephemeris object."),
'center': ("body_code", "Body code for the center of motion of the body."),
'frame' : ("string", "The reference frame of the states."),
'first' : ("float", "First valid time for which states can be computed."),
'last'  : ("float", "Last valid time for which states can be computed."),
'segid' : ("string", "Segment identifier."),
'epoch' : ("time", "Epoch of the periapse."),
'tp'    : ("float[3]", "Trajectory pole vector."),
'pa'    : ("float[3]", "Periapsis vector."),
'p'     : ("float", "Semi-latus rectum."),
'ecc'   : ("float", "Eccentricity."),
'j2flg' : ("float", "J2 processing flag."),
'pv'    : ("float[3]", "Central body pole vector."),
'gm'    : ("float", "Central body GM."),
'j2'    : ("float", "Central body J2."),
'radius': ("float", "Equatorial radius of central body."),
}
CSPYCE_URL["spkw15"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw15_c.html"
#########################################
CSPYCE_ARGNAMES["spkw17"] = ["handle", "body", "center", "frame", "first", "last", "segid", "epoch", "eqel", "rapol", "decpol"]
CSPYCE_RETNAMES["spkw17"] = []
CSPYCE_ABSTRACT["spkw17"] = """
Write an SPK segment of type 17 given a type 17 data record.
"""
CSPYCE_DEFINITIONS["spkw17"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'body'  : ("body_code", "Body code for ephemeris object."),
'center': ("body_code", "Body code for the center of motion of the body."),
'frame' : ("string", "The reference frame of the states."),
'first' : ("float", "First valid time for which states can be computed."),
'last'  : ("float", "Last valid time for which states can be computed."),
'segid' : ("string", "Segment identifier."),
'epoch' : ("time", "Epoch of elements in seconds past J2000."),
'eqel'  : ("float[9]", "Array of equinoctial elements."),
'rapol' : ("float", "Right Ascension of the reference plane's pole."),
'decpol': ("float", "Declination of the reference plane's pole."),
}
CSPYCE_URL["spkw17"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw17_c.html"
#########################################
CSPYCE_ARGNAMES["spkw18"] = ["handle", "subtyp", "body", "center", "frame", "first", "last", "segid", "degree", "n", "packts", "epochs"]
CSPYCE_RETNAMES["spkw18"] = []
CSPYCE_ABSTRACT["spkw18"] = """
Write a type 18 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw18"] = {
'handle': ("int", "Handle of an SPK file open for writing."),
'subtyp': ("string", "SPK type 18 subtype code."),
'body'  : ("body_code", "NAIF code for an ephemeris object."),
'center': ("body_code", "NAIF code for center of motion of `body'."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'degree': ("int", "Degree of interpolating polynomials."),
'n'     : ("int", "Number of packets."),
'packts': ("float[*]", "Array of packets."),
'epochs': ("time[*]", "Array of epochs corresponding to packets."),
}
CSPYCE_URL["spkw18"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw18_c.html"
#########################################
CSPYCE_ARGNAMES["spkw20"] = ["handle", "body", "center", "frame", "first", "last", "segid", "intlen", "n", "polydg", "cdata", "dscale", "tscale", "initjd", "initfr"]
CSPYCE_RETNAMES["spkw20"] = []
CSPYCE_ABSTRACT["spkw20"] = """
Write a type 20 segment to an SPK file.
"""
CSPYCE_DEFINITIONS["spkw20"] = {
'handle': ("int", "Handle of SPK file open for writing."),
'body'  : ("body_code", "NAIF code for ephemeris object."),
'center': ("body_code", "NAIF code for the center of motion of the body."),
'frame' : ("string", "Reference frame name."),
'first' : ("float", "Start time of interval covered by segment."),
'last'  : ("float", "End time of interval covered by segment."),
'segid' : ("string", "Segment identifier."),
'intlen': ("float", "Length of time covered by logical record (days)."),
'n'     : ("int", "Number of logical records in segment."),
'polydg': ("int", "Chebyshev polynomial degree."),
'cdata' : ("float[*]", "Array of Chebyshev coefficients and positions."),
'dscale': ("float", "Distance scale of data."),
'tscale': ("float", "Time scale of data."),
'initjd': ("float", "Integer part of begin time (TDB Julian date) of first record."),
'initfr': ("float", "Fractional part of begin time (TDB Julian date) of first record."),
}
CSPYCE_URL["spkw20"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/spkw20_c.html"
#########################################
CSPYCE_ARGNAMES["sumad"] = ["array"]
CSPYCE_RETNAMES["sumad"] = ["sum"]
CSPYCE_ABSTRACT["sumad"] = """
Return the sum of the elements of a floating-point array.
"""
CSPYCE_DEFINITIONS["sumad"] = {
'array' : ("float[*]", "Input array."),
'sum'   : ("float", "Sum of elements."),
}
CSPYCE_URL["sumad"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sumad_c.html"
#########################################
CSPYCE_ARGNAMES["sumai"] = ["array"]
CSPYCE_RETNAMES["sumai"] = ["sum"]
CSPYCE_ABSTRACT["sumai"] = """
Return the sum of the elements of an integer array.
"""
CSPYCE_DEFINITIONS["sumai"] = {
'array' : ("int[*]", "Input array."),
'sum'   : ("int", "Sum of elements."),
}
CSPYCE_URL["sumai"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/sumai_c.html"
#########################################
CSPYCE_ARGNAMES["swpool"] = ["agent", "names"]
CSPYCE_RETNAMES["swpool"] = []
CSPYCE_ABSTRACT["swpool"] = """
Add a name to the list of agents to notify whenever a member of a list
of kernel variables is updated.
"""
CSPYCE_DEFINITIONS["swpool"] = {
'agent' : ("string", "The name of an agent to be notified after updates."),
'names' : ("string[*]", "Variable names whose update causes the notice."),
}
CSPYCE_URL["swpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/swpool_c.html"
#########################################
CSPYCE_ARGNAMES["szpool"] = ["name"]
CSPYCE_RETNAMES["szpool"] = ["n", "found"]
CSPYCE_ABSTRACT["szpool"] = """
Return the kernel pool size limitations.
"""
CSPYCE_DEFINITIONS["szpool"] = {
'name'  : ("string", "Name of the parameter to be returned, one of \"MAXVAR\", \"MAXLEN\", \"MAXVAL\", \"MXNOTE\", \"MAXAGT\", \"MAXCHR\", or \"MAXLIN\"."),
'n'     : ("int", "Value of parameter specified by name."),
'found' : ("bool", "True if name is recognized."),
}
CSPYCE_URL["szpool"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/szpool_c.html"
#########################################
CSPYCE_ARGNAMES["tangpt"] = ["method", "target", "et", "fixref", "abcorr", "corloc", "obsrvr", "dref", "dvec"]
CSPYCE_RETNAMES["tangpt"] = ["tanpt", "alt", "range", "srfpt", "trgepc", "srfvec"]
CSPYCE_ABSTRACT["tangpt"] = """
Compute, for a given observer, ray emanating from the observer, and
target, the "tangent point": the point on the ray nearest to the
target's surface. Also compute the point on the target's surface nearest
to the tangent point. The locations of both points are optionally
corrected for light time and stellar aberration. The surface shape is
modeled as a triaxial ellipsoid.
"""
CSPYCE_DEFINITIONS["tangpt"] = {
'method': ("string", "Computation method."),
'target': ("body_name", "Name of target body."),
'et'    : ("time", "Epoch in ephemeris seconds past J2000 TDB."),
'fixref': ("frame_name", "Body-fixed, body-centered target body frame."),
'abcorr': ("string", "Aberration correction."),
'corloc': ("string", "Aberration correction locus: \"TANGENT POINT\" or \"SURFACE POINT\"."),
'obsrvr': ("body_name", "Name of observing body."),
'dref'  : ("frame_name", "Reference frame of ray direction vector."),
'dvec'  : ("float[3]", "Ray direction vector."),
'tanpt' : ("float[3]", "\"Tangent point\": point on ray nearest to surface."),
'alt'   : ("float", "Altitude of tangent point above surface."),
'range' : ("float", "Distance of tangent point from observer."),
'srfpt' : ("float[3]", "Point on surface nearest to tangent point."),
'trgepc': ("time", "Epoch associated with correction locus."),
'srfvec': ("float[3]", "Vector from observer to surface point `srfpt'."),
}
CSPYCE_URL["tangpt"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tangpt_c.html"
#########################################
CSPYCE_ARGNAMES["tkfram"] = ["frcode"]
CSPYCE_RETNAMES["tkfram"] = ["rot", "frame", "found"]
CSPYCE_ABSTRACT["tkfram"] = """
Find the position rotation matrix from a Text Kernel (TK) frame with the
specified frame class ID to its base frame.
"""
CSPYCE_DEFINITIONS["tkfram"] = {
'frcode': ("frame_code", "Frame class ID of a TK frame."),
'rot'   : ("float[3,3]", "Rotation matrix from TK frame to frame `frame'."),
'frame' : ("int", "Frame ID of the base reference."),
'found' : ("bool", "True if the rotation could be determined."),
}
CSPYCE_URL["tkfram"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tkfram_c.html"
#########################################
CSPYCE_ARGNAMES["tparch"] = ["type"]
CSPYCE_RETNAMES["tparch"] = []
CSPYCE_ABSTRACT["tparch"] = """
Restrict the set of strings that are recognized by SPICE time parsing
routines to those that have standard values for all time components.
"""
CSPYCE_DEFINITIONS["tparch"] = {
'type'  : ("string", "String: Use \"YES\" to restrict time inputs."),
}
CSPYCE_URL["tparch"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/tparch_c.html"
#########################################
CSPYCE_ARGNAMES["trgsep"] = ["et", "targ1", "shape1", "frame1", "targ2", "shape2", "frame2", "obsrvr", "abcorr"]
CSPYCE_RETNAMES["trgsep"] = ["sep"]
CSPYCE_ABSTRACT["trgsep"] = """
Compute the angular separation in radians between two spherical or point
objects.
"""
CSPYCE_DEFINITIONS["trgsep"] = {
'et'    : ("time", "Ephemeris seconds past J2000 TDB."),
'targ1' : ("body_name", "First target body name."),
'shape1': ("string", "First target body shape."),
'frame1': ("frame_name", "Reference frame of first target."),
'targ2' : ("body_name", "Second target body name."),
'shape2': ("string", "First target body shape."),
'frame2': ("frame_name", "Reference frame of second target."),
'obsrvr': ("body_name", "Observing body name."),
'abcorr': ("string", "Aberration corrections flag."),
'sep'   : ("float", "Separation angle in radians."),
}
CSPYCE_URL["trgsep"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/trgsep_c.html"
#########################################
CSPYCE_ARGNAMES["twovxf"] = ["axdef", "indexa", "plndef", "indexp"]
CSPYCE_RETNAMES["twovxf"] = ["xform"]
CSPYCE_ABSTRACT["twovxf"] = """
Find the state transformation from a base frame to the right-handed
frame defined by two state vectors: one state vector defining a
specified axis and a second state vector defining a specified coordinate
plane.
"""
CSPYCE_DEFINITIONS["twovxf"] = {
'axdef' : ("float[6]", "State defining a principal axis."),
'indexa': ("int", "Principal axis number of `axdef' (x=1, y=2, z=3)."),
'plndef': ("float[6]", "State defining (with `axdef') a principal plane."),
'indexp': ("int", "Second axis number (with `indexa') of principal plane."),
'xform' : ("float[6,6]", "Output state transformation matrix."),
}
CSPYCE_URL["twovxf"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/twovxf_c.html"
#########################################
CSPYCE_ARGNAMES["vprojg"] = ["a", "b"]
CSPYCE_RETNAMES["vprojg"] = ["p"]
CSPYCE_ABSTRACT["vprojg"] = """
Compute the projection of one vector onto another vector. All vectors
are of arbitrary dimension.
"""
CSPYCE_DEFINITIONS["vprojg"] = {
'a'     : ("float[*]", "The vector to be projected."),
'b'     : ("float[*]", "The vector onto which `a' is to be projected."),
'p'     : ("float[*]", "The projection of `a' onto `b'."),
}
CSPYCE_URL["vprojg"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/vprojg_c.html"
#########################################
CSPYCE_ARGNAMES["wncomd"] = ["left", "right", "window"]
CSPYCE_RETNAMES["wncomd"] = ["result"]
CSPYCE_ABSTRACT["wncomd"] = """
Determine the complement of a floating-point window with respect to a
specified interval.
"""
CSPYCE_DEFINITIONS["wncomd"] = {
'left'  : ("float", "Left endpoint of complement interval."),
'right' : ("float", "Right endpoint of complement interval."),
'window': ("float[*,2]", "Input window."),
'result': ("float[*,2]", "Complement of window with respect to [left,right]."),
}
CSPYCE_URL["wncomd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wncomd_c.html"
#########################################
CSPYCE_ARGNAMES["wncond"] = ["left", "right", "window"]
CSPYCE_RETNAMES["wncond"] = ["result"]
CSPYCE_ABSTRACT["wncond"] = """
Contract each of the intervals of a floating-point window.
"""
CSPYCE_DEFINITIONS["wncond"] = {
'left'  : ("float", "Amount added to each left endpoint."),
'right' : ("float", "Amount subtracted from each right endpoint."),
'window': ("float[*,2]", "Window to be contracted."),
'result': ("float[*,2]", "Contracted window."),
}
CSPYCE_URL["wncond"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wncond_c.html"
#########################################
CSPYCE_ARGNAMES["wndifd"] = ["a", "b"]
CSPYCE_RETNAMES["wndifd"] = ["c"]
CSPYCE_ABSTRACT["wndifd"] = """
Place the difference of two floating-point windows into a third window.
"""
CSPYCE_DEFINITIONS["wndifd"] = {
'a'     : ("float[*,2]", "First input window."),
'b'     : ("float[*,2]", "Second input windows."),
'c'     : ("float[*,2]", "Difference of `a' and `b'."),
}
CSPYCE_URL["wndifd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wndifd_c.html"
#########################################
CSPYCE_ARGNAMES["wnelmd"] = ["point", "window"]
CSPYCE_RETNAMES["wnelmd"] = ["flag"]
CSPYCE_ABSTRACT["wnelmd"] = """
Determine whether a point is an element of a floating-point window.
"""
CSPYCE_DEFINITIONS["wnelmd"] = {
'point' : ("float", "Input point."),
'window': ("float[*,2]", "Input window."),
'flag'  : ("bool", "True if the point is an element; False otherwise."),
}
CSPYCE_URL["wnelmd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnelmd_c.html"
#########################################
CSPYCE_ARGNAMES["wnexpd"] = ["left", "right", "window"]
CSPYCE_RETNAMES["wnexpd"] = ["result"]
CSPYCE_ABSTRACT["wnexpd"] = """
Expand each of the intervals of a floating-point window.
"""
CSPYCE_DEFINITIONS["wnexpd"] = {
'left'  : ("float", "Amount subtracted from each left endpoint."),
'right' : ("float", "Amount added to each right endpoint."),
'window': ("float[*,2]", "Window to be expanded."),
'result': ("float[*,2]", "Expanded window."),
}
CSPYCE_URL["wnexpd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnexpd_c.html"
#########################################
CSPYCE_ARGNAMES["wnextd"] = ["side", "window"]
CSPYCE_RETNAMES["wnextd"] = ["result"]
CSPYCE_ABSTRACT["wnextd"] = """
Extract the left or right endpoints from a floating-point window.
"""
CSPYCE_DEFINITIONS["wnextd"] = {
'side'  : ("string", "Extract left ('L') or right ('R') endpoints."),
'window': ("float[*,2]", "Window to be extracted."),
'result': ("float[*,2]", "Extracted window."),
}
CSPYCE_URL["wnextd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnextd_c.html"
#########################################
CSPYCE_ARGNAMES["wnfild"] = ["smlgap", "window"]
CSPYCE_RETNAMES["wnfild"] = ["result"]
CSPYCE_ABSTRACT["wnfild"] = """
Fill small gaps between adjacent intervals of a floating-point window.
"""
CSPYCE_DEFINITIONS["wnfild"] = {
'smlgap': ("float", "Limiting measure of small gaps."),
'window': ("float[*,2]", "Window to be filled."),
'result': ("float[*,2]", "Window after being filled."),
}
CSPYCE_URL["wnfild"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnfild_c.html"
#########################################
CSPYCE_ARGNAMES["wnfltd"] = ["smlint", "window"]
CSPYCE_RETNAMES["wnfltd"] = ["result"]
CSPYCE_ABSTRACT["wnfltd"] = """
Filter (remove) small intervals from a floating-point window.
"""
CSPYCE_DEFINITIONS["wnfltd"] = {
'smlint': ("float", "Limiting measure of small intervals."),
'window': ("float[*,2]", "Window to be filtered."),
'result': ("float[*,2]", "Window after being filtered."),
}
CSPYCE_URL["wnfltd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnfltd_c.html"
#########################################
CSPYCE_ARGNAMES["wnincd"] = ["left", "right", "window"]
CSPYCE_RETNAMES["wnincd"] = ["flag"]
CSPYCE_ABSTRACT["wnincd"] = """
Determine whether an interval is included in a floating-point window.
"""
CSPYCE_DEFINITIONS["wnincd"] = {
'left'  : ("float", "Minimum of input interval."),
'right' : ("float", "Maximum of input interval."),
'window': ("float[*,2]", "Input window."),
'flag'  : ("bool", "True if the interval is included; False otherwise."),
}
CSPYCE_URL["wnincd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnincd_c.html"
#########################################
CSPYCE_ARGNAMES["wninsd"] = ["left", "right", "window"]
CSPYCE_RETNAMES["wninsd"] = ["result"]
CSPYCE_ABSTRACT["wninsd"] = """
Insert an interval into a floating-point window.
"""
CSPYCE_DEFINITIONS["wninsd"] = {
'left'  : ("float", "Left endpoint of new interval."),
'right' : ("float", "Right endpoint of new interval."),
'window': ("float[*,2]", "Input window."),
'result': ("float[*,2]", "New window."),
}
CSPYCE_URL["wninsd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wninsd_c.html"
#########################################
CSPYCE_ARGNAMES["wnintd"] = ["a", "b"]
CSPYCE_RETNAMES["wnintd"] = ["c"]
CSPYCE_ABSTRACT["wnintd"] = """
Place the intersection of two floating-point windows into a third
window.
"""
CSPYCE_DEFINITIONS["wnintd"] = {
'a'     : ("float[*,2]", "First input window."),
'b'     : ("float[*,2]", "Second input window."),
'c'     : ("float[*,2]", "Intersection of `a' and `b'."),
}
CSPYCE_URL["wnintd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnintd_c.html"
#########################################
CSPYCE_ARGNAMES["wnreld"] = ["a", "op", "b"]
CSPYCE_RETNAMES["wnreld"] = ["flag"]
CSPYCE_ABSTRACT["wnreld"] = """
Compare two floating-point windows.
"""
CSPYCE_DEFINITIONS["wnreld"] = {
'a'     : ("float[*,2]", "First window."),
'op'    : ("string", "Comparison operator: \"=\" for equal; \"<>\" for not equal; \"<=\" for `a' a subset of `b'; \"<\" for `a' a proper subset of `b'; \">=\" for `b' a subset of `a'; \">\" for `b' a proper subset of `a'."),
'b'     : ("float[*,2]", "Second window."),
'flag'  : ("bool", "True if the comparison is satisfied."),
}
CSPYCE_URL["wnreld"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnreld_c.html"
#########################################
CSPYCE_ARGNAMES["wnsumd"] = ["window"]
CSPYCE_RETNAMES["wnsumd"] = ["meas", "avg", "stddev", "idxsml", "idxlon"]
CSPYCE_ABSTRACT["wnsumd"] = """
Summarize the contents of a floating-point window.
"""
CSPYCE_DEFINITIONS["wnsumd"] = {
'window': ("float[*,2]", "Window to be summarized."),
'meas'  : ("float", "Total measure of intervals in window."),
'avg'   : ("float", "Average measure."),
'stddev': ("float", "Standard deviation."),
'idxsml': ("int", "Location of shortest interval."),
'idxlon': ("int", "Location of longest interval."),
}
CSPYCE_URL["wnsumd"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnsumd_c.html"
#########################################
CSPYCE_ARGNAMES["wnunid"] = ["a", "b"]
CSPYCE_RETNAMES["wnunid"] = ["c"]
CSPYCE_ABSTRACT["wnunid"] = """
Place the union of two floating-point windows into a third window.
"""
CSPYCE_DEFINITIONS["wnunid"] = {
'a'     : ("float[*,2]", "First input window."),
'b'     : ("float[*,2]", "Second input window."),
'c'     : ("float[*,2]", "Union of `a' and `b'."),
}
CSPYCE_URL["wnunid"] = "https://naif.jpl.nasa.gov/pub/naif/toolkit_docs/C/cspice/wnunid_c.html"
#########################################

# Derive the CSPYCE_SIGNATURES, CSPYCE_RETURNS, and CSPYCE_DEFAULTS structures
CSPYCE_SIGNATURES = {}
CSPYCE_RETURNS = {}
for (func, def_dict) in CSPYCE_DEFINITIONS.items():
    CSPYCE_SIGNATURES[func] = [def_dict[name][0]
                               for name in CSPYCE_ARGNAMES[func]]
    CSPYCE_RETURNS[func] = [def_dict[name][0]
                            for name in CSPYCE_RETNAMES[func]]

################################################################################
