"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackInstances = exports.StackInstancesProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "StackInstancesProperty", { enumerable: true, get: function () { return ros_generated_1.RosStackInstances; } });
/**
 * A ROS resource type:  `ALIYUN::ROS::StackInstances`
 */
class StackInstances extends ros.Resource {
    /**
     * Create a new `ALIYUN::ROS::StackInstances`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosStackInstances = new ros_generated_1.RosStackInstances(this, id, {
            operationPreferences: props.operationPreferences,
            retainStacks: props.retainStacks === undefined || props.retainStacks === null ? false : props.retainStacks,
            regionIds: props.regionIds,
            accountIds: props.accountIds,
            parameterOverrides: props.parameterOverrides,
            stackGroupName: props.stackGroupName,
            deploymentTargets: props.deploymentTargets,
            operationDescription: props.operationDescription,
            disableRollback: props.disableRollback,
            timeoutInMinutes: props.timeoutInMinutes,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosStackInstances;
        this.attrLastOperationId = rosStackInstances.attrLastOperationId;
        this.attrStacks = rosStackInstances.attrStacks;
    }
}
exports.StackInstances = StackInstances;
//# sourceMappingURL=data:application/json;base64,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