/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.StringUtil;

public class B64Code {
    static final char pad = '=';
    static final char[] nibble2code = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static byte[] code2nibble = null;

    public static String encode(String s2) {
        try {
            return B64Code.encode(s2, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static String encode(String s2, String charEncoding) throws UnsupportedEncodingException {
        byte[] bytes = charEncoding == null ? s2.getBytes(StringUtil.__ISO_8859_1) : s2.getBytes(charEncoding);
        return new String(B64Code.encode(bytes));
    }

    public static char[] encode(byte[] b) {
        byte b1;
        byte b0;
        if (b == null) {
            return null;
        }
        int bLen = b.length;
        char[] r = new char[(bLen + 2) / 3 * 4];
        int ri = 0;
        int bi = 0;
        int stop = bLen / 3 * 3;
        while (bi < stop) {
            b0 = b[bi++];
            b1 = b[bi++];
            byte b2 = b[bi++];
            r[ri++] = nibble2code[b0 >>> 2 & 0x3F];
            r[ri++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
            r[ri++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
            r[ri++] = nibble2code[b2 & 0x3F];
        }
        if (bLen != bi) {
            switch (bLen % 3) {
                case 2: {
                    b0 = b[bi++];
                    b1 = b[bi++];
                    r[ri++] = nibble2code[b0 >>> 2 & 0x3F];
                    r[ri++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                    r[ri++] = nibble2code[b1 << 2 & 0x3F];
                    r[ri++] = 61;
                    break;
                }
                case 1: {
                    b0 = b[bi++];
                    r[ri++] = nibble2code[b0 >>> 2 & 0x3F];
                    r[ri++] = nibble2code[b0 << 4 & 0x3F];
                    r[ri++] = 61;
                    r[ri++] = 61;
                    break;
                }
            }
        }
        return r;
    }

    public static String decode(String s2) {
        try {
            return B64Code.decode(s2, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static String decode(String s2, String charEncoding) throws UnsupportedEncodingException {
        byte[] decoded = B64Code.decode(s2.toCharArray());
        if (charEncoding == null) {
            return new String(decoded);
        }
        return new String(decoded, charEncoding);
    }

    public static byte[] decode(char[] b) {
        int li;
        if (b == null) {
            return null;
        }
        int bLen = b.length;
        if (bLen % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        for (li = bLen - 1; li >= 0 && b[li] == '='; --li) {
        }
        if (li < 0) {
            return new byte[0];
        }
        int rLen = (li + 1) * 3 / 4;
        byte[] r = new byte[rLen];
        int ri = 0;
        int bi = 0;
        int stop = rLen / 3 * 3;
        try {
            byte b2;
            byte b1;
            byte b0;
            while (ri < stop) {
                b0 = code2nibble[b[bi++]];
                b1 = code2nibble[b[bi++]];
                b2 = code2nibble[b[bi++]];
                byte b3 = code2nibble[b[bi++]];
                if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                r[ri++] = (byte)(b0 << 2 | b1 >>> 4);
                r[ri++] = (byte)(b1 << 4 | b2 >>> 2);
                r[ri++] = (byte)(b2 << 6 | b3);
            }
            if (rLen != ri) {
                switch (rLen % 3) {
                    case 2: {
                        b0 = code2nibble[b[bi++]];
                        b1 = code2nibble[b[bi++]];
                        b2 = code2nibble[b[bi++]];
                        if (b0 < 0 || b1 < 0 || b2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        r[ri++] = (byte)(b0 << 2 | b1 >>> 4);
                        r[ri++] = (byte)(b1 << 4 | b2 >>> 2);
                        break;
                    }
                    case 1: {
                        b0 = code2nibble[b[bi++]];
                        b1 = code2nibble[b[bi++]];
                        if (b0 < 0 || b1 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        r[ri++] = (byte)(b0 << 2 | b1 >>> 4);
                        break;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("char " + bi + " was not B64 encoded");
        }
        return r;
    }

    static {
        code2nibble = new byte[256];
        for (int i = 0; i < 256; ++i) {
            B64Code.code2nibble[i] = -1;
        }
        for (int b = 0; b < 64; b = (int)((byte)(b + 1))) {
            B64Code.code2nibble[(byte)B64Code.nibble2code[b]] = b;
        }
        B64Code.code2nibble[61] = 0;
    }
}

