/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetAvro;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

class ParquetReadSupport<T>
extends ReadSupport<T> {
    private final Schema expectedSchema;
    private final ReadSupport<T> wrapped;
    private final boolean callInit;
    private final NameMapping nameMapping;

    ParquetReadSupport(Schema expectedSchema, ReadSupport<T> readSupport, boolean callInit, NameMapping nameMapping) {
        this.expectedSchema = expectedSchema;
        this.wrapped = readSupport;
        this.callInit = callInit;
        this.nameMapping = nameMapping;
    }

    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        MessageType projection;
        if (ParquetSchemaUtil.hasIds(fileSchema)) {
            projection = ParquetSchemaUtil.pruneColumns(fileSchema, this.expectedSchema);
        } else if (this.nameMapping != null) {
            MessageType typeWithIds = ParquetSchemaUtil.applyNameMapping(fileSchema, this.nameMapping);
            projection = ParquetSchemaUtil.pruneColumns(typeWithIds, this.expectedSchema);
        } else {
            projection = ParquetSchemaUtil.pruneColumnsFallback(fileSchema, this.expectedSchema);
        }
        configuration.set("parquet.strict.typing", "false");
        configuration.set("parquet.avro.add-list-element-records", "false");
        configuration.set("parquet.avro.write-old-list-structure", "false");
        AvroReadSupport.setRequestedProjection(configuration, AvroSchemaUtil.convert(this.expectedSchema, projection.getName()));
        org.apache.avro.Schema avroReadSchema = AvroSchemaUtil.buildAvroProjection(AvroSchemaUtil.convert(ParquetSchemaUtil.convert(projection), projection.getName()), this.expectedSchema, ImmutableMap.of());
        AvroReadSupport.setAvroReadSchema(configuration, ParquetAvro.parquetAvroSchema(avroReadSchema));
        ReadSupport.ReadContext context = null;
        if (this.callInit) {
            try {
                context = this.wrapped.init(configuration, keyValueMetaData, projection);
            }
            catch (UnsupportedOperationException e) {
                context = this.wrapped.init(new InitContext(configuration, this.makeMultimap(keyValueMetaData), projection));
            }
        }
        return new ReadSupport.ReadContext(projection, context != null ? context.getReadSupportMetadata() : ImmutableMap.of());
    }

    @Override
    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> fileMetadata, MessageType fileMessageType, ReadSupport.ReadContext readContext) {
        MessageType readSchema = ParquetSchemaUtil.convert(this.expectedSchema, fileMessageType.getName());
        return this.wrapped.prepareForRead(configuration, fileMetadata, readSchema, readContext);
    }

    private Map<String, Set<String>> makeMultimap(Map<String, String> map) {
        ImmutableMap.Builder<String, HashSet<String>> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.put(entry.getKey(), Sets.newHashSet(entry.getValue()));
        }
        return builder.build();
    }
}

