/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.CharSequenceSet;

public class WriteResult
implements Serializable {
    private DataFile[] dataFiles;
    private DeleteFile[] deleteFiles;
    private CharSequence[] referencedDataFiles;

    private WriteResult(List<DataFile> dataFiles, List<DeleteFile> deleteFiles, CharSequenceSet referencedDataFiles) {
        this.dataFiles = dataFiles.toArray(new DataFile[0]);
        this.deleteFiles = deleteFiles.toArray(new DeleteFile[0]);
        this.referencedDataFiles = referencedDataFiles.toArray(new CharSequence[0]);
    }

    public DataFile[] dataFiles() {
        return this.dataFiles;
    }

    public DeleteFile[] deleteFiles() {
        return this.deleteFiles;
    }

    public CharSequence[] referencedDataFiles() {
        return this.referencedDataFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<DataFile> dataFiles = Lists.newArrayList();
        private final List<DeleteFile> deleteFiles = Lists.newArrayList();
        private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();

        private Builder() {
        }

        public Builder add(WriteResult result) {
            this.addDataFiles(result.dataFiles);
            this.addDeleteFiles(result.deleteFiles);
            this.addReferencedDataFiles(result.referencedDataFiles);
            return this;
        }

        public Builder addAll(Iterable<WriteResult> results) {
            results.forEach(this::add);
            return this;
        }

        public Builder addDataFiles(DataFile ... files) {
            Collections.addAll(this.dataFiles, files);
            return this;
        }

        public Builder addDataFiles(Iterable<DataFile> files) {
            Iterables.addAll(this.dataFiles, files);
            return this;
        }

        public Builder addDeleteFiles(DeleteFile ... files) {
            Collections.addAll(this.deleteFiles, files);
            return this;
        }

        public Builder addDeleteFiles(Iterable<DeleteFile> files) {
            Iterables.addAll(this.deleteFiles, files);
            return this;
        }

        public Builder addReferencedDataFiles(CharSequence ... files) {
            Collections.addAll(this.referencedDataFiles, files);
            return this;
        }

        public Builder addReferencedDataFiles(Iterable<CharSequence> files) {
            Iterables.addAll(this.referencedDataFiles, files);
            return this;
        }

        public WriteResult build() {
            return new WriteResult(this.dataFiles, this.deleteFiles, this.referencedDataFiles);
        }
    }
}

