/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.PositionDeltaWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class BasePositionDeltaWriter<T>
implements PositionDeltaWriter<T> {
    private final PartitioningWriter<T, DataWriteResult> dataWriter;
    private final PartitioningWriter<PositionDelete<T>, DeleteWriteResult> deleteWriter;
    private final PositionDelete<T> positionDelete;
    private boolean closed;

    public BasePositionDeltaWriter(PartitioningWriter<T, DataWriteResult> dataWriter, PartitioningWriter<PositionDelete<T>, DeleteWriteResult> deleteWriter) {
        Preconditions.checkArgument(dataWriter != null, "Data writer cannot be null");
        Preconditions.checkArgument(deleteWriter != null, "Delete writer cannot be null");
        this.dataWriter = dataWriter;
        this.deleteWriter = deleteWriter;
        this.positionDelete = PositionDelete.create();
    }

    @Override
    public void insert(T row, PartitionSpec spec, StructLike partition) {
        this.dataWriter.write(row, spec, partition);
    }

    @Override
    public void delete(CharSequence path, long pos, T row, PartitionSpec spec, StructLike partition) {
        this.positionDelete.set(path, pos, row);
        this.deleteWriter.write(this.positionDelete, spec, partition);
    }

    @Override
    public WriteResult result() {
        Preconditions.checkState(this.closed, "Cannot get result from unclosed writer");
        DataWriteResult dataWriteResult = this.dataWriter.result();
        DeleteWriteResult deleteWriteResult = this.deleteWriter.result();
        return WriteResult.builder().addDataFiles(dataWriteResult.dataFiles()).addDeleteFiles(deleteWriteResult.deleteFiles()).addReferencedDataFiles(deleteWriteResult.referencedDataFiles()).build();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.dataWriter.close();
            this.deleteWriter.close();
            this.closed = true;
        }
    }
}

