/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public abstract class BaseParquetReaders<T> {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    protected BaseParquetReaders() {
    }

    protected ParquetValueReader<T> createReader(Schema expectedSchema, MessageType fileSchema) {
        return this.createReader(expectedSchema, fileSchema, ImmutableMap.of());
    }

    protected ParquetValueReader<T> createReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        if (ParquetSchemaUtil.hasIds(fileSchema)) {
            return (ParquetValueReader)TypeWithSchemaVisitor.visit(expectedSchema.asStruct(), fileSchema, new ReadBuilder(fileSchema, idToConstant));
        }
        return (ParquetValueReader)TypeWithSchemaVisitor.visit(expectedSchema.asStruct(), fileSchema, new FallbackReadBuilder(fileSchema, idToConstant));
    }

    protected abstract ParquetValueReader<T> createStructReader(List<Type> var1, List<ParquetValueReader<?>> var2, Types.StructType var3);

    private static class FixedReader
    extends ParquetValueReaders.PrimitiveReader<byte[]> {
        private FixedReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public byte[] read(byte[] reuse) {
            if (reuse != null) {
                this.column.nextBinary().toByteBuffer().duplicate().get(reuse);
                return reuse;
            }
            return this.column.nextBinary().getBytes();
        }
    }

    private static class TimeReader
    extends ParquetValueReaders.PrimitiveReader<LocalTime> {
        private TimeReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalTime read(LocalTime reuse) {
            return LocalTime.ofNanoOfDay(this.column.nextLong() * 1000L);
        }
    }

    private static class TimeMillisReader
    extends ParquetValueReaders.PrimitiveReader<LocalTime> {
        private TimeMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalTime read(LocalTime reuse) {
            return LocalTime.ofNanoOfDay(this.column.nextLong() * 1000000L);
        }
    }

    private static class TimestamptzMillisReader
    extends ParquetValueReaders.PrimitiveReader<OffsetDateTime> {
        private TimestamptzMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public OffsetDateTime read(OffsetDateTime reuse) {
            return EPOCH.plus(this.column.nextLong() * 1000L, ChronoUnit.MICROS);
        }
    }

    private static class TimestamptzReader
    extends ParquetValueReaders.PrimitiveReader<OffsetDateTime> {
        private TimestamptzReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public OffsetDateTime read(OffsetDateTime reuse) {
            return EPOCH.plus(this.column.nextLong(), ChronoUnit.MICROS);
        }
    }

    private static class TimestampInt96Reader
    extends ParquetValueReaders.PrimitiveReader<OffsetDateTime> {
        private static final long UNIX_EPOCH_JULIAN = 2440588L;

        private TimestampInt96Reader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public OffsetDateTime read(OffsetDateTime reuse) {
            ByteBuffer byteBuffer = this.column.nextBinary().toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = byteBuffer.getLong();
            int julianDay = byteBuffer.getInt();
            return Instant.ofEpochMilli(TimeUnit.DAYS.toMillis((long)julianDay - 2440588L)).plusNanos(timeOfDayNanos).atOffset(ZoneOffset.UTC);
        }
    }

    private static class TimestampMillisReader
    extends ParquetValueReaders.PrimitiveReader<LocalDateTime> {
        private TimestampMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalDateTime read(LocalDateTime reuse) {
            return EPOCH.plus(this.column.nextLong() * 1000L, ChronoUnit.MICROS).toLocalDateTime();
        }
    }

    private static class TimestampReader
    extends ParquetValueReaders.PrimitiveReader<LocalDateTime> {
        private TimestampReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalDateTime read(LocalDateTime reuse) {
            return EPOCH.plus(this.column.nextLong(), ChronoUnit.MICROS).toLocalDateTime();
        }
    }

    private static class DateReader
    extends ParquetValueReaders.PrimitiveReader<LocalDate> {
        private DateReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalDate read(LocalDate reuse) {
            return EPOCH_DAY.plusDays(this.column.nextInteger());
        }
    }

    private class ReadBuilder
    extends TypeWithSchemaVisitor<ParquetValueReader<?>> {
        private final MessageType type;
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            this.type = type;
            this.idToConstant = idToConstant;
        }

        @Override
        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return this.struct(expected, message.asGroupType(), (List)fieldReaders);
        }

        @Override
        public ParquetValueReader<?> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            HashMap<Integer, ParquetValueReader<?>> readersById = Maps.newHashMap();
            HashMap<Integer, Type> typesById = Maps.newHashMap();
            List<Type> fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                ParquetValueReader<?> fieldReader = fieldReaders.get(i);
                if (fieldReader == null) continue;
                Type fieldType = fields.get(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                int n = fieldType.getId().intValue();
                readersById.put(n, ParquetValueReaders.option(fieldType, fieldD, fieldReader));
                typesById.put(n, fieldType);
            }
            List<Object> expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList<ParquetValueReader<?>> reorderedFields = Lists.newArrayListWithExpectedSize(expectedFields.size());
            ArrayList<Type> types = Lists.newArrayListWithExpectedSize(expectedFields.size());
            for (Types.NestedField nestedField : expectedFields) {
                int id = nestedField.fieldId();
                if (this.idToConstant.containsKey(id)) {
                    reorderedFields.add(ParquetValueReaders.constant(this.idToConstant.get(id)));
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.ROW_POSITION.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.position());
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.IS_DELETED.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.constant(false));
                    types.add(null);
                    continue;
                }
                ParquetValueReader reader = (ParquetValueReader)readersById.get(id);
                if (reader != null) {
                    reorderedFields.add(reader);
                    types.add((Type)typesById.get(id));
                    continue;
                }
                reorderedFields.add(ParquetValueReaders.nulls());
                types.add(null);
            }
            return BaseParquetReaders.this.createStructReader(types, reorderedFields, expected);
        }

        @Override
        public ParquetValueReader<?> list(Types.ListType expectedList, GroupType array, ParquetValueReader<?> elementReader) {
            if (expectedList == null) {
                return null;
            }
            GroupType repeated = array.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName())) - 1;
            return new ParquetValueReaders.ListReader(repeatedD, repeatedR, ParquetValueReaders.option(elementType, elementD, elementReader));
        }

        @Override
        public ParquetValueReader<?> map(Types.MapType expectedMap, GroupType map, ParquetValueReader<?> keyReader, ParquetValueReader<?> valueReader) {
            if (expectedMap == null) {
                return null;
            }
            GroupType repeatedKeyValue = map.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName())) - 1;
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName())) - 1;
            return new ParquetValueReaders.MapReader(repeatedD, repeatedR, ParquetValueReaders.option(keyType, keyD, keyReader), ParquetValueReaders.option(valueType, valueD, valueReader));
        }

        @Override
        public ParquetValueReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            if (expected == null) {
                return null;
            }
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return new ParquetValueReaders.StringReader(desc);
                    }
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        if (expected.typeId() == Type.TypeID.LONG) {
                            return new ParquetValueReaders.IntAsLongReader(desc);
                        }
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case INT_64: {
                        return new ParquetValueReaders.UnboxedReader(desc);
                    }
                    case DATE: {
                        return new DateReader(desc);
                    }
                    case TIMESTAMP_MICROS: {
                        Types.TimestampType tsMicrosType = (Types.TimestampType)expected;
                        if (tsMicrosType.shouldAdjustToUTC()) {
                            return new TimestamptzReader(desc);
                        }
                        return new TimestampReader(desc);
                    }
                    case TIMESTAMP_MILLIS: {
                        Types.TimestampType tsMillisType = (Types.TimestampType)expected;
                        if (tsMillisType.shouldAdjustToUTC()) {
                            return new TimestamptzMillisReader(desc);
                        }
                        return new TimestampMillisReader(desc);
                    }
                    case TIME_MICROS: {
                        return new TimeReader(desc);
                    }
                    case TIME_MILLIS: {
                        return new TimeMillisReader(desc);
                    }
                    case DECIMAL: {
                        DecimalMetadata decimal = primitive.getDecimalMetadata();
                        switch (primitive.getPrimitiveTypeName()) {
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return new ParquetValueReaders.BinaryAsDecimalReader(desc, decimal.getScale());
                            }
                            case INT64: {
                                return new ParquetValueReaders.LongAsDecimalReader(desc, decimal.getScale());
                            }
                            case INT32: {
                                return new ParquetValueReaders.IntegerAsDecimalReader(desc, decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + (Object)((Object)primitive.getPrimitiveTypeName()));
                    }
                    case BSON: {
                        return new ParquetValueReaders.BytesReader(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + (Object)((Object)primitive.getOriginalType()));
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedReader(desc);
                }
                case BINARY: {
                    return new ParquetValueReaders.BytesReader(desc);
                }
                case INT32: {
                    if (expected != null && expected.typeId() == Type.TypeID.LONG) {
                        return new ParquetValueReaders.IntAsLongReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case FLOAT: {
                    if (expected != null && expected.typeId() == Type.TypeID.DOUBLE) {
                        return new ParquetValueReaders.FloatAsDoubleReader(desc);
                    }
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT64: 
                case BOOLEAN: 
                case DOUBLE: {
                    return new ParquetValueReaders.UnboxedReader(desc);
                }
                case INT96: {
                    return new TimestampInt96Reader(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }

        MessageType type() {
            return this.type;
        }
    }

    private class FallbackReadBuilder
    extends ReadBuilder {
        private FallbackReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            super(type, idToConstant);
        }

        @Override
        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return super.struct(expected, (GroupType)message, (List)fieldReaders);
        }

        @Override
        public ParquetValueReader<?> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            ArrayList<ParquetValueReader<?>> newFields = Lists.newArrayListWithExpectedSize(fieldReaders.size());
            ArrayList<Type> types = Lists.newArrayListWithExpectedSize(fieldReaders.size());
            List<Type> fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                ParquetValueReader<?> fieldReader = fieldReaders.get(i);
                if (fieldReader == null) continue;
                Type fieldType = fields.get(i);
                int fieldD = this.type().getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                newFields.add(ParquetValueReaders.option(fieldType, fieldD, fieldReader));
                types.add(fieldType);
            }
            return BaseParquetReaders.this.createStructReader(types, newFields, expected);
        }
    }
}

