/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.io.DatumReader;
import org.apache.iceberg.avro.AvroIO;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class AvroIterable<D>
extends CloseableGroup
implements CloseableIterable<D> {
    private final InputFile file;
    private final DatumReader<D> reader;
    private final Long start;
    private final Long end;
    private final boolean reuseContainers;
    private Map<String, String> metadata = null;

    AvroIterable(InputFile file, DatumReader<D> reader, Long start, Long length, boolean reuseContainers) {
        this.file = file;
        this.reader = reader;
        this.start = start;
        this.end = start != null ? Long.valueOf(start + length) : null;
        this.reuseContainers = reuseContainers;
    }

    private DataFileReader<D> initMetadata(DataFileReader<D> metadataReader) {
        if (this.metadata == null) {
            this.metadata = Maps.newHashMap();
            for (String key : metadataReader.getMetaKeys()) {
                this.metadata.put(key, metadataReader.getMetaString(key));
            }
        }
        return metadataReader;
    }

    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            try (DataFileReader<D> reader = this.newFileReader();){
                this.initMetadata(reader);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read metadata for file: %s", this.file);
            }
        }
        return this.metadata;
    }

    @Override
    public CloseableIterator<D> iterator() {
        FileReader<D> fileReader = this.initMetadata(this.newFileReader());
        if (this.start != null) {
            if (this.reader instanceof SupportsRowPosition) {
                ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(() -> AvroIO.findStartingRowPos(this.file::newStream, this.start));
            }
            fileReader = new AvroRangeIterator<D>(fileReader, this.start, this.end);
        } else if (this.reader instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.reader)).setRowPositionSupplier(() -> 0L);
        }
        this.addCloseable(fileReader);
        if (this.reuseContainers) {
            return new AvroReuseIterator<D>(fileReader);
        }
        return CloseableIterator.withClose(fileReader);
    }

    private DataFileReader<D> newFileReader() {
        try {
            return (DataFileReader)DataFileReader.openReader(AvroIO.stream(this.file.newStream(), this.file.getLength()), this.reader);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to open file: %s", this.file);
        }
    }

    private static class AvroReuseIterator<D>
    implements CloseableIterator<D> {
        private final FileReader<D> reader;
        private D reused = null;

        AvroReuseIterator(FileReader<D> reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            return this.reader.hasNext();
        }

        @Override
        public D next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                this.reused = this.reader.next(this.reused);
                return this.reused;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read next record", new Object[0]);
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class AvroRangeIterator<D>
    implements FileReader<D> {
        private final FileReader<D> reader;
        private final long end;

        AvroRangeIterator(FileReader<D> reader, long start, long end) {
            this.reader = reader;
            this.end = end;
            try {
                reader.sync(start);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to find sync past position %d", start);
            }
        }

        @Override
        public Schema getSchema() {
            return this.reader.getSchema();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext() && !this.reader.pastSync(this.end);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to check range end: %d", this.end);
            }
        }

        @Override
        public D next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (D)this.reader.next();
        }

        @Override
        public D next(D reuse) {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.reader.next(reuse);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read next record", new Object[0]);
            }
        }

        @Override
        public void sync(long position) throws IOException {
            this.reader.sync(position);
        }

        @Override
        public boolean pastSync(long position) throws IOException {
            return this.reader.pastSync(position);
        }

        @Override
        public long tell() throws IOException {
            return this.reader.tell();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public Iterator<D> iterator() {
            return this;
        }
    }
}

