/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class MergeAppend
extends MergingSnapshotProducer<AppendFiles>
implements AppendFiles {
    MergeAppend(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected AppendFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "append";
    }

    @Override
    public MergeAppend appendFile(DataFile file) {
        this.add(file);
        return this;
    }

    @Override
    public AppendFiles appendManifest(ManifestFile manifest) {
        Preconditions.checkArgument(!manifest.hasExistingFiles(), "Cannot append manifest with existing files");
        Preconditions.checkArgument(!manifest.hasDeletedFiles(), "Cannot append manifest with deleted files");
        Preconditions.checkArgument(manifest.snapshotId() == null || manifest.snapshotId() == -1L, "Snapshot id must be assigned during commit");
        Preconditions.checkArgument(manifest.sequenceNumber() == -1L, "Sequence must be assigned during commit");
        this.add(manifest);
        return this;
    }
}

