/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.curator.framework.recipes.shared.VersionedValue;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.utils.EnsurePath;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ZKDelegationTokenSecretManager<TokenIdent extends AbstractDelegationTokenIdentifier>
extends AbstractDelegationTokenSecretManager<TokenIdent> {
    private static final String ZK_CONF_PREFIX = "zk-dt-secret-manager.";
    public static final String ZK_DTSM_ZK_NUM_RETRIES = "zk-dt-secret-manager.zkNumRetries";
    public static final String ZK_DTSM_ZK_SESSION_TIMEOUT = "zk-dt-secret-manager.zkSessionTimeout";
    public static final String ZK_DTSM_ZK_CONNECTION_TIMEOUT = "zk-dt-secret-manager.zkConnectionTimeout";
    public static final String ZK_DTSM_ZK_SHUTDOWN_TIMEOUT = "zk-dt-secret-manager.zkShutdownTimeout";
    public static final String ZK_DTSM_ZNODE_WORKING_PATH = "zk-dt-secret-manager.znodeWorkingPath";
    public static final String ZK_DTSM_ZK_AUTH_TYPE = "zk-dt-secret-manager.zkAuthType";
    public static final String ZK_DTSM_ZK_CONNECTION_STRING = "zk-dt-secret-manager.zkConnectionString";
    public static final String ZK_DTSM_ZK_KERBEROS_KEYTAB = "zk-dt-secret-manager.kerberos.keytab";
    public static final String ZK_DTSM_ZK_KERBEROS_PRINCIPAL = "zk-dt-secret-manager.kerberos.principal";
    public static final int ZK_DTSM_ZK_NUM_RETRIES_DEFAULT = 3;
    public static final int ZK_DTSM_ZK_SESSION_TIMEOUT_DEFAULT = 10000;
    public static final int ZK_DTSM_ZK_CONNECTION_TIMEOUT_DEFAULT = 10000;
    public static final int ZK_DTSM_ZK_SHUTDOWN_TIMEOUT_DEFAULT = 10000;
    public static final String ZK_DTSM_ZNODE_WORKING_PATH_DEAFULT = "zkdtsm";
    private static Logger LOG = LoggerFactory.getLogger(ZKDelegationTokenSecretManager.class);
    private static final String JAAS_LOGIN_ENTRY_NAME = "ZKDelegationTokenSecretManagerClient";
    private static final String ZK_DTSM_NAMESPACE = "ZKDTSMRoot";
    private static final String ZK_DTSM_SEQNUM_ROOT = "/ZKDTSMSeqNumRoot";
    private static final String ZK_DTSM_KEYID_ROOT = "/ZKDTSMKeyIdRoot";
    private static final String ZK_DTSM_TOKENS_ROOT = "/ZKDTSMTokensRoot";
    private static final String ZK_DTSM_MASTER_KEY_ROOT = "/ZKDTSMMasterKeyRoot";
    private static final String DELEGATION_KEY_PREFIX = "DK_";
    private static final String DELEGATION_TOKEN_PREFIX = "DT_";
    private static final ThreadLocal<CuratorFramework> CURATOR_TL = new ThreadLocal();
    private final boolean isExternalClient;
    private final CuratorFramework zkClient;
    private SharedCount delTokSeqCounter;
    private SharedCount keyIdSeqCounter;
    private PathChildrenCache keyCache;
    private PathChildrenCache tokenCache;
    private ExecutorService listenerThreadPool;
    private final long shutdownTimeout;

    public static void setCurator(CuratorFramework curator) {
        CURATOR_TL.set(curator);
    }

    public ZKDelegationTokenSecretManager(Configuration conf) {
        super(conf.getLong("delegation-token.update-interval.sec", 86400L) * 1000L, conf.getLong("delegation-token.max-lifetime.sec", 604800L) * 1000L, conf.getLong("delegation-token.renew-interval.sec", 86400L) * 1000L, conf.getLong("delegation-token.removal-scan-interval.sec", 3600L) * 1000L);
        this.shutdownTimeout = conf.getLong(ZK_DTSM_ZK_SHUTDOWN_TIMEOUT, 10000L);
        if (CURATOR_TL.get() != null) {
            this.zkClient = CURATOR_TL.get().usingNamespace(conf.get(ZK_DTSM_ZNODE_WORKING_PATH, ZK_DTSM_ZNODE_WORKING_PATH_DEAFULT) + "/" + ZK_DTSM_NAMESPACE);
            this.isExternalClient = true;
        } else {
            String connString = conf.get(ZK_DTSM_ZK_CONNECTION_STRING);
            Preconditions.checkNotNull(connString, "Zookeeper connection string cannot be null");
            String authType = conf.get(ZK_DTSM_ZK_AUTH_TYPE);
            Preconditions.checkNotNull(authType, "Zookeeper authType cannot be null !!");
            Preconditions.checkArgument(authType.equals("sasl") || authType.equals("none"), "Zookeeper authType must be one of [none, sasl]");
            CuratorFrameworkFactory.Builder builder = null;
            try {
                ACLProvider aclProvider = null;
                if (authType.equals("sasl")) {
                    LOG.info("Connecting to ZooKeeper with SASL/Kerberosand using 'sasl' ACLs");
                    String principal = this.setJaasConfiguration(conf);
                    System.setProperty("zookeeper.sasl.clientconfig", JAAS_LOGIN_ENTRY_NAME);
                    System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
                    aclProvider = new SASLOwnerACLProvider(principal);
                } else {
                    LOG.info("Connecting to ZooKeeper without authentication");
                    aclProvider = new DefaultACLProvider();
                }
                int sessionT = conf.getInt(ZK_DTSM_ZK_SESSION_TIMEOUT, 10000);
                int numRetries = conf.getInt(ZK_DTSM_ZK_NUM_RETRIES, 3);
                builder = CuratorFrameworkFactory.builder().aclProvider(aclProvider).namespace(conf.get(ZK_DTSM_ZNODE_WORKING_PATH, ZK_DTSM_ZNODE_WORKING_PATH_DEAFULT) + "/" + ZK_DTSM_NAMESPACE).sessionTimeoutMs(sessionT).connectionTimeoutMs(conf.getInt(ZK_DTSM_ZK_CONNECTION_TIMEOUT, 10000)).retryPolicy(new RetryNTimes(numRetries, sessionT / numRetries));
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not Load ZK acls or auth");
            }
            this.zkClient = builder.ensembleProvider(new FixedEnsembleProvider(connString)).build();
            this.isExternalClient = false;
        }
    }

    private String setJaasConfiguration(Configuration config) throws Exception {
        String keytabFile = config.get(ZK_DTSM_ZK_KERBEROS_KEYTAB, "").trim();
        if (keytabFile == null || keytabFile.length() == 0) {
            throw new IllegalArgumentException("zk-dt-secret-manager.kerberos.keytab must be specified");
        }
        String principal = config.get(ZK_DTSM_ZK_KERBEROS_PRINCIPAL, "").trim();
        if (principal == null || principal.length() == 0) {
            throw new IllegalArgumentException("zk-dt-secret-manager.kerberos.principal must be specified");
        }
        JaasConfiguration jConf = new JaasConfiguration(JAAS_LOGIN_ENTRY_NAME, principal, keytabFile);
        javax.security.auth.login.Configuration.setConfiguration(jConf);
        return principal.split("[/@]")[0];
    }

    @Override
    public void startThreads() throws IOException {
        if (!this.isExternalClient) {
            try {
                this.zkClient.start();
            }
            catch (Exception e) {
                throw new IOException("Could not start Curator Framework", e);
            }
        }
        CuratorFramework nullNsFw = this.zkClient.usingNamespace(null);
        EnsurePath ensureNs = nullNsFw.newNamespaceAwareEnsurePath("/" + this.zkClient.getNamespace());
        try {
            ensureNs.ensure(nullNsFw.getZookeeperClient());
        }
        catch (Exception e) {
            throw new IOException("Could not create namespace", e);
        }
        this.listenerThreadPool = Executors.newSingleThreadExecutor();
        try {
            this.delTokSeqCounter = new SharedCount(this.zkClient, ZK_DTSM_SEQNUM_ROOT, 0);
            if (this.delTokSeqCounter != null) {
                this.delTokSeqCounter.start();
            }
        }
        catch (Exception e) {
            throw new IOException("Could not start Sequence Counter", e);
        }
        try {
            this.keyIdSeqCounter = new SharedCount(this.zkClient, ZK_DTSM_KEYID_ROOT, 0);
            if (this.keyIdSeqCounter != null) {
                this.keyIdSeqCounter.start();
            }
        }
        catch (Exception e) {
            throw new IOException("Could not start KeyId Counter", e);
        }
        try {
            this.createPersistentNode(ZK_DTSM_MASTER_KEY_ROOT);
            this.createPersistentNode(ZK_DTSM_TOKENS_ROOT);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create ZK paths");
        }
        try {
            this.keyCache = new PathChildrenCache(this.zkClient, ZK_DTSM_MASTER_KEY_ROOT, true);
            if (this.keyCache != null) {
                this.keyCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
                this.keyCache.getListenable().addListener(new PathChildrenCacheListener(){

                    @Override
                    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                ZKDelegationTokenSecretManager.this.processKeyAddOrUpdate(event.getData().getData());
                                break;
                            }
                            case CHILD_UPDATED: {
                                ZKDelegationTokenSecretManager.this.processKeyAddOrUpdate(event.getData().getData());
                                break;
                            }
                            case CHILD_REMOVED: {
                                ZKDelegationTokenSecretManager.this.processKeyRemoved(event.getData().getPath());
                                break;
                            }
                        }
                    }
                }, this.listenerThreadPool);
                this.loadFromZKCache(false);
            }
        }
        catch (Exception e) {
            throw new IOException("Could not start PathChildrenCache for keys", e);
        }
        try {
            this.tokenCache = new PathChildrenCache(this.zkClient, ZK_DTSM_TOKENS_ROOT, true);
            if (this.tokenCache != null) {
                this.tokenCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
                this.tokenCache.getListenable().addListener(new PathChildrenCacheListener(){

                    @Override
                    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                ZKDelegationTokenSecretManager.this.processTokenAddOrUpdate(event.getData());
                                break;
                            }
                            case CHILD_UPDATED: {
                                ZKDelegationTokenSecretManager.this.processTokenAddOrUpdate(event.getData());
                                break;
                            }
                            case CHILD_REMOVED: {
                                ZKDelegationTokenSecretManager.this.processTokenRemoved(event.getData());
                                break;
                            }
                        }
                    }
                }, this.listenerThreadPool);
                this.loadFromZKCache(true);
            }
        }
        catch (Exception e) {
            throw new IOException("Could not start PathChildrenCache for tokens", e);
        }
        super.startThreads();
    }

    private void loadFromZKCache(boolean isTokenCache) {
        String cacheName = isTokenCache ? "token" : "key";
        LOG.info("Starting to load {} cache.", (Object)cacheName);
        List<ChildData> children = isTokenCache ? this.tokenCache.getCurrentData() : this.keyCache.getCurrentData();
        int count = 0;
        for (ChildData child : children) {
            try {
                if (isTokenCache) {
                    this.processTokenAddOrUpdate(child);
                    continue;
                }
                this.processKeyAddOrUpdate(child.getData());
            }
            catch (Exception e) {
                LOG.info("Ignoring node {} because it failed to load.", (Object)child.getPath());
                LOG.debug("Failure exception:", e);
                ++count;
            }
        }
        if (count > 0) {
            LOG.warn("Ignored {} nodes while loading {} cache.", (Object)count, (Object)cacheName);
        }
        LOG.info("Loaded {} cache.", (Object)cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKeyAddOrUpdate(byte[] data) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        DelegationKey key = new DelegationKey();
        key.readFields(din);
        ZKDelegationTokenSecretManager zKDelegationTokenSecretManager = this;
        synchronized (zKDelegationTokenSecretManager) {
            this.allKeys.put(key.getKeyId(), key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKeyRemoved(String path) {
        String tokSeg;
        int j;
        int i = path.lastIndexOf(47);
        if (i > 0 && (j = (tokSeg = path.substring(i + 1)).indexOf(95)) > 0) {
            int keyId = Integer.parseInt(tokSeg.substring(j + 1));
            ZKDelegationTokenSecretManager zKDelegationTokenSecretManager = this;
            synchronized (zKDelegationTokenSecretManager) {
                this.allKeys.remove(keyId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTokenAddOrUpdate(ChildData data) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data.getData());
        DataInputStream din = new DataInputStream(bin);
        AbstractDelegationTokenIdentifier ident = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        ident.readFields(din);
        long renewDate = din.readLong();
        int pwdLen = din.readInt();
        byte[] password = new byte[pwdLen];
        int numRead = din.read(password, 0, pwdLen);
        if (numRead > -1) {
            AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = new AbstractDelegationTokenSecretManager.DelegationTokenInformation(renewDate, password);
            ZKDelegationTokenSecretManager zKDelegationTokenSecretManager = this;
            synchronized (zKDelegationTokenSecretManager) {
                this.currentTokens.put(ident, tokenInfo);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTokenRemoved(ChildData data) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data.getData());
        DataInputStream din = new DataInputStream(bin);
        AbstractDelegationTokenIdentifier ident = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        ident.readFields(din);
        ZKDelegationTokenSecretManager zKDelegationTokenSecretManager = this;
        synchronized (zKDelegationTokenSecretManager) {
            this.currentTokens.remove(ident);
            this.notifyAll();
        }
    }

    @Override
    public void stopThreads() {
        super.stopThreads();
        try {
            if (this.tokenCache != null) {
                this.tokenCache.close();
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop Delegation Token Cache", e);
        }
        try {
            if (this.delTokSeqCounter != null) {
                this.delTokSeqCounter.close();
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop Delegation Token Counter", e);
        }
        try {
            if (this.keyIdSeqCounter != null) {
                this.keyIdSeqCounter.close();
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop Key Id Counter", e);
        }
        try {
            if (this.keyCache != null) {
                this.keyCache.close();
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop KeyCache", e);
        }
        try {
            if (!this.isExternalClient && this.zkClient != null) {
                this.zkClient.close();
            }
        }
        catch (Exception e) {
            LOG.error("Could not stop Curator Framework", e);
        }
        if (this.listenerThreadPool != null) {
            this.listenerThreadPool.shutdown();
            try {
                if (!this.listenerThreadPool.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                    LOG.error("Forcing Listener threadPool to shutdown !!");
                    this.listenerThreadPool.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.listenerThreadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void createPersistentNode(String nodePath) throws Exception {
        try {
            ((ACLBackgroundPathAndBytesable)this.zkClient.create().withMode(CreateMode.PERSISTENT)).forPath(nodePath);
        }
        catch (KeeperException.NodeExistsException ne) {
            LOG.debug(nodePath + " znode already exists !!");
        }
        catch (Exception e) {
            throw new IOException(nodePath + " znode could not be created !!", e);
        }
    }

    @Override
    protected int getDelegationTokenSeqNum() {
        return this.delTokSeqCounter.getCount();
    }

    private void incrSharedCount(SharedCount sharedCount) throws Exception {
        VersionedValue<Integer> versionedValue;
        while (!sharedCount.trySetCount(versionedValue = sharedCount.getVersionedValue(), versionedValue.getValue() + 1)) {
        }
    }

    @Override
    protected int incrementDelegationTokenSeqNum() {
        try {
            this.incrSharedCount(this.delTokSeqCounter);
        }
        catch (InterruptedException e) {
            LOG.debug("Thread interrupted while performing token counter increment", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not increment shared counter !!", e);
        }
        return this.delTokSeqCounter.getCount();
    }

    @Override
    protected void setDelegationTokenSeqNum(int seqNum) {
        try {
            this.delTokSeqCounter.setCount(seqNum);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set shared counter !!", e);
        }
    }

    @Override
    protected int getCurrentKeyId() {
        return this.keyIdSeqCounter.getCount();
    }

    @Override
    protected int incrementCurrentKeyId() {
        try {
            this.incrSharedCount(this.keyIdSeqCounter);
        }
        catch (InterruptedException e) {
            LOG.debug("Thread interrupted while performing keyId increment", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not increment shared keyId counter !!", e);
        }
        return this.keyIdSeqCounter.getCount();
    }

    @Override
    protected DelegationKey getDelegationKey(int keyId) {
        DelegationKey key = (DelegationKey)this.allKeys.get(keyId);
        if (key == null) {
            try {
                key = this.getKeyFromZK(keyId);
                if (key != null) {
                    this.allKeys.put(keyId, key);
                }
            }
            catch (IOException e) {
                LOG.error("Error retrieving key [" + keyId + "] from ZK", e);
            }
        }
        return key;
    }

    private DelegationKey getKeyFromZK(int keyId) throws IOException {
        String nodePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_MASTER_KEY_ROOT, DELEGATION_KEY_PREFIX + keyId);
        try {
            byte[] data = (byte[])this.zkClient.getData().forPath(nodePath);
            if (data == null || data.length == 0) {
                return null;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            DelegationKey key = new DelegationKey();
            key.readFields(din);
            return key;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.error("No node in path [" + nodePath + "]");
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return null;
    }

    @Override
    protected AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfo(TokenIdent ident) {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(ident);
        if (tokenInfo == null) {
            try {
                tokenInfo = this.getTokenInfoFromZK(ident);
                if (tokenInfo != null) {
                    this.currentTokens.put(ident, tokenInfo);
                }
            }
            catch (IOException e) {
                LOG.error("Error retrieving tokenInfo [" + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber() + "] from ZK", e);
            }
        }
        return tokenInfo;
    }

    private synchronized void syncLocalCacheWithZk(TokenIdent ident) {
        try {
            AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = this.getTokenInfoFromZK(ident);
            if (tokenInfo != null && !this.currentTokens.containsKey(ident)) {
                this.currentTokens.put(ident, tokenInfo);
            } else if (tokenInfo == null && this.currentTokens.containsKey(ident)) {
                this.currentTokens.remove(ident);
            }
        }
        catch (IOException e) {
            LOG.error("Error retrieving tokenInfo [" + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber() + "] from ZK", e);
        }
    }

    private AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfoFromZK(TokenIdent ident) throws IOException {
        return this.getTokenInfoFromZK(ident, false);
    }

    private AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfoFromZK(TokenIdent ident, boolean quiet) throws IOException {
        String nodePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_TOKENS_ROOT, DELEGATION_TOKEN_PREFIX + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber());
        try {
            byte[] data = (byte[])this.zkClient.getData().forPath(nodePath);
            if (data == null || data.length == 0) {
                return null;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            ((AbstractDelegationTokenIdentifier)this.createIdentifier()).readFields(din);
            long renewDate = din.readLong();
            int pwdLen = din.readInt();
            byte[] password = new byte[pwdLen];
            int numRead = din.read(password, 0, pwdLen);
            if (numRead > -1) {
                AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = new AbstractDelegationTokenSecretManager.DelegationTokenInformation(renewDate, password);
                return tokenInfo;
            }
        }
        catch (KeeperException.NoNodeException e) {
            if (!quiet) {
                LOG.error("No node in path [" + nodePath + "]");
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return null;
    }

    @Override
    protected void storeDelegationKey(DelegationKey key) throws IOException {
        this.addOrUpdateDelegationKey(key, false);
    }

    @Override
    protected void updateDelegationKey(DelegationKey key) throws IOException {
        this.addOrUpdateDelegationKey(key, true);
    }

    private void addOrUpdateDelegationKey(DelegationKey key, boolean isUpdate) throws IOException {
        String nodeCreatePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_MASTER_KEY_ROOT, DELEGATION_KEY_PREFIX + key.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing ZKDTSMDelegationKey_" + key.getKeyId());
        }
        key.write(fsOut);
        try {
            if (this.zkClient.checkExists().forPath(nodeCreatePath) != null) {
                ((Stat)this.zkClient.setData().forPath(nodeCreatePath, os.toByteArray())).setVersion(-1);
                if (!isUpdate) {
                    LOG.debug("Key with path [" + nodeCreatePath + "] already exists.. Updating !!");
                }
            } else {
                ((ACLBackgroundPathAndBytesable)this.zkClient.create().withMode(CreateMode.PERSISTENT)).forPath(nodeCreatePath, os.toByteArray());
                if (isUpdate) {
                    LOG.debug("Updating non existent Key path [" + nodeCreatePath + "].. Adding new !!");
                }
            }
        }
        catch (KeeperException.NodeExistsException ne) {
            LOG.debug(nodeCreatePath + " znode already exists !!");
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            os.close();
        }
    }

    @Override
    protected void removeStoredMasterKey(DelegationKey key) {
        String nodeRemovePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_MASTER_KEY_ROOT, DELEGATION_KEY_PREFIX + key.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing ZKDTSMDelegationKey_" + key.getKeyId());
        }
        try {
            if (this.zkClient.checkExists().forPath(nodeRemovePath) != null) {
                while (this.zkClient.checkExists().forPath(nodeRemovePath) != null) {
                    try {
                        this.zkClient.delete().guaranteed().forPath(nodeRemovePath);
                    }
                    catch (KeeperException.NoNodeException nne) {
                        LOG.debug("Node already deleted by peer " + nodeRemovePath);
                    }
                }
            } else {
                LOG.debug("Attempted to delete a non-existing znode " + nodeRemovePath);
            }
        }
        catch (Exception e) {
            LOG.debug(nodeRemovePath + " znode could not be removed!!");
        }
    }

    @Override
    protected void storeToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        try {
            this.addOrUpdateToken(ident, tokenInfo, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void updateToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
        String nodeRemovePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_TOKENS_ROOT, DELEGATION_TOKEN_PREFIX + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber());
        try {
            if (this.zkClient.checkExists().forPath(nodeRemovePath) != null) {
                this.addOrUpdateToken(ident, tokenInfo, true);
            } else {
                this.addOrUpdateToken(ident, tokenInfo, false);
                LOG.debug("Attempted to update a non-existing znode " + nodeRemovePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not update Stored Token ZKDTSMDelegationToken_" + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), e);
        }
    }

    @Override
    protected void removeStoredToken(TokenIdent ident) throws IOException {
        String nodeRemovePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_TOKENS_ROOT, DELEGATION_TOKEN_PREFIX + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing ZKDTSMDelegationToken_" + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber());
        }
        try {
            if (this.zkClient.checkExists().forPath(nodeRemovePath) != null) {
                while (this.zkClient.checkExists().forPath(nodeRemovePath) != null) {
                    try {
                        this.zkClient.delete().guaranteed().forPath(nodeRemovePath);
                    }
                    catch (KeeperException.NoNodeException nne) {
                        LOG.debug("Node already deleted by peer " + nodeRemovePath);
                    }
                }
            } else {
                LOG.debug("Attempted to remove a non-existing znode " + nodeRemovePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not remove Stored Token ZKDTSMDelegationToken_" + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber(), e);
        }
    }

    @Override
    public synchronized TokenIdent cancelToken(Token<TokenIdent> token, String canceller) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        id.readFields(in);
        this.syncLocalCacheWithZk(id);
        return super.cancelToken(token, canceller);
    }

    private void addOrUpdateToken(TokenIdent ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation info, boolean isUpdate) throws Exception {
        String nodeCreatePath = ZKDelegationTokenSecretManager.getNodePath(ZK_DTSM_TOKENS_ROOT, DELEGATION_TOKEN_PREFIX + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber());
        try (ByteArrayOutputStream tokenOs = new ByteArrayOutputStream();
             DataOutputStream tokenOut = new DataOutputStream(tokenOs);){
            ((AbstractDelegationTokenIdentifier)ident).write(tokenOut);
            tokenOut.writeLong(info.getRenewDate());
            tokenOut.writeInt(info.getPassword().length);
            tokenOut.write(info.getPassword());
            if (LOG.isDebugEnabled()) {
                LOG.debug((isUpdate ? "Updating " : "Storing ") + "ZKDTSMDelegationToken_" + ((AbstractDelegationTokenIdentifier)ident).getSequenceNumber());
            }
            if (isUpdate) {
                ((Stat)this.zkClient.setData().forPath(nodeCreatePath, tokenOs.toByteArray())).setVersion(-1);
            } else {
                ((ACLBackgroundPathAndBytesable)this.zkClient.create().withMode(CreateMode.PERSISTENT)).forPath(nodeCreatePath, tokenOs.toByteArray());
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    static String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    @VisibleForTesting
    public ExecutorService getListenerThreadPool() {
        return this.listenerThreadPool;
    }

    @VisibleForTesting
    AbstractDelegationTokenSecretManager.DelegationTokenInformation getTokenInfoFromMemory(TokenIdent ident) {
        return (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(ident);
    }

    private static class SASLOwnerACLProvider
    implements ACLProvider {
        private final List<ACL> saslACL;

        private SASLOwnerACLProvider(String principal) {
            this.saslACL = Collections.singletonList(new ACL(31, new Id("sasl", principal)));
        }

        @Override
        public List<ACL> getDefaultAcl() {
            return this.saslACL;
        }

        @Override
        public List<ACL> getAclForPath(String path) {
            return this.saslACL;
        }
    }

    @InterfaceAudience.Private
    public static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private final javax.security.auth.login.Configuration baseConfig = javax.security.auth.login.Configuration.getConfiguration();
        private static AppConfigurationEntry[] entry;
        private String entryName;

        public JaasConfiguration(String entryName, String principal, String keytab) {
            this.entryName = entryName;
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("keyTab", keytab);
            options.put("principal", principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("useTicketCache", "false");
            options.put("refreshKrb5Config", "true");
            String jaasEnvVar = System.getenv("HADOOP_JAAS_DEBUG");
            if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
                options.put("debug", "true");
            }
            entry = new AppConfigurationEntry[]{new AppConfigurationEntry(this.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.entryName.equals(name) ? entry : (this.baseConfig != null ? this.baseConfig.getAppConfigurationEntry(name) : null);
        }

        private String getKrb5LoginModuleName() {
            String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
            return krb5LoginModuleName;
        }
    }
}

