/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsPlugin;
import org.apache.hadoop.metrics2.filter.GlobFilter;
import org.apache.hadoop.metrics2.impl.MetricsConfigException;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricsConfig
extends SubsetConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    static final String DEFAULT_FILE_NAME = "hadoop-metrics2.properties";
    static final String PREFIX_DEFAULT = "*.";
    static final String PERIOD_KEY = "period";
    static final int PERIOD_DEFAULT = 10;
    static final String PERIOD_MILLIS_KEY = "periodMillis";
    static final String QUEUE_CAPACITY_KEY = "queue.capacity";
    static final int QUEUE_CAPACITY_DEFAULT = 1;
    static final String RETRY_DELAY_KEY = "retry.delay";
    static final int RETRY_DELAY_DEFAULT = 10;
    static final String RETRY_BACKOFF_KEY = "retry.backoff";
    static final int RETRY_BACKOFF_DEFAULT = 2;
    static final String RETRY_COUNT_KEY = "retry.count";
    static final int RETRY_COUNT_DEFAULT = 1;
    static final String JMX_CACHE_TTL_KEY = "jmx.cache.ttl";
    static final String START_MBEANS_KEY = "source.start_mbeans";
    static final String PLUGIN_URLS_KEY = "plugin.urls";
    static final String CONTEXT_KEY = "context";
    static final String NAME_KEY = "name";
    static final String DESC_KEY = "description";
    static final String SOURCE_KEY = "source";
    static final String SINK_KEY = "sink";
    static final String METRIC_FILTER_KEY = "metric.filter";
    static final String RECORD_FILTER_KEY = "record.filter";
    static final String SOURCE_FILTER_KEY = "source.filter";
    static final Pattern INSTANCE_REGEX = Pattern.compile("([^.*]+)\\..+");
    static final Splitter SPLITTER = Splitter.on(',').trimResults();
    private ClassLoader pluginLoader;

    MetricsConfig(Configuration c, String prefix) {
        super(c, StringUtils.toLowerCase(prefix), ".");
    }

    static MetricsConfig create(String prefix) {
        return MetricsConfig.loadFirst(prefix, "hadoop-metrics2-" + StringUtils.toLowerCase(prefix) + ".properties", DEFAULT_FILE_NAME);
    }

    static MetricsConfig create(String prefix, String ... fileNames) {
        return MetricsConfig.loadFirst(prefix, fileNames);
    }

    static MetricsConfig loadFirst(String prefix, String ... fileNames) {
        for (String fname : fileNames) {
            try {
                Configuration cf = new PropertiesConfiguration(fname).interpolatedConfiguration();
                LOG.info("loaded properties from " + fname);
                LOG.debug(MetricsConfig.toString(cf));
                MetricsConfig mc = new MetricsConfig(cf, prefix);
                LOG.debug(mc.toString());
                return mc;
            }
            catch (ConfigurationException e) {
                if (e.getMessage().startsWith("Cannot locate configuration")) continue;
                throw new MetricsConfigException(e);
            }
        }
        LOG.warn("Cannot locate configuration: tried " + Joiner.on(",").join(fileNames));
        return new MetricsConfig(new PropertiesConfiguration(), prefix);
    }

    @Override
    public MetricsConfig subset(String prefix) {
        return new MetricsConfig(this, prefix);
    }

    Map<String, MetricsConfig> getInstanceConfigs(String type) {
        HashMap<String, MetricsConfig> map = Maps.newHashMap();
        MetricsConfig sub = this.subset(type);
        for (String key : sub.keys()) {
            String instance;
            Matcher matcher = INSTANCE_REGEX.matcher(key);
            if (!matcher.matches() || map.containsKey(instance = matcher.group(1))) continue;
            map.put(instance, sub.subset(instance));
        }
        return map;
    }

    Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return MetricsConfig.this.getKeys();
            }
        };
    }

    @Override
    public Object getProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("poking parent '" + this.getParent().getClass().getSimpleName() + "' for key: " + key);
            }
            return this.getParent().getProperty(key.startsWith(PREFIX_DEFAULT) ? key : PREFIX_DEFAULT + key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("returning '" + value + "' for key: " + key);
        }
        return value;
    }

    <T extends MetricsPlugin> T getPlugin(String name) {
        String clsName = this.getClassName(name);
        if (clsName == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(clsName, true, this.getPluginLoader());
            MetricsPlugin plugin = (MetricsPlugin)cls.newInstance();
            plugin.init(name.isEmpty() ? this : this.subset(name));
            return (T)plugin;
        }
        catch (Exception e) {
            throw new MetricsConfigException("Error creating plugin: " + clsName, e);
        }
    }

    String getClassName(String prefix) {
        String classKey = prefix.isEmpty() ? "class" : prefix + ".class";
        String clsName = this.getString(classKey);
        LOG.debug(clsName);
        if (clsName == null || clsName.isEmpty()) {
            return null;
        }
        return clsName;
    }

    ClassLoader getPluginLoader() {
        if (this.pluginLoader != null) {
            return this.pluginLoader;
        }
        final ClassLoader defaultLoader = this.getClass().getClassLoader();
        Object purls = super.getProperty(PLUGIN_URLS_KEY);
        if (purls == null) {
            return defaultLoader;
        }
        Iterable<String> jars = SPLITTER.split((String)purls);
        int len = Iterables.size(jars);
        if (len > 0) {
            final URL[] urls = new URL[len];
            try {
                int i = 0;
                for (String jar : jars) {
                    LOG.debug(jar);
                    urls[i++] = new URL(jar);
                }
            }
            catch (Exception e) {
                throw new MetricsConfigException(e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("using plugin jars: " + Iterables.toString(jars));
            }
            this.pluginLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new URLClassLoader(urls, defaultLoader);
                }
            });
            return this.pluginLoader;
        }
        if (this.parent instanceof MetricsConfig) {
            return ((MetricsConfig)this.parent).getPluginLoader();
        }
        return defaultLoader;
    }

    @Override
    public void clear() {
        super.clear();
    }

    MetricsFilter getFilter(String prefix) {
        MetricsConfig conf = this.subset(prefix);
        if (conf.isEmpty()) {
            return null;
        }
        MetricsFilter filter = (MetricsFilter)this.getPlugin(prefix);
        if (filter != null) {
            return filter;
        }
        filter = new GlobFilter();
        filter.init(conf);
        return filter;
    }

    public String toString() {
        return MetricsConfig.toString(this);
    }

    static String toString(Configuration c) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            PrintStream ps = new PrintStream((OutputStream)buffer, false, "UTF-8");
            PropertiesConfiguration tmp = new PropertiesConfiguration();
            tmp.copy(c);
            tmp.save(ps);
            return buffer.toString("UTF-8");
        }
        catch (Exception e) {
            throw new MetricsConfigException(e);
        }
    }
}

