/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyCombiner {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyCombiner.class);

    private ProxyCombiner() {
    }

    public static <T> T combine(Class<T> combinedProxyInterface, Object ... proxies) {
        block2: for (Method m3 : combinedProxyInterface.getMethods()) {
            for (Object proxy : proxies) {
                try {
                    proxy.getClass().getMethod(m3.getName(), m3.getParameterTypes());
                    continue block2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            throw new IllegalStateException("The proxies specified for " + combinedProxyInterface + " do not cover method " + m3);
        }
        CombinedProxyInvocationHandler handler = new CombinedProxyInvocationHandler(combinedProxyInterface, proxies);
        return (T)Proxy.newProxyInstance(combinedProxyInterface.getClassLoader(), new Class[]{combinedProxyInterface}, (InvocationHandler)handler);
    }

    private static final class CombinedProxyInvocationHandler
    implements RpcInvocationHandler {
        private final Class<?> proxyInterface;
        private final Object[] proxies;

        private CombinedProxyInvocationHandler(Class<?> proxyInterface, Object[] proxies) {
            this.proxyInterface = proxyInterface;
            this.proxies = proxies;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Exception lastException = null;
            for (Object underlyingProxy : this.proxies) {
                try {
                    return method.invoke(underlyingProxy, args);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    lastException = e;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getCause();
                }
            }
            LOG.error("BUG: Method {} was unable to be found on any of the underlying proxies for {}", (Object)method, (Object)proxy.getClass());
            throw new IllegalArgumentException("Method " + method + " not supported", lastException);
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return RPC.getConnectionIdForProxy(this.proxies[0]);
        }

        public String toString() {
            return "CombinedProxy[" + this.proxyInterface.getSimpleName() + "][" + Joiner.on(",").join(this.proxies) + "]";
        }

        @Override
        public void close() throws IOException {
            MultipleIOException.Builder exceptionBuilder = new MultipleIOException.Builder();
            for (Object proxy : this.proxies) {
                if (!(proxy instanceof Closeable)) continue;
                try {
                    ((Closeable)proxy).close();
                }
                catch (IOException ioe) {
                    exceptionBuilder.add(ioe);
                }
            }
            if (!exceptionBuilder.isEmpty()) {
                throw exceptionBuilder.build();
            }
        }
    }
}

