/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.PowerShellFencer;
import org.apache.hadoop.ha.ShellCommandFencer;
import org.apache.hadoop.ha.SshFenceByTcpPort;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NodeFencer {
    private static final String CLASS_RE = "([a-zA-Z0-9\\.\\$]+)";
    private static final Pattern CLASS_WITH_ARGUMENT = Pattern.compile("([a-zA-Z0-9\\.\\$]+)\\((.+?)\\)");
    private static final Pattern CLASS_WITHOUT_ARGUMENT = Pattern.compile("([a-zA-Z0-9\\.\\$]+)");
    private static final Pattern HASH_COMMENT_RE = Pattern.compile("#.*$");
    private static final Logger LOG = LoggerFactory.getLogger(NodeFencer.class);
    private static final Map<String, Class<? extends FenceMethod>> STANDARD_METHODS = ImmutableMap.of("shell", ShellCommandFencer.class, "sshfence", SshFenceByTcpPort.class, "powershell", PowerShellFencer.class);
    private final List<FenceMethodWithArg> methods;

    NodeFencer(Configuration conf, String spec) throws BadFencingConfigurationException {
        this.methods = NodeFencer.parseMethods(conf, spec);
    }

    public static NodeFencer create(Configuration conf, String confKey) throws BadFencingConfigurationException {
        String confStr = conf.get(confKey);
        if (confStr == null) {
            return null;
        }
        return new NodeFencer(conf, confStr);
    }

    public boolean fence(HAServiceTarget fromSvc) {
        return this.fence(fromSvc, null);
    }

    public boolean fence(HAServiceTarget fromSvc, HAServiceTarget toSvc) {
        LOG.info("====== Beginning Service Fencing Process... ======");
        int i = 0;
        for (FenceMethodWithArg method : this.methods) {
            LOG.info("Trying method " + ++i + "/" + this.methods.size() + ": " + method);
            try {
                boolean toSvcFencingFailed = false;
                if (toSvc != null) {
                    boolean bl = toSvcFencingFailed = !method.method.tryFence(toSvc, method.arg);
                }
                if (toSvcFencingFailed) {
                    LOG.error("====== Fencing on target failed, skipping fencing on source ======");
                } else if (method.method.tryFence(fromSvc, method.arg)) {
                    LOG.info("====== Fencing successful by method " + method + " ======");
                    return true;
                }
            }
            catch (BadFencingConfigurationException e) {
                LOG.error("Fencing method " + method + " misconfigured", e);
                continue;
            }
            catch (Throwable t) {
                LOG.error("Fencing method " + method + " failed with an unexpected error.", t);
                continue;
            }
            LOG.warn("Fencing method " + method + " was unsuccessful.");
        }
        LOG.error("Unable to fence service by any configured method.");
        return false;
    }

    private static List<FenceMethodWithArg> parseMethods(Configuration conf, String spec) throws BadFencingConfigurationException {
        String[] lines = spec.split("\\s*\n\\s*");
        ArrayList<FenceMethodWithArg> methods = Lists.newArrayList();
        for (String line : lines) {
            line = HASH_COMMENT_RE.matcher(line).replaceAll("");
            if ((line = line.trim()).isEmpty()) continue;
            methods.add(NodeFencer.parseMethod(conf, line));
        }
        return methods;
    }

    private static FenceMethodWithArg parseMethod(Configuration conf, String line) throws BadFencingConfigurationException {
        Matcher m3 = CLASS_WITH_ARGUMENT.matcher(line);
        if (m3.matches()) {
            String className = m3.group(1);
            String arg = m3.group(2);
            return NodeFencer.createFenceMethod(conf, className, arg);
        }
        m3 = CLASS_WITHOUT_ARGUMENT.matcher(line);
        if (m3.matches()) {
            String className = m3.group(1);
            return NodeFencer.createFenceMethod(conf, className, null);
        }
        throw new BadFencingConfigurationException("Unable to parse line: '" + line + "'");
    }

    private static FenceMethodWithArg createFenceMethod(Configuration conf, String clazzName, String arg) throws BadFencingConfigurationException {
        Class<FenceMethod> clazz;
        try {
            clazz = STANDARD_METHODS.get(clazzName);
            if (clazz == null) {
                clazz = Class.forName(clazzName);
            }
        }
        catch (Exception e) {
            throw new BadFencingConfigurationException("Could not find configured fencing method " + clazzName, e);
        }
        if (!FenceMethod.class.isAssignableFrom(clazz)) {
            throw new BadFencingConfigurationException("Class " + clazzName + " does not implement FenceMethod");
        }
        FenceMethod method = ReflectionUtils.newInstance(clazz, conf);
        method.checkArgs(arg);
        return new FenceMethodWithArg(method, arg);
    }

    private static class FenceMethodWithArg {
        private final FenceMethod method;
        private final String arg;

        private FenceMethodWithArg(FenceMethod method, String arg) {
            this.method = method;
            this.arg = arg;
        }

        public String toString() {
            return this.method.getClass().getCanonicalName() + "(" + this.arg + ")";
        }
    }
}

