/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.SystemId;
import com.ctc.wstx.stax.WstxInputFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.ConfigRedactor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.stax2.XMLStreamReader2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Configuration
implements Iterable<Map.Entry<String, String>>,
Writable {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private static final Logger LOG_DEPRECATION = LoggerFactory.getLogger("org.apache.hadoop.conf.Configuration.deprecation");
    private boolean quietmode = true;
    private static final String DEFAULT_STRING_CHECK = "testingforemptydefaultvalue";
    private static boolean restrictSystemPropsDefault = false;
    private boolean restrictSystemProps = restrictSystemPropsDefault;
    private boolean allowNullValueProperties = false;
    private ArrayList<Resource> resources = new ArrayList();
    static final String UNKNOWN_RESOURCE = "Unknown";
    private Set<String> finalParameters = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean loadDefaults = true;
    private static final WeakHashMap<Configuration, Object> REGISTRY = new WeakHashMap();
    private static final CopyOnWriteArrayList<String> defaultResources = new CopyOnWriteArrayList();
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final Class<?> NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    private volatile Map<String, String[]> updatingResource;
    private static final WstxInputFactory XML_INPUT_FACTORY = new WstxInputFactory();
    private static DeprecationDelta[] defaultDeprecations = new DeprecationDelta[]{new DeprecationDelta("topology.script.file.name", "net.topology.script.file.name"), new DeprecationDelta("topology.script.number.args", "net.topology.script.number.args"), new DeprecationDelta("hadoop.configured.node.mapping", "net.topology.configured.node.mapping"), new DeprecationDelta("topology.node.switch.mapping.impl", "net.topology.node.switch.mapping.impl"), new DeprecationDelta("dfs.df.interval", "fs.df.interval"), new DeprecationDelta("hadoop.native.lib", "io.native.lib.available"), new DeprecationDelta("fs.default.name", "fs.defaultFS"), new DeprecationDelta("dfs.umaskmode", "fs.permissions.umask-mode"), new DeprecationDelta("dfs.nfs.exports.allowed.hosts", "nfs.exports.allowed.hosts")};
    private static AtomicReference<DeprecationContext> deprecationContext = new AtomicReference<DeprecationContext>(new DeprecationContext(null, defaultDeprecations));
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static final int MAX_SUBST = 20;
    private static final int SUB_START_IDX = 0;
    private static final int SUB_END_IDX = 1;

    public static void addDeprecations(DeprecationDelta[] deltas) {
        DeprecationContext next;
        DeprecationContext prev;
        while (!deprecationContext.compareAndSet(prev = deprecationContext.get(), next = new DeprecationContext(prev, deltas))) {
        }
    }

    @Deprecated
    public static void addDeprecation(String key, String[] newKeys, String customMessage) {
        Configuration.addDeprecations(new DeprecationDelta[]{new DeprecationDelta(key, newKeys, customMessage)});
    }

    public static void addDeprecation(String key, String newKey, String customMessage) {
        Configuration.addDeprecation(key, new String[]{newKey}, customMessage);
    }

    @Deprecated
    public static void addDeprecation(String key, String[] newKeys) {
        Configuration.addDeprecation(key, newKeys, null);
    }

    public static void addDeprecation(String key, String newKey) {
        Configuration.addDeprecation(key, new String[]{newKey}, null);
    }

    public static boolean isDeprecated(String key) {
        return deprecationContext.get().getDeprecatedKeyMap().containsKey(key);
    }

    private static String getDeprecatedKey(String key) {
        return deprecationContext.get().getReverseDeprecatedKeyMap().get(key);
    }

    private static DeprecatedKeyInfo getDeprecatedKeyInfo(String key) {
        return deprecationContext.get().getDeprecatedKeyMap().get(key);
    }

    public void setDeprecatedProperties() {
        DeprecationContext deprecations = deprecationContext.get();
        Properties props = this.getProps();
        Properties overlay = this.getOverlay();
        block0: for (Map.Entry<String, DeprecatedKeyInfo> entry : deprecations.getDeprecatedKeyMap().entrySet()) {
            String depKey = entry.getKey();
            if (overlay.contains(depKey)) continue;
            for (String newKey : entry.getValue().newKeys) {
                String val = overlay.getProperty(newKey);
                if (val == null) continue;
                props.setProperty(depKey, val);
                overlay.setProperty(depKey, val);
                continue block0;
            }
        }
    }

    private String[] handleDeprecation(DeprecationContext deprecations, String name) {
        Properties overlay;
        if (null != name) {
            name = name.trim();
        }
        String[] names = new String[]{name};
        DeprecatedKeyInfo keyInfo = deprecations.getDeprecatedKeyMap().get(name);
        if (keyInfo != null) {
            if (!keyInfo.getAndSetAccessed()) {
                this.logDeprecation(keyInfo.getWarningMessage(name));
            }
            names = keyInfo.newKeys;
        }
        if ((overlay = this.getOverlay()).isEmpty()) {
            return names;
        }
        for (String n : names) {
            String deprecatedValue;
            String deprecatedKey = deprecations.getReverseDeprecatedKeyMap().get(n);
            if (deprecatedKey == null || overlay.containsKey(n) || (deprecatedValue = overlay.getProperty(deprecatedKey)) == null) continue;
            this.getProps().setProperty(n, deprecatedValue);
            overlay.setProperty(n, deprecatedValue);
        }
        return names;
    }

    private void handleDeprecation() {
        LOG.debug("Handling deprecation for all properties in config...");
        DeprecationContext deprecations = deprecationContext.get();
        HashSet<Object> keys = new HashSet<Object>();
        keys.addAll(this.getProps().keySet());
        for (Object e : keys) {
            LOG.debug("Handling deprecation for " + (String)e);
            this.handleDeprecation(deprecations, (String)e);
        }
    }

    public Configuration() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(boolean loadDefaults) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = loadDefaults;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration other) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        Object object = other;
        synchronized (object) {
            other.getProps();
            this.resources = (ArrayList)other.resources.clone();
            if (other.properties != null) {
                this.properties = (Properties)other.properties.clone();
            }
            if (other.overlay != null) {
                this.overlay = (Properties)other.overlay.clone();
            }
            this.restrictSystemProps = other.restrictSystemProps;
            if (other.updatingResource != null) {
                this.updatingResource = new ConcurrentHashMap<String, String[]>(other.updatingResource);
            }
            this.finalParameters = Collections.newSetFromMap(new ConcurrentHashMap());
            this.finalParameters.addAll(other.finalParameters);
        }
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.classLoader = other.classLoader;
            this.loadDefaults = other.loadDefaults;
            this.setQuietMode(other.getQuietMode());
            return;
        }
    }

    public static synchronized void reloadExistingConfigurations() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reloading " + REGISTRY.keySet().size() + " existing configurations");
        }
        for (Configuration conf : REGISTRY.keySet()) {
            conf.reloadConfiguration();
        }
    }

    public static synchronized void addDefaultResource(String name) {
        if (!defaultResources.contains(name)) {
            defaultResources.add(name);
            for (Configuration conf : REGISTRY.keySet()) {
                if (!conf.loadDefaults) continue;
                conf.reloadConfiguration();
            }
        }
    }

    public static void setRestrictSystemPropertiesDefault(boolean val) {
        restrictSystemPropsDefault = val;
    }

    public void setRestrictSystemProperties(boolean val) {
        this.restrictSystemProps = val;
    }

    public void addResource(String name) {
        this.addResourceObject(new Resource(name));
    }

    public void addResource(String name, boolean restrictedParser) {
        this.addResourceObject(new Resource((Object)name, restrictedParser));
    }

    public void addResource(URL url) {
        this.addResourceObject(new Resource(url));
    }

    public void addResource(URL url, boolean restrictedParser) {
        this.addResourceObject(new Resource((Object)url, restrictedParser));
    }

    public void addResource(Path file) {
        this.addResourceObject(new Resource(file));
    }

    public void addResource(Path file, boolean restrictedParser) {
        this.addResourceObject(new Resource((Object)file, restrictedParser));
    }

    public void addResource(InputStream in) {
        this.addResourceObject(new Resource(in));
    }

    public void addResource(InputStream in, boolean restrictedParser) {
        this.addResourceObject(new Resource((Object)in, restrictedParser));
    }

    public void addResource(InputStream in, String name) {
        this.addResourceObject(new Resource((Object)in, name));
    }

    public void addResource(InputStream in, String name, boolean restrictedParser) {
        this.addResourceObject(new Resource(in, name, restrictedParser));
    }

    public void addResource(Configuration conf) {
        this.addResourceObject(new Resource((Object)conf.getProps(), conf.restrictSystemProps));
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Resource resource) {
        this.resources.add(resource);
        this.restrictSystemProps |= resource.isParserRestricted();
        this.loadProps(this.properties, this.resources.size() - 1, false);
    }

    private static int[] findSubVariable(String eval) {
        int[] result = new int[]{-1, -1};
        int matchStart = 1;
        int leftBrace = eval.indexOf(123, matchStart);
        block4: while (leftBrace > 0 && leftBrace + "{c".length() < eval.length()) {
            block8: {
                int matchedLen = 0;
                if (eval.charAt(leftBrace - 1) == '$') {
                    int subStart;
                    int i = subStart = leftBrace + 1;
                    while (i < eval.length()) {
                        switch (eval.charAt(i)) {
                            case '}': {
                                if (matchedLen > 0) {
                                    result[0] = subStart;
                                    result[1] = subStart + matchedLen;
                                    break block4;
                                }
                            }
                            case ' ': 
                            case '$': {
                                matchStart = i + 1;
                                break block8;
                            }
                            default: {
                                ++matchedLen;
                                ++i;
                                break;
                            }
                        }
                    }
                    break;
                }
                matchStart = leftBrace + 1;
            }
            leftBrace = eval.indexOf(123, matchStart);
        }
        return result;
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        String eval = expr;
        for (int s2 = 0; s2 < 20; ++s2) {
            int[] varBounds = Configuration.findSubVariable(eval);
            if (varBounds[0] == -1) {
                return eval;
            }
            String var = eval.substring(varBounds[0], varBounds[1]);
            String val = null;
            if (!this.restrictSystemProps) {
                try {
                    val = System.getProperty(var);
                }
                catch (SecurityException se) {
                    LOG.warn("Unexpected SecurityException in Configuration", se);
                }
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            int dollar = varBounds[0] - "${".length();
            int afterRightBrace = varBounds[1] + "}".length();
            eval = eval.substring(0, dollar) + val + eval.substring(afterRightBrace);
        }
        throw new IllegalStateException("Variable substitution depth too large: 20 " + expr);
    }

    public String get(String name) {
        String[] names = this.handleDeprecation(deprecationContext.get(), name);
        String result = null;
        for (String n : names) {
            result = this.substituteVars(this.getProps().getProperty(n));
        }
        return result;
    }

    @VisibleForTesting
    public void setAllowNullValueProperties(boolean val) {
        this.allowNullValueProperties = val;
    }

    public void setRestrictSystemProps(boolean val) {
        this.restrictSystemProps = val;
    }

    @VisibleForTesting
    public boolean onlyKeyExists(String name) {
        String[] names;
        for (String n : names = this.handleDeprecation(deprecationContext.get(), name)) {
            if (!this.getProps().getProperty(n, DEFAULT_STRING_CHECK).equals(DEFAULT_STRING_CHECK)) continue;
            return true;
        }
        return false;
    }

    public String getTrimmed(String name) {
        String value = this.get(name);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public String getTrimmed(String name, String defaultValue) {
        String ret = this.getTrimmed(name);
        return ret == null ? defaultValue : ret;
    }

    public String getRaw(String name) {
        String[] names = this.handleDeprecation(deprecationContext.get(), name);
        String result = null;
        for (String n : names) {
            result = this.getProps().getProperty(n);
        }
        return result;
    }

    private String[] getAlternativeNames(String name) {
        String[] altNames = null;
        DeprecatedKeyInfo keyInfo = null;
        DeprecationContext cur = deprecationContext.get();
        String depKey = cur.getReverseDeprecatedKeyMap().get(name);
        if (depKey != null && (keyInfo = cur.getDeprecatedKeyMap().get(depKey)).newKeys.length > 0) {
            if (this.getProps().containsKey(depKey)) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(keyInfo.newKeys));
                list.add(depKey);
                altNames = list.toArray(new String[list.size()]);
            } else {
                altNames = keyInfo.newKeys;
            }
        }
        return altNames;
    }

    public void set(String name, String value) {
        this.set(name, value, null);
    }

    public void set(String name, String value, String source) {
        block4: {
            block3: {
                String newSource;
                Preconditions.checkArgument(name != null, "Property name must not be null");
                Preconditions.checkArgument(value != null, "The value of property %s must not be null", name);
                name = name.trim();
                DeprecationContext deprecations = deprecationContext.get();
                if (deprecations.getDeprecatedKeyMap().isEmpty()) {
                    this.getProps();
                }
                this.getOverlay().setProperty(name, value);
                this.getProps().setProperty(name, value);
                String string = newSource = source == null ? "programatically" : source;
                if (Configuration.isDeprecated(name)) break block3;
                this.putIntoUpdatingResource(name, new String[]{newSource});
                String[] altNames = this.getAlternativeNames(name);
                if (altNames == null) break block4;
                for (String n : altNames) {
                    if (n.equals(name)) continue;
                    this.getOverlay().setProperty(n, value);
                    this.getProps().setProperty(n, value);
                    this.putIntoUpdatingResource(n, new String[]{newSource});
                }
                break block4;
            }
            String[] names = this.handleDeprecation(deprecationContext.get(), name);
            String altSource = "because " + name + " is deprecated";
            for (String n : names) {
                this.getOverlay().setProperty(n, value);
                this.getProps().setProperty(n, value);
                this.putIntoUpdatingResource(n, new String[]{altSource});
            }
        }
    }

    private void logDeprecation(String message) {
        LOG_DEPRECATION.info(message);
    }

    void logDeprecationOnce(String name, String source) {
        DeprecatedKeyInfo keyInfo = Configuration.getDeprecatedKeyInfo(name);
        if (keyInfo != null && !keyInfo.getAndSetAccessed()) {
            LOG_DEPRECATION.info(keyInfo.getWarningMessage(name, source));
        }
    }

    public synchronized void unset(String name) {
        String[] names = null;
        if (!Configuration.isDeprecated(name)) {
            names = this.getAlternativeNames(name);
            if (names == null) {
                names = new String[]{name};
            }
        } else {
            names = this.handleDeprecation(deprecationContext.get(), name);
        }
        for (String n : names) {
            this.getOverlay().remove(n);
            this.getProps().remove(n);
        }
    }

    public synchronized void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        String[] names = this.handleDeprecation(deprecationContext.get(), name);
        String result = null;
        for (String n : names) {
            result = this.substituteVars(this.getProps().getProperty(n, defaultValue));
        }
        return result;
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public int[] getInts(String name) {
        String[] strings = this.getTrimmedStrings(name);
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public long getLongBytes(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.TraditionalBinaryPrefix.string2long(valueString);
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Float.parseFloat(valueString);
    }

    public void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    public double getDouble(String name, double defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Double.parseDouble(valueString);
    }

    public void setDouble(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.getTrimmed(name);
        if (null == valueString || valueString.isEmpty()) {
            return defaultValue;
        }
        if (StringUtils.equalsIgnoreCase("true", valueString)) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase("false", valueString)) {
            return false;
        }
        return defaultValue;
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.setIfUnset(name, Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.set(name, value.toString());
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.getTrimmed(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public void setTimeDuration(String name, long value, TimeUnit unit) {
        this.set(name, value + ParsedTimeDuration.unitFor(unit).suffix());
    }

    public long getTimeDuration(String name, long defaultValue, TimeUnit unit) {
        return this.getTimeDuration(name, defaultValue, unit, unit);
    }

    public long getTimeDuration(String name, long defaultValue, TimeUnit defaultUnit, TimeUnit returnUnit) {
        String vStr = this.get(name);
        if (null == vStr) {
            return returnUnit.convert(defaultValue, defaultUnit);
        }
        vStr = vStr.trim();
        return this.getTimeDurationHelper(name, vStr, defaultUnit, returnUnit);
    }

    private long getTimeDurationHelper(String name, String vStr, TimeUnit unit) {
        return this.getTimeDurationHelper(name, vStr, unit, unit);
    }

    private long getTimeDurationHelper(String name, String vStr, TimeUnit defaultUnit, TimeUnit returnUnit) {
        ParsedTimeDuration vUnit = ParsedTimeDuration.unitFor(vStr);
        if (null == vUnit) {
            LOG.warn("No unit for " + name + "(" + vStr + ") assuming " + (Object)((Object)defaultUnit));
            vUnit = ParsedTimeDuration.unitFor(defaultUnit);
        } else {
            vStr = vStr.substring(0, vStr.lastIndexOf(vUnit.suffix()));
        }
        return returnUnit.convert(Long.parseLong(vStr), vUnit.unit());
    }

    public long[] getTimeDurations(String name, TimeUnit unit) {
        String[] strings = this.getTrimmedStrings(name);
        long[] durations = new long[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            durations[i] = this.getTimeDurationHelper(name, strings[i], unit);
        }
        return durations;
    }

    public Pattern getPattern(String name, Pattern defaultValue) {
        String valString = this.get(name);
        if (null == valString || valString.isEmpty()) {
            return defaultValue;
        }
        try {
            return Pattern.compile(valString);
        }
        catch (PatternSyntaxException pse) {
            LOG.warn("Regular expression '" + valString + "' for property '" + name + "' not valid. Using default", pse);
            return defaultValue;
        }
    }

    public void setPattern(String name, Pattern pattern) {
        assert (pattern != null) : "Pattern cannot be null";
        this.set(name, pattern.pattern());
    }

    @InterfaceStability.Unstable
    public synchronized String[] getPropertySources(String name) {
        if (this.properties == null) {
            this.getProps();
        }
        if (this.properties == null || this.updatingResource == null) {
            return null;
        }
        String[] source = this.updatingResource.get(name);
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public IntegerRanges getRange(String name, String defaultValue) {
        return new IntegerRanges(this.get(name, defaultValue));
    }

    public Collection<String> getStringCollection(String name) {
        String valueString = this.get(name);
        return StringUtils.getStringCollection(valueString);
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings(valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings(valueString);
    }

    public Collection<String> getTrimmedStringCollection(String name) {
        String valueString = this.get(name);
        if (null == valueString) {
            ArrayList<String> empty = new ArrayList<String>();
            return empty;
        }
        return StringUtils.getTrimmedStringCollection(valueString);
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getTrimmedStrings(valueString);
    }

    public String[] getTrimmedStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (null == valueString) {
            return defaultValue;
        }
        return StringUtils.getTrimmedStrings(valueString);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.arrayToString(values));
    }

    public char[] getPassword(String name) throws IOException {
        char[] pass = null;
        pass = this.getPasswordFromCredentialProviders(name);
        if (pass == null) {
            pass = this.getPasswordFromConfig(name);
        }
        return pass;
    }

    private CredentialProvider.CredentialEntry getCredentialEntry(CredentialProvider provider, String name) throws IOException {
        CredentialProvider.CredentialEntry entry = provider.getCredentialEntry(name);
        if (entry != null) {
            return entry;
        }
        String oldName = Configuration.getDeprecatedKey(name);
        if (oldName != null && (entry = provider.getCredentialEntry(oldName)) != null) {
            this.logDeprecationOnce(oldName, provider.toString());
            return entry;
        }
        DeprecatedKeyInfo keyInfo = Configuration.getDeprecatedKeyInfo(name);
        if (keyInfo != null && keyInfo.newKeys != null) {
            for (String newName : keyInfo.newKeys) {
                entry = provider.getCredentialEntry(newName);
                if (entry == null) continue;
                this.logDeprecationOnce(name, null);
                return entry;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public char[] getPasswordFromCredentialProviders(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected char[] getPasswordFromConfig(String name) {
        String passStr;
        char[] pass = null;
        if (this.getBoolean("hadoop.security.credential.clear-text-fallback", true) && (passStr = this.get(name)) != null) {
            pass = passStr.toCharArray();
        }
        return pass;
    }

    public InetSocketAddress getSocketAddr(String hostProperty, String addressProperty, String defaultAddressValue, int defaultPort) {
        InetSocketAddress bindAddr = this.getSocketAddr(addressProperty, defaultAddressValue, defaultPort);
        String host = this.get(hostProperty);
        if (host == null || host.isEmpty()) {
            return bindAddr;
        }
        return NetUtils.createSocketAddr(host, bindAddr.getPort(), hostProperty);
    }

    public InetSocketAddress getSocketAddr(String name, String defaultAddress, int defaultPort) {
        String address = this.getTrimmed(name, defaultAddress);
        return NetUtils.createSocketAddr(address, defaultPort, name);
    }

    public void setSocketAddr(String name, InetSocketAddress addr) {
        this.set(name, NetUtils.getHostPortString(addr));
    }

    public InetSocketAddress updateConnectAddr(String hostProperty, String addressProperty, String defaultAddressValue, InetSocketAddress addr) {
        String host = this.get(hostProperty);
        String connectHostPort = this.getTrimmed(addressProperty, defaultAddressValue);
        if (host == null || host.isEmpty() || connectHostPort == null || connectHostPort.isEmpty()) {
            return this.updateConnectAddr(addressProperty, addr);
        }
        String connectHost = connectHostPort.split(":")[0];
        return this.updateConnectAddr(addressProperty, NetUtils.createSocketAddrForHost(connectHost, addr.getPort()));
    }

    public InetSocketAddress updateConnectAddr(String name, InetSocketAddress addr) {
        InetSocketAddress connectAddr = NetUtils.getConnectAddress(addr);
        this.setSocketAddr(name, connectAddr);
        return connectAddr;
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> ret = this.getClassByNameOrNull(name);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassByNameOrNull(String name) {
        Map<String, WeakReference<Class<Object>>> map;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.get(this.classLoader);
            if (map == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                CACHE_CLASSES.put(this.classLoader, map);
            }
        }
        Class<?> clazz = null;
        WeakReference<Class<Object>> ref = map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                map.put(name, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        if (clazz == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String valueString = this.getRaw(name);
        if (null == valueString) {
            return defaultValue;
        }
        String[] classnames = this.getTrimmedStrings(name);
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = this.getClassByName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <U> List<U> getInstances(String name, Class<U> xface) {
        Class<?>[] classes;
        ArrayList ret = new ArrayList();
        for (Class<?> cl : classes = this.getClasses(name, new Class[0])) {
            if (!xface.isAssignableFrom(cl)) {
                throw new RuntimeException(cl + " does not implement " + xface);
            }
            ret.add(ReflectionUtils.newInstance(cl, this));
        }
        return ret;
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public Path getLocalPath(String dirsProp, String path) throws IOException {
        int index;
        int i;
        String[] dirs = this.getTrimmedStrings(dirsProp);
        int hashCode = path.hashCode();
        LocalFileSystem fs = FileSystem.getLocal(this);
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            Path file = new Path(dirs[index], path);
            Path dir = file.getParent();
            if (!((FileSystem)fs).mkdirs(dir) && !fs.exists(dir)) continue;
            return file;
        }
        LOG.warn("Could not make " + path + " in local directories from " + dirsProp);
        for (i = 0; i < dirs.length; ++i) {
            index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            LOG.warn(dirsProp + "[" + index + "]=" + dirs[index]);
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public File getFile(String dirsProp, String path) throws IOException {
        String[] dirs = this.getTrimmedStrings(dirsProp);
        int hashCode = path.hashCode();
        for (int i = 0; i < dirs.length; ++i) {
            int index = (hashCode + i & Integer.MAX_VALUE) % dirs.length;
            File file = new File(dirs[index], path);
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) continue;
            return file;
        }
        throw new IOException("No valid local directories in property: " + dirsProp);
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info(name + " not found");
                return null;
            }
            LOG.info("found resource " + name + " at " + url);
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Reader getConfResourceAsReader(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                LOG.info(name + " not found");
                return null;
            }
            LOG.info("found resource " + name + " at " + url);
            return new InputStreamReader(url.openStream(), Charsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<String> getFinalParameters() {
        Set<String> setFinalParams = Collections.newSetFromMap(new ConcurrentHashMap());
        setFinalParams.addAll(this.finalParameters);
        return setFinalParams;
    }

    protected synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadProps(this.properties, 0, true);
        }
        return this.properties;
    }

    private synchronized void loadProps(Properties props, int startIdx, boolean fullReload) {
        if (props != null) {
            ConcurrentHashMap<String, String[]> backup = this.updatingResource != null ? new ConcurrentHashMap<String, String[]>(this.updatingResource) : null;
            this.loadResources(props, this.resources, startIdx, fullReload, this.quietmode);
            if (this.overlay != null) {
                props.putAll((Map<?, ?>)this.overlay);
                if (backup != null) {
                    for (Map.Entry<Object, Object> item : this.overlay.entrySet()) {
                        String key = (String)item.getKey();
                        String[] source = (String[])backup.get(key);
                        if (source == null) continue;
                        this.updatingResource.put(key, source);
                    }
                }
            }
        }
    }

    public int size() {
        return this.getProps().size();
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Properties props = this.getProps();
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = props;
        synchronized (properties) {
            for (Map.Entry<Object, Object> item : props.entrySet()) {
                if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
                result.put((String)item.getKey(), (String)item.getValue());
            }
        }
        return result.entrySet().iterator();
    }

    public Map<String, String> getPropsWithPrefix(String confPrefix) {
        Properties props = this.getProps();
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String name : props.stringPropertyNames()) {
            if (!name.startsWith(confPrefix)) continue;
            String value = this.get(name);
            String keyName = name.substring(confPrefix.length());
            configMap.put(keyName, value);
        }
        return configMap;
    }

    private XMLStreamReader parse(URL url, boolean restricted) throws IOException, XMLStreamException {
        if (!this.quietmode && LOG.isDebugEnabled()) {
            LOG.debug("parsing URL " + url);
        }
        if (url == null) {
            return null;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            connection.setUseCaches(false);
        }
        return this.parse(connection.getInputStream(), url.toString(), restricted);
    }

    private XMLStreamReader parse(InputStream is, String systemIdStr, boolean restricted) throws IOException, XMLStreamException {
        if (!this.quietmode) {
            LOG.debug("parsing input stream " + is);
        }
        if (is == null) {
            return null;
        }
        SystemId systemId = SystemId.construct(systemIdStr);
        ReaderConfig readerConfig = XML_INPUT_FACTORY.createPrivateConfig();
        if (restricted) {
            readerConfig.setProperty("javax.xml.stream.supportDTD", false);
        }
        return XML_INPUT_FACTORY.createSR(readerConfig, systemId, (InputBootstrapper)StreamBootstrapper.getInstance(null, systemId, is), false, true);
    }

    private void loadResources(Properties properties, ArrayList<Resource> resources, int startIdx, boolean fullReload, boolean quiet) {
        if (this.loadDefaults && fullReload) {
            for (String resource : defaultResources) {
                this.loadResource(properties, new Resource((Object)resource, false), quiet);
            }
        }
        for (int i = startIdx; i < resources.size(); ++i) {
            Resource ret = this.loadResource(properties, resources.get(i), quiet);
            if (ret == null) continue;
            resources.set(i, ret);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource loadResource(Properties properties, Resource wrapper, boolean quiet) {
        String name = UNKNOWN_RESOURCE;
        try {
            Object resource = wrapper.getResource();
            name = wrapper.getName();
            XMLStreamReader2 reader = null;
            boolean returnCachedProperties = false;
            boolean isRestricted = wrapper.isParserRestricted();
            if (resource instanceof URL) {
                reader = (XMLStreamReader2)this.parse((URL)resource, isRestricted);
            } else if (resource instanceof String) {
                URL url = this.getResource((String)resource);
                reader = (XMLStreamReader2)this.parse(url, isRestricted);
            } else if (resource instanceof Path) {
                File file = new File(((Path)resource).toUri().getPath()).getAbsoluteFile();
                if (file.exists()) {
                    if (!quiet) {
                        LOG.debug("parsing File " + file);
                    }
                    reader = (XMLStreamReader2)this.parse(new BufferedInputStream(new FileInputStream(file)), ((Path)resource).toString(), isRestricted);
                }
            } else if (resource instanceof InputStream) {
                reader = (XMLStreamReader2)this.parse((InputStream)resource, null, isRestricted);
                returnCachedProperties = true;
            } else if (resource instanceof Properties) {
                this.overlay(properties, (Properties)resource);
            }
            if (reader == null) {
                if (quiet) {
                    return null;
                }
                throw new RuntimeException(resource + " not found");
            }
            Properties toAddTo = properties;
            if (returnCachedProperties) {
                toAddTo = new Properties();
            }
            DeprecationContext deprecations = deprecationContext.get();
            StringBuilder token = new StringBuilder();
            String confName = null;
            String confValue = null;
            String confInclude = null;
            boolean confFinal = false;
            boolean fallbackAllowed = false;
            boolean fallbackEntered = false;
            boolean parseToken = false;
            LinkedList<String> confSource = new LinkedList<String>();
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        switch (reader.getLocalName()) {
                            case "property": {
                                confName = null;
                                confValue = null;
                                confFinal = false;
                                confSource.clear();
                                int attrCount = reader.getAttributeCount();
                                for (int i = 0; i < attrCount; ++i) {
                                    String propertyAttr = reader.getAttributeLocalName(i);
                                    if ("name".equals(propertyAttr)) {
                                        confName = StringInterner.weakIntern(reader.getAttributeValue(i));
                                        continue;
                                    }
                                    if ("value".equals(propertyAttr)) {
                                        confValue = StringInterner.weakIntern(reader.getAttributeValue(i));
                                        continue;
                                    }
                                    if ("final".equals(propertyAttr)) {
                                        confFinal = "true".equals(reader.getAttributeValue(i));
                                        continue;
                                    }
                                    if (!"source".equals(propertyAttr)) continue;
                                    confSource.add(StringInterner.weakIntern(reader.getAttributeValue(i)));
                                }
                                break;
                            }
                            case "name": 
                            case "value": 
                            case "final": 
                            case "source": {
                                parseToken = true;
                                token.setLength(0);
                                break;
                            }
                            case "include": {
                                confInclude = null;
                                int attrCount = reader.getAttributeCount();
                                for (int i = 0; i < attrCount; ++i) {
                                    String attrName = reader.getAttributeLocalName(i);
                                    if (!"href".equals(attrName)) continue;
                                    confInclude = reader.getAttributeValue(i);
                                }
                                if (confInclude == null) break;
                                if (isRestricted) {
                                    throw new RuntimeException("Error parsing resource " + wrapper + ": XInclude is not supported for restricted resources");
                                }
                                URL include = this.getResource(confInclude);
                                Properties tmpProps = new Properties();
                                if (include != null) {
                                    Resource classpathResource = new Resource(include, name, wrapper.isParserRestricted());
                                    this.loadResource(tmpProps, classpathResource, quiet);
                                } else {
                                    URL url;
                                    try {
                                        url = new URL(confInclude);
                                        url.openConnection().connect();
                                    }
                                    catch (IOException ioe) {
                                        File href = new File(confInclude);
                                        if (!href.isAbsolute()) {
                                            File baseFile = new File(name).getParentFile();
                                            href = new File(baseFile, href.getPath());
                                        }
                                        if (!href.exists()) {
                                            fallbackAllowed = true;
                                            break;
                                        }
                                        url = href.toURI().toURL();
                                    }
                                    Resource uriResource = new Resource(url, name, wrapper.isParserRestricted());
                                    this.loadResource(tmpProps, uriResource, quiet);
                                }
                                toAddTo.putAll((Map<?, ?>)tmpProps);
                                break;
                            }
                            case "fallback": {
                                fallbackEntered = true;
                                break;
                            }
                            case "configuration": {
                                break;
                            }
                        }
                        break;
                    }
                    case 4: 
                    case 12: {
                        if (!parseToken) break;
                        char[] text = reader.getTextCharacters();
                        token.append(text, reader.getTextStart(), reader.getTextLength());
                        break;
                    }
                    case 2: {
                        switch (reader.getLocalName()) {
                            case "name": {
                                if (token.length() <= 0) break;
                                confName = StringInterner.weakIntern(token.toString().trim());
                                break;
                            }
                            case "value": {
                                if (token.length() <= 0) break;
                                confValue = StringInterner.weakIntern(token.toString());
                                break;
                            }
                            case "final": {
                                confFinal = "true".equals(token.toString());
                                break;
                            }
                            case "source": {
                                confSource.add(StringInterner.weakIntern(token.toString()));
                                break;
                            }
                            case "include": {
                                if (fallbackAllowed && !fallbackEntered) {
                                    throw new IOException("Fetch fail on include for '" + confInclude + "' with no fallback while loading '" + name + "'");
                                }
                                fallbackAllowed = false;
                                fallbackEntered = false;
                                break;
                            }
                            case "property": {
                                if (confName == null || !fallbackAllowed && fallbackEntered) break;
                                confSource.add(name);
                                DeprecatedKeyInfo keyInfo = deprecations.getDeprecatedKeyMap().get(confName);
                                if (keyInfo != null) {
                                    keyInfo.clearAccessed();
                                    for (String key : keyInfo.newKeys) {
                                        this.loadProperty(toAddTo, name, key, confValue, confFinal, confSource.toArray(new String[confSource.size()]));
                                    }
                                    break;
                                }
                                this.loadProperty(toAddTo, name, confName, confValue, confFinal, confSource.toArray(new String[confSource.size()]));
                                break;
                            }
                        }
                        break;
                    }
                }
            }
            reader.close();
            if (returnCachedProperties) {
                this.overlay(properties, toAddTo);
                return new Resource(toAddTo, name, wrapper.isParserRestricted());
            }
            return null;
        }
        catch (IOException e) {
            LOG.error("error parsing conf " + name, e);
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            LOG.error("error parsing conf " + name, e);
            throw new RuntimeException(e);
        }
    }

    private void overlay(Properties to, Properties from) {
        for (Map.Entry<Object, Object> entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    private void loadProperty(Properties properties, String name, String attr, String value, boolean finalParameter, String[] source) {
        if (value != null || this.allowNullValueProperties) {
            if (value == null) {
                value = DEFAULT_STRING_CHECK;
            }
            if (!this.finalParameters.contains(attr)) {
                properties.setProperty(attr, value);
                if (source != null) {
                    this.putIntoUpdatingResource(attr, source);
                }
            } else {
                this.checkForOverride(this.properties, name, attr, value);
                if (this.properties != properties) {
                    this.checkForOverride(properties, name, attr, value);
                }
            }
        }
        if (finalParameter && attr != null) {
            this.finalParameters.add(attr);
        }
    }

    private void checkForOverride(Properties properties, String name, String attr, String value) {
        String propertyValue = properties.getProperty(attr);
        if (propertyValue != null && !propertyValue.equals(value)) {
            LOG.warn(name + ":an attempt to override final parameter: " + attr + ";  Ignoring.");
        }
    }

    public void writeXml(OutputStream out) throws IOException {
        this.writeXml(new OutputStreamWriter(out, "UTF-8"));
    }

    public void writeXml(Writer out) throws IOException {
        this.writeXml(null, out);
    }

    public void writeXml(String propertyName, Writer out) throws IOException, IllegalArgumentException {
        Document doc = this.asXmlDocument(propertyName);
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    private synchronized Document asXmlDocument(String propertyName) throws IOException, IllegalArgumentException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pe) {
            throw new IOException(pe);
        }
        Element conf = doc.createElement("configuration");
        doc.appendChild(conf);
        conf.appendChild(doc.createTextNode("\n"));
        this.handleDeprecation();
        if (!Strings.isNullOrEmpty(propertyName)) {
            if (!this.properties.containsKey(propertyName)) {
                throw new IllegalArgumentException("Property " + propertyName + " not found");
            }
            this.appendXMLProperty(doc, conf, propertyName);
            conf.appendChild(doc.createTextNode("\n"));
        } else {
            Enumeration<Object> e = this.properties.keys();
            while (e.hasMoreElements()) {
                this.appendXMLProperty(doc, conf, (String)e.nextElement());
                conf.appendChild(doc.createTextNode("\n"));
            }
        }
        return doc;
    }

    private synchronized void appendXMLProperty(Document doc, Element conf, String propertyName) {
        String value;
        if (!Strings.isNullOrEmpty(propertyName) && (value = this.properties.getProperty(propertyName)) != null) {
            String[] sources;
            Element propNode = doc.createElement("property");
            conf.appendChild(propNode);
            Element nameNode = doc.createElement("name");
            nameNode.appendChild(doc.createTextNode(propertyName));
            propNode.appendChild(nameNode);
            Element valueNode = doc.createElement("value");
            valueNode.appendChild(doc.createTextNode(this.properties.getProperty(propertyName)));
            propNode.appendChild(valueNode);
            Element finalNode = doc.createElement("final");
            finalNode.appendChild(doc.createTextNode(String.valueOf(this.finalParameters.contains(propertyName))));
            propNode.appendChild(finalNode);
            if (this.updatingResource != null && (sources = this.updatingResource.get(propertyName)) != null) {
                for (String s2 : sources) {
                    Element sourceNode = doc.createElement("source");
                    sourceNode.appendChild(doc.createTextNode(s2));
                    propNode.appendChild(sourceNode);
                }
            }
        }
    }

    public static void dumpConfiguration(Configuration config, String propertyName, Writer out) throws IOException {
        if (Strings.isNullOrEmpty(propertyName)) {
            Configuration.dumpConfiguration(config, out);
        } else {
            if (Strings.isNullOrEmpty(config.get(propertyName))) {
                throw new IllegalArgumentException("Property " + propertyName + " not found");
            }
            JsonFactory dumpFactory = new JsonFactory();
            JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
            dumpGenerator.writeStartObject();
            dumpGenerator.writeFieldName("property");
            Configuration.appendJSONProperty(dumpGenerator, config, propertyName, new ConfigRedactor(config));
            dumpGenerator.writeEndObject();
            dumpGenerator.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpConfiguration(Configuration config, Writer out) throws IOException {
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createJsonGenerator(out);
        dumpGenerator.writeStartObject();
        dumpGenerator.writeFieldName("properties");
        dumpGenerator.writeStartArray();
        dumpGenerator.flush();
        ConfigRedactor redactor = new ConfigRedactor(config);
        Configuration configuration = config;
        synchronized (configuration) {
            for (Map.Entry<Object, Object> item : config.getProps().entrySet()) {
                Configuration.appendJSONProperty(dumpGenerator, config, item.getKey().toString(), redactor);
            }
        }
        dumpGenerator.writeEndArray();
        dumpGenerator.writeEndObject();
        dumpGenerator.flush();
    }

    private static void appendJSONProperty(JsonGenerator jsonGen, Configuration config, String name, ConfigRedactor redactor) throws IOException {
        if (!Strings.isNullOrEmpty(name) && jsonGen != null) {
            jsonGen.writeStartObject();
            jsonGen.writeStringField("key", name);
            jsonGen.writeStringField("value", redactor.redact(name, config.get(name)));
            jsonGen.writeBooleanField("isFinal", config.finalParameters.contains(name));
            String[] resources = config.updatingResource != null ? config.updatingResource.get(name) : null;
            String resource = UNKNOWN_RESOURCE;
            if (resources != null && resources.length > 0) {
                resource = resources[0];
            }
            jsonGen.writeStringField("resource", resource);
            jsonGen.writeEndObject();
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            this.toString(defaultResources, sb);
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private <T> void toString(List<T> resources, StringBuilder sb) {
        ListIterator<T> i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    public synchronized void setQuietMode(boolean quietmode) {
        this.quietmode = quietmode;
    }

    synchronized boolean getQuietMode() {
        return this.quietmode;
    }

    public static void main(String[] args) throws Exception {
        new Configuration().writeXml(System.out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            String key = Text.readString(in);
            String value = Text.readString(in);
            this.set(key, value);
            String[] sources = WritableUtils.readCompressedStringArray(in);
            if (sources == null) continue;
            this.putIntoUpdatingResource(key, sources);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Properties props = this.getProps();
        WritableUtils.writeVInt(out, props.size());
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            Text.writeString(out, (String)item.getKey());
            Text.writeString(out, (String)item.getValue());
            WritableUtils.writeCompressedStringArray(out, this.updatingResource != null ? this.updatingResource.get(item.getKey()) : null);
        }
    }

    public Map<String, String> getValByRegex(String regex) {
        Pattern p = Pattern.compile(regex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            Matcher m3;
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String) || !(m3 = p.matcher((String)item.getKey())).find()) continue;
            result.put((String)item.getKey(), this.substituteVars(this.getProps().getProperty((String)item.getKey())));
        }
        return result;
    }

    public static void dumpDeprecatedKeys() {
        DeprecationContext deprecations = deprecationContext.get();
        for (Map.Entry<String, DeprecatedKeyInfo> entry : deprecations.getDeprecatedKeyMap().entrySet()) {
            StringBuilder newKeys = new StringBuilder();
            for (String newKey : entry.getValue().newKeys) {
                newKeys.append(newKey).append("\t");
            }
            System.out.println(entry.getKey() + "\t" + newKeys.toString());
        }
    }

    public static boolean hasWarnedDeprecation(String name) {
        DeprecationContext deprecations = deprecationContext.get();
        return deprecations.getDeprecatedKeyMap().containsKey(name) && deprecations.getDeprecatedKeyMap().get(name).accessed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIntoUpdatingResource(String key, String[] value) {
        Map<String, String[]> localUR = this.updatingResource;
        if (localUR == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                localUR = this.updatingResource;
                if (localUR == null) {
                    this.updatingResource = localUR = new ConcurrentHashMap<String, String[]>(8);
                }
            }
        }
        localUR.put(key, value);
    }

    static {
        Configuration.addDefaultResource("core-default.xml");
        Configuration.addDefaultResource("core-site.xml");
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = Configuration.class.getClassLoader();
        }
        if (cL.getResource("hadoop-site.xml") != null) {
            LOG.warn("DEPRECATED: hadoop-site.xml found in the classpath. Usage of hadoop-site.xml is deprecated. Instead use core-site.xml, mapred-site.xml and hdfs-site.xml to override properties of core-default.xml, mapred-default.xml and hdfs-default.xml respectively");
            Configuration.addDefaultResource("hadoop-site.xml");
        }
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }

    public static class IntegerRanges
    implements Iterable<Integer> {
        List<Range> ranges = new ArrayList<Range>();

        public IntegerRanges() {
        }

        public IntegerRanges(String newValue) {
            StringTokenizer itr = new StringTokenizer(newValue, ",");
            while (itr.hasMoreTokens()) {
                String rng = itr.nextToken().trim();
                String[] parts = rng.split("-", 3);
                if (parts.length < 1 || parts.length > 2) {
                    throw new IllegalArgumentException("integer range badly formed: " + rng);
                }
                Range r = new Range();
                r.start = IntegerRanges.convertToInt(parts[0], 0);
                r.end = parts.length == 2 ? IntegerRanges.convertToInt(parts[1], Integer.MAX_VALUE) : r.start;
                if (r.start > r.end) {
                    throw new IllegalArgumentException("IntegerRange from " + r.start + " to " + r.end + " is invalid");
                }
                this.ranges.add(r);
            }
        }

        private static int convertToInt(String value, int defaultValue) {
            String trim = value.trim();
            if (trim.length() == 0) {
                return defaultValue;
            }
            return Integer.parseInt(trim);
        }

        public boolean isIncluded(int value) {
            for (Range r : this.ranges) {
                if (r.start > value || value > r.end) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.ranges == null || this.ranges.isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Range r : this.ranges) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(r.start);
                result.append('-');
                result.append(r.end);
            }
            return result.toString();
        }

        public int getRangeStart() {
            if (this.ranges == null || this.ranges.isEmpty()) {
                return -1;
            }
            Range r = this.ranges.get(0);
            return r.start;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeNumberIterator(this.ranges);
        }

        private static class RangeNumberIterator
        implements Iterator<Integer> {
            Iterator<Range> internal;
            int at;
            int end;

            public RangeNumberIterator(List<Range> ranges) {
                if (ranges != null) {
                    this.internal = ranges.iterator();
                }
                this.at = -1;
                this.end = -2;
            }

            @Override
            public boolean hasNext() {
                if (this.at <= this.end) {
                    return true;
                }
                if (this.internal != null) {
                    return this.internal.hasNext();
                }
                return false;
            }

            @Override
            public Integer next() {
                Range found;
                if (this.at <= this.end) {
                    ++this.at;
                    return this.at - 1;
                }
                if (this.internal != null && (found = this.internal.next()) != null) {
                    this.at = found.start;
                    this.end = found.end;
                    ++this.at;
                    return this.at - 1;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private static class Range {
            int start;
            int end;

            private Range() {
            }
        }
    }

    static enum ParsedTimeDuration {
        NS{

            @Override
            TimeUnit unit() {
                return TimeUnit.NANOSECONDS;
            }

            @Override
            String suffix() {
                return "ns";
            }
        }
        ,
        US{

            @Override
            TimeUnit unit() {
                return TimeUnit.MICROSECONDS;
            }

            @Override
            String suffix() {
                return "us";
            }
        }
        ,
        MS{

            @Override
            TimeUnit unit() {
                return TimeUnit.MILLISECONDS;
            }

            @Override
            String suffix() {
                return "ms";
            }
        }
        ,
        S{

            @Override
            TimeUnit unit() {
                return TimeUnit.SECONDS;
            }

            @Override
            String suffix() {
                return "s";
            }
        }
        ,
        M{

            @Override
            TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            @Override
            String suffix() {
                return "m";
            }
        }
        ,
        H{

            @Override
            TimeUnit unit() {
                return TimeUnit.HOURS;
            }

            @Override
            String suffix() {
                return "h";
            }
        }
        ,
        D{

            @Override
            TimeUnit unit() {
                return TimeUnit.DAYS;
            }

            @Override
            String suffix() {
                return "d";
            }
        };


        abstract TimeUnit unit();

        abstract String suffix();

        static ParsedTimeDuration unitFor(String s2) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (!s2.endsWith(ptd.suffix())) continue;
                return ptd;
            }
            return null;
        }

        static ParsedTimeDuration unitFor(TimeUnit unit) {
            for (ParsedTimeDuration ptd : ParsedTimeDuration.values()) {
                if (ptd.unit() != unit) continue;
                return ptd;
            }
            return null;
        }
    }

    private static class DeprecationContext {
        private final Map<String, DeprecatedKeyInfo> deprecatedKeyMap;
        private final Map<String, String> reverseDeprecatedKeyMap;

        DeprecationContext(DeprecationContext other, DeprecationDelta[] deltas) {
            HashMap<String, DeprecatedKeyInfo> newDeprecatedKeyMap = new HashMap<String, DeprecatedKeyInfo>();
            HashMap<String, Object> newReverseDeprecatedKeyMap = new HashMap<String, Object>();
            if (other != null) {
                for (Map.Entry<String, DeprecatedKeyInfo> entry : other.deprecatedKeyMap.entrySet()) {
                    newDeprecatedKeyMap.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : other.reverseDeprecatedKeyMap.entrySet()) {
                    newReverseDeprecatedKeyMap.put(entry.getKey(), entry.getValue());
                }
            }
            for (DeprecationDelta delta : deltas) {
                if (newDeprecatedKeyMap.containsKey(delta.getKey())) continue;
                DeprecatedKeyInfo newKeyInfo = new DeprecatedKeyInfo(delta.getNewKeys(), delta.getCustomMessage());
                newDeprecatedKeyMap.put(delta.key, newKeyInfo);
                for (String newKey : delta.getNewKeys()) {
                    newReverseDeprecatedKeyMap.put(newKey, delta.key);
                }
            }
            this.deprecatedKeyMap = UnmodifiableMap.decorate(newDeprecatedKeyMap);
            this.reverseDeprecatedKeyMap = UnmodifiableMap.decorate(newReverseDeprecatedKeyMap);
        }

        Map<String, DeprecatedKeyInfo> getDeprecatedKeyMap() {
            return this.deprecatedKeyMap;
        }

        Map<String, String> getReverseDeprecatedKeyMap() {
            return this.reverseDeprecatedKeyMap;
        }
    }

    public static class DeprecationDelta {
        private final String key;
        private final String[] newKeys;
        private final String customMessage;

        DeprecationDelta(String key, String[] newKeys, String customMessage) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(newKeys);
            Preconditions.checkArgument(newKeys.length > 0);
            this.key = key;
            this.newKeys = newKeys;
            this.customMessage = customMessage;
        }

        public DeprecationDelta(String key, String newKey, String customMessage) {
            this(key, new String[]{newKey}, customMessage);
        }

        public DeprecationDelta(String key, String newKey) {
            this(key, new String[]{newKey}, null);
        }

        public String getKey() {
            return this.key;
        }

        public String[] getNewKeys() {
            return this.newKeys;
        }

        public String getCustomMessage() {
            return this.customMessage;
        }
    }

    private static class DeprecatedKeyInfo {
        private final String[] newKeys;
        private final String customMessage;
        private final AtomicBoolean accessed = new AtomicBoolean(false);

        DeprecatedKeyInfo(String[] newKeys, String customMessage) {
            this.newKeys = newKeys;
            this.customMessage = customMessage;
        }

        private final String getWarningMessage(String key) {
            return this.getWarningMessage(key, null);
        }

        private String getWarningMessage(String key, String source) {
            String warningMessage;
            if (this.customMessage == null) {
                StringBuilder message = new StringBuilder(key);
                if (source != null) {
                    message.append(" in " + source);
                }
                message.append(" is deprecated. Instead, use ");
                for (int i = 0; i < this.newKeys.length; ++i) {
                    message.append(this.newKeys[i]);
                    if (i == this.newKeys.length - 1) continue;
                    message.append(", ");
                }
                warningMessage = message.toString();
            } else {
                warningMessage = this.customMessage;
            }
            return warningMessage;
        }

        boolean getAndSetAccessed() {
            return this.accessed.getAndSet(true);
        }

        public void clearAccessed() {
            this.accessed.set(false);
        }
    }

    private static class Resource {
        private final Object resource;
        private final String name;
        private final boolean restrictParser;

        public Resource(Object resource) {
            this(resource, resource.toString());
        }

        public Resource(Object resource, boolean useRestrictedParser) {
            this(resource, resource.toString(), useRestrictedParser);
        }

        public Resource(Object resource, String name) {
            this(resource, name, Resource.getRestrictParserDefault(resource));
        }

        public Resource(Object resource, String name, boolean restrictParser) {
            this.resource = resource;
            this.name = name;
            this.restrictParser = restrictParser;
        }

        public String getName() {
            return this.name;
        }

        public Object getResource() {
            return this.resource;
        }

        public boolean isParserRestricted() {
            return this.restrictParser;
        }

        public String toString() {
            return this.name;
        }

        private static boolean getRestrictParserDefault(Object resource) {
            UserGroupInformation user;
            if (resource instanceof String || !UserGroupInformation.isInitialized()) {
                return false;
            }
            try {
                user = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to determine current user", e);
            }
            return user.getRealUser() != null;
        }
    }
}

