// ~~~~~~~~~ EXPORT CHART CODE ~~~~~~~~~

const VIS_EXPORTS = `# Generated by AutoProfiler

import altair as alt`
const disableMaxRowsCode = 'alt.data_transformers.disable_max_rows()'

export const QUANT_CHART = (
    df_name: string,
    col_name: string,
    numbins = 8
) => `${VIS_EXPORTS} 
binned_series = ${df_name}["${col_name}"].value_counts(bins=${numbins}, sort=False)

chart_data_binned = pd.DataFrame({
    "leftbin": binned_series.index.left, 
    "rightbin": binned_series.index.right, 
    "count": binned_series.values
})

# move leftmost bin edge up since pandas does not put edge at the min
chart_data_binned.loc[0, "leftbin"] = ${df_name}["${col_name}"].min()

quant_chart = alt.Chart(chart_data_binned).mark_bar(color="#fca5a5").encode(
    x = alt.X("leftbin", bin="binned", title="${col_name} (binned)"),
    x2 = "rightbin",
    y = alt.Y("count")
).properties(
    width=500,
    height=200
)

quant_chart`;

export const CAT_CHART = (
    df_name: string,
    col_name: string,
    k = 10
) => `${VIS_EXPORTS}
topk_series = ${df_name}["${col_name}"].value_counts().iloc[:${k}]
topk_df = pd.DataFrame({"${col_name}":topk_series.index, 'count':topk_series.values})

cat_chart = alt.Chart(topk_df).mark_bar(color="#bae6fd").encode( 
    x = alt.X("count"),
    y = alt.Y("${col_name}", sort="-x")
).properties(
    width=500,
    height=200
)

cat_chart`;


export const TEMPORAL_CHART = (
    df_name: string,
    col_name: string,
    shouldDisableMaxRows = false
) => `${VIS_EXPORTS}
${shouldDisableMaxRows ? disableMaxRowsCode : ""}
temporal_chart = alt.Chart(${df_name}).mark_line(color="#14b8a6").encode(
    x='${col_name}:T',
    y='count()'
).properties(
    width=500,
    height=200
)

temporal_chart`;
