# Autogenerated constants for HID Keyboard service
from enum import IntEnum
from jacdac.constants import *
JD_SERVICE_CLASS_HID_KEYBOARD = const(0x18b05b6a)


class HidKeyboardModifiers(IntEnum):
    NONE = const(0x0)
    LEFT_CONTROL = const(0x1)
    LEFT_SHIFT = const(0x2)
    LEFT_ALT = const(0x4)
    LEFT_GUI = const(0x8)
    RIGHT_CONTROL = const(0x10)
    RIGHT_SHIFT = const(0x20)
    RIGHT_ALT = const(0x40)
    RIGHT_GUI = const(0x80)


class HidKeyboardAction(IntEnum):
    PRESS = const(0x0)
    UP = const(0x1)
    DOWN = const(0x2)


JD_HID_KEYBOARD_CMD_KEY = const(0x80)
JD_HID_KEYBOARD_CMD_CLEAR = const(0x81)
JD_HID_KEYBOARD_PACK_FORMATS = {
    JD_HID_KEYBOARD_CMD_KEY: "r: u16 u8 u8"
}
