# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class HidJoystickClient(Client):
    """
    Controls a HID joystick.
    Implements a client for the `HID Joystick <https://microsoft.github.io/jacdac-docs/services/hidjoystick>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_HID_JOYSTICK, JD_HID_JOYSTICK_PACK_FORMATS, role)


    @property
    def button_count(self) -> Optional[int]:
        """
        Number of button report supported, 
        """
        return self.register(JD_HID_JOYSTICK_REG_BUTTON_COUNT).value()

    @property
    def buttons_analog(self) -> Optional[int]:
        """
        A bitset that indicates which button is analog., 
        """
        return self.register(JD_HID_JOYSTICK_REG_BUTTONS_ANALOG).value()

    @property
    def axis_count(self) -> Optional[int]:
        """
        Number of analog input supported, 
        """
        return self.register(JD_HID_JOYSTICK_REG_AXIS_COUNT).value()

    
