# Generated by Django 3.2.9 on 2022-03-17 15:10

import ckeditor.fields
import ddm.models.questions
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='DonationBlueprint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
                ('exp_file_format', models.CharField(choices=[('json', 'Json Format')], default='json', max_length=10)),
                ('expected_fields', models.JSONField()),
                ('extracted_fields', models.JSONField()),
                ('regex_path', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DonationProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('slug', models.SlugField(unique=True, verbose_name='External Project Slug')),
                ('intro_text', ckeditor.fields.RichTextField(blank=True, null=True)),
                ('outro_text', ckeditor.fields.RichTextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Participant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField(null=True)),
                ('completed', models.BooleanField(default=False)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationproject')),
            ],
        ),
        migrations.CreateModel(
            name='QuestionBase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('question_type', models.CharField(choices=[('generic', 'Generic Question'), ('single_choice', 'Single Choice Question'), ('multi_choice', 'Multi Choice Question'), ('matrix', 'Matrix Question'), ('semantic_diff', 'Semantic Differential'), ('open', 'Open Question'), ('transition', 'Transition Block')], default='generic', max_length=20)),
                ('name', models.CharField(max_length=255)),
                ('index', models.PositiveIntegerField(default=1)),
                ('variable_name', models.SlugField()),
                ('text', ckeditor.fields.RichTextField(blank=True, null=True)),
                ('required', models.BooleanField(default=False)),
                ('blueprint', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationblueprint')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_ddm.questionbase_set+', to='contenttypes.contenttype')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationproject')),
            ],
            options={
                'ordering': ['index'],
            },
        ),
        migrations.CreateModel(
            name='MatrixQuestion',
            fields=[
                ('questionbase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='ddm.questionbase')),
                ('randomize_items', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=(ddm.models.questions.ScaleMixin, 'ddm.questionbase', models.Model),
        ),
        migrations.CreateModel(
            name='MultiChoiceQuestion',
            fields=[
                ('questionbase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='ddm.questionbase')),
                ('randomize_items', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=('ddm.questionbase', models.Model),
        ),
        migrations.CreateModel(
            name='OpenQuestion',
            fields=[
                ('questionbase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='ddm.questionbase')),
                ('display', models.CharField(choices=[('small', 'Small'), ('large', 'Large')], default='large', max_length=20)),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('ddm.questionbase',),
        ),
        migrations.CreateModel(
            name='SemanticDifferential',
            fields=[
                ('questionbase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='ddm.questionbase')),
                ('randomize_items', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=(ddm.models.questions.ScaleMixin, 'ddm.questionbase', models.Model),
        ),
        migrations.CreateModel(
            name='SingleChoiceQuestion',
            fields=[
                ('questionbase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='ddm.questionbase')),
                ('randomize_items', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
            bases=('ddm.questionbase', models.Model),
        ),
        migrations.CreateModel(
            name='Transition',
            fields=[
                ('questionbase_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='ddm.questionbase')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('ddm.questionbase',),
        ),
        migrations.CreateModel(
            name='ZippedBlueprint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationproject')),
            ],
        ),
        migrations.CreateModel(
            name='ScalePoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('index', models.IntegerField()),
                ('label', models.CharField(blank=True, max_length=100, null=True)),
                ('value', models.IntegerField()),
                ('add_border', models.BooleanField(default=False)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.questionbase')),
            ],
            options={
                'ordering': ['index'],
            },
        ),
        migrations.CreateModel(
            name='QuestionnaireResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_submitted', models.DateTimeField()),
                ('data', models.JSONField()),
                ('participant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.participant')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationproject')),
            ],
        ),
        migrations.CreateModel(
            name='QuestionItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(blank=True, max_length=255, null=True)),
                ('label_alt', models.CharField(blank=True, max_length=255, null=True)),
                ('index', models.IntegerField()),
                ('value', models.IntegerField()),
                ('randomize', models.BooleanField(default=False)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.questionbase')),
            ],
            options={
                'ordering': ['index'],
            },
        ),
        migrations.CreateModel(
            name='DonationInstruction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', ckeditor.fields.RichTextField(blank=True, null=True)),
                ('index', models.PositiveIntegerField(default=1)),
                ('blueprint', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='ddm.donationblueprint')),
                ('zip_blueprint', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='ddm.zippedblueprint')),
            ],
            options={
                'ordering': ['index'],
            },
        ),
        migrations.AddField(
            model_name='donationblueprint',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationproject'),
        ),
        migrations.AddField(
            model_name='donationblueprint',
            name='zip_blueprint',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ddm.zippedblueprint'),
        ),
        migrations.CreateModel(
            name='DataDonation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time', models.DateTimeField()),
                ('consent', models.BooleanField(default=False)),
                ('status', models.JSONField()),
                ('data', models.JSONField()),
                ('blueprint', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='ddm.donationblueprint')),
                ('participant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.participant')),
                ('project', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ddm.donationproject')),
            ],
        ),
        migrations.AddConstraint(
            model_name='scalepoint',
            constraint=models.UniqueConstraint(fields=('index', 'question'), name='unique_index_per_question'),
        ),
        migrations.AddConstraint(
            model_name='questionbase',
            constraint=models.UniqueConstraint(fields=('variable_name', 'project'), name='unique_varname_per_project'),
        ),
        migrations.AddConstraint(
            model_name='donationinstruction',
            constraint=models.UniqueConstraint(fields=('index', 'blueprint'), name='unique_index_per_blueprint'),
        ),
        migrations.AddConstraint(
            model_name='donationinstruction',
            constraint=models.UniqueConstraint(fields=('index', 'zip_blueprint'), name='unique_index_per_zipblueprint'),
        ),
    ]
