# -*- coding: utf-8 -*-
#
#
# TheVirtualBrain-Framework Package. This package holds all Data Management, and
# Web-UI helpful to run brain-simulations. To use it, you also need to download
# TheVirtualBrain-Scientific Package (for simulators). See content of the
# documentation-folder for more details. See also http://www.thevirtualbrain.org
#
# (c) 2012-2023, Baycrest Centre for Geriatric Care ("Baycrest") and others
#
# This program is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software Foundation,
# either version 3 of the License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.  See the GNU General Public License for more details.
# You should have received a copy of the GNU General Public License along with this
# program.  If not, see <http://www.gnu.org/licenses/>.
#
#
#   CITATION:
# When using The Virtual Brain for scientific publications, please cite it as explained here:
# https://www.thevirtualbrain.org/tvb/zwei/neuroscience-publications
#
#

"""
.. moduleauthor:: Robert Vincze <robert.vincze@codemart.ro>
.. moduleauthor:: Paula Popa <paula.popa@codemart.ro>
"""

from tvb.core.entities.transient.structure_entities import DataTypeMetaData
from tvb.core.neotraits.view_model import ViewModel, Str


class UploaderViewModel(ViewModel):
    REQUIRED_TYPE = None

    data_subject = Str(
        default=DataTypeMetaData.DEFAULT_SUBJECT,
        label='Subject'
    )

    encrypted_aes_key = Str(
        required=False,
        label='Encrypted AES Password (if your files come encrypted)',
        doc='Check our demo notebook on how to produce this key and how we expect your files to be encrypted'
    )
