# MergeHRISClient
The unified API for building rich integrations with multiple HR Information System platforms.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.merge.dev/](https://www.merge.dev/)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/merge-api/merge-hris-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/merge-api/merge-hris-python.git`)

Then import the package:
```python
import MergeHRISClient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import MergeHRISClient
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import MergeHRISClient
from pprint import pprint
from MergeHRISClient.api import account_details_api
from MergeHRISClient.model.account_details import AccountDetails
# Defining the host is optional and defaults to https://api.merge.dev/api/hris/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = MergeHRISClient.Configuration(
    host = "https://api.merge.dev/api/hris/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: tokenAuth
configuration.api_key['tokenAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['tokenAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with MergeHRISClient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = account_details_api.AccountDetailsApi(api_client)
    
    try:
        api_response = api_instance.account_details_retrieve()
        pprint(api_response)
    except MergeHRISClient.ApiException as e:
        print("Exception when calling AccountDetailsApi->account_details_retrieve: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.merge.dev/api/hris/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountDetailsApi* | [**account_details_retrieve**](docs/AccountDetailsApi.md#account_details_retrieve) | **GET** /account-details | 
*AccountTokenApi* | [**account_token_retrieve**](docs/AccountTokenApi.md#account_token_retrieve) | **GET** /account-token/{public_token} | 
*AvailableActionsApi* | [**available_actions_retrieve**](docs/AvailableActionsApi.md#available_actions_retrieve) | **GET** /available-actions | 
*BankInfoApi* | [**bank_info_list**](docs/BankInfoApi.md#bank_info_list) | **GET** /bank-info | 
*BankInfoApi* | [**bank_info_retrieve**](docs/BankInfoApi.md#bank_info_retrieve) | **GET** /bank-info/{id} | 
*BenefitsApi* | [**benefits_list**](docs/BenefitsApi.md#benefits_list) | **GET** /benefits | 
*BenefitsApi* | [**benefits_retrieve**](docs/BenefitsApi.md#benefits_retrieve) | **GET** /benefits/{id} | 
*CompaniesApi* | [**companies_list**](docs/CompaniesApi.md#companies_list) | **GET** /companies | 
*CompaniesApi* | [**companies_retrieve**](docs/CompaniesApi.md#companies_retrieve) | **GET** /companies/{id} | 
*DeductionsApi* | [**deductions_list**](docs/DeductionsApi.md#deductions_list) | **GET** /deductions | 
*DeductionsApi* | [**deductions_retrieve**](docs/DeductionsApi.md#deductions_retrieve) | **GET** /deductions/{id} | 
*DeleteAccountApi* | [**delete_account_create**](docs/DeleteAccountApi.md#delete_account_create) | **POST** /delete-account | 
*EmployeePayrollRunsApi* | [**employee_payroll_runs_list**](docs/EmployeePayrollRunsApi.md#employee_payroll_runs_list) | **GET** /employee-payroll-runs | 
*EmployeePayrollRunsApi* | [**employee_payroll_runs_retrieve**](docs/EmployeePayrollRunsApi.md#employee_payroll_runs_retrieve) | **GET** /employee-payroll-runs/{id} | 
*EmployeesApi* | [**employees_list**](docs/EmployeesApi.md#employees_list) | **GET** /employees | 
*EmployeesApi* | [**employees_retrieve**](docs/EmployeesApi.md#employees_retrieve) | **GET** /employees/{id} | 
*EmploymentsApi* | [**employments_list**](docs/EmploymentsApi.md#employments_list) | **GET** /employments | 
*EmploymentsApi* | [**employments_retrieve**](docs/EmploymentsApi.md#employments_retrieve) | **GET** /employments/{id} | 
*ForceResyncApi* | [**sync_status_resync_create**](docs/ForceResyncApi.md#sync_status_resync_create) | **POST** /sync-status/resync | 
*GenerateKeyApi* | [**generate_key_create**](docs/GenerateKeyApi.md#generate_key_create) | **POST** /generate-key | 
*IssuesApi* | [**issues_list**](docs/IssuesApi.md#issues_list) | **GET** /issues | 
*IssuesApi* | [**issues_retrieve**](docs/IssuesApi.md#issues_retrieve) | **GET** /issues/{id} | 
*LinkTokenApi* | [**link_token_create**](docs/LinkTokenApi.md#link_token_create) | **POST** /link-token | 
*LinkedAccountsApi* | [**linked_accounts_list**](docs/LinkedAccountsApi.md#linked_accounts_list) | **GET** /linked-accounts | 
*LocationsApi* | [**locations_list**](docs/LocationsApi.md#locations_list) | **GET** /locations | 
*LocationsApi* | [**locations_retrieve**](docs/LocationsApi.md#locations_retrieve) | **GET** /locations/{id} | 
*PassthroughApi* | [**passthrough_create**](docs/PassthroughApi.md#passthrough_create) | **POST** /passthrough | 
*PayGroupsApi* | [**pay_groups_list**](docs/PayGroupsApi.md#pay_groups_list) | **GET** /pay-groups | 
*PayGroupsApi* | [**pay_groups_retrieve**](docs/PayGroupsApi.md#pay_groups_retrieve) | **GET** /pay-groups/{id} | 
*PayrollRunsApi* | [**payroll_runs_list**](docs/PayrollRunsApi.md#payroll_runs_list) | **GET** /payroll-runs | 
*PayrollRunsApi* | [**payroll_runs_retrieve**](docs/PayrollRunsApi.md#payroll_runs_retrieve) | **GET** /payroll-runs/{id} | 
*RegenerateKeyApi* | [**regenerate_key_create**](docs/RegenerateKeyApi.md#regenerate_key_create) | **POST** /regenerate-key | 
*SyncStatusApi* | [**sync_status_list**](docs/SyncStatusApi.md#sync_status_list) | **GET** /sync-status | 
*TeamsApi* | [**teams_list**](docs/TeamsApi.md#teams_list) | **GET** /teams | 
*TeamsApi* | [**teams_retrieve**](docs/TeamsApi.md#teams_retrieve) | **GET** /teams/{id} | 
*TimeOffApi* | [**time_off_create**](docs/TimeOffApi.md#time_off_create) | **POST** /time-off | 
*TimeOffApi* | [**time_off_list**](docs/TimeOffApi.md#time_off_list) | **GET** /time-off | 
*TimeOffApi* | [**time_off_retrieve**](docs/TimeOffApi.md#time_off_retrieve) | **GET** /time-off/{id} | 
*TimeOffBalancesApi* | [**time_off_balances_list**](docs/TimeOffBalancesApi.md#time_off_balances_list) | **GET** /time-off-balances | 
*TimeOffBalancesApi* | [**time_off_balances_retrieve**](docs/TimeOffBalancesApi.md#time_off_balances_retrieve) | **GET** /time-off-balances/{id} | 


## Documentation For Models

 - [AccountDetails](docs/AccountDetails.md)
 - [AccountDetailsAndActions](docs/AccountDetailsAndActions.md)
 - [AccountDetailsAndActionsIntegration](docs/AccountDetailsAndActionsIntegration.md)
 - [AccountDetailsAndActionsStatusEnum](docs/AccountDetailsAndActionsStatusEnum.md)
 - [AccountIntegration](docs/AccountIntegration.md)
 - [AccountToken](docs/AccountToken.md)
 - [AccountTypeEnum](docs/AccountTypeEnum.md)
 - [AvailableActions](docs/AvailableActions.md)
 - [BankInfo](docs/BankInfo.md)
 - [Benefit](docs/Benefit.md)
 - [BenefitPlanTypeEnum](docs/BenefitPlanTypeEnum.md)
 - [CategoriesEnum](docs/CategoriesEnum.md)
 - [CategoryEnum](docs/CategoryEnum.md)
 - [Company](docs/Company.md)
 - [CountryEnum](docs/CountryEnum.md)
 - [DataPassthroughRequest](docs/DataPassthroughRequest.md)
 - [Deduction](docs/Deduction.md)
 - [Earning](docs/Earning.md)
 - [Employee](docs/Employee.md)
 - [EmployeePayrollRun](docs/EmployeePayrollRun.md)
 - [Employment](docs/Employment.md)
 - [EmploymentStatusEnum](docs/EmploymentStatusEnum.md)
 - [EmploymentTypeEnum](docs/EmploymentTypeEnum.md)
 - [EndUserDetailsRequest](docs/EndUserDetailsRequest.md)
 - [ErrorValidationProblem](docs/ErrorValidationProblem.md)
 - [EthnicityEnum](docs/EthnicityEnum.md)
 - [FlsaStatusEnum](docs/FlsaStatusEnum.md)
 - [GenderEnum](docs/GenderEnum.md)
 - [GenerateRemoteKeyRequest](docs/GenerateRemoteKeyRequest.md)
 - [Issue](docs/Issue.md)
 - [IssueStatusEnum](docs/IssueStatusEnum.md)
 - [LinkToken](docs/LinkToken.md)
 - [Location](docs/Location.md)
 - [MaritalStatusEnum](docs/MaritalStatusEnum.md)
 - [MethodEnum](docs/MethodEnum.md)
 - [ModelOperation](docs/ModelOperation.md)
 - [PaginatedAccountDetailsAndActionsList](docs/PaginatedAccountDetailsAndActionsList.md)
 - [PaginatedBankInfoList](docs/PaginatedBankInfoList.md)
 - [PaginatedBenefitList](docs/PaginatedBenefitList.md)
 - [PaginatedCompanyList](docs/PaginatedCompanyList.md)
 - [PaginatedDeductionList](docs/PaginatedDeductionList.md)
 - [PaginatedEmployeeList](docs/PaginatedEmployeeList.md)
 - [PaginatedEmployeePayrollRunList](docs/PaginatedEmployeePayrollRunList.md)
 - [PaginatedEmploymentList](docs/PaginatedEmploymentList.md)
 - [PaginatedIssueList](docs/PaginatedIssueList.md)
 - [PaginatedLocationList](docs/PaginatedLocationList.md)
 - [PaginatedPayGroupList](docs/PaginatedPayGroupList.md)
 - [PaginatedPayrollRunList](docs/PaginatedPayrollRunList.md)
 - [PaginatedSyncStatusList](docs/PaginatedSyncStatusList.md)
 - [PaginatedTeamList](docs/PaginatedTeamList.md)
 - [PaginatedTimeOffBalanceList](docs/PaginatedTimeOffBalanceList.md)
 - [PaginatedTimeOffList](docs/PaginatedTimeOffList.md)
 - [PayCurrencyEnum](docs/PayCurrencyEnum.md)
 - [PayFrequencyEnum](docs/PayFrequencyEnum.md)
 - [PayGroup](docs/PayGroup.md)
 - [PayPeriodEnum](docs/PayPeriodEnum.md)
 - [PayrollRun](docs/PayrollRun.md)
 - [PolicyTypeEnum](docs/PolicyTypeEnum.md)
 - [RemoteData](docs/RemoteData.md)
 - [RemoteDataRequest](docs/RemoteDataRequest.md)
 - [RemoteKey](docs/RemoteKey.md)
 - [RemoteKeyForRegenerationRequest](docs/RemoteKeyForRegenerationRequest.md)
 - [RemoteResponse](docs/RemoteResponse.md)
 - [RequestFormatEnum](docs/RequestFormatEnum.md)
 - [RequestTypeEnum](docs/RequestTypeEnum.md)
 - [RunStateEnum](docs/RunStateEnum.md)
 - [RunTypeEnum](docs/RunTypeEnum.md)
 - [SyncStatus](docs/SyncStatus.md)
 - [SyncStatusStatusEnum](docs/SyncStatusStatusEnum.md)
 - [Tax](docs/Tax.md)
 - [Team](docs/Team.md)
 - [TimeOff](docs/TimeOff.md)
 - [TimeOffBalance](docs/TimeOffBalance.md)
 - [TimeOffEndpointRequest](docs/TimeOffEndpointRequest.md)
 - [TimeOffRequest](docs/TimeOffRequest.md)
 - [TimeOffResponse](docs/TimeOffResponse.md)
 - [TimeOffStatusEnum](docs/TimeOffStatusEnum.md)
 - [TypeEnum](docs/TypeEnum.md)
 - [UnitsEnum](docs/UnitsEnum.md)
 - [ValidationProblemSource](docs/ValidationProblemSource.md)
 - [WarningValidationProblem](docs/WarningValidationProblem.md)


## Documentation For Authorization


## tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

hello@merge.dev


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in MergeHRISClient.apis and MergeHRISClient.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from MergeHRISClient.api.default_api import DefaultApi`
- `from MergeHRISClient.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import MergeHRISClient
from MergeHRISClient.apis import *
from MergeHRISClient.models import *
```

