# -*- coding: utf-8 -*-
#
# Copyright (c) 2015, Alcatel-Lucent Inc, 2017 Nokia
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of its contributors
#       may be used to endorse or promote products derived from this software without
#       specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.




from .fetchers import NUPermissionsFetcher


from .fetchers import NUMetadatasFetcher


from .fetchers import NUGlobalMetadatasFetcher

from bambou import NURESTObject


class NUInfrastructureVscProfile(NURESTObject):
    """ Represents a InfrastructureVscProfile in the VSD

        Notes:
            Infrastructure VSC Profiles identify a set of controllers which will be used to connect bootstrapped NSGs.
    """

    __rest_name__ = "infrastructurevscprofile"
    __resource_name__ = "infrastructurevscprofiles"

    
    ## Constants
    
    CONST_ADDRESS_FAMILY_DUALSTACK = "DUALSTACK"
    
    CONST_ENTITY_SCOPE_GLOBAL = "GLOBAL"
    
    CONST_ADDRESS_FAMILY_IPV6 = "IPV6"
    
    CONST_ADDRESS_FAMILY_IPV4 = "IPV4"
    
    CONST_ENTITY_SCOPE_ENTERPRISE = "ENTERPRISE"
    
    

    def __init__(self, **kwargs):
        """ Initializes a InfrastructureVscProfile instance

            Notes:
                You can specify all parameters while calling this methods.
                A special argument named `data` will enable you to load the
                object from a Python dictionary

            Examples:
                >>> infrastructurevscprofile = NUInfrastructureVscProfile(id=u'xxxx-xxx-xxx-xxx', name=u'InfrastructureVscProfile')
                >>> infrastructurevscprofile = NUInfrastructureVscProfile(data=my_dict)
        """

        super(NUInfrastructureVscProfile, self).__init__()

        # Read/Write Attributes
        
        self._name = None
        self._last_updated_by = None
        self._last_updated_date = None
        self._address_family = None
        self._second_controller = None
        self._second_controller_v6 = None
        self._description = None
        self._first_controller = None
        self._first_controller_v6 = None
        self._embedded_metadata = None
        self._enterprise_id = None
        self._entity_scope = None
        self._creation_date = None
        self._probe_interval = None
        self._owner = None
        self._external_id = None
        
        self.expose_attribute(local_name="name", remote_name="name", attribute_type=str, is_required=True, is_unique=False)
        self.expose_attribute(local_name="last_updated_by", remote_name="lastUpdatedBy", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_updated_date", remote_name="lastUpdatedDate", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="address_family", remote_name="addressFamily", attribute_type=str, is_required=False, is_unique=False, choices=[u'DUALSTACK', u'IPV4', u'IPV6'])
        self.expose_attribute(local_name="second_controller", remote_name="secondController", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="second_controller_v6", remote_name="secondControllerV6", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="description", remote_name="description", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="first_controller", remote_name="firstController", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="first_controller_v6", remote_name="firstControllerV6", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="embedded_metadata", remote_name="embeddedMetadata", attribute_type=list, is_required=False, is_unique=False)
        self.expose_attribute(local_name="enterprise_id", remote_name="enterpriseID", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="entity_scope", remote_name="entityScope", attribute_type=str, is_required=False, is_unique=False, choices=[u'ENTERPRISE', u'GLOBAL'])
        self.expose_attribute(local_name="creation_date", remote_name="creationDate", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="probe_interval", remote_name="probeInterval", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="owner", remote_name="owner", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="external_id", remote_name="externalID", attribute_type=str, is_required=False, is_unique=True)
        

        # Fetchers
        
        
        self.permissions = NUPermissionsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.metadatas = NUMetadatasFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.global_metadatas = NUGlobalMetadatasFetcher.fetcher_with_object(parent_object=self, relationship="child")
        

        self._compute_args(**kwargs)

    # Properties
    
    @property
    def name(self):
        """ Get name value.

            Notes:
                Name of the Infrastructure VSC Profile

                
        """
        return self._name

    @name.setter
    def name(self, value):
        """ Set name value.

            Notes:
                Name of the Infrastructure VSC Profile

                
        """
        self._name = value

    
    @property
    def last_updated_by(self):
        """ Get last_updated_by value.

            Notes:
                ID of the user who last updated the object.

                
                This attribute is named `lastUpdatedBy` in VSD API.
                
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, value):
        """ Set last_updated_by value.

            Notes:
                ID of the user who last updated the object.

                
                This attribute is named `lastUpdatedBy` in VSD API.
                
        """
        self._last_updated_by = value

    
    @property
    def last_updated_date(self):
        """ Get last_updated_date value.

            Notes:
                Time stamp when this object was last updated.

                
                This attribute is named `lastUpdatedDate` in VSD API.
                
        """
        return self._last_updated_date

    @last_updated_date.setter
    def last_updated_date(self, value):
        """ Set last_updated_date value.

            Notes:
                Time stamp when this object was last updated.

                
                This attribute is named `lastUpdatedDate` in VSD API.
                
        """
        self._last_updated_date = value

    
    @property
    def address_family(self):
        """ Get address_family value.

            Notes:
                The type of IP address used in the identification of the active and standby controllers.

                
                This attribute is named `addressFamily` in VSD API.
                
        """
        return self._address_family

    @address_family.setter
    def address_family(self, value):
        """ Set address_family value.

            Notes:
                The type of IP address used in the identification of the active and standby controllers.

                
                This attribute is named `addressFamily` in VSD API.
                
        """
        self._address_family = value

    
    @property
    def second_controller(self):
        """ Get second_controller value.

            Notes:
                Second VSC Controller :  IP Address of the secondary VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `secondController` in VSD API.
                
        """
        return self._second_controller

    @second_controller.setter
    def second_controller(self, value):
        """ Set second_controller value.

            Notes:
                Second VSC Controller :  IP Address of the secondary VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `secondController` in VSD API.
                
        """
        self._second_controller = value

    
    @property
    def second_controller_v6(self):
        """ Get second_controller_v6 value.

            Notes:
                Second VSC Controller:  IPv6 address of the secondary VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `secondControllerV6` in VSD API.
                
        """
        return self._second_controller_v6

    @second_controller_v6.setter
    def second_controller_v6(self, value):
        """ Set second_controller_v6 value.

            Notes:
                Second VSC Controller:  IPv6 address of the secondary VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `secondControllerV6` in VSD API.
                
        """
        self._second_controller_v6 = value

    
    @property
    def description(self):
        """ Get description value.

            Notes:
                A description of the VSC Profile instance created.

                
        """
        return self._description

    @description.setter
    def description(self, value):
        """ Set description value.

            Notes:
                A description of the VSC Profile instance created.

                
        """
        self._description = value

    
    @property
    def first_controller(self):
        """ Get first_controller value.

            Notes:
                First VSC Controller :  IP Address of the first VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `firstController` in VSD API.
                
        """
        return self._first_controller

    @first_controller.setter
    def first_controller(self, value):
        """ Set first_controller value.

            Notes:
                First VSC Controller :  IP Address of the first VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `firstController` in VSD API.
                
        """
        self._first_controller = value

    
    @property
    def first_controller_v6(self):
        """ Get first_controller_v6 value.

            Notes:
                First VSC Controller: IPv6 address of the first VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `firstControllerV6` in VSD API.
                
        """
        return self._first_controller_v6

    @first_controller_v6.setter
    def first_controller_v6(self, value):
        """ Set first_controller_v6 value.

            Notes:
                First VSC Controller: IPv6 address of the first VSC system NSG instances associated to this profile will be reaching for.

                
                This attribute is named `firstControllerV6` in VSD API.
                
        """
        self._first_controller_v6 = value

    
    @property
    def embedded_metadata(self):
        """ Get embedded_metadata value.

            Notes:
                Metadata objects associated with this entity. This will contain a list of Metadata objects if the API request is made using the special flag to enable the embedded Metadata feature. Only a maximum of Metadata objects is returned based on the value set in the system configuration.

                
                This attribute is named `embeddedMetadata` in VSD API.
                
        """
        return self._embedded_metadata

    @embedded_metadata.setter
    def embedded_metadata(self, value):
        """ Set embedded_metadata value.

            Notes:
                Metadata objects associated with this entity. This will contain a list of Metadata objects if the API request is made using the special flag to enable the embedded Metadata feature. Only a maximum of Metadata objects is returned based on the value set in the system configuration.

                
                This attribute is named `embeddedMetadata` in VSD API.
                
        """
        self._embedded_metadata = value

    
    @property
    def enterprise_id(self):
        """ Get enterprise_id value.

            Notes:
                Enterprise/Organisation associated with this Profile instance.

                
                This attribute is named `enterpriseID` in VSD API.
                
        """
        return self._enterprise_id

    @enterprise_id.setter
    def enterprise_id(self, value):
        """ Set enterprise_id value.

            Notes:
                Enterprise/Organisation associated with this Profile instance.

                
                This attribute is named `enterpriseID` in VSD API.
                
        """
        self._enterprise_id = value

    
    @property
    def entity_scope(self):
        """ Get entity_scope value.

            Notes:
                Specify if scope of entity is Data center or Enterprise level

                
                This attribute is named `entityScope` in VSD API.
                
        """
        return self._entity_scope

    @entity_scope.setter
    def entity_scope(self, value):
        """ Set entity_scope value.

            Notes:
                Specify if scope of entity is Data center or Enterprise level

                
                This attribute is named `entityScope` in VSD API.
                
        """
        self._entity_scope = value

    
    @property
    def creation_date(self):
        """ Get creation_date value.

            Notes:
                Time stamp when this object was created.

                
                This attribute is named `creationDate` in VSD API.
                
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, value):
        """ Set creation_date value.

            Notes:
                Time stamp when this object was created.

                
                This attribute is named `creationDate` in VSD API.
                
        """
        self._creation_date = value

    
    @property
    def probe_interval(self):
        """ Get probe_interval value.

            Notes:
                Openflow echo timer in milliseconds.

                
                This attribute is named `probeInterval` in VSD API.
                
        """
        return self._probe_interval

    @probe_interval.setter
    def probe_interval(self, value):
        """ Set probe_interval value.

            Notes:
                Openflow echo timer in milliseconds.

                
                This attribute is named `probeInterval` in VSD API.
                
        """
        self._probe_interval = value

    
    @property
    def owner(self):
        """ Get owner value.

            Notes:
                Identifies the user that has created this object.

                
        """
        return self._owner

    @owner.setter
    def owner(self, value):
        """ Set owner value.

            Notes:
                Identifies the user that has created this object.

                
        """
        self._owner = value

    
    @property
    def external_id(self):
        """ Get external_id value.

            Notes:
                External object ID. Used for integration with third party systems

                
                This attribute is named `externalID` in VSD API.
                
        """
        return self._external_id

    @external_id.setter
    def external_id(self, value):
        """ Set external_id value.

            Notes:
                External object ID. Used for integration with third party systems

                
                This attribute is named `externalID` in VSD API.
                
        """
        self._external_id = value

    

    