# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class StartProcessInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'business_key': 'str',
        'variables': 'dict(str, VariableValueDto)',
        'case_instance_id': 'str',
        'start_instructions': 'list[ProcessInstanceModificationInstructionDto]',
        'skip_custom_listeners': 'bool',
        'skip_io_mappings': 'bool',
        'with_variables_in_return': 'bool'
    }

    attribute_map = {
        'business_key': 'businessKey',
        'variables': 'variables',
        'case_instance_id': 'caseInstanceId',
        'start_instructions': 'startInstructions',
        'skip_custom_listeners': 'skipCustomListeners',
        'skip_io_mappings': 'skipIoMappings',
        'with_variables_in_return': 'withVariablesInReturn'
    }

    def __init__(self, business_key=None, variables=None, case_instance_id=None, start_instructions=None, skip_custom_listeners=None, skip_io_mappings=None, with_variables_in_return=None, local_vars_configuration=None):  # noqa: E501
        """StartProcessInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._business_key = None
        self._variables = None
        self._case_instance_id = None
        self._start_instructions = None
        self._skip_custom_listeners = None
        self._skip_io_mappings = None
        self._with_variables_in_return = None
        self.discriminator = None

        if business_key is not None:
            self.business_key = business_key
        if variables is not None:
            self.variables = variables
        if case_instance_id is not None:
            self.case_instance_id = case_instance_id
        if start_instructions is not None:
            self.start_instructions = start_instructions
        self.skip_custom_listeners = skip_custom_listeners
        self.skip_io_mappings = skip_io_mappings
        self.with_variables_in_return = with_variables_in_return

    @property
    def business_key(self):
        """Gets the business_key of this StartProcessInstanceDto.  # noqa: E501

        The business key of the process instance.  # noqa: E501

        :return: The business_key of this StartProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key

    @business_key.setter
    def business_key(self, business_key):
        """Sets the business_key of this StartProcessInstanceDto.

        The business key of the process instance.  # noqa: E501

        :param business_key: The business_key of this StartProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._business_key = business_key

    @property
    def variables(self):
        """Gets the variables of this StartProcessInstanceDto.  # noqa: E501


        :return: The variables of this StartProcessInstanceDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this StartProcessInstanceDto.


        :param variables: The variables of this StartProcessInstanceDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._variables = variables

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this StartProcessInstanceDto.  # noqa: E501

        The case instance id the process instance is to be initialized with.  # noqa: E501

        :return: The case_instance_id of this StartProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this StartProcessInstanceDto.

        The case instance id the process instance is to be initialized with.  # noqa: E501

        :param case_instance_id: The case_instance_id of this StartProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def start_instructions(self):
        """Gets the start_instructions of this StartProcessInstanceDto.  # noqa: E501

        **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.  # noqa: E501

        :return: The start_instructions of this StartProcessInstanceDto.  # noqa: E501
        :rtype: list[ProcessInstanceModificationInstructionDto]
        """
        return self._start_instructions

    @start_instructions.setter
    def start_instructions(self, start_instructions):
        """Sets the start_instructions of this StartProcessInstanceDto.

        **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.  # noqa: E501

        :param start_instructions: The start_instructions of this StartProcessInstanceDto.  # noqa: E501
        :type: list[ProcessInstanceModificationInstructionDto]
        """

        self._start_instructions = start_instructions

    @property
    def skip_custom_listeners(self):
        """Gets the skip_custom_listeners of this StartProcessInstanceDto.  # noqa: E501

        Skip execution listener invocation for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.  # noqa: E501

        :return: The skip_custom_listeners of this StartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._skip_custom_listeners

    @skip_custom_listeners.setter
    def skip_custom_listeners(self, skip_custom_listeners):
        """Sets the skip_custom_listeners of this StartProcessInstanceDto.

        Skip execution listener invocation for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.  # noqa: E501

        :param skip_custom_listeners: The skip_custom_listeners of this StartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._skip_custom_listeners = skip_custom_listeners

    @property
    def skip_io_mappings(self):
        """Gets the skip_io_mappings of this StartProcessInstanceDto.  # noqa: E501

        Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.14/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.  # noqa: E501

        :return: The skip_io_mappings of this StartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._skip_io_mappings

    @skip_io_mappings.setter
    def skip_io_mappings(self, skip_io_mappings):
        """Sets the skip_io_mappings of this StartProcessInstanceDto.

        Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.14/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.  # noqa: E501

        :param skip_io_mappings: The skip_io_mappings of this StartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._skip_io_mappings = skip_io_mappings

    @property
    def with_variables_in_return(self):
        """Gets the with_variables_in_return of this StartProcessInstanceDto.  # noqa: E501

        Indicates if the variables, which was used by the process instance during execution, should be returned. Default value: `false`  # noqa: E501

        :return: The with_variables_in_return of this StartProcessInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_variables_in_return

    @with_variables_in_return.setter
    def with_variables_in_return(self, with_variables_in_return):
        """Sets the with_variables_in_return of this StartProcessInstanceDto.

        Indicates if the variables, which was used by the process instance during execution, should be returned. Default value: `false`  # noqa: E501

        :param with_variables_in_return: The with_variables_in_return of this StartProcessInstanceDto.  # noqa: E501
        :type: bool
        """

        self._with_variables_in_return = with_variables_in_return

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StartProcessInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StartProcessInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
