# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricProcessInstanceQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_instance_id': 'str',
        'process_instance_ids': 'list[str]',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'process_definition_key_in': 'list[str]',
        'process_definition_name': 'str',
        'process_definition_name_like': 'str',
        'process_definition_key_not_in': 'list[str]',
        'process_instance_business_key': 'str',
        'process_instance_business_key_like': 'str',
        'root_process_instances': 'bool',
        'finished': 'bool',
        'unfinished': 'bool',
        'with_incidents': 'bool',
        'with_root_incidents': 'bool',
        'incident_type': 'str',
        'incident_status': 'str',
        'incident_message': 'str',
        'incident_message_like': 'str',
        'started_before': 'datetime',
        'started_after': 'datetime',
        'finished_before': 'datetime',
        'finished_after': 'datetime',
        'executed_activity_after': 'datetime',
        'executed_activity_before': 'datetime',
        'executed_job_after': 'datetime',
        'executed_job_before': 'datetime',
        'started_by': 'str',
        'super_process_instance_id': 'str',
        'sub_process_instance_id': 'str',
        'super_case_instance_id': 'str',
        'sub_case_instance_id': 'str',
        'case_instance_id': 'str',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'executed_activity_id_in': 'list[str]',
        'active_activity_id_in': 'list[str]',
        'active': 'bool',
        'suspended': 'bool',
        'completed': 'bool',
        'externally_terminated': 'bool',
        'internally_terminated': 'bool',
        'variables': 'list[VariableQueryParameterDto]',
        'variable_names_ignore_case': 'bool',
        'variable_values_ignore_case': 'bool',
        'or_queries': 'list[HistoricProcessInstanceQueryDto]',
        'sorting': 'list[HistoricProcessInstanceQueryDtoSorting]'
    }

    attribute_map = {
        'process_instance_id': 'processInstanceId',
        'process_instance_ids': 'processInstanceIds',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_key_in': 'processDefinitionKeyIn',
        'process_definition_name': 'processDefinitionName',
        'process_definition_name_like': 'processDefinitionNameLike',
        'process_definition_key_not_in': 'processDefinitionKeyNotIn',
        'process_instance_business_key': 'processInstanceBusinessKey',
        'process_instance_business_key_like': 'processInstanceBusinessKeyLike',
        'root_process_instances': 'rootProcessInstances',
        'finished': 'finished',
        'unfinished': 'unfinished',
        'with_incidents': 'withIncidents',
        'with_root_incidents': 'withRootIncidents',
        'incident_type': 'incidentType',
        'incident_status': 'incidentStatus',
        'incident_message': 'incidentMessage',
        'incident_message_like': 'incidentMessageLike',
        'started_before': 'startedBefore',
        'started_after': 'startedAfter',
        'finished_before': 'finishedBefore',
        'finished_after': 'finishedAfter',
        'executed_activity_after': 'executedActivityAfter',
        'executed_activity_before': 'executedActivityBefore',
        'executed_job_after': 'executedJobAfter',
        'executed_job_before': 'executedJobBefore',
        'started_by': 'startedBy',
        'super_process_instance_id': 'superProcessInstanceId',
        'sub_process_instance_id': 'subProcessInstanceId',
        'super_case_instance_id': 'superCaseInstanceId',
        'sub_case_instance_id': 'subCaseInstanceId',
        'case_instance_id': 'caseInstanceId',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'executed_activity_id_in': 'executedActivityIdIn',
        'active_activity_id_in': 'activeActivityIdIn',
        'active': 'active',
        'suspended': 'suspended',
        'completed': 'completed',
        'externally_terminated': 'externallyTerminated',
        'internally_terminated': 'internallyTerminated',
        'variables': 'variables',
        'variable_names_ignore_case': 'variableNamesIgnoreCase',
        'variable_values_ignore_case': 'variableValuesIgnoreCase',
        'or_queries': 'orQueries',
        'sorting': 'sorting'
    }

    def __init__(self, process_instance_id=None, process_instance_ids=None, process_definition_id=None, process_definition_key=None, process_definition_key_in=None, process_definition_name=None, process_definition_name_like=None, process_definition_key_not_in=None, process_instance_business_key=None, process_instance_business_key_like=None, root_process_instances=None, finished=None, unfinished=None, with_incidents=None, with_root_incidents=None, incident_type=None, incident_status=None, incident_message=None, incident_message_like=None, started_before=None, started_after=None, finished_before=None, finished_after=None, executed_activity_after=None, executed_activity_before=None, executed_job_after=None, executed_job_before=None, started_by=None, super_process_instance_id=None, sub_process_instance_id=None, super_case_instance_id=None, sub_case_instance_id=None, case_instance_id=None, tenant_id_in=None, without_tenant_id=None, executed_activity_id_in=None, active_activity_id_in=None, active=None, suspended=None, completed=None, externally_terminated=None, internally_terminated=None, variables=None, variable_names_ignore_case=None, variable_values_ignore_case=None, or_queries=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricProcessInstanceQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_instance_id = None
        self._process_instance_ids = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._process_definition_key_in = None
        self._process_definition_name = None
        self._process_definition_name_like = None
        self._process_definition_key_not_in = None
        self._process_instance_business_key = None
        self._process_instance_business_key_like = None
        self._root_process_instances = None
        self._finished = None
        self._unfinished = None
        self._with_incidents = None
        self._with_root_incidents = None
        self._incident_type = None
        self._incident_status = None
        self._incident_message = None
        self._incident_message_like = None
        self._started_before = None
        self._started_after = None
        self._finished_before = None
        self._finished_after = None
        self._executed_activity_after = None
        self._executed_activity_before = None
        self._executed_job_after = None
        self._executed_job_before = None
        self._started_by = None
        self._super_process_instance_id = None
        self._sub_process_instance_id = None
        self._super_case_instance_id = None
        self._sub_case_instance_id = None
        self._case_instance_id = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._executed_activity_id_in = None
        self._active_activity_id_in = None
        self._active = None
        self._suspended = None
        self._completed = None
        self._externally_terminated = None
        self._internally_terminated = None
        self._variables = None
        self._variable_names_ignore_case = None
        self._variable_values_ignore_case = None
        self._or_queries = None
        self._sorting = None
        self.discriminator = None

        if process_instance_id is not None:
            self.process_instance_id = process_instance_id
        if process_instance_ids is not None:
            self.process_instance_ids = process_instance_ids
        if process_definition_id is not None:
            self.process_definition_id = process_definition_id
        if process_definition_key is not None:
            self.process_definition_key = process_definition_key
        if process_definition_key_in is not None:
            self.process_definition_key_in = process_definition_key_in
        if process_definition_name is not None:
            self.process_definition_name = process_definition_name
        if process_definition_name_like is not None:
            self.process_definition_name_like = process_definition_name_like
        if process_definition_key_not_in is not None:
            self.process_definition_key_not_in = process_definition_key_not_in
        if process_instance_business_key is not None:
            self.process_instance_business_key = process_instance_business_key
        if process_instance_business_key_like is not None:
            self.process_instance_business_key_like = process_instance_business_key_like
        self.root_process_instances = root_process_instances
        self.finished = finished
        self.unfinished = unfinished
        self.with_incidents = with_incidents
        self.with_root_incidents = with_root_incidents
        if incident_type is not None:
            self.incident_type = incident_type
        if incident_status is not None:
            self.incident_status = incident_status
        if incident_message is not None:
            self.incident_message = incident_message
        if incident_message_like is not None:
            self.incident_message_like = incident_message_like
        self.started_before = started_before
        self.started_after = started_after
        self.finished_before = finished_before
        self.finished_after = finished_after
        self.executed_activity_after = executed_activity_after
        self.executed_activity_before = executed_activity_before
        self.executed_job_after = executed_job_after
        self.executed_job_before = executed_job_before
        if started_by is not None:
            self.started_by = started_by
        if super_process_instance_id is not None:
            self.super_process_instance_id = super_process_instance_id
        if sub_process_instance_id is not None:
            self.sub_process_instance_id = sub_process_instance_id
        if super_case_instance_id is not None:
            self.super_case_instance_id = super_case_instance_id
        if sub_case_instance_id is not None:
            self.sub_case_instance_id = sub_case_instance_id
        if case_instance_id is not None:
            self.case_instance_id = case_instance_id
        if tenant_id_in is not None:
            self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        if executed_activity_id_in is not None:
            self.executed_activity_id_in = executed_activity_id_in
        if active_activity_id_in is not None:
            self.active_activity_id_in = active_activity_id_in
        self.active = active
        self.suspended = suspended
        self.completed = completed
        self.externally_terminated = externally_terminated
        self.internally_terminated = internally_terminated
        if variables is not None:
            self.variables = variables
        self.variable_names_ignore_case = variable_names_ignore_case
        self.variable_values_ignore_case = variable_values_ignore_case
        if or_queries is not None:
            self.or_queries = or_queries
        if sorting is not None:
            self.sorting = sorting

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by process instance id.  # noqa: E501

        :return: The process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricProcessInstanceQueryDto.

        Filter by process instance id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_instance_ids(self):
        """Gets the process_instance_ids of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by process instance ids. Must be a JSON array of `Strings`.  # noqa: E501

        :return: The process_instance_ids of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_ids

    @process_instance_ids.setter
    def process_instance_ids(self, process_instance_ids):
        """Sets the process_instance_ids of this HistoricProcessInstanceQueryDto.

        Filter by process instance ids. Must be a JSON array of `Strings`.  # noqa: E501

        :param process_instance_ids: The process_instance_ids of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_ids = process_instance_ids

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by the process definition the instances run on.  # noqa: E501

        :return: The process_definition_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricProcessInstanceQueryDto.

        Filter by the process definition the instances run on.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by the key of the process definition the instances run on.  # noqa: E501

        :return: The process_definition_key of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricProcessInstanceQueryDto.

        Filter by the key of the process definition the instances run on.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_key_in(self):
        """Gets the process_definition_key_in of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of `Strings`.  # noqa: E501

        :return: The process_definition_key_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_definition_key_in

    @process_definition_key_in.setter
    def process_definition_key_in(self, process_definition_key_in):
        """Sets the process_definition_key_in of this HistoricProcessInstanceQueryDto.

        Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of `Strings`.  # noqa: E501

        :param process_definition_key_in: The process_definition_key_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_definition_key_in = process_definition_key_in

    @property
    def process_definition_name(self):
        """Gets the process_definition_name of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by the name of the process definition the instances run on.  # noqa: E501

        :return: The process_definition_name of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name

    @process_definition_name.setter
    def process_definition_name(self, process_definition_name):
        """Sets the process_definition_name of this HistoricProcessInstanceQueryDto.

        Filter by the name of the process definition the instances run on.  # noqa: E501

        :param process_definition_name: The process_definition_name of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name = process_definition_name

    @property
    def process_definition_name_like(self):
        """Gets the process_definition_name_like of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by process definition names that the parameter is a substring of.  # noqa: E501

        :return: The process_definition_name_like of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name_like

    @process_definition_name_like.setter
    def process_definition_name_like(self, process_definition_name_like):
        """Sets the process_definition_name_like of this HistoricProcessInstanceQueryDto.

        Filter by process definition names that the parameter is a substring of.  # noqa: E501

        :param process_definition_name_like: The process_definition_name_like of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name_like = process_definition_name_like

    @property
    def process_definition_key_not_in(self):
        """Gets the process_definition_key_not_in of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Exclude instances that belong to a set of process definitions. Must be a JSON array of `Strings`.  # noqa: E501

        :return: The process_definition_key_not_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_definition_key_not_in

    @process_definition_key_not_in.setter
    def process_definition_key_not_in(self, process_definition_key_not_in):
        """Sets the process_definition_key_not_in of this HistoricProcessInstanceQueryDto.

        Exclude instances that belong to a set of process definitions. Must be a JSON array of `Strings`.  # noqa: E501

        :param process_definition_key_not_in: The process_definition_key_not_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_definition_key_not_in = process_definition_key_not_in

    @property
    def process_instance_business_key(self):
        """Gets the process_instance_business_key of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by process instance business key.  # noqa: E501

        :return: The process_instance_business_key of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key

    @process_instance_business_key.setter
    def process_instance_business_key(self, process_instance_business_key):
        """Sets the process_instance_business_key of this HistoricProcessInstanceQueryDto.

        Filter by process instance business key.  # noqa: E501

        :param process_instance_business_key: The process_instance_business_key of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key = process_instance_business_key

    @property
    def process_instance_business_key_like(self):
        """Gets the process_instance_business_key_like of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by process instance business key that the parameter is a substring of.  # noqa: E501

        :return: The process_instance_business_key_like of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key_like

    @process_instance_business_key_like.setter
    def process_instance_business_key_like(self, process_instance_business_key_like):
        """Sets the process_instance_business_key_like of this HistoricProcessInstanceQueryDto.

        Filter by process instance business key that the parameter is a substring of.  # noqa: E501

        :param process_instance_business_key_like: The process_instance_business_key_like of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key_like = process_instance_business_key_like

    @property
    def root_process_instances(self):
        """Gets the root_process_instances of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict the query to all process instances that are top level process instances.  # noqa: E501

        :return: The root_process_instances of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._root_process_instances

    @root_process_instances.setter
    def root_process_instances(self, root_process_instances):
        """Sets the root_process_instances of this HistoricProcessInstanceQueryDto.

        Restrict the query to all process instances that are top level process instances.  # noqa: E501

        :param root_process_instances: The root_process_instances of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._root_process_instances = root_process_instances

    @property
    def finished(self):
        """Gets the finished of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include finished process instances. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The finished of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this HistoricProcessInstanceQueryDto.

        Only include finished process instances. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param finished: The finished of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._finished = finished

    @property
    def unfinished(self):
        """Gets the unfinished of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The unfinished of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._unfinished

    @unfinished.setter
    def unfinished(self, unfinished):
        """Sets the unfinished of this HistoricProcessInstanceQueryDto.

        Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param unfinished: The unfinished of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._unfinished = unfinished

    @property
    def with_incidents(self):
        """Gets the with_incidents of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_incidents of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_incidents

    @with_incidents.setter
    def with_incidents(self, with_incidents):
        """Sets the with_incidents of this HistoricProcessInstanceQueryDto.

        Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_incidents: The with_incidents of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_incidents = with_incidents

    @property
    def with_root_incidents(self):
        """Gets the with_root_incidents of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_root_incidents of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_root_incidents

    @with_root_incidents.setter
    def with_root_incidents(self, with_root_incidents):
        """Sets the with_root_incidents of this HistoricProcessInstanceQueryDto.

        Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_root_incidents: The with_root_incidents of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_root_incidents = with_root_incidents

    @property
    def incident_type(self):
        """Gets the incident_type of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :return: The incident_type of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """Sets the incident_type of this HistoricProcessInstanceQueryDto.

        Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :param incident_type: The incident_type of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_type = incident_type

    @property
    def incident_status(self):
        """Gets the incident_status of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.  # noqa: E501

        :return: The incident_status of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_status

    @incident_status.setter
    def incident_status(self, incident_status):
        """Sets the incident_status of this HistoricProcessInstanceQueryDto.

        Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.  # noqa: E501

        :param incident_status: The incident_status of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["open", "resolved"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and incident_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `incident_status` ({0}), must be one of {1}"  # noqa: E501
                .format(incident_status, allowed_values)
            )

        self._incident_status = incident_status

    @property
    def incident_message(self):
        """Gets the incident_message of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident message. Exact match.  # noqa: E501

        :return: The incident_message of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message

    @incident_message.setter
    def incident_message(self, incident_message):
        """Sets the incident_message of this HistoricProcessInstanceQueryDto.

        Filter by the incident message. Exact match.  # noqa: E501

        :param incident_message: The incident_message of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_message = incident_message

    @property
    def incident_message_like(self):
        """Gets the incident_message_like of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by the incident message that the parameter is a substring of.  # noqa: E501

        :return: The incident_message_like of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message_like

    @incident_message_like.setter
    def incident_message_like(self, incident_message_like):
        """Sets the incident_message_like of this HistoricProcessInstanceQueryDto.

        Filter by the incident message that the parameter is a substring of.  # noqa: E501

        :param incident_message_like: The incident_message_like of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._incident_message_like = incident_message_like

    @property
    def started_before(self):
        """Gets the started_before of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The started_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._started_before

    @started_before.setter
    def started_before(self, started_before):
        """Sets the started_before of this HistoricProcessInstanceQueryDto.

        Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param started_before: The started_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._started_before = started_before

    @property
    def started_after(self):
        """Gets the started_after of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The started_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._started_after

    @started_after.setter
    def started_after(self, started_after):
        """Sets the started_after of this HistoricProcessInstanceQueryDto.

        Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param started_after: The started_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._started_after = started_after

    @property
    def finished_before(self):
        """Gets the finished_before of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The finished_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_before

    @finished_before.setter
    def finished_before(self, finished_before):
        """Sets the finished_before of this HistoricProcessInstanceQueryDto.

        Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param finished_before: The finished_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._finished_before = finished_before

    @property
    def finished_after(self):
        """Gets the finished_after of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The finished_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_after

    @finished_after.setter
    def finished_after(self, finished_after):
        """Sets the finished_after of this HistoricProcessInstanceQueryDto.

        Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param finished_after: The finished_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._finished_after = finished_after

    @property
    def executed_activity_after(self):
        """Gets the executed_activity_after of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The executed_activity_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._executed_activity_after

    @executed_activity_after.setter
    def executed_activity_after(self, executed_activity_after):
        """Sets the executed_activity_after of this HistoricProcessInstanceQueryDto.

        Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param executed_activity_after: The executed_activity_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._executed_activity_after = executed_activity_after

    @property
    def executed_activity_before(self):
        """Gets the executed_activity_before of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The executed_activity_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._executed_activity_before

    @executed_activity_before.setter
    def executed_activity_before(self, executed_activity_before):
        """Sets the executed_activity_before of this HistoricProcessInstanceQueryDto.

        Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param executed_activity_before: The executed_activity_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._executed_activity_before = executed_activity_before

    @property
    def executed_job_after(self):
        """Gets the executed_job_after of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The executed_job_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._executed_job_after

    @executed_job_after.setter
    def executed_job_after(self, executed_job_after):
        """Sets the executed_job_after of this HistoricProcessInstanceQueryDto.

        Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param executed_job_after: The executed_job_after of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._executed_job_after = executed_job_after

    @property
    def executed_job_before(self):
        """Gets the executed_job_before of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The executed_job_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._executed_job_before

    @executed_job_before.setter
    def executed_job_before(self, executed_job_before):
        """Sets the executed_job_before of this HistoricProcessInstanceQueryDto.

        Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param executed_job_before: The executed_job_before of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._executed_job_before = executed_job_before

    @property
    def started_by(self):
        """Gets the started_by of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include process instances that were started by the given user.  # noqa: E501

        :return: The started_by of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._started_by

    @started_by.setter
    def started_by(self, started_by):
        """Sets the started_by of this HistoricProcessInstanceQueryDto.

        Only include process instances that were started by the given user.  # noqa: E501

        :param started_by: The started_by of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._started_by = started_by

    @property
    def super_process_instance_id(self):
        """Gets the super_process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.  # noqa: E501

        :return: The super_process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._super_process_instance_id

    @super_process_instance_id.setter
    def super_process_instance_id(self, super_process_instance_id):
        """Sets the super_process_instance_id of this HistoricProcessInstanceQueryDto.

        Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.  # noqa: E501

        :param super_process_instance_id: The super_process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._super_process_instance_id = super_process_instance_id

    @property
    def sub_process_instance_id(self):
        """Gets the sub_process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict query to one process instance that has a sub process instance with the given id.  # noqa: E501

        :return: The sub_process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._sub_process_instance_id

    @sub_process_instance_id.setter
    def sub_process_instance_id(self, sub_process_instance_id):
        """Sets the sub_process_instance_id of this HistoricProcessInstanceQueryDto.

        Restrict query to one process instance that has a sub process instance with the given id.  # noqa: E501

        :param sub_process_instance_id: The sub_process_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._sub_process_instance_id = sub_process_instance_id

    @property
    def super_case_instance_id(self):
        """Gets the super_case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.  # noqa: E501

        :return: The super_case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._super_case_instance_id

    @super_case_instance_id.setter
    def super_case_instance_id(self, super_case_instance_id):
        """Sets the super_case_instance_id of this HistoricProcessInstanceQueryDto.

        Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.  # noqa: E501

        :param super_case_instance_id: The super_case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._super_case_instance_id = super_case_instance_id

    @property
    def sub_case_instance_id(self):
        """Gets the sub_case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict query to one process instance that has a sub case instance with the given id.  # noqa: E501

        :return: The sub_case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._sub_case_instance_id

    @sub_case_instance_id.setter
    def sub_case_instance_id(self, sub_case_instance_id):
        """Sets the sub_case_instance_id of this HistoricProcessInstanceQueryDto.

        Restrict query to one process instance that has a sub case instance with the given id.  # noqa: E501

        :param sub_case_instance_id: The sub_case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._sub_case_instance_id = sub_case_instance_id

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.  # noqa: E501

        :return: The case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricProcessInstanceQueryDto.

        Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of `Strings`  # noqa: E501

        :return: The tenant_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricProcessInstanceQueryDto.

        Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of `Strings`  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricProcessInstanceQueryDto.

        Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def executed_activity_id_in(self):
        """Gets the executed_activity_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that executed an activity with one of given ids. Must be a JSON array of `Strings`  # noqa: E501

        :return: The executed_activity_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._executed_activity_id_in

    @executed_activity_id_in.setter
    def executed_activity_id_in(self, executed_activity_id_in):
        """Sets the executed_activity_id_in of this HistoricProcessInstanceQueryDto.

        Restrict to instances that executed an activity with one of given ids. Must be a JSON array of `Strings`  # noqa: E501

        :param executed_activity_id_in: The executed_activity_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._executed_activity_id_in = executed_activity_id_in

    @property
    def active_activity_id_in(self):
        """Gets the active_activity_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that have an active activity with one of given ids. Must be a JSON array of `Strings`  # noqa: E501

        :return: The active_activity_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._active_activity_id_in

    @active_activity_id_in.setter
    def active_activity_id_in(self, active_activity_id_in):
        """Sets the active_activity_id_in of this HistoricProcessInstanceQueryDto.

        Restrict to instances that have an active activity with one of given ids. Must be a JSON array of `Strings`  # noqa: E501

        :param active_activity_id_in: The active_activity_id_in of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._active_activity_id_in = active_activity_id_in

    @property
    def active(self):
        """Gets the active of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that are active.  # noqa: E501

        :return: The active of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this HistoricProcessInstanceQueryDto.

        Restrict to instances that are active.  # noqa: E501

        :param active: The active of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def suspended(self):
        """Gets the suspended of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that are suspended.  # noqa: E501

        :return: The suspended of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this HistoricProcessInstanceQueryDto.

        Restrict to instances that are suspended.  # noqa: E501

        :param suspended: The suspended of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def completed(self):
        """Gets the completed of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that are completed.  # noqa: E501

        :return: The completed of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._completed

    @completed.setter
    def completed(self, completed):
        """Sets the completed of this HistoricProcessInstanceQueryDto.

        Restrict to instances that are completed.  # noqa: E501

        :param completed: The completed of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._completed = completed

    @property
    def externally_terminated(self):
        """Gets the externally_terminated of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that are externallyTerminated.  # noqa: E501

        :return: The externally_terminated of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._externally_terminated

    @externally_terminated.setter
    def externally_terminated(self, externally_terminated):
        """Sets the externally_terminated of this HistoricProcessInstanceQueryDto.

        Restrict to instances that are externallyTerminated.  # noqa: E501

        :param externally_terminated: The externally_terminated of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._externally_terminated = externally_terminated

    @property
    def internally_terminated(self):
        """Gets the internally_terminated of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Restrict to instances that are internallyTerminated.  # noqa: E501

        :return: The internally_terminated of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._internally_terminated

    @internally_terminated.setter
    def internally_terminated(self, internally_terminated):
        """Sets the internally_terminated of this HistoricProcessInstanceQueryDto.

        Restrict to instances that are internallyTerminated.  # noqa: E501

        :param internally_terminated: The internally_terminated of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._internally_terminated = internally_terminated

    @property
    def variables(self):
        """Gets the variables of this HistoricProcessInstanceQueryDto.  # noqa: E501

        A JSON array to only include process instances that have/had variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (`String`) is the variable name, `operator` (`String`) is the comparison operator to be used and `value` the variable value.  Value may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.   # noqa: E501

        :return: The variables of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this HistoricProcessInstanceQueryDto.

        A JSON array to only include process instances that have/had variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (`String`) is the variable name, `operator` (`String`) is the comparison operator to be used and `value` the variable value.  Value may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.   # noqa: E501

        :param variables: The variables of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._variables = variables

    @property
    def variable_names_ignore_case(self):
        """Gets the variable_names_ignore_case of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.  # noqa: E501

        :return: The variable_names_ignore_case of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_names_ignore_case

    @variable_names_ignore_case.setter
    def variable_names_ignore_case(self, variable_names_ignore_case):
        """Sets the variable_names_ignore_case of this HistoricProcessInstanceQueryDto.

        Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.  # noqa: E501

        :param variable_names_ignore_case: The variable_names_ignore_case of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_names_ignore_case = variable_names_ignore_case

    @property
    def variable_values_ignore_case(self):
        """Gets the variable_values_ignore_case of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.  # noqa: E501

        :return: The variable_values_ignore_case of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_values_ignore_case

    @variable_values_ignore_case.setter
    def variable_values_ignore_case(self, variable_values_ignore_case):
        """Sets the variable_values_ignore_case of this HistoricProcessInstanceQueryDto.

        Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.  # noqa: E501

        :param variable_values_ignore_case: The variable_values_ignore_case of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_values_ignore_case = variable_values_ignore_case

    @property
    def or_queries(self):
        """Gets the or_queries of this HistoricProcessInstanceQueryDto.  # noqa: E501

        A JSON array of nested historic process instance queries with OR semantics.  A process instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a process instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All process instance query properties can be used except for: `sorting`  See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :return: The or_queries of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[HistoricProcessInstanceQueryDto]
        """
        return self._or_queries

    @or_queries.setter
    def or_queries(self, or_queries):
        """Sets the or_queries of this HistoricProcessInstanceQueryDto.

        A JSON array of nested historic process instance queries with OR semantics.  A process instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a process instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All process instance query properties can be used except for: `sorting`  See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :param or_queries: The or_queries of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[HistoricProcessInstanceQueryDto]
        """

        self._or_queries = or_queries

    @property
    def sorting(self):
        """Gets the sorting of this HistoricProcessInstanceQueryDto.  # noqa: E501

        Apply sorting of the result  # noqa: E501

        :return: The sorting of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :rtype: list[HistoricProcessInstanceQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricProcessInstanceQueryDto.

        Apply sorting of the result  # noqa: E501

        :param sorting: The sorting of this HistoricProcessInstanceQueryDto.  # noqa: E501
        :type: list[HistoricProcessInstanceQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricProcessInstanceQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricProcessInstanceQueryDto):
            return True

        return self.to_dict() != other.to_dict()
