# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricProcessInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'root_process_instance_id': 'str',
        'super_process_instance_id': 'str',
        'super_case_instance_id': 'str',
        'case_instance_id': 'str',
        'process_definition_name': 'str',
        'process_definition_key': 'str',
        'process_definition_version': 'int',
        'process_definition_id': 'str',
        'business_key': 'str',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'removal_time': 'datetime',
        'duration_in_millis': 'int',
        'start_user_id': 'str',
        'start_activity_id': 'str',
        'delete_reason': 'str',
        'tenant_id': 'str',
        'state': 'str'
    }

    attribute_map = {
        'id': 'id',
        'root_process_instance_id': 'rootProcessInstanceId',
        'super_process_instance_id': 'superProcessInstanceId',
        'super_case_instance_id': 'superCaseInstanceId',
        'case_instance_id': 'caseInstanceId',
        'process_definition_name': 'processDefinitionName',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_version': 'processDefinitionVersion',
        'process_definition_id': 'processDefinitionId',
        'business_key': 'businessKey',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'removal_time': 'removalTime',
        'duration_in_millis': 'durationInMillis',
        'start_user_id': 'startUserId',
        'start_activity_id': 'startActivityId',
        'delete_reason': 'deleteReason',
        'tenant_id': 'tenantId',
        'state': 'state'
    }

    def __init__(self, id=None, root_process_instance_id=None, super_process_instance_id=None, super_case_instance_id=None, case_instance_id=None, process_definition_name=None, process_definition_key=None, process_definition_version=None, process_definition_id=None, business_key=None, start_time=None, end_time=None, removal_time=None, duration_in_millis=None, start_user_id=None, start_activity_id=None, delete_reason=None, tenant_id=None, state=None, local_vars_configuration=None):  # noqa: E501
        """HistoricProcessInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._root_process_instance_id = None
        self._super_process_instance_id = None
        self._super_case_instance_id = None
        self._case_instance_id = None
        self._process_definition_name = None
        self._process_definition_key = None
        self._process_definition_version = None
        self._process_definition_id = None
        self._business_key = None
        self._start_time = None
        self._end_time = None
        self._removal_time = None
        self._duration_in_millis = None
        self._start_user_id = None
        self._start_activity_id = None
        self._delete_reason = None
        self._tenant_id = None
        self._state = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if root_process_instance_id is not None:
            self.root_process_instance_id = root_process_instance_id
        if super_process_instance_id is not None:
            self.super_process_instance_id = super_process_instance_id
        if super_case_instance_id is not None:
            self.super_case_instance_id = super_case_instance_id
        if case_instance_id is not None:
            self.case_instance_id = case_instance_id
        if process_definition_name is not None:
            self.process_definition_name = process_definition_name
        if process_definition_key is not None:
            self.process_definition_key = process_definition_key
        if process_definition_version is not None:
            self.process_definition_version = process_definition_version
        if process_definition_id is not None:
            self.process_definition_id = process_definition_id
        if business_key is not None:
            self.business_key = business_key
        self.start_time = start_time
        self.end_time = end_time
        self.removal_time = removal_time
        self.duration_in_millis = duration_in_millis
        if start_user_id is not None:
            self.start_user_id = start_user_id
        if start_activity_id is not None:
            self.start_activity_id = start_activity_id
        if delete_reason is not None:
            self.delete_reason = delete_reason
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if state is not None:
            self.state = state

    @property
    def id(self):
        """Gets the id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the process instance.  # noqa: E501

        :return: The id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricProcessInstanceDto.

        The id of the process instance.  # noqa: E501

        :param id: The id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricProcessInstanceDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process.  # noqa: E501

        :return: The root_process_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricProcessInstanceDto.

        The process instance id of the root process instance that initiated the process.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    @property
    def super_process_instance_id(self):
        """Gets the super_process_instance_id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the parent process instance, if it exists.  # noqa: E501

        :return: The super_process_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._super_process_instance_id

    @super_process_instance_id.setter
    def super_process_instance_id(self, super_process_instance_id):
        """Sets the super_process_instance_id of this HistoricProcessInstanceDto.

        The id of the parent process instance, if it exists.  # noqa: E501

        :param super_process_instance_id: The super_process_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._super_process_instance_id = super_process_instance_id

    @property
    def super_case_instance_id(self):
        """Gets the super_case_instance_id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the parent case instance, if it exists.  # noqa: E501

        :return: The super_case_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._super_case_instance_id

    @super_case_instance_id.setter
    def super_case_instance_id(self, super_case_instance_id):
        """Sets the super_case_instance_id of this HistoricProcessInstanceDto.

        The id of the parent case instance, if it exists.  # noqa: E501

        :param super_case_instance_id: The super_case_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._super_case_instance_id = super_case_instance_id

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the parent case instance, if it exists.  # noqa: E501

        :return: The case_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricProcessInstanceDto.

        The id of the parent case instance, if it exists.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def process_definition_name(self):
        """Gets the process_definition_name of this HistoricProcessInstanceDto.  # noqa: E501

        The name of the process definition that this process instance belongs to.  # noqa: E501

        :return: The process_definition_name of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name

    @process_definition_name.setter
    def process_definition_name(self, process_definition_name):
        """Sets the process_definition_name of this HistoricProcessInstanceDto.

        The name of the process definition that this process instance belongs to.  # noqa: E501

        :param process_definition_name: The process_definition_name of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name = process_definition_name

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricProcessInstanceDto.  # noqa: E501

        The key of the process definition that this process instance belongs to.  # noqa: E501

        :return: The process_definition_key of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricProcessInstanceDto.

        The key of the process definition that this process instance belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_version(self):
        """Gets the process_definition_version of this HistoricProcessInstanceDto.  # noqa: E501

        The version of the process definition that this process instance belongs to.  # noqa: E501

        :return: The process_definition_version of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: int
        """
        return self._process_definition_version

    @process_definition_version.setter
    def process_definition_version(self, process_definition_version):
        """Sets the process_definition_version of this HistoricProcessInstanceDto.

        The version of the process definition that this process instance belongs to.  # noqa: E501

        :param process_definition_version: The process_definition_version of this HistoricProcessInstanceDto.  # noqa: E501
        :type: int
        """

        self._process_definition_version = process_definition_version

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the process definition that this process instance belongs to.  # noqa: E501

        :return: The process_definition_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricProcessInstanceDto.

        The id of the process definition that this process instance belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def business_key(self):
        """Gets the business_key of this HistoricProcessInstanceDto.  # noqa: E501

        The business key of the process instance.  # noqa: E501

        :return: The business_key of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._business_key

    @business_key.setter
    def business_key(self, business_key):
        """Sets the business_key of this HistoricProcessInstanceDto.

        The business key of the process instance.  # noqa: E501

        :param business_key: The business_key of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._business_key = business_key

    @property
    def start_time(self):
        """Gets the start_time of this HistoricProcessInstanceDto.  # noqa: E501

        The time the instance was started. Default [format](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The start_time of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this HistoricProcessInstanceDto.

        The time the instance was started. Default [format](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param start_time: The start_time of this HistoricProcessInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this HistoricProcessInstanceDto.  # noqa: E501

        The time the instance ended. Default [format](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The end_time of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this HistoricProcessInstanceDto.

        The time the instance ended. Default [format](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param end_time: The end_time of this HistoricProcessInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._end_time = end_time

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricProcessInstanceDto.  # noqa: E501

        The time after which the instance should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricProcessInstanceDto.

        The time after which the instance should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricProcessInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def duration_in_millis(self):
        """Gets the duration_in_millis of this HistoricProcessInstanceDto.  # noqa: E501

        The time the instance took to finish (in milliseconds).  # noqa: E501

        :return: The duration_in_millis of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: int
        """
        return self._duration_in_millis

    @duration_in_millis.setter
    def duration_in_millis(self, duration_in_millis):
        """Sets the duration_in_millis of this HistoricProcessInstanceDto.

        The time the instance took to finish (in milliseconds).  # noqa: E501

        :param duration_in_millis: The duration_in_millis of this HistoricProcessInstanceDto.  # noqa: E501
        :type: int
        """

        self._duration_in_millis = duration_in_millis

    @property
    def start_user_id(self):
        """Gets the start_user_id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the user who started the process instance.  # noqa: E501

        :return: The start_user_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._start_user_id

    @start_user_id.setter
    def start_user_id(self, start_user_id):
        """Sets the start_user_id of this HistoricProcessInstanceDto.

        The id of the user who started the process instance.  # noqa: E501

        :param start_user_id: The start_user_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._start_user_id = start_user_id

    @property
    def start_activity_id(self):
        """Gets the start_activity_id of this HistoricProcessInstanceDto.  # noqa: E501

        The id of the initial activity that was executed (e.g., a start event).  # noqa: E501

        :return: The start_activity_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._start_activity_id

    @start_activity_id.setter
    def start_activity_id(self, start_activity_id):
        """Sets the start_activity_id of this HistoricProcessInstanceDto.

        The id of the initial activity that was executed (e.g., a start event).  # noqa: E501

        :param start_activity_id: The start_activity_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._start_activity_id = start_activity_id

    @property
    def delete_reason(self):
        """Gets the delete_reason of this HistoricProcessInstanceDto.  # noqa: E501

        The provided delete reason in case the process instance was canceled during execution.  # noqa: E501

        :return: The delete_reason of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._delete_reason

    @delete_reason.setter
    def delete_reason(self, delete_reason):
        """Sets the delete_reason of this HistoricProcessInstanceDto.

        The provided delete reason in case the process instance was canceled during execution.  # noqa: E501

        :param delete_reason: The delete_reason of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._delete_reason = delete_reason

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricProcessInstanceDto.  # noqa: E501

        The tenant id of the process instance.  # noqa: E501

        :return: The tenant_id of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricProcessInstanceDto.

        The tenant id of the process instance.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def state(self):
        """Gets the state of this HistoricProcessInstanceDto.  # noqa: E501

        Last state of the process instance, possible values are:  `ACTIVE` - running process instance  `SUSPENDED` - suspended process instances  `COMPLETED` - completed through normal end event  `EXTERNALLY_TERMINATED` - terminated externally, for instance through REST API  `INTERNALLY_TERMINATED` - terminated internally, for instance by terminating boundary event  # noqa: E501

        :return: The state of this HistoricProcessInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this HistoricProcessInstanceDto.

        Last state of the process instance, possible values are:  `ACTIVE` - running process instance  `SUSPENDED` - suspended process instances  `COMPLETED` - completed through normal end event  `EXTERNALLY_TERMINATED` - terminated externally, for instance through REST API  `INTERNALLY_TERMINATED` - terminated internally, for instance by terminating boundary event  # noqa: E501

        :param state: The state of this HistoricProcessInstanceDto.  # noqa: E501
        :type: str
        """
        allowed_values = ["ACTIVE", "SUSPENDED", "COMPLETED", "EXTERNALLY_TERMINATED", "INTERNALLY_TERMINATED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricProcessInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricProcessInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
