# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProcessInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_async_historic_query_based(self, **kwargs):  # noqa: E501
        """delete_async_historic_query_based  # noqa: E501

        Deletes a set of process instances asynchronously (batch) based on a historic process instance query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_async_historic_query_based(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteProcessInstancesDto delete_process_instances_dto: **Unallowed property**: `processInstanceQuery`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_async_historic_query_based_with_http_info(**kwargs)  # noqa: E501

    def delete_async_historic_query_based_with_http_info(self, **kwargs):  # noqa: E501
        """delete_async_historic_query_based  # noqa: E501

        Deletes a set of process instances asynchronously (batch) based on a historic process instance query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_async_historic_query_based_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteProcessInstancesDto delete_process_instances_dto: **Unallowed property**: `processInstanceQuery`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'delete_process_instances_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_async_historic_query_based" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_process_instances_dto' in local_var_params:
            body_params = local_var_params['delete_process_instances_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/delete-historic-query-based', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_process_instance(self, id, **kwargs):  # noqa: E501
        """delete_process_instance  # noqa: E501

        Deletes a running process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_process_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to be deleted. (required)
        :param bool skip_custom_listeners: If set to true, the custom listeners will be skipped.
        :param bool skip_io_mappings: If set to true, the input/output mappings will be skipped.
        :param bool skip_subprocesses: If set to true, subprocesses related to deleted processes will be skipped.
        :param bool fail_if_not_exists: If set to false, the request will still be successful if the process id is not found.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_process_instance_with_http_info(id, **kwargs)  # noqa: E501

    def delete_process_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_process_instance  # noqa: E501

        Deletes a running process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_process_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to be deleted. (required)
        :param bool skip_custom_listeners: If set to true, the custom listeners will be skipped.
        :param bool skip_io_mappings: If set to true, the input/output mappings will be skipped.
        :param bool skip_subprocesses: If set to true, subprocesses related to deleted processes will be skipped.
        :param bool fail_if_not_exists: If set to false, the request will still be successful if the process id is not found.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'skip_custom_listeners',
            'skip_io_mappings',
            'skip_subprocesses',
            'fail_if_not_exists'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_process_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_process_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'skip_custom_listeners' in local_var_params and local_var_params['skip_custom_listeners'] is not None:  # noqa: E501
            query_params.append(('skipCustomListeners', local_var_params['skip_custom_listeners']))  # noqa: E501
        if 'skip_io_mappings' in local_var_params and local_var_params['skip_io_mappings'] is not None:  # noqa: E501
            query_params.append(('skipIoMappings', local_var_params['skip_io_mappings']))  # noqa: E501
        if 'skip_subprocesses' in local_var_params and local_var_params['skip_subprocesses'] is not None:  # noqa: E501
            query_params.append(('skipSubprocesses', local_var_params['skip_subprocesses']))  # noqa: E501
        if 'fail_if_not_exists' in local_var_params and local_var_params['fail_if_not_exists'] is not None:  # noqa: E501
            query_params.append(('failIfNotExists', local_var_params['fail_if_not_exists']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_process_instance_variable(self, id, var_name, **kwargs):  # noqa: E501
        """delete_process_instance_variable  # noqa: E501

        Deletes a variable of a process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_process_instance_variable(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to delete the variable from. (required)
        :param str var_name: The name of the variable to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_process_instance_variable_with_http_info(id, var_name, **kwargs)  # noqa: E501

    def delete_process_instance_variable_with_http_info(self, id, var_name, **kwargs):  # noqa: E501
        """delete_process_instance_variable  # noqa: E501

        Deletes a variable of a process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_process_instance_variable_with_http_info(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to delete the variable from. (required)
        :param str var_name: The name of the variable to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'var_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_process_instance_variable" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_process_instance_variable`")  # noqa: E501
        # verify the required parameter 'var_name' is set
        if self.api_client.client_side_validation and ('var_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['var_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `var_name` when calling `delete_process_instance_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'var_name' in local_var_params:
            path_params['varName'] = local_var_params['var_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables/{varName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_process_instances_async_operation(self, **kwargs):  # noqa: E501
        """delete_process_instances_async_operation  # noqa: E501

        Deletes multiple process instances asynchronously (batch).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_process_instances_async_operation(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteProcessInstancesDto delete_process_instances_dto: **Unallowed property**: `historicProcessInstanceQuery`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_process_instances_async_operation_with_http_info(**kwargs)  # noqa: E501

    def delete_process_instances_async_operation_with_http_info(self, **kwargs):  # noqa: E501
        """delete_process_instances_async_operation  # noqa: E501

        Deletes multiple process instances asynchronously (batch).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_process_instances_async_operation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteProcessInstancesDto delete_process_instances_dto: **Unallowed property**: `historicProcessInstanceQuery`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'delete_process_instances_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_process_instances_async_operation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_process_instances_dto' in local_var_params:
            body_params = local_var_params['delete_process_instances_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_instance_tree(self, id, **kwargs):  # noqa: E501
        """get_activity_instance_tree  # noqa: E501

        Retrieves an Activity Instance (Tree) for a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_instance_tree(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance for which the activity instance should be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActivityInstanceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_activity_instance_tree_with_http_info(id, **kwargs)  # noqa: E501

    def get_activity_instance_tree_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_activity_instance_tree  # noqa: E501

        Retrieves an Activity Instance (Tree) for a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_instance_tree_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance for which the activity instance should be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActivityInstanceDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_instance_tree" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_activity_instance_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/activity-instances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityInstanceDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_instance(self, id, **kwargs):  # noqa: E501
        """Get Process Instance  # noqa: E501

        Retrieves a process instance by id, according to the `ProcessInstance` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ProcessInstanceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_process_instance_with_http_info(id, **kwargs)  # noqa: E501

    def get_process_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Process Instance  # noqa: E501

        Retrieves a process instance by id, according to the `ProcessInstance` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ProcessInstanceDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_process_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProcessInstanceDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_instance_variable(self, id, var_name, **kwargs):  # noqa: E501
        """get_process_instance_variable  # noqa: E501

        Retrieves a variable of a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_variable(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variable for. (required)
        :param str var_name: The name of the variable to retrieve. (required)
        :param bool deserialize_value: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: VariableValueDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_process_instance_variable_with_http_info(id, var_name, **kwargs)  # noqa: E501

    def get_process_instance_variable_with_http_info(self, id, var_name, **kwargs):  # noqa: E501
        """get_process_instance_variable  # noqa: E501

        Retrieves a variable of a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_variable_with_http_info(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variable for. (required)
        :param str var_name: The name of the variable to retrieve. (required)
        :param bool deserialize_value: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(VariableValueDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'var_name',
            'deserialize_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_instance_variable" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_process_instance_variable`")  # noqa: E501
        # verify the required parameter 'var_name' is set
        if self.api_client.client_side_validation and ('var_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['var_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `var_name` when calling `get_process_instance_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'var_name' in local_var_params:
            path_params['varName'] = local_var_params['var_name']  # noqa: E501

        query_params = []
        if 'deserialize_value' in local_var_params and local_var_params['deserialize_value'] is not None:  # noqa: E501
            query_params.append(('deserializeValue', local_var_params['deserialize_value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables/{varName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VariableValueDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_instance_variable_binary(self, id, var_name, **kwargs):  # noqa: E501
        """get_process_instance_variable_binary  # noqa: E501

        Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_variable_binary(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variable for. (required)
        :param str var_name: The name of the variable to retrieve. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_process_instance_variable_binary_with_http_info(id, var_name, **kwargs)  # noqa: E501

    def get_process_instance_variable_binary_with_http_info(self, id, var_name, **kwargs):  # noqa: E501
        """get_process_instance_variable_binary  # noqa: E501

        Retrieves the content of a Process Variable by the Process Instance id and the Process Variable name. Applicable for byte array or file Process Variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_variable_binary_with_http_info(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variable for. (required)
        :param str var_name: The name of the variable to retrieve. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'var_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_instance_variable_binary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_process_instance_variable_binary`")  # noqa: E501
        # verify the required parameter 'var_name' is set
        if self.api_client.client_side_validation and ('var_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['var_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `var_name` when calling `get_process_instance_variable_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'var_name' in local_var_params:
            path_params['varName'] = local_var_params['var_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables/{varName}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_instance_variables(self, id, **kwargs):  # noqa: E501
        """get_process_instance_variables  # noqa: E501

        Retrieves all variables of a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_variables(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variables from. (required)
        :param bool deserialize_value: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, VariableValueDto)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_process_instance_variables_with_http_info(id, **kwargs)  # noqa: E501

    def get_process_instance_variables_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_process_instance_variables  # noqa: E501

        Retrieves all variables of a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instance_variables_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variables from. (required)
        :param bool deserialize_value: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default true).  If set to true, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to false, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  Note: While true is the default value for reasons of backward compatibility, we recommend setting this parameter to false when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, VariableValueDto), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'deserialize_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_instance_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_process_instance_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'deserialize_value' in local_var_params and local_var_params['deserialize_value'] is not None:  # noqa: E501
            query_params.append(('deserializeValue', local_var_params['deserialize_value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, VariableValueDto)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_instances(self, **kwargs):  # noqa: E501
        """get_process_instances  # noqa: E501

        Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param str process_instance_ids: Filter by a comma-separated list of process instance ids.
        :param str business_key: Filter by process instance business key.
        :param str business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param str case_instance_id: Filter by case instance id.
        :param str process_definition_id: Filter by the deployment the id belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys.
        :param str process_definition_key_not_in: Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys.
        :param str deployment_id: Filter by the deployment the id belongs to.
        :param str super_process_instance: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance: Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.
        :param str super_case_instance: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance: Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.
        :param bool active: Only include active process instances. Value may only be true, as false is the default behavior.
        :param bool suspended: Only include suspended process instances. Value may only be true, as false is the default behavior.
        :param bool with_incident: Filter by presence of incidents. Selects only process instances that have an incident.
        :param str incident_id: Filter by the incident id.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include process instances which belong to no tenant.
        :param bool process_definition_without_tenant_id: Only include process instances which process definition has no tenant id.
        :param str activity_id_in: Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool leaf_process_instances: Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances).
        :param str variables: Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ProcessInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_process_instances_with_http_info(**kwargs)  # noqa: E501

    def get_process_instances_with_http_info(self, **kwargs):  # noqa: E501
        """get_process_instances  # noqa: E501

        Queries for process instances that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of process instances. The size of the result set can be retrieved by using the Get Instance Count method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param str process_instance_ids: Filter by a comma-separated list of process instance ids.
        :param str business_key: Filter by process instance business key.
        :param str business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param str case_instance_id: Filter by case instance id.
        :param str process_definition_id: Filter by the deployment the id belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys.
        :param str process_definition_key_not_in: Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys.
        :param str deployment_id: Filter by the deployment the id belongs to.
        :param str super_process_instance: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance: Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.
        :param str super_case_instance: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance: Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.
        :param bool active: Only include active process instances. Value may only be true, as false is the default behavior.
        :param bool suspended: Only include suspended process instances. Value may only be true, as false is the default behavior.
        :param bool with_incident: Filter by presence of incidents. Selects only process instances that have an incident.
        :param str incident_id: Filter by the incident id.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include process instances which belong to no tenant.
        :param bool process_definition_without_tenant_id: Only include process instances which process definition has no tenant id.
        :param str activity_id_in: Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool leaf_process_instances: Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances).
        :param str variables: Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ProcessInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'sort_by',
            'sort_order',
            'first_result',
            'max_results',
            'process_instance_ids',
            'business_key',
            'business_key_like',
            'case_instance_id',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_definition_key_not_in',
            'deployment_id',
            'super_process_instance',
            'sub_process_instance',
            'super_case_instance',
            'sub_case_instance',
            'active',
            'suspended',
            'with_incident',
            'incident_id',
            'incident_type',
            'incident_message',
            'incident_message_like',
            'tenant_id_in',
            'without_tenant_id',
            'process_definition_without_tenant_id',
            'activity_id_in',
            'root_process_instances',
            'leaf_process_instances',
            'variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'process_instance_ids' in local_var_params and local_var_params['process_instance_ids'] is not None:  # noqa: E501
            query_params.append(('processInstanceIds', local_var_params['process_instance_ids']))  # noqa: E501
        if 'business_key' in local_var_params and local_var_params['business_key'] is not None:  # noqa: E501
            query_params.append(('businessKey', local_var_params['business_key']))  # noqa: E501
        if 'business_key_like' in local_var_params and local_var_params['business_key_like'] is not None:  # noqa: E501
            query_params.append(('businessKeyLike', local_var_params['business_key_like']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_definition_key_not_in' in local_var_params and local_var_params['process_definition_key_not_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyNotIn', local_var_params['process_definition_key_not_in']))  # noqa: E501
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'super_process_instance' in local_var_params and local_var_params['super_process_instance'] is not None:  # noqa: E501
            query_params.append(('superProcessInstance', local_var_params['super_process_instance']))  # noqa: E501
        if 'sub_process_instance' in local_var_params and local_var_params['sub_process_instance'] is not None:  # noqa: E501
            query_params.append(('subProcessInstance', local_var_params['sub_process_instance']))  # noqa: E501
        if 'super_case_instance' in local_var_params and local_var_params['super_case_instance'] is not None:  # noqa: E501
            query_params.append(('superCaseInstance', local_var_params['super_case_instance']))  # noqa: E501
        if 'sub_case_instance' in local_var_params and local_var_params['sub_case_instance'] is not None:  # noqa: E501
            query_params.append(('subCaseInstance', local_var_params['sub_case_instance']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'with_incident' in local_var_params and local_var_params['with_incident'] is not None:  # noqa: E501
            query_params.append(('withIncident', local_var_params['with_incident']))  # noqa: E501
        if 'incident_id' in local_var_params and local_var_params['incident_id'] is not None:  # noqa: E501
            query_params.append(('incidentId', local_var_params['incident_id']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'process_definition_without_tenant_id' in local_var_params and local_var_params['process_definition_without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionWithoutTenantId', local_var_params['process_definition_without_tenant_id']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'root_process_instances' in local_var_params and local_var_params['root_process_instances'] is not None:  # noqa: E501
            query_params.append(('rootProcessInstances', local_var_params['root_process_instances']))  # noqa: E501
        if 'leaf_process_instances' in local_var_params and local_var_params['leaf_process_instances'] is not None:  # noqa: E501
            query_params.append(('leafProcessInstances', local_var_params['leaf_process_instances']))  # noqa: E501
        if 'variables' in local_var_params and local_var_params['variables'] is not None:  # noqa: E501
            query_params.append(('variables', local_var_params['variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProcessInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_process_instances_count(self, **kwargs):  # noqa: E501
        """get_process_instances_count  # noqa: E501

        Queries for the number of process instances that fulfill given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_ids: Filter by a comma-separated list of process instance ids.
        :param str business_key: Filter by process instance business key.
        :param str business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param str case_instance_id: Filter by case instance id.
        :param str process_definition_id: Filter by the deployment the id belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys.
        :param str process_definition_key_not_in: Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys.
        :param str deployment_id: Filter by the deployment the id belongs to.
        :param str super_process_instance: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance: Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.
        :param str super_case_instance: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance: Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.
        :param bool active: Only include active process instances. Value may only be true, as false is the default behavior.
        :param bool suspended: Only include suspended process instances. Value may only be true, as false is the default behavior.
        :param bool with_incident: Filter by presence of incidents. Selects only process instances that have an incident.
        :param str incident_id: Filter by the incident id.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include process instances which belong to no tenant.
        :param bool process_definition_without_tenant_id: Only include process instances which process definition has no tenant id.
        :param str activity_id_in: Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool leaf_process_instances: Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances).
        :param str variables: Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_process_instances_count_with_http_info(**kwargs)  # noqa: E501

    def get_process_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """get_process_instances_count  # noqa: E501

        Queries for the number of process instances that fulfill given parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_process_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_ids: Filter by a comma-separated list of process instance ids.
        :param str business_key: Filter by process instance business key.
        :param str business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param str case_instance_id: Filter by case instance id.
        :param str process_definition_id: Filter by the deployment the id belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a comma-separated list of process definition keys. A process instance must have one of the given process definition keys.
        :param str process_definition_key_not_in: Exclude instances by a comma-separated list of process definition keys. A process instance must not have one of the given process definition keys.
        :param str deployment_id: Filter by the deployment the id belongs to.
        :param str super_process_instance: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance: Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.
        :param str super_case_instance: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance: Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.
        :param bool active: Only include active process instances. Value may only be true, as false is the default behavior.
        :param bool suspended: Only include suspended process instances. Value may only be true, as false is the default behavior.
        :param bool with_incident: Filter by presence of incidents. Selects only process instances that have an incident.
        :param str incident_id: Filter by the incident id.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include process instances which belong to no tenant.
        :param bool process_definition_without_tenant_id: Only include process instances which process definition has no tenant id.
        :param str activity_id_in: Filter by a comma-separated list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool leaf_process_instances: Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances).
        :param str variables: Only include process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note**: Values are always treated as String objects on server side.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_ids',
            'business_key',
            'business_key_like',
            'case_instance_id',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_definition_key_not_in',
            'deployment_id',
            'super_process_instance',
            'sub_process_instance',
            'super_case_instance',
            'sub_case_instance',
            'active',
            'suspended',
            'with_incident',
            'incident_id',
            'incident_type',
            'incident_message',
            'incident_message_like',
            'tenant_id_in',
            'without_tenant_id',
            'process_definition_without_tenant_id',
            'activity_id_in',
            'root_process_instances',
            'leaf_process_instances',
            'variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_process_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'process_instance_ids' in local_var_params and local_var_params['process_instance_ids'] is not None:  # noqa: E501
            query_params.append(('processInstanceIds', local_var_params['process_instance_ids']))  # noqa: E501
        if 'business_key' in local_var_params and local_var_params['business_key'] is not None:  # noqa: E501
            query_params.append(('businessKey', local_var_params['business_key']))  # noqa: E501
        if 'business_key_like' in local_var_params and local_var_params['business_key_like'] is not None:  # noqa: E501
            query_params.append(('businessKeyLike', local_var_params['business_key_like']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_definition_key_not_in' in local_var_params and local_var_params['process_definition_key_not_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyNotIn', local_var_params['process_definition_key_not_in']))  # noqa: E501
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'super_process_instance' in local_var_params and local_var_params['super_process_instance'] is not None:  # noqa: E501
            query_params.append(('superProcessInstance', local_var_params['super_process_instance']))  # noqa: E501
        if 'sub_process_instance' in local_var_params and local_var_params['sub_process_instance'] is not None:  # noqa: E501
            query_params.append(('subProcessInstance', local_var_params['sub_process_instance']))  # noqa: E501
        if 'super_case_instance' in local_var_params and local_var_params['super_case_instance'] is not None:  # noqa: E501
            query_params.append(('superCaseInstance', local_var_params['super_case_instance']))  # noqa: E501
        if 'sub_case_instance' in local_var_params and local_var_params['sub_case_instance'] is not None:  # noqa: E501
            query_params.append(('subCaseInstance', local_var_params['sub_case_instance']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'with_incident' in local_var_params and local_var_params['with_incident'] is not None:  # noqa: E501
            query_params.append(('withIncident', local_var_params['with_incident']))  # noqa: E501
        if 'incident_id' in local_var_params and local_var_params['incident_id'] is not None:  # noqa: E501
            query_params.append(('incidentId', local_var_params['incident_id']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'process_definition_without_tenant_id' in local_var_params and local_var_params['process_definition_without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionWithoutTenantId', local_var_params['process_definition_without_tenant_id']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'root_process_instances' in local_var_params and local_var_params['root_process_instances'] is not None:  # noqa: E501
            query_params.append(('rootProcessInstances', local_var_params['root_process_instances']))  # noqa: E501
        if 'leaf_process_instances' in local_var_params and local_var_params['leaf_process_instances'] is not None:  # noqa: E501
            query_params.append(('leafProcessInstances', local_var_params['leaf_process_instances']))  # noqa: E501
        if 'variables' in local_var_params and local_var_params['variables'] is not None:  # noqa: E501
            query_params.append(('variables', local_var_params['variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_process_instance(self, id, **kwargs):  # noqa: E501
        """modify_process_instance  # noqa: E501

        Submits a list of modification instructions to change a process instance's execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request's body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_process_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to modify. (required)
        :param ProcessInstanceModificationDto process_instance_modification_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_process_instance_with_http_info(id, **kwargs)  # noqa: E501

    def modify_process_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """modify_process_instance  # noqa: E501

        Submits a list of modification instructions to change a process instance's execution state. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Canceling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed immediately and in the order they are provided in this request's body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/develop/user-guide/process-engine/process-instance-modification/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_process_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to modify. (required)
        :param ProcessInstanceModificationDto process_instance_modification_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'process_instance_modification_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_process_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `modify_process_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_instance_modification_dto' in local_var_params:
            body_params = local_var_params['process_instance_modification_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/modification', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_process_instance_async_operation(self, id, **kwargs):  # noqa: E501
        """modify_process_instance_async_operation  # noqa: E501

        Submits a list of modification instructions to change a process instance's execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request's body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-instance-modification/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_process_instance_async_operation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to modify. (required)
        :param ProcessInstanceModificationDto process_instance_modification_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_process_instance_async_operation_with_http_info(id, **kwargs)  # noqa: E501

    def modify_process_instance_async_operation_with_http_info(self, id, **kwargs):  # noqa: E501
        """modify_process_instance_async_operation  # noqa: E501

        Submits a list of modification instructions to change a process instance's execution state async. A modification instruction is one of the following:  * Starting execution before an activity * Starting execution after an activity on its single outgoing sequence flow * Starting execution on a specific sequence flow * Cancelling an activity instance, transition instance, or all instances (activity or transition) for an activity  Instructions are executed asynchronous and in the order they are provided in this request's body. Variables can be provided with every starting instruction.  The exact semantics of modification can be read about in the [User guide](https://docs.camunda.org/manual/7.14/user-guide/process-engine/process-instance-modification/).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_process_instance_async_operation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to modify. (required)
        :param ProcessInstanceModificationDto process_instance_modification_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'process_instance_modification_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_process_instance_async_operation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `modify_process_instance_async_operation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_instance_modification_dto' in local_var_params:
            body_params = local_var_params['process_instance_modification_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/modification-async', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_process_instance_variables(self, id, **kwargs):  # noqa: E501
        """modify_process_instance_variables  # noqa: E501

        Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_process_instance_variables(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to set variables for. (required)
        :param PatchVariablesDto patch_variables_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_process_instance_variables_with_http_info(id, **kwargs)  # noqa: E501

    def modify_process_instance_variables_with_http_info(self, id, **kwargs):  # noqa: E501
        """modify_process_instance_variables  # noqa: E501

        Updates or deletes the variables of a process instance by id. Updates precede deletions. So, if a variable is updated AND deleted, the deletion overrides the update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_process_instance_variables_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to set variables for. (required)
        :param PatchVariablesDto patch_variables_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'patch_variables_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_process_instance_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `modify_process_instance_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patch_variables_dto' in local_var_params:
            body_params = local_var_params['patch_variables_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_process_instances(self, **kwargs):  # noqa: E501
        """query_process_instances  # noqa: E501

        Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types `string`, `number` or `boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_process_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param ProcessInstanceQueryDto process_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ProcessInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_process_instances_with_http_info(**kwargs)  # noqa: E501

    def query_process_instances_with_http_info(self, **kwargs):  # noqa: E501
        """query_process_instances  # noqa: E501

        Queries for process instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the Get Instances method because it allows filtering by multiple process variables of types `string`, `number` or `boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_process_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param ProcessInstanceQueryDto process_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ProcessInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'process_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_process_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_instance_query_dto' in local_var_params:
            body_params = local_var_params['process_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProcessInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_process_instances_count(self, **kwargs):  # noqa: E501
        """query_process_instances_count  # noqa: E501

        Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_process_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProcessInstanceQueryDto process_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_process_instances_count_with_http_info(**kwargs)  # noqa: E501

    def query_process_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """query_process_instances_count  # noqa: E501

        Queries for the number of process instances that fulfill the given parameters. This method takes the same message body as the Get Instances (POST) method and therefore it is slightly more powerful than the Get Instance Count method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_process_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProcessInstanceQueryDto process_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_process_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_instance_query_dto' in local_var_params:
            body_params = local_var_params['process_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_process_instance_variable(self, id, var_name, **kwargs):  # noqa: E501
        """set_process_instance_variable  # noqa: E501

        Sets a variable of a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_process_instance_variable(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to set the variable for. (required)
        :param str var_name: The name of the variable to set. (required)
        :param VariableValueDto variable_value_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_process_instance_variable_with_http_info(id, var_name, **kwargs)  # noqa: E501

    def set_process_instance_variable_with_http_info(self, id, var_name, **kwargs):  # noqa: E501
        """set_process_instance_variable  # noqa: E501

        Sets a variable of a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_process_instance_variable_with_http_info(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to set the variable for. (required)
        :param str var_name: The name of the variable to set. (required)
        :param VariableValueDto variable_value_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'var_name',
            'variable_value_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_process_instance_variable" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `set_process_instance_variable`")  # noqa: E501
        # verify the required parameter 'var_name' is set
        if self.api_client.client_side_validation and ('var_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['var_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `var_name` when calling `set_process_instance_variable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'var_name' in local_var_params:
            path_params['varName'] = local_var_params['var_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'variable_value_dto' in local_var_params:
            body_params = local_var_params['variable_value_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables/{varName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_process_instance_variable_binary(self, id, var_name, **kwargs):  # noqa: E501
        """set_process_instance_variable_binary  # noqa: E501

        Sets the serialized value for a binary variable or the binary value for a file variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_process_instance_variable_binary(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variable for. (required)
        :param str var_name: The name of the variable to retrieve. (required)
        :param file data: The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory.
        :param str value_type: The name of the variable type. Either Bytes for a byte array variable or File for a file variable.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_process_instance_variable_binary_with_http_info(id, var_name, **kwargs)  # noqa: E501

    def set_process_instance_variable_binary_with_http_info(self, id, var_name, **kwargs):  # noqa: E501
        """set_process_instance_variable_binary  # noqa: E501

        Sets the serialized value for a binary variable or the binary value for a file variable.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_process_instance_variable_binary_with_http_info(id, var_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to retrieve the variable for. (required)
        :param str var_name: The name of the variable to retrieve. (required)
        :param file data: The binary data to be set. For File variables, this multipart can contain the filename, binary value and MIME type of the file variable to be set Only the filename is mandatory.
        :param str value_type: The name of the variable type. Either Bytes for a byte array variable or File for a file variable.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'var_name',
            'data',
            'value_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_process_instance_variable_binary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `set_process_instance_variable_binary`")  # noqa: E501
        # verify the required parameter 'var_name' is set
        if self.api_client.client_side_validation and ('var_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['var_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `var_name` when calling `set_process_instance_variable_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'var_name' in local_var_params:
            path_params['varName'] = local_var_params['var_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'data' in local_var_params:
            local_var_files['data'] = local_var_params['data']  # noqa: E501
        if 'value_type' in local_var_params:
            form_params.append(('valueType', local_var_params['value_type']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/variables/{varName}/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_retries_by_process(self, **kwargs):  # noqa: E501
        """set_retries_by_process  # noqa: E501

        Create a batch to set retries of jobs associated with given processes asynchronously.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_retries_by_process(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetJobRetriesByProcessDto set_job_retries_by_process_dto: Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: `historicProcessInstanceQuery`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_retries_by_process_with_http_info(**kwargs)  # noqa: E501

    def set_retries_by_process_with_http_info(self, **kwargs):  # noqa: E501
        """set_retries_by_process  # noqa: E501

        Create a batch to set retries of jobs associated with given processes asynchronously.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_retries_by_process_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetJobRetriesByProcessDto set_job_retries_by_process_dto: Please note that if both processInstances and processInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: `historicProcessInstanceQuery`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_job_retries_by_process_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_retries_by_process" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_job_retries_by_process_dto' in local_var_params:
            body_params = local_var_params['set_job_retries_by_process_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/job-retries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_retries_by_process_historic_query_based(self, **kwargs):  # noqa: E501
        """set_retries_by_process_historic_query_based  # noqa: E501

        Create a batch to set retries of jobs asynchronously based on a historic process instance query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_retries_by_process_historic_query_based(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetJobRetriesByProcessDto set_job_retries_by_process_dto: Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: `processInstanceQuery`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_retries_by_process_historic_query_based_with_http_info(**kwargs)  # noqa: E501

    def set_retries_by_process_historic_query_based_with_http_info(self, **kwargs):  # noqa: E501
        """set_retries_by_process_historic_query_based  # noqa: E501

        Create a batch to set retries of jobs asynchronously based on a historic process instance query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_retries_by_process_historic_query_based_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetJobRetriesByProcessDto set_job_retries_by_process_dto: Please note that if both processInstances and historicProcessInstanceQuery are provided, then the resulting execution will be performed on the union of these sets. **Unallowed property**: `processInstanceQuery`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_job_retries_by_process_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_retries_by_process_historic_query_based" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_job_retries_by_process_dto' in local_var_params:
            body_params = local_var_params['set_job_retries_by_process_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/job-retries-historic-query-based', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_variables_async_operation(self, **kwargs):  # noqa: E501
        """set_variables_async_operation  # noqa: E501

        Update or create runtime process variables in the root scope of process instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_variables_async_operation(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetVariablesAsyncDto set_variables_async_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_variables_async_operation_with_http_info(**kwargs)  # noqa: E501

    def set_variables_async_operation_with_http_info(self, **kwargs):  # noqa: E501
        """set_variables_async_operation  # noqa: E501

        Update or create runtime process variables in the root scope of process instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_variables_async_operation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetVariablesAsyncDto set_variables_async_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_variables_async_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_variables_async_operation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_variables_async_dto' in local_var_params:
            body_params = local_var_params['set_variables_async_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/variables-async', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_suspension_state(self, **kwargs):  # noqa: E501
        """update_suspension_state  # noqa: E501

        Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * `suspend` * `processDefinitionId`  # Activate/Suspend Process Instance By Process Definition Key  * `suspend` * `processDefinitionKey` * `processDefinitionTenantId` * `processDefinitionWithoutTenantId`  # Activate/Suspend Process Instance In Group * `suspend` * `processInstanceIds` * `processInstanceQuery` * `historicProcessInstanceQuery`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_suspension_state(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProcessInstanceSuspensionStateDto process_instance_suspension_state_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_suspension_state_with_http_info(**kwargs)  # noqa: E501

    def update_suspension_state_with_http_info(self, **kwargs):  # noqa: E501
        """update_suspension_state  # noqa: E501

        Activates or suspends process instances by providing certain criteria:  # Activate/Suspend Process Instance By Process Definition Id * `suspend` * `processDefinitionId`  # Activate/Suspend Process Instance By Process Definition Key  * `suspend` * `processDefinitionKey` * `processDefinitionTenantId` * `processDefinitionWithoutTenantId`  # Activate/Suspend Process Instance In Group * `suspend` * `processInstanceIds` * `processInstanceQuery` * `historicProcessInstanceQuery`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_suspension_state_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProcessInstanceSuspensionStateDto process_instance_suspension_state_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_suspension_state_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_suspension_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_instance_suspension_state_dto' in local_var_params:
            body_params = local_var_params['process_instance_suspension_state_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/suspended', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_suspension_state_async_operation(self, **kwargs):  # noqa: E501
        """update_suspension_state_async_operation  # noqa: E501

        Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_suspension_state_async_operation(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProcessInstanceSuspensionStateAsyncDto process_instance_suspension_state_async_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_suspension_state_async_operation_with_http_info(**kwargs)  # noqa: E501

    def update_suspension_state_async_operation_with_http_info(self, **kwargs):  # noqa: E501
        """update_suspension_state_async_operation  # noqa: E501

        Activates or suspends process instances asynchronously with a list of process instance ids, a process instance query, and/or a historical process instance query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_suspension_state_async_operation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProcessInstanceSuspensionStateAsyncDto process_instance_suspension_state_async_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_suspension_state_async_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_suspension_state_async_operation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_instance_suspension_state_async_dto' in local_var_params:
            body_params = local_var_params['process_instance_suspension_state_async_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/suspended-async', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_suspension_state_by_id(self, id, **kwargs):  # noqa: E501
        """update_suspension_state_by_id  # noqa: E501

        Activates or suspends a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_suspension_state_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to activate or suspend. (required)
        :param SuspensionStateDto suspension_state_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_suspension_state_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def update_suspension_state_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_suspension_state_by_id  # noqa: E501

        Activates or suspends a given process instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_suspension_state_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance to activate or suspend. (required)
        :param SuspensionStateDto suspension_state_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'suspension_state_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_suspension_state_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_suspension_state_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'suspension_state_dto' in local_var_params:
            body_params = local_var_params['suspension_state_dto']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/process-instance/{id}/suspended', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
