# coding: utf-8

"""
    Camunda BPM REST API

    OpenApi Spec for Camunda BPM REST API.  # noqa: E501

    The version of the OpenAPI document: 7.14.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ExternalTaskApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def complete_external_task_resource(self, id, **kwargs):  # noqa: E501
        """complete_external_task_resource  # noqa: E501

        Completes an external task by id and updates process variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_external_task_resource(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to complete. (required)
        :param CompleteExternalTaskDto complete_external_task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.complete_external_task_resource_with_http_info(id, **kwargs)  # noqa: E501

    def complete_external_task_resource_with_http_info(self, id, **kwargs):  # noqa: E501
        """complete_external_task_resource  # noqa: E501

        Completes an external task by id and updates process variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_external_task_resource_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the task to complete. (required)
        :param CompleteExternalTaskDto complete_external_task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'complete_external_task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_external_task_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `complete_external_task_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'complete_external_task_dto' in local_var_params:
            body_params = local_var_params['complete_external_task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/complete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def extend_lock(self, id, **kwargs):  # noqa: E501
        """extend_lock  # noqa: E501

        Extends the timeout of the lock by a given amount of time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.extend_lock(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task. (required)
        :param ExtendLockOnExternalTaskDto extend_lock_on_external_task_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.extend_lock_with_http_info(id, **kwargs)  # noqa: E501

    def extend_lock_with_http_info(self, id, **kwargs):  # noqa: E501
        """extend_lock  # noqa: E501

        Extends the timeout of the lock by a given amount of time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.extend_lock_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task. (required)
        :param ExtendLockOnExternalTaskDto extend_lock_on_external_task_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'extend_lock_on_external_task_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method extend_lock" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `extend_lock`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'extend_lock_on_external_task_dto' in local_var_params:
            body_params = local_var_params['extend_lock_on_external_task_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/extendLock', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fetch_and_lock(self, **kwargs):  # noqa: E501
        """fetch_and_lock  # noqa: E501

        Fetches and locks a specific number of external tasks for execution by a worker. Query can be restricted to specific task topics and for each task topic an individual lock time can be provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_and_lock(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FetchExternalTasksDto fetch_external_tasks_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[LockedExternalTaskDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_and_lock_with_http_info(**kwargs)  # noqa: E501

    def fetch_and_lock_with_http_info(self, **kwargs):  # noqa: E501
        """fetch_and_lock  # noqa: E501

        Fetches and locks a specific number of external tasks for execution by a worker. Query can be restricted to specific task topics and for each task topic an individual lock time can be provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_and_lock_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FetchExternalTasksDto fetch_external_tasks_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[LockedExternalTaskDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'fetch_external_tasks_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_and_lock" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'fetch_external_tasks_dto' in local_var_params:
            body_params = local_var_params['fetch_external_tasks_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/fetchAndLock', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LockedExternalTaskDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_task(self, id, **kwargs):  # noqa: E501
        """get_external_task  # noqa: E501

        Retrieves an external task by id, corresponding to the `ExternalTask` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_task(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExternalTaskDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_task_with_http_info(id, **kwargs)  # noqa: E501

    def get_external_task_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_external_task  # noqa: E501

        Retrieves an external task by id, corresponding to the `ExternalTask` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_task_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExternalTaskDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_external_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExternalTaskDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_task_error_details(self, id, **kwargs):  # noqa: E501
        """get_external_task_error_details  # noqa: E501

        Retrieves the error details in the context of a running external task by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_task_error_details(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task for which the error details should be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_task_error_details_with_http_info(id, **kwargs)  # noqa: E501

    def get_external_task_error_details_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_external_task_error_details  # noqa: E501

        Retrieves the error details in the context of a running external task by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_task_error_details_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task for which the error details should be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(str, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_task_error_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_external_task_error_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/errorDetails', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_tasks(self, **kwargs):  # noqa: E501
        """get_external_tasks  # noqa: E501

        Queries for the external tasks that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of executions. The size of the result set can be retrieved by using the [Get External Task Count](https://docs.camunda.org/manual/7.14/reference/rest/external-task/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_task_id: Filter by an external task's id.
        :param str external_task_id_in: Filter by the comma-separated list of external task ids.
        :param str topic_name: Filter by an external task topic.
        :param str worker_id: Filter by the id of the worker that the task was most recently locked by.
        :param bool locked: Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.
        :param bool not_locked: Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_retries_left: Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.
        :param bool no_retries_left: Only include external tasks that have 0 retries. Value may only be `true`, as `false` matches any external task.
        :param datetime lock_expiration_after: Restrict to external tasks that have a lock that expires after a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime lock_expiration_before: Restrict to external tasks that have a lock that expires before a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Filter by the id of the activity that an external task is created for.
        :param str activity_id_in: Filter by the comma-separated list of ids of the activities that an external task is created for.
        :param str execution_id: Filter by the id of the execution that an external task belongs to.
        :param str process_instance_id: Filter by the id of the process instance that an external task belongs to.
        :param str process_instance_id_in: Filter by a comma-separated list of process instance ids that an external task may belong to.
        :param str process_definition_id: Filter by the id of the process definition that an external task belongs to.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. An external task must have one of the given tenant ids.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` matches any external task.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` matches any external task.
        :param int priority_higher_than_or_equals: Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param int priority_lower_than_or_equals: Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ExternalTaskDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_tasks_with_http_info(**kwargs)  # noqa: E501

    def get_external_tasks_with_http_info(self, **kwargs):  # noqa: E501
        """get_external_tasks  # noqa: E501

        Queries for the external tasks that fulfill given parameters. Parameters may be static as well as dynamic runtime properties of executions. The size of the result set can be retrieved by using the [Get External Task Count](https://docs.camunda.org/manual/7.14/reference/rest/external-task/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_task_id: Filter by an external task's id.
        :param str external_task_id_in: Filter by the comma-separated list of external task ids.
        :param str topic_name: Filter by an external task topic.
        :param str worker_id: Filter by the id of the worker that the task was most recently locked by.
        :param bool locked: Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.
        :param bool not_locked: Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_retries_left: Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.
        :param bool no_retries_left: Only include external tasks that have 0 retries. Value may only be `true`, as `false` matches any external task.
        :param datetime lock_expiration_after: Restrict to external tasks that have a lock that expires after a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime lock_expiration_before: Restrict to external tasks that have a lock that expires before a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Filter by the id of the activity that an external task is created for.
        :param str activity_id_in: Filter by the comma-separated list of ids of the activities that an external task is created for.
        :param str execution_id: Filter by the id of the execution that an external task belongs to.
        :param str process_instance_id: Filter by the id of the process instance that an external task belongs to.
        :param str process_instance_id_in: Filter by a comma-separated list of process instance ids that an external task may belong to.
        :param str process_definition_id: Filter by the id of the process definition that an external task belongs to.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. An external task must have one of the given tenant ids.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` matches any external task.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` matches any external task.
        :param int priority_higher_than_or_equals: Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param int priority_lower_than_or_equals: Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ExternalTaskDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_task_id',
            'external_task_id_in',
            'topic_name',
            'worker_id',
            'locked',
            'not_locked',
            'with_retries_left',
            'no_retries_left',
            'lock_expiration_after',
            'lock_expiration_before',
            'activity_id',
            'activity_id_in',
            'execution_id',
            'process_instance_id',
            'process_instance_id_in',
            'process_definition_id',
            'tenant_id_in',
            'active',
            'suspended',
            'priority_higher_than_or_equals',
            'priority_lower_than_or_equals',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_tasks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'external_task_id' in local_var_params and local_var_params['external_task_id'] is not None:  # noqa: E501
            query_params.append(('externalTaskId', local_var_params['external_task_id']))  # noqa: E501
        if 'external_task_id_in' in local_var_params and local_var_params['external_task_id_in'] is not None:  # noqa: E501
            query_params.append(('externalTaskIdIn', local_var_params['external_task_id_in']))  # noqa: E501
        if 'topic_name' in local_var_params and local_var_params['topic_name'] is not None:  # noqa: E501
            query_params.append(('topicName', local_var_params['topic_name']))  # noqa: E501
        if 'worker_id' in local_var_params and local_var_params['worker_id'] is not None:  # noqa: E501
            query_params.append(('workerId', local_var_params['worker_id']))  # noqa: E501
        if 'locked' in local_var_params and local_var_params['locked'] is not None:  # noqa: E501
            query_params.append(('locked', local_var_params['locked']))  # noqa: E501
        if 'not_locked' in local_var_params and local_var_params['not_locked'] is not None:  # noqa: E501
            query_params.append(('notLocked', local_var_params['not_locked']))  # noqa: E501
        if 'with_retries_left' in local_var_params and local_var_params['with_retries_left'] is not None:  # noqa: E501
            query_params.append(('withRetriesLeft', local_var_params['with_retries_left']))  # noqa: E501
        if 'no_retries_left' in local_var_params and local_var_params['no_retries_left'] is not None:  # noqa: E501
            query_params.append(('noRetriesLeft', local_var_params['no_retries_left']))  # noqa: E501
        if 'lock_expiration_after' in local_var_params and local_var_params['lock_expiration_after'] is not None:  # noqa: E501
            query_params.append(('lockExpirationAfter', local_var_params['lock_expiration_after']))  # noqa: E501
        if 'lock_expiration_before' in local_var_params and local_var_params['lock_expiration_before'] is not None:  # noqa: E501
            query_params.append(('lockExpirationBefore', local_var_params['lock_expiration_before']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'priority_higher_than_or_equals' in local_var_params and local_var_params['priority_higher_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('priorityHigherThanOrEquals', local_var_params['priority_higher_than_or_equals']))  # noqa: E501
        if 'priority_lower_than_or_equals' in local_var_params and local_var_params['priority_lower_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('priorityLowerThanOrEquals', local_var_params['priority_lower_than_or_equals']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExternalTaskDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_tasks_count(self, **kwargs):  # noqa: E501
        """get_external_tasks_count  # noqa: E501

        Queries for the number of external tasks that fulfill given parameters. Takes the same parameters as the [Get External Tasks](https://docs.camunda.org/manual/7.14/reference/rest/external-task/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_tasks_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_task_id: Filter by an external task's id.
        :param str external_task_id_in: Filter by the comma-separated list of external task ids.
        :param str topic_name: Filter by an external task topic.
        :param str worker_id: Filter by the id of the worker that the task was most recently locked by.
        :param bool locked: Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.
        :param bool not_locked: Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_retries_left: Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.
        :param bool no_retries_left: Only include external tasks that have 0 retries. Value may only be `true`, as `false` matches any external task.
        :param datetime lock_expiration_after: Restrict to external tasks that have a lock that expires after a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime lock_expiration_before: Restrict to external tasks that have a lock that expires before a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Filter by the id of the activity that an external task is created for.
        :param str activity_id_in: Filter by the comma-separated list of ids of the activities that an external task is created for.
        :param str execution_id: Filter by the id of the execution that an external task belongs to.
        :param str process_instance_id: Filter by the id of the process instance that an external task belongs to.
        :param str process_instance_id_in: Filter by a comma-separated list of process instance ids that an external task may belong to.
        :param str process_definition_id: Filter by the id of the process definition that an external task belongs to.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. An external task must have one of the given tenant ids.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` matches any external task.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` matches any external task.
        :param int priority_higher_than_or_equals: Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param int priority_lower_than_or_equals: Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_external_tasks_count_with_http_info(**kwargs)  # noqa: E501

    def get_external_tasks_count_with_http_info(self, **kwargs):  # noqa: E501
        """get_external_tasks_count  # noqa: E501

        Queries for the number of external tasks that fulfill given parameters. Takes the same parameters as the [Get External Tasks](https://docs.camunda.org/manual/7.14/reference/rest/external-task/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_tasks_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str external_task_id: Filter by an external task's id.
        :param str external_task_id_in: Filter by the comma-separated list of external task ids.
        :param str topic_name: Filter by an external task topic.
        :param str worker_id: Filter by the id of the worker that the task was most recently locked by.
        :param bool locked: Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.
        :param bool not_locked: Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_retries_left: Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.
        :param bool no_retries_left: Only include external tasks that have 0 retries. Value may only be `true`, as `false` matches any external task.
        :param datetime lock_expiration_after: Restrict to external tasks that have a lock that expires after a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime lock_expiration_before: Restrict to external tasks that have a lock that expires before a given date. By [default](https://docs.camunda.org/manual/7.14/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Filter by the id of the activity that an external task is created for.
        :param str activity_id_in: Filter by the comma-separated list of ids of the activities that an external task is created for.
        :param str execution_id: Filter by the id of the execution that an external task belongs to.
        :param str process_instance_id: Filter by the id of the process instance that an external task belongs to.
        :param str process_instance_id_in: Filter by a comma-separated list of process instance ids that an external task may belong to.
        :param str process_definition_id: Filter by the id of the process definition that an external task belongs to.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. An external task must have one of the given tenant ids.
        :param bool active: Only include active tasks. Value may only be `true`, as `false` matches any external task.
        :param bool suspended: Only include suspended tasks. Value may only be `true`, as `false` matches any external task.
        :param int priority_higher_than_or_equals: Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param int priority_lower_than_or_equals: Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_task_id',
            'external_task_id_in',
            'topic_name',
            'worker_id',
            'locked',
            'not_locked',
            'with_retries_left',
            'no_retries_left',
            'lock_expiration_after',
            'lock_expiration_before',
            'activity_id',
            'activity_id_in',
            'execution_id',
            'process_instance_id',
            'process_instance_id_in',
            'process_definition_id',
            'tenant_id_in',
            'active',
            'suspended',
            'priority_higher_than_or_equals',
            'priority_lower_than_or_equals'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_tasks_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'external_task_id' in local_var_params and local_var_params['external_task_id'] is not None:  # noqa: E501
            query_params.append(('externalTaskId', local_var_params['external_task_id']))  # noqa: E501
        if 'external_task_id_in' in local_var_params and local_var_params['external_task_id_in'] is not None:  # noqa: E501
            query_params.append(('externalTaskIdIn', local_var_params['external_task_id_in']))  # noqa: E501
        if 'topic_name' in local_var_params and local_var_params['topic_name'] is not None:  # noqa: E501
            query_params.append(('topicName', local_var_params['topic_name']))  # noqa: E501
        if 'worker_id' in local_var_params and local_var_params['worker_id'] is not None:  # noqa: E501
            query_params.append(('workerId', local_var_params['worker_id']))  # noqa: E501
        if 'locked' in local_var_params and local_var_params['locked'] is not None:  # noqa: E501
            query_params.append(('locked', local_var_params['locked']))  # noqa: E501
        if 'not_locked' in local_var_params and local_var_params['not_locked'] is not None:  # noqa: E501
            query_params.append(('notLocked', local_var_params['not_locked']))  # noqa: E501
        if 'with_retries_left' in local_var_params and local_var_params['with_retries_left'] is not None:  # noqa: E501
            query_params.append(('withRetriesLeft', local_var_params['with_retries_left']))  # noqa: E501
        if 'no_retries_left' in local_var_params and local_var_params['no_retries_left'] is not None:  # noqa: E501
            query_params.append(('noRetriesLeft', local_var_params['no_retries_left']))  # noqa: E501
        if 'lock_expiration_after' in local_var_params and local_var_params['lock_expiration_after'] is not None:  # noqa: E501
            query_params.append(('lockExpirationAfter', local_var_params['lock_expiration_after']))  # noqa: E501
        if 'lock_expiration_before' in local_var_params and local_var_params['lock_expiration_before'] is not None:  # noqa: E501
            query_params.append(('lockExpirationBefore', local_var_params['lock_expiration_before']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'priority_higher_than_or_equals' in local_var_params and local_var_params['priority_higher_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('priorityHigherThanOrEquals', local_var_params['priority_higher_than_or_equals']))  # noqa: E501
        if 'priority_lower_than_or_equals' in local_var_params and local_var_params['priority_lower_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('priorityLowerThanOrEquals', local_var_params['priority_lower_than_or_equals']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_topic_names(self, **kwargs):  # noqa: E501
        """get_topic_names  # noqa: E501

        Queries for distinct topic names of external tasks that fulfill given parameters. Query can be restricted to only tasks with retries left, tasks that are locked, or tasks that are unlocked. The parameters withLockedTasks and withUnlockedTasks are exclusive. Setting them both to true will return an empty list. Providing no parameters will return a list of all distinct topic names with external tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_topic_names(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool with_locked_tasks: Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_unlocked_tasks: Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_retries_left: Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_topic_names_with_http_info(**kwargs)  # noqa: E501

    def get_topic_names_with_http_info(self, **kwargs):  # noqa: E501
        """get_topic_names  # noqa: E501

        Queries for distinct topic names of external tasks that fulfill given parameters. Query can be restricted to only tasks with retries left, tasks that are locked, or tasks that are unlocked. The parameters withLockedTasks and withUnlockedTasks are exclusive. Setting them both to true will return an empty list. Providing no parameters will return a list of all distinct topic names with external tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_topic_names_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param bool with_locked_tasks: Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_unlocked_tasks: Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.
        :param bool with_retries_left: Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'with_locked_tasks',
            'with_unlocked_tasks',
            'with_retries_left'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_topic_names" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'with_locked_tasks' in local_var_params and local_var_params['with_locked_tasks'] is not None:  # noqa: E501
            query_params.append(('withLockedTasks', local_var_params['with_locked_tasks']))  # noqa: E501
        if 'with_unlocked_tasks' in local_var_params and local_var_params['with_unlocked_tasks'] is not None:  # noqa: E501
            query_params.append(('withUnlockedTasks', local_var_params['with_unlocked_tasks']))  # noqa: E501
        if 'with_retries_left' in local_var_params and local_var_params['with_retries_left'] is not None:  # noqa: E501
            query_params.append(('withRetriesLeft', local_var_params['with_retries_left']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/topic-names', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_external_task_bpmn_error(self, id, **kwargs):  # noqa: E501
        """handle_external_task_bpmn_error  # noqa: E501

        Reports a business error in the context of a running external task by id. The error code must be specified to identify the BPMN error handler.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_external_task_bpmn_error(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task in which context a BPMN error is reported. (required)
        :param ExternalTaskBpmnError external_task_bpmn_error:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.handle_external_task_bpmn_error_with_http_info(id, **kwargs)  # noqa: E501

    def handle_external_task_bpmn_error_with_http_info(self, id, **kwargs):  # noqa: E501
        """handle_external_task_bpmn_error  # noqa: E501

        Reports a business error in the context of a running external task by id. The error code must be specified to identify the BPMN error handler.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_external_task_bpmn_error_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task in which context a BPMN error is reported. (required)
        :param ExternalTaskBpmnError external_task_bpmn_error:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'external_task_bpmn_error'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_external_task_bpmn_error" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `handle_external_task_bpmn_error`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_task_bpmn_error' in local_var_params:
            body_params = local_var_params['external_task_bpmn_error']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/bpmnError', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_failure(self, id, **kwargs):  # noqa: E501
        """handle_failure  # noqa: E501

        Reports a failure to execute an external task by id. A number of retries and a timeout until the task can be retried can be specified. If retries are set to 0, an incident for this task is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_failure(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to report a failure for. (required)
        :param ExternalTaskFailureDto external_task_failure_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.handle_failure_with_http_info(id, **kwargs)  # noqa: E501

    def handle_failure_with_http_info(self, id, **kwargs):  # noqa: E501
        """handle_failure  # noqa: E501

        Reports a failure to execute an external task by id. A number of retries and a timeout until the task can be retried can be specified. If retries are set to 0, an incident for this task is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_failure_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to report a failure for. (required)
        :param ExternalTaskFailureDto external_task_failure_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'external_task_failure_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_failure" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `handle_failure`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_task_failure_dto' in local_var_params:
            body_params = local_var_params['external_task_failure_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/failure', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_external_tasks(self, **kwargs):  # noqa: E501
        """query_external_tasks  # noqa: E501

        Queries for external tasks that fulfill given parameters in the form of a JSON object.  This method is slightly more powerful than the [Get External Tasks](https://docs.camunda.org/manual/7.14/reference/rest/external-task/get-query/) method because it allows to specify a hierarchical result sorting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_external_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param ExternalTaskQueryDto external_task_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ExternalTaskDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_external_tasks_with_http_info(**kwargs)  # noqa: E501

    def query_external_tasks_with_http_info(self, **kwargs):  # noqa: E501
        """query_external_tasks  # noqa: E501

        Queries for external tasks that fulfill given parameters in the form of a JSON object.  This method is slightly more powerful than the [Get External Tasks](https://docs.camunda.org/manual/7.14/reference/rest/external-task/get-query/) method because it allows to specify a hierarchical result sorting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_external_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param ExternalTaskQueryDto external_task_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ExternalTaskDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'external_task_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_external_tasks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_task_query_dto' in local_var_params:
            body_params = local_var_params['external_task_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExternalTaskDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_external_tasks_count(self, **kwargs):  # noqa: E501
        """query_external_tasks_count  # noqa: E501

        Queries for the number of external tasks that fulfill given parameters. This method takes the same message body as the [Get External Tasks (POST)](https://docs.camunda.org/manual/7.14/reference/rest/external-task/post-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_external_tasks_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ExternalTaskQueryDto external_task_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_external_tasks_count_with_http_info(**kwargs)  # noqa: E501

    def query_external_tasks_count_with_http_info(self, **kwargs):  # noqa: E501
        """query_external_tasks_count  # noqa: E501

        Queries for the number of external tasks that fulfill given parameters. This method takes the same message body as the [Get External Tasks (POST)](https://docs.camunda.org/manual/7.14/reference/rest/external-task/post-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_external_tasks_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ExternalTaskQueryDto external_task_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'external_task_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_external_tasks_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'external_task_query_dto' in local_var_params:
            body_params = local_var_params['external_task_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_external_task_resource_priority(self, id, **kwargs):  # noqa: E501
        """set_external_task_resource_priority  # noqa: E501

        Sets the priority of an existing external task by id. The default value of a priority is 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_resource_priority(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to set the priority for. (required)
        :param PriorityDto priority_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_external_task_resource_priority_with_http_info(id, **kwargs)  # noqa: E501

    def set_external_task_resource_priority_with_http_info(self, id, **kwargs):  # noqa: E501
        """set_external_task_resource_priority  # noqa: E501

        Sets the priority of an existing external task by id. The default value of a priority is 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_resource_priority_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to set the priority for. (required)
        :param PriorityDto priority_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'priority_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_external_task_resource_priority" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `set_external_task_resource_priority`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'priority_dto' in local_var_params:
            body_params = local_var_params['priority_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/priority', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_external_task_resource_retries(self, id, **kwargs):  # noqa: E501
        """set_external_task_resource_retries  # noqa: E501

        Sets the number of retries left to execute an external task by id. If retries are set to 0, an  incident is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_resource_retries(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to set the number of retries for. (required)
        :param RetriesDto retries_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_external_task_resource_retries_with_http_info(id, **kwargs)  # noqa: E501

    def set_external_task_resource_retries_with_http_info(self, id, **kwargs):  # noqa: E501
        """set_external_task_resource_retries  # noqa: E501

        Sets the number of retries left to execute an external task by id. If retries are set to 0, an  incident is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_resource_retries_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to set the number of retries for. (required)
        :param RetriesDto retries_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'retries_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_external_task_resource_retries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `set_external_task_resource_retries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retries_dto' in local_var_params:
            body_params = local_var_params['retries_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/retries', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_external_task_retries(self, **kwargs):  # noqa: E501
        """set_external_task_retries  # noqa: E501

        Sets the number of retries left to execute external tasks by id synchronously. If retries are set to 0,  an incident is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_retries(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRetriesForExternalTasksDto set_retries_for_external_tasks_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_external_task_retries_with_http_info(**kwargs)  # noqa: E501

    def set_external_task_retries_with_http_info(self, **kwargs):  # noqa: E501
        """set_external_task_retries  # noqa: E501

        Sets the number of retries left to execute external tasks by id synchronously. If retries are set to 0,  an incident is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_retries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRetriesForExternalTasksDto set_retries_for_external_tasks_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_retries_for_external_tasks_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_external_task_retries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_retries_for_external_tasks_dto' in local_var_params:
            body_params = local_var_params['set_retries_for_external_tasks_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/retries', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_external_task_retries_async_operation(self, **kwargs):  # noqa: E501
        """set_external_task_retries_async_operation  # noqa: E501

        Sets the number of retries left to execute external tasks by id asynchronously. If retries are set to 0, an incident is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_retries_async_operation(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRetriesForExternalTasksDto set_retries_for_external_tasks_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_external_task_retries_async_operation_with_http_info(**kwargs)  # noqa: E501

    def set_external_task_retries_async_operation_with_http_info(self, **kwargs):  # noqa: E501
        """set_external_task_retries_async_operation  # noqa: E501

        Sets the number of retries left to execute external tasks by id asynchronously. If retries are set to 0, an incident is created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_external_task_retries_async_operation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRetriesForExternalTasksDto set_retries_for_external_tasks_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_retries_for_external_tasks_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_external_task_retries_async_operation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_retries_for_external_tasks_dto' in local_var_params:
            body_params = local_var_params['set_retries_for_external_tasks_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/retries-async', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unlock(self, id, **kwargs):  # noqa: E501
        """unlock  # noqa: E501

        Unlocks an external task by id. Clears the task's lock expiration time and worker id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlock(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to unlock. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.unlock_with_http_info(id, **kwargs)  # noqa: E501

    def unlock_with_http_info(self, id, **kwargs):  # noqa: E501
        """unlock  # noqa: E501

        Unlocks an external task by id. Clears the task's lock expiration time and worker id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unlock_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the external task to unlock. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlock" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `unlock`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/external-task/{id}/unlock', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
