# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cq_server']

package_data = \
{'': ['*'],
 'cq_server': ['static/*', 'static/images/*', 'static/vendor/*', 'templates/*']}

install_requires = \
['CairoSVG>=2.5.2,<3.0.0',
 'Flask>=2.2.2,<3.0.0',
 'cadquery-massembly>=0.9.0,<0.10.0',
 'jupyter-cadquery>=3.2.2,<4.0.0',
 'matplotlib>=3.5.3,<4.0.0',
 'minify-html>=0.10.0,<0.11.0']

extras_require = \
{'cadquery': ['cadquery==2.2.0b0', 'casadi>=3.5.6rc2,<4.0.0']}

entry_points = \
{'console_scripts': ['cq-server = cq_server.cli:main']}

setup_kwargs = {
    'name': 'cadquery-server',
    'version': '0.4.0',
    'description': 'A web server used to render 3d models from CadQuery code loaded dynamically.',
    'long_description': '# CadQuery Server\n\nA web server used to render 3d models from CadQuery code loaded dynamically, and eventually build a static website as a showcase for your CadQuery projects.\n\nExample usage with Kate on the left and Firefox on the right:\n\n![](./images/screenshot.png)\n\nDemonstration video:\n\n[![cq-server_v-0-3-1](https://peertube.ethibox.fr/static/thumbnails/a6f01cba-7f53-4ac9-9d2f-c74d0f58abe2.jpg)](https://peertube.ethibox.fr/w/vwBfEkaEdzKiN98mm2jyDz)\n\n## About CadQuery Server\n\n### Features\n\n- build-in static website builder\n- fast response time\n- multi-file support\n- built-in file-watcher\n- live-reload\n- use your favorite text editor or IDE\n- display model on an external monitor or other device\n- compatible with VSCode built-in browser\n- options to customize ui\n\n### Functionning\n\nCadQuery Server dynamically loads your CadQuery code and renders the model on the browser using [three-cad-viewer](https://github.com/bernhard-42/three-cad-viewer) (the same used in [jupyter-cadquery](https://github.com/bernhard-42/jupyter-cadquery)). It includes a file watcher that reloads the Python code and updates the web page when the file is updated.\n\nThis approach allows users to work on any IDE, and render the model on any web browser. It also allow them to display the model in an other monitor, or even in an other computer on the same local network (for instance a tablet on your desktop).\n\nThe project was originally started for the VSCode extension, but since it doesn\'t depend on VSCode anymore, it\'s now a project as it own.\n\n### About CadQuery\n\nFrom the [CadQuery readme](https://github.com/CadQuery/cadquery/blob/master/README.md):\n\n> CadQuery is an intuitive, easy-to-use Python module for building parametric 3D CAD models. Using CadQuery, you can write short, simple scripts that produce high quality CAD models. It is easy to make many different objects using a single script that can be customized.\n\nRead [CadQuery documentation](https://cadquery.readthedocs.io/en/latest/) for more information about CadQuery and its usage.\n\n## Installation\n\n### Create a virtual environment (recommended)\n\n    python -m venv .venv\n    source .venv/bin/activate\n\n### Upgrade pip and setuptools\n\n    pip install --upgrade pip setuptools\n\n### Install with pip\n\nIf you already have CadQuery installed on your system:\n\n    pip install cadquery-server\n\nIf you want to install both cq-server and CadQuery:\n\n    pip install \'cadquery-server[cadquery]\'\n\n### Install with Docker\n\n    docker pull cadquery/cadquery-server\n\nThen add a volume and port when running the container. Typically:\n\n    docker run -p 5000:5000 -v $(pwd)/examples:/data cadquery/cadquery-server\n\nWhere `examples` is in your current directory and contains CadQuery scripts.\n\n### Install from sources\n\n    git clone https://github.com/roipoussiere/cadquery-server.git\n    cd cadquery-server\n\nIf you already have CadQuery installed on your system:\n\n    pip install .\n\nIf you want to install both cq-server and CadQuery:\n\n    pip install \'.[cadquery]\'\n\n## Usage\n\nOnce installed, the `cq-server` command should be available on your system (or on your virtual env).\n\nCLI usage is detailled here but might be not up to date. Type `cq-server -h` to get last instructions.\n\n#### Global options\n\n- `-h`, `--help`: show main cq-server help message and exit\n- `-V`, `--version`: print CadQuery Server version and exit\n\n### `run`\n\nRun the server\n\n#### Usage\n\n    cq-server run [-h] [-p PORT] [-r] [-d] [ui options] [target]\n\n#### Positional arguments\n\n- `target`: python file or folder containing CadQuery script to load (default: ".")\n\n#### Options\n\n- `-h`, `--help`: show the help message of the run command and exit\n- `-p PORT`, `--port PORT`: server port (default: 5000)\n- `-r`, `--raise`: when an error happen, raise it instead showing its title\n- `-d`, `--dead`: disable live reloading\n\nAs well as the UI options, listed in the dedicated section below.\n\n#### Examples\n\n```bash\ncq-server run # run cq-server with current folder as target on port 5000\ncq-server run -p 8080 ./examples # run cq-server with "examples" as target on port 8080\ncq-server run ./examples/box.py # run cq-server with only box.py as target\n```\n\n### `build`\n\nBuild static website\n\n#### Usage\n\n    cq-server build [-h] [-f FMT] [-m] [ui options] [target] [destination]\n\n#### Positional arguments\n\n- `target`: python file or folder containing CadQuery script to load (default: ".")\n- `destination`: output file path (default: `<module_name>.html`), or `-` for stdout\n\n#### Options\n\n- `-h`, `--help`: show the help message of the build command and exit\n- `-f FMT`, `--format FMT`: output format: html, json, step, xml, gltf, vtkjs, vrml, dxf, svg, stl, amf, tjs, vtp, 3mf, png, pdf (default: file extension, or html if not given)\n- `-m`, `--minify`: minify output when exporting to html\n\nAs well as the UI options, listed in the dedicated section below.\n\n#### Examples\n\n```bash\ncq-server build examples docs # build website of "example" project in "docs"\ncq-server build examples/box.py # build web page of box.py in examples/box.html\ncq-server build examples/box.py -f stl # build stl file in examples/box.stl\ncq-server build examples/box.png build # build web page in build/box.html\ncq-server build examples/box.png build/box.step # build step file in build/box.step\n```\n\n### `info`\n\nShow information about the current target and exit\n\n#### Usage\n\n    cq-server info [-h] [target]\n\n#### Positional arguments\n\n- `target`: python file or folder containing CadQuery script to load (default: ".")\n\n### UI options\n\nYou can configure the user interface via CLI options:\n\n- `--ui-hide`: a comma-separated list of buttons to disable, among: `axes`, `axes0`, `grid`, `ortho`, `more`, `help` and `all`\n- `--ui-glass`: activate tree view glass mode\n- `--ui-theme`: set ui theme, `light` or `dark` (default: browser config)\n- `--ui-trackball`: set control mode to trackball instead orbit\n- `--ui-perspective`: set camera view to perspective instead orthogonal\n- `--ui-grid`: display a grid in specified axes (`x`, `y`, `z`, `xy`, etc.)\n- `--ui-transparent`: make objects semi-transparent\n- `--ui-black-edges`: make edges black\n\n## Writing a CadQuery code\n\nCadQuery Server renders the model defined in the `show_object()` function (like in CadQuery Editor).\n\nYou **must** import it before from the `cq_server.ui` module, among with the `UI` class, which is used by the server to load the model.\n\nMinimal working example:\n\n```py\nimport cadquery as cq\nfrom cq_server.ui import UI, show_object\n\nshow_object(cq.Workplane(\'XY\').box(1, 2, 3))\n```\n\nPlease read the [CadQuery documentation](https://cadquery.readthedocs.io/en/latest/) for more details about the CadQuery library.\n\n## Using the web server\n\nOnce the server is started, go to its url (ie. `http://127.0.0.1`).\n\nOther endpoints:\n\n- `/json`: returns the model as a threejs json object. Used internally to retrieve the model;\n- `/html`: returns a static html page that doesn\'t require the CadQuery Server running.\n\nOptional url parameters, available for all listed endpoints:\n\n- `m`: name of module to load (if target is a folder)\n\nExamples: `/?m=box`, `/json?m=box`, `/html?m=box`.\n\n### Integration with VSCode\n\nThe web page can be displayed within VSCode IDE using [LivePreview extension](https://marketplace.visualstudio.com/items?itemName=ms-vscode.live-server):\n\n1. install the LivePreview VSCode extension;\n2. hit `ctrl+shift+P` -> *Simple Browser: Show*;\n3. update the url according to your running CadQuery server instance (ie. `127.0.0.1:5000`).\n\n### Publish a website to GitHub pages\n\nYou have a repository published on GitHub containing code CadQuery you want to share.\n\nYou *could* setup a CI to publish your website using the Docker image, but you might eventually edit your CI config it each time you have a new project dependency. Thus this section will explain how to publish it manually (but do what you want).\n\n1. Using the `build` command, build the static website **in `/docs`**:\n\n    cq-server build ./examples docs\n\nNote that the folder name **must** be */docs* in order to publish to GitHub pages.\n\n2. Add your website folder to .gitignore:\n\n```\n# Static website generated by cadquery-server\n/docs\n```\n\n3. Create a new orphan branch named `gh-pages`:\n\n    gc --orphan gh-pages\n\n4. In this branch, replace the .gitignore file by this:\n\n```\n# ignore all...\n/*\n\n# ...except build folder and gitignore\n!/docs\n!.gitignore\n```\n\n5. Push your website branch\n\n    git add .\n    git commit -m \'update website\'\n    git push origin gh-pages\n\n6. Configure GitHub:\n\nFrom your project page: *Settings*, *Pages* (side bar), then:\n- **Source**: deploy from a branch\n- **Branch**: `gh-pages`, `/docs`\n\nThen save. Wait few minutes and then you can go visit your website at `https://user_name.github.io/project_name/`. Congratulations!\n\n7. To update your website, repeat step 1, 3 and 5:\n\n    cq-server build ./examples docs\n    gc gh-pages\n    git add .\n    git commit -m \'update website\'\n    git push\n\n## About\n\n- contact:\n    - ping user `@roipoussiere` on channel `other-gui` in the CadQuery Discord;\n    - [Mastodon](https://mastodon.tetaneutral.net/@roipoussiere);\n- license: [MIT](./LICENSE);\n- source: both on [Framagit](https://framagit.org/roipoussiere/cadquery-server) (Gitlab instance) and [Github](https://github.com/roipoussiere/cadquery-server);\n- issue tracker: both on [Framagit](https://framagit.org/roipoussiere/cadquery-server/-/issues) and [Github](https://github.com/roipoussiere/cadquery-server/issues)\n',
    'author': 'Roipoussiere',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://open-vsx.org/extension/roipoussiere/cadquery',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
