#!/usr/bin/env python3
import numpy as np
import matplotlib.pyplot as plt

# https://law.resource.org/pub/us/cfr/ibr/003/cie.15.2004.tables.xls
cie_observer = np.array([
  [380,  0.00003, -0.00001,  0.00117,  0.0272, -0.0115,  0.9843, 0.001368, 0.000039, 0.006450, 0.174110, 0.004960],
  [385,  0.00005, -0.00002,  0.00189,  0.0268, -0.0114,  0.9846, 0.002236, 0.000064, 0.010550, 0.174010, 0.004980],
  [390,  0.00010, -0.00004,  0.00359,  0.0263, -0.0114,  0.9851, 0.004243, 0.000120, 0.020050, 0.173800, 0.004920],
  [395,  0.00017, -0.00007,  0.00647,  0.0256, -0.0113,  0.9857, 0.007650, 0.000217, 0.036210, 0.173560, 0.004920],
  [400,  0.00030, -0.00014,  0.01214,  0.0247, -0.0112,  0.9865, 0.014310, 0.000396, 0.067850, 0.173340, 0.004800],
  [405,  0.00047, -0.00022,  0.01969,  0.0237, -0.0111,  0.9874, 0.023190, 0.000640, 0.110200, 0.173020, 0.004780],
  [410,  0.00084, -0.00041,  0.03707,  0.0225, -0.0109,  0.9884, 0.043510, 0.001210, 0.207400, 0.172580, 0.004800],
  [415,  0.00139, -0.00070,  0.06637,  0.0207, -0.0104,  0.9897, 0.077630, 0.002180, 0.371300, 0.172090, 0.004830],
  [420,  0.00211, -0.00110,  0.11541,  0.0181, -0.0094,  0.9913, 0.134380, 0.004000, 0.645600, 0.171410, 0.005100],
  [425,  0.00266, -0.00143,  0.18575,  0.0142, -0.0076,  0.9934, 0.214770, 0.007300, 1.039050, 0.170300, 0.005790],
  [430,  0.00218, -0.00119,  0.24769,  0.0088, -0.0048,  0.9960, 0.283900, 0.011600, 1.385600, 0.168880, 0.006900],
  [435,  0.00036, -0.00021,  0.29012,  0.0012, -0.0007,  0.9995, 0.328500, 0.016840, 1.622960, 0.166900, 0.008560],
  [440, -0.00261,  0.00149,  0.31228, -0.0084,  0.0048,  1.0036, 0.348280, 0.023000, 1.747060, 0.164410, 0.010860],
  [445, -0.00673,  0.00379,  0.31860, -0.0213,  0.0120,  1.0093, 0.348060, 0.029800, 1.782600, 0.161100, 0.013790],
  [450, -0.01213,  0.00678,  0.31670, -0.0390,  0.0218,  1.0172, 0.336200, 0.038000, 1.772110, 0.156640, 0.017700],
  [455, -0.01874,  0.01046,  0.31166, -0.0618,  0.0345,  1.0273, 0.318700, 0.048000, 1.744100, 0.150990, 0.022740],
  [460, -0.02608,  0.01485,  0.29821, -0.0909,  0.0517,  1.0392, 0.290800, 0.060000, 1.669200, 0.143960, 0.029700],
  [465, -0.03324,  0.01977,  0.27295, -0.1281,  0.0762,  1.0519, 0.251100, 0.073900, 1.528100, 0.135500, 0.039880],
  [470, -0.03933,  0.02538,  0.22991, -0.1821,  0.1175,  1.0646, 0.195360, 0.090980, 1.287640, 0.124120, 0.057800],
  [475, -0.04471,  0.03183,  0.18592, -0.2584,  0.1840,  1.0744, 0.142100, 0.112600, 1.041900, 0.109590, 0.086840],
  [480, -0.04939,  0.03914,  0.14494, -0.3667,  0.2906,  1.0761, 0.095640, 0.139020, 0.812950, 0.091290, 0.132700],
  [485, -0.05364,  0.04713,  0.10968, -0.5200,  0.4568,  1.0632, 0.057950, 0.169300, 0.616200, 0.068710, 0.200720],
  [490, -0.05814,  0.05689,  0.08257, -0.7150,  0.6996,  1.0154, 0.032010, 0.208020, 0.465180, 0.045390, 0.294980],
  [495, -0.06414,  0.06948,  0.06246, -0.9459,  1.0247,  0.9212, 0.014700, 0.258600, 0.353300, 0.023460, 0.412700],
  [500, -0.07173,  0.08536,  0.04776, -1.1685,  1.3905,  0.7780, 0.004900, 0.323000, 0.272000, 0.008170, 0.538420],
  [505, -0.08120,  0.10593,  0.03688, -1.3182,  1.7195,  0.5987, 0.002400, 0.407300, 0.212300, 0.003860, 0.654820],
  [510, -0.08901,  0.12860,  0.02698, -1.3371,  1.9318,  0.4053, 0.009300, 0.503000, 0.158200, 0.013870, 0.750190],
  [515, -0.09356,  0.15262,  0.01842, -1.2076,  1.9699,  0.2377, 0.029100, 0.608200, 0.111700, 0.038850, 0.812020],
  [520, -0.09264,  0.17468,  0.01221, -0.9830,  1.8534,  0.1296, 0.063270, 0.710000, 0.078250, 0.074300, 0.833800],
  [525, -0.08473,  0.19113,  0.00830, -0.7386,  1.6662,  0.0724, 0.109600, 0.793200, 0.057250, 0.114160, 0.826210],
  [530, -0.07101,  0.20317,  0.00549, -0.5159,  1.4761,  0.0398, 0.165500, 0.862000, 0.042160, 0.154720, 0.805860],
  [535, -0.05316,  0.21083,  0.00320, -0.3304,  1.3105,  0.0199, 0.225750, 0.914850, 0.029840, 0.192880, 0.781630],
  [540, -0.03152,  0.21466,  0.00146, -0.1707,  1.1628,  0.0079, 0.290400, 0.954000, 0.020300, 0.229620, 0.754330],
  [545, -0.00613,  0.21487,  0.00023, -0.0293,  1.0282,  0.0011, 0.359700, 0.980300, 0.013400, 0.265780, 0.724320],
  [550,  0.02279,  0.21178, -0.00058,  0.0974,  0.9051, -0.0025, 0.433450, 0.994950, 0.008750, 0.301600, 0.692310],
  [555,  0.05514,  0.20588, -0.00105,  0.2121,  0.7919, -0.0040, 0.512050, 1.000000, 0.005750, 0.337360, 0.658850],
  [560,  0.09060,  0.19702, -0.00130,  0.3164,  0.6881, -0.0045, 0.594500, 0.995000, 0.003900, 0.373100, 0.624450],
  [565,  0.12840,  0.18522, -0.00138,  0.4112,  0.5932, -0.0044, 0.678400, 0.978600, 0.002750, 0.408740, 0.589610],
  [570,  0.16768,  0.17087, -0.00135,  0.4973,  0.5067, -0.0040, 0.762100, 0.952000, 0.002100, 0.444060, 0.554710],
  [575,  0.20715,  0.15429, -0.00123,  0.5751,  0.4283, -0.0034, 0.842500, 0.915400, 0.001800, 0.478770, 0.520200],
  [580,  0.24526,  0.13610, -0.00108,  0.6449,  0.3579, -0.0028, 0.916300, 0.870000, 0.001650, 0.512490, 0.486590],
  [585,  0.27989,  0.11686, -0.00093,  0.7071,  0.2952, -0.0023, 0.978600, 0.816300, 0.001400, 0.544790, 0.454430],
  [590,  0.30928,  0.09754, -0.00079,  0.7617,  0.2402, -0.0019, 1.026300, 0.757000, 0.001100, 0.575150, 0.424230],
  [595,  0.33184,  0.07909, -0.00063,  0.8087,  0.1928, -0.0015, 1.056700, 0.694900, 0.001000, 0.602930, 0.396500],
  [600,  0.34429,  0.06246, -0.00049,  0.8475,  0.1537, -0.0012, 1.062200, 0.631000, 0.000800, 0.627040, 0.372490],
  [605,  0.34756,  0.04776, -0.00038,  0.8800,  0.1209, -0.0009, 1.045600, 0.566800, 0.000600, 0.648230, 0.351390],
  [610,  0.33971,  0.03557, -0.00030,  0.9059,  0.0949, -0.0008, 1.002600, 0.503000, 0.000340, 0.665760, 0.334010],
  [615,  0.32265,  0.02583, -0.00022,  0.9265,  0.0741, -0.0006, 0.938400, 0.441200, 0.000240, 0.680080, 0.319750],
  [620,  0.29708,  0.01828, -0.00015,  0.9425,  0.0580, -0.0005, 0.854450, 0.381000, 0.000190, 0.691500, 0.308340],
  [625,  0.26348,  0.01253, -0.00011,  0.9550,  0.0454, -0.0004, 0.751400, 0.321000, 0.000100, 0.700610, 0.299300],
  [630,  0.22677,  0.00833, -0.00008,  0.9649,  0.0354, -0.0003, 0.642400, 0.265000, 0.000050, 0.707920, 0.292030],
  [635,  0.19233,  0.00537, -0.00005,  0.9730,  0.0272, -0.0002, 0.541900, 0.217000, 0.000030, 0.714030, 0.285930],
  [640,  0.15968,  0.00334, -0.00003,  0.9797,  0.0205, -0.0002, 0.447900, 0.175000, 0.000020, 0.719030, 0.280930],
  [645,  0.12905,  0.00199, -0.00002,  0.9850,  0.0152, -0.0002, 0.360800, 0.138200, 0.000010, 0.723030, 0.276950],
  [650,  0.10167,  0.00116, -0.00001,  0.9888,  0.0113, -0.0001, 0.283500, 0.107000, 0.000000, 0.725990, 0.274010],
  [655,  0.07857,  0.00066, -0.00001,  0.9918,  0.0083, -0.0001, 0.218700, 0.081600, 0.000000, 0.728270, 0.271730],
  [660,  0.05932,  0.00037,  0.00000,  0.9940,  0.0061, -0.0001, 0.164900, 0.061000, 0.000000, 0.729970, 0.270030],
  [665,  0.04366,  0.00021,  0.00000,  0.9954,  0.0047, -0.0001, 0.121200, 0.044580, 0.000000, 0.731090, 0.268910],
  [670,  0.03149,  0.00011,  0.00000,  0.9966,  0.0035, -0.0001, 0.087400, 0.032000, 0.000000, 0.731990, 0.268010],
  [675,  0.02294,  0.00006,  0.00000,  0.9975,  0.0025,  0.0000, 0.063600, 0.023200, 0.000000, 0.732720, 0.267280],
  [680,  0.01687,  0.00003,  0.00000,  0.9984,  0.0016,  0.0000, 0.046770, 0.017000, 0.000000, 0.733420, 0.266580],
  [685,  0.01187,  0.00001,  0.00000,  0.9991,  0.0009,  0.0000, 0.032900, 0.011920, 0.000000, 0.734050, 0.265950],
  [690,  0.00819,  0.00000,  0.00000,  0.9996,  0.0004,  0.0000, 0.022700, 0.008210, 0.000000, 0.734390, 0.265610],
  [695,  0.00572,  0.00000,  0.00000,  0.9999,  0.0001,  0.0000, 0.015840, 0.005723, 0.000000, 0.734590, 0.265410],
  [700,  0.00410,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.011359, 0.004102, 0.000000, 0.734690, 0.265310],
  [705,  0.00291,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.008111, 0.002929, 0.000000, 0.734690, 0.265310],
  [710,  0.00210,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.005790, 0.002091, 0.000000, 0.734690, 0.265310],
  [715,  0.00148,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.004109, 0.001484, 0.000000, 0.734690, 0.265310],
  [720,  0.00105,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.002899, 0.001047, 0.000000, 0.734690, 0.265310],
  [725,  0.00074,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.002049, 0.000740, 0.000000, 0.734690, 0.265310],
  [730,  0.00052,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.001440, 0.000520, 0.000000, 0.734690, 0.265310],
  [735,  0.00036,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.001000, 0.000361, 0.000000, 0.734690, 0.265310],
  [740,  0.00025,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000690, 0.000249, 0.000000, 0.734690, 0.265310],
  [745,  0.00017,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000476, 0.000172, 0.000000, 0.734690, 0.265310],
  [750,  0.00012,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000332, 0.000120, 0.000000, 0.734690, 0.265310],
  [755,  0.00008,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000235, 0.000085, 0.000000, 0.734690, 0.265310],
  [760,  0.00006,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000166, 0.000060, 0.000000, 0.734690, 0.265310],
  [765,  0.00004,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000117, 0.000042, 0.000000, 0.734690, 0.265310],
  [770,  0.00003,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000083, 0.000030, 0.000000, 0.734690, 0.265310],
  [775,  0.00001,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000059, 0.000021, 0.000000, 0.734690, 0.265310],
  [780,  0.00000,  0.00000,  0.00000,  1.0000,  0.0000,  0.0000, 0.000042, 0.000015, 0.000000, 0.734690, 0.265310],
])

lambd = cie_observer[:,0]
rbar = cie_observer[:,1]
gbar = cie_observer[:,2]
bbar = cie_observer[:,3]
r = cie_observer[:,4]
g = cie_observer[:,5]
b = cie_observer[:,6]
xbar = cie_observer[:,7]
ybar = cie_observer[:,8]
zbar = cie_observer[:,9]
x = cie_observer[:,10]
y = cie_observer[:,11]
z = 1 - x - y

plt.plot(lambd, rbar, 'r', label='rbar')
plt.plot(lambd, gbar, 'g', label='gbar')
plt.plot(lambd, bbar, 'b', label='bbar')
plt.title('CIE 1931 Standard Colorimetric Observer rgbbar')
plt.xlabel('Wavelength (nm)')
plt.ylabel('Intensity')
plt.legend()
plt.savefig('rgbbar.png')
plt.show()

plt.plot(lambd, r, 'r', label='r')
plt.plot(lambd, g, 'g', label='g')
plt.plot(lambd, b, 'b', label='b')
plt.title('CIE 1931 Standard Colorimetric Observer rgb')
plt.xlabel('Wavelength (nm)')
plt.ylabel('Intensity')
plt.legend()
plt.savefig('rgb.png')
plt.show()

plt.plot(lambd, xbar, 'r', label='xbar')
plt.plot(lambd, ybar, 'g', label='ybar')
plt.plot(lambd, zbar, 'b', label='zbar')
plt.title('CIE 1931 Standard Colorimetric Observer xyzbar')
plt.xlabel('Wavelength (nm)')
plt.ylabel('Intensity')
plt.legend()
plt.savefig('xyzbar.png')
plt.show()

plt.plot(lambd, x, 'r', label='x')
plt.plot(lambd, y, 'g', label='y')
plt.plot(lambd, z, 'b', label='z')
plt.title('CIE 1931 Standard Colorimetric Observer xyz')
plt.xlabel('Wavelength (nm)')
plt.ylabel('Intensity')
plt.legend()
plt.savefig('xyz.png')
plt.show()
