# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BuiltinRoleAssignmentArgs', 'BuiltinRoleAssignment']

@pulumi.input_type
class BuiltinRoleAssignmentArgs:
    def __init__(__self__, *,
                 builtin_role: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]]):
        """
        The set of arguments for constructing a BuiltinRoleAssignment resource.
        :param pulumi.Input[str] builtin_role: Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        :param pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]] roles: Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        pulumi.set(__self__, "builtin_role", builtin_role)
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="builtinRole")
    def builtin_role(self) -> pulumi.Input[str]:
        """
        Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        """
        return pulumi.get(self, "builtin_role")

    @builtin_role.setter
    def builtin_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "builtin_role", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]]:
        """
        Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _BuiltinRoleAssignmentState:
    def __init__(__self__, *,
                 builtin_role: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]]] = None):
        """
        Input properties used for looking up and filtering BuiltinRoleAssignment resources.
        :param pulumi.Input[str] builtin_role: Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        :param pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]] roles: Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        if builtin_role is not None:
            pulumi.set(__self__, "builtin_role", builtin_role)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="builtinRole")
    def builtin_role(self) -> Optional[pulumi.Input[str]]:
        """
        Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        """
        return pulumi.get(self, "builtin_role")

    @builtin_role.setter
    def builtin_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builtin_role", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]]]:
        """
        Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BuiltinRoleAssignmentRoleArgs']]]]):
        pulumi.set(self, "roles", value)


class BuiltinRoleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 builtin_role: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuiltinRoleAssignmentRoleArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        viewer = grafana.BuiltinRoleAssignment("viewer",
            builtin_role="Viewer",
            roles=[
                grafana.BuiltinRoleAssignmentRoleArgs(
                    global_=False,
                    uid="firstuid",
                ),
                grafana.BuiltinRoleAssignmentRoleArgs(
                    global_=True,
                    uid="seconduid",
                ),
            ])
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/builtinRoleAssignment:BuiltinRoleAssignment builtin_role_name {{builtin_role_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] builtin_role: Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuiltinRoleAssignmentRoleArgs']]]] roles: Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BuiltinRoleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        viewer = grafana.BuiltinRoleAssignment("viewer",
            builtin_role="Viewer",
            roles=[
                grafana.BuiltinRoleAssignmentRoleArgs(
                    global_=False,
                    uid="firstuid",
                ),
                grafana.BuiltinRoleAssignmentRoleArgs(
                    global_=True,
                    uid="seconduid",
                ),
            ])
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/builtinRoleAssignment:BuiltinRoleAssignment builtin_role_name {{builtin_role_name}}
        ```

        :param str resource_name: The name of the resource.
        :param BuiltinRoleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BuiltinRoleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 builtin_role: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuiltinRoleAssignmentRoleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BuiltinRoleAssignmentArgs.__new__(BuiltinRoleAssignmentArgs)

            if builtin_role is None and not opts.urn:
                raise TypeError("Missing required property 'builtin_role'")
            __props__.__dict__["builtin_role"] = builtin_role
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
        super(BuiltinRoleAssignment, __self__).__init__(
            'grafana:index/builtinRoleAssignment:BuiltinRoleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            builtin_role: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuiltinRoleAssignmentRoleArgs']]]]] = None) -> 'BuiltinRoleAssignment':
        """
        Get an existing BuiltinRoleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] builtin_role: Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BuiltinRoleAssignmentRoleArgs']]]] roles: Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BuiltinRoleAssignmentState.__new__(_BuiltinRoleAssignmentState)

        __props__.__dict__["builtin_role"] = builtin_role
        __props__.__dict__["roles"] = roles
        return BuiltinRoleAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="builtinRole")
    def builtin_role(self) -> pulumi.Output[str]:
        """
        Organization roles (`Viewer`, `Editor`, `Admin`) or `Grafana Admin` to assign the roles to.
        """
        return pulumi.get(self, "builtin_role")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence['outputs.BuiltinRoleAssignmentRole']]:
        """
        Fixed or custom roles which provide granular access for specific resources within Grafana.
        """
        return pulumi.get(self, "roles")

