# Generated by Django 2.0.8 on 2018-09-09 09:43

from django.db import migrations, models


def set_default_null(apps, schema_editor):
    Plan = apps.get_model("plans", "Plan")
    default_plans = Plan.objects.filter(default=True)
    if default_plans.count() > 1:
        print("You have more than 1 default plan:")
        for plan in default_plans:
            print(plan.id, ": ", plan)
        default_plan_id = input("Select ID of plan you want to keep default? ")
        Plan.objects.exclude(id=default_plan_id).update(default=None)
    Plan.objects.filter(default=False).update(default=None)


def set_default_false(apps, schema_editor):
    Plan = apps.get_model("plans", "Plan")
    Plan.objects.filter(default=None).update(default=False)


class Migration(migrations.Migration):

    dependencies = [
        ('plans', '0002_auto_20180901_1744'),
    ]

    operations = [
        migrations.AlterField(
            model_name='plan',
            name='default',
            field=models.NullBooleanField(db_index=True, default=None),
        ),
        migrations.RunPython(set_default_null, reverse_code=set_default_false),
        migrations.AlterField(
            model_name='plan',
            name='default',
            field=models.NullBooleanField(db_index=True, default=None, help_text='Both "Unknown" and "No" means that the plan is not default', unique=True),
        ),
    ]
