# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hecate', 'hecate.template', 'hecate.template.slash-commands']

package_data = \
{'': ['*']}

install_requires = \
['hikari-lightbulb>=2.3.1,<3.0.0']

setup_kwargs = {
    'name': 'lightbulb-ext-hecate',
    'version': '0.1.5',
    'description': 'File driven wrappers around lightbulb extensions and plugins.',
    'long_description': "# Hecate\nFile driven wrappers around lightbulb extensions and plugins.\n\n## Installation\nHecate can be installed through [pip](https://pip.pypa.io/en/stable/)\n```bash\npip install lightbulb-ext-hecate\n```\n\n## First Steps\nA pong slash command template for a basic hecate extension can be generated by running\n```bash\npython -m lightbulb.ext.hecate --template REL_PATH_TO_PY\n```\ngranted a .py extension file already exists in the desired directory.\n\nThe following directory structure\n```bash\n.\n└── extension.py\n```\nwill become\n```bash\n.\n├── slash-commands\n│   ├── pong_count.py\n│   └── ping.py\n├── __modify__.py\n└── extension.py\n```\n\n## Usage\n```python\n# Import the Plugin class\nfrom lightbulb.ext.hecate import Plugin\n\n# Create a Plugin instance (__file__ is necessary to fetch the commands and events in other files)\nplugin = Plugin('EXTENSION', __file__)\n\n# Plain lightbulb extension load method\ndef load(bot):\n    bot.add_plugin(plugin)\n```",
    'author': 'Radkii',
    'author_email': 'real.radkii@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/radkii/lightbulb-ext-hecate',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.12',
}


setup(**setup_kwargs)
