# Hecate
File driven wrappers around lightbulb extensions and plugins.

## Installation
Hecate can be installed through [pip](https://pip.pypa.io/en/stable/)
```bash
pip install lightbulb-ext-hecate
```

## First Steps
A pong slash command template for a basic hecate extension can be generated by running
```bash
python -m lightbulb.ext.hecate --template REL_PATH_TO_PY
```
granted a .py extension file already exists in the desired directory.

The following directory structure
```bash
.
└── extension.py
```
will become
```bash
.
├── slash-commands
│   ├── pong_count.py
│   └── ping.py
├── __modify__.py
└── extension.py
```

## Usage
```python
# Import the Plugin class
from lightbulb.ext.hecate import Plugin

# Create a Plugin instance (__file__ is necessary to fetch the commands and events in other files)
plugin = Plugin('EXTENSION', __file__)

# Plain lightbulb extension load method
def load(bot):
    bot.add_plugin(plugin)
```