"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool');
const userpool = new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    userInvitation: {
        emailSubject: 'invitation email subject from the integ test',
        emailBody: 'invitation email body from the integ test for {username}. Temp password is {####}.',
        smsMessage: 'invitation sms message from the integ test for {username}. Temp password is {####}.',
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailBody: 'verification email body from the integ test. Code is {####}.',
        emailSubject: 'verification email subject from the integ test',
        smsMessage: 'verification sms message from the integ test. Code is {####}.',
    },
    signInAliases: {
        username: true,
        email: true,
    },
    autoVerify: {
        email: true,
        phone: true,
    },
    standardAttributes: {
        fullname: {
            required: true,
            mutable: true,
        },
        email: {
            required: true,
        },
    },
    customAttributes: {
        'some-string-attr': new lib_1.StringAttribute(),
        'another-string-attr': new lib_1.StringAttribute({ minLen: 4, maxLen: 100 }),
        'some-number-attr': new lib_1.NumberAttribute(),
        'another-number-attr': new lib_1.NumberAttribute({ min: 10, max: 50 }),
        'some-boolean-attr': new lib_1.BooleanAttribute(),
        'some-datetime-attr': new lib_1.DateTimeAttribute(),
    },
    mfa: lib_1.Mfa.REQUIRED,
    mfaSecondFactor: {
        sms: true,
        otp: true,
    },
    passwordPolicy: {
        tempPasswordValidity: core_1.Duration.days(10),
        minLength: 12,
        requireDigits: true,
        requireLowercase: true,
        requireUppercase: true,
        requireSymbols: true,
    },
    emailSettings: {
        from: 'noreply@myawesomeapp.com',
        replyTo: 'support@myawesomeapp.com',
    },
    lambdaTriggers: {
        createAuthChallenge: dummyTrigger('createAuthChallenge'),
        customMessage: dummyTrigger('customMessage'),
        defineAuthChallenge: dummyTrigger('defineAuthChallenge'),
        postAuthentication: dummyTrigger('postAuthentication'),
        postConfirmation: dummyTrigger('postConfirmation'),
        preAuthentication: dummyTrigger('preAuthentication'),
        preSignUp: dummyTrigger('preSignUp'),
        preTokenGeneration: dummyTrigger('preTokenGeneration'),
        userMigration: dummyTrigger('userMigration'),
        verifyAuthChallengeResponse: dummyTrigger('verifyAuthChallengeResponse'),
    },
});
const cognitoDomain = userpool.addDomain('myuserpooldomain', {
    cognitoDomain: {
        domainPrefix: 'myawesomeapp',
    },
});
new core_1.CfnOutput(stack, 'userpoolId', {
    value: userpool.userPoolId,
});
new core_1.CfnOutput(stack, 'cognitoDomainName', {
    value: `${cognitoDomain.domainName}.auth.${stack.region}.amazoncognito.com`,
});
function dummyTrigger(name) {
    return new aws_lambda_1.Function(stack, name, {
        functionName: name,
        handler: 'index.handler',
        runtime: aws_lambda_1.Runtime.NODEJS_12_X,
        code: aws_lambda_1.Code.fromInline('foo'),
    });
}
//# sourceMappingURL=data:application/json;base64,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