# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pelican', 'pelican.plugins.search']

package_data = \
{'': ['*']}

install_requires = \
['pelican>=4.5']

extras_require = \
{'markdown': ['markdown>=3.2']}

setup_kwargs = {
    'name': 'pelican-search',
    'version': '1.0.2',
    'description': 'Pelican plugin that indexes content and enables static site searches',
    'long_description': '# Search: A Plugin for Pelican\n\n[![Build Status](https://img.shields.io/github/actions/workflow/status/pelican-plugins/search/main.yml?branch=main)](https://github.com/pelican-plugins/search/actions)\n[![PyPI Version](https://img.shields.io/pypi/v/pelican-search)](https://pypi.org/project/pelican-search/)\n\nThis plugin generates an index for searching content on a Pelican-powered site.\n\n\n## Why would you want this?\n\nStatic sites are, well, static… and thus usually don’t have an application server component that could be used to power site search functionality. Rather than give up control (and privacy) to third-party search engine corporations, this plugin adds elegant and self-hosted site search capability to your site. Last but not least, searches are **really** fast. 🚀\n\nWant to see just _how_ fast? Try it out for yourself. Following are some sites that use this plugin:\n\n* [Justin Mayer](https://justinmayer.com)\n* [Open Source Alternatives](https://opensourcealternatives.org)\n\n\n## Installation\n\nThis plugin uses [Stork](https://stork-search.net/) to generate a search index. Follow the [Stork installation instructions](https://stork-search.net/docs/install) to install this required command-line tool and ensure it is available within `/usr/local/bin/` or another `$PATH`-accessible location of your choosing. For example, Stork can be installed on macOS (Intel) via:\n\n    export STORKVERSION="v1.5.0"\n    wget -O /usr/local/bin/stork https://files.stork-search.net/releases/$STORKVERSION/stork-macos-10-15\n    chmod +x /usr/local/bin/stork\n\nFor macOS on ARM, install via Homebrew:\n\n    brew install stork-search/stork-tap/stork\n\nConfirm that Stork is properly installed via:\n\n    stork --help\n\nOnce Stork has been successfully installed and tested, this plugin can be installed via:\n\n    python -m pip install pelican-search\n\nIf you are using Pelican 4.5+ with namespace plugins and don’t have a `PLUGINS` setting defined in your configuration, then the Search plugin should be auto-discovered with no further action required. If, on the other hand, you _do_ have a `PLUGINS` setting defined (because you also use legacy plugins or because you want to be able to selectively disable installed plugins), then you must manually add `search` to the `PLUGINS` list, as described in the [Pelican plugins documentation][].\n\n\n## Settings\n\nThis plugin’s behavior can be customized via Pelican settings. Those settings, and their default values, follow below.\n\n### `SEARCH_MODE = "output"`\n\nIn addition to plain-text files, Stork can recognize and index HTML and Markdown-formatted content. The default behavior of this plugin is to index generated HTML files, since Stork is good at extracting content from tags, scripts, and styles. But that mode may require a slight theme modification that isn’t necessary when indexing Markdown source (see `SEARCH_HTML_SELECTOR` setting below). That said, indexing Markdown means that markup information may not be removed from the indexed content and will thus be visible in the search preview results. With that caveat aside, if you want to index Markdown source content files instead of the generated HTML output, you can use: `SEARCH_MODE = "source"`\n\n### `SEARCH_HTML_SELECTOR = "main"`\n\nBy default, Stork looks for `<main>[…]</main>` tags to determine where your main content is located. If such tags do not already exist in your theme’s template files, you can either (1) add `<main>` tags or (2) change the HTML selector that Stork should look for.\n\nTo use the default `main` selector, in each of your theme’s relevant template files, wrap the content you want to index with `<main>` tags. For example:\n\n`article.html`:\n\n```jinja\n<main>\n{{ article.content }}\n</main>\n```\n\n`page.html`:\n\n```jinja\n<main>\n{{ page.content }}\n</main>\n\n```\n\nFor more information, refer to [Stork’s documentation on HTML tag selection](https://stork-search.net/docs/html).\n\n\n## Static Assets\n\nThere are two options for serving the necessary JavaScript, WebAssembly, and CSS static assets:\n\n1. Use a content delivery network (CDN) to serve Stork’s static assets\n2. Self-host the Stork static assets\n\nThe first option is easier to set up. The second option is provided for folks who prefer to self-host everything. After you have decided which option you prefer, follow the relevant section’s instructions below.\n\n### Static Assets — Option 1: Use CDN\n\n#### CSS\n\nAdd the Stork CSS before the closing `</head>` tag in your theme’s base template file, such as `base.html`:\n\n```html\n<link rel="stylesheet" href="https://files.stork-search.net/basic.css" />\n```\n\nIf your theme supports dark mode, you may want to also add Stork’s dark CSS file:\n\n```html\n<link rel="stylesheet" media="screen and (prefers-color-scheme: dark)" href="https://files.stork-search.net/dark.css">\n```\n\n#### JavaScript\n\nAdd the following script tags to your theme’s base template, just before your closing `</body>` tag, which will load the most recent Stork module along with the matching WASM binary:\n\n```html\n<script src="https://files.stork-search.net/releases/v1.5.0/stork.js"></script>\n<script>\n    stork.register("sitesearch", "{{ SITEURL }}/search-index.st")\n</script>\n```\n\n### Static Assets — Option 2: Self-Host\n\nDownload the Stork JavaScript, WebAssembly, and CSS files and put them in your theme’s respective static asset directories:\n\n```shell\nexport STORKVERSION="v1.5.0"\ncd $YOUR-THEME-DIR\nmkdir -p static/{js,css}\nwget -O static/js/stork.js https://files.stork-search.net/releases/$STORKVERSION/stork.js\nwget -O static/js/stork.js.map https://files.stork-search.net/releases/$STORKVERSION/stork.js.map\nwget -O static/js/stork.wasm https://files.stork-search.net/releases/$STORKVERSION/stork.wasm\nwget -O static/css/stork.css https://files.stork-search.net/basic.css\nwget -O static/css/stork-dark.css https://files.stork-search.net/dark.css\n```\n\n#### CSS\n\nAdd the Stork CSS before the closing `</head>` tag in your theme’s base template file, such as `base.html`:\n\n```jinja\n<link rel="stylesheet" href="{{ SITEURL }}/{{ THEME_STATIC_DIR }}/css/stork.css">\n```\n\nIf your theme supports dark mode, you may want to also add Stork’s dark CSS file:\n\n```jinja\n<link rel="stylesheet" media="screen and (prefers-color-scheme: dark)" href="{{ SITEURL }}/{{ THEME_STATIC_DIR }}/css/stork-dark.css">\n```\n\n#### JavaScript & WebAssembly\n\nAdd the following script tags to your theme’s base template file, such as `base.html`, just before the closing `</body>` tag:\n\n```jinja\n<script src="{{ SITEURL }}/{{ THEME_STATIC_DIR }}/js/stork.js"></script>\n<script>\n    stork.initialize("{{ SITEURL }}/{{ THEME_STATIC_DIR }}/js/stork.wasm")\n    stork.downloadIndex("sitesearch", "{{ SITEURL }}/search-index.st")\n    stork.attach("sitesearch")\n</script>\n```\n\n### Search Input Form\n\nDecide in which place(s) on your site you want to put your search field, such as your `index.html` template file. Then add the search field to the template:\n\n```html\nSearch: <input data-stork="sitesearch" />\n<div data-stork="sitesearch-output"></div>\n```\n\nFor more information regarding this topic, see the [Stork search interface documentation](https://stork-search.net/docs/interface).\n\n\n## Deployment\n\nEnsure your production web server serves the WebAssembly file with the `application/wasm` MIME type. For folks using older versions of Nginx, that might look like the following:\n\n```nginx\n…\nhttp {\n    …\n    include             mime.types;\n    # Types not included in older Nginx versions:\n    types {\n        application/wasm                                 wasm;\n    }\n    …\n}\n```\n\nFor other self-hosting considerations, see the [Stork self-hosting documentation](https://stork-search.net/docs/self-hosting).\n\n\n## Contributing\n\nContributions are welcome and much appreciated. Every little bit helps. You can contribute by improving the documentation, adding missing features, and fixing bugs. You can also help out by reviewing and commenting on [existing issues][].\n\nTo start contributing to this plugin, review the [Contributing to Pelican][] documentation, beginning with the **Contributing Code** section.\n\n[Pelican plugins documentation]: https://docs.getpelican.com/en/latest/plugins.html\n[existing issues]: https://github.com/pelican-plugins/search/issues\n[Contributing to Pelican]: https://docs.getpelican.com/en/latest/contribute.html\n',
    'author': 'Justin Mayer',
    'author_email': 'entroP@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/pelican-plugins/search',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
