"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToFargate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
const core_2 = require("@aws-solutions-constructs/core");
class AlbToFargate extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        defaults.CheckFargateProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        // Set up the ALB
        this.loadBalancer = defaults.ObtainAlb(scope, `${id}-lb`, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        const newListener = this.loadBalancer.listeners.length === 0;
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_2.GetActiveListener(this.loadBalancer.listeners);
        }
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Add the Fargate Service to the
        // to the ALB Listener we set up earlier
        const applicationTargetGroupProps = defaults.consolidateProps(defaults.DefaultApplicationTargetGroupProps(this.vpc), props.targetGroupProps);
        const newTargetGroup = defaults.AddFargateTarget(scope, `${id}-target`, this.listener, this.service, props.ruleProps, applicationTargetGroupProps);
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependsOn(cfnTargetGroup);
        }
    }
}
exports.AlbToFargate = AlbToFargate;
_a = JSII_RTTI_SYMBOL_1;
AlbToFargate[_a] = { fqn: "@aws-solutions-constructs/aws-alb-fargate.AlbToFargate", version: "1.165.0" };
//# sourceMappingURL=data:application/json;base64,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