% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_line_mapping.R
\name{ccle.to.latest}
\alias{ccle.to.latest}
\title{Map any ccle names to the current/latest ccle names. Useful for updating old names and correcting lines which have been renamed.}
\usage{
ccle.to.latest(arxspan.ids, ignore.problems = F, check.unique.mapping = T)
}
\arguments{
\item{ignore.problems}{if not set to True, any unknown cell lines will result in an error being thrown. If you set to True, then you'll get NA for unknown lines instead.}

\item{check.unique.mapping}{if set, will throw an error if it discovers two different IDs which map to the same ccle name (which could cause issues downstream)}

\item{ccle.names}{A vector of CCLE names}
}
\description{
Map any ccle names to the current/latest ccle names. Useful for updating old names and correcting lines which have been renamed.
}
\examples{
ccle_names <- ccle.to.latest('HEL9217_2013_HAEMATOPOIETIC_AND_LYMPHOID_TISSUE')
}
