# generated by datamodel-codegen:
#   filename:  openapi.yaml
#   timestamp: 2023-01-31T11:47:38+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Extra, Field


class BlockContent(BaseModel):
    time: int = Field(..., example=1641338934)
    """
    Block creation time in UNIX time
    """
    height: int = Field(..., example=15243593)
    """
    Block number
    """
    hash: str = Field(
        ..., example="4ea1ba291e8eef538635a53e59fddba7810d1679631cc3aed7c8e6c4091a516a"
    )
    """
    Hash of the block
    """
    slot: int = Field(..., example=412162133)
    """
    Slot number
    """
    epoch: int = Field(..., example=425)
    """
    Epoch number
    """
    epoch_slot: int = Field(..., example=12)
    """
    Slot within the epoch
    """
    slot_leader: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2qnikdy"
    )
    """
    Bech32 ID of the slot leader or specific block description in case there is no slot leader
    """
    size: int = Field(..., example=3)
    """
    Block size in Bytes
    """
    tx_count: int = Field(..., example=1)
    """
    Number of transactions in the block
    """
    output: str = Field(..., example="128314491794")
    """
    Total output within the block in Lovelaces
    """
    fees: str = Field(..., example="592661")
    """
    Total fees within the block in Lovelaces
    """
    block_vrf: str = Field(
        ...,
        example="vrf_vk1wf2k6lhujezqcfe00l6zetxpnmh9n6mwhpmhm0dvfh3fxgmdnrfqkms8ty",
        max_length=65,
        min_length=65,
    )
    """
    VRF key of the block
    """
    op_cert: str = Field(
        ..., example="da905277534faf75dae41732650568af545134ee08a3c0392dbefc8096ae177c"
    )
    """
    The hash of the operational certificate of the block producer
    """
    op_cert_counter: str = Field(..., example="18")
    """
    The value of the counter used to produce the operational certificate
    """
    previous_block: str = Field(
        ..., example="43ebccb3ac72c7cebd0d9b755a4b08412c9f5dcb81b8a0ad1e3c197d29d47b05"
    )
    """
    Hash of the previous block
    """
    next_block: str = Field(
        ..., example="8367f026cf4b03e116ff8ee5daf149b55ba5a6ec6dec04803b8dc317721d15fa"
    )
    """
    Hash of the next block
    """
    confirmations: int = Field(..., example=4698)
    """
    Number of block confirmations
    """


class BlockContentTxs(BaseModel):
    __root__: List[str] = Field(
        ...,
        example=[
            "8788591983aa73981fc92d6cddbbe643959f5a784e84b8bee0db15823f575a5b",
            "4eef6bb7755d8afbeac526b799f3e32a624691d166657e9d862aaeb66682c036",
            "52e748c4dec58b687b90b0b40d383b9fe1f24c1a833b7395cdf07dd67859f46f",
            "e8073fd5318ff43eca18a852527166aa8008bee9ee9e891f585612b7e4ba700b",
        ],
    )


class BlockContentArray(BaseModel):
    __root__: List[BlockContent]


class Transaction(BaseModel):
    tx_hash: str


class BlockContentAddress(BaseModel):
    address: str
    """
    Address that was affected in the specified block
    """
    transactions: List[Transaction]
    """
    List of transactions containing the address either in their inputs or outputs. Sorted by transaction index within a block, ascending.
    """


class BlockContentAddresses(BaseModel):
    __root__: List[BlockContentAddress] = Field(
        ...,
        example=[
            {
                "address": "addr1q9ld26v2lv8wvrxxmvg90pn8n8n5k6tdst06q2s856rwmvnueldzuuqmnsye359fqrk8hwvenjnqultn7djtrlft7jnq7dy7wv",
                "transactions": [
                    {
                        "tx_hash": "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dce628516157f0"
                    }
                ],
            },
            {
                "address": "addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
                "transactions": [
                    {
                        "tx_hash": "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dce628516157d0"
                    }
                ],
            },
        ],
    )


class GenesisContent(BaseModel):
    active_slots_coefficient: float = Field(..., example=0.05)
    """
    The proportion of slots in which blocks should be issued
    """
    update_quorum: int = Field(..., example=5)
    """
    Determines the quorum needed for votes on the protocol parameter updates
    """
    max_lovelace_supply: str = Field(..., example="45000000000000000")
    """
    The total number of lovelace in the system
    """
    network_magic: int = Field(..., example=764824073)
    """
    Network identifier
    """
    epoch_length: int = Field(..., example=432000)
    """
    Number of slots in an epoch
    """
    system_start: int = Field(..., example=1506203091)
    """
    Time of slot 0 in UNIX time
    """
    slots_per_kes_period: int = Field(..., example=129600)
    """
    Number of slots in an KES period
    """
    slot_length: int = Field(..., example=1)
    """
    Duration of one slot in seconds
    """
    max_kes_evolutions: int = Field(..., example=62)
    """
    The maximum number of time a KES key can be evolved before a pool operator must create a new operational certificate
    """
    security_param: int = Field(..., example=2160)
    """
    Security parameter k
    """


class EpochContent(BaseModel):
    epoch: int = Field(..., example=225)
    """
    Epoch number
    """
    start_time: int = Field(..., example=1603403091)
    """
    Unix time of the start of the epoch
    """
    end_time: int = Field(..., example=1603835086)
    """
    Unix time of the end of the epoch
    """
    first_block_time: int = Field(..., example=1603403092)
    """
    Unix time of the first block of the epoch
    """
    last_block_time: int = Field(..., example=1603835084)
    """
    Unix time of the last block of the epoch
    """
    block_count: int = Field(..., example=21298)
    """
    Number of blocks within the epoch
    """
    tx_count: int = Field(..., example=17856)
    """
    Number of transactions within the epoch
    """
    output: str = Field(..., example="7849943934049314")
    """
    Sum of all the transactions within the epoch in Lovelaces
    """
    fees: str = Field(..., example="4203312194")
    """
    Sum of all the fees within the epoch in Lovelaces
    """
    active_stake: str = Field(..., example="784953934049314")
    """
    Sum of all the active stakes within the epoch in Lovelaces
    """


class EpochParamContent(BaseModel):
    epoch: int = Field(..., example=225)
    """
    Epoch number
    """
    min_fee_a: int = Field(..., example=44)
    """
    The linear factor for the minimum fee calculation for given epoch
    """
    min_fee_b: int = Field(..., example=155381)
    """
    The constant factor for the minimum fee calculation
    """
    max_block_size: int = Field(..., example=65536)
    """
    Maximum block body size in Bytes
    """
    max_tx_size: int = Field(..., example=16384)
    """
    Maximum transaction size
    """
    max_block_header_size: int = Field(..., example=1100)
    """
    Maximum block header size
    """
    key_deposit: str = Field(..., example="2000000")
    """
    The amount of a key registration deposit in Lovelaces
    """
    pool_deposit: str = Field(..., example="500000000")
    """
    The amount of a pool registration deposit in Lovelaces
    """
    e_max: int = Field(..., example=18)
    """
    Epoch bound on pool retirement
    """
    n_opt: int = Field(..., example=150)
    """
    Desired number of pools
    """
    a0: float = Field(..., example=0.3)
    """
    Pool pledge influence
    """
    rho: float = Field(..., example=0.003)
    """
    Monetary expansion
    """
    tau: float = Field(..., example=0.2)
    """
    Treasury expansion
    """
    decentralisation_param: float = Field(..., example=0.5)
    """
    Percentage of blocks produced by federated nodes
    """
    extra_entropy: str
    """
    Seed for extra entropy
    """
    protocol_major_ver: int = Field(..., example=2)
    """
    Accepted protocol major version
    """
    protocol_minor_ver: int = Field(..., example=0)
    """
    Accepted protocol minor version
    """
    min_utxo: str = Field(..., example="1000000")
    """
    Minimum UTXO value
    """
    min_pool_cost: str = Field(..., example="340000000")
    """
    Minimum stake cost forced on the pool
    """
    nonce: str = Field(
        ..., example="1a3be38bcbb7911969283716ad7aa550250226b76a61fc51cc9a9a35d9276d81"
    )
    """
    Epoch number only used once
    """
    cost_models: Dict[str, Any] = Field(
        ...,
        example={
            "PlutusV1": {
                "addInteger-cpu-arguments-intercept": 197209,
                "addInteger-cpu-arguments-slope": 0,
            },
            "PlutusV2": {
                "addInteger-cpu-arguments-intercept": 197209,
                "addInteger-cpu-arguments-slope": 0,
            },
        },
    )
    """
    Cost models parameters for Plutus Core scripts
    """
    price_mem: float = Field(..., example=0.0577)
    """
    The per word cost of script memory usage
    """
    price_step: float = Field(..., example=7.21e-05)
    """
    The cost of script execution step usage
    """
    max_tx_ex_mem: str = Field(..., example="10000000")
    """
    The maximum number of execution memory allowed to be used in a single transaction
    """
    max_tx_ex_steps: str = Field(..., example="10000000000")
    """
    The maximum number of execution steps allowed to be used in a single transaction
    """
    max_block_ex_mem: str = Field(..., example="50000000")
    """
    The maximum number of execution memory allowed to be used in a single block
    """
    max_block_ex_steps: str = Field(..., example="40000000000")
    """
    The maximum number of execution steps allowed to be used in a single block
    """
    max_val_size: str = Field(..., example="5000")
    """
    The maximum Val size
    """
    collateral_percent: int = Field(..., example=150)
    """
    The percentage of the transactions fee which must be provided as collateral when including non-native scripts
    """
    max_collateral_inputs: int = Field(..., example=3)
    """
    The maximum number of collateral inputs allowed in a transaction
    """
    coins_per_utxo_size: str = Field(..., example="34482")
    """
    Cost per UTxO word for Alonzo. Cost per UTxO byte for Babbage and later.
    """
    coins_per_utxo_word: str = Field(..., example="34482")
    """
    Cost per UTxO word for Alonzo. Cost per UTxO byte for Babbage and later.
    """


class EpochContentArray(BaseModel):
    __root__: List[EpochContent]


class EpochStakeContentItem(BaseModel):
    stake_address: str = Field(
        ..., example="stake1u9l5q5jwgelgagzyt6nuaasefgmn8pd25c8e9qpeprq0tdcp0e3uk"
    )
    """
    Stake address
    """
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 prefix of the pool delegated to
    """
    amount: str = Field(..., example="4440295078")
    """
    Amount of active delegated stake in Lovelaces
    """


class EpochStakeContent(BaseModel):
    __root__: List[EpochStakeContentItem]


class EpochStakePoolContentItem(BaseModel):
    stake_address: str = Field(
        ..., example="stake1u9l5q5jwgelgagzyt6nuaasefgmn8pd25c8e9qpeprq0tdcp0e3uk"
    )
    """
    Stake address
    """
    amount: str = Field(..., example="4440295078")
    """
    Amount of active delegated stake in Lovelaces
    """


class EpochStakePoolContent(BaseModel):
    __root__: List[EpochStakePoolContentItem]


class EpochBlockContent(BaseModel):
    __root__: List[str] = Field(
        ...,
        example=[
            "d0fa315687e99ccdc96b14cc2ea74a767405d64427b648c470731a9b69e4606e",
            "38bc6efb92a830a0ed22a64f979d120d26483fd3c811f6622a8c62175f530878",
            "f3258fcd8b975c061b4fcdcfcbb438807134d6961ec278c200151274893b6b7d",
        ],
    )


class OutputAmountItem(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class TxContent(BaseModel):
    hash: str = Field(
        ..., example="1e043f100dce12d107f679685acd2fc0610e10f72a92d412794c9773d11d8477"
    )
    """
    Transaction hash
    """
    block: str = Field(
        ..., example="356b7d7dbb696ccd12775c016941057a9dc70898d87a63fc752271bb46856940"
    )
    """
    Block hash
    """
    block_height: int = Field(..., example=123456)
    """
    Block number
    """
    block_time: int = Field(..., example=1635505891)
    """
    Block creation time in UNIX time
    """
    slot: int = Field(..., example=42000000)
    """
    Slot number
    """
    index: int = Field(..., example=1)
    """
    Transaction index within the block
    """
    output_amount: List[OutputAmountItem] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    fees: str = Field(..., example="182485")
    """
    Fees of the transaction in Lovelaces
    """
    deposit: str = Field(..., example="0")
    """
    Deposit within the transaction in Lovelaces
    """
    size: int = Field(..., example=433)
    """
    Size of the transaction in Bytes
    """
    invalid_before: str
    """
    Left (included) endpoint of the timelock validity intervals
    """
    invalid_hereafter: str = Field(..., example="13885913")
    """
    Right (excluded) endpoint of the timelock validity intervals
    """
    utxo_count: int = Field(..., example=4)
    """
    Count of UTXOs within the transaction
    """
    withdrawal_count: int = Field(..., example=0)
    """
    Count of the withdrawals within the transaction
    """
    mir_cert_count: int = Field(..., example=0)
    """
    Count of the MIR certificates within the transaction
    """
    delegation_count: int = Field(..., example=0)
    """
    Count of the delegations within the transaction
    """
    stake_cert_count: int = Field(..., example=0)
    """
    Count of the stake keys (de)registration within the transaction
    """
    pool_update_count: int = Field(..., example=0)
    """
    Count of the stake pool registration and update certificates within the transaction
    """
    pool_retire_count: int = Field(..., example=0)
    """
    Count of the stake pool retirement certificates within the transaction
    """
    asset_mint_or_burn_count: int = Field(..., example=0)
    """
    Count of asset mints and burns within the transaction
    """
    redeemer_count: int = Field(..., example=0)
    """
    Count of redeemers within the transaction
    """
    valid_contract: bool = Field(..., example=True)
    """
    True if contract script passed validation
    """


class AmountItem(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class Input(BaseModel):
    address: str = Field(
        ...,
        example="addr1q9ld26v2lv8wvrxxmvg90pn8n8n5k6tdst06q2s856rwmvnueldzuuqmnsye359fqrk8hwvenjnqultn7djtrlft7jnq7dy7wv",
    )
    """
    Input address
    """
    amount: List[AmountItem] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    tx_hash: str = Field(
        ..., example="1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dce628516157f0"
    )
    """
    Hash of the UTXO transaction
    """
    output_index: int = Field(..., example=0)
    """
    UTXO index in the transaction
    """
    data_hash: str = Field(
        ..., example="9e478573ab81ea7a8e31891ce0648b81229f408d596a3483e6f4f9b92d3cf710"
    )
    """
    The hash of the transaction output datum
    """
    inline_datum: str = Field(..., example="19a6aa")
    """
    CBOR encoded inline datum
    """
    reference_script_hash: str = Field(
        ..., example="13a3efd825703a352a8f71f4e2758d08c28c564e8dfcce9f77776ad1"
    )
    """
    The hash of the reference script of the input
    """
    collateral: bool = Field(..., example=False)
    """
    Whether the input is a collateral consumed on script validation failure
    """
    reference: Optional[bool] = Field(None, example=False)
    """
    Whether the input is a reference transaction input
    """


class AmountItem1(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class Output(BaseModel):
    address: str = Field(
        ...,
        example="addr1q9ld26v2lv8wvrxxmvg90pn8n8n5k6tdst06q2s856rwmvnueldzuuqmnsye359fqrk8hwvenjnqultn7djtrlft7jnq7dy7wv",
    )
    """
    Output address
    """
    amount: List[AmountItem1] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    output_index: int = Field(..., example=0)
    """
    UTXO index in the transaction
    """
    data_hash: str = Field(
        ..., example="9e478573ab81ea7a8e31891ce0648b81229f408d596a3483e6f4f9b92d3cf710"
    )
    """
    The hash of the transaction output datum
    """
    inline_datum: str = Field(..., example="19a6aa")
    """
    CBOR encoded inline datum
    """
    collateral: bool = Field(..., example=False)
    """
    Whether the output is a collateral output
    """
    reference_script_hash: str = Field(
        ..., example="13a3efd825703a352a8f71f4e2758d08c28c564e8dfcce9f77776ad1"
    )
    """
    The hash of the reference script of the output
    """


class TxContentUtxo(BaseModel):
    hash: str = Field(
        ..., example="1e043f100dce12d107f679685acd2fc0610e10f72a92d412794c9773d11d8477"
    )
    """
    Transaction hash
    """
    inputs: List[Input]
    outputs: List[Output]


class TxContentStakeAddrItem(BaseModel):
    cert_index: int = Field(..., example=0)
    """
    Index of the certificate within the transaction
    """
    address: str = Field(
        ..., example="stake1u9t3a0tcwune5xrnfjg4q7cpvjlgx9lcv0cuqf5mhfjwrvcwrulda"
    )
    """
    Delegation stake address
    """
    registration: bool = Field(..., example=True)
    """
    Registration boolean, false if deregistration
    """


class TxContentStakeAddr(BaseModel):
    __root__: List[TxContentStakeAddrItem]


class TxContentDelegation(BaseModel):
    index: int = Field(..., example=0)
    """
    Index of the certificate within the transaction
    """
    cert_index: int = Field(..., example=0)
    """
    Index of the certificate within the transaction
    """
    address: str = Field(
        ..., example="stake1u9r76ypf5fskppa0cmttas05cgcswrttn6jrq4yd7jpdnvc7gt0yc"
    )
    """
    Bech32 delegation stake address
    """
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 ID of delegated stake pool
    """
    active_epoch: int = Field(..., example=210)
    """
    Epoch in which the delegation becomes active
    """


class TxContentDelegations(BaseModel):
    __root__: List[TxContentDelegation]


class TxContentWithdrawal(BaseModel):
    address: str = Field(
        ..., example="stake1u9r76ypf5fskppa0cmttas05cgcswrttn6jrq4yd7jpdnvc7gt0yc"
    )
    """
    Bech32 withdrawal address
    """
    amount: str = Field(..., example="431833601")
    """
    Withdrawal amount in Lovelaces
    """


class TxContentWithdrawals(BaseModel):
    __root__: List[TxContentWithdrawal]


class Pot(Enum):
    """
    Source of MIR funds
    """

    reserve = "reserve"
    treasury = "treasury"


class TxContentMir(BaseModel):
    pot: Pot = Field(..., example="reserve")
    """
    Source of MIR funds
    """
    cert_index: int = Field(..., example=0)
    """
    Index of the certificate within the transaction
    """
    address: str = Field(
        ..., example="stake1u9r76ypf5fskppa0cmttas05cgcswrttn6jrq4yd7jpdnvc7gt0yc"
    )
    """
    Bech32 stake address
    """
    amount: str = Field(..., example="431833601")
    """
    MIR amount in Lovelaces
    """


class TxContentMirs(BaseModel):
    __root__: List[TxContentMir]


class Metadata(BaseModel):
    url: str = Field(..., example="https://stakenuts.com/mainnet.json")
    """
    URL to the stake pool metadata
    """
    hash: str = Field(
        ..., example="47c0c68cb57f4a5b4a87bad896fc274678e7aea98e200fa14a1cb40c0cab1d8c"
    )
    """
    Hash of the metadata file
    """
    ticker: str = Field(..., example="NUTS")
    """
    Ticker of the stake pool
    """
    name: str = Field(..., example="Stake Nuts")
    """
    Name of the stake pool
    """
    description: str = Field(..., example="The best pool ever")
    """
    Description of the stake pool
    """
    homepage: str = Field(..., example="https://stakentus.com/")
    """
    Home page of the stake pool
    """


class Relay(BaseModel):
    ipv4: str = Field(..., example="4.4.4.4")
    """
    IPv4 address of the relay
    """
    ipv6: str = Field(..., example="https://stakenuts.com/mainnet.json")
    """
    IPv6 address of the relay
    """
    dns: str = Field(..., example="relay1.stakenuts.com")
    """
    DNS name of the relay
    """
    dns_srv: str = Field(..., example="_relays._tcp.relays.stakenuts.com")
    """
    DNS SRV entry of the relay
    """
    port: int = Field(..., example=3001)
    """
    Network port of the relay
    """


class TxContentPoolCert(BaseModel):
    cert_index: int = Field(..., example=0)
    """
    Index of the certificate within the transaction
    """
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 encoded pool ID
    """
    vrf_key: str = Field(
        ..., example="0b5245f9934ec2151116fb8ec00f35fd00e0aa3b075c4ed12cce440f999d8233"
    )
    """
    VRF key hash
    """
    pledge: str = Field(..., example="5000000000")
    """
    Stake pool certificate pledge in Lovelaces
    """
    margin_cost: float = Field(..., example=0.05)
    """
    Margin tax cost of the stake pool
    """
    fixed_cost: str = Field(..., example="340000000")
    """
    Fixed tax cost of the stake pool in Lovelaces
    """
    reward_account: str = Field(
        ..., example="stake1uxkptsa4lkr55jleztw43t37vgdn88l6ghclfwuxld2eykgpgvg3f"
    )
    """
    Bech32 reward account of the stake pool
    """
    owners: List[str] = Field(
        ..., example=["stake1u98nnlkvkk23vtvf9273uq7cph5ww6u2yq2389psuqet90sv4xv9v"]
    )
    metadata: Metadata
    relays: List[Relay]
    active_epoch: int = Field(..., example=210)
    """
    Epoch in which the update becomes active
    """


class TxContentPoolCerts(BaseModel):
    __root__: List[TxContentPoolCert]


class TxContentPoolRetire(BaseModel):
    cert_index: int = Field(..., example=0)
    """
    Index of the certificate within the transaction
    """
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 stake pool ID
    """
    retiring_epoch: int = Field(..., example=216)
    """
    Epoch in which the pool becomes retired
    """


class TxContentPoolRetires(BaseModel):
    __root__: List[TxContentPoolRetire]


class TxContentMetadatum(BaseModel):
    label: str
    """
    Metadata label
    """
    json_metadata: Union[str, Dict[str, Any]]
    """
    Content of the metadata
    """


class TxContentMetadata(BaseModel):
    __root__: List[TxContentMetadatum] = Field(
        ...,
        example=[
            {
                "label": "1967",
                "json_metadata": {
                    "metadata": "https://nut.link/metadata.json",
                    "hash": "6bf124f217d0e5a0a8adb1dbd8540e1334280d49ab861127868339f43b3948af",
                },
            },
            {
                "label": "1968",
                "json_metadata": {
                    "ADAUSD": [
                        {"value": "0.10409800535729975", "source": "ergoOracles"}
                    ]
                },
            },
        ],
    )


class TxContentMetadataCborItem(BaseModel):
    label: str
    """
    Metadata label
    """
    cbor_metadata: str
    """
    Content of the CBOR metadata
    """
    metadata: str
    """
    Content of the CBOR metadata in hex
    """


class TxContentMetadataCbor(BaseModel):
    __root__: List[TxContentMetadataCborItem] = Field(
        ...,
        example=[
            {
                "label": "1968",
                "cbor_metadata": "\\xa100a16b436f6d62696e6174696f6e8601010101010c",
                "metadata": "a100a16b436f6d62696e6174696f6e8601010101010c",
            }
        ],
    )


class Purpose(Enum):
    """
    Validation purpose
    """

    spend = "spend"
    mint = "mint"
    cert = "cert"
    reward = "reward"


class TxContentRedeemer(BaseModel):
    tx_index: int = Field(..., example=0)
    """
    Index of the redeemer within the transaction
    """
    purpose: Purpose = Field(..., example="spend")
    """
    Validation purpose
    """
    script_hash: str = Field(
        ..., example="ec26b89af41bef0f7585353831cb5da42b5b37185e0c8a526143b824"
    )
    """
    Script hash
    """
    redeemer_data_hash: str = Field(
        ..., example="923918e403bf43c34b4ef6b48eb2ee04babed17320d8d1b9ff9ad086e86f44ec"
    )
    """
    Redeemer data hash
    """
    datum_hash: str = Field(
        ..., example="923918e403bf43c34b4ef6b48eb2ee04babed17320d8d1b9ff9ad086e86f44ec"
    )
    """
    Datum hash
    """
    unit_mem: str = Field(..., example="1700")
    """
    The budget in Memory to run a script
    """
    unit_steps: str = Field(..., example="476468")
    """
    The budget in CPU steps to run a script
    """
    fee: str = Field(..., example="172033")
    """
    The fee consumed to run the script
    """


class TxContentRedeemers(BaseModel):
    __root__: List[TxContentRedeemer]


class AccountContent(BaseModel):
    stake_address: str = Field(
        ..., example="stake1ux3g2c9dx2nhhehyrezyxpkstartcqmu9hk63qgfkccw5rqttygt7"
    )
    """
    Bech32 stake address
    """
    active: bool = Field(..., example=True)
    """
    Registration state of an account
    """
    active_epoch: int = Field(..., example=412)
    """
    Epoch of the most recent action - registration or deregistration
    """
    controlled_amount: str = Field(..., example="619154618165")
    """
    Balance of the account in Lovelaces
    """
    rewards_sum: str = Field(..., example="319154618165")
    """
    Sum of all rewards for the account in the Lovelaces
    """
    withdrawals_sum: str = Field(..., example="12125369253")
    """
    Sum of all the withdrawals for the account in Lovelaces
    """
    reserves_sum: str = Field(..., example="319154618165")
    """
    Sum of all  funds from reserves for the account in the Lovelaces
    """
    treasury_sum: str = Field(..., example="12000000")
    """
    Sum of all funds from treasury for the account in the Lovelaces
    """
    withdrawable_amount: str = Field(..., example="319154618165")
    """
    Sum of available rewards that haven't been withdrawn yet for the account in the Lovelaces
    """
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 pool ID that owns the account
    """


class Type(Enum):
    """
    Type of the reward
    """

    leader = "leader"
    member = "member"
    pool_deposit_refund = "pool_deposit_refund"


class AccountRewardContentItem(BaseModel):
    epoch: int
    """
    Epoch of the associated reward
    """
    amount: str
    """
    Rewards for given epoch in Lovelaces
    """
    pool_id: str
    """
    Bech32 pool ID being delegated to
    """
    type: Type
    """
    Type of the reward
    """


class AccountRewardContent(BaseModel):
    __root__: List[AccountRewardContentItem] = Field(
        ...,
        example=[
            {
                "epoch": 215,
                "amount": "12695385",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
                "type": "member",
            },
            {
                "epoch": 216,
                "amount": "3586329",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
                "type": "member",
            },
            {
                "epoch": 217,
                "amount": "1",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
                "type": "member",
            },
            {
                "epoch": 217,
                "amount": "1337",
                "pool_id": "pool1cytwr0n7eas6du2h2xshl8ypa1yqr18f0erlhhjcuczysiunjcs",
                "type": "leader",
            },
            {
                "epoch": 218,
                "amount": "1395265",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
                "type": "member",
            },
            {
                "epoch": 218,
                "amount": "500000000",
                "pool_id": "pool1cytwr0n7eas6du2h2xshl8ypa1yqr18f0erlhhjcuczysiunjcs",
                "type": "pool_deposit_refund",
            },
        ],
    )


class AccountHistoryContentItem(BaseModel):
    active_epoch: int = Field(..., example=210)
    """
    Epoch in which the stake was active
    """
    amount: str
    """
    Stake amount in Lovelaces
    """
    pool_id: str
    """
    Bech32 ID of pool being delegated to
    """


class AccountHistoryContent(BaseModel):
    __root__: List[AccountHistoryContentItem] = Field(
        ...,
        example=[
            {
                "active_epoch": 210,
                "amount": "12695385",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
            },
            {
                "active_epoch": 211,
                "amount": "22695385",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
            },
        ],
    )


class AccountDelegationContentItem(BaseModel):
    active_epoch: int = Field(..., example=210)
    """
    Epoch in which the delegation becomes active
    """
    tx_hash: str
    """
    Hash of the transaction containing the delegation
    """
    amount: str
    """
    Rewards for given epoch in Lovelaces
    """
    pool_id: str
    """
    Bech32 ID of pool being delegated to
    """


class AccountDelegationContent(BaseModel):
    __root__: List[AccountDelegationContentItem] = Field(
        ...,
        example=[
            {
                "active_epoch": 210,
                "tx_hash": "2dd15e0ef6e6a17841cb9541c27724072ce4d4b79b91e58432fbaa32d9572531",
                "amount": "12695385",
                "pool_id": "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
            },
            {
                "active_epoch": 242,
                "tx_hash": "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dde628516157f0",
                "amount": "12691385",
                "pool_id": "pool1kchver88u3kygsak8wgll7htr8uxn5v35lfrsyy842nkscrzyvj",
            },
        ],
    )


class Action(Enum):
    """
    Action in the certificate
    """

    registered = "registered"
    deregistered = "deregistered"


class AccountRegistrationContentItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction containing the (de)registration certificate
    """
    action: Action
    """
    Action in the certificate
    """


class AccountRegistrationContent(BaseModel):
    __root__: List[AccountRegistrationContentItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "2dd15e0ef6e6a17841cb9541c27724072ce4d4b79b91e58432fbaa32d9572531",
                "action": "registered",
            },
            {
                "tx_hash": "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dde628516157f0",
                "action": "deregistered",
            },
        ],
    )


class AccountWithdrawalContentItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction containing the withdrawal
    """
    amount: str
    """
    Withdrawal amount in Lovelaces
    """


class AccountWithdrawalContent(BaseModel):
    __root__: List[AccountWithdrawalContentItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "48a9625c841eea0dd2bb6cf551eabe6523b7290c9ce34be74eedef2dd8f7ecc5",
                "amount": "454541212442",
            },
            {
                "tx_hash": "4230b0cbccf6f449f0847d8ad1d634a7a49df60d8c142bb8cc2dbc8ca03d9e34",
                "amount": "97846969",
            },
        ],
    )


class AccountMirContentItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction containing the MIR
    """
    amount: str
    """
    MIR amount in Lovelaces
    """


class AccountMirContent(BaseModel):
    __root__: List[AccountMirContentItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "69705bba1d687a816ff5a04ec0c358a1f1ef075ab7f9c6cc2763e792581cec6d",
                "amount": "2193707473",
            },
            {
                "tx_hash": "baaa77b63d4d7d2bb3ab02c9b85978c2092c336dede7f59e31ad65452d510c13",
                "amount": "14520198574",
            },
        ],
    )


class AccountAddressesContentItem(BaseModel):
    address: str
    """
    Address associated with the stake key
    """


class AccountAddressesContent(BaseModel):
    __root__: List[AccountAddressesContentItem] = Field(
        ...,
        example=[
            {
                "address": "addr1qx2kd28nq8ac5prwg32hhvudlwggpgfp8utlyqxu6wqgz62f79qsdmm5dsknt9ecr5w468r9ey0fxwkdrwh08ly3tu9sy0f4qd"
            },
            {
                "address": "addr1qys3czp8s9thc6u2fqed9yq3h24nyw28uk0m6mkgn9dkckjf79qsdmm5dsknt9ecr5w468r9ey0fxwkdrwh08ly3tu9suth4w4"
            },
            {
                "address": "addr1q8j55h253zcvl326sk5qdt2n8z7eghzspe0ekxgncr796s2f79qsdmm5dsknt9ecr5w468r9ey0fxwkdrwh08ly3tu9sjmd35m"
            },
            {
                "address": "addr1q8f7gxrprank3drhx8k5grlux7ene0nlwun8y9thu8mc3yjf79qsdmm5dsknt9ecr5w468r9ey0fxwkdrwh08ly3tu9sls6vnt"
            },
        ],
    )


class AccountAddressesAsset(BaseModel):
    """
    The sum of all assets of all addresses associated with a given account
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class AccountAddressesAssets(BaseModel):
    __root__: List[AccountAddressesAsset] = Field(
        ...,
        example=[
            {
                "unit": "d5e6bf0500378d4f0da4e8dde6becec7621cd8cbf5cbb9b87013d4cc537061636542756433343132",
                "quantity": "1",
            },
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "125",
            },
        ],
    )


class ReceivedSumItem(BaseModel):
    """
    The sum of all the UTXO per asset for all addresses associated with the account
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class SentSumItem(BaseModel):
    """
    The sum of all the UTXO per asset for all addresses associated with the account
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class AccountAddressesTotal(BaseModel):
    stake_address: str = Field(
        ..., example="stake1u9l5q5jwgelgagzyt6nuaasefgmn8pd25c8e9qpeprq0tdcp0e3uk"
    )
    """
    Bech32 encoded stake address
    """
    received_sum: List[ReceivedSumItem] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    sent_sum: List[SentSumItem] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    tx_count: int = Field(..., example=12)
    """
    Count of all transactions for all addresses associated with the account
    """


class MempoolContentItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction
    """


class MempoolContent(BaseModel):
    __root__: List[MempoolContentItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dce628516157f0"
            }
        ],
    )


class OutputAmountItem1(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class Tx(BaseModel):
    hash: str = Field(
        ..., example="1e043f100dce12d107f679685acd2fc0610e10f72a92d412794c9773d11d8477"
    )
    """
    Transaction hash
    """
    output_amount: List[OutputAmountItem1] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    fees: str = Field(..., example="182485")
    """
    Fees of the transaction in Lovelaces
    """
    deposit: str = Field(..., example="0")
    """
    Deposit within the transaction in Lovelaces
    """
    size: int = Field(..., example=433)
    """
    Size of the transaction in Bytes
    """
    invalid_before: str
    """
    Left (included) endpoint of the timelock validity intervals
    """
    invalid_hereafter: str = Field(..., example="13885913")
    """
    Right (excluded) endpoint of the timelock validity intervals
    """
    utxo_count: int = Field(..., example=4)
    """
    Count of UTXOs within the transaction
    """
    withdrawal_count: int = Field(..., example=0)
    """
    Count of the withdrawals within the transaction
    """
    mir_cert_count: int = Field(..., example=0)
    """
    Count of the MIR certificates within the transaction
    """
    delegation_count: int = Field(..., example=0)
    """
    Count of the delegations within the transaction
    """
    stake_cert_count: int = Field(..., example=0)
    """
    Count of the stake keys (de)registration within the transaction
    """
    pool_update_count: int = Field(..., example=0)
    """
    Count of the stake pool registration and update certificates within the transaction
    """
    pool_retire_count: int = Field(..., example=0)
    """
    Count of the stake pool retirement certificates within the transaction
    """
    asset_mint_or_burn_count: int = Field(..., example=0)
    """
    Count of asset mints and burns within the transaction
    """
    redeemer_count: int = Field(..., example=0)
    """
    Count of redeemers within the transaction
    """
    valid_contract: bool = Field(..., example=True)
    """
    True if contract script passed validation
    """


class Input1(BaseModel):
    tx_hash: str = Field(
        ..., example="1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dce628516157f0"
    )
    """
    Hash of the UTXO transaction
    """
    output_index: int = Field(..., example=0)
    """
    UTXO index in the transaction
    """
    collateral: bool = Field(..., example=False)
    """
    Whether the input is a collateral consumed on script validation failure
    """
    reference: Optional[bool] = Field(None, example=False)
    """
    Whether the input is a reference transaction input
    """


class AmountItem2(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class Output1(BaseModel):
    address: str = Field(
        ...,
        example="addr1q9ld26v2lv8wvrxxmvg90pn8n8n5k6tdst06q2s856rwmvnueldzuuqmnsye359fqrk8hwvenjnqultn7djtrlft7jnq7dy7wv",
    )
    """
    Output address
    """
    amount: List[AmountItem2] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    output_index: int = Field(..., example=0)
    """
    UTXO index in the transaction
    """
    data_hash: str = Field(
        ..., example="9e478573ab81ea7a8e31891ce0648b81229f408d596a3483e6f4f9b92d3cf710"
    )
    """
    The hash of the transaction output datum
    """
    inline_datum: str = Field(..., example="19a6aa")
    """
    CBOR encoded inline datum
    """
    collateral: bool = Field(..., example=False)
    """
    Whether the output is a collateral output
    """
    reference_script_hash: str = Field(
        ..., example="13a3efd825703a352a8f71f4e2758d08c28c564e8dfcce9f77776ad1"
    )
    """
    The hash of the reference script of the output
    """


class Purpose1(Enum):
    """
    Validation purpose
    """

    spend = "spend"
    mint = "mint"
    cert = "cert"
    reward = "reward"


class Redeemer(BaseModel):
    tx_index: int = Field(..., example=0)
    """
    Index of the redeemer within the transaction
    """
    purpose: Purpose1 = Field(..., example="spend")
    """
    Validation purpose
    """
    unit_mem: str = Field(..., example="1700")
    """
    The budget in Memory to run a script
    """
    unit_steps: str = Field(..., example="476468")
    """
    The budget in CPU steps to run a script
    """


class MempoolTxContent(BaseModel):
    tx: Tx
    inputs: List[Input1]
    outputs: List[Output1]
    redeemers: Optional[List[Redeemer]] = None


class TxMetadataLabel(BaseModel):
    label: str
    """
    Metadata label
    """
    cip10: str
    """
    CIP10 defined description
    """
    count: str
    """
    The count of metadata entries with a specific label
    """


class TxMetadataLabels(BaseModel):
    __root__: List[TxMetadataLabel] = Field(
        ...,
        example=[
            {"label": "1990", "cip10": None, "count": "1"},
            {
                "label": "1967",
                "cip10": "nut.link metadata oracles registry",
                "count": "3",
            },
            {
                "label": "1968",
                "cip10": "nut.link metadata oracles data points",
                "count": "16321",
            },
        ],
    )


class TxMetadataLabelJsonItem(BaseModel):
    tx_hash: str
    """
    Transaction hash that contains the specific metadata
    """
    json_metadata: Union[str, Dict[str, Any], List, int, float, bool]
    """
    Content of the JSON metadata
    """


class TxMetadataLabelJson(BaseModel):
    __root__: List[TxMetadataLabelJsonItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "257d75c8ddb0434e9b63e29ebb6241add2b835a307aa33aedba2effe09ed4ec8",
                "json_metadata": {
                    "ADAUSD": [
                        {"value": "0.10409800535729975", "source": "ergoOracles"}
                    ]
                },
            },
            {
                "tx_hash": "e865f2cc01ca7381cf98dcdc4de07a5e8674b8ea16e6a18e3ed60c186fde2b9c",
                "json_metadata": {
                    "ADAUSD": [
                        {"value": "0.15409850555139935", "source": "ergoOracles"}
                    ]
                },
            },
            {
                "tx_hash": "4237501da3cfdd53ade91e8911e764bd0699d88fd43b12f44a1f459b89bc91be",
                "json_metadata": None,
            },
        ],
    )


class TxMetadataLabelCborItem(BaseModel):
    tx_hash: str
    """
    Transaction hash that contains the specific metadata
    """
    cbor_metadata: str
    """
    Content of the CBOR metadata
    """
    metadata: str
    """
    Content of the CBOR metadata in hex
    """


class TxMetadataLabelCbor(BaseModel):
    __root__: List[TxMetadataLabelCborItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "257d75c8ddb0434e9b63e29ebb6241add2b835a307aa33aedba2effe09ed4ec8",
                "cbor_metadata": None,
                "metadata": None,
            },
            {
                "tx_hash": "e865f2cc01ca7381cf98dcdc4de07a5e8674b8ea16e6a18e3ed60c186fde2b9c",
                "cbor_metadata": None,
                "metadata": None,
            },
            {
                "tx_hash": "4237501da3cfdd53ade91e8911e764bd0699d88fd43b12f44a1f459b89bc91be",
                "cbor_metadata": "\\xa100a16b436f6d62696e6174696f6e8601010101010c",
                "metadata": "a100a16b436f6d62696e6174696f6e8601010101010c",
            },
        ],
    )


class AmountItem3(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class Type1(Enum):
    """
    Address era
    """

    byron = "byron"
    shelley = "shelley"


class AddressContent(BaseModel):
    address: str = Field(
        ...,
        example="addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
    )
    """
    Bech32 encoded addresses
    """
    amount: List[AmountItem3] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    stake_address: str = Field(
        ..., example="stake1ux3g2c9dx2nhhehyrezyxpkstartcqmu9hk63qgfkccw5rqttygt7"
    )
    """
    Stake address that controls the key
    """
    type: Type1 = Field(..., example="shelley")
    """
    Address era
    """
    script: bool = Field(..., example=False)
    """
    True if this is a script address
    """


class AmountItem4(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """
    decimals: int
    """
    Number of decimal places of the asset unit. Primary data source is CIP68 reference NFT with a fallback to off-chain metadata.
    """
    has_nft_onchain_metadata: bool
    """
    True if the latest minting transaction includes metadata (best-effort)
    """


class Type2(Enum):
    """
    Address era
    """

    byron = "byron"
    shelley = "shelley"


class AddressContentExtended(BaseModel):
    address: str = Field(
        ...,
        example="addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
    )
    """
    Bech32 encoded addresses
    """
    amount: List[AmountItem4] = Field(
        ...,
        example=[
            {
                "unit": "lovelace",
                "quantity": "42000000",
                "decimals": 6,
                "has_nft_onchain_metadata": False,
            },
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
                "decimals": None,
                "has_nft_onchain_metadata": True,
            },
        ],
    )
    stake_address: str = Field(
        ..., example="stake1ux3g2c9dx2nhhehyrezyxpkstartcqmu9hk63qgfkccw5rqttygt7"
    )
    """
    Stake address that controls the key
    """
    type: Type2 = Field(..., example="shelley")
    """
    Address era
    """
    script: bool = Field(..., example=False)
    """
    True if this is a script address
    """


class ReceivedSumItem1(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class SentSumItem1(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class AddressContentTotal(BaseModel):
    address: str = Field(
        ...,
        example="addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
    )
    """
    Bech32 encoded address
    """
    received_sum: List[ReceivedSumItem1] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    sent_sum: List[SentSumItem1] = Field(
        ...,
        example=[
            {"unit": "lovelace", "quantity": "42000000"},
            {
                "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "12",
            },
        ],
    )
    tx_count: int = Field(..., example=12)
    """
    Count of all transactions on the address
    """


class AmountItem5(BaseModel):
    """
    The sum of all the UTXO per asset
    """

    unit: str
    """
    The unit of the value
    """
    quantity: str
    """
    The quantity of the unit
    """


class AddressUtxoContentItem(BaseModel):
    address: str = Field(
        ...,
        example="addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
    )
    """
    Bech32 encoded addresses - useful when querying by payment_cred
    """
    tx_hash: str
    """
    Transaction hash of the UTXO
    """
    tx_index: int
    """
    UTXO index in the transaction
    """
    output_index: int
    """
    UTXO index in the transaction
    """
    amount: List[AmountItem5]
    block: str
    """
    Block hash of the UTXO
    """
    data_hash: str
    """
    The hash of the transaction output datum
    """
    inline_datum: str = Field(..., example="19a6aa")
    """
    CBOR encoded inline datum
    """
    reference_script_hash: str = Field(
        ..., example="13a3efd825703a352a8f71f4e2758d08c28c564e8dfcce9f77776ad1"
    )
    """
    The hash of the reference script of the output
    """


class AddressUtxoContent(BaseModel):
    __root__: List[AddressUtxoContentItem] = Field(
        ...,
        example=[
            {
                "address": "addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
                "tx_hash": "39a7a284c2a0948189dc45dec670211cd4d72f7b66c5726c08d9b3df11e44d58",
                "output_index": 0,
                "amount": [{"unit": "lovelace", "quantity": "42000000"}],
                "block": "7eb8e27d18686c7db9a18f8bbcfe34e3fed6e047afaa2d969904d15e934847e6",
                "data_hash": "9e478573ab81ea7a8e31891ce0648b81229f408d596a3483e6f4f9b92d3cf710",
                "inline_datum": None,
                "reference_script_hash": None,
            },
            {
                "address": "addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
                "tx_hash": "4c4e67bafa15e742c13c592b65c8f74c769cd7d9af04c848099672d1ba391b49",
                "output_index": 0,
                "amount": [{"unit": "lovelace", "quantity": "729235000"}],
                "block": "953f1b80eb7c11a7ffcd67cbd4fde66e824a451aca5a4065725e5174b81685b7",
                "data_hash": None,
                "inline_datum": None,
                "reference_script_hash": None,
            },
            {
                "address": "addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
                "tx_hash": "768c63e27a1c816a83dc7b07e78af673b2400de8849ea7e7b734ae1333d100d2",
                "output_index": 1,
                "amount": [
                    {"unit": "lovelace", "quantity": "42000000"},
                    {
                        "unit": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                        "quantity": "12",
                    },
                ],
                "block": "5c571f83fe6c784d3fbc223792627ccf0eea96773100f9aedecf8b1eda4544d7",
                "data_hash": None,
                "inline_datum": None,
                "reference_script_hash": None,
            },
        ],
    )


class AddressTxsContent(BaseModel):
    __root__: List[str] = Field(
        ...,
        example=[
            "2dd15e0ef6e6a17841cb9541c27724072ce4d4b79b91e58432fbaa32d9572531",
            "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dde628516157f0",
        ],
    )


class AddressTransactionsContentItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction
    """
    tx_index: int
    """
    Transaction index within the block
    """
    block_height: int
    """
    Block height
    """
    block_time: int
    """
    Block creation time in UNIX time
    """


class AddressTransactionsContent(BaseModel):
    __root__: List[AddressTransactionsContentItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "8788591983aa73981fc92d6cddbbe643959f5a784e84b8bee0db15823f575a5b",
                "tx_index": 6,
                "block_height": 69,
                "block_time": 1635505891,
            },
            {
                "tx_hash": "52e748c4dec58b687b90b0b40d383b9fe1f24c1a833b7395cdf07dd67859f46f",
                "tx_index": 9,
                "block_height": 4547,
                "block_time": 1635505987,
            },
            {
                "tx_hash": "e8073fd5318ff43eca18a852527166aa8008bee9ee9e891f585612b7e4ba700b",
                "tx_index": 0,
                "block_height": 564654,
                "block_time": 1834505492,
            },
        ],
    )


class PoolList(BaseModel):
    __root__: List[str] = Field(
        ...,
        example=[
            "pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy",
            "pool1hn7hlwrschqykupwwrtdfkvt2u4uaxvsgxyh6z63703p2knj288",
            "pool1ztjyjfsh432eqetadf82uwuxklh28xc85zcphpwq6mmezavzad2",
        ],
    )


class PoolListExtendedItem(BaseModel):
    pool_id: str = Field(
        ..., example="pool1z5uqdk7dzdxaae5633fqfcu2eqzy3a3rgtuvy087fdld7yws0xt"
    )
    """
    Bech32 encoded pool ID
    """
    hex: str = Field(
        ..., example="0f292fcaa02b8b2f9b3c8f9fd8e0bb21abedb692a6d5058df3ef2735"
    )
    """
    Hexadecimal pool ID.
    """
    active_stake: str = Field(..., example="4200000000")
    """
    Active delegated amount
    """
    live_stake: str = Field(..., example="6900000000")
    """
    Currently delegated amount
    """


class PoolListExtended(BaseModel):
    __root__: List[PoolListExtendedItem] = Field(
        ...,
        example=[
            {
                "pool_id": "pool19u64770wqp6s95gkajc8udheske5e6ljmpq33awxk326zjaza0q",
                "hex": "2f355f79ee007502d116ecb07e36f985b34cebf2d84118f5c6b455a1",
                "active_stake": "1541200000",
                "live_stake": "1541400000",
            },
            {
                "pool_id": "pool1dvla4zq98hpvacv20snndupjrqhuc79zl6gjap565nku6et5zdx",
                "hex": "6b3fda88053dc2cee18a7c2736f032182fcc78a2fe912e869aa4edcd",
                "active_stake": "22200000",
                "live_stake": "48955550",
            },
            {
                "pool_id": "pool1wvccajt4eugjtf3k0ja3exjqdj7t8egsujwhcw4tzj4rzsxzw5w",
                "hex": "73318ec975cf1125a6367cbb1c9a406cbcb3e510e49d7c3aab14aa31",
                "active_stake": "9989541215",
                "live_stake": "168445464878",
            },
        ],
    )


class PoolListRetireItem(BaseModel):
    pool_id: str = Field(
        ..., example="pool1z5uqdk7dzdxaae5633fqfcu2eqzy3a3rgtuvy087fdld7yws0xt"
    )
    """
    Bech32 encoded pool ID
    """
    epoch: int = Field(..., example=242)
    """
    Retirement epoch number
    """


class PoolListRetire(BaseModel):
    __root__: List[PoolListRetireItem] = Field(
        ...,
        example=[
            {
                "pool_id": "pool19u64770wqp6s95gkajc8udheske5e6ljmpq33awxk326zjaza0q",
                "epoch": 225,
            },
            {
                "pool_id": "pool1dvla4zq98hpvacv20snndupjrqhuc79zl6gjap565nku6et5zdx",
                "epoch": 215,
            },
            {
                "pool_id": "pool1wvccajt4eugjtf3k0ja3exjqdj7t8egsujwhcw4tzj4rzsxzw5w",
                "epoch": 231,
            },
        ],
    )


class Pool(BaseModel):
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 pool ID
    """
    hex: str = Field(
        ..., example="0f292fcaa02b8b2f9b3c8f9fd8e0bb21abedb692a6d5058df3ef2735"
    )
    """
    Hexadecimal pool ID.
    """
    vrf_key: str = Field(
        ..., example="0b5245f9934ec2151116fb8ec00f35fd00e0aa3b075c4ed12cce440f999d8233"
    )
    """
    VRF key hash
    """
    blocks_minted: int = Field(..., example=69)
    """
    Total minted blocks
    """
    blocks_epoch: int = Field(..., example=4)
    """
    Number of blocks minted in the current epoch
    """
    live_stake: str = Field(..., example="6900000000")
    live_size: float = Field(..., example=0.42)
    live_saturation: float = Field(..., example=0.93)
    live_delegators: float = Field(..., example=127)
    active_stake: str = Field(..., example="4200000000")
    active_size: float = Field(..., example=0.43)
    declared_pledge: str = Field(..., example="5000000000")
    """
    Stake pool certificate pledge
    """
    live_pledge: str = Field(..., example="5000000001")
    """
    Stake pool current pledge
    """
    margin_cost: float = Field(..., example=0.05)
    """
    Margin tax cost of the stake pool
    """
    fixed_cost: str = Field(..., example="340000000")
    """
    Fixed tax cost of the stake pool
    """
    reward_account: str = Field(
        ..., example="stake1uxkptsa4lkr55jleztw43t37vgdn88l6ghclfwuxld2eykgpgvg3f"
    )
    """
    Bech32 reward account of the stake pool
    """
    owners: List[str] = Field(
        ..., example=["stake1u98nnlkvkk23vtvf9273uq7cph5ww6u2yq2389psuqet90sv4xv9v"]
    )
    registration: List[str] = Field(
        ...,
        example=[
            "9f83e5484f543e05b52e99988272a31da373f3aab4c064c76db96643a355d9dc",
            "7ce3b8c433bf401a190d58c8c483d8e3564dfd29ae8633c8b1b3e6c814403e95",
            "3e6e1200ce92977c3fe5996bd4d7d7e192bcb7e231bc762f9f240c76766535b9",
        ],
    )
    retirement: List[str]


class PoolHistoryItem(BaseModel):
    epoch: int = Field(..., example=233)
    """
    Epoch number
    """
    blocks: int = Field(..., example=22)
    """
    Number of blocks created by pool
    """
    active_stake: str = Field(..., example="20485965693569")
    """
    Active (Snapshot of live stake 2 epochs ago) stake in Lovelaces
    """
    active_size: float = Field(..., example=1.2345)
    """
    Pool size (percentage) of overall active stake at that epoch
    """
    delegators_count: int = Field(..., example=115)
    """
    Number of delegators for epoch
    """
    rewards: str = Field(..., example="206936253674159")
    """
    Total rewards received before distribution to delegators
    """
    fees: str = Field(..., example="1290968354")
    """
    Pool operator rewards
    """


class PoolHistory(BaseModel):
    __root__: List[PoolHistoryItem]


class PoolMetadata(BaseModel):
    pool_id: str = Field(
        ..., example="pool1pu5jlj4q9w9jlxeu370a3c9myx47md5j5m2str0naunn2q3lkdy"
    )
    """
    Bech32 pool ID
    """
    hex: str = Field(
        ..., example="0f292fcaa02b8b2f9b3c8f9fd8e0bb21abedb692a6d5058df3ef2735"
    )
    """
    Hexadecimal pool ID
    """
    url: str = Field(..., example="https://stakenuts.com/mainnet.json")
    """
    URL to the stake pool metadata
    """
    hash: str = Field(
        ..., example="47c0c68cb57f4a5b4a87bad896fc274678e7aea98e200fa14a1cb40c0cab1d8c"
    )
    """
    Hash of the metadata file
    """
    ticker: str = Field(..., example="NUTS")
    """
    Ticker of the stake pool
    """
    name: str = Field(..., example="Stake Nuts")
    """
    Name of the stake pool
    """
    description: str = Field(..., example="The best pool ever")
    """
    Description of the stake pool
    """
    homepage: str = Field(..., example="https://stakentus.com/")
    """
    Home page of the stake pool
    """


class EmptyObject(BaseModel):
    pass


class PoolRelay(BaseModel):
    ipv4: str = Field(..., example="4.4.4.4")
    """
    IPv4 address of the relay
    """
    ipv6: str = Field(..., example="https://stakenuts.com/mainnet.json")
    """
    IPv6 address of the relay
    """
    dns: str = Field(..., example="relay1.stakenuts.com")
    """
    DNS name of the relay
    """
    dns_srv: str = Field(..., example="_relays._tcp.relays.stakenuts.com")
    """
    DNS SRV entry of the relay
    """
    port: int = Field(..., example=3001)
    """
    Network port of the relay
    """


class PoolRelays(BaseModel):
    __root__: List[PoolRelay]


class PoolDelegator(BaseModel):
    address: str
    """
    Bech32 encoded stake addresses
    """
    live_stake: str
    """
    Currently delegated amount
    """


class PoolDelegators(BaseModel):
    __root__: List[PoolDelegator] = Field(
        ...,
        example=[
            {
                "address": "stake1ux4vspfvwuus9uwyp5p3f0ky7a30jq5j80jxse0fr7pa56sgn8kha",
                "live_stake": "1137959159981411",
            },
            {
                "address": "stake1uylayej7esmarzd4mk4aru37zh9yz0luj3g9fsvgpfaxulq564r5u",
                "live_stake": "16958865648",
            },
            {
                "address": "stake1u8lr2pnrgf8f7vrs9lt79hc3sxm8s2w4rwvgpncks3axx6q93d4ck",
                "live_stake": "18605647",
            },
        ],
    )


class PoolBlocks(BaseModel):
    __root__: List[str] = Field(
        ...,
        example=[
            "d8982ca42cfe76b747cc681d35d671050a9e41e9cfe26573eb214e94fe6ff21d",
            "026436c539e2ce84c7f77ffe669f4e4bbbb3b9c53512e5857dcba8bb0b4e9a8c",
            "bcc8487f419b8c668a18ea2120822a05df6dfe1de1f0fac3feba88cf760f303c",
            "86bf7b4a274e0f8ec9816171667c1b4a0cfc661dc21563f271acea9482b62df7",
        ],
    )


class Action1(Enum):
    """
    Action in the certificate
    """

    registered = "registered"
    deregistered = "deregistered"


class PoolUpdate(BaseModel):
    tx_hash: str
    """
    Transaction ID
    """
    cert_index: int
    """
    Certificate within the transaction
    """
    action: Action1
    """
    Action in the certificate
    """


class PoolUpdates(BaseModel):
    __root__: List[PoolUpdate] = Field(
        ...,
        example=[
            {
                "tx_hash": "6804edf9712d2b619edb6ac86861fe93a730693183a262b165fcc1ba1bc99cad",
                "cert_index": 0,
                "action": "registered",
            },
            {
                "tx_hash": "9c190bc1ac88b2ab0c05a82d7de8b71b67a9316377e865748a89d4426c0d3005",
                "cert_index": 0,
                "action": "deregistered",
            },
            {
                "tx_hash": "e14a75b0eb2625de7055f1f580d70426311b78e0d36dd695a6bdc96c7b3d80e0",
                "cert_index": 1,
                "action": "registered",
            },
        ],
    )


class Asset(BaseModel):
    asset: str
    """
    Asset identifier
    """
    quantity: str
    """
    Current asset quantity
    """


class Assets(BaseModel):
    __root__: List[Asset] = Field(
        ...,
        example=[
            {
                "asset": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "1",
            },
            {
                "asset": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e75d",
                "quantity": "100000",
            },
            {
                "asset": "6804edf9712d2b619edb6ac86861fe93a730693183a262b165fcc1ba1bc99cad",
                "quantity": "18605647",
            },
        ],
    )


class OnchainMetadataStandard(Enum):
    """
    If on-chain metadata passes validation, we display the standard
    under which it is valid

    """

    CIP25v1 = "CIP25v1"
    CIP25v2 = "CIP25v2"


class Metadata1(BaseModel):
    """
    Off-chain metadata fetched from GitHub based on network.
    Mainnet: https://github.com/cardano-foundation/cardano-token-registry/
    Testnet: https://github.com/input-output-hk/metadata-registry-testnet/

    """

    name: str = Field(..., example="nutcoin")
    """
    Asset name
    """
    description: str = Field(..., example="The Nut Coin")
    """
    Asset description
    """
    ticker: str = Field(..., example="nutc")
    url: str = Field(..., example="https://www.stakenuts.com/")
    """
    Asset website
    """
    logo: str = Field(
        ...,
        example="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",
    )
    """
    Base64 encoded logo of the asset
    """
    decimals: int = Field(..., example=6, le=255)
    """
    Number of decimal places of the asset unit
    """


class Asset1(BaseModel):
    asset: str = Field(
        ...,
        example="b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
    )
    """
    Hex-encoded asset full name
    """
    policy_id: str = Field(
        ..., example="b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a7"
    )
    """
    Policy ID of the asset
    """
    asset_name: str = Field(..., example="6e7574636f696e")
    """
    Hex-encoded asset name of the asset
    """
    fingerprint: str = Field(
        ..., example="asset1pkpwyknlvul7az0xx8czhl60pyel45rpje4z8w"
    )
    """
    CIP14 based user-facing fingerprint
    """
    quantity: str = Field(..., example="12000")
    """
    Current asset quantity
    """
    initial_mint_tx_hash: str = Field(
        ..., example="6804edf9712d2b619edb6ac86861fe93a730693183a262b165fcc1ba1bc99cad"
    )
    """
    ID of the initial minting transaction
    """
    mint_or_burn_count: int = Field(..., example=1)
    """
    Count of mint and burn transactions
    """
    onchain_metadata: Dict[str, Any]
    """
    On-chain metadata which SHOULD adhere to the valid standards,
    based on which we perform the look up and display the asset
    (best effort)

    """
    onchain_metadata_standard: Optional[OnchainMetadataStandard] = None
    """
    If on-chain metadata passes validation, we display the standard
    under which it is valid

    """
    metadata: Metadata1
    """
    Off-chain metadata fetched from GitHub based on network.
    Mainnet: https://github.com/cardano-foundation/cardano-token-registry/
    Testnet: https://github.com/input-output-hk/metadata-registry-testnet/

    """


class Action2(Enum):
    """
    Action executed upon the asset policy
    """

    minted = "minted"
    burned = "burned"


class AssetHistoryItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction containing the asset action
    """
    action: Action2
    """
    Action executed upon the asset policy
    """
    amount: str
    """
    Asset amount of the specific action
    """


class AssetHistory(BaseModel):
    __root__: List[AssetHistoryItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "2dd15e0ef6e6a17841cb9541c27724072ce4d4b79b91e58432fbaa32d9572531",
                "amount": "10",
                "action": "minted",
            },
            {
                "tx_hash": "9c190bc1ac88b2ab0c05a82d7de8b71b67a9316377e865748a89d4426c0d3005",
                "amount": "5",
                "action": "burned",
            },
            {
                "tx_hash": "1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dde628516157f0",
                "amount": "5",
                "action": "burned",
            },
        ],
    )


class AssetTxs(BaseModel):
    __root__: List[str] = Field(
        ...,
        example=[
            "8788591983aa73981fc92d6cddbbe643959f5a784e84b8bee0db15823f575a5b",
            "52e748c4dec58b687b90b0b40d383b9fe1f24c1a833b7395cdf07dd67859f46f",
            "e8073fd5318ff43eca18a852527166aa8008bee9ee9e891f585612b7e4ba700b",
        ],
    )


class AssetTransaction(BaseModel):
    tx_hash: str
    """
    Hash of the transaction
    """
    tx_index: int
    """
    Transaction index within the block
    """
    block_height: int
    """
    Block height
    """
    block_time: int = Field(..., example=1635505891)
    """
    Block creation time in UNIX time
    """


class AssetTransactions(BaseModel):
    __root__: List[AssetTransaction] = Field(
        ...,
        example=[
            {
                "tx_hash": "8788591983aa73981fc92d6cddbbe643959f5a784e84b8bee0db15823f575a5b",
                "tx_index": 6,
                "block_height": 69,
                "block_time": 1635505891,
            },
            {
                "tx_hash": "52e748c4dec58b687b90b0b40d383b9fe1f24c1a833b7395cdf07dd67859f46f",
                "tx_index": 9,
                "block_height": 4547,
                "block_time": 1635505987,
            },
            {
                "tx_hash": "e8073fd5318ff43eca18a852527166aa8008bee9ee9e891f585612b7e4ba700b",
                "tx_index": 0,
                "block_height": 564654,
                "block_time": 1834505492,
            },
        ],
    )


class AssetAddress(BaseModel):
    address: str
    """
    Address containing the specific asset
    """
    quantity: str
    """
    Asset quantity on the specific address
    """


class AssetAddresses(BaseModel):
    __root__: List[AssetAddress] = Field(
        ...,
        example=[
            {
                "address": "addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
                "quantity": "1",
            },
            {
                "address": "addr1qyhr4exrgavdcn3qhfcc9f939fzsch2re5ry9cwvcdyh4x4re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qdpvhza",
                "quantity": "100000",
            },
            {
                "address": "addr1q8zup8m9ue3p98kxlxl9q8rnyan8hw3ul282tsl9s326dfj088lvedv4zckcj24arcpasr0gua4c5gq4zw2rpcpjk2lq8cmd9l",
                "quantity": "18605647",
            },
        ],
    )


class AssetPolicyItem(BaseModel):
    asset: str
    """
    Concatenation of the policy_id and hex-encoded asset_name
    """
    quantity: str
    """
    Current asset quantity
    """


class AssetPolicy(BaseModel):
    __root__: List[AssetPolicyItem] = Field(
        ...,
        example=[
            {
                "asset": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a76e7574636f696e",
                "quantity": "1",
            },
            {
                "asset": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb38a766e",
                "quantity": "100000",
            },
            {
                "asset": "b0d07d45fe9514f80213f4020e5a61241458be626841cde717cb574636f696e",
                "quantity": "18605647",
            },
        ],
    )


class Script(BaseModel):
    script_hash: str
    """
    Script hash
    """


class Scripts(BaseModel):
    __root__: List[Script] = Field(
        ...,
        example=[
            {"script_hash": "13a3efd825703a352a8f71f4e2758d08c28c564e8dfcce9f77776ad1"},
            {"script_hash": "e1457a0c47dfb7a2f6b8fbb059bdceab163c05d34f195b87b9f2b30e"},
            {"script_hash": "a6e63c0ff05c96943d1cc30bf53112ffff0f34b45986021ca058ec54"},
        ],
    )


class Type3(Enum):
    """
    Type of the script language
    """

    timelock = "timelock"
    plutusV1 = "plutusV1"
    plutusV2 = "plutusV2"


class Script1(BaseModel):
    script_hash: str = Field(
        ..., example="13a3efd825703a352a8f71f4e2758d08c28c564e8dfcce9f77776ad1"
    )
    """
    Script hash
    """
    type: Type3 = Field(..., example="plutusV1")
    """
    Type of the script language
    """
    serialised_size: int = Field(..., example=3119)
    """
    The size of the CBOR serialised script, if a Plutus script
    """


class ScriptJson(BaseModel):
    json_: Union[str, Dict[str, Any], List, int, float, bool] = Field(..., alias="json")
    """
    JSON contents of the `timelock` script, null for `plutus` scripts
    """


class ScriptCbor(BaseModel):
    cbor: str
    """
    CBOR contents of the `plutus` script, null for `timelocks`
    """


class Purpose2(Enum):
    """
    Validation purpose
    """

    spend = "spend"
    mint = "mint"
    cert = "cert"
    reward = "reward"


class ScriptRedeemer(BaseModel):
    tx_hash: str = Field(
        ..., example="1a0570af966fb355a7160e4f82d5a80b8681b7955f5d44bec0dce628516157f0"
    )
    """
    Hash of the transaction
    """
    tx_index: int = Field(..., example=0)
    """
    The index of the redeemer pointer in the transaction
    """
    purpose: Purpose2 = Field(..., example="spend")
    """
    Validation purpose
    """
    redeemer_data_hash: str = Field(
        ..., example="923918e403bf43c34b4ef6b48eb2ee04babed17320d8d1b9ff9ad086e86f44ec"
    )
    """
    Datum hash of the redeemer
    """
    datum_hash: str = Field(
        ..., example="923918e403bf43c34b4ef6b48eb2ee04babed17320d8d1b9ff9ad086e86f44ec"
    )
    """
    Datum hash
    """
    unit_mem: str = Field(..., example="1700")
    """
    The budget in Memory to run a script
    """
    unit_steps: str = Field(..., example="476468")
    """
    The budget in CPU steps to run a script
    """
    fee: str = Field(..., example="172033")
    """
    The fee consumed to run the script
    """


class ScriptRedeemers(BaseModel):
    __root__: List[ScriptRedeemer]


class ScriptDatum(BaseModel):
    json_value: Any
    """
    JSON content of the datum
    """


class ScriptDatumCbor(BaseModel):
    cbor: str
    """
    CBOR serialized datum
    """


class UtilsAddressesXpub(BaseModel):
    xpub: str
    """
    Script hash
    """
    role: int
    """
    Account role
    """
    index: int
    """
    Address index
    """
    address: str
    """
    Derived address
    """


class Metric(BaseModel):
    time: int
    """
    Starting time of the call count interval (ends midnight UTC) in UNIX time
    """
    calls: int
    """
    Sum of all calls for a particular day
    """


class Metrics(BaseModel):
    __root__: List[Metric] = Field(
        ...,
        example=[
            {"time": 1612543884, "calls": 42},
            {"time": 1614523884, "calls": 6942},
        ],
    )


class MetricsEndpoint(BaseModel):
    time: int
    """
    Starting time of the call count interval (ends midnight UTC) in UNIX time
    """
    calls: int
    """
    Sum of all calls for a particular day and endpoint
    """
    endpoint: str
    """
    Endpoint parent name
    """


class MetricsEndpoints(BaseModel):
    __root__: List[MetricsEndpoint] = Field(
        ...,
        example=[
            {"time": 1612543814, "calls": 182, "endpoint": "block"},
            {"time": 1612543814, "calls": 42, "endpoint": "epoch"},
            {"time": 1612543812, "calls": 775, "endpoint": "block"},
            {"time": 1612523884, "calls": 4, "endpoint": "epoch"},
            {"time": 1612553884, "calls": 89794, "endpoint": "block"},
        ],
    )


class Supply(BaseModel):
    max: str = Field(..., example="45000000000000000")
    """
    Maximum supply in Lovelaces
    """
    total: str = Field(..., example="32890715183299160")
    """
    Current total (max supply - reserves) supply in Lovelaces
    """
    circulating: str = Field(..., example="32412601976210393")
    """
    Current circulating (UTXOs + withdrawables) supply in Lovelaces
    """
    locked: str = Field(..., example="125006953355")
    """
    Current supply locked by scripts in Lovelaces
    """
    treasury: str = Field(..., example="98635632000000")
    """
    Current supply locked in treasury
    """
    reserves: str = Field(..., example="46635632000000")
    """
    Current supply locked in reserves
    """


class Stake(BaseModel):
    live: str = Field(..., example="23204950463991654")
    """
    Current live stake in Lovelaces
    """
    active: str = Field(..., example="22210233523456321")
    """
    Current active stake in Lovelaces
    """


class Network(BaseModel):
    supply: Supply
    stake: Stake


class Start(BaseModel):
    """
    Start of the blockchain era,
    relative to the start of the network

    """

    time: float
    """
    Time in seconds relative to the start time of the network
    """
    slot: int
    """
    Absolute slot number
    """
    epoch: int
    """
    Epoch number
    """


class End(BaseModel):
    """
    End of the blockchain era,
    relative to the start of the network

    """

    time: float
    """
    Time in seconds relative to the start time of the network
    """
    slot: int
    """
    Absolute slot number
    """
    epoch: int
    """
    Epoch number
    """


class Parameters(BaseModel):
    """
    Era parameters
    """

    epoch_length: int
    """
    Epoch length in number of slots
    """
    slot_length: float
    """
    Slot length in seconds
    """
    safe_zone: int
    """
    Zone in which it is guaranteed that no hard fork can take place
    """


class NetworkEra(BaseModel):
    start: Start
    """
    Start of the blockchain era,
    relative to the start of the network

    """
    end: End
    """
    End of the blockchain era,
    relative to the start of the network

    """
    parameters: Parameters
    """
    Era parameters
    """


class NetworkEras(BaseModel):
    __root__: List[NetworkEra] = Field(
        ...,
        example=[
            {
                "start": {"time": 0, "slot": 0, "epoch": 0},
                "end": {"time": 89856000, "slot": 4492800, "epoch": 208},
                "parameters": {
                    "epoch_length": 21600,
                    "slot_length": 20,
                    "safe_zone": 4320,
                },
            },
            {
                "start": {"time": 89856000, "slot": 4492800, "epoch": 208},
                "end": {"time": 101952000, "slot": 16588800, "epoch": 236},
                "parameters": {
                    "epoch_length": 432000,
                    "slot_length": 1,
                    "safe_zone": 129600,
                },
            },
        ],
    )


class NutlinkAddress(BaseModel):
    address: str = Field(
        ...,
        example="addr1qxqs59lphg8g6qndelq8xwqn60ag3aeyfcp33c2kdp46a09re5df3pzwwmyq946axfcejy5n4x0y99wqpgtp2gd0k09qsgy6pz",
    )
    """
    Bech32 encoded address
    """
    metadata_url: str = Field(..., example="https://nut.link/metadata.json")
    """
    URL of the specific metadata file
    """
    metadata_hash: str = Field(
        ..., example="6bf124f217d0e5a0a8adb1dbd8540e1334280d49ab861127868339f43b3948af"
    )
    """
    Hash of the metadata file
    """
    metadata: Dict[str, Any]
    """
    The cached metadata of the `metadata_url` file.
    """


class NutlinkAddressTicker(BaseModel):
    name: str
    """
    Name of the ticker
    """
    count: int
    """
    Number of ticker records
    """
    latest_block: int
    """
    Block height of the latest record
    """


class NutlinkAddressTickers(BaseModel):
    __root__: List[NutlinkAddressTicker] = Field(
        ...,
        example=[
            {"name": "ADAUSD", "count": 1980038, "latest_block": 2657092},
            {"name": "ADAEUR", "count": 1980038, "latest_block": 2657092},
            {"name": "ADABTC", "count": 1980038, "latest_block": 2657092},
        ],
    )


class NutlinkAddressTickerItem(BaseModel):
    tx_hash: str
    """
    Hash of the transaction
    """
    block_height: int
    """
    Block height of the record
    """
    tx_index: int
    """
    Transaction index within the block
    """
    payload: Union[str, Dict[str, Any], List, int, float, bool]
    """
    Content of the ticker
    """


class NutlinkAddressTicker1(BaseModel):
    __root__: List[NutlinkAddressTickerItem] = Field(
        ...,
        example=[
            {
                "tx_hash": "e8073fd5318ff43eca18a852527166aa8008bee9ee9e891f585612b7e4ba700b",
                "block_height": 2657092,
                "tx_index": 8,
                "payload": [
                    {"source": "coinGecko", "value": "1.29"},
                    {"source": "cryptoCompare", "value": "1.283"},
                ],
            }
        ],
    )


class NutlinkTickersTickerItem(BaseModel):
    address: str
    """
    Address of a metadata oracle
    """
    tx_hash: str
    """
    Hash of the transaction
    """
    block_height: int
    """
    Block height of the record
    """
    tx_index: int
    """
    Transaction index within the block
    """
    payload: Union[str, Dict[str, Any], List, int, float, bool]
    """
    Content of the ticker
    """


class NutlinkTickersTicker(BaseModel):
    __root__: List[NutlinkTickersTickerItem] = Field(
        ...,
        example=[
            {
                "address": "addr_test1qpmtp5t0t5y6cqkaz7rfsyrx7mld77kpvksgkwm0p7en7qum7a589n30e80tclzrrnj8qr4qvzj6al0vpgtnmrkkksnqd8upj0",
                "tx_hash": "e8073fd5318ff43eca18a852527166aa8008bee9ee9e891f585612b7e4ba700b",
                "block_height": 2657092,
                "tx_index": 8,
                "payload": [
                    {"source": "coinGecko", "value": "1.29"},
                    {"source": "cryptoCompare", "value": "1.283"},
                ],
            }
        ],
    )


class File(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = Field(None, example="myimage")
    """
    Name of the file
    """
    mediaType: str = Field(..., example="image/jpeg")
    """
    Mime sub-type of image
    """
    src: Union[str, List[str]] = Field(..., example="My NFT token description")
    """
    URI pointing to a resource of this mime type
    """


class AssetOnchainMetadataCip25(BaseModel):
    """
    On-chain metadata stored in the minting transaction under label 721,
    which adheres to https://cips.cardano.org/cips/cip25/

    """

    class Config:
        extra = Extra.allow

    name: str = Field(..., example="My NFT token")
    """
    Name of the asset
    """
    image: Union[str, List[str]] = Field(
        ..., example="ipfs://ipfs/QmfKyJ4tuvHowwKQCbCHj4L5T3fSj8cjs7Aau8V7BWv226"
    )
    """
    URI(s) of the associated asset
    """
    description: Optional[Union[str, List[str]]] = Field(
        None, example="My NFT token description"
    )
    """
    Additional description
    """
    mediaType: Optional[str] = Field(None, example="image/jpeg")
    """
    Mime sub-type of image
    """
    files: Optional[List[File]] = None


class AssetOnchainMetadataCip68Ft333(BaseModel):
    """
    On-chain metadata stored in the datum of the reference NFT output
    which adheres to 333 FT Standard https://cips.cardano.org/cips/cip68/

    """

    class Config:
        extra = Extra.allow

    name: str = Field(..., example="My FT token")
    """
    Name of the asset
    """
    description: str = Field(..., example="My FT token description")
    """
    Additional description
    """
    logo: Optional[str] = Field(
        None, example="ipfs://ipfs/QmfKyJ4tuvHowwKQCbCHj4L5T3fSj8cjs7Aau8V7BWv226"
    )
    """
    URI(s) of the associated asset
    """
    ticker: Optional[str] = Field(None, example="TOK")
    """
    Ticker
    """
    decimals: Optional[float] = Field(None, example=8)
    """
    Number of decimals
    """


class File1(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = Field(None, example="myimage")
    """
    Name of the file
    """
    mediaType: str = Field(..., example="image/jpeg")
    """
    Mime sub-type of image
    """
    src: Union[str, List[str]] = Field(..., example="My NFT token description")
    """
    URI pointing to a resource of this mime type
    """


class AssetOnchainMetadataCip68Nft222(BaseModel):
    """
    On-chain metadata stored in the datum of the reference NFT output
    which adheres to 222 NFT Standard https://cips.cardano.org/cips/cip68/

    """

    class Config:
        extra = Extra.allow

    name: str = Field(..., example="My NFT token")
    """
    Name of the asset
    """
    image: str = Field(
        ..., example="ipfs://ipfs/QmfKyJ4tuvHowwKQCbCHj4L5T3fSj8cjs7Aau8V7BWv226"
    )
    """
    URI(s) of the associated asset
    """
    description: Optional[str] = Field(None, example="My NFT token description")
    """
    Additional description
    """
    mediaType: Optional[str] = Field(None, example="image/jpeg")
    """
    Mime sub-type of image
    """
    files: Optional[List[File1]] = None


class OnchainMetadataCip25(BaseModel):
    __root__: AssetOnchainMetadataCip25


class OnchainMetadataCip68Ft333(BaseModel):
    __root__: AssetOnchainMetadataCip68Ft333


class OnchainMetadataCip68Nft222(BaseModel):
    __root__: AssetOnchainMetadataCip68Nft222
