# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_envoy_cli` - Install for python with `pip install nomad-envoy-cli`  # noqa: E501

    The version of the OpenAPI document: 1.44
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_envoy_cli.configuration import Configuration


class Product(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'product_id': 'str',
        'name': 'str',
        'name_en': 'str',
        'skus': 'list[ProductSku]',
        'currency': 'str',
        'mass_unit': 'str',
        'time_unit': 'str',
        'barcode': 'str',
        'description': 'str',
        'price': 'float',
        'rrp': 'float',
        'group_buying_price': 'float',
        'net_weight': 'float',
        'gross_weight': 'float',
        'images': 'Images',
        'is_onsale': 'bool',
        'status': 'str',
        'category': 'list[str]',
        'vendor': 'str',
        'country': 'str',
        'shelf_life': 'float',
        'created_at': 'str',
        'updated_at': 'str',
        'logistics_mode': 'str',
        'shipping_cost': 'float',
        'shipping_time': 'int',
        'hs_code': 'str',
        'personal_postal_articles_tax': 'str',
        'ingredient': 'str',
        'model': 'str',
        'spec': 'str',
        'warranty_period': 'int',
        'express_type': 'str',
        'discount': 'float',
        'tax_rate': 'float',
        'brand': 'str',
        'store_id': 'str',
        'category_id': 'str'
    }

    attribute_map = {
        'product_id': 'productId',
        'name': 'name',
        'name_en': 'nameEn',
        'skus': 'skus',
        'currency': 'currency',
        'mass_unit': 'massUnit',
        'time_unit': 'timeUnit',
        'barcode': 'barcode',
        'description': 'description',
        'price': 'price',
        'rrp': 'rrp',
        'group_buying_price': 'groupBuyingPrice',
        'net_weight': 'netWeight',
        'gross_weight': 'grossWeight',
        'images': 'images',
        'is_onsale': 'isOnsale',
        'status': 'status',
        'category': 'category',
        'vendor': 'vendor',
        'country': 'country',
        'shelf_life': 'shelfLife',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'logistics_mode': 'logisticsMode',
        'shipping_cost': 'shippingCost',
        'shipping_time': 'shippingTime',
        'hs_code': 'hsCode',
        'personal_postal_articles_tax': 'personalPostalArticlesTax',
        'ingredient': 'ingredient',
        'model': 'model',
        'spec': 'spec',
        'warranty_period': 'warrantyPeriod',
        'express_type': 'expressType',
        'discount': 'discount',
        'tax_rate': 'taxRate',
        'brand': 'brand',
        'store_id': 'storeId',
        'category_id': 'categoryId'
    }

    def __init__(self, product_id=None, name=None, name_en=None, skus=None, currency='RMB', mass_unit='Kilogram', time_unit=None, barcode=None, description=None, price=None, rrp=None, group_buying_price=None, net_weight=None, gross_weight=None, images=None, is_onsale=None, status='draft', category=None, vendor=None, country=None, shelf_life=None, created_at=None, updated_at=None, logistics_mode=None, shipping_cost=None, shipping_time=None, hs_code=None, personal_postal_articles_tax=None, ingredient=None, model=None, spec=None, warranty_period=365, express_type=None, discount=None, tax_rate=None, brand='Other', store_id=None, category_id=None, local_vars_configuration=None):  # noqa: E501
        """Product - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._product_id = None
        self._name = None
        self._name_en = None
        self._skus = None
        self._currency = None
        self._mass_unit = None
        self._time_unit = None
        self._barcode = None
        self._description = None
        self._price = None
        self._rrp = None
        self._group_buying_price = None
        self._net_weight = None
        self._gross_weight = None
        self._images = None
        self._is_onsale = None
        self._status = None
        self._category = None
        self._vendor = None
        self._country = None
        self._shelf_life = None
        self._created_at = None
        self._updated_at = None
        self._logistics_mode = None
        self._shipping_cost = None
        self._shipping_time = None
        self._hs_code = None
        self._personal_postal_articles_tax = None
        self._ingredient = None
        self._model = None
        self._spec = None
        self._warranty_period = None
        self._express_type = None
        self._discount = None
        self._tax_rate = None
        self._brand = None
        self._store_id = None
        self._category_id = None
        self.discriminator = None

        if product_id is not None:
            self.product_id = product_id
        if name is not None:
            self.name = name
        if name_en is not None:
            self.name_en = name_en
        if skus is not None:
            self.skus = skus
        self.currency = currency
        self.mass_unit = mass_unit
        if time_unit is not None:
            self.time_unit = time_unit
        if barcode is not None:
            self.barcode = barcode
        if description is not None:
            self.description = description
        if price is not None:
            self.price = price
        if rrp is not None:
            self.rrp = rrp
        if group_buying_price is not None:
            self.group_buying_price = group_buying_price
        if net_weight is not None:
            self.net_weight = net_weight
        if gross_weight is not None:
            self.gross_weight = gross_weight
        if images is not None:
            self.images = images
        if is_onsale is not None:
            self.is_onsale = is_onsale
        if status is not None:
            self.status = status
        if category is not None:
            self.category = category
        if vendor is not None:
            self.vendor = vendor
        if country is not None:
            self.country = country
        if shelf_life is not None:
            self.shelf_life = shelf_life
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if logistics_mode is not None:
            self.logistics_mode = logistics_mode
        if shipping_cost is not None:
            self.shipping_cost = shipping_cost
        if shipping_time is not None:
            self.shipping_time = shipping_time
        if hs_code is not None:
            self.hs_code = hs_code
        if personal_postal_articles_tax is not None:
            self.personal_postal_articles_tax = personal_postal_articles_tax
        if ingredient is not None:
            self.ingredient = ingredient
        if model is not None:
            self.model = model
        if spec is not None:
            self.spec = spec
        if warranty_period is not None:
            self.warranty_period = warranty_period
        if express_type is not None:
            self.express_type = express_type
        if discount is not None:
            self.discount = discount
        if tax_rate is not None:
            self.tax_rate = tax_rate
        if brand is not None:
            self.brand = brand
        if store_id is not None:
            self.store_id = store_id
        if category_id is not None:
            self.category_id = category_id

    @property
    def product_id(self):
        """Gets the product_id of this Product.  # noqa: E501

        product ID of third parties.  # noqa: E501

        :return: The product_id of this Product.  # noqa: E501
        :rtype: str
        """
        return self._product_id

    @product_id.setter
    def product_id(self, product_id):
        """Sets the product_id of this Product.

        product ID of third parties.  # noqa: E501

        :param product_id: The product_id of this Product.  # noqa: E501
        :type: str
        """

        self._product_id = product_id

    @property
    def name(self):
        """Gets the name of this Product.  # noqa: E501

        Default name, usually it's Chinese.  # noqa: E501

        :return: The name of this Product.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Product.

        Default name, usually it's Chinese.  # noqa: E501

        :param name: The name of this Product.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def name_en(self):
        """Gets the name_en of this Product.  # noqa: E501

        English name, should be optional  # noqa: E501

        :return: The name_en of this Product.  # noqa: E501
        :rtype: str
        """
        return self._name_en

    @name_en.setter
    def name_en(self, name_en):
        """Sets the name_en of this Product.

        English name, should be optional  # noqa: E501

        :param name_en: The name_en of this Product.  # noqa: E501
        :type: str
        """

        self._name_en = name_en

    @property
    def skus(self):
        """Gets the skus of this Product.  # noqa: E501

        all SKU in a product  # noqa: E501

        :return: The skus of this Product.  # noqa: E501
        :rtype: list[ProductSku]
        """
        return self._skus

    @skus.setter
    def skus(self, skus):
        """Sets the skus of this Product.

        all SKU in a product  # noqa: E501

        :param skus: The skus of this Product.  # noqa: E501
        :type: list[ProductSku]
        """

        self._skus = skus

    @property
    def currency(self):
        """Gets the currency of this Product.  # noqa: E501

        The currency used in current product, it makes sense if we declare it explicity.  # noqa: E501

        :return: The currency of this Product.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Product.

        The currency used in current product, it makes sense if we declare it explicity.  # noqa: E501

        :param currency: The currency of this Product.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def mass_unit(self):
        """Gets the mass_unit of this Product.  # noqa: E501

        weight unit in current product.  # noqa: E501

        :return: The mass_unit of this Product.  # noqa: E501
        :rtype: str
        """
        return self._mass_unit

    @mass_unit.setter
    def mass_unit(self, mass_unit):
        """Sets the mass_unit of this Product.

        weight unit in current product.  # noqa: E501

        :param mass_unit: The mass_unit of this Product.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and mass_unit is None:  # noqa: E501
            raise ValueError("Invalid value for `mass_unit`, must not be `None`")  # noqa: E501

        self._mass_unit = mass_unit

    @property
    def time_unit(self):
        """Gets the time_unit of this Product.  # noqa: E501

        time unit in current product.  # noqa: E501

        :return: The time_unit of this Product.  # noqa: E501
        :rtype: str
        """
        return self._time_unit

    @time_unit.setter
    def time_unit(self, time_unit):
        """Sets the time_unit of this Product.

        time unit in current product.  # noqa: E501

        :param time_unit: The time_unit of this Product.  # noqa: E501
        :type: str
        """

        self._time_unit = time_unit

    @property
    def barcode(self):
        """Gets the barcode of this Product.  # noqa: E501


        :return: The barcode of this Product.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this Product.


        :param barcode: The barcode of this Product.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def description(self):
        """Gets the description of this Product.  # noqa: E501


        :return: The description of this Product.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Product.


        :param description: The description of this Product.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def price(self):
        """Gets the price of this Product.  # noqa: E501

        The default selling price of current product.  # noqa: E501

        :return: The price of this Product.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this Product.

        The default selling price of current product.  # noqa: E501

        :param price: The price of this Product.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def rrp(self):
        """Gets the rrp of this Product.  # noqa: E501

        recommended retail price  # noqa: E501

        :return: The rrp of this Product.  # noqa: E501
        :rtype: float
        """
        return self._rrp

    @rrp.setter
    def rrp(self, rrp):
        """Sets the rrp of this Product.

        recommended retail price  # noqa: E501

        :param rrp: The rrp of this Product.  # noqa: E501
        :type: float
        """

        self._rrp = rrp

    @property
    def group_buying_price(self):
        """Gets the group_buying_price of this Product.  # noqa: E501

        group buying price  # noqa: E501

        :return: The group_buying_price of this Product.  # noqa: E501
        :rtype: float
        """
        return self._group_buying_price

    @group_buying_price.setter
    def group_buying_price(self, group_buying_price):
        """Sets the group_buying_price of this Product.

        group buying price  # noqa: E501

        :param group_buying_price: The group_buying_price of this Product.  # noqa: E501
        :type: float
        """

        self._group_buying_price = group_buying_price

    @property
    def net_weight(self):
        """Gets the net_weight of this Product.  # noqa: E501

        The default net weight of current product.  # noqa: E501

        :return: The net_weight of this Product.  # noqa: E501
        :rtype: float
        """
        return self._net_weight

    @net_weight.setter
    def net_weight(self, net_weight):
        """Sets the net_weight of this Product.

        The default net weight of current product.  # noqa: E501

        :param net_weight: The net_weight of this Product.  # noqa: E501
        :type: float
        """

        self._net_weight = net_weight

    @property
    def gross_weight(self):
        """Gets the gross_weight of this Product.  # noqa: E501

        The default gross weight of current product.  # noqa: E501

        :return: The gross_weight of this Product.  # noqa: E501
        :rtype: float
        """
        return self._gross_weight

    @gross_weight.setter
    def gross_weight(self, gross_weight):
        """Sets the gross_weight of this Product.

        The default gross weight of current product.  # noqa: E501

        :param gross_weight: The gross_weight of this Product.  # noqa: E501
        :type: float
        """

        self._gross_weight = gross_weight

    @property
    def images(self):
        """Gets the images of this Product.  # noqa: E501


        :return: The images of this Product.  # noqa: E501
        :rtype: Images
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this Product.


        :param images: The images of this Product.  # noqa: E501
        :type: Images
        """

        self._images = images

    @property
    def is_onsale(self):
        """Gets the is_onsale of this Product.  # noqa: E501

        if a product/sku is on sale.  # noqa: E501

        :return: The is_onsale of this Product.  # noqa: E501
        :rtype: bool
        """
        return self._is_onsale

    @is_onsale.setter
    def is_onsale(self, is_onsale):
        """Sets the is_onsale of this Product.

        if a product/sku is on sale.  # noqa: E501

        :param is_onsale: The is_onsale of this Product.  # noqa: E501
        :type: bool
        """

        self._is_onsale = is_onsale

    @property
    def status(self):
        """Gets the status of this Product.  # noqa: E501

        The status of a product in a store (more like a post) , could be draft/to_check/published/deleted/revoked. This field 'status' has priority over 'is_onsale'  # noqa: E501

        :return: The status of this Product.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Product.

        The status of a product in a store (more like a post) , could be draft/to_check/published/deleted/revoked. This field 'status' has priority over 'is_onsale'  # noqa: E501

        :param status: The status of this Product.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def category(self):
        """Gets the category of this Product.  # noqa: E501

        The category of current product, and the platform may or may not require fixed categories data  # noqa: E501

        :return: The category of this Product.  # noqa: E501
        :rtype: list[str]
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this Product.

        The category of current product, and the platform may or may not require fixed categories data  # noqa: E501

        :param category: The category of this Product.  # noqa: E501
        :type: list[str]
        """

        self._category = category

    @property
    def vendor(self):
        """Gets the vendor of this Product.  # noqa: E501

        The name of the product vendor  # noqa: E501

        :return: The vendor of this Product.  # noqa: E501
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """Sets the vendor of this Product.

        The name of the product vendor  # noqa: E501

        :param vendor: The vendor of this Product.  # noqa: E501
        :type: str
        """

        self._vendor = vendor

    @property
    def country(self):
        """Gets the country of this Product.  # noqa: E501

        The country of origin.  # noqa: E501

        :return: The country of this Product.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this Product.

        The country of origin.  # noqa: E501

        :param country: The country of this Product.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def shelf_life(self):
        """Gets the shelf_life of this Product.  # noqa: E501

        How long could we keep current product on the shelf.  # noqa: E501

        :return: The shelf_life of this Product.  # noqa: E501
        :rtype: float
        """
        return self._shelf_life

    @shelf_life.setter
    def shelf_life(self, shelf_life):
        """Sets the shelf_life of this Product.

        How long could we keep current product on the shelf.  # noqa: E501

        :param shelf_life: The shelf_life of this Product.  # noqa: E501
        :type: float
        """

        self._shelf_life = shelf_life

    @property
    def created_at(self):
        """Gets the created_at of this Product.  # noqa: E501

        The time that when current product was created, and should be ISO 8601 format.  # noqa: E501

        :return: The created_at of this Product.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Product.

        The time that when current product was created, and should be ISO 8601 format.  # noqa: E501

        :param created_at: The created_at of this Product.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Product.  # noqa: E501

        The time that when the last time current product was updated, and should be ISO 8601 format.  # noqa: E501

        :return: The updated_at of this Product.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Product.

        The time that when the last time current product was updated, and should be ISO 8601 format.  # noqa: E501

        :param updated_at: The updated_at of this Product.  # noqa: E501
        :type: str
        """

        self._updated_at = updated_at

    @property
    def logistics_mode(self):
        """Gets the logistics_mode of this Product.  # noqa: E501

        logistics mode of current product.  # noqa: E501

        :return: The logistics_mode of this Product.  # noqa: E501
        :rtype: str
        """
        return self._logistics_mode

    @logistics_mode.setter
    def logistics_mode(self, logistics_mode):
        """Sets the logistics_mode of this Product.

        logistics mode of current product.  # noqa: E501

        :param logistics_mode: The logistics_mode of this Product.  # noqa: E501
        :type: str
        """

        self._logistics_mode = logistics_mode

    @property
    def shipping_cost(self):
        """Gets the shipping_cost of this Product.  # noqa: E501

        The shipping cost of current product.  # noqa: E501

        :return: The shipping_cost of this Product.  # noqa: E501
        :rtype: float
        """
        return self._shipping_cost

    @shipping_cost.setter
    def shipping_cost(self, shipping_cost):
        """Sets the shipping_cost of this Product.

        The shipping cost of current product.  # noqa: E501

        :param shipping_cost: The shipping_cost of this Product.  # noqa: E501
        :type: float
        """

        self._shipping_cost = shipping_cost

    @property
    def shipping_time(self):
        """Gets the shipping_time of this Product.  # noqa: E501

        The days that take to ship and deliver to customer's door  # noqa: E501

        :return: The shipping_time of this Product.  # noqa: E501
        :rtype: int
        """
        return self._shipping_time

    @shipping_time.setter
    def shipping_time(self, shipping_time):
        """Sets the shipping_time of this Product.

        The days that take to ship and deliver to customer's door  # noqa: E501

        :param shipping_time: The shipping_time of this Product.  # noqa: E501
        :type: int
        """

        self._shipping_time = shipping_time

    @property
    def hs_code(self):
        """Gets the hs_code of this Product.  # noqa: E501

        The Harmonized Commodity Description and Coding System (HS code) of the tariff nomenclature is an international standardised system of names and numbers for the classification of commodities. The HS code system is based on a 6-digit nomenclature.  # noqa: E501

        :return: The hs_code of this Product.  # noqa: E501
        :rtype: str
        """
        return self._hs_code

    @hs_code.setter
    def hs_code(self, hs_code):
        """Sets the hs_code of this Product.

        The Harmonized Commodity Description and Coding System (HS code) of the tariff nomenclature is an international standardised system of names and numbers for the classification of commodities. The HS code system is based on a 6-digit nomenclature.  # noqa: E501

        :param hs_code: The hs_code of this Product.  # noqa: E501
        :type: str
        """

        self._hs_code = hs_code

    @property
    def personal_postal_articles_tax(self):
        """Gets the personal_postal_articles_tax of this Product.  # noqa: E501

        行邮税。Chinese version of parcel tax  # noqa: E501

        :return: The personal_postal_articles_tax of this Product.  # noqa: E501
        :rtype: str
        """
        return self._personal_postal_articles_tax

    @personal_postal_articles_tax.setter
    def personal_postal_articles_tax(self, personal_postal_articles_tax):
        """Sets the personal_postal_articles_tax of this Product.

        行邮税。Chinese version of parcel tax  # noqa: E501

        :param personal_postal_articles_tax: The personal_postal_articles_tax of this Product.  # noqa: E501
        :type: str
        """

        self._personal_postal_articles_tax = personal_postal_articles_tax

    @property
    def ingredient(self):
        """Gets the ingredient of this Product.  # noqa: E501

        The ingredient of current product.  # noqa: E501

        :return: The ingredient of this Product.  # noqa: E501
        :rtype: str
        """
        return self._ingredient

    @ingredient.setter
    def ingredient(self, ingredient):
        """Sets the ingredient of this Product.

        The ingredient of current product.  # noqa: E501

        :param ingredient: The ingredient of this Product.  # noqa: E501
        :type: str
        """

        self._ingredient = ingredient

    @property
    def model(self):
        """Gets the model of this Product.  # noqa: E501

        The model of current product.  # noqa: E501

        :return: The model of this Product.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this Product.

        The model of current product.  # noqa: E501

        :param model: The model of this Product.  # noqa: E501
        :type: str
        """

        self._model = model

    @property
    def spec(self):
        """Gets the spec of this Product.  # noqa: E501

        The spec of current product.  # noqa: E501

        :return: The spec of this Product.  # noqa: E501
        :rtype: str
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this Product.

        The spec of current product.  # noqa: E501

        :param spec: The spec of this Product.  # noqa: E501
        :type: str
        """

        self._spec = spec

    @property
    def warranty_period(self):
        """Gets the warranty_period of this Product.  # noqa: E501

        The warranty period of current product, time unit is day  # noqa: E501

        :return: The warranty_period of this Product.  # noqa: E501
        :rtype: int
        """
        return self._warranty_period

    @warranty_period.setter
    def warranty_period(self, warranty_period):
        """Sets the warranty_period of this Product.

        The warranty period of current product, time unit is day  # noqa: E501

        :param warranty_period: The warranty_period of this Product.  # noqa: E501
        :type: int
        """

        self._warranty_period = warranty_period

    @property
    def express_type(self):
        """Gets the express_type of this Product.  # noqa: E501

        CC/BC/BBC.  CC for free samples, like Temple Spa free samples; BBC for perfume, like Shay & Blue; BC for other products  # noqa: E501

        :return: The express_type of this Product.  # noqa: E501
        :rtype: str
        """
        return self._express_type

    @express_type.setter
    def express_type(self, express_type):
        """Sets the express_type of this Product.

        CC/BC/BBC.  CC for free samples, like Temple Spa free samples; BBC for perfume, like Shay & Blue; BC for other products  # noqa: E501

        :param express_type: The express_type of this Product.  # noqa: E501
        :type: str
        """

        self._express_type = express_type

    @property
    def discount(self):
        """Gets the discount of this Product.  # noqa: E501

        The default discount price of current product.  # noqa: E501

        :return: The discount of this Product.  # noqa: E501
        :rtype: float
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """Sets the discount of this Product.

        The default discount price of current product.  # noqa: E501

        :param discount: The discount of this Product.  # noqa: E501
        :type: float
        """

        self._discount = discount

    @property
    def tax_rate(self):
        """Gets the tax_rate of this Product.  # noqa: E501

        The default tax rate of current product.  # noqa: E501

        :return: The tax_rate of this Product.  # noqa: E501
        :rtype: float
        """
        return self._tax_rate

    @tax_rate.setter
    def tax_rate(self, tax_rate):
        """Sets the tax_rate of this Product.

        The default tax rate of current product.  # noqa: E501

        :param tax_rate: The tax_rate of this Product.  # noqa: E501
        :type: float
        """

        self._tax_rate = tax_rate

    @property
    def brand(self):
        """Gets the brand of this Product.  # noqa: E501

        The brand name of current product  # noqa: E501

        :return: The brand of this Product.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this Product.

        The brand name of current product  # noqa: E501

        :param brand: The brand of this Product.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def store_id(self):
        """Gets the store_id of this Product.  # noqa: E501

        The initial store id this product belongs to  # noqa: E501

        :return: The store_id of this Product.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this Product.

        The initial store id this product belongs to  # noqa: E501

        :param store_id: The store_id of this Product.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def category_id(self):
        """Gets the category_id of this Product.  # noqa: E501

        The categoryId, currently required by TOF  # noqa: E501

        :return: The category_id of this Product.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this Product.

        The categoryId, currently required by TOF  # noqa: E501

        :param category_id: The category_id of this Product.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Product):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Product):
            return True

        return self.to_dict() != other.to_dict()
