# coding: utf-8

"""
    Nomad Envoy

    This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_envoy_cli` - Install for python with `pip install nomad-envoy-cli`  # noqa: E501

    The version of the OpenAPI document: 1.44
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_envoy_cli.api_client import ApiClient
from nomad_envoy_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class OrderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_order(self, store, order, **kwargs):  # noqa: E501
        """addOrder  # noqa: E501

        Creates a new order for products for this store.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_order(store, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param Order order: Order details (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_order_with_http_info(store, order, **kwargs)  # noqa: E501

    def add_order_with_http_info(self, store, order, **kwargs):  # noqa: E501
        """addOrder  # noqa: E501

        Creates a new order for products for this store.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_order_with_http_info(store, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param Order order: Order details (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['store', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'store' is set
        if self.api_client.client_side_validation and ('store' not in local_var_params or  # noqa: E501
                                                        local_var_params['store'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `store` when calling `add_order`")  # noqa: E501
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `add_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'store' in local_var_params:
            path_params['store'] = local_var_params['store']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/order/{store}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_order(self, store, order_id, **kwargs):  # noqa: E501
        """cancelOrder  # noqa: E501

        Attempts to cancel a created order, success will depend on platform support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order(store, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param int order_id: ID of order to cancel. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_order_with_http_info(store, order_id, **kwargs)  # noqa: E501

    def cancel_order_with_http_info(self, store, order_id, **kwargs):  # noqa: E501
        """cancelOrder  # noqa: E501

        Attempts to cancel a created order, success will depend on platform support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_with_http_info(store, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param int order_id: ID of order to cancel. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['store', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'store' is set
        if self.api_client.client_side_validation and ('store' not in local_var_params or  # noqa: E501
                                                        local_var_params['store'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `store` when calling `cancel_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['order_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `cancel_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'store' in local_var_params:
            path_params['store'] = local_var_params['store']  # noqa: E501

        query_params = []
        if 'order_id' in local_var_params and local_var_params['order_id'] is not None:  # noqa: E501
            query_params.append(('order_id', local_var_params['order_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/order/{store}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_by_field(self, store, **kwargs):  # noqa: E501
        """getOrderByField  # noqa: E501

        Requests a list of orders based on the supplied parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_by_field(store, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param str order_id: Order ID ref (odoo platform) for order to get.
        :param str client_order_ref: Client order ref (third party platform, same as Order.entity)
        :param str status: order status, 6 available options are [WAIT_BUYER_PAY, WAIT_SELLER_SEND_GOODS, WAIT_BUYER_CONFIRM_GOODS, TRADE_SUCCESS, TRADE_CLOSED ,TRADE_REFUND]
        :param str type: order type, 2 available options are [NORMAL, DISTRIBUTION]
        :param str created_range: The time range of order creation, use ISO_8601 format here, e.g. 2007-03-01T13:00:00Z/2008-05-11T15:30:00Z
        :param str updated_range: The time range of order update, use ISO_8601 format here, e.g. 2007-03-01T13:00:00Z/2008-05-11T15:30:00Z
        :param int page_no: Page number
        :param int page_size: Page size
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_order_by_field_with_http_info(store, **kwargs)  # noqa: E501

    def get_order_by_field_with_http_info(self, store, **kwargs):  # noqa: E501
        """getOrderByField  # noqa: E501

        Requests a list of orders based on the supplied parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_by_field_with_http_info(store, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param str order_id: Order ID ref (odoo platform) for order to get.
        :param str client_order_ref: Client order ref (third party platform, same as Order.entity)
        :param str status: order status, 6 available options are [WAIT_BUYER_PAY, WAIT_SELLER_SEND_GOODS, WAIT_BUYER_CONFIRM_GOODS, TRADE_SUCCESS, TRADE_CLOSED ,TRADE_REFUND]
        :param str type: order type, 2 available options are [NORMAL, DISTRIBUTION]
        :param str created_range: The time range of order creation, use ISO_8601 format here, e.g. 2007-03-01T13:00:00Z/2008-05-11T15:30:00Z
        :param str updated_range: The time range of order update, use ISO_8601 format here, e.g. 2007-03-01T13:00:00Z/2008-05-11T15:30:00Z
        :param int page_no: Page number
        :param int page_size: Page size
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['store', 'order_id', 'client_order_ref', 'status', 'type', 'created_range', 'updated_range', 'page_no', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_by_field" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'store' is set
        if self.api_client.client_side_validation and ('store' not in local_var_params or  # noqa: E501
                                                        local_var_params['store'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `store` when calling `get_order_by_field`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'store' in local_var_params:
            path_params['store'] = local_var_params['store']  # noqa: E501

        query_params = []
        if 'order_id' in local_var_params and local_var_params['order_id'] is not None:  # noqa: E501
            query_params.append(('order_id', local_var_params['order_id']))  # noqa: E501
        if 'client_order_ref' in local_var_params and local_var_params['client_order_ref'] is not None:  # noqa: E501
            query_params.append(('client_order_ref', local_var_params['client_order_ref']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'created_range' in local_var_params and local_var_params['created_range'] is not None:  # noqa: E501
            query_params.append(('created_range', local_var_params['created_range']))  # noqa: E501
        if 'updated_range' in local_var_params and local_var_params['updated_range'] is not None:  # noqa: E501
            query_params.append(('updated_range', local_var_params['updated_range']))  # noqa: E501
        if 'page_no' in local_var_params and local_var_params['page_no'] is not None:  # noqa: E501
            query_params.append(('page_no', local_var_params['page_no']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/order/{store}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_order(self, store, order, **kwargs):  # noqa: E501
        """updateOrder  # noqa: E501

        Update the shipping status of an order for this store.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order(store, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param Order order: Order details (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_order_with_http_info(store, order, **kwargs)  # noqa: E501

    def update_order_with_http_info(self, store, order, **kwargs):  # noqa: E501
        """updateOrder  # noqa: E501

        Update the shipping status of an order for this store.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_with_http_info(store, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str store: ID of the store. (required)
        :param Order order: Order details (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['store', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'store' is set
        if self.api_client.client_side_validation and ('store' not in local_var_params or  # noqa: E501
                                                        local_var_params['store'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `store` when calling `update_order`")  # noqa: E501
        # verify the required parameter 'order' is set
        if self.api_client.client_side_validation and ('order' not in local_var_params or  # noqa: E501
                                                        local_var_params['order'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order` when calling `update_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'store' in local_var_params:
            path_params['store'] = local_var_params['store']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in local_var_params:
            body_params = local_var_params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key', 'ca_stage']  # noqa: E501

        return self.api_client.call_api(
            '/order/{store}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
