# pnap-bmc-api
Create, power off, power on, reset, reboot, or shut down your server with the Bare Metal Cloud API. 
Deprovision servers, get or edit SSH key details, assign public IPs, assign servers to networks and a lot more. 
Manage your infrastructure more efficiently using just a few simple API calls.<br>
<br>
<span class='pnap-api-knowledge-base-link'>
Knowledge base articles to help you can be found
<a href='https://phoenixnap.com/kb/how-to-deploy-bare-metal-cloud-server' target='_blank'>here</a>
</span><br>
<br>
<b>All URLs are relative to (https://api.phoenixnap.com/bmc/v1/)</b>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1
For more information, please visit [https://phoenixnap.com/](https://phoenixnap.com/)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
$ pip install pnap_bmc_api
```

Then import the package:
```python
import pnap_bmc_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_bmc_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import pnap_bmc_api
from pprint import pprint
from pnap_bmc_api.api import quotas_api
from pnap_bmc_api.model.error import Error
from pnap_bmc_api.model.quota import Quota
from pnap_bmc_api.model.quota_edit_limit_request import QuotaEditLimitRequest
# Defining the host is optional and defaults to https://api.phoenixnap.com/bmc/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_bmc_api.Configuration(
    host = "https://api.phoenixnap.com/bmc/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: OAuth2
configuration = pnap_bmc_api.Configuration(
    host = "https://api.phoenixnap.com/bmc/v1"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with pnap_bmc_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = quotas_api.QuotasApi(api_client)

    try:
        # List quotas
        api_response = api_instance.quotas_get()
        pprint(api_response)
    except pnap_bmc_api.ApiException as e:
        print("Exception when calling QuotasApi->quotas_get: %s\n" % e)
```

To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:
```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']
```

## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/bmc/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*QuotasApi* | [**quotas_get**](docs/QuotasApi.md#quotas_get) | **GET** /quotas | List quotas
*QuotasApi* | [**quotas_quota_id_actions_request_edit_post**](docs/QuotasApi.md#quotas_quota_id_actions_request_edit_post) | **POST** /quotas/{quotaId}/actions/request-edit | Request quota limit change.
*QuotasApi* | [**quotas_quota_id_get**](docs/QuotasApi.md#quotas_quota_id_get) | **GET** /quotas/{quotaId} | Get a quota.
*SSHKeysApi* | [**ssh_keys_get**](docs/SSHKeysApi.md#ssh_keys_get) | **GET** /ssh-keys | List SSH Keys.
*SSHKeysApi* | [**ssh_keys_post**](docs/SSHKeysApi.md#ssh_keys_post) | **POST** /ssh-keys | Create SSH Key.
*SSHKeysApi* | [**ssh_keys_ssh_key_id_delete**](docs/SSHKeysApi.md#ssh_keys_ssh_key_id_delete) | **DELETE** /ssh-keys/{sshKeyId} | Delete SSH Key.
*SSHKeysApi* | [**ssh_keys_ssh_key_id_get**](docs/SSHKeysApi.md#ssh_keys_ssh_key_id_get) | **GET** /ssh-keys/{sshKeyId} | Get SSH Key.
*SSHKeysApi* | [**ssh_keys_ssh_key_id_put**](docs/SSHKeysApi.md#ssh_keys_ssh_key_id_put) | **PUT** /ssh-keys/{sshKeyId} | Edit SSH Key.
*ServersApi* | [**delete_private_network**](docs/ServersApi.md#delete_private_network) | **DELETE** /servers/{serverId}/network-configuration/private-network-configuration/private-networks/{privateNetworkId} | Removes the server from private network.
*ServersApi* | [**servers_get**](docs/ServersApi.md#servers_get) | **GET** /servers | List servers.
*ServersApi* | [**servers_post**](docs/ServersApi.md#servers_post) | **POST** /servers | Create new server.
*ServersApi* | [**servers_server_id_actions_deprovision_post**](docs/ServersApi.md#servers_server_id_actions_deprovision_post) | **POST** /servers/{serverId}/actions/deprovision | Deprovision a server.
*ServersApi* | [**servers_server_id_actions_power_off_post**](docs/ServersApi.md#servers_server_id_actions_power_off_post) | **POST** /servers/{serverId}/actions/power-off | Power off server.
*ServersApi* | [**servers_server_id_actions_power_on_post**](docs/ServersApi.md#servers_server_id_actions_power_on_post) | **POST** /servers/{serverId}/actions/power-on | Power on server.
*ServersApi* | [**servers_server_id_actions_reboot_post**](docs/ServersApi.md#servers_server_id_actions_reboot_post) | **POST** /servers/{serverId}/actions/reboot | Reboot server.
*ServersApi* | [**servers_server_id_actions_reserve_post**](docs/ServersApi.md#servers_server_id_actions_reserve_post) | **POST** /servers/{serverId}/actions/reserve | Reserve server.
*ServersApi* | [**servers_server_id_actions_reset_post**](docs/ServersApi.md#servers_server_id_actions_reset_post) | **POST** /servers/{serverId}/actions/reset | Reset server.
*ServersApi* | [**servers_server_id_actions_shutdown_post**](docs/ServersApi.md#servers_server_id_actions_shutdown_post) | **POST** /servers/{serverId}/actions/shutdown | Shutdown server.
*ServersApi* | [**servers_server_id_delete**](docs/ServersApi.md#servers_server_id_delete) | **DELETE** /servers/{serverId} | Delete server.
*ServersApi* | [**servers_server_id_get**](docs/ServersApi.md#servers_server_id_get) | **GET** /servers/{serverId} | Get server.
*ServersApi* | [**servers_server_id_ip_blocks_ip_block_id_delete**](docs/ServersApi.md#servers_server_id_ip_blocks_ip_block_id_delete) | **DELETE** /servers/{serverId}/network-configuration/ip-block-configurations/ip-blocks/{ipBlockId} | Unassign IP Block from Server.
*ServersApi* | [**servers_server_id_ip_blocks_post**](docs/ServersApi.md#servers_server_id_ip_blocks_post) | **POST** /servers/{serverId}/network-configuration/ip-block-configurations/ip-blocks | Assign IP Block to Server.
*ServersApi* | [**servers_server_id_patch**](docs/ServersApi.md#servers_server_id_patch) | **PATCH** /servers/{serverId} | Patch a Server.
*ServersApi* | [**servers_server_id_private_networks_post**](docs/ServersApi.md#servers_server_id_private_networks_post) | **POST** /servers/{serverId}/network-configuration/private-network-configuration/private-networks | Adds the server to a private network.
*ServersApi* | [**servers_server_id_public_networks_delete**](docs/ServersApi.md#servers_server_id_public_networks_delete) | **DELETE** /servers/{serverId}/network-configuration/public-network-configuration/public-networks/{publicNetworkId} | Removes the server from the Public Network
*ServersApi* | [**servers_server_id_public_networks_post**](docs/ServersApi.md#servers_server_id_public_networks_post) | **POST** /servers/{serverId}/network-configuration/public-network-configuration/public-networks | Adds the server to a Public Network.
*ServersApi* | [**servers_server_id_tags_put**](docs/ServersApi.md#servers_server_id_tags_put) | **PUT** /servers/{serverId}/tags | Overwrite tags assigned for Server.


## Documentation For Models

 - [ActionResult](docs/ActionResult.md)
 - [DeleteResult](docs/DeleteResult.md)
 - [DeleteSshKeyResult](docs/DeleteSshKeyResult.md)
 - [Error](docs/Error.md)
 - [IpBlocksConfiguration](docs/IpBlocksConfiguration.md)
 - [NetworkConfiguration](docs/NetworkConfiguration.md)
 - [OsConfiguration](docs/OsConfiguration.md)
 - [OsConfigurationMap](docs/OsConfigurationMap.md)
 - [OsConfigurationMapEsxi](docs/OsConfigurationMapEsxi.md)
 - [OsConfigurationMapProxmox](docs/OsConfigurationMapProxmox.md)
 - [OsConfigurationWindows](docs/OsConfigurationWindows.md)
 - [PrivateNetworkConfiguration](docs/PrivateNetworkConfiguration.md)
 - [PublicNetworkConfiguration](docs/PublicNetworkConfiguration.md)
 - [Quota](docs/Quota.md)
 - [QuotaEditLimitRequest](docs/QuotaEditLimitRequest.md)
 - [QuotaEditLimitRequestDetails](docs/QuotaEditLimitRequestDetails.md)
 - [QuotaEditLimitRequestDetailsAllOf](docs/QuotaEditLimitRequestDetailsAllOf.md)
 - [RelinquishIpBlock](docs/RelinquishIpBlock.md)
 - [ResetResult](docs/ResetResult.md)
 - [Server](docs/Server.md)
 - [ServerCreate](docs/ServerCreate.md)
 - [ServerIpBlock](docs/ServerIpBlock.md)
 - [ServerPatch](docs/ServerPatch.md)
 - [ServerPrivateNetwork](docs/ServerPrivateNetwork.md)
 - [ServerPublicNetwork](docs/ServerPublicNetwork.md)
 - [ServerReserve](docs/ServerReserve.md)
 - [ServerReset](docs/ServerReset.md)
 - [SshKey](docs/SshKey.md)
 - [SshKeyCreate](docs/SshKeyCreate.md)
 - [SshKeyUpdate](docs/SshKeyUpdate.md)
 - [TagAssignment](docs/TagAssignment.md)
 - [TagAssignmentRequest](docs/TagAssignmentRequest.md)


## Documentation For Authorization


## OAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **bmc**: Grants full access to bmc-api.
 - **bmc.read**: Grants read only access to bmc-api.


## Author

support@phoenixnap.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in pnap_bmc_api.apis and pnap_bmc_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from pnap_bmc_api.api.default_api import DefaultApi`
- `from pnap_bmc_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import pnap_bmc_api
from pnap_bmc_api.apis import *
from pnap_bmc_api.models import *
```

