"""
s-curve-beta

Efficient Python implementation of the smoothest S-curve robot motion planner ever

This module is using interpolated beta function. For true function please import
scurvebetatrue.
"""
from __future__ import division # fix python2 1/2 = 0
from math import sqrt # Python standard math.sqrt is faster than np.sqrt
import numpy as np
__version__ = "0.1.0"
__author__ = 'Vladimir Grankovsky'
__credits__ = 'Hidoba Research'

# 801 points interpolation:
SCURVEPOINTSX = np.arange(-1,1.0025,0.0025)
SCURVEPOINTSY = np.array([0.,1.2830424500620552E-9,1.4480681986839272E-8,5.971046818098458E-8,1.630336142199873E-7,3.5514225765753693E-7,6.706190835426007E-7,1.1474345205653158E-6,1.826572895491374E-6,2.7517385105535475E-6,3.969115556168301E-6,5.527166453356269E-6,7.476458833033384E-6,9.86951457965235E-6,0.00001276067633099176,0.0000162059880915999,0.000020263087467720098,0.000024991107618110853,0.000030450587435393306,0.00003670338878114521,0.00004381261982538964,0.00005184256371659757,0.00006085861194404796,0.00007092720185813972,0.00008211575790084691,0.00009449263616423398,0.00010812707195045901,0.00012308913005210087,0.00013944965750872784,0.00015728023862621177,0.0001766531520718262,0.0001976413298802604,0.000220318318224888,0.00024475823982283984,0.00027103575785902834,0.0002992260413242631,0.0003294047316731996,0.000361647910718188,0.0003960320696813624,0.00043263407933546993,0.0004715311611701023,0.0005128008595247091,0.000556521014635103,0.0006027697365449947,0.0006516253798373728,0.0007031665191437608,0.0007574719253938267,0.0008146205427687625,0.000874691466326738,0.0009377639202683419,0.0010039172368148663,0.0010732308356717901,0.0011457842040537014,0.0012216568772456804,0.0013009284196816018,0.0013836784065173746,0.0014699864056799128,0.0015599319603753492,0.001653594572037731,0.0017510536837028745,0.0018523886637928366,0.0019576787902957915,0.002067003235328324,0.002180441050067483,0.0022980711500403816,0.0024199723007591323,0.002546223103691181,0.00267690198255488,0.002812087169929034,0.002951856694168087,0.003096288366614075,0.0032454597690962927,0.003399448241710734,0.0035583308708715955,0.003722184477627344,0.0038910856062343013,0.004065110512980807,0.004244335155255574,0.004428835180853796,0.004618685917515575,0.004813962362689828,0.005014739173519578,0.005221090657041794,0.005433090760598225,0.005650813062451021,0.005874330762599078,0.006103716673790727,0.006339043212727491,0.0065803823914561965,0.006827805808943543,0.0070813846428308125,0.007341189641363932,0.007607291115495685,0.007879758931156333,0.008158662501689229,0.008444070780448565,0.008736052253555227,0.00903467493280824,0.009340006348748764,0.009652113543873797,0.00997106306599621,0.010296920961749445,0.010629752770232814,0.0109696235167962,0.011316597706960918,0.011670739320474632,0.012032111805497403,0.012400778072917562,0.012776800490794216,0.013160240878925256,0.013551160503537163,0.013949620072096991,0.014355679728241866,0.014769399046826226,0.015190837029083692,0.01562005209790207,0.01605710209320993,0.016502044267472815,0.016954935281297434,0.017415831199141862,0.017884787485130782,0.018361858998973912,0.018847099991985694,0.019340564103205282,0.01984230435561546,0.020352373152458192,0.020870822273646283,0.02139770287226994,0.021933065471195612,0.02247695995975757,0.02302943559053916,0.023590540976244467,0.024160324086656915,0.024738832245685738,0.025326112128497558,0.025922209758733383,0.02652717050580805,0.027141039082293095,0.02776385954138033,0.028395675274426047,0.029036529008574286,0.029686462804458802,0.0303455180539815,0.03101373547816838,0.03169115512509979,0.032377816367915535,0.03307375790289385,0.033779017747602225,0.03449363323912147,0.03521764103233821,0.03595107709831047,0.03669397672270025,0.03744637450427507,0.03820830435347816,0.03897979949106367,0.03976089244679987,0.04055161505823618,0.04135199846953547,0.04216207313037035,0.042981868794881806,0.0438114145207012,0.04465073866803332,0.04549986889880059,0.04635883217584802,0.04722765476220736,0.04810636222042025,0.04899497941192055,0.049893530496473326,0.050802038931672566,0.051720527472492894,0.05264901817090051,0.0535875323755165,0.054536090731336806,0.055494713179505606,0.05646341895714235,0.057442226597222146,0.05843115392850856,0.05943021807553833,0.06043943545865721,0.06145882179410772,0.0624883920941659,0.06352816066732936,0.06457814111855381,0.06563834634953825,0.06670878855906004,0.06778947924335621,0.06888042919655268,0.06998164851114158,0.07109314657850263,0.07221493208947416,0.07334701303496566,0.07448939670661836,0.07564208969750968,0.07680509790290202,0.07797842652103404,0.07916208005395886,0.08035606230842052,0.08156037639677716,0.08277502473796355,0.08400000905849775,0.08523533039352688,0.08648098908791502,0.08773698479737252,0.08900331648962301,0.09027998244561308,0.09156698026076021,0.09286430684623875,0.09417195843030574,0.09548993055966543,0.0968182181008706,0.09815681524176306,0.09950571549294918,0.10086491168931466,0.10223439599157508,0.10361415988786077,0.10500419419534174,0.10640448906188404,0.10781503396774328,0.10923581772729446,0.11066682849079157,0.11210805374616833,0.1135594803208666,0.11502109438370223,0.11649288144676323,0.11797482636734019,0.11946691334988957,0.12096912594803216,0.1224814470665786,0.12400385896359156,0.12553634325247665,0.1270788809041043,0.12863145224896588,0.13019403697935655,0.13176661415159024,0.13334916218824583,0.1349416588804408,0.1365440813901358,0.1381564062524691,0.13977860937811898,0.14141066605569463,0.14305255095415637,0.1447042381252649,0.14636570100605534,0.14803691242134298,0.1497178445862532,0.1514084691087807,0.1531087569923747,0.15481867863855076,0.15653820384952927,0.15826730183090065,0.16000594119431544,0.16175408996020102,0.16351171556050342,0.16527878484145314,0.1670552640663595,0.16884111891842563,0.17063631450359007,0.17244081535339245,0.17425458542786387,0.1760775881184391,0.17790978625089449,0.17975114208830778,0.1816016173340428,0.18346117313475474,0.18532977008341994,0.1872073682223887,0.18909392704645667,0.19098940550596372,0.19289376200991054,0.19480695442909773,0.19672894009928832,0.19865967582438798,0.2005991178796503,0.20254722201489928,0.2045039434577745,0.20646923691699604,0.2084430565856501,0.2104253561444927,0.2124160887652765,0.21441520711409362,0.21642266335474125,0.21843840915210222,0.2204623956755501,0.22249457360236763,0.22453489312118696,0.22658330393544818,0.22863975526687363,0.230704195858964,0.23277657398050933,0.23485683742911773,0.2369449335347637,0.2390408091633523,0.24114441072029896,0.24325568415413001,0.24537457496009557,0.24750102818380276,0.24963498842486198,0.25177639984055267,0.25392520614950154,0.2560813506353796,0.25824477615061314,0.26041542512011073,0.26259323954500535,0.2647781610064117,0.26697013066919895,0.26916908928577654,0.27137497719989634,0.27358773435046957,0.27580730027539474,0.2780336141154043,0.28026661461792135,0.28250624014093184,0.2847524286568699,0.28700511775651716,0.2892642446529141,0.2915297461852857,0.29380155882297876,0.29607961866941357,0.2983638614660462,0.30065422259634456,0.30295063708977676,0.30525303962580974,0.30756136453792243,0.3098755458176291,0.312195517118514,0.3145212117602779,0.316852562732797,0.3191895027001904,0.32153196400490136,0.32387987867178725,0.3262331784122209,0.3285917946282026,0.3309556584164819,0.33332470057269004,0.33569885159548274,0.3380780416906912,0.3404622007754846,0.34285125848254117,0.3452451441642293,0.347643786896797,0.3500471154845709,0.352455058464165,0.35486754410869625,0.35728450043201043,0.3597058551929161,0.3621315358994265,0.36456146981300985,0.3669955839528478,0.36943380510010104,0.3718760598021844,0.3743222743770468,0.3767723749174614,0.3792262872953207,0.3816839371659409,0.3841452499723712,0.38661015094971146,0.38907856512943556,0.3915504173437223,0.39402563222979126,0.39650413423424663,0.3989858476174255,0.4014706964577532,0.403958604656104,0.40644949594016766,0.40894329386882133,0.4114399218365068,0.4139393030776133,0.41644136067086457,0.41894601754371275,0.4214531964767339,0.42396282010803177,0.4264748109376432,0.42898909133194985,0.43150558352809254,0.4340242096383913,0.4365448916547676,0.43906755145317256,0.4415921107980161,0.4441184913466024,0.44664661465356637,0.4491764021753151,0.4517077752744713,0.4542406552243203,0.45677496321325906,0.4593106203492494,0.46184754766427194,0.46438566611878335,0.46692489660617614,0.4694651599572396,0.47200637694462394,0.4745484682873046,0.4770913546550504,0.47963495667289086,0.482179194925587,0.4847239899621016,0.48726926230007256,0.4898149324302851,0.49236092082114674,0.4949071479231611,0.4974535341734044,0.5,0.5025464658265957,0.5050928520768391,0.5076390791788534,0.5101850675697149,0.5127307376999274,0.5152760100378986,0.5178208050744132,0.5203650433271091,0.5229086453449495,0.5254515317126953,0.5279936230553762,0.5305348400427604,0.5330751033938239,0.5356143338812166,0.5381524523357282,0.5406893796507506,0.543225036786741,0.5457593447756798,0.5482922247255289,0.550823597824685,0.5533533853464336,0.5558815086533976,0.558407889201984,0.5609324485468276,0.5634551083452324,0.5659757903616087,0.5684944164719076,0.5710109086680503,0.5735251890623568,0.5760371798919682,0.5785468035232663,0.5810539824562874,0.5835586393291354,0.5860606969223867,0.5885600781634933,0.5910567061311788,0.5935505040598323,0.596041395343896,0.5985293035422468,0.6010141523825745,0.6034958657657533,0.6059743677702087,0.6084495826562777,0.6109214348705646,0.6133898490502887,0.6158547500276288,0.6183160628340592,0.6207737127046795,0.6232276250825388,0.6256777256229532,0.6281239401978156,0.6305661948998991,0.6330044160471523,0.6354385301869901,0.6378684641005735,0.640294144807084,0.6427154995679897,0.6451324558913037,0.647544941535835,0.6499528845154292,0.6523562131032032,0.6547548558357708,0.6571487415174588,0.6595377992245153,0.6619219583093089,0.6643011484045173,0.66667529942731,0.6690443415835181,0.6714082053717975,0.6737668215877792,0.6761201213282128,0.6784680359950986,0.6808104972998097,0.6831474372672032,0.6854787882397221,0.687804482881486,0.6901244541823709,0.6924386354620775,0.6947469603741903,0.6970493629102232,0.6993457774036556,0.7016361385339538,0.7039203813305864,0.7061984411770212,0.7084702538147144,0.7107357553470859,0.7129948822434828,0.7152475713431301,0.717493759859068,0.7197333853820788,0.7219663858845957,0.7241926997246053,0.7264122656495304,0.7286250228001038,0.7308309107142236,0.733029869330801,0.7352218389935883,0.737406760454995,0.7395845748798894,0.7417552238493869,0.7439186493646204,0.7460747938504984,0.7482236001594473,0.750365011575138,0.7524989718161972,0.7546254250399045,0.7567443158458702,0.7588555892797011,0.7609591908366478,0.7630550664652364,0.7651431625708826,0.7672234260194907,0.769295804141036,0.7713602447331265,0.7734166960645521,0.775465106878813,0.7775054263976324,0.7795376043244497,0.7815615908478977,0.7835773366452589,0.7855847928859063,0.7875839112347235,0.7895746438555074,0.79155694341435,0.793530763083004,0.7954960565422255,0.7974527779851008,0.7994008821203498,0.8013403241756121,0.8032710599007117,0.8051930455709022,0.8071062379900895,0.8090105944940362,0.8109060729535433,0.8127926317776115,0.81467022991658,0.8165388268652453,0.8183983826659572,0.8202488579116922,0.8220902137491056,0.8239224118815609,0.8257454145721361,0.8275591846466073,0.82936368549641,0.8311588810815744,0.8329447359336405,0.8347212151585468,0.8364882844394969,0.8382459100397991,0.8399940588056846,0.8417326981690993,0.8434617961504709,0.8451813213614494,0.8468912430076253,0.8485915308912193,0.850282155413747,0.8519630875786571,0.8536342989939447,0.8552957618747351,0.8569474490458437,0.8585893339443056,0.860221390621881,0.8618435937475308,0.8634559186098643,0.8650583411195594,0.8666508378117541,0.8682333858484097,0.8698059630206434,0.8713685477510342,0.8729211190958955,0.8744636567475234,0.8759961410364084,0.8775185529334215,0.8790308740519681,0.8805330866501104,0.8820251736326599,0.8835071185532368,0.8849789056162976,0.8864405196791334,0.8878919462538317,0.8893331715092083,0.8907641822727057,0.8921849660322567,0.893595510938116,0.8949958058046583,0.8963858401121394,0.897765604008425,0.8991350883106853,0.9004942845070509,0.9018431847582371,0.9031817818991295,0.9045100694403345,0.9058280415696942,0.9071356931537615,0.9084330197392398,0.9097200175543869,0.910996683510377,0.9122630152026276,0.9135190109120848,0.9147646696064731,0.9159999909415022,0.9172249752620365,0.9184396236032228,0.9196439376915795,0.9208379199460411,0.922021573478966,0.923194902097098,0.9243579103024904,0.9255106032933816,0.9266529869650346,0.9277850679105258,0.9289068534214974,0.9300183514888585,0.9311195708034473,0.932210520756644,0.93329121144094,0.9343616536504618,0.9354218588814462,0.9364718393326706,0.9375116079058341,0.9385411782058923,0.9395605645413427,0.9405697819244618,0.9415688460714915,0.9425577734027779,0.9435365810428576,0.9445052868204944,0.9454639092686632,0.9464124676244835,0.9473509818290995,0.9482794725275071,0.9491979610683274,0.9501064695035266,0.9510050205880795,0.9518936377795798,0.9527723452377926,0.953641167824152,0.9545001311011994,0.9553492613319667,0.9561885854792989,0.9570181312051182,0.9578379268696297,0.9586480015304646,0.9594483849417639,0.9602391075532002,0.9610202005089363,0.9617916956465218,0.962553625495725,0.9633060232772997,0.9640489229016895,0.9647823589676618,0.9655063667608785,0.9662209822523977,0.9669262420971061,0.9676221836320844,0.9683088448749002,0.9689862645218317,0.9696544819460184,0.9703135371955411,0.9709634709914257,0.9716043247255739,0.9722361404586197,0.972858960917707,0.973472829494192,0.9740777902412666,0.9746738878715024,0.9752611677543143,0.9758396759133431,0.9764094590237555,0.9769705644094608,0.9775230400402424,0.9780669345288044,0.9786022971277302,0.9791291777263538,0.9796476268475418,0.9801576956443845,0.9806594358967947,0.9811529000080144,0.9816381410010261,0.9821152125148692,0.9825841688008581,0.9830450647187026,0.9834979557325272,0.9839428979067901,0.984379947902098,0.9848091629709164,0.9852306009531737,0.9856443202717582,0.986050379927903,0.9864488394964628,0.9868397591210747,0.9872231995092058,0.9875992219270824,0.9879678881945027,0.9883292606795253,0.9886834022930391,0.9890303764832038,0.9893702472297672,0.9897030790382506,0.9900289369340038,0.9903478864561261,0.9906599936512512,0.9909653250671917,0.9912639477464448,0.9915559292195515,0.9918413374983108,0.9921202410688437,0.9923927088845044,0.992658810358636,0.9929186153571692,0.9931721941910565,0.9934196176085438,0.9936609567872725,0.9938962833262093,0.994125669237401,0.9943491869375489,0.9945669092394018,0.9947789093429582,0.9949852608264804,0.9951860376373102,0.9953813140824844,0.9955711648191462,0.9957556648447444,0.9959348894870192,0.9961089143937657,0.9962778155223726,0.9964416691291285,0.9966005517582892,0.9967545402309037,0.9969037116333859,0.9970481433058319,0.9971879128300709,0.9973230980174451,0.9974537768963088,0.9975800276992409,0.9977019288499596,0.9978195589499326,0.9979329967646717,0.9980423212097043,0.9981476113362071,0.9982489463162971,0.9983464054279623,0.9984400680396246,0.99853001359432,0.9986163215934827,0.9986990715803183,0.9987783431227544,0.9988542157959464,0.9989267691643282,0.9989960827631852,0.9990622360797317,0.9991253085336733,0.9991853794572312,0.9992425280746062,0.9992968334808563,0.9993483746201626,0.9993972302634551,0.9994434789853649,0.9994871991404752,0.99952846883883,0.9995673659206645,0.9996039679303186,0.9996383520892818,0.9996705952683268,0.9997007739586757,0.999728964242141,0.9997552417601772,0.9997796816817751,0.9998023586701197,0.9998233468479282,0.9998427197613737,0.9998605503424913,0.9998769108699479,0.9998918729280495,0.9999055073638358,0.9999178842420992,0.9999290727981418,0.999939141388056,0.9999481574362834,0.9999561873801746,0.9999632966112189,0.9999695494125647,0.9999750088923819,0.9999797369125323,0.9999837940119084,0.9999872393236691,0.9999901304854204,0.999992523541167,0.9999944728335466,0.9999960308844438,0.9999972482614894,0.9999981734271045,0.9999988525654795,0.9999993293809164,0.9999996448577424,0.9999998369663858,0.9999999402895319,0.999999985519318,0.9999999987169575,1.])

def motionTime(robotVmax, robotAmax, motionRange):
    return max(2.572148274314975138567 * sqrt(motionRange / robotAmax),
               2.037183271576260297842 * motionRange / robotVmax)

def f_interpolated(t):
    return np.interp(t, SCURVEPOINTSX, SCURVEPOINTSY)
    # NumPy automatically handles t outside of the initial boundaries (t<0 and t>1).

def sCurve(t, motionTime, x0, x1):
    if(isinstance(t, list)):
        t = np.array(t)
    return x0 + (x1 - x0) * f_interpolated(2.0 * t / motionTime - 1)
