"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTeam = exports.toJson_Member = exports.toJson_CfnTeamProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("@aws-cdk/core");
/**
 * Converts an object of type 'CfnTeamProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnTeamProps(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Description': obj.description,
        'Members': (_b = obj.members) === null || _b === void 0 ? void 0 : _b.map(y => toJson_Member(y)),
        'OpsgenieApiKey': obj.opsgenieApiKey,
        'OpsgenieApiEndpoint': obj.opsgenieApiEndpoint,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnTeamProps = toJson_CfnTeamProps;
/**
 * Converts an object of type 'Member' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Member(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'UserId': obj.userId,
        'Role': obj.role,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Member = toJson_Member;
/**
 * A CloudFormation `Atlassian::Opsgenie::Team`.
 *
 * @external
 * @cloudformationResource Atlassian::Opsgenie::Team
 * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
 */
class CfnTeam extends cdk.CfnResource {
    /**
     * Create a new `Atlassian::Opsgenie::Team`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTeam.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnTeamProps(props) });
        this.props = props;
        this.attrTeamId = cdk.Token.asString(this.getAtt('TeamId'));
    }
}
exports.CfnTeam = CfnTeam;
_a = JSII_RTTI_SYMBOL_1;
CfnTeam[_a] = { fqn: "@cdk-cloudformation/atlassian-opsgenie-team.CfnTeam", version: "1.0.1-alpha.3" };
/**
 * The CloudFormation resource type name for this resource class.
 *
 * @external
 */
CfnTeam.CFN_RESOURCE_TYPE_NAME = "Atlassian::Opsgenie::Team";
//# sourceMappingURL=data:application/json;base64,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