/**
 * vis-data
 * http://visjs.org/
 *
 * Manage unstructured data using DataSet. Add, update, and remove data, and listen for changes in the data.
 *
 * @version 6.5.1
 * @date    2020-03-27T15:50:07.060Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("uuid"),require("vis-util/esnext"),require("moment")):"function"==typeof define&&define.amd?define(["exports","uuid","vis-util/esnext","moment"],e):e((t=t||self).vis=t.vis||{},t.uuidv4,t.vis,t.moment)}(this,(function(t,e,s,r){"use strict";r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r;class i{constructor(t,e,s){this._source=t,this._transformers=e,this._target=s,this._listeners={add:this._add.bind(this),remove:this._remove.bind(this),update:this._update.bind(this)}}all(){return this._target.update(this._transformItems(this._source.get())),this}start(){return this._source.on("add",this._listeners.add),this._source.on("remove",this._listeners.remove),this._source.on("update",this._listeners.update),this}stop(){return this._source.off("add",this._listeners.add),this._source.off("remove",this._listeners.remove),this._source.off("update",this._listeners.update),this}_transformItems(t){return this._transformers.reduce((t,e)=>e(t),t)}_add(t,e){null!=e&&this._target.add(this._transformItems(this._source.get(e.items)))}_update(t,e){null!=e&&this._target.update(this._transformItems(this._source.get(e.items)))}_remove(t,e){null!=e&&this._target.remove(this._transformItems(e.oldData))}}class n{constructor(t){this._source=t,this._transformers=[]}filter(t){return this._transformers.push(e=>e.filter(t)),this}map(t){return this._transformers.push(e=>e.map(t)),this}flatMap(t){return this._transformers.push(e=>e.flatMap(t)),this}to(t){return new i(this._source,this._transformers,t)}}const o=/^\/?Date\((-?\d+)/i;function a(t){return r.isMoment(t)}function h(t,e){let i;if(void 0!==t){if(null===t)return null;if(!e)return t;if("string"!=typeof e&&!(e instanceof String))throw new Error("Type must be a string");switch(e){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return s.isString(t)&&!isNaN(Date.parse(t))?r(t).valueOf():Number(t.valueOf());case"string":case"String":return String(t);case"Date":if(s.isNumber(t))return new Date(t);if(t instanceof Date)return new Date(t.valueOf());if(a(t))return new Date(t.valueOf());if(s.isString(t))return i=o.exec(t),i?new Date(Number(i[1])):r(new Date(t)).toDate();throw new Error("Cannot convert object of type "+s.getType(t)+" to type Date");case"Moment":if(s.isNumber(t))return r(t);if(t instanceof Date)return r(t.valueOf());if(a(t))return r(t);if(s.isString(t))return i=o.exec(t),r(i?Number(i[1]):t);throw new Error("Cannot convert object of type "+s.getType(t)+" to type Date");case"ISODate":if(s.isNumber(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(a(t))return t.toDate().toISOString();if(s.isString(t))return i=o.exec(t),i?new Date(Number(i[1])).toISOString():r(t).format();throw new Error("Cannot convert object of type "+s.getType(t)+" to type ISODate");case"ASPDate":if(s.isNumber(t))return"/Date("+t+")/";if(t instanceof Date||a(t))return"/Date("+t.valueOf()+")/";if(s.isString(t)){let e;return i=o.exec(t),e=i?new Date(Number(i[1])).valueOf():new Date(t).valueOf(),"/Date("+e+")/"}throw new Error("Cannot convert object of type "+s.getType(t)+" to type ASPDate");default:throw new Error(`Unknown type ${e}`)}}}function l(t){return"string"==typeof t||"number"==typeof t}class u{constructor(t){this._queue=[],this._timeout=null,this._extended=null,this.delay=null,this.max=1/0,this.setOptions(t)}setOptions(t){t&&void 0!==t.delay&&(this.delay=t.delay),t&&void 0!==t.max&&(this.max=t.max),this._flushIfNeeded()}static extend(t,e){const s=new u(e);if(void 0!==t.flush)throw new Error("Target object already has a property flush");t.flush=()=>{s.flush()};const r=[{name:"flush",original:void 0}];if(e&&e.replace)for(let i=0;i<e.replace.length;i++){const n=e.replace[i];r.push({name:n,original:t[n]}),s.replace(t,n)}return s._extended={object:t,methods:r},s}destroy(){if(this.flush(),this._extended){const t=this._extended.object,e=this._extended.methods;for(let s=0;s<e.length;s++){const r=e[s];r.original?t[r.name]=r.original:delete t[r.name]}this._extended=null}}replace(t,e){const s=this,r=t[e];if(!r)throw new Error("Method "+e+" undefined");t[e]=function(...t){s.queue({args:t,fn:r,context:this})}}queue(t){"function"==typeof t?this._queue.push({fn:t}):this._queue.push(t),this._flushIfNeeded()}_flushIfNeeded(){this._queue.length>this.max&&this.flush(),null!=this._timeout&&(clearTimeout(this._timeout),this._timeout=null),this.queue.length>0&&"number"==typeof this.delay&&(this._timeout=setTimeout(()=>{this.flush()},this.delay))}flush(){this._queue.splice(0).forEach(t=>{t.fn.apply(t.context||t.fn,t.args||[])})}}class d{constructor(){this._subscribers={"*":[],add:[],remove:[],update:[]},this.subscribe=d.prototype.on,this.unsubscribe=d.prototype.off}_trigger(t,e,s){if("*"===t)throw new Error("Cannot trigger event *");[...this._subscribers[t],...this._subscribers["*"]].forEach(r=>{r(t,e,null!=s?s:null)})}on(t,e){"function"==typeof e&&this._subscribers[t].push(e)}off(t,e){this._subscribers[t]=this._subscribers[t].filter(t=>t!==e)}}class f{constructor(t){this._pairs=t}*[Symbol.iterator](){for(const[t,e]of this._pairs)yield[t,e]}*entries(){for(const[t,e]of this._pairs)yield[t,e]}*keys(){for(const[t]of this._pairs)yield t}*values(){for(const[,t]of this._pairs)yield t}toIdArray(){return[...this._pairs].map(t=>t[0])}toItemArray(){return[...this._pairs].map(t=>t[1])}toEntryArray(){return[...this._pairs]}toObjectMap(){const t=Object.create(null);for(const[e,s]of this._pairs)t[e]=s;return t}toMap(){return new Map(this._pairs)}toIdSet(){return new Set(this.toIdArray())}toItemSet(){return new Set(this.toItemArray())}cache(){return new f([...this._pairs])}distinct(t){const e=new Set;for(const[s,r]of this._pairs)e.add(t(r,s));return e}filter(t){const e=this._pairs;return new f({*[Symbol.iterator](){for(const[s,r]of e)t(r,s)&&(yield[s,r])}})}forEach(t){for(const[e,s]of this._pairs)t(s,e)}map(t){const e=this._pairs;return new f({*[Symbol.iterator](){for(const[s,r]of e)yield[s,t(r,s)]}})}max(t){const e=this._pairs[Symbol.iterator]();let s=e.next();if(s.done)return null;let r=s.value[1],i=t(s.value[1],s.value[0]);for(;!(s=e.next()).done;){const[e,n]=s.value,o=t(n,e);o>i&&(i=o,r=n)}return r}min(t){const e=this._pairs[Symbol.iterator]();let s=e.next();if(s.done)return null;let r=s.value[1],i=t(s.value[1],s.value[0]);for(;!(s=e.next()).done;){const[e,n]=s.value,o=t(n,e);o<i&&(i=o,r=n)}return r}reduce(t,e){for(const[s,r]of this._pairs)e=t(e,r,s);return e}sort(t){return new f({[Symbol.iterator]:()=>[...this._pairs].sort(([e,s],[r,i])=>t(s,i,e,r))[Symbol.iterator]()})}}const _=()=>{console.warn("Type coercion has been deprecated. Please, use data pipes instead. See https://visjs.github.io/vis-data/data/datapipe.html#TypeCoercion for more details with working migration example.")};class c extends d{constructor(t,e){if(super(),t&&!Array.isArray(t)&&(e=t,t=[]),this._options=e||{},this._data=new Map,this.length=0,this._idProp=this._options.fieldId||"id",this._type={},this._options.type){_();const t=Object.keys(this._options.type);for(let e=0,s=t.length;e<s;e++){const s=t[e],r=this._options.type[s];this._type[s]="Date"==r||"ISODate"==r||"ASPDate"==r?"Date":r}}t&&t.length&&this.add(t),this.setOptions(e)}setOptions(t){t&&void 0!==t.queue&&(!1===t.queue?this._queue&&(this._queue.destroy(),delete this._queue):(this._queue||(this._queue=u.extend(this,{replace:["add","update","remove"]})),t.queue&&"object"==typeof t.queue&&this._queue.setOptions(t.queue)))}add(t,e){const s=[];let r;if(Array.isArray(t)){if(t.map(t=>t[this._idProp]).some(t=>this._data.has(t)))throw new Error("A duplicate id was found in the parameter array.");for(let e=0,i=t.length;e<i;e++)r=this._addItem(t[e]),s.push(r)}else{if(!t||"object"!=typeof t)throw new Error("Unknown dataType");r=this._addItem(t),s.push(r)}return s.length&&this._trigger("add",{items:s},e),s}update(t,e){const s=[],r=[],i=[],n=[],o=this._idProp,a=t=>{const e=t[o];if(null!=e&&this._data.has(e)){const s=t,o=Object.assign({},this._data.get(e)),a=this._updateItem(s);r.push(a),n.push(s),i.push(o)}else{const e=this._addItem(t);s.push(e)}};if(Array.isArray(t))for(let e=0,s=t.length;e<s;e++)t[e]&&"object"==typeof t[e]?a(t[e]):console.warn("Ignoring input item, which is not an object at index "+e);else{if(!t||"object"!=typeof t)throw new Error("Unknown dataType");a(t)}if(s.length&&this._trigger("add",{items:s},e),r.length){const t={items:r,oldData:i,data:n};this._trigger("update",t,e)}return s.concat(r)}updateOnly(t,e){Array.isArray(t)||(t=[t]);const r=t.map(t=>{const e=this._data.get(t[this._idProp]);if(null==e)throw new Error("Updating non-existent items is not allowed.");return{oldData:e,update:t}}).map(({oldData:t,update:e})=>{const r=t[this._idProp],i=s.deepExtend(s.deepExtend({},t),e);return this._data.set(r,i),{id:r,oldData:t,updatedData:i}});if(r.length){const t={items:r.map(t=>t.id),oldData:r.map(t=>t.oldData),data:r.map(t=>t.updatedData)};return this._trigger("update",t,e),t.items}return[]}get(t,e){let s=void 0,r=void 0,i=void 0;l(t)?(s=t,i=e):Array.isArray(t)?(r=t,i=e):i=t;const n=i&&"Object"===i.returnType?"Object":"Array",o=i&&i.type||this._options.type,a=i&&i.filter,h=[];let u=null,d=null,f=null;if(null!=s)u=this._getItem(s,o),u&&a&&!a(u)&&(u=null);else if(null!=r)for(let t=0,e=r.length;t<e;t++)u=this._getItem(r[t],o),null==u||a&&!a(u)||h.push(u);else{d=[...this._data.keys()];for(let t=0,e=d.length;t<e;t++)f=d[t],u=this._getItem(f,o),null==u||a&&!a(u)||h.push(u)}if(i&&i.order&&null==s&&this._sort(h,i.order),i&&i.fields){const t=i.fields;if(null!=s&&null!=u)u=this._filterFields(u,t);else for(let e=0,s=h.length;e<s;e++)h[e]=this._filterFields(h[e],t)}if("Object"==n){const t={};for(let e=0,s=h.length;e<s;e++){const s=h[e];t[s[this._idProp]]=s}return t}return null!=s?u:h}getIds(t){const e=this._data,s=t&&t.filter,r=t&&t.order,i=t&&t.type||this._options.type,n=[...e.keys()],o=[];let a,h;if(s)if(r){h=[];for(let t=0,e=n.length;t<e;t++){const e=n[t];a=this._getItem(e,i),s(a)&&h.push(a)}this._sort(h,r);for(let t=0,e=h.length;t<e;t++)o.push(h[t][this._idProp])}else for(let t=0,e=n.length;t<e;t++){const e=n[t];a=this._getItem(e,i),s(a)&&o.push(a[this._idProp])}else if(r){h=[];for(let t=0,s=n.length;t<s;t++){const s=n[t];h.push(e.get(s))}this._sort(h,r);for(let t=0,e=h.length;t<e;t++)o.push(h[t][this._idProp])}else for(let t=0,s=n.length;t<s;t++){const s=n[t];a=e.get(s),o.push(a[this._idProp])}return o}getDataSet(){return this}forEach(t,e){const s=e&&e.filter,r=e&&e.type||this._options.type,i=[...this._data.keys()];if(e&&e.order){const s=this.get(e);for(let e=0,r=s.length;e<r;e++){const r=s[e];t(r,r[this._idProp])}}else for(let e=0,n=i.length;e<n;e++){const n=i[e],o=this._getItem(n,r);s&&!s(o)||t(o,n)}}map(t,e){const s=e&&e.filter,r=e&&e.type||this._options.type,i=[],n=[...this._data.keys()];for(let e=0,o=n.length;e<o;e++){const o=n[e],a=this._getItem(o,r);s&&!s(a)||i.push(t(a,o))}return e&&e.order&&this._sort(i,e.order),i}_filterFields(t,e){return t?(Array.isArray(e)?e:Object.keys(e)).reduce((e,s)=>(e[s]=t[s],e),{}):t}_sort(t,e){if("string"==typeof e){const s=e;t.sort((t,e)=>{const r=t[s],i=e[s];return r>i?1:r<i?-1:0})}else{if("function"!=typeof e)throw new TypeError("Order must be a function or a string");t.sort(e)}}remove(t,e){const s=[],r=[],i=Array.isArray(t)?t:[t];for(let t=0,e=i.length;t<e;t++){const e=this._remove(i[t]);if(e){const t=e[this._idProp];null!=t&&(s.push(t),r.push(e))}}return s.length&&this._trigger("remove",{items:s,oldData:r},e),s}_remove(t){let e;if(l(t)?e=t:t&&"object"==typeof t&&(e=t[this._idProp]),null!=e&&this._data.has(e)){const t=this._data.get(e)||null;return this._data.delete(e),--this.length,t}return null}clear(t){const e=[...this._data.keys()],s=[];for(let t=0,r=e.length;t<r;t++)s.push(this._data.get(e[t]));return this._data.clear(),this.length=0,this._trigger("remove",{items:e,oldData:s},t),e}max(t){let e=null,s=null;for(const r of this._data.values()){const i=r[t];"number"==typeof i&&(null==s||i>s)&&(e=r,s=i)}return e||null}min(t){let e=null,s=null;for(const r of this._data.values()){const i=r[t];"number"==typeof i&&(null==s||i<s)&&(e=r,s=i)}return e||null}distinct(t){const e=this._data,s=[...e.keys()],r=[],i=this._options.type&&this._options.type[t]||null;let n=0;for(let i=0,o=s.length;i<o;i++){const o=s[i],a=e.get(o)[t];let h=!1;for(let t=0;t<n;t++)if(r[t]==a){h=!0;break}h||void 0===a||(r[n]=a,n++)}if(i)for(let t=0,e=r.length;t<e;t++)r[t]=h(r[t],i);return r}_addItem(t){let s=t[this._idProp];if(null!=s){if(this._data.has(s))throw new Error("Cannot add item: item with id "+s+" already exists")}else s=e.v4(),t[this._idProp]=s;const r={},i=Object.keys(t);for(let e=0,s=i.length;e<s;e++){const s=i[e],n=this._type[s];r[s]=h(t[s],n)}return this._data.set(s,r),++this.length,s}_getItem(t,e){const s=this._data.get(t);if(!s)return null;let r;const i=Object.keys(s);if(e){_(),r={};for(let t=0,n=i.length;t<n;t++){const n=i[t],o=s[n];r[n]=h(o,e[n])}}else r={...s};return null==r[this._idProp]&&(r[this._idProp]=s.id),r}_updateItem(t){const e=t[this._idProp];if(null==e)throw new Error("Cannot update item: item has no id (item: "+JSON.stringify(t)+")");const s=this._data.get(e);if(!s)throw new Error("Cannot update item: no item with id "+e+" found");const r=Object.keys(t);for(let e=0,i=r.length;e<i;e++){const i=r[e],n=this._type[i];s[i]=h(t[i],n)}return e}stream(t){if(t){const e=this._data;return new f({*[Symbol.iterator](){for(const s of t){const t=e.get(s);null!=t&&(yield[s,t])}}})}return new f({[Symbol.iterator]:this._data.entries.bind(this._data)})}}t.DataSet=c,t.DataStream=f,t.DataView=class extends d{constructor(t,e){super(),this.length=0,this._ids=new Set,this._options=e||{},this._listener=this._onEvent.bind(this),this.setData(t)}setData(t){if(this._data){this._data.off&&this._data.off("*",this._listener);const t=this._data.getIds({filter:this._options.filter}),e=this._data.get(t);this._ids.clear(),this.length=0,this._trigger("remove",{items:t,oldData:e})}if(null!=t){this._data=t;const e=this._data.getIds({filter:this._options.filter});for(let t=0,s=e.length;t<s;t++){const s=e[t];this._ids.add(s)}this.length=e.length,this._trigger("add",{items:e})}else this._data=new c;this._data.on&&this._data.on("*",this._listener)}refresh(){const t=this._data.getIds({filter:this._options.filter}),e=[...this._ids],s={},r=[],i=[],n=[];for(let e=0,i=t.length;e<i;e++){const i=t[e];s[i]=!0,this._ids.has(i)||(r.push(i),this._ids.add(i))}for(let t=0,r=e.length;t<r;t++){const r=e[t],o=this._data.get(r);null==o?console.error("If you see this, report it please."):s[r]||(i.push(r),n.push(o),this._ids.delete(r))}this.length+=r.length-i.length,r.length&&this._trigger("add",{items:r}),i.length&&this._trigger("remove",{items:i,oldData:n})}get(t,e){if(null==this._data)return null;let s,r=null;l(t)||Array.isArray(t)?(r=t,s=e):s=t;const i=Object.assign({},this._options,s),n=this._options.filter,o=s&&s.filter;return n&&o&&(i.filter=t=>n(t)&&o(t)),null==r?this._data.get(i):this._data.get(r,i)}getIds(t){if(this._data.length){const e=this._options.filter,s=null!=t?t.filter:null;let r;return r=s?e?t=>e(t)&&s(t):s:e,this._data.getIds({filter:r,order:t&&t.order})}return[]}forEach(t,e){if(this._data){const s=this._options.filter,r=e&&e.filter;let i;i=r?s?function(t){return s(t)&&r(t)}:r:s,this._data.forEach(t,{filter:i,order:e&&e.order})}}map(t,e){if(this._data){const s=this._options.filter,r=e&&e.filter;let i;return i=r?s?t=>s(t)&&r(t):r:s,this._data.map(t,{filter:i,order:e&&e.order})}return[]}getDataSet(){return this._data.getDataSet()}stream(t){return this._data.stream(t||{[Symbol.iterator]:this._ids.keys.bind(this._ids)})}dispose(){var t;(null===(t=this._data)||void 0===t?void 0:t.off)&&this._data.off("*",this._listener);const e="This data view has already been disposed of.";Object.defineProperty(this,"_data",{get:()=>{throw new Error(e)},set:()=>{throw new Error(e)},configurable:!1})}_onEvent(t,e,s){if(!e||!e.items||!this._data)return;const r=e.items,i=[],n=[],o=[],a=[],h=[],l=[];switch(t){case"add":for(let t=0,e=r.length;t<e;t++){const e=r[t];this.get(e)&&(this._ids.add(e),i.push(e))}break;case"update":for(let t=0,s=r.length;t<s;t++){const s=r[t];this.get(s)?this._ids.has(s)?(n.push(s),h.push(e.data[t]),a.push(e.oldData[t])):(this._ids.add(s),i.push(s)):this._ids.has(s)&&(this._ids.delete(s),o.push(s),l.push(e.oldData[t]))}break;case"remove":for(let t=0,s=r.length;t<s;t++){const s=r[t];this._ids.has(s)&&(this._ids.delete(s),o.push(s),l.push(e.oldData[t]))}}this.length+=i.length-o.length,i.length&&this._trigger("add",{items:i},s),n.length&&this._trigger("update",{items:n,oldData:a,data:h},s),o.length&&this._trigger("remove",{items:o,oldData:l},s)}},t.Queue=u,t.createNewDataPipeFrom=function(t){return new n(t)},Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=vis-data.min.js.map
