# coding: utf-8

"""
    TON Rocket Pay API

    This API based on @tonRocketBot (@ton_rocket_test_bot for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.<br><br>This page is fully interactive. Provide obtained API key to AUTHORIZE button on the right, and you can try all API methods by simply clicking buttons and filling forms here<br><br>API token must be specified in header of each request. Header name is <b>Rocket-Pay-Key</b>. Only exception is /version endpoint<br><br>If endpoint can send webhooks in response, it is provided on endpoint page on Callbacks bookmark. Now only /tg-invoices endpoint sends webhooks. You can turn them on in bot in app management page<br>In order to verify webhooks information integrity, we send you in headers parameter <b>rocket-pay-signature</b>, which is hex representation of HMAC-SHA-256 signature used to sign request body with a secret key that is SHA256 hash of your app token.<br><br>This specification fully complies with OpenAPI 3.0 standard, so if you want to see schemas of request bodies or responses, please click \"Schema\" inside endpoint. All mandatory fields marked with *, all types and limits also described inside schemas<br><br><h2>Change Log</h2><h3>version 1.3</h3>Added support for multi-invoices:<br>post /tg-invoices - added request parameter numPayments (default - 1), added response parameter totalActivations, activationsLeft<br>webhook /tg-invoices - added parameter payment (telegram user ID and number of items purchased for this payment)<br>get /tg-invoices - added response parameter totalActivations, activationsLeft<br>get /tg-invoices/{id} - added response parameter numPayments and payments (list, info about payments that were maid for this invoice)<br>  # noqa: E501

    OpenAPI spec version: 1.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WithdrawalDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'float',
        'address': 'float',
        'currency': 'str',
        'amount': 'float',
        'comment': 'str'
    }

    attribute_map = {
        'id': 'id',
        'address': 'address',
        'currency': 'currency',
        'amount': 'amount',
        'comment': 'comment'
    }

    def __init__(self, id=None, address=None, currency=None, amount=None, comment=None):  # noqa: E501
        """WithdrawalDto - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._address = None
        self._currency = None
        self._amount = None
        self._comment = None
        self.discriminator = None
        self.id = id
        self.address = address
        self.currency = currency
        self.amount = amount
        if comment is not None:
            self.comment = comment

    @property
    def id(self):
        """Gets the id of this WithdrawalDto.  # noqa: E501

        Withdrawal ID  # noqa: E501

        :return: The id of this WithdrawalDto.  # noqa: E501
        :rtype: float
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WithdrawalDto.

        Withdrawal ID  # noqa: E501

        :param id: The id of this WithdrawalDto.  # noqa: E501
        :type: float
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def address(self):
        """Gets the address of this WithdrawalDto.  # noqa: E501

        Withdrawal address  # noqa: E501

        :return: The address of this WithdrawalDto.  # noqa: E501
        :rtype: float
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this WithdrawalDto.

        Withdrawal address  # noqa: E501

        :param address: The address of this WithdrawalDto.  # noqa: E501
        :type: float
        """
        if address is None:
            raise ValueError("Invalid value for `address`, must not be `None`")  # noqa: E501

        self._address = address

    @property
    def currency(self):
        """Gets the currency of this WithdrawalDto.  # noqa: E501

        Currency code  # noqa: E501

        :return: The currency of this WithdrawalDto.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this WithdrawalDto.

        Currency code  # noqa: E501

        :param currency: The currency of this WithdrawalDto.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def amount(self):
        """Gets the amount of this WithdrawalDto.  # noqa: E501

        Withdrawal amount. 9 decimal places, others cut off  # noqa: E501

        :return: The amount of this WithdrawalDto.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this WithdrawalDto.

        Withdrawal amount. 9 decimal places, others cut off  # noqa: E501

        :param amount: The amount of this WithdrawalDto.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def comment(self):
        """Gets the comment of this WithdrawalDto.  # noqa: E501

        Withdrawal comment  # noqa: E501

        :return: The comment of this WithdrawalDto.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this WithdrawalDto.

        Withdrawal comment  # noqa: E501

        :param comment: The comment of this WithdrawalDto.  # noqa: E501
        :type: str
        """

        self._comment = comment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WithdrawalDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WithdrawalDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
