# coding: utf-8

"""
    TON Rocket Pay API

    This API based on @tonRocketBot (@ton_rocket_test_bot for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.<br><br>This page is fully interactive. Provide obtained API key to AUTHORIZE button on the right, and you can try all API methods by simply clicking buttons and filling forms here<br><br>API token must be specified in header of each request. Header name is <b>Rocket-Pay-Key</b>. Only exception is /version endpoint<br><br>If endpoint can send webhooks in response, it is provided on endpoint page on Callbacks bookmark. Now only /tg-invoices endpoint sends webhooks. You can turn them on in bot in app management page<br>In order to verify webhooks information integrity, we send you in headers parameter <b>rocket-pay-signature</b>, which is hex representation of HMAC-SHA-256 signature used to sign request body with a secret key that is SHA256 hash of your app token.<br><br>This specification fully complies with OpenAPI 3.0 standard, so if you want to see schemas of request bodies or responses, please click \"Schema\" inside endpoint. All mandatory fields marked with *, all types and limits also described inside schemas<br><br><h2>Change Log</h2><h3>version 1.3</h3>Added support for multi-invoices:<br>post /tg-invoices - added request parameter numPayments (default - 1), added response parameter totalActivations, activationsLeft<br>webhook /tg-invoices - added parameter payment (telegram user ID and number of items purchased for this payment)<br>get /tg-invoices - added response parameter totalActivations, activationsLeft<br>get /tg-invoices/{id} - added response parameter numPayments and payments (list, info about payments that were maid for this invoice)<br>  # noqa: E501

    OpenAPI spec version: 1.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserSubscription(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'subscription_id': 'float',
        'subscription_code': 'str',
        'user_id': 'float',
        'amount': 'float',
        'currency': 'str',
        'interval': 'str',
        'ref_fee': 'float',
        'is_ref_pay': 'bool',
        'total_amount': 'float',
        'payment_start': 'datetime',
        'payment_end': 'datetime',
        'auto_renewal': 'bool',
        'transactions': 'list[UserSubscriptionTransaction]'
    }

    attribute_map = {
        'subscription_id': 'subscriptionId',
        'subscription_code': 'subscriptionCode',
        'user_id': 'userId',
        'amount': 'amount',
        'currency': 'currency',
        'interval': 'interval',
        'ref_fee': 'refFee',
        'is_ref_pay': 'isRefPay',
        'total_amount': 'totalAmount',
        'payment_start': 'paymentStart',
        'payment_end': 'paymentEnd',
        'auto_renewal': 'autoRenewal',
        'transactions': 'transactions'
    }

    def __init__(self, subscription_id=None, subscription_code=None, user_id=None, amount=None, currency=None, interval=None, ref_fee=None, is_ref_pay=None, total_amount=None, payment_start=None, payment_end=None, auto_renewal=None, transactions=None):  # noqa: E501
        """UserSubscription - a model defined in Swagger"""  # noqa: E501
        self._subscription_id = None
        self._subscription_code = None
        self._user_id = None
        self._amount = None
        self._currency = None
        self._interval = None
        self._ref_fee = None
        self._is_ref_pay = None
        self._total_amount = None
        self._payment_start = None
        self._payment_end = None
        self._auto_renewal = None
        self._transactions = None
        self.discriminator = None
        self.subscription_id = subscription_id
        self.subscription_code = subscription_code
        self.user_id = user_id
        self.amount = amount
        self.currency = currency
        self.interval = interval
        self.ref_fee = ref_fee
        self.is_ref_pay = is_ref_pay
        self.total_amount = total_amount
        self.payment_start = payment_start
        self.payment_end = payment_end
        self.auto_renewal = auto_renewal
        self.transactions = transactions

    @property
    def subscription_id(self):
        """Gets the subscription_id of this UserSubscription.  # noqa: E501

        Subscription id for this payment  # noqa: E501

        :return: The subscription_id of this UserSubscription.  # noqa: E501
        :rtype: float
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """Sets the subscription_id of this UserSubscription.

        Subscription id for this payment  # noqa: E501

        :param subscription_id: The subscription_id of this UserSubscription.  # noqa: E501
        :type: float
        """
        if subscription_id is None:
            raise ValueError("Invalid value for `subscription_id`, must not be `None`")  # noqa: E501

        self._subscription_id = subscription_id

    @property
    def subscription_code(self):
        """Gets the subscription_code of this UserSubscription.  # noqa: E501

        Subscription code for this payment  # noqa: E501

        :return: The subscription_code of this UserSubscription.  # noqa: E501
        :rtype: str
        """
        return self._subscription_code

    @subscription_code.setter
    def subscription_code(self, subscription_code):
        """Sets the subscription_code of this UserSubscription.

        Subscription code for this payment  # noqa: E501

        :param subscription_code: The subscription_code of this UserSubscription.  # noqa: E501
        :type: str
        """
        if subscription_code is None:
            raise ValueError("Invalid value for `subscription_code`, must not be `None`")  # noqa: E501

        self._subscription_code = subscription_code

    @property
    def user_id(self):
        """Gets the user_id of this UserSubscription.  # noqa: E501

        TG user ID who pay subscription  # noqa: E501

        :return: The user_id of this UserSubscription.  # noqa: E501
        :rtype: float
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this UserSubscription.

        TG user ID who pay subscription  # noqa: E501

        :param user_id: The user_id of this UserSubscription.  # noqa: E501
        :type: float
        """
        if user_id is None:
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def amount(self):
        """Gets the amount of this UserSubscription.  # noqa: E501

        Sum all payments which added to app balance  # noqa: E501

        :return: The amount of this UserSubscription.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this UserSubscription.

        Sum all payments which added to app balance  # noqa: E501

        :param amount: The amount of this UserSubscription.  # noqa: E501
        :type: float
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def currency(self):
        """Gets the currency of this UserSubscription.  # noqa: E501

        Subscription currency  # noqa: E501

        :return: The currency of this UserSubscription.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this UserSubscription.

        Subscription currency  # noqa: E501

        :param currency: The currency of this UserSubscription.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def interval(self):
        """Gets the interval of this UserSubscription.  # noqa: E501

        Payed interval  # noqa: E501

        :return: The interval of this UserSubscription.  # noqa: E501
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this UserSubscription.

        Payed interval  # noqa: E501

        :param interval: The interval of this UserSubscription.  # noqa: E501
        :type: str
        """
        if interval is None:
            raise ValueError("Invalid value for `interval`, must not be `None`")  # noqa: E501

        self._interval = interval

    @property
    def ref_fee(self):
        """Gets the ref_fee of this UserSubscription.  # noqa: E501

        Sum all referral rewards  # noqa: E501

        :return: The ref_fee of this UserSubscription.  # noqa: E501
        :rtype: float
        """
        return self._ref_fee

    @ref_fee.setter
    def ref_fee(self, ref_fee):
        """Sets the ref_fee of this UserSubscription.

        Sum all referral rewards  # noqa: E501

        :param ref_fee: The ref_fee of this UserSubscription.  # noqa: E501
        :type: float
        """
        if ref_fee is None:
            raise ValueError("Invalid value for `ref_fee`, must not be `None`")  # noqa: E501

        self._ref_fee = ref_fee

    @property
    def is_ref_pay(self):
        """Gets the is_ref_pay of this UserSubscription.  # noqa: E501

        This payment by ref link  # noqa: E501

        :return: The is_ref_pay of this UserSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._is_ref_pay

    @is_ref_pay.setter
    def is_ref_pay(self, is_ref_pay):
        """Sets the is_ref_pay of this UserSubscription.

        This payment by ref link  # noqa: E501

        :param is_ref_pay: The is_ref_pay of this UserSubscription.  # noqa: E501
        :type: bool
        """
        if is_ref_pay is None:
            raise ValueError("Invalid value for `is_ref_pay`, must not be `None`")  # noqa: E501

        self._is_ref_pay = is_ref_pay

    @property
    def total_amount(self):
        """Gets the total_amount of this UserSubscription.  # noqa: E501

        Sum all payments which user pay  # noqa: E501

        :return: The total_amount of this UserSubscription.  # noqa: E501
        :rtype: float
        """
        return self._total_amount

    @total_amount.setter
    def total_amount(self, total_amount):
        """Sets the total_amount of this UserSubscription.

        Sum all payments which user pay  # noqa: E501

        :param total_amount: The total_amount of this UserSubscription.  # noqa: E501
        :type: float
        """
        if total_amount is None:
            raise ValueError("Invalid value for `total_amount`, must not be `None`")  # noqa: E501

        self._total_amount = total_amount

    @property
    def payment_start(self):
        """Gets the payment_start of this UserSubscription.  # noqa: E501

        When subscribe start  # noqa: E501

        :return: The payment_start of this UserSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._payment_start

    @payment_start.setter
    def payment_start(self, payment_start):
        """Sets the payment_start of this UserSubscription.

        When subscribe start  # noqa: E501

        :param payment_start: The payment_start of this UserSubscription.  # noqa: E501
        :type: datetime
        """
        if payment_start is None:
            raise ValueError("Invalid value for `payment_start`, must not be `None`")  # noqa: E501

        self._payment_start = payment_start

    @property
    def payment_end(self):
        """Gets the payment_end of this UserSubscription.  # noqa: E501

        When subscribe ends  # noqa: E501

        :return: The payment_end of this UserSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._payment_end

    @payment_end.setter
    def payment_end(self, payment_end):
        """Sets the payment_end of this UserSubscription.

        When subscribe ends  # noqa: E501

        :param payment_end: The payment_end of this UserSubscription.  # noqa: E501
        :type: datetime
        """
        if payment_end is None:
            raise ValueError("Invalid value for `payment_end`, must not be `None`")  # noqa: E501

        self._payment_end = payment_end

    @property
    def auto_renewal(self):
        """Gets the auto_renewal of this UserSubscription.  # noqa: E501

        Is auto renewal  # noqa: E501

        :return: The auto_renewal of this UserSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._auto_renewal

    @auto_renewal.setter
    def auto_renewal(self, auto_renewal):
        """Sets the auto_renewal of this UserSubscription.

        Is auto renewal  # noqa: E501

        :param auto_renewal: The auto_renewal of this UserSubscription.  # noqa: E501
        :type: bool
        """
        if auto_renewal is None:
            raise ValueError("Invalid value for `auto_renewal`, must not be `None`")  # noqa: E501

        self._auto_renewal = auto_renewal

    @property
    def transactions(self):
        """Gets the transactions of this UserSubscription.  # noqa: E501

        Payments for this user  # noqa: E501

        :return: The transactions of this UserSubscription.  # noqa: E501
        :rtype: list[UserSubscriptionTransaction]
        """
        return self._transactions

    @transactions.setter
    def transactions(self, transactions):
        """Sets the transactions of this UserSubscription.

        Payments for this user  # noqa: E501

        :param transactions: The transactions of this UserSubscription.  # noqa: E501
        :type: list[UserSubscriptionTransaction]
        """
        if transactions is None:
            raise ValueError("Invalid value for `transactions`, must not be `None`")  # noqa: E501

        self._transactions = transactions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserSubscription, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserSubscription):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
