# coding: utf-8

"""
    TON Rocket Pay API

    This API based on @tonRocketBot (@ton_rocket_test_bot for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.<br><br>This page is fully interactive. Provide obtained API key to AUTHORIZE button on the right, and you can try all API methods by simply clicking buttons and filling forms here<br><br>API token must be specified in header of each request. Header name is <b>Rocket-Pay-Key</b>. Only exception is /version endpoint<br><br>If endpoint can send webhooks in response, it is provided on endpoint page on Callbacks bookmark. Now only /tg-invoices endpoint sends webhooks. You can turn them on in bot in app management page<br>In order to verify webhooks information integrity, we send you in headers parameter <b>rocket-pay-signature</b>, which is hex representation of HMAC-SHA-256 signature used to sign request body with a secret key that is SHA256 hash of your app token.<br><br>This specification fully complies with OpenAPI 3.0 standard, so if you want to see schemas of request bodies or responses, please click \"Schema\" inside endpoint. All mandatory fields marked with *, all types and limits also described inside schemas<br><br><h2>Change Log</h2><h3>version 1.3</h3>Added support for multi-invoices:<br>post /tg-invoices - added request parameter numPayments (default - 1), added response parameter totalActivations, activationsLeft<br>webhook /tg-invoices - added parameter payment (telegram user ID and number of items purchased for this payment)<br>get /tg-invoices - added response parameter totalActivations, activationsLeft<br>get /tg-invoices/{id} - added response parameter numPayments and payments (list, info about payments that were maid for this invoice)<br>  # noqa: E501

    OpenAPI spec version: 1.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Subscription(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'float',
        'name': 'str',
        'description': 'str',
        'currency': 'str',
        'link': 'str',
        'interval': 'AllOfSubscriptionInterval',
        'referral_percent': 'float',
        'return_url': 'str',
        'tg_resource': 'AllOfSubscriptionTgResource'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'currency': 'currency',
        'link': 'link',
        'interval': 'interval',
        'referral_percent': 'referralPercent',
        'return_url': 'returnUrl',
        'tg_resource': 'tgResource'
    }

    def __init__(self, id=None, name=None, description=None, currency=None, link=None, interval=None, referral_percent=0, return_url=None, tg_resource=None):  # noqa: E501
        """Subscription - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._description = None
        self._currency = None
        self._link = None
        self._interval = None
        self._referral_percent = None
        self._return_url = None
        self._tg_resource = None
        self.discriminator = None
        self.id = id
        self.name = name
        if description is not None:
            self.description = description
        self.currency = currency
        self.link = link
        self.interval = interval
        self.referral_percent = referral_percent
        if return_url is not None:
            self.return_url = return_url
        if tg_resource is not None:
            self.tg_resource = tg_resource

    @property
    def id(self):
        """Gets the id of this Subscription.  # noqa: E501

        Subscription ID  # noqa: E501

        :return: The id of this Subscription.  # noqa: E501
        :rtype: float
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Subscription.

        Subscription ID  # noqa: E501

        :param id: The id of this Subscription.  # noqa: E501
        :type: float
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Subscription.  # noqa: E501

        Subscription name  # noqa: E501

        :return: The name of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Subscription.

        Subscription name  # noqa: E501

        :param name: The name of this Subscription.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Subscription.  # noqa: E501

        Subscription description  # noqa: E501

        :return: The description of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Subscription.

        Subscription description  # noqa: E501

        :param description: The description of this Subscription.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def currency(self):
        """Gets the currency of this Subscription.  # noqa: E501

        Subscription currency  # noqa: E501

        :return: The currency of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this Subscription.

        Subscription currency  # noqa: E501

        :param currency: The currency of this Subscription.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def link(self):
        """Gets the link of this Subscription.  # noqa: E501

        Link to subscription  # noqa: E501

        :return: The link of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._link

    @link.setter
    def link(self, link):
        """Sets the link of this Subscription.

        Link to subscription  # noqa: E501

        :param link: The link of this Subscription.  # noqa: E501
        :type: str
        """
        if link is None:
            raise ValueError("Invalid value for `link`, must not be `None`")  # noqa: E501

        self._link = link

    @property
    def interval(self):
        """Gets the interval of this Subscription.  # noqa: E501

        Subscription interval  # noqa: E501

        :return: The interval of this Subscription.  # noqa: E501
        :rtype: AllOfSubscriptionInterval
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this Subscription.

        Subscription interval  # noqa: E501

        :param interval: The interval of this Subscription.  # noqa: E501
        :type: AllOfSubscriptionInterval
        """
        if interval is None:
            raise ValueError("Invalid value for `interval`, must not be `None`")  # noqa: E501

        self._interval = interval

    @property
    def referral_percent(self):
        """Gets the referral_percent of this Subscription.  # noqa: E501

        Subscription referral percent  # noqa: E501

        :return: The referral_percent of this Subscription.  # noqa: E501
        :rtype: float
        """
        return self._referral_percent

    @referral_percent.setter
    def referral_percent(self, referral_percent):
        """Sets the referral_percent of this Subscription.

        Subscription referral percent  # noqa: E501

        :param referral_percent: The referral_percent of this Subscription.  # noqa: E501
        :type: float
        """
        if referral_percent is None:
            raise ValueError("Invalid value for `referral_percent`, must not be `None`")  # noqa: E501

        self._referral_percent = referral_percent

    @property
    def return_url(self):
        """Gets the return_url of this Subscription.  # noqa: E501

        Return link after payment  # noqa: E501

        :return: The return_url of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._return_url

    @return_url.setter
    def return_url(self, return_url):
        """Sets the return_url of this Subscription.

        Return link after payment  # noqa: E501

        :param return_url: The return_url of this Subscription.  # noqa: E501
        :type: str
        """

        self._return_url = return_url

    @property
    def tg_resource(self):
        """Gets the tg_resource of this Subscription.  # noqa: E501

        TG Resource for subscription  # noqa: E501

        :return: The tg_resource of this Subscription.  # noqa: E501
        :rtype: AllOfSubscriptionTgResource
        """
        return self._tg_resource

    @tg_resource.setter
    def tg_resource(self, tg_resource):
        """Sets the tg_resource of this Subscription.

        TG Resource for subscription  # noqa: E501

        :param tg_resource: The tg_resource of this Subscription.  # noqa: E501
        :type: AllOfSubscriptionTgResource
        """

        self._tg_resource = tg_resource

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Subscription, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Subscription):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
