# coding: utf-8

"""
    TON Rocket Pay API

    This API based on @tonRocketBot (@ton_rocket_test_bot for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.<br><br>This page is fully interactive. Provide obtained API key to AUTHORIZE button on the right, and you can try all API methods by simply clicking buttons and filling forms here<br><br>API token must be specified in header of each request. Header name is <b>Rocket-Pay-Key</b>. Only exception is /version endpoint<br><br>If endpoint can send webhooks in response, it is provided on endpoint page on Callbacks bookmark. Now only /tg-invoices endpoint sends webhooks. You can turn them on in bot in app management page<br>In order to verify webhooks information integrity, we send you in headers parameter <b>rocket-pay-signature</b>, which is hex representation of HMAC-SHA-256 signature used to sign request body with a secret key that is SHA256 hash of your app token.<br><br>This specification fully complies with OpenAPI 3.0 standard, so if you want to see schemas of request bodies or responses, please click \"Schema\" inside endpoint. All mandatory fields marked with *, all types and limits also described inside schemas<br><br><h2>Change Log</h2><h3>version 1.3</h3>Added support for multi-invoices:<br>post /tg-invoices - added request parameter numPayments (default - 1), added response parameter totalActivations, activationsLeft<br>webhook /tg-invoices - added parameter payment (telegram user ID and number of items purchased for this payment)<br>get /tg-invoices - added response parameter totalActivations, activationsLeft<br>get /tg-invoices/{id} - added response parameter numPayments and payments (list, info about payments that were maid for this invoice)<br>  # noqa: E501

    OpenAPI spec version: 1.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CoinDto(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'currency': 'str',
        'name': 'str',
        'min_transfer': 'float',
        'min_cheque': 'float',
        'min_invoice': 'float',
        'min_withdraw': 'float',
        'fee_withdraw': 'AllOfCoinDtoFeeWithdraw'
    }

    attribute_map = {
        'currency': 'currency',
        'name': 'name',
        'min_transfer': 'minTransfer',
        'min_cheque': 'minCheque',
        'min_invoice': 'minInvoice',
        'min_withdraw': 'minWithdraw',
        'fee_withdraw': 'feeWithdraw'
    }

    def __init__(self, currency=None, name=None, min_transfer=None, min_cheque=None, min_invoice=None, min_withdraw=None, fee_withdraw=None):  # noqa: E501
        """CoinDto - a model defined in Swagger"""  # noqa: E501
        self._currency = None
        self._name = None
        self._min_transfer = None
        self._min_cheque = None
        self._min_invoice = None
        self._min_withdraw = None
        self._fee_withdraw = None
        self.discriminator = None
        self.currency = currency
        self.name = name
        self.min_transfer = min_transfer
        self.min_cheque = min_cheque
        self.min_invoice = min_invoice
        self.min_withdraw = min_withdraw
        if fee_withdraw is not None:
            self.fee_withdraw = fee_withdraw

    @property
    def currency(self):
        """Gets the currency of this CoinDto.  # noqa: E501

        ID of currency, use in Rocket Pay Api  # noqa: E501

        :return: The currency of this CoinDto.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this CoinDto.

        ID of currency, use in Rocket Pay Api  # noqa: E501

        :param currency: The currency of this CoinDto.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def name(self):
        """Gets the name of this CoinDto.  # noqa: E501

        Name of currency  # noqa: E501

        :return: The name of this CoinDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CoinDto.

        Name of currency  # noqa: E501

        :param name: The name of this CoinDto.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def min_transfer(self):
        """Gets the min_transfer of this CoinDto.  # noqa: E501

        Minimal amount for transfer  # noqa: E501

        :return: The min_transfer of this CoinDto.  # noqa: E501
        :rtype: float
        """
        return self._min_transfer

    @min_transfer.setter
    def min_transfer(self, min_transfer):
        """Sets the min_transfer of this CoinDto.

        Minimal amount for transfer  # noqa: E501

        :param min_transfer: The min_transfer of this CoinDto.  # noqa: E501
        :type: float
        """
        if min_transfer is None:
            raise ValueError("Invalid value for `min_transfer`, must not be `None`")  # noqa: E501

        self._min_transfer = min_transfer

    @property
    def min_cheque(self):
        """Gets the min_cheque of this CoinDto.  # noqa: E501

        Minimal amount for cheque  # noqa: E501

        :return: The min_cheque of this CoinDto.  # noqa: E501
        :rtype: float
        """
        return self._min_cheque

    @min_cheque.setter
    def min_cheque(self, min_cheque):
        """Sets the min_cheque of this CoinDto.

        Minimal amount for cheque  # noqa: E501

        :param min_cheque: The min_cheque of this CoinDto.  # noqa: E501
        :type: float
        """
        if min_cheque is None:
            raise ValueError("Invalid value for `min_cheque`, must not be `None`")  # noqa: E501

        self._min_cheque = min_cheque

    @property
    def min_invoice(self):
        """Gets the min_invoice of this CoinDto.  # noqa: E501

        Minimal amount for invoice  # noqa: E501

        :return: The min_invoice of this CoinDto.  # noqa: E501
        :rtype: float
        """
        return self._min_invoice

    @min_invoice.setter
    def min_invoice(self, min_invoice):
        """Sets the min_invoice of this CoinDto.

        Minimal amount for invoice  # noqa: E501

        :param min_invoice: The min_invoice of this CoinDto.  # noqa: E501
        :type: float
        """
        if min_invoice is None:
            raise ValueError("Invalid value for `min_invoice`, must not be `None`")  # noqa: E501

        self._min_invoice = min_invoice

    @property
    def min_withdraw(self):
        """Gets the min_withdraw of this CoinDto.  # noqa: E501

        Minimal amount for withdraw  # noqa: E501

        :return: The min_withdraw of this CoinDto.  # noqa: E501
        :rtype: float
        """
        return self._min_withdraw

    @min_withdraw.setter
    def min_withdraw(self, min_withdraw):
        """Sets the min_withdraw of this CoinDto.

        Minimal amount for withdraw  # noqa: E501

        :param min_withdraw: The min_withdraw of this CoinDto.  # noqa: E501
        :type: float
        """
        if min_withdraw is None:
            raise ValueError("Invalid value for `min_withdraw`, must not be `None`")  # noqa: E501

        self._min_withdraw = min_withdraw

    @property
    def fee_withdraw(self):
        """Gets the fee_withdraw of this CoinDto.  # noqa: E501

        Fee for token withdraw in main currency  # noqa: E501

        :return: The fee_withdraw of this CoinDto.  # noqa: E501
        :rtype: AllOfCoinDtoFeeWithdraw
        """
        return self._fee_withdraw

    @fee_withdraw.setter
    def fee_withdraw(self, fee_withdraw):
        """Sets the fee_withdraw of this CoinDto.

        Fee for token withdraw in main currency  # noqa: E501

        :param fee_withdraw: The fee_withdraw of this CoinDto.  # noqa: E501
        :type: AllOfCoinDtoFeeWithdraw
        """

        self._fee_withdraw = fee_withdraw

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CoinDto, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CoinDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
