# coding: utf-8

"""
    TON Rocket Pay API

    This API based on @tonRocketBot (@ton_rocket_test_bot for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.<br><br>This page is fully interactive. Provide obtained API key to AUTHORIZE button on the right, and you can try all API methods by simply clicking buttons and filling forms here<br><br>API token must be specified in header of each request. Header name is <b>Rocket-Pay-Key</b>. Only exception is /version endpoint<br><br>If endpoint can send webhooks in response, it is provided on endpoint page on Callbacks bookmark. Now only /tg-invoices endpoint sends webhooks. You can turn them on in bot in app management page<br>In order to verify webhooks information integrity, we send you in headers parameter <b>rocket-pay-signature</b>, which is hex representation of HMAC-SHA-256 signature used to sign request body with a secret key that is SHA256 hash of your app token.<br><br>This specification fully complies with OpenAPI 3.0 standard, so if you want to see schemas of request bodies or responses, please click \"Schema\" inside endpoint. All mandatory fields marked with *, all types and limits also described inside schemas<br><br><h2>Change Log</h2><h3>version 1.3</h3>Added support for multi-invoices:<br>post /tg-invoices - added request parameter numPayments (default - 1), added response parameter totalActivations, activationsLeft<br>webhook /tg-invoices - added parameter payment (telegram user ID and number of items purchased for this payment)<br>get /tg-invoices - added response parameter totalActivations, activationsLeft<br>get /tg-invoices/{id} - added response parameter numPayments and payments (list, info about payments that were maid for this invoice)<br>  # noqa: E501

    OpenAPI spec version: 1.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rocketpay.api_client import ApiClient


class SubscriptionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def subscriptions_controller_check_subscription(self, body, subscription_id, **kwargs):  # noqa: E501
        """subscriptions_controller_check_subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_check_subscription(body, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CheckSubscriptionDto body: (required)
        :param str subscription_id: (required)
        :return: SimpleUserSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_check_subscription_with_http_info(body, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_check_subscription_with_http_info(body, subscription_id, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_check_subscription_with_http_info(self, body, subscription_id, **kwargs):  # noqa: E501
        """subscriptions_controller_check_subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_check_subscription_with_http_info(body, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CheckSubscriptionDto body: (required)
        :param str subscription_id: (required)
        :return: SimpleUserSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_check_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subscriptions_controller_check_subscription`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_check_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/check/{subscriptionId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleUserSubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_create_subscription(self, body, **kwargs):  # noqa: E501
        """Create subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_create_subscription(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSubscriptionDto body: (required)
        :return: SimpleSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_create_subscription_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_create_subscription_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_create_subscription_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_create_subscription_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSubscriptionDto body: (required)
        :return: SimpleSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_create_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subscriptions_controller_create_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleSubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_crete_subscription_interval(self, body, subscription_id, **kwargs):  # noqa: E501
        """Create subscription interval  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_crete_subscription_interval(body, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionIntervalDto body: (required)
        :param str subscription_id: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_crete_subscription_interval_with_http_info(body, subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_crete_subscription_interval_with_http_info(body, subscription_id, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_crete_subscription_interval_with_http_info(self, body, subscription_id, **kwargs):  # noqa: E501
        """Create subscription interval  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_crete_subscription_interval_with_http_info(body, subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubscriptionIntervalDto body: (required)
        :param str subscription_id: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_crete_subscription_interval" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subscriptions_controller_crete_subscription_interval`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_crete_subscription_interval`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscriptionId}/interval', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleSubscriptionIntervalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_delete_subscription(self, subscription_id, **kwargs):  # noqa: E501
        """Delete subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_delete_subscription(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :return: DeleteResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_delete_subscription_with_http_info(subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_delete_subscription_with_http_info(subscription_id, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_delete_subscription_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """Delete subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_delete_subscription_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :return: DeleteResponseDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_delete_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_delete_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscriptionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteResponseDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_delete_subscription_interval(self, subscription_id, interval_code, **kwargs):  # noqa: E501
        """Delete subscription interval  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_delete_subscription_interval(subscription_id, interval_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str interval_code: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_delete_subscription_interval_with_http_info(subscription_id, interval_code, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_delete_subscription_interval_with_http_info(subscription_id, interval_code, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_delete_subscription_interval_with_http_info(self, subscription_id, interval_code, **kwargs):  # noqa: E501
        """Delete subscription interval  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_delete_subscription_interval_with_http_info(subscription_id, interval_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str interval_code: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'interval_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_delete_subscription_interval" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_delete_subscription_interval`")  # noqa: E501
        # verify the required parameter 'interval_code' is set
        if ('interval_code' not in params or
                params['interval_code'] is None):
            raise ValueError("Missing the required parameter `interval_code` when calling `subscriptions_controller_delete_subscription_interval`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501
        if 'interval_code' in params:
            path_params['intervalCode'] = params['interval_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscriptionId}/interval/{intervalCode}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleSubscriptionIntervalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_edit_subscription_interval(self, body, subscription_id, interval_code, **kwargs):  # noqa: E501
        """Edit subscription interval  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_edit_subscription_interval(body, subscription_id, interval_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EditSubscriptionIntervalDto body: (required)
        :param str subscription_id: (required)
        :param str interval_code: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_edit_subscription_interval_with_http_info(body, subscription_id, interval_code, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_edit_subscription_interval_with_http_info(body, subscription_id, interval_code, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_edit_subscription_interval_with_http_info(self, body, subscription_id, interval_code, **kwargs):  # noqa: E501
        """Edit subscription interval  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_edit_subscription_interval_with_http_info(body, subscription_id, interval_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EditSubscriptionIntervalDto body: (required)
        :param str subscription_id: (required)
        :param str interval_code: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'subscription_id', 'interval_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_edit_subscription_interval" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `subscriptions_controller_edit_subscription_interval`")  # noqa: E501
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_edit_subscription_interval`")  # noqa: E501
        # verify the required parameter 'interval_code' is set
        if ('interval_code' not in params or
                params['interval_code'] is None):
            raise ValueError("Missing the required parameter `interval_code` when calling `subscriptions_controller_edit_subscription_interval`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501
        if 'interval_code' in params:
            path_params['intervalCode'] = params['interval_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscriptionId}/interval/{intervalCode}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleSubscriptionIntervalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_get_subscription(self, subscription_id, **kwargs):  # noqa: E501
        """Get subscription info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_get_subscription(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :return: SimpleSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_get_subscription_with_http_info(subscription_id, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_get_subscription_with_http_info(subscription_id, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_get_subscription_with_http_info(self, subscription_id, **kwargs):  # noqa: E501
        """Get subscription info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_get_subscription_with_http_info(subscription_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :return: SimpleSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_get_subscription" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_get_subscription`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscriptionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleSubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_get_subscription_interval(self, subscription_id, interval_code, **kwargs):  # noqa: E501
        """Get subscription interval info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_get_subscription_interval(subscription_id, interval_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str interval_code: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_get_subscription_interval_with_http_info(subscription_id, interval_code, **kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_get_subscription_interval_with_http_info(subscription_id, interval_code, **kwargs)  # noqa: E501
            return data

    def subscriptions_controller_get_subscription_interval_with_http_info(self, subscription_id, interval_code, **kwargs):  # noqa: E501
        """Get subscription interval info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_get_subscription_interval_with_http_info(subscription_id, interval_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subscription_id: (required)
        :param str interval_code: (required)
        :return: SimpleSubscriptionIntervalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription_id', 'interval_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_get_subscription_interval" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription_id' is set
        if ('subscription_id' not in params or
                params['subscription_id'] is None):
            raise ValueError("Missing the required parameter `subscription_id` when calling `subscriptions_controller_get_subscription_interval`")  # noqa: E501
        # verify the required parameter 'interval_code' is set
        if ('interval_code' not in params or
                params['interval_code'] is None):
            raise ValueError("Missing the required parameter `interval_code` when calling `subscriptions_controller_get_subscription_interval`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subscription_id' in params:
            path_params['subscriptionId'] = params['subscription_id']  # noqa: E501
        if 'interval_code' in params:
            path_params['intervalCode'] = params['interval_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions/{subscriptionId}/interval/{intervalCode}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SimpleSubscriptionIntervalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscriptions_controller_get_subscriptions(self, **kwargs):  # noqa: E501
        """Get list of subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_get_subscriptions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float limit:
        :param float offset:
        :return: PaginatedSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscriptions_controller_get_subscriptions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.subscriptions_controller_get_subscriptions_with_http_info(**kwargs)  # noqa: E501
            return data

    def subscriptions_controller_get_subscriptions_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscriptions_controller_get_subscriptions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float limit:
        :param float offset:
        :return: PaginatedSubscriptionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscriptions_controller_get_subscriptions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key']  # noqa: E501

        return self.api_client.call_api(
            '/subscriptions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedSubscriptionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
