# swagger-client
This API based on [@tonRocketBot](https://t.me/tonRocketBot) ([@ton_rocket_test_bot](https://t.me/ton_rocket_test_bot) for testnest) Payment System. In order to use it, you need to get API key from bot. Open it and go to Rocket Pay > Create App > API token.

API token must be specified in header of each request. Header name is **Rocket-Pay-Key**. Only exception is /version endpoint

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.3
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:

```python
import rocketpay 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import rocketpay
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import rocketpay
from rocketpay.rest import ApiException
from pprint import pprint

# Configure API key authorization: api-key
configuration = rocketpay.Configuration()
# Uncomment below to setup testnet
# configuration.is_testnet = True
configuration.api_key['Rocket-Pay-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Rocket-Pay-Key'] = 'Bearer'

# create an instance of the API class
api_instance = rocketpay.AppApi(rocketpay.ApiClient(configuration))

try:
    # Returns information about your application
    api_response = api_instance.apps_controller_get_app_info()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppApi->apps_controller_get_app_info: %s\n" % e)

# Configure API key authorization: api-key
configuration = rocketpay.Configuration()
configuration.api_key['Rocket-Pay-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Rocket-Pay-Key'] = 'Bearer'

# create an instance of the API class
api_instance = rocketpay.AppApi(rocketpay.ApiClient(configuration))
body = rocketpay.CreateTransferDto() # CreateTransferDto | 

try:
    # Make transfer of funds to another user
    api_response = api_instance.apps_controller_transfer(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppApi->apps_controller_transfer: %s\n" % e)

# Configure API key authorization: api-key
configuration = rocketpay.Configuration()
configuration.api_key['Rocket-Pay-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Rocket-Pay-Key'] = 'Bearer'

# create an instance of the API class
api_instance = rocketpay.AppApi(rocketpay.ApiClient(configuration))
body = rocketpay.CreateWithdrawalDto() # CreateWithdrawalDto | 

try:
    # Make withdrawal of funds to external wallet
    api_response = api_instance.apps_controller_withdrawal(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AppApi->apps_controller_withdrawal: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://pay.ton-rocket.com/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppApi* | [**apps_controller_get_app_info**](docs/AppApi.md#apps_controller_get_app_info) | **GET** /app/info | Returns information about your application
*AppApi* | [**apps_controller_transfer**](docs/AppApi.md#apps_controller_transfer) | **POST** /app/transfer | Make transfer of funds to another user
*AppApi* | [**apps_controller_withdrawal**](docs/AppApi.md#apps_controller_withdrawal) | **POST** /app/withdrawal | Make withdrawal of funds to external wallet
*CurrenciesApi* | [**currencies_controller_get_coins**](docs/CurrenciesApi.md#currencies_controller_get_coins) | **GET** /currencies/available | Returns available currencies
*CurrenciesApi* | [**currencies_controller_get_rates**](docs/CurrenciesApi.md#currencies_controller_get_rates) | **GET** /currencies/rate | Returns rates from simple simple-order
*MultiChequesApi* | [**cheques_controller_create_cheque**](docs/MultiChequesApi.md#cheques_controller_create_cheque) | **POST** /multi-cheques | Create multi-cheque
*MultiChequesApi* | [**cheques_controller_delete_cheque**](docs/MultiChequesApi.md#cheques_controller_delete_cheque) | **DELETE** /multi-cheques/{id} | Delete multi-cheque
*MultiChequesApi* | [**cheques_controller_edit_cheque**](docs/MultiChequesApi.md#cheques_controller_edit_cheque) | **PUT** /multi-cheques/{id} | Edit multi-cheque
*MultiChequesApi* | [**cheques_controller_get_cheque**](docs/MultiChequesApi.md#cheques_controller_get_cheque) | **GET** /multi-cheques/{id} | Get multi-cheque info
*MultiChequesApi* | [**cheques_controller_get_cheques**](docs/MultiChequesApi.md#cheques_controller_get_cheques) | **GET** /multi-cheques | Get list of multi-cheques
*SubscriptionsApi* | [**subscriptions_controller_check_subscription**](docs/SubscriptionsApi.md#subscriptions_controller_check_subscription) | **POST** /subscriptions/check/{subscriptionId} | 
*SubscriptionsApi* | [**subscriptions_controller_create_subscription**](docs/SubscriptionsApi.md#subscriptions_controller_create_subscription) | **POST** /subscriptions | Create subscription
*SubscriptionsApi* | [**subscriptions_controller_crete_subscription_interval**](docs/SubscriptionsApi.md#subscriptions_controller_crete_subscription_interval) | **POST** /subscriptions/{subscriptionId}/interval | Create subscription interval
*SubscriptionsApi* | [**subscriptions_controller_delete_subscription**](docs/SubscriptionsApi.md#subscriptions_controller_delete_subscription) | **DELETE** /subscriptions/{subscriptionId} | Delete subscription
*SubscriptionsApi* | [**subscriptions_controller_delete_subscription_interval**](docs/SubscriptionsApi.md#subscriptions_controller_delete_subscription_interval) | **DELETE** /subscriptions/{subscriptionId}/interval/{intervalCode} | Delete subscription interval
*SubscriptionsApi* | [**subscriptions_controller_edit_subscription_interval**](docs/SubscriptionsApi.md#subscriptions_controller_edit_subscription_interval) | **PUT** /subscriptions/{subscriptionId}/interval/{intervalCode} | Edit subscription interval
*SubscriptionsApi* | [**subscriptions_controller_get_subscription**](docs/SubscriptionsApi.md#subscriptions_controller_get_subscription) | **GET** /subscriptions/{subscriptionId} | Get subscription info
*SubscriptionsApi* | [**subscriptions_controller_get_subscription_interval**](docs/SubscriptionsApi.md#subscriptions_controller_get_subscription_interval) | **GET** /subscriptions/{subscriptionId}/interval/{intervalCode} | Get subscription interval info
*SubscriptionsApi* | [**subscriptions_controller_get_subscriptions**](docs/SubscriptionsApi.md#subscriptions_controller_get_subscriptions) | **GET** /subscriptions | Get list of subscription
*TgInvoicesApi* | [**invoices_controller_create_invoice**](docs/TgInvoicesApi.md#invoices_controller_create_invoice) | **POST** /tg-invoices | Create invoice
*TgInvoicesApi* | [**invoices_controller_delete_invoice**](docs/TgInvoicesApi.md#invoices_controller_delete_invoice) | **DELETE** /tg-invoices/{id} | Delete invoice
*TgInvoicesApi* | [**invoices_controller_get_invoice**](docs/TgInvoicesApi.md#invoices_controller_get_invoice) | **GET** /tg-invoices/{id} | Get invoice info
*TgInvoicesApi* | [**invoices_controller_get_invoices**](docs/TgInvoicesApi.md#invoices_controller_get_invoices) | **GET** /tg-invoices | Get list of invoices
*VersionApi* | [**version_controller_get_version**](docs/VersionApi.md#version_controller_get_version) | **GET** /version | Returns current version of API. You may use it as healthcheck

## Documentation For Models

 - [AllOfChequeDisabledLanguages](docs/AllOfChequeDisabledLanguages.md)
 - [AllOfCoinDtoFeeWithdraw](docs/AllOfCoinDtoFeeWithdraw.md)
 - [AllOfPayInvoiceDtoPayment](docs/AllOfPayInvoiceDtoPayment.md)
 - [AllOfShortChequeDtoDisabledLanguages](docs/AllOfShortChequeDtoDisabledLanguages.md)
 - [AllOfSubscriptionInterval](docs/AllOfSubscriptionInterval.md)
 - [AllOfSubscriptionTgResource](docs/AllOfSubscriptionTgResource.md)
 - [ApiBadRequestError](docs/ApiBadRequestError.md)
 - [ApiError](docs/ApiError.md)
 - [App](docs/App.md)
 - [AppBalance](docs/AppBalance.md)
 - [AppDto](docs/AppDto.md)
 - [AvailableCoins](docs/AvailableCoins.md)
 - [AvailableCoinsData](docs/AvailableCoinsData.md)
 - [CheckSubscriptionDto](docs/CheckSubscriptionDto.md)
 - [Cheque](docs/Cheque.md)
 - [CoinDto](docs/CoinDto.md)
 - [CreateChequeDto](docs/CreateChequeDto.md)
 - [CreateInvoiceDto](docs/CreateInvoiceDto.md)
 - [CreateSubscriptionDto](docs/CreateSubscriptionDto.md)
 - [CreateTransferDto](docs/CreateTransferDto.md)
 - [CreateWithdrawalDto](docs/CreateWithdrawalDto.md)
 - [DeleteResponseDto](docs/DeleteResponseDto.md)
 - [EditSubscriptionIntervalDto](docs/EditSubscriptionIntervalDto.md)
 - [FullInvoiceDto](docs/FullInvoiceDto.md)
 - [FullInvoiceResponseDto](docs/FullInvoiceResponseDto.md)
 - [Invoice](docs/Invoice.md)
 - [PaginatedInvoiceResponse](docs/PaginatedInvoiceResponse.md)
 - [PaginatedShortChequeDtoResponse](docs/PaginatedShortChequeDtoResponse.md)
 - [PaginatedSubscriptionResponse](docs/PaginatedSubscriptionResponse.md)
 - [PaginationDto](docs/PaginationDto.md)
 - [PayInvoiceDto](docs/PayInvoiceDto.md)
 - [PayInvoiceStatDto](docs/PayInvoiceStatDto.md)
 - [PropertyError](docs/PropertyError.md)
 - [Rates](docs/Rates.md)
 - [ResponseDto](docs/ResponseDto.md)
 - [Set](docs/Set.md)
 - [ShortChequeDto](docs/ShortChequeDto.md)
 - [SimpleChequeResponse](docs/SimpleChequeResponse.md)
 - [SimpleFullInvoiceDtoResponse](docs/SimpleFullInvoiceDtoResponse.md)
 - [SimpleInvoiceResponse](docs/SimpleInvoiceResponse.md)
 - [SimpleShortChequeDtoResponse](docs/SimpleShortChequeDtoResponse.md)
 - [SimpleSubscriptionIntervalResponse](docs/SimpleSubscriptionIntervalResponse.md)
 - [SimpleSubscriptionResponse](docs/SimpleSubscriptionResponse.md)
 - [SimpleTransferDtoResponse](docs/SimpleTransferDtoResponse.md)
 - [SimpleUserSubscriptionResponse](docs/SimpleUserSubscriptionResponse.md)
 - [SimpleWithdrawalDtoResponse](docs/SimpleWithdrawalDtoResponse.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionInterval](docs/SubscriptionInterval.md)
 - [SubscriptionIntervalDto](docs/SubscriptionIntervalDto.md)
 - [SubscriptionResource](docs/SubscriptionResource.md)
 - [TgResource](docs/TgResource.md)
 - [TransferDto](docs/TransferDto.md)
 - [UpdateChequeDto](docs/UpdateChequeDto.md)
 - [UserSubscription](docs/UserSubscription.md)
 - [UserSubscriptionTransaction](docs/UserSubscriptionTransaction.md)
 - [Version](docs/Version.md)
 - [WebhookDto](docs/WebhookDto.md)
 - [WithdrawFeeDto](docs/WithdrawFeeDto.md)
 - [WithdrawalDto](docs/WithdrawalDto.md)

## Documentation For Authorization


## api-key

- **Type**: API key
- **API key parameter name**: Rocket-Pay-Key
- **Location**: HTTP header


## Author
* Aleksandr Shepelev
* [Reinier Hernández](https://ragnarok22.dev)
