# Generated by Django 4.0.7 on 2022-08-18 15:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Broker',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fid', models.IntegerField(unique=True, verbose_name='Foreign ID')),
                ('name', models.CharField(max_length=63, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Clearing',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fid', models.IntegerField(unique=True, verbose_name='Foreign ID')),
                ('name', models.CharField(max_length=63, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fid', models.IntegerField(unique=True, verbose_name='Foreign ID')),
                ('name', models.CharField(max_length=63, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fid', models.IntegerField(unique=True, verbose_name='Foreign ID')),
                ('name', models.CharField(max_length=63, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TradingAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fid', models.IntegerField(unique=True, verbose_name='Foreign ID')),
                ('account', models.CharField(max_length=255, unique=True)),
                ('status', models.PositiveSmallIntegerField(choices=[(0, 'ENABLED'), (1, 'DISABLED'), (2, 'PAUSED')], default=0, verbose_name='Status')),
                ('type', models.CharField(blank=True, default=None, max_length=63, null=True)),
                ('service_status', models.BooleanField(default=False, verbose_name='Is service account')),
                ('service_start_date', models.DateField(blank=True, default=None, null=True, verbose_name='Service account start operation')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('broker', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='trading_accounts.broker')),
                ('clearing', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='trading_accounts.clearing')),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='trading_accounts.company')),
                ('created_by', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='created_by_user', to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='trading_accounts.source', verbose_name='Executions source')),
                ('user', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='owner_user', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Trading account',
                'verbose_name_plural': 'Trading accounts',
            },
        ),
    ]
